/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.report.plananalysis;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;

public class GrossdemandSourcePlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private static final String FILTER_OPERATION = "caculatelogs";
    public static final String QUERYCACHE = "queryCache";

    public void afterCreateNewData(EventObject e) {
        QFilter[] filters = new QFilter[]{new QFilter("runtype", "=", (Object)"A"), new QFilter("calculatestatus", "=", (Object)"A"), new QFilter("clearstatus", "!=", (Object)Character.valueOf('B')), new QFilter("operatmodekey", "!=", (Object)"mrp_simulation")};
        try (DataSet rows = ORM.create().queryDataSet(this.getPluginName(), "mrp_caculate_log", "id", filters, "startdate desc", 1);){
            if (rows.hasNext()) {
                this.getModel().setValue(FILTER_OPERATION, (Object)rows.next().getLong(0));
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit operationEdit = (BasedataEdit)this.getControl(FILTER_OPERATION);
        if (operationEdit != null) {
            operationEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        String requirementtypes;
        DynamicObjectCollection productmodels;
        DynamicObjectCollection materialparentcodes;
        FilterInfo filter = queryParam.getFilter();
        DynamicObject caculatelogs = filter.getDynamicObject(FILTER_OPERATION);
        if (StringUtils.isBlank((Object)caculatelogs)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u5212\u8fd0\u7b97\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GrossdemandSourcePlugin_0", (String)"mmc-mrp-report", (Object[])new Object[0]));
            return false;
        }
        HashMap<String, Object> queryCache = new HashMap<String, Object>();
        queryCache.put(FILTER_OPERATION, Long.parseLong(caculatelogs.getPkValue().toString()));
        DynamicObjectCollection materialcodes = filter.getDynamicObjectCollection("materialcodes");
        if (materialcodes != null && materialcodes.size() > 0) {
            HashSet<Long> id = new HashSet<Long>();
            for (Iterator materialcode : materialcodes) {
                id.add(materialcode.getLong("id"));
            }
            queryCache.put("materialcodes", id);
        }
        if ((materialparentcodes = filter.getDynamicObjectCollection("materialparentcodes")) != null && materialparentcodes.size() > 0) {
            HashSet<Long> id = new HashSet<Long>();
            for (Iterator materialparent : materialparentcodes) {
                id.add(materialparent.getLong("id"));
            }
            queryCache.put("materialparentcodes", id);
        }
        if ((productmodels = filter.getDynamicObjectCollection("productmodels")) != null && productmodels.size() > 0) {
            HashSet<Long> id = new HashSet<Long>();
            for (DynamicObject productmodel : productmodels) {
                id.add(productmodel.getLong("id"));
            }
            queryCache.put("productmodels", id);
        }
        if ((requirementtypes = filter.getString("requirementtypes")) != null && requirementtypes.length() > 0) {
            queryCache.put("requirementtypes", requirementtypes);
        }
        ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
        list.add(queryCache);
        String jsonStr = SerializationUtils.toJsonString(list);
        this.getPageCache().put(QUERYCACHE, jsonStr);
        return true;
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        Control con = (Control)evt.getSource();
        String key = con.getKey();
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)FILTER_OPERATION)) {
            listShowParameter.setShowApproved(false);
            listShowParameter.setUseOrgId(0L);
            listShowParameter.setIsolationOrg(false);
            listShowParameter.setShowUsed(false);
            ListFilterParameter listFilterParameter = listShowParameter.getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            QFilter qFilter2 = new QFilter("runtype", "=", (Object)"A");
            QFilter qFilter3 = new QFilter("calculatestatus", "=", (Object)"A");
            qFilters.add(new QFilter("clearstatus", "!=", (Object)Character.valueOf('B')));
            qFilters.add(new QFilter("operatmodekey", "!=", (Object)"mrp_simulation"));
            qFilters.add(qFilter2);
            qFilters.add(qFilter3);
        }
    }
}

