/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.report.plananalysis;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.DateType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ColumnStyle;
import kd.bos.entity.report.DecimalReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.extplugin.PluginProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mrp.business.custom.ext.IgetCustomFilter;
import kd.mmc.mrp.business.custom.ext.getCustomFilterImpl;
import kd.mmc.mrp.common.util.CharacterEncodingConvert;

public class SummaryListRptQuery
extends AbstractReportListDataPlugin {
    private final String algoKey = ((Object)((Object)this)).getClass().getName();
    private static final ThreadLocal<List<String>> threadLocal = new ThreadLocal();
    private static boolean calshowtotal = false;

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        getCustomFilterImpl defXXXSubPlugin = new getCustomFilterImpl();
        PluginProxy pluginProxy = PluginProxy.create((Object)defXXXSubPlugin, IgetCustomFilter.class, (String)"MRP_SUMMARYLIST_RPT_QFILTER", null);
        FilterInfo filterInfo = reportQueryParam.getFilter();
        StringBuilder selectStr = new StringBuilder();
        selectStr.append("caculatelog caculatelog,");
        selectStr.append("entryentity.material material,");
        selectStr.append("entryentity.materialattr materialattr,");
        selectStr.append("entryentity.bomversion bomversion,");
        selectStr.append("entryentity.ishandle ishandle,");
        selectStr.append("entryentity.supplyqty supplyqty,");
        selectStr.append("entryentity.demandqty demandqty,");
        selectStr.append("entryentity.exception exceptionnumber,");
        selectStr.append("entryentity.demandbilltype demandbilltype,");
        selectStr.append("entryentity.supplybillf7 supplybillf7,");
        selectStr.append("entryentity.supplybilltype supplybilltype,");
        selectStr.append("entryentity.requireoperator operator,");
        selectStr.append("entryentity.adjustsuggest adjustsuggest,");
        selectStr.append("entryentity.configuredcode configuredcode,");
        selectStr.append("entryentity.demandplanscope demandplanscope,");
        selectStr.append("entryentity.supplyplanscope supplyplanscope,");
        selectStr.append("entryentity.tracknumber tracknumber,");
        selectStr.append("entryentity.suptracknumber suptracknumber,");
        selectStr.append("entryentity.demandproject demandproject,");
        selectStr.append("entryentity.supplyproject supplyproject,");
        selectStr.append("entryentity.demandauxpty demandauxpty,");
        selectStr.append("entryentity.supplyauxpty supplyauxpty,");
        selectStr.append("entryentity.supplyorg supplyorg,");
        selectStr.append("entryentity.requireorg requireorg");
        QFilter qFilter = new QFilter("caculatelog", "=", (Object)filterInfo.getDynamicObject("calclogno").getString("number"));
        QFilter materialArrQF = null;
        materialArrQF = this.orQFilter(filterInfo, "fabricatedpart", materialArrQF, "entryentity.materialattr", "=", "10030");
        materialArrQF = this.orQFilter(filterInfo, "externalprocessinpart", materialArrQF, "entryentity.materialattr", "=", "10050");
        materialArrQF = this.orQFilter(filterInfo, "purchasedpart", materialArrQF, "entryentity.materialattr", "=", "10040");
        materialArrQF = this.orQFilter(filterInfo, "storagepart", materialArrQF, "entryentity.materialattr", "=", "10060");
        if (materialArrQF != null) {
            qFilter = qFilter.and(materialArrQF);
        }
        QFilter qFilterPlanScope = null;
        DynamicObject filter_planscope = filterInfo.getDynamicObject("filter_planscope");
        if (filter_planscope != null) {
            qFilterPlanScope = new QFilter("entryentity.demandplanscope", "=", filter_planscope.getPkValue());
            qFilterPlanScope.or(new QFilter("entryentity.supplyplanscope", "=", filter_planscope.getPkValue()));
        }
        DynamicObject filter_org = filterInfo.getDynamicObject("filter_org");
        QFilter qFilterOrg = null;
        if (filter_org != null) {
            qFilterOrg = new QFilter("entryentity.supplyorg", "=", filter_org.getPkValue());
            qFilterOrg.or(new QFilter("entryentity.requireorg", "=", filter_org.getPkValue()));
        }
        QFilter qFilterOperator = null;
        DynamicObjectCollection filter_operator = filterInfo.getDynamicObjectCollection("filter_operator");
        if (filter_operator != null && !filter_operator.isEmpty()) {
            ArrayList<Object> operators = new ArrayList<Object>(filter_operator.size());
            for (DynamicObject operator : filter_operator) {
                operators.add(operator.getPkValue());
            }
            qFilterOperator = new QFilter("entryentity.requireoperator", "in", operators);
        }
        List results = pluginProxy.callReplaceIfPresent(p -> p.getQFilter());
        for (QFilter qf : results) {
            qFilter.and(qf);
        }
        DataSet calDataSet = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)"mrp_calcdetail", (String)selectStr.toString(), (QFilter[])new QFilter[]{qFilter, qFilterPlanScope, qFilterOrg, qFilterOperator}, null);
        HashSet<Long> allMids = new HashSet<Long>(16);
        try (DataSet copyDataSet = calDataSet.copy();){
            for (Row row : copyDataSet) {
                allMids.add(row.getLong("material"));
            }
        }
        QFilter materialQF = null;
        materialQF = this.andQFilterByDynamicObject(filterInfo, "materialstandar", "id", materialQF, "standard.id", "=");
        materialQF = this.andQFilterByMultDynamicObject(filterInfo, "materialgroupbegins", "number", materialQF, "group.number", ">=");
        materialQF = this.andQFilterByDynamicObject(filterInfo, "materialgroupend", "number", materialQF, "group.number", "<=");
        materialQF = this.andQFilterByMultDynamicObject(filterInfo, "materialbegins", "number", materialQF, "material.number", ">=");
        if ((materialQF = this.andQFilterByDynamicObject(filterInfo, "materialend", "number", materialQF, "material.number", "<=")) != null) {
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)"bd_materialgroupdetail", (String)"id,material.id materialid", (QFilter[])new QFilter[]{materialQF}, null);
            Object object = null;
            try {
                HashSet<Long> set = new HashSet<Long>(16);
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    set.add(row.getLong("materialid"));
                }
                allMids.retainAll(set);
            }
            catch (Throwable set) {
                object = set;
                throw set;
            }
            finally {
                if (dataSet != null) {
                    if (object != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable set) {
                            ((Throwable)object).addSuppressed(set);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
        }
        materialQF = new QFilter("id", "in", allMids);
        String showkeycols = filterInfo.getString("showkeycols");
        calshowtotal = filterInfo.getBoolean("calshowtotal");
        DataSet materialDataSet = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)"bd_material", (String)"id material1,baseunit unit", (QFilter[])new QFilter[]{materialQF}, null);
        JoinDataSet joinData = calDataSet.join(materialDataSet, JoinType.INNER);
        joinData.select(new String[]{"caculatelog", "material", "materialattr", "unit", "bomversion", "ishandle", "supplyqty", "demandqty", "exceptionnumber", "demandbilltype", "supplybilltype", "operator", "requireorg", "supplybillf7", "supplyorg", "configuredcode", "tracknumber", "suptracknumber", "demandproject", "supplyproject", "demandplanscope", "supplyplanscope", "demandauxpty", "supplyauxpty"});
        calDataSet = joinData.on("material", "material1").finish();
        return this.mergeRowData(calDataSet, showkeycols);
    }

    private QFilter orQFilter(FilterInfo filterInfo, String propertyName, QFilter materialArrQF, String property, String qcp, Object value) {
        if (filterInfo.getBoolean(propertyName)) {
            if (materialArrQF == null) {
                materialArrQF = new QFilter(property, qcp, value);
            } else {
                materialArrQF.or(new QFilter(property, qcp, value));
            }
        }
        return materialArrQF;
    }

    private QFilter andQFilterByDynamicObject(FilterInfo filterInfo, String propertyName, String valueKey, QFilter materialQF, String property, String qcp) {
        DynamicObject data = filterInfo.getDynamicObject(propertyName);
        if (data != null) {
            if (materialQF == null) {
                materialQF = new QFilter(property, qcp, data.get(valueKey));
            } else {
                materialQF.and(new QFilter(property, qcp, data.get(valueKey)));
            }
        }
        return materialQF;
    }

    private QFilter andQFilterByMultDynamicObject(FilterInfo filterInfo, String propertyName, String valueKey, QFilter materialQF, String property, String qcp) {
        DynamicObjectCollection data = filterInfo.getDynamicObjectCollection(propertyName);
        if (data != null && !data.isEmpty()) {
            ArrayList<Object> value;
            if (data.size() > 1) {
                property = property.replaceAll(".number", ".id");
                qcp = "in";
                ArrayList<Object> ids = new ArrayList<Object>(data.size());
                for (DynamicObject d : data) {
                    ids.add(d.getPkValue());
                }
                value = ids;
            } else {
                value = ((DynamicObject)data.get(0)).get(valueKey);
            }
            if (materialQF == null) {
                materialQF = new QFilter(property, qcp, (Object)value);
            } else {
                materialQF.and(new QFilter(property, qcp, (Object)value));
            }
        }
        return materialQF;
    }

    private DataSet mergeRowData(DataSet dataSet, String showkeycols) {
        ArrayList<String> supplyList = new ArrayList<String>();
        ArrayList<String> requireList = new ArrayList<String>();
        ArrayList<String> thisGenList = new ArrayList<String>();
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>(16);
        this.mergeData(dataSet, supplyList, requireList, thisGenList, map, showkeycols);
        DataSet res = this.getReturnData(supplyList, requireList, thisGenList, map, showkeycols);
        List<String> allShowkeycols = this.getAllShowkeycols();
        ArrayList<String> orderBys = new ArrayList<String>();
        orderBys.add("material");
        orderBys.add("materialattr");
        orderBys.add("bomversion");
        orderBys.add("configuredcode");
        orderBys.add("tracknumber");
        orderBys.add("project");
        orderBys.add("planscope");
        orderBys.add("auxpty");
        orderBys.add("project");
        Iterator iterator = orderBys.iterator();
        while (iterator.hasNext()) {
            String orderBy = (String)iterator.next();
            if (!allShowkeycols.contains(orderBy) || showkeycols.contains(orderBy)) continue;
            iterator.remove();
        }
        return res.orderBy(orderBys.toArray(new String[0]));
    }

    private DataSet getReturnData(List<String> supplyList, List<String> requireList, List<String> thisGenList, Map<String, Map<String, Object>> map, String showkeycols) {
        String unicode;
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(new Field("light", (DataType)DateType.BooleanType, true));
        fields.add(new Field("ishandle", (DataType)DateType.BooleanType, true));
        fields.add(new Field("material", (DataType)DateType.StringType, true));
        fields.add(new Field("unit", (DataType)DateType.StringType, true));
        fields.add(new Field("materialattr", (DataType)DateType.IntegerType, true));
        fields.add(new Field("operator", (DataType)DateType.StringType, true));
        if (showkeycols.contains("bomversion")) {
            fields.add(new Field("bomversion", (DataType)DateType.LongType, true));
        }
        fields.add(new Field("useqty", (DataType)DateType.BigDecimalType, true));
        if (showkeycols.contains("planscope")) {
            fields.add(new Field("planscope", (DataType)DateType.LongType, true));
        }
        fields.add(new Field("org", (DataType)DateType.LongType, true));
        if (showkeycols.contains("configuredcode")) {
            fields.add(new Field("configuredcode", (DataType)DateType.LongType, true));
        }
        if (showkeycols.contains("tracknumber")) {
            fields.add(new Field("tracknumber", (DataType)DateType.LongType, true));
        }
        fields.add(new Field("project", (DataType)DateType.LongType, true));
        if (showkeycols.contains("auxpty")) {
            fields.add(new Field("auxpty", (DataType)DateType.LongType, true));
        }
        fields.add(new Field("group1", (DataType)DateType.IntegerType, true));
        fields.add(new Field("group2", (DataType)DateType.IntegerType, true));
        fields.add(new Field("group3", (DataType)DateType.IntegerType, true));
        fields.add(new Field("group4", (DataType)DateType.IntegerType, true));
        fields.add(new Field("group5", (DataType)DateType.IntegerType, true));
        fields.add(new Field("group6", (DataType)DateType.IntegerType, true));
        HashMap<String, String> unicode2Key = new HashMap<String, String>(supplyList.size() + requireList.size() + thisGenList.size());
        for (String key : supplyList) {
            unicode = CharacterEncodingConvert.chineseToUnicode((String)key);
            unicode2Key.put(unicode, key);
            fields.add(new Field(unicode, (DataType)DateType.BigDecimalType, true));
        }
        for (String key : requireList) {
            unicode = CharacterEncodingConvert.chineseToUnicode((String)key);
            unicode2Key.put(unicode, key);
            fields.add(new Field(unicode, (DataType)DateType.BigDecimalType, true));
        }
        for (String key : thisGenList) {
            unicode = CharacterEncodingConvert.chineseToUnicode((String)key);
            unicode2Key.put(unicode, key);
            fields.add(new Field(unicode, (DataType)DateType.BigDecimalType, true));
        }
        RowMeta metas = new RowMeta(fields.toArray(new Field[0]));
        Algo algo = Algo.create((String)this.algoKey);
        DataSetBuilder builder = algo.createDataSetBuilder(metas);
        for (Map.Entry<String, Map<String, Object>> entry : map.entrySet()) {
            Object[] values = new Object[fields.size()];
            Map<String, Object> m = entry.getValue();
            Field[] field = metas.getFields();
            for (int i = 0; i < field.length; ++i) {
                values[i] = m.get(unicode2Key.getOrDefault(field[i].getName(), field[i].getName()));
            }
            builder.append(values);
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeData(DataSet dataSet, List<String> supplyList, List<String> requireList, List<String> thisGenList, Map<String, Map<String, Object>> map, String showkeycols) {
        ArrayList<String> columnList = new ArrayList<String>(2);
        HashSet<String> supplySet = new HashSet<String>(16);
        HashSet<String> requireSet = new HashSet<String>(16);
        HashSet<String> thisGenSet = new HashSet<String>(16);
        String[] showkeycolStrs = showkeycols.split(",");
        try {
            while (dataSet.hasNext()) {
                Map<Object, Object> rowMap;
                Row row = dataSet.next();
                Long tracknumber = row.getLong("tracknumber");
                Long project = row.getLong("demandproject") == 0L ? row.getLong("supplyproject") : row.getLong("demandproject");
                Long planscope = row.getLong("demandplanscope") == 0L ? row.getLong("supplyplanscope") : row.getLong("demandplanscope");
                Long org = row.getLong("requireorg") == 0L ? row.getLong("supplyorg") : row.getLong("requireorg");
                Long auxpty = row.getLong("demandauxpty") == 0L ? row.getLong("supplyauxpty") : row.getLong("demandauxpty");
                StringBuilder sb = new StringBuilder();
                for (String showkeycolStr : showkeycolStrs) {
                    if (StringUtils.isBlank((CharSequence)showkeycolStr)) continue;
                    if ("tracknumber".equals(showkeycolStr)) {
                        sb.append(tracknumber);
                        continue;
                    }
                    if ("org".equals(showkeycolStr)) {
                        sb.append(org);
                        continue;
                    }
                    if ("planscope".equals(showkeycolStr)) {
                        sb.append(planscope);
                        continue;
                    }
                    if ("auxpty".equals(showkeycolStr)) {
                        sb.append(auxpty);
                        continue;
                    }
                    if ("project".equals(showkeycolStr)) {
                        sb.append(project);
                        continue;
                    }
                    sb.append(row.get(showkeycolStr));
                }
                String key = sb.toString();
                BigDecimal supplyQty = row.get("supplyqty") == null ? BigDecimal.ZERO : row.getBigDecimal("supplyqty");
                BigDecimal requireQty = row.get("demandqty") == null ? BigDecimal.ZERO : row.getBigDecimal("demandqty");
                BigDecimal qty = BigDecimal.ZERO;
                qty = requireQty.compareTo(supplyQty) > 0 || requireQty.compareTo(BigDecimal.ZERO) <= 0 ? supplyQty : requireQty;
                if (BigDecimal.ZERO.compareTo(qty) == 0 && row.get("exceptionnumber") != null && !"".equals(row.getString("exceptionnumber").trim())) continue;
                requireQty = BigDecimal.ZERO.subtract(requireQty);
                String demandbilltype = row.getString("demandbilltype").trim();
                if (this.isInvLevelEmptyRequire(demandbilltype)) {
                    demandbilltype = "";
                }
                String requireKey = this.getRequirePutKey(demandbilltype);
                String supplybilltype = row.getString("supplybilltype").trim();
                String supplybillf7 = row.getString("supplybillf7");
                String supplyKey = this.getSupplyPutKey(supplybilltype);
                boolean isThisGen = this.isNewPlanOrderSupply(supplybilltype, supplybillf7);
                String thisGenKey = this.getThisGenPutKey(supplybilltype);
                boolean supplyTypeIsNull = StringUtils.isBlank((CharSequence)supplybilltype) || isThisGen;
                boolean requireTypeIsNull = StringUtils.isBlank((CharSequence)demandbilltype);
                if (!supplyTypeIsNull) {
                    supplySet.add(supplyKey);
                }
                if (!requireTypeIsNull) {
                    requireSet.add(requireKey);
                }
                if (isThisGen) {
                    thisGenSet.add(thisGenKey);
                }
                if (map.get(key) == null) {
                    rowMap = new HashMap(16);
                    rowMap.put("ishandle", row.get("ishandle"));
                    rowMap.put("material", row.get("material"));
                    rowMap.put("unit", row.get("unit"));
                    rowMap.put("materialattr", row.get("materialattr"));
                    rowMap.put("operator", row.get("operator"));
                    rowMap.put("bomversion", row.get("bomversion"));
                    rowMap.put("planscope", planscope);
                    rowMap.put("org", org);
                    rowMap.put("tracknumber", tracknumber);
                    rowMap.put("project", project);
                    rowMap.put("auxpty", auxpty);
                    rowMap.put("configuredcode", row.get("configuredcode"));
                    rowMap.put("sumrequire", BigDecimal.ZERO);
                    rowMap.put("sumsupply", BigDecimal.ZERO);
                    rowMap.put("sumgen", BigDecimal.ZERO);
                    rowMap.put("useqty", BigDecimal.ZERO);
                    if (!requireTypeIsNull) {
                        rowMap.put(requireKey, requireQty);
                        rowMap.put("sumrequire", requireQty);
                    } else {
                        rowMap.put("", BigDecimal.ZERO);
                        rowMap.put("sumrequire", BigDecimal.ZERO);
                    }
                    if (!supplyTypeIsNull) {
                        rowMap.put(supplyKey, qty);
                        rowMap.put("sumsupply", qty);
                    } else {
                        rowMap.put("", BigDecimal.ZERO);
                        rowMap.put("sumsupply", BigDecimal.ZERO);
                    }
                    if (isThisGen) {
                        rowMap.put(thisGenKey, qty);
                        rowMap.put("sumgen", qty);
                    } else {
                        rowMap.put("", BigDecimal.ZERO);
                        rowMap.put("sumgen", BigDecimal.ZERO);
                    }
                    rowMap.put("useqty", ((BigDecimal)rowMap.get("sumsupply")).add((BigDecimal)rowMap.get("sumrequire")).add((BigDecimal)rowMap.get("sumgen")));
                    map.put(key, rowMap);
                    continue;
                }
                rowMap = map.get(key);
                if (!requireTypeIsNull) {
                    rowMap.put(requireKey, rowMap.get(requireKey) == null ? requireQty : requireQty.add((BigDecimal)rowMap.get(requireKey)));
                    rowMap.put("sumrequire", ((BigDecimal)rowMap.get("sumrequire")).add(requireQty));
                }
                if (!supplyTypeIsNull) {
                    rowMap.put(supplyKey, rowMap.get(supplyKey) == null ? qty : qty.add((BigDecimal)rowMap.get(supplyKey)));
                    rowMap.put("sumsupply", ((BigDecimal)rowMap.get("sumsupply")).add(qty));
                }
                if (isThisGen) {
                    rowMap.put(thisGenKey, rowMap.get(thisGenKey) == null ? qty : qty.add((BigDecimal)rowMap.get(thisGenKey)));
                    rowMap.put("sumgen", ((BigDecimal)rowMap.get("sumgen")).add(qty));
                }
                rowMap.put("useqty", ((BigDecimal)rowMap.get("sumsupply")).add((BigDecimal)rowMap.get("sumrequire")).add((BigDecimal)rowMap.get("sumgen")));
            }
            if (!supplySet.isEmpty()) {
                supplyList.addAll(supplySet);
                supplyList.add("sumsupply");
            }
            if (!requireSet.isEmpty()) {
                requireList.addAll(requireSet);
                requireList.add("sumrequire");
            }
            if (!thisGenSet.isEmpty()) {
                thisGenList.addAll(thisGenSet);
                thisGenList.add("sumgen");
            }
            columnList.add(supplyList.toString());
            columnList.add(requireList.toString());
            columnList.add(thisGenList.toString());
            columnList.add(showkeycols);
            threadLocal.set(columnList);
        }
        finally {
            dataSet.close();
        }
    }

    private boolean isNewPlanOrderSupply(String supplybilltype, String supplybillf7) {
        boolean flag = StringUtils.equals((CharSequence)supplybillf7, (CharSequence)"mrp_planorder") || StringUtils.equals((CharSequence)supplybillf7, (CharSequence)"mrp_collaborativeorder");
        return flag && (StringUtils.startsWith((CharSequence)supplybilltype, (CharSequence)ResManager.loadKDString((String)"\u65b0\u5efa", (String)"SummaryListRptQuery_0", (String)"mmc-mrp-report", (Object[])new Object[0])) || StringUtils.startsWith((CharSequence)supplybilltype, (CharSequence)ResManager.loadKDString((String)"\u65b0\u521b\u5efa", (String)"SummaryListRptQuery_1", (String)"mmc-mrp-report", (Object[])new Object[0])));
    }

    private boolean isInvLevelEmptyRequire(String dType) {
        return dType.equals(ResManager.loadKDString((String)"\u5e93\u5b58\u6c34\u4f4d", (String)"SummaryListRptQuery_3", (String)"mmc-mrp-report", (Object[])new Object[0]));
    }

    private String getRequirePutKey(String type) {
        return String.format("(%s)", type);
    }

    private String getSupplyPutKey(String type) {
        return String.format("[%s]", type);
    }

    private String getThisGenPutKey(String type) {
        return String.format("{%s}", type);
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List cols = super.getColumns(columns);
        List<String> list = threadLocal.get();
        if (list != null && list.size() > 2) {
            String supply = list.get(0);
            String[] supplyArr = supply.substring(1, supply.length() - 1).split(",");
            String require = list.get(1);
            String[] requireArr = require.substring(1, require.length() - 1).split(",");
            String thisGen = list.get(2);
            String[] thisGenArr = thisGen.substring(1, thisGen.length() - 1).split(",");
            String showkeycols = list.get(3);
            Iterator iterator = cols.iterator();
            List<String> allShowkeycols = this.getAllShowkeycols();
            while (iterator.hasNext()) {
                String key;
                ReportColumnGroup g;
                AbstractReportColumn next = (AbstractReportColumn)iterator.next();
                if (next instanceof DecimalReportColumn) {
                    DecimalReportColumn qty = (DecimalReportColumn)next;
                    if (calshowtotal) {
                        this.setQtyFieldSummary(qty);
                    }
                }
                if (next instanceof ReportColumnGroup) {
                    g = (ReportColumnGroup)next;
                    switch (key = g.getFieldKey()) {
                        case "require": {
                            this.addColumn(g, requireArr, "sumrequire");
                            break;
                        }
                        case "supply": {
                            this.addColumn(g, supplyArr, "sumsupply");
                            break;
                        }
                        case "thisgen": {
                            this.addColumn(g, thisGenArr, "sumgen");
                            break;
                        }
                    }
                    continue;
                }
                if (!(next instanceof ReportColumn) || !allShowkeycols.contains(key = (g = (ReportColumn)next).getFieldKey()) || showkeycols.contains(key)) continue;
                iterator.remove();
            }
        }
        threadLocal.remove();
        return cols;
    }

    private List<String> getAllShowkeycols() {
        ArrayList<String> allShowkeycols = new ArrayList<String>();
        allShowkeycols.add("material");
        allShowkeycols.add("materialattr");
        allShowkeycols.add("bomversion");
        allShowkeycols.add("configuredcode");
        allShowkeycols.add("tracknumber");
        allShowkeycols.add("planscope");
        allShowkeycols.add("org");
        allShowkeycols.add("auxpty");
        allShowkeycols.add("project");
        return allShowkeycols;
    }

    private void addColumn(ReportColumnGroup g, String[] arr, String sumKey) {
        for (String pk : arr) {
            if ("".equals(pk.trim())) continue;
            DecimalReportColumn qty = new DecimalReportColumn();
            if (sumKey.equals(pk.trim())) {
                qty.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5408\u8ba1", (String)"SummaryListRptQuery_2", (String)"mmc-mrp-report", (Object[])new Object[0])));
                qty.setFieldKey(sumKey);
            } else {
                qty.setCaption(new LocaleString(pk.trim().substring(1, pk.trim().length() - 1)));
                qty.setFieldKey(CharacterEncodingConvert.chineseToUnicode((String)pk.trim()));
            }
            qty.setWidth(new LocaleString("100px"));
            qty.setFieldType("qty");
            qty.setMeasureUnitField("unit");
            qty.setZeroShow(true);
            if (calshowtotal) {
                this.setQtyFieldSummary(qty);
            }
            ColumnStyle c = new ColumnStyle();
            c.setTextAlign("right");
            qty.setStyle(c);
            g.getChildren().add(qty);
        }
    }

    protected void setQtyFieldSummary(DecimalReportColumn qty) {
        qty.setSummary(1);
    }
}

