/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.report.rpt;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mrp.rpt.util.RptUtils;

public class ProductionForecastQueryPlugin
extends AbstractReportListDataPlugin {
    public static final Log logger = LogFactory.getLog(ProductionForecastQueryPlugin.class);
    protected Map<String, String> COLUMNMAP;
    protected static String[] FIXFIELDS = new String[]{"entryid", "planno", "offeringno", "offeringname", "supplyorg", "supplyorgname", "demandmodel", "operatorno", "operator", "acqstatus", "acquser", "acqtime", "modifier", "modifytime", "remark", "qty"};
    protected static DataType[] FIXFIELDSTYPE = new DataType[]{DataType.LongType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.DateType, DataType.StringType, DataType.DateType, DataType.StringType, DataType.BigDecimalType};

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        DynamicObject head_operator;
        String head_demandmodel;
        DynamicObject head_supplyorg;
        String head_acqstatus;
        boolean isdemandmaterial;
        FilterInfo filterInfo = reportQueryParam.getFilter();
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(8);
        DynamicObject head_plan = filterInfo.getDynamicObject("head_plan");
        if (head_plan == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8ba1\u5212\u8fd0\u7b97\u53f7\u3002", (String)"ProductionForecastQueryPlugin_0", (String)"mmc-mrp-report", (Object[])new Object[0]));
        }
        qFilterList.add(new QFilter("billno", "=", (Object)head_plan.getString("number")));
        DynamicObject material = filterInfo.getDynamicObject("head_offering");
        if (material != null) {
            qFilterList.add(new QFilter("entryentity.offeringid", "=", (Object)material.getLong("id")));
        }
        if (isdemandmaterial = filterInfo.getBoolean("head_isdemandmaterial")) {
            qFilterList.add(new QFilter("entryentity.isdemandmaterial", "=", (Object)isdemandmaterial));
        }
        if (StringUtils.isNotBlank((CharSequence)(head_acqstatus = filterInfo.getString("head_acqstatus")))) {
            qFilterList.add(new QFilter("entryentity.acqstatus", "=", (Object)head_acqstatus));
        }
        if ((head_supplyorg = filterInfo.getDynamicObject("head_supplyorg")) != null) {
            qFilterList.add(new QFilter("entryentity.supplyorg", "=", (Object)head_supplyorg.getLong("id")));
        }
        if (StringUtils.isNotBlank((CharSequence)(head_demandmodel = filterInfo.getString("head_demandmodel")))) {
            qFilterList.add(new QFilter("entryentity.demandmodel", "=", (Object)head_demandmodel));
        }
        if ((head_operator = filterInfo.getDynamicObject("head_operator")) != null) {
            qFilterList.add(new QFilter("entryentity.operator", "=", (Object)head_operator.getLong("id")));
        }
        this.COLUMNMAP = new LinkedHashMap<String, String>(8);
        QFilter[] qFilters = qFilterList.toArray(new QFilter[0]);
        String selectStr = "id,billno planno,entryentity.id entryid,entryentity.offeringno offeringno,entryentity.offeringname offeringname,entryentity.supplyorg.number supplyorg,entryentity.supplyorg.name supplyorgname,entryentity.demandmodel demandmodel,entryentity.operator.number operatorno,entryentity.operator.name operator,entryentity.acqstatus acqstatus,entryentity.acquser.name acquser,entryentity.acqtime acqtime,entryentity.modifierfield.name modifier,entryentity.entry_modifytime modifytime,entryentity.remark remark,entryentity.qty qty,entryentity.subentryentity.fieldkey,entryentity.subentryentity.fieldcaption,entryentity.subentryentity.fieldvalue,entryentity.subentryentity.sequence";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mrp_rpt_production_datas", (String)selectStr, (QFilter[])qFilters, (String)"entryentity.id,entryentity.subentryentity.sequence,entryentity.subentryentity.fieldcaption");
        DataSet resultDataSet = RptUtils.getNewDataSet((String)((Object)((Object)this)).getClass().getName(), (DataSet)dataSet, (String[])FIXFIELDS, (DataType[])FIXFIELDSTYPE, this.COLUMNMAP);
        String sort = reportQueryParam.getSortInfo();
        resultDataSet = StringUtils.isNotEmpty((CharSequence)sort) ? resultDataSet.orderBy(new String[]{sort}) : resultDataSet.orderBy(new String[]{"offeringno"});
        try {
            List<String> filters = this.getFilters(filterInfo);
            for (String filter : filters) {
                resultDataSet = resultDataSet.filter(filter);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u8868\u67e5\u8be2\u51fa\u9519\uff0c\u8bf7\u67e5\u770b\u7cfb\u7edf\u65e5\u5fd7\u3002", (String)"ProductionForecastQueryPlugin_1", (String)"mmc-mrp-report", (Object[])new Object[0]));
        }
        return resultDataSet.filter("offeringno != ''");
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List cols = super.getColumns(columns);
        for (AbstractReportColumn abstractReportColumn : cols) {
            ReportColumn col = (ReportColumn)abstractReportColumn;
            String fieldKey = col.getFieldKey();
            if (StringUtils.equals((CharSequence)"offeringno", (CharSequence)fieldKey) || StringUtils.equals((CharSequence)"offeringname", (CharSequence)fieldKey) || StringUtils.equals((CharSequence)"supplyorg", (CharSequence)fieldKey) || StringUtils.equals((CharSequence)"supplyorgname", (CharSequence)fieldKey) || StringUtils.equals((CharSequence)"demandmodel", (CharSequence)fieldKey) || StringUtils.equals((CharSequence)"operator", (CharSequence)fieldKey) || StringUtils.equals((CharSequence)"planno", (CharSequence)fieldKey) || StringUtils.equals((CharSequence)"operatorno", (CharSequence)fieldKey)) {
                col.setFreeze(true);
            }
            if (!StringUtils.equals((CharSequence)"qty", (CharSequence)fieldKey)) continue;
            col.setScale(4);
        }
        for (Map.Entry entry : this.COLUMNMAP.entrySet()) {
            String key = (String)entry.getKey();
            String caption = (String)entry.getValue();
            ReportColumn newColmun = new ReportColumn();
            newColmun.setFieldKey(key);
            newColmun.setCaption(new LocaleString(caption));
            newColmun.setFieldType("decimal");
            newColmun.setScale(4);
            newColmun.setZeroShow(true);
            cols.add(newColmun);
        }
        return cols;
    }

    private List<String> getFilters(FilterInfo filterInfo) throws ParseException {
        ArrayList<String> filters = new ArrayList<String>(8);
        List filterItems = filterInfo.getTableHeadFilterItems();
        for (FilterItemInfo item : filterItems) {
            String propName = item.getPropName();
            if (StringUtils.equals((CharSequence)"acqtime", (CharSequence)propName) || StringUtils.equals((CharSequence)"modifytime", (CharSequence)propName)) {
                filters.addAll(RptUtils.transformTimeFilters((FilterItemInfo)item));
                continue;
            }
            if (StringUtils.equals((CharSequence)"qty", (CharSequence)propName)) {
                filters.add(propName + " " + item.getCompareType() + " " + item.getValue());
                continue;
            }
            filters.addAll(RptUtils.transformTextFilters((FilterItemInfo)item));
        }
        return filters;
    }
}

