/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.report.rpt.impt;

import com.google.common.collect.Maps;
import java.io.InputStream;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;

public class ForecastImportPlugin
extends AbstractFormPlugin
implements UploadListener,
ProgresssListener {
    private static final Log logger = LogFactory.getLog(ForecastImportPlugin.class);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok", "btndetail", "btndownload"});
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl("attachmentpanelap");
        attachmentPanel.addUploadListener((UploadListener)this);
        ProgressBar progressBar = (ProgressBar)this.getControl("progressbarap");
        progressBar.addProgressListener((ProgresssListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"btndetail", "progressbarap"});
    }

    public void onProgress(ProgressEvent progressEvent) {
        int progress = this.getProgress();
        ProgressBar progressBar = (ProgressBar)progressEvent.getSource();
        if (progress == 0) {
            this.setProgress(1);
            this.setTip(ResManager.loadKDString((String)"\u6b63\u5728\u89e3\u6790...", (String)"ForecastImportPlugin_0", (String)"mmc-mrp-report", (Object[])new Object[0]));
            ThreadPools.executeOnce((String)"ForecastImportPlugin", this::execute);
            return;
        }
        boolean completed = this.isCompleted();
        boolean error = this.isError();
        String errorMsgs = this.getPageCache().get("errorMsgs");
        if (error) {
            progressBar.stop();
            String errorMsg = this.getErrorMsg();
            this.getView().hideLoading();
            if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
                this.getView().showErrorNotification(errorMsg);
                if (errorMsg.contains(ResManager.loadKDString((String)"\u8be6\u60c5", (String)"ForecastImportPlugin_1", (String)"mmc-mrp-report", (Object[])new Object[0]))) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"btndetail"});
                }
            }
            if (StringUtils.isNotBlank((CharSequence)errorMsgs)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u5bfc\u5165\u5f02\u5e38", (String)"ForecastImportPlugin_2", (String)"mmc-mrp-report", (Object[])new Object[0]), errorMsgs, null);
            }
        } else if (completed) {
            progressBar.stop();
            this.getView().hideLoading();
            String msg = this.getPageCache().get("completeMsg");
            this.getView().showMessage(msg, MessageTypes.Default, new ConfirmCallBackListener("completed"));
        } else {
            String tip = this.getTip();
            this.getView().showProgressLoading(new LocaleString(tip), progress);
        }
    }

    private void execute() {
        try {
            this.importExcel();
        }
        catch (Exception e) {
            logger.error("\u5f15\u4eba\u6587\u4ef6\u9519\u8bef\uff1a", (Throwable)e);
            this.setError(e.getMessage());
        }
    }

    public void importExcel() throws Exception {
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control con = (Control)evt.getSource();
        String key = con.getKey();
        if ("btnok".equals(key)) {
            this.startImportExcel();
        } else if ("btndetail".equals(key)) {
            this.downloadErrorFile();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String completed = this.getPageCache().get("complete");
        if (completed != null) {
            this.getView().returnDataToParent((Object)completed);
        }
    }

    public void startImportExcel() {
        List attachmentDataList = ((AttachmentPanel)this.getControl("attachmentpanelap")).getAttachmentData();
        if (attachmentDataList.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20Excle\u6587\u4ef6\u3002", (String)"ForecastImportPlugin_3", (String)"mmc-mrp-report", (Object[])new Object[0]));
            return;
        }
        this.reset();
        this.getView().showProgressLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u89e3\u6790...", (String)"ForecastImportPlugin_0", (String)"mmc-mrp-report", (Object[])new Object[0])), 0);
        ProgressBar progressBar = (ProgressBar)this.getControl("progressbarap");
        progressBar.start();
    }

    private void downloadErrorFile() {
        String errorFileUrl = this.getPageCache().get("errorFileUrl");
        if (StringUtils.isEmpty((CharSequence)errorFileUrl)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5f02\u5e38\u8be6\u60c5\u3002", (String)"ForecastImportPlugin_4", (String)"mmc-mrp-report", (Object[])new Object[0]));
            return;
        }
        this.getView().download(errorFileUrl);
    }

    public InputStream getInputStream() {
        List attachmentDataList = ((AttachmentPanel)this.getControl("attachmentpanelap")).getAttachmentData();
        if (attachmentDataList.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20Excle\u6587\u4ef6\u3002", (String)"ForecastImportPlugin_3", (String)"mmc-mrp-report", (Object[])new Object[0]));
        }
        if (attachmentDataList.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u540c\u65f6\u5904\u7406\u591a\u4e2aExcle\u6587\u4ef6\u3002", (String)"ForecastImportPlugin_5", (String)"mmc-mrp-report", (Object[])new Object[0]));
        }
        Map attachmentData = (Map)attachmentDataList.get(0);
        String fileUrl = (String)attachmentData.get("url");
        if (StringUtils.isBlank((CharSequence)fileUrl)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20Excle\u6587\u4ef6\u3002", (String)"ForecastImportPlugin_3", (String)"mmc-mrp-report", (Object[])new Object[0]));
        }
        FileService service = FileServiceFactory.getAttachmentFileService();
        boolean exists = service.exists(fileUrl);
        if (exists) {
            return service.getInputStream(fileUrl);
        }
        Map<String, String> parseUrl = this.parseUrl(fileUrl);
        TempFileCacheDownloadable downLoadCache = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        TempFileCacheDownloadable.Content content = downLoadCache.get(parseUrl.get("configKey"), parseUrl.get("id"));
        return content.getInputStream();
    }

    private Map<String, String> parseUrl(String url) {
        String[] pairStr = url.split("\\?");
        String[] pairs = pairStr[1].split("&");
        HashMap result = Maps.newHashMapWithExpectedSize((int)2);
        int index0 = 0;
        int index1 = 1;
        for (String pair : pairs) {
            String[] p = pair.split("=");
            result.put(p[index0], p[index1]);
        }
        return result;
    }

    private int getProgress() {
        String str = this.getPageCache().get("progress");
        return StringUtils.isBlank((CharSequence)str) ? 0 : Integer.parseInt(str);
    }

    private void setProgress(int progress) {
        this.getPageCache().put("progress", String.valueOf(progress));
    }

    private void setTip(String tip) {
        this.getPageCache().put("tip", tip);
    }

    private String getTip() {
        return this.getPageCache().get("tip");
    }

    private boolean isCompleted() {
        String finish = this.getPageCache().get("complete");
        return !StringUtils.isBlank((CharSequence)finish) && Boolean.parseBoolean(finish);
    }

    private boolean isError() {
        String error = this.getPageCache().get("error");
        return !StringUtils.isBlank((CharSequence)error) && Boolean.parseBoolean(error);
    }

    private String getErrorMsg() {
        return this.getPageCache().get("errorMsg");
    }

    private void reset() {
        this.setProgress(0);
        this.getView().setVisible(Boolean.FALSE, new String[]{"btndetail"});
        this.getPageCache().remove("error");
        this.getPageCache().remove("errorMsgs");
        this.getPageCache().remove("errorMsg");
        this.getPageCache().remove("complete");
        this.getPageCache().remove("completeMsg");
    }

    public void setError(String errorMsg) {
        this.getPageCache().put("error", String.valueOf(true));
        this.getPageCache().put("errorMsg", errorMsg);
    }
}

