/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.report.rpt.impt;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import kd.bos.algo.DataType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.exception.KDBizException;
import kd.bos.impt.SheetHandler;

public class ForecastSheetHandle<T>
extends SheetHandler {
    private int fixCloumnsEndIndex;
    private List<AbstractReportColumn> cloumns;
    private Map<String, Set<String>> baseDatas;
    private Map<T, T> matchDatas;
    private List<T> datas;
    private Map<Integer, StringJoiner[]> errorMsgs;
    private Map<T, T> dbData;
    private Set<String> mustInputColumns;
    private int updateNum;

    public ForecastSheetHandle() {
    }

    public ForecastSheetHandle(List<AbstractReportColumn> cloumns, int fixCloumnsEndIndex) {
        this.fixCloumnsEndIndex = fixCloumnsEndIndex;
        this.cloumns = cloumns;
    }

    public void handleRow(SheetHandler.ParsedRow parsedRow) {
        if (parsedRow.getRowNum() == 2) {
            this.checkTableTile(parsedRow);
        }
        if (parsedRow.getRowNum() > 2) {
            this.checkData(parsedRow);
        }
    }

    private void checkData(SheetHandler.ParsedRow parsedRow) {
        if (this.isEmptyRow(parsedRow)) {
            return;
        }
        this.parsedRowData(parsedRow);
    }

    public void parsedRowData(SheetHandler.ParsedRow parsedRow) {
    }

    public void addBaseData(T t) {
    }

    private void checkTableTile(SheetHandler.ParsedRow parsedRow) {
        Map tableTitle = parsedRow.getData();
        for (int i = 0; i < this.cloumns.size(); ++i) {
            String tableTitleName;
            ReportColumn reportColumn = (ReportColumn)this.cloumns.get(i);
            String name = reportColumn.getCaption().getLocaleValue();
            if (StringUtils.equals((CharSequence)name, (CharSequence)(tableTitleName = (String)tableTitle.get(i)))) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u6587\u4ef6\u9519\u8bef\uff0c\u8bf7\u6309\u5bfc\u51fa\u6a21\u677f\u5bfc\u5165\u3002", (String)"ForecastSheetHandle_0", (String)"mmc-mrp-report", (Object[])new Object[0]));
        }
    }

    protected Object convertValue(String fieldType, String cellValue) {
        switch (fieldType) {
            case "text": {
                return cellValue;
            }
            case "decimal": {
                if (StringUtils.isEmpty((CharSequence)cellValue)) {
                    return BigDecimal.ZERO;
                }
                return DataType.convertValue((DataType)DataType.BigDecimalType, (Object)cellValue);
            }
            case "qty": {
                if (StringUtils.isEmpty((CharSequence)cellValue)) {
                    return BigDecimal.ZERO;
                }
                return DataType.convertValue((DataType)DataType.BigDecimalType, (Object)cellValue);
            }
        }
        return cellValue;
    }

    public Map<Integer, StringJoiner[]> getErrorMsgs() {
        if (this.errorMsgs == null) {
            this.errorMsgs = new HashMap<Integer, StringJoiner[]>();
        }
        return this.errorMsgs;
    }

    private boolean isEmptyRow(SheetHandler.ParsedRow parsedRow) {
        Map row = parsedRow.getData();
        if (row == null || row.isEmpty()) {
            return true;
        }
        boolean isEmptyRow = true;
        Collection values = row.values();
        for (String value : values) {
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            isEmptyRow = false;
        }
        return isEmptyRow;
    }

    public Map<T, T> getMatchDatas() {
        if (this.matchDatas == null) {
            this.matchDatas = new HashMap<T, T>();
        }
        return this.matchDatas;
    }

    public List<T> getDatas() {
        if (this.datas == null) {
            this.datas = new ArrayList<T>();
        }
        return this.datas;
    }

    public void setDatas(List<T> datas) {
        this.datas = datas;
    }

    public Map<String, Set<String>> getBaseDatas() {
        if (this.baseDatas == null) {
            this.baseDatas = new HashMap<String, Set<String>>();
        }
        return this.baseDatas;
    }

    public List<AbstractReportColumn> getCloumns() {
        return this.cloumns;
    }

    public Map<T, T> getDbData() {
        return this.dbData;
    }

    public Set<String> getMustInputColumns() {
        return this.mustInputColumns;
    }

    public void setMustInputColumns(Set<String> mustInputColumns) {
        this.mustInputColumns = mustInputColumns;
    }

    public void fillErrorMsg(Integer index, int seq, CharSequence detailMsg) {
        StringJoiner[] errorMsgInfo = this.getErrorMsgs().computeIfAbsent(index, x -> new StringJoiner[2]);
        StringJoiner errorMsg = errorMsgInfo[seq];
        if (errorMsg == null) {
            if (seq == 0) {
                errorMsg = new StringJoiner(",", "", "]");
                errorMsg.add(String.format(ResManager.loadKDString((String)"\u4e0e\u6587\u4ef6\u5185\u6570\u636e\u91cd\u590d\u884c\u53f7\u4e3a[%s", (String)"ForecastSheetHandle_1", (String)"mmc-mrp-report", (Object[])new Object[0]), detailMsg));
                errorMsgInfo[seq] = errorMsg;
                return;
            }
            errorMsgInfo[seq] = errorMsg = new StringJoiner("\n");
        }
        errorMsg.add(detailMsg);
    }

    public int getFixCloumnsEndIndex() {
        return this.fixCloumnsEndIndex;
    }

    public void setDbData(Map<T, T> dbData) {
        this.dbData = dbData;
    }

    protected void addUpdateNum() {
        ++this.updateNum;
    }

    public int getUpdateNum() {
        return this.updateNum;
    }

    protected boolean checkBigdecimalFormat(String value) {
        return Pattern.matches("[-+]?[0-9]{1,20}+(.[0-9]{1,10})|[-+]?[0-9]{1,20}", value);
    }
}

