/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.report.rpt.impt;

import com.google.common.collect.Sets;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mmc.mrp.report.rpt.impt.ForcastImportService;
import kd.mmc.mrp.report.rpt.impt.ForecastSheetHandle;
import kd.mmc.mrp.rpt.entity.BaseDataEntity;
import kd.mmc.mrp.rpt.entity.ProductionForeCastEntity;

public class ProductionForecastImportService
extends ForcastImportService<ProductionForeCastEntity> {
    private final String planNo;
    private static final String ENTITY_NAME = "mrp_rpt_production_datas";
    private long entityId;
    private static final Set<String> DATADEMANDMODELS = Sets.newHashSet((Object[])new String[]{"MTS", "MTO", "ATO", "ETO", "STO"});
    private static final Set<String> MUST_INPUT_COLUMNS = Sets.newHashSet((Object[])new String[]{"offeringno", "supplyorg"});

    public ProductionForecastImportService(AbstractFormPlugin formPlugin, ForecastSheetHandle<ProductionForeCastEntity> sheetHandler, String planNo) {
        super(formPlugin, sheetHandler);
        this.planNo = planNo;
    }

    @Override
    public void handleExcel(InputStream inputStream) throws Exception {
        this.getSheetHandler().setMustInputColumns(MUST_INPUT_COLUMNS);
        super.handleExcel(inputStream);
    }

    @Override
    public Map<ProductionForeCastEntity, ProductionForeCastEntity> seletReportData() {
        QFilter qFilter = new QFilter("planid", "=", (Object)this.planNo);
        StringJoiner selectProperties = new StringJoiner(",");
        selectProperties.add("id");
        selectProperties.add("entryentity.id");
        selectProperties.add("entryentity.offeringno");
        selectProperties.add("entryentity.offeringname");
        selectProperties.add("entryentity.offeringid");
        selectProperties.add("entryentity.supplyorg");
        selectProperties.add("entryentity.operator");
        selectProperties.add("entryentity.demandmodel");
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)ENTITY_NAME, (String)selectProperties.toString(), (QFilter[])qFilter.toArray());
        if (dynamicObject == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\uff1a\u672a\u751f\u6210\u9884\u6d4b\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"ProductionForecastImportService_0", (String)"mmc-mrp-report", (Object[])new Object[0]), this.planNo));
        }
        this.entityId = dynamicObject.getLong("id");
        HashMap<ProductionForeCastEntity, ProductionForeCastEntity> dbDatas = new HashMap<ProductionForeCastEntity, ProductionForeCastEntity>(16);
        DynamicObjectCollection entrys = dynamicObject.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entrys) {
            DynamicObject org;
            ProductionForeCastEntity productionForeCastEntity = new ProductionForeCastEntity();
            productionForeCastEntity.setId(Long.valueOf(entry.getLong("id")));
            productionForeCastEntity.setOfferingNo(entry.getString("offeringno"));
            productionForeCastEntity.setOfferingId(Long.valueOf(entry.getLong("offeringid")));
            productionForeCastEntity.setOfferingName(entry.getString("offeringname"));
            productionForeCastEntity.setDemandmodel(StringUtils.isBlank((CharSequence)entry.getString("demandmodel")) ? "" : entry.getString("demandmodel"));
            DynamicObject user = entry.getDynamicObject("operator");
            if (user != null) {
                productionForeCastEntity.setOperatorId(Long.valueOf(user.getLong("id")));
                productionForeCastEntity.setOperatorNo(user.getString("number"));
            }
            if ((org = entry.getDynamicObject("supplyorg")) != null) {
                productionForeCastEntity.setOrgId(Long.valueOf(org.getLong("id")));
                productionForeCastEntity.setOrgNo(org.getString("number"));
            }
            dbDatas.put(productionForeCastEntity, productionForeCastEntity);
        }
        return dbDatas;
    }

    @Override
    public void checkBaseData(ProductionForeCastEntity data, Map<String, Map<String, BaseDataEntity>> daseDataDynamicObjects) {
        String dataDemandmodel;
        String orgNo;
        String operatorNo;
        if (daseDataDynamicObjects == null) {
            return;
        }
        if (data.getId() != null && data.getId() != 0L) {
            return;
        }
        String offeringNo = data.getOfferingNo();
        if (StringUtils.isNotEmpty((CharSequence)offeringNo)) {
            BaseDataEntity offering;
            Map<String, BaseDataEntity> offerings = daseDataDynamicObjects.get("bd_productsummary");
            BaseDataEntity baseDataEntity = offering = offerings == null ? null : offerings.get(offeringNo);
            if (offering == null) {
                BaseDataEntity material;
                Map<String, BaseDataEntity> materials = daseDataDynamicObjects.get("bd_material");
                BaseDataEntity baseDataEntity2 = material = materials == null ? null : materials.get(offeringNo);
                if (material == null) {
                    this.getSheetHandler().fillErrorMsg(data.getRow(), 1, String.format(ResManager.loadKDString((String)"offring\u7f16\u7801\u201c%s\u201d\u4e0d\u5b58\u5728\u6216\u4e3a\u4e0d\u53ef\u7528\u3001\u975e\u5df2\u5ba1\u6838\u72b6\u6001\u3002", (String)"ProductionForecastImportService_1", (String)"mmc-mrp-report", (Object[])new Object[0]), offeringNo));
                } else {
                    data.setOfferingId((Long)material.getId());
                    data.setOfferingName(material.getName());
                }
            } else {
                data.setOfferingId((Long)offering.getId());
                data.setOfferingName(offering.getName());
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(operatorNo = data.getOperatorNo()))) {
            BaseDataEntity user;
            Map<String, BaseDataEntity> users = daseDataDynamicObjects.get("bos_user");
            BaseDataEntity baseDataEntity = user = users == null ? null : users.get(operatorNo);
            if (user == null) {
                this.getSheetHandler().fillErrorMsg(data.getRow(), 1, String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u8ba1\u5212\u5458\u7f16\u7801\u201c%s\u201d\u4e0d\u5b58\u5728\u6216\u4e3a\u4e0d\u53ef\u7528\u3001\u975e\u5df2\u5ba1\u6838\u72b6\u6001\u3002", (String)"ProductionForecastImportService_2", (String)"mmc-mrp-report", (Object[])new Object[0]), operatorNo));
            } else {
                data.setOperatorId((Long)user.getId());
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(orgNo = data.getOrgNo()))) {
            BaseDataEntity org;
            Map<String, BaseDataEntity> orgs = daseDataDynamicObjects.get("bos_org");
            BaseDataEntity baseDataEntity = org = orgs == null ? null : orgs.get(orgNo);
            if (org == null) {
                this.getSheetHandler().fillErrorMsg(data.getRow(), 1, String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u7ec4\u7ec7\u7f16\u7801\u201c%s\u201d\u4e0d\u5b58\u5728\u6216\u4e3a\u4e0d\u53ef\u7528\u3001\u975e\u5df2\u5ba1\u6838\u72b6\u6001\u3002", (String)"ProductionForecastImportService_3", (String)"mmc-mrp-report", (Object[])new Object[0]), orgNo));
            } else {
                data.setOrgId((Long)org.getId());
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(dataDemandmodel = data.getDemandmodel())) && !DATADEMANDMODELS.contains(dataDemandmodel)) {
            this.getSheetHandler().fillErrorMsg(data.getRow(), 1, String.format(ResManager.loadKDString((String)"\u5236\u9020\u7b56\u7565\u201c%s\u201d\u9519\u8bef\u3002", (String)"ProductionForecastImportService_4", (String)"mmc-mrp-report", (Object[])new Object[0]), dataDemandmodel));
        }
        if (StringUtils.isBlank((CharSequence)dataDemandmodel)) {
            data.setDemandmodel("");
        }
    }

    @Override
    public void saveOrUpdateData() {
        List datas = this.getSheetHandler().getDatas();
        int batchSize = 100;
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)ENTITY_NAME);
        DBRoute dbRoute = new DBRoute(entityType.getDBRouteKey());
        ArrayList<Object[]> addEntrys = new ArrayList<Object[]>();
        ArrayList<Object[]> addSubEntrys = new ArrayList<Object[]>();
        ArrayList<Object[]> updateEntrys = new ArrayList<Object[]>();
        ArrayList<Object[]> updateSubEntrys = new ArrayList<Object[]>();
        List<AbstractReportColumn> columns = this.getSheetHandler().getCloumns();
        int fixCloumnsEndIndex = this.getSheetHandler().getFixCloumnsEndIndex() + 1;
        Iterator iterator = datas.iterator();
        long userId = RequestContext.get().getCurrUserId();
        Date time = new Date();
        int updateSize = 0;
        int addSize = 0;
        int updateNum = this.getSheetHandler().getUpdateNum();
        int idSize = updateNum + updateNum * (columns.size() - fixCloumnsEndIndex - 1);
        long[] ids = ID.genLongIds((int)idSize);
        while (iterator.hasNext()) {
            ProductionForeCastEntity item = (ProductionForeCastEntity)iterator.next();
            Long id = item.getId();
            if (id == null || id == 0L) {
                ++addSize;
                Object[] saveEntryParams = new Object[14];
                long entryId = ids[--updateNum];
                saveEntryParams[0] = this.entityId;
                saveEntryParams[1] = entryId;
                saveEntryParams[2] = item.getOfferingNo();
                saveEntryParams[3] = item.getOfferingName();
                saveEntryParams[4] = item.getOfferingId();
                saveEntryParams[5] = item.getOrgId();
                saveEntryParams[6] = item.getDemandmodel();
                saveEntryParams[7] = item.getOperatorId();
                saveEntryParams[8] = "A";
                saveEntryParams[9] = 0L;
                saveEntryParams[10] = userId;
                saveEntryParams[11] = time;
                saveEntryParams[12] = item.getRemark();
                saveEntryParams[13] = BigDecimal.ZERO;
                addEntrys.add(saveEntryParams);
                for (int i = fixCloumnsEndIndex; i < columns.size(); ++i) {
                    ReportColumn reportColumn = (ReportColumn)columns.get(i);
                    String fieldKey = reportColumn.getFieldKey();
                    String fieldName = reportColumn.getCaption().getLocaleValue();
                    List dynamicData = item.getDynamicData();
                    int index = i - fixCloumnsEndIndex;
                    BigDecimal value = (BigDecimal)dynamicData.get(index);
                    Object[] saveSubEntryParams = new Object[]{entryId, ids[--idSize], fieldKey, fieldName, value, index};
                    addSubEntrys.add(saveSubEntryParams);
                }
            } else {
                ++updateSize;
                Object[] entryParams = new Object[]{userId, time, item.getRemark(), id};
                updateEntrys.add(entryParams);
                for (int i = fixCloumnsEndIndex; i < columns.size(); ++i) {
                    Object[] objects = new Object[3];
                    ReportColumn reportColumn = (ReportColumn)columns.get(i);
                    String fieldKey = reportColumn.getFieldKey();
                    List dynamicData = item.getDynamicData();
                    int index = i - fixCloumnsEndIndex;
                    BigDecimal value = (BigDecimal)dynamicData.get(index);
                    objects[0] = value;
                    objects[1] = item.getId();
                    objects[2] = fieldKey;
                    updateSubEntrys.add(objects);
                }
            }
            if (updateEntrys.size() == batchSize || !iterator.hasNext()) {
                this.updateEntry(updateEntrys, dbRoute);
                updateEntrys.clear();
            }
            if (updateSubEntrys.size() <= batchSize && iterator.hasNext()) continue;
            this.updateSubEntry(updateSubEntrys, dbRoute);
            updateSubEntrys.clear();
        }
        int addEntrysSize = addEntrys.size();
        int fromIndex = 0;
        if (addEntrysSize > 0) {
            while (fromIndex < addEntrysSize) {
                int toIndex = fromIndex + batchSize;
                if (toIndex > addEntrysSize) {
                    toIndex = addEntrysSize;
                }
                this.saveEntry(addEntrys.subList(fromIndex, toIndex), dbRoute);
                fromIndex = toIndex;
            }
        }
        int addSubEntrySize = addSubEntrys.size();
        fromIndex = 0;
        if (addEntrysSize > 0) {
            while (fromIndex < addSubEntrySize) {
                int toIndex = fromIndex + batchSize;
                if (toIndex > addSubEntrySize) {
                    toIndex = addSubEntrySize;
                }
                this.saveSubEntry(addSubEntrys.subList(fromIndex, toIndex), dbRoute);
                fromIndex = toIndex;
            }
        }
        this.setCompleted(addSize, updateSize);
    }

    private void updateEntry(List<Object[]> updateEntrys, DBRoute dbRoute) {
        String sql = "update t_mrp_production_datafix set fmodifierfield = ?,fmodifytime = ?,fremark = ? where FEntryID = ?";
        this.executeSql(sql, updateEntrys, dbRoute);
    }

    private void saveEntry(List<Object[]> objects, DBRoute dbRoute) {
        String sql = "insert  into t_mrp_production_datafix (fid,fentryid,fofferingno,fofferingname,fofferingid,fsupplyorg,fdemandmodel,foperator,facqstatus,facquser,fmodifierfield,fmodifytime,fremark,fqty) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        this.executeSql(sql, objects, dbRoute);
    }

    private void saveSubEntry(List<Object[]> objects, DBRoute dbRoute) {
        String sql = "insert  into t_mrp_production_datasub (fentryid,fdetailid,ffieldkey,ffieldcaption,ffieldvalue,fsequence) values (?,?,?,?,?,?)";
        this.executeSql(sql, objects, dbRoute);
    }

    private void updateSubEntry(List<Object[]> objects, DBRoute dbRoute) {
        String sql = "update t_mrp_production_datasub set ffieldvalue = ? where FEntryID = ? and ffieldkey = ? ";
        this.executeSql(sql, objects, dbRoute);
    }
}

