/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.report.supdem;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import kd.bos.algo.Algo;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.ReduceGroupFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;

public class SupplyDemandMonthListQueryPlugin
extends AbstractReportListDataPlugin {
    private static Calendar CAL = Calendar.getInstance();
    private int rowId = 0;
    private RowMeta meta = new RowMeta(new String[]{"month", "displaymonth", "monthproject", "monthtrack", "monthreqqty", "monthsupqty", "monthavqty", "monthunit", "rowid", "pid", "isgroupnode"}, new DataType[]{DataType.DateType, DataType.StringType, DataType.LongType, DataType.LongType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.LongType, DataType.StringType, DataType.StringType, DataType.IntegerType});

    public DataSet query(ReportQueryParam arg0, Object arg1) throws Throwable {
        CachedDataSet ds;
        Algo algo = Algo.create((String)"real_time_rpt_month");
        Object cacheId = arg0.getCustomParam().get("detail_dataset_id");
        try {
            ds = Algo.getCacheDataSet((String)String.valueOf(cacheId));
        }
        catch (Throwable error) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u67e5\u8be2\u5df2\u5931\u6548\uff0c\u8bf7\u5237\u65b0\u5f53\u524d\u62a5\u8868\u3002", (String)"SupplyDemandRptFormPlugin_9", (String)"mmc-mrp-report", (Object[])new Object[0]));
        }
        DataSet details = ds.toDataSet(algo, false);
        details = details.addField("concat('M - ', Year(billdate), ' - ', Month(billdate))", "displaymonth");
        details = this.sum(details.where("isinvrow = 0"), true).union(this.sum(details.where("isinvrow = 1"), false));
        String fields = "month, displaymonth, monthtrack, monthreqqty, monthsupqty, monthunit, ";
        fields = fields + "(case when PreRowValue(monthtrack) = monthtrack then PreRowValue() + monthavqty else monthavqty end) as monthavqty";
        fields = fields + ", rowid, pid, isgroupnode";
        details = details.select(fields);
        return details;
    }

    private DataSet sum(DataSet ds, final boolean isInv) {
        return ds.filter("leftqty is not null").groupBy(new String[]{"project", "tracknumber", "displaymonth"}).reduceGroup(new ReduceGroupFunction(){
            private static final long serialVersionUID = -3365878860368564626L;

            public RowMeta getResultRowMeta() {
                return SupplyDemandMonthListQueryPlugin.this.meta;
            }

            public Iterator<Object[]> reduce(Iterator<Row> iter) {
                ArrayList<Object[]> sums = new ArrayList<Object[]>();
                Date date = null;
                Long unit = null;
                Object project = null;
                Long track = null;
                String displaymonth = null;
                BigDecimal reqQty = BigDecimal.ZERO;
                BigDecimal avQty = BigDecimal.ZERO;
                BigDecimal supQty = BigDecimal.ZERO;
                while (iter.hasNext()) {
                    BigDecimal qty;
                    Row next = iter.next();
                    if (date == null) {
                        date = next.getDate("billdate");
                        CAL.setTime(date);
                        CAL.set(5, 1);
                        date = CAL.getTime();
                        displaymonth = next.getString("displaymonth");
                    }
                    if (unit == null) {
                        unit = next.getLong("unit");
                    }
                    if (track == null) {
                        track = next.getLong("tracknumber");
                    }
                    if (project == null) {
                        track = next.getLong("project");
                    }
                    if ((qty = next.getBigDecimal("qty")).compareTo(BigDecimal.ZERO) >= 0) {
                        supQty = supQty.add(qty);
                    } else {
                        reqQty = reqQty.add(qty);
                    }
                    avQty = avQty.add(qty);
                }
                if (date != null) {
                    sums.add(new Object[]{date, isInv ? "Stock" : displaymonth, project, track, reqQty, supQty, avQty, unit, ++SupplyDemandMonthListQueryPlugin.this.rowId, 0, 0});
                }
                return sums.iterator();
            }
        });
    }
}

