/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.report.supdem;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import kd.bos.algo.Algo;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.MapFunction;
import kd.bos.algo.ReduceGroupFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;

public class SupplyDemandWeekListQueryPlugin
extends AbstractReportListDataPlugin {
    private static Calendar CAL = Calendar.getInstance();
    private int rowId = 0;
    private RowMeta meta = new RowMeta(new String[]{"week", "displayweek", "weekproject", "weektrack", "weekreqqty", "weeksupqty", "weekavqty", "weekunit", "rowid", "pid", "isgroupnode"}, new DataType[]{DataType.DateType, DataType.StringType, DataType.LongType, DataType.LongType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.LongType, DataType.StringType, DataType.StringType, DataType.IntegerType});

    public DataSet query(ReportQueryParam arg0, Object arg1) throws Throwable {
        CachedDataSet ds;
        Algo algo = Algo.create((String)"real_time_rpt_week");
        Object cacheId = arg0.getCustomParam().get("detail_dataset_id");
        try {
            ds = Algo.getCacheDataSet((String)String.valueOf(cacheId));
        }
        catch (Throwable error) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u67e5\u8be2\u5df2\u5931\u6548\uff0c\u8bf7\u5237\u65b0\u5f53\u524d\u62a5\u8868\u3002", (String)"SupplyDemandRptFormPlugin_9", (String)"mmc-mrp-report", (Object[])new Object[0]));
        }
        DataSet details = ds.toDataSet(algo, false);
        details = this.sum(details.where("isinvrow = 0"), true).union(this.sum(details.where("isinvrow = 1"), false));
        String fields = "week, displayweek, weektrack, weekreqqty, weeksupqty, weekunit, ";
        fields = fields + "(case when PreRowValue(weektrack) = weektrack then PreRowValue() + weekavqty else weekavqty end) as weekavqty";
        fields = fields + ", rowid, pid, isgroupnode";
        details = details.select(fields);
        return details;
    }

    private DataSet sum(DataSet ds, final boolean isInv) {
        return ds.filter("leftqty is not null").map(new MapFunction(){
            private static final long serialVersionUID = 8492325410220133645L;

            public RowMeta getResultRowMeta() {
                return SupplyDemandWeekListQueryPlugin.this.meta;
            }

            public Object[] map(Row arg0) {
                Date date = arg0.getDate("billdate");
                CAL.setTime(date);
                int week = CAL.get(3);
                CAL.set(7, 1);
                BigDecimal qty = arg0.getBigDecimal("qty");
                return new Object[]{CAL.getTime(), "W - " + CAL.get(1) + " - " + week, arg0.get("project"), arg0.getLong("tracknumber"), qty, BigDecimal.ZERO, BigDecimal.ZERO, arg0.getLong("unit")};
            }
        }).groupBy(new String[]{"weekproject", "weektrack", "displayweek"}).reduceGroup(new ReduceGroupFunction(){
            private static final long serialVersionUID = -3365878860368564626L;

            public RowMeta getResultRowMeta() {
                return SupplyDemandWeekListQueryPlugin.this.meta;
            }

            public Iterator<Object[]> reduce(Iterator<Row> iter) {
                ArrayList<Object[]> sums = new ArrayList<Object[]>();
                Date date = null;
                Long unit = null;
                Object project = null;
                Long track = null;
                String displayweek = null;
                BigDecimal reqQty = BigDecimal.ZERO;
                BigDecimal avQty = BigDecimal.ZERO;
                BigDecimal supQty = BigDecimal.ZERO;
                while (iter.hasNext()) {
                    BigDecimal qty;
                    Row next = iter.next();
                    if (date == null) {
                        date = next.getDate("week");
                        displayweek = next.getString("displayweek");
                    }
                    if (unit == null) {
                        unit = next.getLong("weekunit");
                    }
                    if (track == null) {
                        track = next.getLong("weektrack");
                    }
                    if (project == null) {
                        track = next.getLong("weekproject");
                    }
                    if ((qty = next.getBigDecimal("weekreqqty")).compareTo(BigDecimal.ZERO) >= 0) {
                        supQty = supQty.add(qty);
                    } else {
                        reqQty = reqQty.add(qty);
                    }
                    avQty = avQty.add(qty);
                }
                if (date != null) {
                    sums.add(new Object[]{date, isInv ? "Stock" : displayweek, project, track, reqQty, supQty, avQty, unit, ++SupplyDemandWeekListQueryPlugin.this.rowId, 0, 0});
                }
                return sums.iterator();
            }
        });
    }
}

