/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.report.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.IColumn;
import kd.bos.entity.IColumnGroup;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.operate.GridConfigurationRow;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ComboReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.IPageCache;
import kd.bos.form.field.format.FlexValueFormatter;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.report.ReportList;
import kd.bos.report.ReportOperationColumn;
import kd.bos.report.flex.FlexColumnSplitService;
import kd.bos.report.plugin.ReportViewPluginProxy;
import kd.bos.report.proxy.ReportListProxy;
import kd.mmc.mrp.report.plananalysis.MRPMergeExcelCell;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public class SummaryListExporter {
    private static final String CELLSTYLE_ALIGN_DEFAULT = "default";
    private static final int MAX_SEARCH_CONDITION_LENGTH = 10000;
    private int filterRows = 0;
    private List<SXSSFRow> headRows = new ArrayList<SXSSFRow>();
    private int colIndex = 0;
    private int loopTimes;
    private Map<String, CellStyle> textStyles = new HashMap<String, CellStyle>();
    private Map<String, Boolean> map = new HashMap<String, Boolean>();
    private Map<String, String> keyCaptionMap = new HashMap<String, String>();

    public int getLoopTimes() {
        return this.loopTimes;
    }

    public void setLoopTimes(int loopTimes) {
        this.loopTimes = loopTimes;
    }

    private boolean isValidColumn(AbstractReportColumn col) {
        ReportColumnGroup rc;
        boolean validColumn = true;
        if (col instanceof ReportColumn) {
            ReportColumn rc2 = (ReportColumn)col;
            if (rc2.isHide() || rc2.isPicture()) {
                validColumn = false;
            }
        } else if (col instanceof ReportColumnGroup && this.map.containsKey((rc = (ReportColumnGroup)col).getFieldKey()) && this.map.get(rc.getFieldKey()).booleanValue()) {
            validColumn = false;
        }
        return validColumn;
    }

    private void addReportColumn(List<AbstractReportColumn> columns, List<AbstractReportColumn> cols) {
        for (AbstractReportColumn col : columns) {
            if (!this.isValidColumn(col)) continue;
            if (this.isColumnGroup(col)) {
                List children = ((IColumnGroup)col).getChildren();
                this.addReportColumn(children, cols);
                continue;
            }
            cols.add(col);
        }
    }

    private static CellStyle createTitleCellStyle(SXSSFWorkbook wb) {
        CellStyle cellStyle = wb.createCellStyle();
        SummaryListExporter.setCommonStyle(cellStyle);
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setFillForegroundColor(IndexedColors.WHITE.getIndex());
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle.setWrapText(true);
        Font headerFont1 = wb.createFont();
        headerFont1.setBold(true);
        cellStyle.setFont(headerFont1);
        return cellStyle;
    }

    private void createSearchCondition(SXSSFWorkbook wb, SXSSFSheet sheet, List<AbstractReportColumn> columns, IPageCache iPageCache, ReportList list) {
        String searchCondition;
        ArrayList<AbstractReportColumn> cols = new ArrayList<AbstractReportColumn>();
        this.addReportColumn(columns, cols);
        String caption = list.getView().getFormShowParameter().getFormConfig().getCaption().getLocaleValue();
        SXSSFRow row = sheet.createRow(0);
        row.setHeightInPoints(30.0f);
        for (int row1 = 0; row1 < cols.size(); ++row1) {
            SXSSFCell i = row.createCell(row1);
            i.setCellValue(caption);
            i.setCellStyle(SummaryListExporter.createTitleCellStyle(wb));
        }
        if (cols.size() > 1) {
            sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, cols.size() - 1));
        }
        if (!StringUtils.isBlank((CharSequence)(searchCondition = this.getSearchCondition(iPageCache)))) {
            SXSSFRow arg8 = sheet.createRow(1);
            for (int arg9 = 0; arg9 < cols.size(); ++arg9) {
                SXSSFCell cell1 = arg8.createCell(arg9);
                cell1.setCellValue(this.getSearchConditionByLength(iPageCache, searchCondition));
                cell1.setCellStyle(SummaryListExporter.createConditionCellStyle(wb));
            }
            if (cols.size() > 1) {
                sheet.addMergedRegion(new CellRangeAddress(1, 1, 0, cols.size() - 1));
            }
            this.filterRows = 2;
        } else {
            this.filterRows = 1;
        }
    }

    private static CellStyle createConditionCellStyle(SXSSFWorkbook wb) {
        CellStyle cellStyle = wb.createCellStyle();
        SummaryListExporter.setCommonStyle(cellStyle);
        cellStyle.setFillForegroundColor(IndexedColors.WHITE.getIndex());
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle.setWrapText(true);
        Font headerFont1 = wb.createFont();
        headerFont1.setColor(IndexedColors.BLUE.index);
        cellStyle.setFont(headerFont1);
        return cellStyle;
    }

    public String getSearchCondition(IPageCache iPageCache) {
        return iPageCache.get("searchCondition");
    }

    private String getSearchConditionByLength(IPageCache iPageCache, String searchCondition) {
        if (searchCondition.length() > 10000) {
            String condition = this.getSearchCondition(iPageCache).substring(0, 10000);
            return condition + "...";
        }
        return this.getSearchCondition(iPageCache);
    }

    private void getExportColumn(List<AbstractReportColumn> exportColumns, List<AbstractReportColumn> columns, ReportList reportList, ReportListProxy reportListProxy) {
        FormatObject format = reportListProxy.getFormat();
        ArrayList<AbstractReportColumn> originColumns = new ArrayList<AbstractReportColumn>();
        HashMap<String, AbstractReportColumn> originColumnMap = new HashMap<String, AbstractReportColumn>();
        for (AbstractReportColumn abstractReportColumn : columns) {
            if (abstractReportColumn instanceof ReportOperationColumn) continue;
            String fieldKey = null;
            if (abstractReportColumn instanceof ReportColumnGroup) {
                fieldKey = ((ReportColumnGroup)abstractReportColumn).getFieldKey();
                List childrens = ((ReportColumnGroup)abstractReportColumn).getChildren();
                for (AbstractReportColumn abstractReportColumn2 : childrens) {
                    if (abstractReportColumn2 instanceof ReportOperationColumn) continue;
                    if (abstractReportColumn2 instanceof ReportColumnGroup) {
                        this.recurGroupColumnUserFormat((ReportColumnGroup)abstractReportColumn2, format);
                        continue;
                    }
                    abstractReportColumn2.setUserFormat(format);
                }
            } else {
                if (abstractReportColumn instanceof ReportColumn) {
                    fieldKey = ((ReportColumn)abstractReportColumn).getFieldKey();
                }
                abstractReportColumn.setUserFormat(format);
            }
            if (!StringUtils.isBlank((CharSequence)fieldKey)) {
                originColumnMap.put(fieldKey, abstractReportColumn);
            }
            originColumns.add(abstractReportColumn);
        }
        List configRows = reportListProxy.getUserGridConfigRows();
        if (configRows != null && !configRows.isEmpty()) {
            for (GridConfigurationRow row : configRows) {
                this.map.put(row.getFieldKey(), row.isHide());
                AbstractReportColumn column = null;
                for (Map.Entry entry : originColumnMap.entrySet()) {
                    Object fieldKey = reportList.getMergeMap().get(entry.getKey()) == null ? entry.getKey() : reportList.getMergeMap().get(entry.getKey());
                    if (!Objects.equals(fieldKey, row.getFieldKey())) continue;
                    column = (AbstractReportColumn)entry.getValue();
                    break;
                }
                if (column == null) continue;
                exportColumns.add(column);
                originColumns.remove(column);
            }
        }
        exportColumns.addAll(originColumns);
        FormViewPluginProxy formViewPluginProxy = (FormViewPluginProxy)reportList.getView().getService(FormViewPluginProxy.class);
        if (formViewPluginProxy instanceof ReportViewPluginProxy) {
            ((ReportViewPluginProxy)formViewPluginProxy).fireResetColumns(exportColumns);
        }
    }

    private void recurGroupColumnUserFormat(ReportColumnGroup column, FormatObject format) {
        List children = column.getChildren();
        if (children != null && !children.isEmpty()) {
            for (AbstractReportColumn col : children) {
                if (col instanceof ReportColumnGroup) {
                    this.recurGroupColumnUserFormat((ReportColumnGroup)col, format);
                    continue;
                }
                col.setUserFormat(format);
            }
        }
    }

    public String export(SXSSFWorkbook wb, SXSSFSheet sheet, ReportList list, ReportListProxy reportListProxy, IPageCache iPageCache) {
        ArrayList<AbstractReportColumn> columns = new ArrayList<AbstractReportColumn>(30);
        List exportColumns = reportListProxy.getColumnList(list.getReportModel());
        this.getExportColumn(columns, exportColumns, list, reportListProxy);
        if (columns.isEmpty()) {
            return null;
        }
        FlexColumnSplitService flexColumnSplitService = list.getFlexColumnSplitService();
        int in = -1;
        for (int i = 0; i < columns.size(); ++i) {
            ReportColumn reportColumn;
            if (!(columns.get(i) instanceof ReportColumn) || !"fseq".equals((reportColumn = (ReportColumn)columns.get(i)).getFieldKey())) continue;
            in = i;
            break;
        }
        if (in != -1 && in != 0) {
            ReportColumn reportColumn = (ReportColumn)columns.get(in);
            columns.remove(in);
            columns.add(0, (AbstractReportColumn)reportColumn);
        }
        HashMap<String, AbstractReportColumn> reportcolumns = new HashMap<String, AbstractReportColumn>(16);
        if (this.getLoopTimes() == 0) {
            this.colIndex = 0;
            this.headRows = new ArrayList<SXSSFRow>(16);
            this.createSearchCondition(wb, sheet, columns, iPageCache, list);
            this.createHeadColumn(wb, sheet, columns, 0, reportcolumns);
        }
        ArrayList<IColumn> cols = new ArrayList<IColumn>();
        this.toReportColumns(columns, cols);
        if (this.getLoopTimes() == 0) {
            this.adjustColumnWidth(sheet, cols);
            this.mergeTableHead(sheet);
            this.renameTableHeadCells(sheet);
        }
        this.createBodyColumn(wb, sheet, cols, list, reportcolumns, flexColumnSplitService);
        return null;
    }

    private void adjustColumnWidth(SXSSFSheet sheet, List<IColumn> cols) {
        int index = 0;
        for (IColumn col : cols) {
            if (col.isHide() || col.isPicture()) continue;
            if (col.getWidth() != null) {
                String width = (String)col.getWidth().getDefaultItem();
                if (!StringUtils.isEmpty((CharSequence)width)) {
                    int w;
                    if (width.endsWith("px")) {
                        if (!StringUtils.isEmpty((CharSequence)(width = width.substring(0, width.length() - 2)))) {
                            w = Integer.parseInt(width.trim());
                            if (w * 40 > 65280) {
                                sheet.setColumnWidth(index, 6000);
                            } else {
                                sheet.setColumnWidth(index, w * 40);
                            }
                        }
                    } else if (this.IsIntNumber(width)) {
                        w = Integer.parseInt(width.trim());
                        if (w * 40 > 65280) {
                            sheet.setColumnWidth(index, 6000);
                        } else {
                            sheet.setColumnWidth(index, w * 40);
                        }
                    }
                }
            } else if (col.getCaption() != null && col.getCaption().getLocaleValue() != null) {
                int w = col.getCaption().getLocaleValue().getBytes().length;
                if (w * 2 * 160 > 65280) {
                    sheet.setColumnWidth(index, 6000);
                } else {
                    sheet.setColumnWidth(index, w * 2 * 160);
                }
            } else {
                sheet.setColumnWidth(index, 1600);
            }
            ++index;
        }
    }

    private boolean match(String regex, String str) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(str);
        return matcher.matches();
    }

    private boolean IsIntNumber(String str) {
        String regex = "^\\+?[1-9][0-9]*$";
        return this.match(regex, str);
    }

    private void mergeTableHead(SXSSFSheet sheet) {
        MRPMergeExcelCell[][] cells = this.getTableHeadCells(sheet);
        int rowCount = cells.length;
        if (rowCount == 0) {
            throw new KDException(BosErrorCode.reportHeadEmpty, new Object[0]);
        }
        int colCount = cells[0].length;
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < colCount; ++j) {
                MRPMergeExcelCell rowCell;
                MRPMergeExcelCell colCell;
                int col;
                int row = i + 1;
                MRPMergeExcelCell firstCell = cells[i][j];
                firstCell.setMerged(true);
                boolean colMerge = false;
                for (col = j + 1; col < colCount && !(colCell = cells[i][col]).isMerged() && firstCell.getValue().equals(colCell.getValue()); ++col) {
                    if (i == 0) {
                        colCell.setMerged(true);
                        colMerge = true;
                    }
                    if (i <= 0 || !cells[i - 1][j].getValue().equals(cells[i - 1][col].getValue()) || !cells[i - 1][j].isMerged() || !cells[i - 1][col].isMerged()) continue;
                    colCell.setMerged(true);
                    colMerge = true;
                }
                boolean rowMerge = false;
                while (row < rowCount && !(rowCell = cells[row][j]).isMerged() && firstCell.getValue().equals(rowCell.getValue())) {
                    rowCell.setMerged(true);
                    rowMerge = true;
                    ++row;
                }
                if (!colMerge && !rowMerge) continue;
                CellRangeAddress rang = new CellRangeAddress(i + this.filterRows, row + this.filterRows - 1, j, col - 1);
                sheet.addMergedRegion(rang);
            }
        }
    }

    private MRPMergeExcelCell[][] getTableHeadCells(SXSSFSheet sheet) {
        int headRowSize = this.headRows.size();
        MRPMergeExcelCell[][] cells = new MRPMergeExcelCell[headRowSize][this.colIndex];
        for (int i = 0; i < headRowSize; ++i) {
            SXSSFRow row = sheet.getRow(i + this.filterRows);
            for (int j = 0; j < this.colIndex; ++j) {
                cells[i][j] = new MRPMergeExcelCell(row.getCell(j).getStringCellValue());
            }
        }
        return cells;
    }

    private void renameTableHeadCells(SXSSFSheet sheet) {
        int headRowSize = this.headRows.size();
        for (int i = 0; i < headRowSize; ++i) {
            SXSSFRow row = sheet.getRow(i + this.filterRows);
            for (int j = 0; j < this.colIndex; ++j) {
                row.getCell(j).setCellValue(this.keyCaptionMap.get(row.getCell(j).getStringCellValue()));
            }
        }
    }

    protected int createBodyColumn(SXSSFWorkbook wb, SXSSFSheet sheet, List<IColumn> cols, ReportList list, Map<String, AbstractReportColumn> reportcolumns, FlexColumnSplitService flexColumnSplitService) {
        SXSSFRow row = null;
        int rowIndex = this.headRows.size() + this.filterRows;
        HashMap<String, Object> sum = new HashMap<String, Object>(16);
        HashMap<String, CellStyle> dataFormatMap = new HashMap<String, CellStyle>();
        DataFormat dataFormat = wb.createDataFormat();
        int n = list.getReportModel().getRowCount();
        for (int i = 1; i <= n; ++i) {
            DynamicObject rowData = list.getReportModel().getRowData(i);
            row = sheet.createRow(rowIndex++);
            this.setRowData(wb, row, rowData, cols, reportcolumns, sum, flexColumnSplitService, dataFormatMap, dataFormat);
        }
        row = sheet.createRow(rowIndex++);
        this.setSumData(wb, row, cols, reportcolumns, sum, dataFormatMap, dataFormat);
        return rowIndex;
    }

    private void setSumData(SXSSFWorkbook wb, SXSSFRow row, List<IColumn> cols, Map<String, AbstractReportColumn> reportcolumns, Map<String, Object> sum, Map<String, CellStyle> dataFormatMap, DataFormat dataFormat) {
        SXSSFCell cell = null;
        int cellIndex = 0;
        CellStyle cellStyle = null;
        int size = cols.size();
        for (int i = 0; i < size; ++i) {
            ReportColumn rc;
            String fieldKey;
            Boolean customVisiable;
            IColumn col = cols.get(i);
            if (col.isHide() || col.isPicture() || (customVisiable = this.map.get(fieldKey = col.getFieldKey())) != null && customVisiable.booleanValue()) continue;
            AbstractReportColumn reportColumn = reportcolumns.get(fieldKey);
            cell = row.createCell(cellIndex);
            int precision = 10;
            Object data = sum.get(col.getFieldKey());
            if (reportColumn instanceof ReportColumn && "qty".equals((rc = (ReportColumn)reportColumn).getFieldType())) {
                CellStyle qtyStyle;
                String format = "#,##0.00";
                if (precision > 0) {
                    format = format.replaceAll("\\.00", precision > 0 ? String.format(".%0" + precision + "d", 0) : "");
                }
                if ((qtyStyle = dataFormatMap.get(format)) == null) {
                    qtyStyle = wb.createCellStyle();
                    short s = dataFormat.getFormat(format);
                    qtyStyle.setDataFormat(s);
                    dataFormatMap.put(format, qtyStyle);
                }
                BigDecimal bd = new BigDecimal(sum.get(col.getFieldKey()).toString());
                data = bd.doubleValue();
                cellStyle = qtyStyle;
            }
            if (cellStyle == null) {
                cellStyle = this.getTextStyle(wb, CELLSTYLE_ALIGN_DEFAULT);
            }
            if (data instanceof Double) {
                cell.setCellValue(((Double)data).doubleValue());
            } else {
                cell.setCellValue(data == null ? null : data.toString());
            }
            cell.setCellStyle(cellStyle);
            ++cellIndex;
        }
    }

    protected void setRowData(SXSSFWorkbook wb, SXSSFRow row, DynamicObject rowData, List<IColumn> columns, Map<String, AbstractReportColumn> reportcolumns, Map<String, Object> sum, FlexColumnSplitService flexColumnSplitService, Map<String, CellStyle> dataFormatMap, DataFormat dataFormat) {
        SXSSFCell cell = null;
        int cellIndex = 0;
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            String fieldKey;
            Boolean customVisiable;
            IColumn col = columns.get(i);
            if (col.isHide() || col.isPicture() || (customVisiable = this.map.get(fieldKey = col.getFieldKey())) != null && customVisiable.booleanValue()) continue;
            DynamicObject unit = rowData.getDynamicObject("unit");
            int precision = 2;
            int roundMode = 4;
            if (unit != null) {
                precision = unit.getInt("precision");
                int precisionaccount = unit.getInt("precisionaccount");
                if (precisionaccount == 2) {
                    roundMode = 1;
                } else if (precisionaccount == 3) {
                    roundMode = 0;
                }
            }
            cell = row.createCell(cellIndex);
            this.setCellValueAndStyle(wb, col, cell, rowData, reportcolumns, sum, flexColumnSplitService, precision, roundMode, dataFormatMap, dataFormat);
            ++cellIndex;
        }
    }

    protected void setCellValueAndStyle(SXSSFWorkbook wb, IColumn col, SXSSFCell cell, DynamicObject rowData, Map<String, AbstractReportColumn> reportcolumns, Map<String, Object> sum, FlexColumnSplitService flexColumnSplitService, int precision, int roundMode, Map<String, CellStyle> dataFormatMap, DataFormat dataFormat) {
        Object value = null;
        CellStyle cellStyle = null;
        AbstractReportColumn areportColumn = reportcolumns.get(col.getFieldKey());
        if (areportColumn instanceof ReportColumn) {
            ReportColumn reportColumn = (ReportColumn)areportColumn;
            if ("fseq".equals(col.getFieldKey())) {
                value = rowData.get(col.getFieldKey());
                sum.put("fseq", ResManager.loadKDString((String)"\u5408\u8ba1", (String)"SummaryListRptPlugin_6", (String)"mmc-mrp-report", (Object[])new Object[0]));
            } else if ("auxpty".equals(col.getFieldKey())) {
                FlexValueFormatter flexValueFormat = new FlexValueFormatter();
                String flexFieldKey = flexColumnSplitService.getFlexFieldKey(col.getFieldKey());
                FlexProp flexProp = (FlexProp)flexColumnSplitService.getEntityType().getProperty(flexFieldKey);
                Object srcValue = flexValueFormat.getDisplayValueForReport(rowData, flexProp, flexProp.getBasePropertyKey());
                value = srcValue instanceof ArrayList ? String.join((CharSequence)";", (ArrayList)srcValue) : srcValue.toString();
            } else if ("org".equals(col.getFieldKey()) || "material".equals(col.getFieldKey()) || "unit".equals(col.getFieldKey()) || "bomversion".equals(col.getFieldKey()) || "project".equals(col.getFieldKey()) || "planscope".equals(col.getFieldKey()) || "operator".equals(col.getFieldKey())) {
                if (rowData.getDynamicObject(col.getFieldKey()) != null) {
                    value = rowData.getDynamicObject(col.getFieldKey()).getString(reportColumn.getDisplayProp());
                }
            } else if (StringUtils.isBlank((CharSequence)reportColumn.getFieldType())) {
                if (reportColumn.getRefBasedataProp() != null) {
                    value = rowData.getDynamicObject(reportColumn.getRefBasedataProp()).getString(reportColumn.getDisplayProp());
                }
            } else if ("configuredcode".equals(col.getFieldKey()) || "tracknumber".equals(col.getFieldKey())) {
                DynamicObject configuredcode = rowData.getDynamicObject(col.getFieldKey());
                String number = "";
                if (configuredcode != null) {
                    number = configuredcode.getString("number");
                }
                value = number;
            } else if ("qty".equals(reportColumn.getFieldType())) {
                CellStyle qtyStyle;
                String format = "#,##0.00";
                if (precision > 0) {
                    format = format.replaceAll("\\.00", precision > 0 ? String.format(".%0" + precision + "d", 0) : "");
                }
                if ((qtyStyle = dataFormatMap.get(format)) == null) {
                    qtyStyle = wb.createCellStyle();
                    short s = dataFormat.getFormat(format);
                    qtyStyle.setDataFormat(s);
                    dataFormatMap.put(format, qtyStyle);
                }
                BigDecimal bd = new BigDecimal(rowData.getString(col.getFieldKey()));
                value = bd.doubleValue();
                cellStyle = qtyStyle;
                BigDecimal qty = (BigDecimal)sum.getOrDefault(reportColumn.getFieldKey(), BigDecimal.ZERO);
                sum.put(reportColumn.getFieldKey(), qty.add(bd));
            } else if (reportColumn instanceof ComboReportColumn) {
                ComboReportColumn comboReportColumn = (ComboReportColumn)reportColumn;
                List comboItems = comboReportColumn.getComboItems();
                for (ValueMapItem valueMapItem : comboItems) {
                    if (!valueMapItem.getValue().equals(rowData.getString(reportColumn.getFieldKey()))) continue;
                    value = valueMapItem.getName();
                    break;
                }
            } else {
                value = rowData.get(col.getFieldKey());
            }
        } else {
            value = rowData.get(col.getFieldKey());
        }
        if (cellStyle == null) {
            cellStyle = this.getTextStyle(wb, CELLSTYLE_ALIGN_DEFAULT);
        }
        if (value instanceof Double) {
            cell.setCellValue(((Double)value).doubleValue());
        } else {
            cell.setCellValue(value == null ? null : value.toString());
        }
        cell.setCellStyle(cellStyle);
    }

    private CellStyle getTextStyle(SXSSFWorkbook wb, String align) {
        String style = "TEXT_" + align;
        CellStyle cs = this.textStyles.get(style);
        if (cs == null) {
            cs = wb.createCellStyle();
            SummaryListExporter.setCommonStyle(cs);
            cs.setDataFormat(wb.createDataFormat().getFormat("@"));
            cs.setAlignment(this.getAlignment(align));
            this.textStyles.put(style, cs);
        }
        return cs;
    }

    private HorizontalAlignment getAlignment(String align) {
        try {
            return HorizontalAlignment.valueOf((String)align.toUpperCase());
        }
        catch (Throwable e) {
            return HorizontalAlignment.GENERAL;
        }
    }

    private void toReportColumns(List<AbstractReportColumn> acols, List<IColumn> cols) {
        for (AbstractReportColumn acol : acols) {
            if (!this.isValidColumn(acol)) continue;
            if (acol instanceof IColumn) {
                cols.add((IColumn)acol);
                continue;
            }
            if (!(acol instanceof IColumnGroup)) continue;
            List children = ((IColumnGroup)acol).getChildren();
            this.toReportColumns(children, cols);
        }
    }

    private void createHeadColumn(SXSSFWorkbook wb, SXSSFSheet sheet, List<AbstractReportColumn> columns, int rowIndex, Map<String, AbstractReportColumn> reportcolumns) {
        for (AbstractReportColumn col : columns) {
            SXSSFRow row;
            if (!this.isValidColumn(col)) continue;
            if (rowIndex >= this.headRows.size()) {
                row = sheet.createRow(rowIndex + this.filterRows);
                this.headRows.add(row);
            } else {
                row = this.headRows.get(rowIndex);
            }
            this.setTempCell(sheet, rowIndex);
            SXSSFCell cell = row.createCell(this.colIndex);
            LocaleString caption = col.getCaption();
            String fieldKey = "";
            if (col instanceof ReportColumnGroup) {
                fieldKey = ((ReportColumnGroup)col).getFieldKey();
            } else if (col instanceof ReportColumn) {
                fieldKey = ((ReportColumn)col).getFieldKey();
            }
            this.keyCaptionMap.put(fieldKey, caption == null ? "" : caption.toString());
            cell.setCellValue((RichTextString)new XSSFRichTextString(fieldKey));
            cell.setCellType(CellType.STRING);
            cell.setCellStyle(this.getHeadColumnStyle(wb));
            if (this.isColumnGroup(col) && !((ReportColumnGroup)col).isMerge()) {
                List children = ((IColumnGroup)col).getChildren();
                this.createHeadColumn(wb, sheet, children, rowIndex + 1, reportcolumns);
            } else {
                int r = rowIndex;
                while (r < this.headRows.size() - 1) {
                    row = this.headRows.get(++r);
                    this.copyCell(sheet.getRow(r - 1 + this.filterRows).getCell(this.colIndex), row.createCell(this.colIndex));
                }
                ++this.colIndex;
            }
            reportcolumns.put(fieldKey, col);
        }
    }

    private void setTempCell(SXSSFSheet sheet, int rowIndex) {
        SXSSFRow row = sheet.getRow(rowIndex + this.filterRows);
        this.setTempCell(sheet, row, rowIndex, this.colIndex - 1);
        for (int i = 0; i < rowIndex; ++i) {
            SXSSFRow r = this.headRows.get(i);
            SXSSFCell cell = r.getCell(this.colIndex);
            if (cell != null) continue;
            this.copyCell(r.getCell(this.colIndex - 1), r.createCell(this.colIndex));
        }
    }

    private void setTempCell(SXSSFSheet sheet, SXSSFRow row, int rowIndex, int colIndex) {
        if (rowIndex == 0 || colIndex < 0) {
            return;
        }
        SXSSFCell cell = row.getCell(colIndex);
        if (cell == null && colIndex >= 0) {
            this.copyCell(sheet.getRow(this.filterRows + rowIndex - 1).getCell(colIndex), row.createCell(colIndex));
            if (colIndex > 0) {
                this.setTempCell(sheet, row, rowIndex, colIndex - 1);
            }
        }
    }

    private boolean isColumnGroup(AbstractReportColumn col) {
        return col instanceof IColumnGroup;
    }

    private void copyCell(SXSSFCell cell, SXSSFCell newCell) {
        newCell.setCellValue(cell.getStringCellValue());
        newCell.setCellType(cell.getCellType());
        newCell.setCellStyle(cell.getCellStyle());
    }

    private CellStyle getHeadColumnStyle(SXSSFWorkbook wb) {
        CellStyle headColumnStyle = wb.createCellStyle();
        headColumnStyle = wb.createCellStyle();
        SummaryListExporter.setCommonStyle(headColumnStyle);
        headColumnStyle.setFillForegroundColor(IndexedColors.GREY_40_PERCENT.getIndex());
        headColumnStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        headColumnStyle.setAlignment(HorizontalAlignment.CENTER);
        headColumnStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headColumnStyle.setHidden(false);
        return headColumnStyle;
    }

    private static void setCommonStyle(CellStyle cellStyle) {
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
    }
}

