/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.business.helper;

import java.util.logging.Logger;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.orm.query.QFilter;
import kd.mmc.mrp.business.helper.AdjustFilterHelper;
import kd.mmc.mrp.business.helper.AdjustSuggestHelper;

public class AdjustEntryGridHelper {
    private static final Logger logger = Logger.getLogger("kd.mmc.mrp.business.helper.AdjustEntryGridHelper");

    public static void fillDatas(IFormView view, AbstractFormDataModel model) {
        model.deleteEntryData("entryentitys");
        QFilter filter = AdjustFilterHelper.getFilters(view);
        String cacheId = view.getPageCache().get("dataset_cache");
        if (StringUtils.isNotEmpty((CharSequence)cacheId)) {
            AdjustSuggestHelper.colseDataSetCache(cacheId);
        }
        cacheId = AdjustSuggestHelper.bulidDataSetCache(filter);
        view.getPageCache().put("dataset_cache", cacheId);
        TableValueSetter vs = new TableValueSetter(new String[0]);
        model.beginInit();
        int pagesize = 20;
        if (model.getValue("pagesize") != null) {
            String pageSize = (String)model.getValue("pagesize");
            pagesize = Integer.parseInt(pageSize);
        }
        Long startTime = System.currentTimeMillis();
        int count = AdjustSuggestHelper.loadDataByCache(cacheId, vs, 0, 1, pagesize);
        view.getPageCache().put("count_cache", String.valueOf(count));
        Label sumLab = (Label)view.getControl("sumlabelap");
        int pageCount = 0;
        pageCount = count % pagesize == 0 ? count / pagesize : count / pagesize + 1;
        sumLab.setText(String.format(ResManager.loadKDString((String)"\u5171%s\u9875", (String)"AdjustEntryGridHelper_0", (String)"mmc-mrp-business", (Object[])new Object[0]), pageCount));
        model.batchCreateNewEntryRow("entryentitys", vs);
        model.endInit();
        view.updateView("entryentitys");
        model.setValue("pageindex", (Object)1);
        Long endTime = System.currentTimeMillis();
        logger.info("\u8c03\u6574\u5efa\u8bae\u6570\u636e\u52a0\u8f7d\u82b1\u8d39" + (endTime - startTime) + "ms");
    }

    public static void atFirst(IDataModel model) {
        model.setValue("pageindex", (Object)1);
    }

    public static void toFront(IDataModel model) {
        int pageIndex;
        int frontIndex;
        if (model.getValue("pageindex") != null && (frontIndex = (pageIndex = ((Integer)model.getValue("pageindex")).intValue()) - 1) >= 1) {
            model.setValue("pageindex", (Object)frontIndex);
        }
    }

    public static void toBack(IDataModel model, int count) {
        int pageIndex;
        int backIndex;
        int pagesize = 20;
        if (model.getValue("pagesize") != null) {
            String pageSize = (String)model.getValue("pagesize");
            pagesize = Integer.parseInt(pageSize);
        }
        int pageCount = 0;
        pageCount = count % pagesize == 0 ? count / pagesize : count / pagesize + 1;
        if (model.getValue("pageindex") != null && (backIndex = (pageIndex = ((Integer)model.getValue("pageindex")).intValue()) + 1) >= 1 && backIndex <= pageCount) {
            model.setValue("pageindex", (Object)backIndex);
        }
    }

    public static void toLast(IDataModel model, int count) {
        int pagesize = 20;
        if (model.getValue("pagesize") != null) {
            String pageSize = (String)model.getValue("pagesize");
            pagesize = Integer.parseInt(pageSize);
        }
        int pageCount = 0;
        pageCount = count % pagesize == 0 ? count / pagesize : count / pagesize + 1;
        model.setValue("pageindex", (Object)pageCount);
    }

    public static void toPageIndex(IFormView view, AbstractFormDataModel model, int pageIndex) {
        String countStr = view.getPageCache().get("count_cache");
        int count = 0;
        if (StringUtils.isNotEmpty((CharSequence)countStr)) {
            count = Integer.parseInt(countStr);
        }
        Label sumLab = (Label)view.getControl("sumlabelap");
        Integer pageCount = 0;
        int pagesize = 20;
        if (model.getValue("pagesize") != null) {
            String pageSize = String.valueOf(model.getValue("pagesize"));
            pagesize = Integer.parseInt(pageSize);
        }
        pageCount = count % pagesize == 0 ? Integer.valueOf(count / pagesize) : Integer.valueOf(count / pagesize + 1);
        sumLab.setText(String.format(ResManager.loadKDString((String)"\u5171%s\u9875", (String)"AdjustEntryGridHelper_0", (String)"mmc-mrp-business", (Object[])new Object[0]), pageCount));
        if (pageIndex > pageCount) {
            pageIndex = pageCount;
            model.beginInit();
            model.setValue("pageindex", (Object)pageIndex);
            model.endInit();
            return;
        }
        model.deleteEntryData("entryentitys");
        model.beginInit();
        String cacheId = view.getPageCache().get("dataset_cache");
        if (StringUtils.isEmpty((CharSequence)cacheId)) {
            QFilter filterInfo = AdjustFilterHelper.getFilters(view);
            cacheId = AdjustSuggestHelper.bulidDataSetCache(filterInfo);
            view.getPageCache().put("dataset_cache", cacheId);
        }
        TableValueSetter vs = new TableValueSetter(new String[0]);
        count = AdjustSuggestHelper.loadDataByCache(cacheId, vs, 0, pageIndex, pagesize);
        view.getPageCache().put("count_cache", String.valueOf(count));
        model.batchCreateNewEntryRow("entryentitys", vs);
        model.endInit();
        view.updateView("entryentitys");
    }

    public static void toPageSize(IFormView view, AbstractFormDataModel model, int pagesize) {
        Integer pageCount = 0;
        String countStr = view.getPageCache().get("count_cache");
        int count = 0;
        if (StringUtils.isNotEmpty((CharSequence)countStr)) {
            count = Integer.parseInt(countStr);
        }
        pageCount = count % pagesize == 0 ? Integer.valueOf(count / pagesize) : Integer.valueOf(count / pagesize + 1);
        Label sumLab = (Label)view.getControl("sumlabelap");
        sumLab.setText(String.format(ResManager.loadKDString((String)"\u5171%s\u9875", (String)"AdjustEntryGridHelper_0", (String)"mmc-mrp-business", (Object[])new Object[0]), pageCount));
        model.deleteEntryData("entryentitys");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        String cacheId = view.getPageCache().get("dataset_cache");
        if (StringUtils.isNotEmpty((CharSequence)cacheId)) {
            count = AdjustSuggestHelper.loadDataByCache(cacheId, vs, 0, 1, pagesize);
            model.setValue("pageindex", (Object)1);
            view.getPageCache().put("count_cache", String.valueOf(count));
            model.batchCreateNewEntryRow("entryentitys", vs);
            model.endInit();
            view.updateView("entryentitys");
        }
    }
}

