/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.param.AppParam;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.mmc.mrp.business.helper.AdjustSuggestHelper;
import kd.mmc.mrp.business.vo.MaterialPlanVo;
import kd.mmc.mrp.business.vo.PurchaseOrderVo;

public class AdjustImportHelper {
    private static ORM orm = ORM.create();

    private AdjustImportHelper() {
    }

    public static Map<String, Map<String, String>> importData(List<Map<String, String>> dataList, DynamicObject calculateLog, Map<String, Integer> paramsMap, Map<String, DynamicObject> adjustMap, Map<String, DynamicObject> unReleaseMap) {
        HashMap<String, Map<String, String>> msgMap = new HashMap<String, Map<String, String>>(2);
        HashMap<String, String> errMsgMap = new HashMap<String, String>(dataList.size());
        HashMap<String, String> successMsgMap = new HashMap<String, String>(dataList.size());
        msgMap.put("errMsgMap", errMsgMap);
        msgMap.put("successMsgMap", successMsgMap);
        if (dataList.isEmpty()) {
            return msgMap;
        }
        ArrayList<DynamicObject> updateObjs = new ArrayList<DynamicObject>(dataList.size());
        ArrayList<DynamicObject> newObjs = new ArrayList<DynamicObject>(dataList.size());
        Map<String, PurchaseOrderVo> purOrderMap = AdjustImportHelper.getPurOrder(dataList, calculateLog);
        Map<Long, MaterialPlanVo> plannerMap = AdjustImportHelper.getPlanner(purOrderMap, calculateLog);
        Map<String, Long> operatorMap = AdjustImportHelper.getOperatorMap(dataList);
        Date currentTime = new Date();
        long userId = RequestContext.get().getCurrUserId();
        for (Map<String, String> data : dataList) {
            String billId = data.get("entryseq");
            if (!StringUtils.isEmpty((CharSequence)billId)) {
                AdjustImportHelper.updateDynamicObject(updateObjs, adjustMap, data, errMsgMap, successMsgMap, operatorMap, calculateLog);
                continue;
            }
            AdjustImportHelper.addDynamicObject(newObjs, data, errMsgMap, successMsgMap, calculateLog, purOrderMap, plannerMap, paramsMap, unReleaseMap, operatorMap, currentTime, userId);
        }
        AdjustImportHelper.executeBatchUpdate(updateObjs);
        AdjustImportHelper.executeBatchSave(newObjs);
        return msgMap;
    }

    private static Map<String, PurchaseOrderVo> getPurOrder(List<Map<String, String>> dataList, DynamicObject calculateLog) {
        HashMap<String, PurchaseOrderVo> purchaseMap = new HashMap<String, PurchaseOrderVo>();
        HashSet<String> duplicateSet = new HashSet<String>(dataList.size());
        Set<String> billSet = AdjustImportHelper.getBillSet(dataList, duplicateSet);
        long createorg = calculateLog.getLong("createorg");
        AppParam appParam = new AppParam("0MBBBZ1L5IAW", Long.valueOf(createorg));
        Map mrpParam = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        String adjustResource = "billentry.deliverdate";
        if (mrpParam.get("fieldtag") != null) {
            adjustResource = (String)mrpParam.get("fieldtag");
        }
        String adjustResourceName = ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6.\u4ea4\u8d27\u65e5\u671f", (String)"AdjustImportHelper_0", (String)"mmc-mrp-business", (Object[])new Object[0]);
        if (mrpParam.get("fieldname") != null) {
            adjustResourceName = (String)mrpParam.get("fieldname");
        }
        StringBuilder fields = new StringBuilder("id, billno, operator, supplier, billentry.id, billentry.seq seq, billentry.material.masterid, org, billentry.material.masterid.baseunit baseunit, billentry.baseqty qty, billentry.receivebaseqty receivebaseqty, billentry.auxpty auxpty, billentry.returnbaseqty returnbaseqty, billentry.configuredcode configuredcode, billentry.tracknumber tracknumber, billentry.project project ");
        fields.append(',').append(adjustResource);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"AdjustImportHelper", (String)"pm_purorderbill", (String)fields.toString(), (QFilter[])AdjustImportHelper.getPurOrderQFilters(billSet), null);){
            for (Row row : dataSet) {
                PurchaseOrderVo purchaseOrderVo = AdjustImportHelper.genpurchaseOrderVo(row, adjustResource);
                purchaseOrderVo.setAdjustResourceName(adjustResourceName);
                StringBuilder key = new StringBuilder();
                key.append(purchaseOrderVo.getBillNo()).append('-').append(purchaseOrderVo.getLineNo());
                if (duplicateSet.contains(key.toString())) {
                    purchaseOrderVo.setDuplicate(true);
                }
                purchaseMap.put(key.toString(), purchaseOrderVo);
            }
        }
        return purchaseMap;
    }

    private static Map<String, Long> getOperatorMap(List<Map<String, String>> dataList) {
        HashMap<String, Long> operatorMap = new HashMap<String, Long>();
        HashSet<String> operatorSet = new HashSet<String>(dataList.size());
        for (Map<String, String> data : dataList) {
            String operatorNum = data.get("schduler");
            operatorSet.add(operatorNum);
        }
        QFilter numFilter = new QFilter("number", "in", operatorSet);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"AdjustImportHelper", (String)"bos_user", (String)"id, number", (QFilter[])new QFilter[]{numFilter}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                long operatorId = row.getLong("id");
                String number = row.getString("number") == null ? "" : row.getString("number");
                if (operatorMap.get(number) != null) continue;
                operatorMap.put(number, operatorId);
            }
        }
        return operatorMap;
    }

    private static Map<Long, MaterialPlanVo> getPlanner(Map<String, PurchaseOrderVo> purOrderMap, DynamicObject calculateLog) {
        HashMap<Long, MaterialPlanVo> operatorMap = new HashMap<Long, MaterialPlanVo>();
        HashMap<Long, MaterialPlanVo> mustMaterialMap = new HashMap<Long, MaterialPlanVo>();
        HashSet<Long> materialIds = new HashSet<Long>(purOrderMap.size());
        for (Map.Entry<String, PurchaseOrderVo> entry : purOrderMap.entrySet()) {
            PurchaseOrderVo purchaseOrderVo = entry.getValue();
            materialIds.add(purchaseOrderVo.getMaterialId());
        }
        long createorg = calculateLog.getLong("createorg");
        QFilter qFilter = new QFilter("masterid", "in", materialIds);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"AdjustImportHeleper", (String)"mpdm_materialplan", (String)"id, masterid, operator, materialattr, createorg, ctrlstrategy", (QFilter[])new QFilter[]{qFilter}, null);){
            for (Row row : dataSet) {
                MaterialPlanVo currentMaterial;
                MaterialPlanVo material = new MaterialPlanVo();
                Long operator = 0L;
                if (row.get("operator") != null) {
                    operator = row.getLong("operator");
                }
                Long createOrg = 0L;
                if (row.get("createorg") != null) {
                    createOrg = row.getLong("createOrg");
                }
                material.setOperator(operator);
                String materialAttr = "";
                if (row.get("materialattr") != null) {
                    materialAttr = row.getString("materialattr");
                }
                material.setMaterialAttr(materialAttr);
                long masterid = row.getLong("masterid");
                String ctrlStragety = "";
                if (row.get("ctrlstrategy") != null) {
                    ctrlStragety = row.getString("ctrlstrategy");
                }
                if (createOrg == createorg) {
                    operatorMap.put(masterid, material);
                    mustMaterialMap.put(masterid, material);
                    continue;
                }
                if (mustMaterialMap.get(masterid) == null && operatorMap.get(masterid) == null && "5".equals(ctrlStragety)) {
                    operatorMap.put(masterid, material);
                    continue;
                }
                if (mustMaterialMap.get(masterid) != null || operatorMap.get(masterid) == null || !"5".equals(ctrlStragety) || (currentMaterial = (MaterialPlanVo)operatorMap.get(masterid)).getId() >= row.getLong("id")) continue;
                operatorMap.put(masterid, material);
            }
        }
        return operatorMap;
    }

    private static Set<String> getBillSet(List<Map<String, String>> dataList, Set<String> duplicateSet) {
        HashSet<String> billSet = new HashSet<String>(dataList.size());
        HashSet<String> lineSet = new HashSet<String>(dataList.size());
        for (Map<String, String> data : dataList) {
            String billType = data.get("billtype");
            String billId = data.get("entryseq");
            String billNo = data.get("billno");
            String lineNo = data.get("lineno");
            StringBuilder bill = new StringBuilder();
            bill.append(billNo).append('-').append(lineNo);
            if (lineSet.contains(bill.toString())) {
                duplicateSet.add(bill.toString());
            } else {
                lineSet.add(bill.toString());
            }
            if (!StringUtils.isEmpty((CharSequence)billId) || !ResManager.loadKDString((String)"\u91c7\u8d2d\u8ba2\u5355", (String)"AdjustImportHelper_1", (String)"mmc-mrp-business", (Object[])new Object[0]).equals(billType) || !StringUtils.isNotEmpty((CharSequence)billNo) || !StringUtils.isNotEmpty((CharSequence)lineNo)) continue;
            billSet.add(billNo);
        }
        return billSet;
    }

    public static QFilter[] getPurOrderQFilters(Set<String> billSet) {
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)Character.valueOf('C'));
        QFilter closeStatusFilter = new QFilter("closestatus", "=", (Object)Character.valueOf('A'));
        QFilter entryCloseStatusFilter = new QFilter("billentry.rowclosestatus", "=", (Object)Character.valueOf('A'));
        QFilter entryTeminateStatusFilter = new QFilter("billentry.rowterminatestatus", "=", (Object)Character.valueOf('A'));
        QFilter idFilter = new QFilter("billno", "in", billSet);
        return new QFilter[]{billStatusFilter, closeStatusFilter, entryCloseStatusFilter, entryTeminateStatusFilter, idFilter};
    }

    private static PurchaseOrderVo genpurchaseOrderVo(Row row, String adjustResource) {
        PurchaseOrderVo purchaseOrderVo = new PurchaseOrderVo();
        String billno = "";
        if (row.get("billno") != null) {
            billno = row.getString("billno");
        }
        purchaseOrderVo.setBillNo(billno);
        String lineNo = "";
        if (row.get("seq") != null) {
            lineNo = row.getString("seq");
        }
        purchaseOrderVo.setLineNo(lineNo);
        Long materialID = 0L;
        if (row.get("billentry.material.masterid") != null) {
            materialID = row.getLong("billentry.material.masterid");
        }
        purchaseOrderVo.setMaterialId(materialID);
        Long operator = 0L;
        if (row.get("operator") != null) {
            operator = row.getLong("operator");
        }
        purchaseOrderVo.setPurchaser(operator);
        Long supplier = 0L;
        if (row.get("supplier") != null) {
            supplier = row.getLong("supplier");
        }
        purchaseOrderVo.setSupplier(supplier);
        Long org = 0L;
        if (row.get("org") != null) {
            org = row.getLong("org");
        }
        purchaseOrderVo.setOrg(org);
        Date originDate = null;
        if (row.get(adjustResource) != null) {
            originDate = row.getDate(adjustResource);
        }
        purchaseOrderVo.setOriginDate(originDate);
        Long baseUnit = 0L;
        if (row.get("baseunit") != null) {
            baseUnit = row.getLong("baseunit");
        }
        purchaseOrderVo.setBaseunit(baseUnit);
        BigDecimal qty = BigDecimal.ZERO;
        if (row.get("qty") != null) {
            qty = row.getBigDecimal("qty");
        }
        BigDecimal receiveQty = BigDecimal.ZERO;
        if (row.get("receivebaseqty") != null) {
            receiveQty = row.getBigDecimal("receivebaseqty");
        }
        BigDecimal returnQty = BigDecimal.ZERO;
        if (row.get("returnbaseqty") != null) {
            returnQty = row.getBigDecimal("returnbaseqty");
        }
        if (qty.subtract(receiveQty).add(returnQty).compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal sxQty = qty.subtract(receiveQty).add(returnQty);
            purchaseOrderVo.setQty(sxQty);
        } else {
            purchaseOrderVo.setQty(BigDecimal.ZERO);
        }
        String billId = "";
        if (row.get("id") != null) {
            billId = row.getString("id");
        }
        purchaseOrderVo.setBillId(billId);
        String billEntryId = "";
        if (row.get("billentry.id") != null) {
            billEntryId = row.getString("billentry.id");
        }
        purchaseOrderVo.setBillEntryId(billEntryId);
        Long tracknumber = 0L;
        if (row.get("tracknumber") != null) {
            tracknumber = row.getLong("tracknumber");
        }
        purchaseOrderVo.setTracknumber(tracknumber);
        Long configuredcode = 0L;
        if (row.get("configuredcode") != null) {
            configuredcode = row.getLong("configuredcode");
        }
        purchaseOrderVo.setConfiguredcode(configuredcode);
        Long project = 0L;
        if (row.get("project") != null) {
            project = row.getLong("project");
        }
        purchaseOrderVo.setProject(project);
        long auxpty = 0L;
        if (row.get("auxpty") != null) {
            auxpty = row.getLong("auxpty");
        }
        purchaseOrderVo.setAuxpty(auxpty);
        purchaseOrderVo.setDuplicate(false);
        return purchaseOrderVo;
    }

    private static void executeBatchUpdate(List<DynamicObject> updateObjs) {
        if (!updateObjs.isEmpty()) {
            DynamicObject[] update = updateObjs.toArray(new DynamicObject[updateObjs.size()]);
            SaveServiceHelper.save((DynamicObject[])update);
        }
    }

    private static void executeBatchSave(List<DynamicObject> newObjs) {
        if (!newObjs.isEmpty()) {
            DynamicObject[] newObj = newObjs.toArray(new DynamicObject[newObjs.size()]);
            SaveServiceHelper.save((DynamicObject[])newObj);
        }
    }

    public static void addDynamicObject(List<DynamicObject> newObjs, Map<String, String> data, Map<String, String> errMsgMap, Map<String, String> successMsgMap, DynamicObject calculateLog, Map<String, PurchaseOrderVo> purOrderMap, Map<Long, MaterialPlanVo> plannerMap, Map<String, Integer> paramsMap, Map<String, DynamicObject> unReleaseMap, Map<String, Long> operatorMap, Date currentTime, long userId) {
        String billType = data.get("billtype");
        String rowIndex = data.get("rowNo");
        String billNo = data.get("billno");
        String lineNo = data.get("lineno");
        String planNum = data.get("plannum");
        String adjustReason = data.get("adjustcause");
        String operatorNum = data.get("schduler");
        int count = paramsMap.get("count");
        if (StringUtils.isEmpty((CharSequence)planNum)) {
            AdjustImportHelper.addNewErrorMsg(errMsgMap, rowIndex, ResManager.loadKDString((String)"\u8ba1\u5212\u8fd0\u7b97\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u65b0\u589e\u5bfc\u5165\u5931\u8d25\u3002", (String)"AdjustImportHelper_2", (String)"mmc-mrp-business", (Object[])new Object[0]));
            return;
        }
        if (!planNum.equals(calculateLog.getString("number"))) {
            AdjustImportHelper.addNewErrorMsg(errMsgMap, rowIndex, ResManager.loadKDString((String)"\u6b64\u6570\u636e\u7684\u8ba1\u5212\u8fd0\u7b97\u53f7\u4e0d\u4e3a\u8c03\u6574\u5efa\u8bae\u62a5\u8868\u8fc7\u6ee4\u6761\u4ef6\u4e0a\u7684\u8ba1\u5212\u8fd0\u7b97\u53f7\u3002", (String)"AdjustImportHelper_3", (String)"mmc-mrp-business", (Object[])new Object[0]));
            return;
        }
        if (!ResManager.loadKDString((String)"\u91c7\u8d2d\u8ba2\u5355", (String)"AdjustImportHelper_1", (String)"mmc-mrp-business", (Object[])new Object[0]).equals(billType)) {
            AdjustImportHelper.addNewErrorMsg(errMsgMap, rowIndex, ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u4e0d\u4e3a\u91c7\u8d2d\u8ba2\u5355\uff0c\u65b0\u589e\u5bfc\u5165\u5931\u8d25\u3002", (String)"AdjustImportHelper_4", (String)"mmc-mrp-business", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isEmpty((CharSequence)billNo)) {
            AdjustImportHelper.addNewErrorMsg(errMsgMap, rowIndex, ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u65b0\u589e\u5bfc\u5165\u5931\u8d25\u3002", (String)"AdjustImportHelper_5", (String)"mmc-mrp-business", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isEmpty((CharSequence)lineNo)) {
            AdjustImportHelper.addNewErrorMsg(errMsgMap, rowIndex, ResManager.loadKDString((String)"\u5355\u636e\u884c\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u65b0\u589e\u5bfc\u5165\u5931\u8d25\u3002", (String)"AdjustImportHelper_6", (String)"mmc-mrp-business", (Object[])new Object[0]));
            return;
        }
        StringBuilder key = new StringBuilder();
        key.append(billNo).append('-').append(lineNo);
        if (purOrderMap.get(key.toString()) == null) {
            String errorMessage = String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5355\u636e\u7f16\u53f7\u4e3a%1$s\uff0c\u884c\u53f7\u4e3a%2$s\u4e14\u5355\u636e\u72b6\u6001=\u5df2\u5ba1\u6838\u4e14\u5173\u95ed\u72b6\u6001=\u6b63\u5e38\u4e14\u884c\u7ec8\u6b62\u72b6\u6001=\u6b63\u5e38\u4e14\u884c\u5173\u95ed\u72b6\u6001=\u6b63\u5e38\u3002", (String)"AdjustImportHelper_9", (String)"mmc-mrp-business", (Object[])new Object[0]), billNo, lineNo);
            AdjustImportHelper.addNewErrorMsg(errMsgMap, rowIndex, errorMessage);
            return;
        }
        PurchaseOrderVo purchaseOrderVo = purOrderMap.get(key.toString());
        if (purchaseOrderVo.isDuplicate()) {
            AdjustImportHelper.addNewErrorMsg(errMsgMap, rowIndex, ResManager.loadKDString((String)"EXCEL\u4e2d\u5b58\u5728\u6709\u8be5\u91c7\u8d2d\u8ba2\u5355\u7f16\u53f7\u3001\u884c\u53f7\u91cd\u590d\u7684\u6570\u636e\u3002", (String)"AdjustImportHelper_10", (String)"mmc-mrp-business", (Object[])new Object[0]));
            return;
        }
        if (unReleaseMap.get(key.toString()) != null) {
            AdjustImportHelper.addNewErrorMsg(errMsgMap, rowIndex, ResManager.loadKDString((String)"\u6700\u65b0\u7684\u8ba1\u5212\u8fd0\u7b97\u53f7\u4e2d\u5df2\u7ecf\u5b58\u5728\u6709\u8be5\u6761\u672a\u91ca\u653e\u7684\u91c7\u8d2d\u8ba2\u5355\u6570\u636e\u5b58\u5728\u3002", (String)"AdjustImportHelper_11", (String)"mmc-mrp-business", (Object[])new Object[0]));
            return;
        }
        DynamicObject newObj = orm.newDynamicObject("mrp_adjustsuggest");
        newObj.set("id", (Object)orm.genLongId("mrp_adjustsuggest"));
        StringBuilder entrySeq = new StringBuilder(planNum);
        entrySeq.append('-').append(count);
        newObj.set("entryseq", (Object)entrySeq.toString());
        newObj.set("plannum", (Object)calculateLog.getLong("id"));
        newObj.set("supplyorg", (Object)purchaseOrderVo.getOrg());
        newObj.set("supplier", (Object)purchaseOrderVo.getSupplier());
        newObj.set("purchaser", (Object)purchaseOrderVo.getPurchaser());
        Long materialId = purchaseOrderVo.getMaterialId();
        newObj.set("materiel", (Object)materialId);
        long auxpty = 0L;
        if (purchaseOrderVo.getAuxpty() != null) {
            auxpty = purchaseOrderVo.getAuxpty();
        }
        newObj.set("auxprop", (Object)auxpty);
        newObj.set("baseunit", (Object)purchaseOrderVo.getBaseunit());
        if (StringUtils.isNotEmpty((CharSequence)operatorNum) && operatorMap.get(operatorNum) != null) {
            newObj.set("schduler", (Object)operatorMap.get(operatorNum));
        } else if ("".equals(operatorNum)) {
            newObj.set("schduler", (Object)0L);
        } else {
            String operatorError = String.format(ResManager.loadKDString((String)"\u5de5\u53f7\u4e3a%1$s\u7684\u8ba1\u5212\u5458\u4e0d\u5b58\u5728\u3002", (String)"AdjustImportHelper_12", (String)"mmc-mrp-business", (Object[])new Object[0]), operatorNum);
            AdjustImportHelper.addNewErrorMsg(errMsgMap, rowIndex, operatorError);
            return;
        }
        newObj.set("adjuststrategy", (Object)Character.valueOf('A'));
        newObj.set("materialattr", (Object)"10040");
        newObj.set("billtype", (Object)"pm_purorderbill");
        newObj.set("adjustcause", (Object)adjustReason);
        newObj.set("billno", (Object)billNo);
        newObj.set("lineno", (Object)lineNo);
        newObj.set("qty", (Object)purchaseOrderVo.getQty());
        if (purchaseOrderVo.getOriginDate() == null) {
            String dateError = String.format(ResManager.loadKDString((String)"\u91c7\u8d2d\u8ba2\u5355\u7f16\u7801\u4e3a%1$s\u7684\u6570\u636e\u7684%2$s\u5b57\u6bb5\u83b7\u53d6\u5230\u7684\u503c\u4e3a\u7a7a\u3002", (String)"AdjustImportHelper_13", (String)"mmc-mrp-business", (Object[])new Object[0]), billNo, purchaseOrderVo.getAdjustResourceName());
            AdjustImportHelper.addNewErrorMsg(errMsgMap, rowIndex, dateError);
            return;
        }
        Date originDate = AdjustSuggestHelper.getFormDate(purchaseOrderVo.getOriginDate(), "yyyy-MM-dd");
        newObj.set("createtime", (Object)currentTime);
        newObj.set("creator", (Object)userId);
        newObj.set("origindate", (Object)originDate);
        newObj.set("adjustdatetype", (Object)purchaseOrderVo.getAdjustResourceName());
        String adjustDateStr = data.get("adjustdate");
        Date adjustDate = null;
        if (StringUtils.isEmpty((CharSequence)adjustDateStr)) {
            newObj.set("adjustdate", null);
            newObj.set("adjustsuggest", (Object)Character.valueOf('0'));
        } else if (adjustDateStr.matches("[0-9]{4}[-][0-9]+[-][0-9]+")) {
            adjustDate = AdjustSuggestHelper.getFormDate(adjustDateStr, "yyyy-MM-dd");
        } else {
            AdjustImportHelper.addNewErrorMsg(errMsgMap, rowIndex, ResManager.loadKDString((String)"\u8c03\u6574\u53ef\u7528\u65e5\u671f\u683c\u5f0f\u4e0d\u7b26\u5408yyyy-MM-dd\u6216\u8005yyyy/MM/dd\u683c\u5f0f(\u6ce8\u610f\u5b9e\u9645\u503c\u5e94\u4e3a\u53d6\u6d88\u683c\u5f0f\u5316\u7684\u503c)\u3002", (String)"AdjustImportHelper_17", (String)"mmc-mrp-business", (Object[])new Object[0]));
            return;
        }
        if (adjustDate != null && adjustDate.compareTo(originDate) == 0) {
            AdjustImportHelper.addNewErrorMsg(errMsgMap, rowIndex, ResManager.loadKDString((String)"\u8c03\u6574\u53ef\u7528\u65e5\u671f\u4e0d\u53ef\u4ee5\u4e0e\u539f\u53ef\u7528\u65e5\u671f\u76f8\u7b49\u3002", (String)"AdjustImportHelper_18", (String)"mmc-mrp-business", (Object[])new Object[0]));
            return;
        }
        Date currentDate = AdjustSuggestHelper.getFormDate(new Date(), "yyyy-MM-dd");
        if (adjustDate != null && adjustDate.compareTo(currentDate) < 0) {
            AdjustImportHelper.addNewErrorMsg(errMsgMap, rowIndex, ResManager.loadKDString((String)"\u8c03\u6574\u53ef\u7528\u65e5\u671f\u4e0d\u53ef\u4ee5\u4e3a\u8fc7\u53bb\u3002", (String)"AdjustImportHelper_19", (String)"mmc-mrp-business", (Object[])new Object[0]));
            return;
        }
        if (adjustDate != null && adjustDate.compareTo(originDate) > 0) {
            newObj.set("adjustdate", (Object)adjustDate);
            newObj.set("adjustsuggest", (Object)Character.valueOf('1'));
        } else if (adjustDate != null) {
            newObj.set("adjustdate", (Object)adjustDate);
            newObj.set("adjustsuggest", (Object)Character.valueOf('2'));
        }
        newObj.set("releasestatus", (Object)Boolean.FALSE);
        newObj.set("billid", (Object)purchaseOrderVo.getBillId());
        newObj.set("lineid", (Object)purchaseOrderVo.getBillEntryId());
        if (purchaseOrderVo.getTracknumber() != null) {
            newObj.set("tracknumber", (Object)purchaseOrderVo.getTracknumber());
        }
        if (purchaseOrderVo.getConfiguredcode() != null) {
            newObj.set("configuredcode", (Object)purchaseOrderVo.getConfiguredcode());
        }
        if (purchaseOrderVo.getProject() != null) {
            newObj.set("project", (Object)purchaseOrderVo.getProject());
        }
        newObjs.add(newObj);
        paramsMap.put("count", ++count);
        AdjustImportHelper.addNewSuccessMsg(successMsgMap, rowIndex);
    }

    private static void updateDynamicObject(List<DynamicObject> updateObjs, Map<String, DynamicObject> adjustMap, Map<String, String> data, Map<String, String> errMsgMap, Map<String, String> successMsgMap, Map<String, Long> operatorMap, DynamicObject calculateLog) {
        String adjustDateStr = data.get("adjustdate");
        String adjustReason = data.get("adjustcause");
        String billId = data.get("entryseq");
        String operatorNum = data.get("schduler");
        String rowIndex = data.get("rowNo");
        if (adjustMap.get(billId) != null) {
            DynamicObject adjust = adjustMap.get(billId);
            long currentPlanId = adjust.getLong("plannum.id");
            if (currentPlanId != calculateLog.getLong("id")) {
                AdjustImportHelper.addErrorMsg(errMsgMap, rowIndex, ResManager.loadKDString((String)"\u6b64\u6570\u636e\u7684\u8ba1\u5212\u8fd0\u7b97\u53f7\u4e0d\u4e3a\u8c03\u6574\u5efa\u8bae\u62a5\u8868\u8fc7\u6ee4\u6761\u4ef6\u4e0a\u7684\u8ba1\u5212\u8fd0\u7b97\u53f7\u3002", (String)"AdjustImportHelper_3", (String)"mmc-mrp-business", (Object[])new Object[0]));
                return;
            }
            if (adjust.getBoolean("releasestatus")) {
                AdjustImportHelper.addErrorMsg(errMsgMap, rowIndex, ResManager.loadKDString((String)"\u6b64\u6570\u636e\u5df2\u7ecf\u88ab\u91ca\u653e\u3002", (String)"AdjustImportHelper_20", (String)"mmc-mrp-business", (Object[])new Object[0]));
                return;
            }
            if (adjustReason.length() > 500) {
                AdjustImportHelper.addErrorMsg(errMsgMap, rowIndex, ResManager.loadKDString((String)"\u6b64\u6570\u636e\u7684\u8c03\u6574\u539f\u56e0\u957f\u5ea6\u5927\u4e8e\u5b57\u7b26\u6700\u5927\u9650\u5236500\u3002", (String)"AdjustImportHelper_21", (String)"mmc-mrp-business", (Object[])new Object[0]));
                return;
            }
            if (StringUtils.isNotEmpty((CharSequence)operatorNum) && operatorMap.get(operatorNum) != null) {
                adjust.set("schduler", (Object)operatorMap.get(operatorNum));
            } else if ("".equals(operatorNum)) {
                adjust.set("schduler", (Object)0L);
            } else {
                String operatorError = String.format(ResManager.loadKDString((String)"\u5de5\u53f7\u4e3a%1$s\u7684\u8ba1\u5212\u5458\u4e0d\u5b58\u5728\u3002", (String)"AdjustImportHelper_12", (String)"mmc-mrp-business", (Object[])new Object[0]), operatorNum);
                AdjustImportHelper.addErrorMsg(errMsgMap, rowIndex, operatorError);
                return;
            }
            adjust.set("adjustcause", (Object)adjustReason);
            adjust.set("dealer", (Object)RequestContext.get().getCurrUserId());
            adjust.set("dealdate", (Object)new Date());
            if (StringUtils.isEmpty((CharSequence)adjustDateStr)) {
                adjust.set("adjustdate", null);
                adjust.set("adjustsuggest", (Object)Character.valueOf('0'));
                updateObjs.add(adjust);
                AdjustImportHelper.addSuccessMsg(successMsgMap, rowIndex);
            } else if (adjustDateStr.matches("[0-9]{4}[-][0-1]+[0-9]+[-]+[0-9]+[0-9]+")) {
                Date adjustDate = AdjustSuggestHelper.getFormDate(adjustDateStr, "yyyy-MM-dd");
                AdjustImportHelper.updateAdjustByDate(updateObjs, adjustDate, adjust, errMsgMap, successMsgMap, rowIndex);
            } else {
                AdjustImportHelper.addErrorMsg(errMsgMap, rowIndex, ResManager.loadKDString((String)"\u8c03\u6574\u53ef\u7528\u65e5\u671f\u683c\u5f0f\u4e0d\u7b26\u5408yyyy-MM-dd\u6216\u8005yyyy/MM/dd\u683c\u5f0f(\u6ce8\u610f\u5b9e\u9645\u503c\u5e94\u4e3a\u53d6\u6d88\u683c\u5f0f\u5316\u7684\u503c)\u3002", (String)"AdjustImportHelper_17", (String)"mmc-mrp-business", (Object[])new Object[0]));
            }
        } else {
            AdjustImportHelper.addErrorMsg(errMsgMap, rowIndex, ResManager.loadKDString((String)"\u6700\u65b0\u8ba1\u5212\u8fd0\u7b97\u53f7\u7684\u8c03\u6574\u5efa\u8bae\u4e2d\u4e0d\u5b58\u5728\u6b64\u884c\u53f7\u7684\u6570\u636e\u3002", (String)"AdjustImportHelper_22", (String)"mmc-mrp-business", (Object[])new Object[0]));
        }
    }

    private static void updateAdjustByDate(List<DynamicObject> updateObjs, Date adjustDate, DynamicObject adjust, Map<String, String> errMsgMap, Map<String, String> successMsgMap, String rowIndex) {
        if (adjustDate == null) {
            adjust.set("adjustsuggest", (Object)Character.valueOf('0'));
        } else if (AdjustImportHelper.getCheckedAdjustDate(adjustDate)) {
            Date originDate = AdjustSuggestHelper.getFormDate(adjust.getDate("origindate"), "yyyy-MM-dd");
            if (originDate == null) {
                AdjustImportHelper.addErrorMsg(errMsgMap, rowIndex, ResManager.loadKDString((String)"\u539f\u53ef\u7528\u65e5\u671f\u4e3a\u7a7a\u3002", (String)"AdjustImportHelper_23", (String)"mmc-mrp-business", (Object[])new Object[0]));
                return;
            }
            if (originDate != null && adjustDate.compareTo(originDate) > 0) {
                adjust.set("adjustsuggest", (Object)Character.valueOf('1'));
            } else if (originDate != null && adjustDate.compareTo(originDate) < 0) {
                adjust.set("adjustsuggest", (Object)Character.valueOf('2'));
            } else {
                AdjustImportHelper.addErrorMsg(errMsgMap, rowIndex, ResManager.loadKDString((String)"\u8c03\u6574\u53ef\u7528\u65e5\u671f\u4e3a\u8fc7\u53bb\u6216\u8005\u4e0e\u539f\u53ef\u7528\u65e5\u671f\u76f8\u7b49\u3002", (String)"AdjustImportHelper_24", (String)"mmc-mrp-business", (Object[])new Object[0]));
                return;
            }
            adjust.set("adjustdate", (Object)adjustDate);
        } else {
            AdjustImportHelper.addErrorMsg(errMsgMap, rowIndex, ResManager.loadKDString((String)"\u8c03\u6574\u53ef\u7528\u65e5\u671f\u4e3a\u8fc7\u53bb\u6216\u8005\u4e0e\u539f\u53ef\u7528\u65e5\u671f\u76f8\u7b49\u3002", (String)"AdjustImportHelper_24", (String)"mmc-mrp-business", (Object[])new Object[0]));
            return;
        }
        updateObjs.add(adjust);
        AdjustImportHelper.addSuccessMsg(successMsgMap, rowIndex);
    }

    private static void addSuccessMsg(Map<String, String> successMsgMap, String rowIndex) {
        successMsgMap.put(rowIndex, ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u5165\u4fee\u6539\u6210\u529f\u3002", (String)"AdjustImportHelper_25", (String)"mmc-mrp-business", (Object[])new Object[0]));
    }

    private static void addNewSuccessMsg(Map<String, String> successMsgMap, String rowIndex) {
        successMsgMap.put(rowIndex, ResManager.loadKDString((String)"\u6570\u636e\u65b0\u589e\u5bfc\u5165\u6210\u529f\u3002", (String)"AdjustImportHelper_26", (String)"mmc-mrp-business", (Object[])new Object[0]));
    }

    private static void addErrorMsg(Map<String, String> errMsgMap, String rowIndex, String errorMessage) {
        StringBuilder message = new StringBuilder();
        message.append(ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u5165\u4fee\u6539\u5931\u8d25\uff0c\u539f\u56e0: ", (String)"AdjustImportHelper_27", (String)"mmc-mrp-business", (Object[])new Object[0])).append(errorMessage);
        errMsgMap.put(rowIndex, message.toString());
    }

    private static void addNewErrorMsg(Map<String, String> errMsgMap, String rowIndex, String errorMessage) {
        StringBuilder message = new StringBuilder();
        message.append(ResManager.loadKDString((String)"\u6570\u636e\u65b0\u589e\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0: ", (String)"AdjustImportHelper_28", (String)"mmc-mrp-business", (Object[])new Object[0])).append(errorMessage);
        errMsgMap.put(rowIndex, message.toString());
    }

    private static boolean getCheckedAdjustDate(Date adjustDate) {
        Date currentDate = AdjustSuggestHelper.getFormDate(new Date(), "yyyy-MM-dd");
        return adjustDate.compareTo(currentDate) >= 0;
    }
}

