/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.business.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class PlanViewOrgHelper {
    public static Set<Long> getOrgIdsByPlanView() {
        HashSet<Long> idSet = new HashSet<Long>();
        QFilter viewfilter = new QFilter("view", "=", (Object)914427355726916608L);
        QFilter ctrlfilter = new QFilter("isctrlunit", "=", (Object)Boolean.TRUE);
        String selectProperties = "org,isctrlunit";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"PlanViewOrgHelper", (String)"bos_org_structure", (String)selectProperties, (QFilter[])new QFilter[]{viewfilter, ctrlfilter}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                long id = row.getLong("org");
                idSet.add(id);
            }
        }
        return idSet;
    }

    public static void setPlanViewOrgFilter(CommonFilterColumn columnFilter, String entity, String appId) {
        CacheFactory cache = CacheFactory.getCommonCacheFactory();
        Set orgIds = null;
        String accountId = RequestContext.get().getAccountId();
        if (cache.getDistributeSessionlessCache().get("Plan_Org_" + accountId, "PlanViewOrgHelper") != null) {
            String string = (String)cache.getDistributeSessionlessCache().get("Plan_Org_" + accountId, "PlanViewOrgHelper");
            orgIds = (Set)SerializationUtils.fromJsonString((String)string, Set.class);
        } else {
            orgIds = PlanViewOrgHelper.getOrgIdsByPlanView();
            cache.getDistributeSessionlessCache().put("Plan_Org_" + accountId, "PlanViewOrgHelper", SerializationUtils.toJsonString(orgIds), 600);
        }
        Long uid = RequestContext.get().getCurrUserId();
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)uid, (String)BizAppServiceHelp.getAppIdByAppNumber((String)appId), (String)entity, (String)"47150e89000000ac");
        columnFilter.getComboItems().clear();
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
        List<QFilter> qfilters = PlanViewOrgHelper.getQF(result);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter pkFilter = new QFilter("id", "in", (Object)orgIds);
        qfilters.add(enableFilter);
        qfilters.add(pkFilter);
        HashMap orgMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (QFilter[])qfilters.toArray(new QFilter[0]));
        if (orgMap == null) {
            orgMap = new HashMap(0);
        }
        ArrayList<Object> orgPks = new ArrayList<Object>(orgMap.size());
        for (DynamicObject org2 : orgMap.values()) {
            Object orgPk = org2.getPkValue();
            orgPks.add(orgPk);
            comboItems.add(new ComboItem(new LocaleString(org2.getLocaleString("name").toString()), orgPk.toString()));
        }
        columnFilter.setComboItems(comboItems);
        ArrayList<String> defaultOrg = new ArrayList<String>();
        long currentOrgId = RequestContext.get().getOrgId();
        boolean match = orgPks.stream().map(org -> Long.valueOf(org.toString())).anyMatch(org -> org.equals(currentOrgId));
        if (!match && !ObjectUtils.isEmpty(orgPks)) {
            defaultOrg.add(String.valueOf(orgPks.get(0)));
        } else {
            defaultOrg.add(String.valueOf(currentOrgId));
        }
        columnFilter.setDefaultValues(defaultOrg);
    }

    public static List<QFilter> getQF(HasPermOrgResult result) {
        ArrayList<Object> qfilters = new ArrayList<QFilter>(2);
        if (!result.hasAllOrgPerm()) {
            qfilters = new ArrayList(3);
            QFilter permFilter = new QFilter("id", "in", (Object)result.getHasPermOrgs());
            qfilters.add(permFilter);
        }
        return qfilters;
    }
}

