/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.business.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.BillStatus;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.mmc.mrp.business.helper.XPlanOrderChangeLoghelper;
import kd.mmc.mrp.common.consts.PlanOrderConst;
import kd.mmc.mrp.common.consts.XPlanOrderLogConst;
import kd.mmc.mrp.common.enums.MaterialAttrEnum;
import kd.mpscmm.msplan.mrp.business.helper.PlanOrderHelper;

public class XPlanOrderChangehelper {
    private static final Log log = LogFactory.getLog(XPlanOrderChangehelper.class);

    public static Boolean judgeIsSplit(String changeType, BigDecimal orderQty, BigDecimal changeQty, BigDecimal dropQty) {
        boolean isSplit = false;
        switch (changeType) {
            case "A": 
            case "B": 
            case "D": {
                if (changeQty.compareTo(orderQty) >= 0 && dropQty.compareTo(BigDecimal.ZERO) <= 0) break;
                isSplit = true;
                break;
            }
        }
        return isSplit;
    }

    public static void dealChangePlanOrder(DynamicObject planorderChangeBill, DynamicObject planOrder, DynamicObject xplanorderLog, Map<Long, DynamicObject> planOrderMap, MainEntityType planorderType) {
        BigDecimal orderQty = planOrder.getBigDecimal("orderqty");
        BigDecimal dropQty = planOrder.getBigDecimal("dropqty");
        BigDecimal changeQty = planorderChangeBill.getBigDecimal("changeqty");
        String changetype = planorderChangeBill.getString("changetype");
        Boolean isSplit = XPlanOrderChangehelper.judgeIsSplit(changetype, orderQty.subtract(dropQty), changeQty, dropQty);
        Boolean isSplitOrder = false;
        log.info(ResManager.loadKDString((String)"\u5904\u7406\u8c03\u6574\u5efa\u8bae\u91ca\u653e\u4e0b\u6e38\u5355\u636e", (String)"XPlanOrderChangehelper_0", (String)"mmc-mrp-business", (Object[])new Object[0]));
        XPlanOrderChangeLoghelper.dealXPlanOrderChangeLog("B", xplanorderLog, planorderChangeBill);
        XPlanOrderChangehelper.dealPlanOrder(planOrder, planorderChangeBill, planOrderMap, xplanorderLog, planorderType, isSplit, isSplitOrder);
    }

    private static void dealPlanOrder(DynamicObject planOrder, DynamicObject planorderChangeBill, Map<Long, DynamicObject> planOrderMap, DynamicObject xplanorderLog, MainEntityType planorderType, Boolean isSplit, Boolean isSplitOrder) {
        String changetype = planorderChangeBill.getString("changetype");
        Map xPlanOrderMap = XPlanOrderLogConst.getXPlanLogMap((String)changetype);
        DynamicObject newPlanOrder = null;
        if (isSplitOrder.booleanValue()) {
            newPlanOrder = (DynamicObject)OrmUtils.clone((Object)planOrder, (IDataEntityType)planorderType, (boolean)true, (boolean)true);
            Long newPlanOrderId = DB.genLongId((String)planorderType.getAlias());
            newPlanOrder.set("id", (Object)newPlanOrderId);
            String orgId = newPlanOrder.getDynamicObject(planorderType.getMainOrg()).getString("id");
            String number = CodeRuleServiceHelper.getNumber((String)planorderType.getName(), (DynamicObject)newPlanOrder, (String)orgId);
            if (number == null) {
                number = UUID.randomUUID().toString().substring(0, 30);
            }
            newPlanOrder.set("billno", (Object)number);
            newPlanOrder.set("dropqty", (Object)BigDecimal.ZERO);
            newPlanOrder.set("dropstatus", (Object)PlanOrderConst.DropStatusEnum.A.name());
            newPlanOrder.set("droptime", null);
            PlanOrderHelper.dealDropRequireqty((DynamicObject)newPlanOrder, (BigDecimal)BigDecimal.ZERO);
            planOrderMap.put(newPlanOrderId, newPlanOrder);
        } else {
            newPlanOrder = planOrder;
        }
        xplanorderLog.set("changestatus", (Object)"B");
        DynamicObject xPlanOrderLogEntry = XPlanOrderChangeLoghelper.getXPlanOrderLogEntry(newPlanOrder, xplanorderLog, isSplitOrder);
        XPlanOrderChangehelper.dealChangeData(newPlanOrder, planorderChangeBill, xPlanOrderLogEntry, xPlanOrderMap, isSplit, isSplitOrder);
        if (isSplit.booleanValue() && !isSplitOrder.booleanValue()) {
            XPlanOrderChangehelper.dealPlanOrder(planOrder, planorderChangeBill, planOrderMap, xplanorderLog, planorderType, isSplit, true);
        }
    }

    private static void dealChangeData(DynamicObject newPlanOrder, DynamicObject planorderChangeBill, DynamicObject xPlanOrderLogEntry, Map<String, String> xPlanOrderMap, Boolean isSplit, Boolean isSplitOrder) {
        XPlanOrderChangeLoghelper.xPlanOrderChangeLogchangeEntry(xPlanOrderLogEntry, planorderChangeBill, newPlanOrder, isSplit, isSplitOrder);
        String changetype = planorderChangeBill.getString("changetype");
        BigDecimal oldOrderQty = newPlanOrder.getBigDecimal("orderqty");
        Map xPlanLogValue = XPlanOrderLogConst.getXPlanLogValue((String)changetype);
        for (Map.Entry<String, String> xPlanLogEntry : xPlanOrderMap.entrySet()) {
            String srcValueTag = xPlanLogEntry.getValue();
            String changeValueTag = xPlanLogEntry.getKey();
            Boolean isChange = (Boolean)xPlanLogValue.get(changeValueTag);
            if (!isChange.booleanValue()) continue;
            Object changeValue = planorderChangeBill.get(changeValueTag);
            Object srcValue = newPlanOrder.get(srcValueTag);
            srcValue = XPlanOrderChangehelper.dealSrcValue(srcValue, changeValue, isSplit, isSplitOrder, changetype);
            newPlanOrder.set(srcValueTag, srcValue);
        }
        DynamicObject materialPlan = newPlanOrder.getDynamicObject("materialplanid");
        DynamicObject supplyOrg = newPlanOrder.getDynamicObject("proorpurorg");
        XPlanOrderChangehelper.dealStatus(newPlanOrder, changetype, oldOrderQty);
        XPlanOrderChangehelper.dealAvailableDate(newPlanOrder, materialPlan, supplyOrg);
        XPlanOrderChangeLoghelper.xPlanOrderChangeLog(xPlanOrderLogEntry, newPlanOrder);
        XPlanOrderChangehelper.recalCulation(newPlanOrder, materialPlan, supplyOrg, oldOrderQty);
    }

    private static void recalCulation(DynamicObject newPlanOrder, DynamicObject materialPlan, DynamicObject supplyOrg, BigDecimal oldOrderQty) {
        String materialattr = newPlanOrder.getString("materialattr");
        BigDecimal newOrderQty = newPlanOrder.getBigDecimal("orderqty");
        BigDecimal yield = newPlanOrder.getBigDecimal("yield");
        newPlanOrder.set("endproqty", (Object)newOrderQty.multiply(yield));
        DynamicObjectCollection planOrderEntrys = newPlanOrder.getDynamicObjectCollection("entryentity");
        if (planOrderEntrys != null && !planOrderEntrys.isEmpty()) {
            for (int j = 0; j < planOrderEntrys.size(); ++j) {
                DynamicObject planOrderEntry = (DynamicObject)planOrderEntrys.get(j);
                XPlanOrderChangehelper.recalCulationDate(planOrderEntry, newPlanOrder, materialattr, supplyOrg);
                DynamicObject entryreplaceplan = planOrderEntry.getDynamicObject("entryreplaceplan");
                BigDecimal entryrequireqty = planOrderEntry.getBigDecimal("entryrequireqty");
                if (entryreplaceplan != null && BigDecimal.ZERO.compareTo(entryrequireqty) == 0) continue;
                PlanOrderHelper.recalCulationQty((DynamicObject)planOrderEntry, (DynamicObject)newPlanOrder, (DynamicObject)planOrderEntry, (int)j, (BigDecimal)newOrderQty, (BigDecimal)oldOrderQty);
            }
        }
        DynamicObjectCollection copEntrys = newPlanOrder.getDynamicObjectCollection("copentry");
        PlanOrderHelper.recalCulationCopentrysQty((DynamicObjectCollection)copEntrys, (BigDecimal)newOrderQty);
    }

    private static void recalCulationDate(DynamicObject planOrderEntry, DynamicObject planOrder, String materialattr, DynamicObject supplyOrg) {
        Date date = null;
        if (!MaterialAttrEnum.PURCHASEDPART.getValue().equals(materialattr)) {
            date = XPlanOrderChangehelper.getRecentWorkDate(planOrder.getDate("startdate"), supplyOrg);
        }
        if (date == null) {
            date = planOrder.getDate("startdate");
        }
        Integer leadtime = planOrderEntry.getInt("entryleadtime");
        Date reqDate = PlanOrderHelper.getReqDate((Date)date, (Integer)leadtime, (Long)supplyOrg.getLong("id"), (String)materialattr);
        planOrderEntry.set("entryrequiredate", (Object)reqDate);
    }

    private static void dealAvailableDate(DynamicObject newPlanOrder, DynamicObject materialPlan, DynamicObject supplyOrg) {
        Date oldavailableDate = newPlanOrder.getDate("availabledate");
        if (oldavailableDate == null) {
            return;
        }
        Date startDate = null;
        Date orderDate = null;
        Date endDate = null;
        if (supplyOrg == null || materialPlan == null) {
            newPlanOrder.set("orderdate", (Object)oldavailableDate);
            newPlanOrder.set("startdate", (Object)oldavailableDate);
            newPlanOrder.set("enddate", (Object)oldavailableDate);
            return;
        }
        Long supplyOrgId = supplyOrg.getLong("id");
        String materialattr = materialPlan.getString("materialattr");
        Date newavailableDate = null;
        if (!MaterialAttrEnum.PURCHASEDPART.getValue().equals(materialattr)) {
            newavailableDate = XPlanOrderChangehelper.getRecentWorkDate(oldavailableDate, supplyOrg);
        }
        if (newavailableDate != null) {
            oldavailableDate = newavailableDate;
        }
        newPlanOrder.set("availabledate", (Object)oldavailableDate);
        BigDecimal testleadtime = materialPlan.getBigDecimal("inspectionleadtime");
        BigDecimal postprocessingtime = materialPlan.getBigDecimal("postprocessingtime");
        int days = testleadtime.add(postprocessingtime).setScale(0, 0).intValue();
        endDate = PlanOrderHelper.getToWorkDateToLastDate((int)(-days), (Date)oldavailableDate, (Long)supplyOrgId, (String)materialattr);
        if (endDate == null) {
            endDate = PlanOrderHelper.getDate((Date)oldavailableDate, (int)(-days));
        }
        newPlanOrder.set("enddate", (Object)endDate);
        String leadtimetype = materialPlan.getString("leadtimetype");
        BigDecimal fixedleadtime = materialPlan.getBigDecimal("fixedleadtime");
        BigDecimal changeleadtime = materialPlan.getBigDecimal("changeleadtime");
        BigDecimal changebatchqty = materialPlan.getBigDecimal("changebatch");
        BigDecimal leadtime = BigDecimal.ZERO;
        if (StringUtils.equalsIgnoreCase((CharSequence)"A", (CharSequence)leadtimetype)) {
            leadtime = fixedleadtime;
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"B", (CharSequence)leadtimetype)) {
            BigDecimal orderqty = newPlanOrder.getBigDecimal("orderqty");
            leadtime = orderqty.multiply(changeleadtime).divide(changebatchqty, RoundingMode.UP);
        }
        days = leadtime.setScale(0, 0).intValue();
        startDate = PlanOrderHelper.getToWorkDateToDate((int)(-days), (Date)endDate, (Long)supplyOrgId, (String)materialattr);
        if (startDate == null) {
            startDate = PlanOrderHelper.getDate((Date)endDate, (int)(-days));
        }
        newPlanOrder.set("startdate", (Object)startDate);
        BigDecimal preprocessingtime = materialPlan.getBigDecimal("preprocessingtime");
        days = preprocessingtime.setScale(0, 0).intValue();
        orderDate = PlanOrderHelper.getToWorkDateToDate((int)(-days), (Date)startDate, (Long)supplyOrgId, (String)materialattr);
        if (orderDate == null) {
            orderDate = PlanOrderHelper.getDate((Date)startDate, (int)(-days));
        }
        newPlanOrder.set("orderdate", (Object)orderDate);
    }

    private static Date getRecentWorkDate(Date date, DynamicObject dept) {
        if (date == null) {
            return null;
        }
        Set calendarIds = PlanOrderHelper.getCalendarIds((Long)dept.getLong("id"));
        if (calendarIds == null || calendarIds.isEmpty()) {
            return null;
        }
        Date workDate = PlanOrderHelper.getRecentWorkDate((Date)date, (Long)dept.getLong("id"));
        return workDate;
    }

    private static void dealStatus(DynamicObject newPlanOrder, String changetype, BigDecimal oldOrderQty) {
        BigDecimal orderQty = newPlanOrder.getBigDecimal("orderqty");
        BigDecimal dropQty = newPlanOrder.getBigDecimal("dropqty");
        String dropstatus = PlanOrderConst.DropStatusEnum.A.name();
        String billStatus = BillStatus.C.name();
        if (orderQty.compareTo(dropQty) == 0 && orderQty.compareTo(BigDecimal.ZERO) > 0) {
            billStatus = "D";
            dropstatus = PlanOrderConst.DropStatusEnum.D.name();
        } else if (orderQty.compareTo(dropQty) > 0 && dropQty.compareTo(BigDecimal.ZERO) > 0) {
            dropstatus = PlanOrderConst.DropStatusEnum.C.name();
        } else if ("C".equals(changetype) && orderQty.compareTo(BigDecimal.ZERO) == 0) {
            billStatus = "D";
        }
        newPlanOrder.set("billstatus", (Object)billStatus);
        newPlanOrder.set("dropstatus", (Object)dropstatus);
    }

    private static Object dealSrcValue(Object srcValue, Object changeValue, Boolean isSplit, Boolean isSplitOrder, String changetype) {
        Object result = null;
        if (srcValue == null && changeValue == null) {
            return result;
        }
        if (changeValue instanceof BigDecimal && srcValue instanceof BigDecimal) {
            result = !"C".equals(changetype) && ((BigDecimal)srcValue).compareTo((BigDecimal)changeValue) == 0 || isSplitOrder != false ? changeValue : ((BigDecimal)srcValue).subtract((BigDecimal)changeValue);
            return result;
        }
        result = isSplit == false || isSplitOrder != false ? changeValue : srcValue;
        return result;
    }
}

