/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.business.synnetchange;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.OpBizRuleSetServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.ExceptionUtils;
import kd.mmc.mrp.common.consts.InitDataConst;

public class NetChangeSynHelper {
    private static final Log log = LogFactory.getLog(NetChangeSynHelper.class);
    private static Map<Long, Long> reserveToNetChangeGroupMap = new HashMap<Long, Long>(16);

    public static void addServiceMap(String entity, Map<String, Map<Long, Set<String>>> initOperateMap, String service) {
        Map map = initOperateMap.getOrDefault(entity, new HashMap(16));
        Map<Long, Set<String>> serviceMap = NetChangeSynHelper.genNetChangeServiceMap(service);
        for (Map.Entry<Long, Set<String>> serviceEntry : serviceMap.entrySet()) {
            Long serviceKey = serviceEntry.getKey();
            map.put(serviceKey, serviceEntry.getValue());
        }
        initOperateMap.put(entity, map);
    }

    public static Map<String, Map<Long, Set<String>>> getInitMap() {
        HashMap<String, Map<Long, Set<String>>> initOperateMap = new HashMap<String, Map<Long, Set<String>>>(16);
        NetChangeSynHelper.addServiceMap("pm_purapplybill", initOperateMap, "MMCNetChangeTransferService");
        NetChangeSynHelper.addServiceMap("pm_purorderbill", initOperateMap, "MMCNetChangeTransferService");
        NetChangeSynHelper.addServiceMap("pom_mftorder", initOperateMap, "MMCNetChangeTransferService");
        NetChangeSynHelper.addServiceMap("om_mftorder", initOperateMap, "MMCNetChangeTransferService");
        NetChangeSynHelper.addServiceMap("pm_om_purorderbill", initOperateMap, "MMCNetChangeTransferService");
        NetChangeSynHelper.addServiceMap("pom_mftstock", initOperateMap, "MMCNetChangeTransferService");
        NetChangeSynHelper.addServiceMap("om_mftstock", initOperateMap, "MMCNetChangeTransferService");
        NetChangeSynHelper.addServiceMap("sm_salorder", initOperateMap, "MMCNetChangeDeleteService");
        NetChangeSynHelper.addServiceMap("mrp_planorder", initOperateMap, "MMCNetChangeDeleteService");
        NetChangeSynHelper.addServiceMap("pm_purapplybill", initOperateMap, "MMCNetChangeDeleteService");
        NetChangeSynHelper.addServiceMap("pm_purorderbill", initOperateMap, "MMCNetChangeDeleteService");
        NetChangeSynHelper.addServiceMap("pom_mftorder", initOperateMap, "MMCNetChangeDeleteService");
        NetChangeSynHelper.addServiceMap("om_mftorder", initOperateMap, "MMCNetChangeDeleteService");
        NetChangeSynHelper.addServiceMap("pm_om_purorderbill", initOperateMap, "MMCNetChangeDeleteService");
        NetChangeSynHelper.addServiceMap("pom_mftstock", initOperateMap, "MMCNetChangeDeleteService");
        NetChangeSynHelper.addServiceMap("om_mftstock", initOperateMap, "MMCNetChangeDeleteService");
        NetChangeSynHelper.addServiceMap("mrp_collaborativeorder", initOperateMap, "MMCNetChangeDeleteService");
        NetChangeSynHelper.addServiceMap("im_materialreqoutbill", initOperateMap, "MMCAutoNetChangeReleaseService");
        NetChangeSynHelper.addServiceMap("im_transoutbill", initOperateMap, "MMCAutoNetChangeReleaseService");
        NetChangeSynHelper.addServiceMap("im_transdirbill", initOperateMap, "MMCAutoNetChangeReleaseService");
        NetChangeSynHelper.addServiceMap("im_otheroutbill", initOperateMap, "MMCAutoNetChangeReleaseService");
        NetChangeSynHelper.addServiceMap("im_purinbill", initOperateMap, "MMCAutoNetChangeReleaseService");
        NetChangeSynHelper.addServiceMap("im_mdc_mftmanuinbill", initOperateMap, "MMCAutoNetChangeReleaseService");
        NetChangeSynHelper.addServiceMap("im_saloutbill", initOperateMap, "MMCAutoNetChangeReleaseService");
        NetChangeSynHelper.addServiceMap("im_mdc_mftproorder", initOperateMap, "MMCAutoNetChangeReleaseService");
        NetChangeSynHelper.addServiceMap("im_productinbill", initOperateMap, "MMCAutoNetChangeReleaseService");
        NetChangeSynHelper.addServiceMap("im_mdc_omoutbill", initOperateMap, "MMCAutoNetChangeReleaseService");
        NetChangeSynHelper.addServiceMap("im_mdc_omcmplinbill", initOperateMap, "MMCAutoNetChangeReleaseService");
        NetChangeSynHelper.addServiceMap("im_materialreqoutbill", initOperateMap, "MMCAutoNetChangeURService");
        NetChangeSynHelper.addServiceMap("im_transoutbill", initOperateMap, "MMCAutoNetChangeURService");
        NetChangeSynHelper.addServiceMap("im_transdirbill", initOperateMap, "MMCAutoNetChangeURService");
        NetChangeSynHelper.addServiceMap("im_otheroutbill", initOperateMap, "MMCAutoNetChangeURService");
        NetChangeSynHelper.addServiceMap("im_purinbill", initOperateMap, "MMCAutoNetChangeURService");
        NetChangeSynHelper.addServiceMap("im_mdc_mftmanuinbill", initOperateMap, "MMCAutoNetChangeURService");
        NetChangeSynHelper.addServiceMap("im_saloutbill", initOperateMap, "MMCAutoNetChangeURService");
        NetChangeSynHelper.addServiceMap("im_mdc_mftproorder", initOperateMap, "MMCAutoNetChangeURService");
        NetChangeSynHelper.addServiceMap("im_productinbill", initOperateMap, "MMCAutoNetChangeURService");
        NetChangeSynHelper.addServiceMap("im_mdc_omoutbill", initOperateMap, "MMCAutoNetChangeURService");
        NetChangeSynHelper.addServiceMap("im_mdc_omcmplinbill", initOperateMap, "MMCAutoNetChangeURService");
        NetChangeSynHelper.addServiceMap("sm_salorder", initOperateMap, "MMCAutoNetChangeAlterService");
        NetChangeSynHelper.addServiceMap("mrp_planorder", initOperateMap, "MMCAutoNetChangeAlterService");
        NetChangeSynHelper.addServiceMap("pm_purapplybill", initOperateMap, "MMCAutoNetChangeAlterService");
        NetChangeSynHelper.addServiceMap("pm_purorderbill", initOperateMap, "MMCAutoNetChangeAlterService");
        NetChangeSynHelper.addServiceMap("pom_mftorder", initOperateMap, "MMCAutoNetChangeAlterService");
        NetChangeSynHelper.addServiceMap("om_mftorder", initOperateMap, "MMCAutoNetChangeAlterService");
        NetChangeSynHelper.addServiceMap("pm_om_purorderbill", initOperateMap, "MMCAutoNetChangeAlterService");
        NetChangeSynHelper.addServiceMap("pom_mftstock", initOperateMap, "MMCAutoNetChangeAlterService");
        NetChangeSynHelper.addServiceMap("om_mftstock", initOperateMap, "MMCAutoNetChangeAlterService");
        NetChangeSynHelper.addServiceMap("mrp_collaborativeorder", initOperateMap, "MMCAutoNetChangeAlterService");
        return initOperateMap;
    }

    public static Map<String, Set<String>> getEntityMap(Map<String, Map<Long, Set<String>>> initOperateMap) {
        HashMap<String, Set<String>> entityOperatesMap = new HashMap<String, Set<String>>(initOperateMap.size());
        for (Map.Entry<String, Map<Long, Set<String>>> entry : initOperateMap.entrySet()) {
            String entity = entry.getKey();
            HashSet<String> operates = new HashSet<String>(16);
            Map<Long, Set<String>> groupMap = entry.getValue();
            for (Map.Entry<Long, Set<String>> groupEntry : groupMap.entrySet()) {
                Set<String> groupSets = groupEntry.getValue();
                if (groupSets == null || groupSets.isEmpty()) continue;
                operates.addAll(groupSets);
            }
            entityOperatesMap.put(entity, operates);
        }
        return entityOperatesMap;
    }

    public static Map<Long, Set<String>> genNetChangeServiceMap(String groupNumber) {
        HashMap<Long, Set<String>> groupMap = new HashMap<Long, Set<String>>(16);
        HashSet<String> operateSet = new HashSet<String>(2);
        switch (groupNumber) {
            case "MMCAutoNetChangeService": {
                operateSet.add("audit");
                groupMap.put(1449295078882279424L, operateSet);
                break;
            }
            case "MMCUnAutoNetChangeService": {
                operateSet.add("unaudit");
                groupMap.put(1483441778274144256L, operateSet);
                break;
            }
            case "MMCNetChangeTransferService": {
                operateSet.add("save");
                operateSet.add("submit");
                groupMap.put(1473815168164041728L, operateSet);
                break;
            }
            case "MMCNetChangeDeleteService": {
                operateSet.add("delete");
                groupMap.put(1478088711852794880L, operateSet);
                break;
            }
            case "MMCAutoNetChangeReleaseService": {
                operateSet.add("audit");
                groupMap.put(1458558020899387392L, operateSet);
                break;
            }
            case "MMCAutoNetChangeURService": {
                operateSet.add("unaudit");
                groupMap.put(1458671999063711744L, operateSet);
                break;
            }
            case "MMCAutoNetChangeAlterService": {
                operateSet.add("save");
                operateSet.add("submit");
                groupMap.put(1500600508618921984L, operateSet);
                break;
            }
        }
        return groupMap;
    }

    public static void doNetChangeSynWork() {
        ThreadPools.executeOnce((String)"syncReserveDatas", () -> {
            QFilter typeFilter = new QFilter("change_type", "=", (Object)Character.valueOf('0'));
            QFilter resourceFilter = new QFilter("reservesource", "!=", (Object)"MRP");
            DeleteServiceHelper.delete((String)"msplan_net_change_record", (QFilter[])new QFilter[]{typeFilter, resourceFilter});
            HashSet<Long> alreadyExistsIds = new HashSet<Long>(16);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)NetChangeSynHelper.class.getName(), (String)"msplan_net_change_record", (String)"id", null, null);){
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    alreadyExistsIds.add(row.getLong("id"));
                }
            }
            QFilter idFilter = new QFilter("id", "not in", alreadyExistsIds);
            NetChangeSynHelper.syncReserveDatas(new QFilter[]{typeFilter, resourceFilter}, new QFilter[]{idFilter});
        });
        ThreadPools.executeOnce((String)"syncCfgDatas", () -> {
            QFilter statusFilter = new QFilter("status", "=", (Object)Character.valueOf('C'));
            QFilter groupFilter = new QFilter("group", "in", (Object)new Long[]{1402037881861730304L, 1402139266611416064L, 1402139420131331072L, 1402139574834039808L, 1402856110217534464L});
            NetChangeSynHelper.syncCfgDatas(new QFilter[]{statusFilter}, new QFilter[]{groupFilter}, true);
        });
    }

    public static List<Object[]> syncReserveDatas(QFilter[] deleteQFilter, QFilter[] recordFilter) {
        try {
            DeleteServiceHelper.delete((String)"msplan_net_change_record", (QFilter[])deleteQFilter);
            String insertSql = NetChangeSynHelper.getInsertSql(InitDataConst.insertFields, "t_msplan_change_record");
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(InitDataConst.insertFields.length);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)NetChangeSynHelper.class.getName(), (String)"msmod_reserve_record", (String)String.join((CharSequence)", ", InitDataConst.selectFields), (QFilter[])recordFilter, null);){
                Field[] fields = dataSet.getRowMeta().getFields();
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    ArrayList<Object> param = new ArrayList<Object>(InitDataConst.insertFields.length);
                    for (Field field : fields) {
                        param.add(row.get(field.getName()));
                    }
                    param.add(row.get("qty"));
                    param.add("0");
                    paramList.add(param.toArray());
                }
            }
            if (!paramList.isEmpty()) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)insertSql, paramList);
            }
            return paramList;
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            return new ArrayList<Object[]>();
        }
    }

    private static String getInsertSql(String[] fields, String tableName) {
        StringBuilder sqlBuilder = new StringBuilder("insert into ");
        sqlBuilder.append(tableName).append(" (");
        sqlBuilder.append(String.join((CharSequence)", ", fields)).append(") ").append(" values(");
        for (int i = 0; i < fields.length - 1; ++i) {
            sqlBuilder.append("?, ");
        }
        sqlBuilder.append('?').append(')');
        return sqlBuilder.toString();
    }

    public static Map<String, Set<Long>> hasExistGroups() {
        HashMap<String, Set<Long>> billGroups = new HashMap<String, Set<Long>>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)NetChangeSynHelper.class.getName(), (String)"msplan_reservecfg", (String)"group, billobject", null, null);){
            while (dataSet.hasNext()) {
                HashSet<Long> groups;
                Row row = dataSet.next();
                String billobject = row.getString("billobject");
                Long group = row.getLong("group");
                if (billGroups.get(billobject) != null) {
                    groups = (HashSet<Long>)billGroups.get(billobject);
                    groups.add(group);
                    continue;
                }
                groups = new HashSet<Long>(16);
                groups.add(group);
                billGroups.put(billobject, groups);
            }
        }
        return billGroups;
    }

    public static boolean checkIsExistCfg(Row row, Map<String, Set<Long>> groupMap) {
        Set<Long> groups;
        long groupId;
        String billobject = row.getString("billobject");
        long l = groupId = row.getLong("group") == null ? 0L : row.getLong("group");
        return groupMap.get(billobject) != null && reserveToNetChangeGroupMap.get(groupId) != null && (groups = groupMap.get(billobject)).contains(reserveToNetChangeGroupMap.get(groupId));
    }

    public static boolean checkIsExistCfg(Row row, long groupId, Map<String, Set<Long>> groupMap) {
        Set<Long> groups;
        String billobject = row.getString("billobject");
        return groupMap.get(billobject) != null && (groups = groupMap.get(billobject)).contains(groupId);
    }

    public static void syncCfgDatas(QFilter[] netChangeDeleteFilter, QFilter[] queryFilter, boolean isInit) {
        try {
            DeleteServiceHelper.delete((String)"msplan_reservecfg", (QFilter[])netChangeDeleteFilter);
            ORM orm = ORM.create();
            HashMap<String, Map<Long, Set<String>>> initOperateMap = new HashMap(16);
            HashMap<String, Set<String>> entityOperatesMap = new HashMap(16);
            Map<String, Set<Long>> groupMap = NetChangeSynHelper.hasExistGroups();
            String cfgInsertSql = NetChangeSynHelper.getInsertSql(InitDataConst.cfgInsertFields, "t_msplan_reservecfg");
            String cdgEntryInsertSql = NetChangeSynHelper.getInsertSql(InitDataConst.cfgEntryFields, "t_msplan_reservecfgentry");
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(InitDataConst.cfgInsertFields.length);
            ArrayList<Object[]> entryParamList = new ArrayList<Object[]>(InitDataConst.cfgEntryFields.length);
            long currentTime = System.currentTimeMillis();
            Timestamp timestamp = new Timestamp(currentTime);
            long currentUser = RequestContext.get().getCurrUserId();
            if (isInit) {
                initOperateMap = NetChangeSynHelper.getInitMap();
                entityOperatesMap = NetChangeSynHelper.getEntityMap(initOperateMap);
                NetChangeSynHelper.initMsmodReserverConfig(entityOperatesMap);
                NetChangeSynHelper.genInitTransferAndDeleteService(orm, initOperateMap, groupMap, paramList, entryParamList, timestamp, currentUser);
                NetChangeSynHelper.genBosBizOpRule();
            }
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)NetChangeSynHelper.class.getName(), (String)"msmod_reserve_service_cfg", (String)String.join((CharSequence)", ", InitDataConst.cfgSelectFields), (QFilter[])queryFilter, null);){
                Field[] fields = dataSet.getRowMeta().getFields();
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    if (NetChangeSynHelper.checkIsExistCfg(row, groupMap)) continue;
                    ArrayList<Object> param = new ArrayList<Object>(InitDataConst.cfgInsertFields.length);
                    Long cfgId = NetChangeSynHelper.genLongId(orm, "msplan_reservecfg");
                    param.add(cfgId);
                    param.add("C");
                    NetChangeSynHelper.genBosOpBizMap(entityOperatesMap, row);
                    for (Field field : fields) {
                        if ("group".equals(field.getName())) {
                            Long group = 0L;
                            if (row.get("group") != null) {
                                group = row.getLong("group");
                            }
                            if (1402139420131331072L == group) {
                                param.add(1458558020899387392L);
                                continue;
                            }
                            if (1402139574834039808L == group) {
                                param.add(1458671999063711744L);
                                continue;
                            }
                            if (1402139266611416064L == group) {
                                param.add(1483441778274144256L);
                                continue;
                            }
                            if (1402037881861730304L != group) break;
                            param.add(1449295078882279424L);
                            if (!NetChangeSynHelper.checkIsExistCfg(row, 1473815168164041728L, groupMap)) {
                                long tId = NetChangeSynHelper.addServiceParam(orm, row, 1473815168164041728L, paramList, timestamp, currentUser, "save,submit");
                                NetChangeSynHelper.addServiceEntryParam(orm, tId, entryParamList, new String[]{"save, submit"});
                            }
                            if (NetChangeSynHelper.checkIsExistCfg(row, 1478088711852794880L, groupMap)) continue;
                            long deleteId = NetChangeSynHelper.addServiceParam(orm, row, 1478088711852794880L, paramList, timestamp, currentUser, "delete");
                            NetChangeSynHelper.addServiceEntryParam(orm, deleteId, entryParamList, new String[]{"delete"});
                            continue;
                        }
                        if ("createtime".equals(field.getName()) || "modifytime".equals(field.getName())) {
                            param.add(timestamp);
                            continue;
                        }
                        if ("creator".equals(field.getName()) || "modifier".equals(field.getName())) {
                            param.add(currentUser);
                            continue;
                        }
                        if ("billoperation".equals(field.getName()) && row.getString("billoperation") != null) {
                            String[] operations = row.getString("billoperation").split("[,]");
                            int index = 1;
                            for (String operation : operations) {
                                if (StringUtils.isBlank((CharSequence)operation)) continue;
                                ArrayList<Object> entryParam = new ArrayList<Object>(InitDataConst.cfgEntryFields.length);
                                entryParam.add(cfgId);
                                entryParam.add(NetChangeSynHelper.genLongId(orm, "msplan_reservecfg.entryentity"));
                                entryParam.add(index++);
                                entryParam.add(operation);
                                entryParamList.add(entryParam.toArray());
                            }
                        }
                        param.add(row.get(field.getName()));
                    }
                    param.add("1");
                    if (param.size() != InitDataConst.cfgInsertFields.length) continue;
                    paramList.add(param.toArray());
                }
            }
            if (!paramList.isEmpty()) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)cfgInsertSql, paramList);
                DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)cdgEntryInsertSql, entryParamList);
            }
            NetChangeSynHelper.genBusinessEventDatas(entityOperatesMap);
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }

    public static String getOperatesString(Set<String> operates) {
        if (operates != null && !operates.isEmpty()) {
            return String.join((CharSequence)",", operates);
        }
        return "";
    }

    public static void genInitTransferAndDeleteService(ORM orm, Map<String, Map<Long, Set<String>>> initOperateMap, Map<String, Set<Long>> groupMap, List<Object[]> paramList, List<Object[]> entryParamList, Timestamp timestamp, long currentUser) {
        for (Map.Entry<String, Map<Long, Set<String>>> initOperateEntry : initOperateMap.entrySet()) {
            String entity = initOperateEntry.getKey();
            Map<Long, Set<String>> serviceMap = initOperateEntry.getValue();
            Set hasExistGroups = groupMap.getOrDefault(entity, new HashSet(16));
            for (Map.Entry<Long, Set<String>> serviceEntry : serviceMap.entrySet()) {
                Long groupId = serviceEntry.getKey();
                if (hasExistGroups.contains(groupId)) continue;
                Set<String> operates = serviceEntry.getValue();
                long headId = NetChangeSynHelper.addInitServiceParam(orm, paramList, groupId, entity, NetChangeSynHelper.getOperatesString(operates), timestamp, currentUser);
                NetChangeSynHelper.addServiceEntryParam(orm, headId, entryParamList, operates.toArray(new String[0]));
                hasExistGroups.add(groupId);
                groupMap.put(entity, hasExistGroups);
            }
        }
    }

    public static long addInitServiceParam(ORM orm, List<Object[]> paramList, long groupId, String entity, String operate, Timestamp timestamp, long currentUser) {
        ArrayList<Object> param = new ArrayList<Object>(InitDataConst.cfgInsertFields.length);
        long id = NetChangeSynHelper.genLongId(orm, "msplan_reservecfg");
        param.add(id);
        param.add("C");
        param.add(0L);
        param.add(groupId);
        param.add(entity);
        param.add(operate);
        param.add("");
        param.add("");
        param.add("");
        param.add("1");
        param.add(currentUser);
        param.add(timestamp);
        param.add(currentUser);
        param.add(timestamp);
        param.add("2");
        paramList.add(param.toArray());
        return id;
    }

    public static void initMsmodReserverConfig(Map<String, Set<String>> entityToOpeateMap) {
        HashSet<String> operates = new HashSet<String>(2);
        operates.add("save");
        entityToOpeateMap.put("msmod_reserve_service_cfg", operates);
    }

    public static void genBosBizOpRule() {
        OpBizRuleSetServiceHelper.deleteOpBizRuleSet((String)"msmod_reserve_record", (String)"CommonNetChangeService");
        OpBizRuleSetServiceHelper.saveOpBizRuleSet((String)"msmod_reserve_record", (String)"CommonNetChangeService", Collections.singletonList("remove"));
    }

    /*
     * WARNING - void declaration
     */
    public static void genBusinessEventDatas(Map<String, Set<String>> entityToOpeateMap) {
        HashSet<String> entityNums = new HashSet<String>(entityToOpeateMap.size());
        for (Map.Entry<String, Set<String>> entry : entityToOpeateMap.entrySet()) {
            String entityNumber = entry.getKey();
            entityNums.add(entityNumber);
        }
        QFilter businessTypeFilter = new QFilter("type", "=", (Object)"cosmic");
        QFilter entityFilter = new QFilter("entity", "in", entityNums);
        HashMap<Long, DynamicObject> eventMap = new HashMap<Long, DynamicObject>(16);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"evt_event", (String)"id, name, numberview, opernumber, operation, entity.id, type", (QFilter[])new QFilter[]{businessTypeFilter, entityFilter});
        HashSet<String> hasRegisterdEvent = new HashSet<String>(16);
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                String entityId = dynamicObject.getString("entity.id");
                String operation = dynamicObject.getString("opernumber");
                StringBuilder duplicateKey = new StringBuilder();
                duplicateKey.append(entityId).append('.').append(operation);
                if (hasRegisterdEvent.contains(duplicateKey.toString())) continue;
                eventMap.put(dynamicObject.getLong("id"), dynamicObject);
                hasRegisterdEvent.add(duplicateKey.toString());
            }
        }
        if (!eventMap.isEmpty()) {
            HashMap<String, DynamicObject> entityMap = new HashMap<String, DynamicObject>();
            Long creatorId = RequestContext.get().getCurrUserId();
            Date currentTime = new Date();
            NetChangeSynHelper.genEntityMap(entityNums, entityMap);
            List<DynamicObject> businessOrders = NetChangeSynHelper.genBusinessOrders(eventMap, creatorId, currentTime);
            if (!businessOrders.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])businessOrders.toArray(new DynamicObject[0]));
                DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("workflow", new DistributeCacheHAPolicy());
                StringBuilder sb = new StringBuilder();
                sb.append(RequestContext.get().getAccountId()).append(".evt.").append("cacheEvent");
                HashMap<void, ArrayList<String>> needaddEvents = new HashMap<void, ArrayList<String>>();
                ArrayList<String> enableDatas = new ArrayList<String>(businessOrders.size());
                for (DynamicObject businessOrder : businessOrders) {
                    enableDatas.add(businessOrder.getString("eventnumber"));
                }
                for (String eventNum : enableDatas) {
                    void var17_19;
                    String string = "";
                    if (eventNum.contains(".")) {
                        String string2 = eventNum.split("\\.")[0];
                    } else {
                        String string3 = "defaultGroup";
                    }
                    ArrayList<String> waitAddEvent = (ArrayList<String>)needaddEvents.get(var17_19);
                    if (waitAddEvent == null) {
                        waitAddEvent = new ArrayList<String>();
                        waitAddEvent.add(eventNum);
                        needaddEvents.put(var17_19, waitAddEvent);
                        continue;
                    }
                    waitAddEvent.add(eventNum);
                }
                Set entrySet = needaddEvents.entrySet();
                for (Map.Entry<String, List<String>> entry : entrySet) {
                    String key = String.format("%s.%s", sb, entry.getKey());
                    NetChangeSynHelper.cacheSet(cache, key, entry);
                }
            }
        }
    }

    private static void cacheSet(DistributeSessionlessCache cache, String key, Map.Entry<String, List<String>> entry) {
        cache.addToSet(key, entry.getValue().toArray(new String[0]));
    }

    private static List<DynamicObject> genBusinessOrders(Map<Long, DynamicObject> eventMap, Long creatorId, Date currentTime) {
        ArrayList<DynamicObject> businessOrders = new ArrayList<DynamicObject>(eventMap.size());
        String businessJson = "{\"scriptid\":\"\",\"type\":\"class\",\"value\":\"{\\\"appid\\\":\\\"mrp\\\",\\\"class\\\":\\\"kd.mmc.mrp.mservice.netchange.businessevent.NetChangeCommonPlugin\\\"}\"}";
        QFilter servicefilter = new QFilter("serviceconfig", "=", (Object)businessJson);
        QFilter eventFilter = new QFilter("event", "in", eventMap.keySet());
        DeleteServiceHelper.delete((String)"evt_subscription", (QFilter[])new QFilter[]{servicefilter, eventFilter});
        ORM orm = ORM.create();
        for (Map.Entry<Long, DynamicObject> entry : eventMap.entrySet()) {
            DynamicObject eventObj = entry.getValue();
            businessOrders.add(NetChangeSynHelper.genBusinessOrder(orm, eventObj, businessJson, creatorId, currentTime));
        }
        return businessOrders;
    }

    private static DynamicObject genBusinessOrder(ORM orm, DynamicObject eventObj, String businessJson, Long creatorId, Date currentTime) {
        DynamicObject dynamicObject = orm.newDynamicObject("evt_subscription");
        Long id = orm.genLongId("evt_subscription");
        dynamicObject.set("id", (Object)id);
        dynamicObject.set("event", (Object)eventObj.getLong("id"));
        dynamicObject.set("service", (Object)904236026388547584L);
        dynamicObject.set("serviceconfig", (Object)businessJson);
        String numberview = "";
        if (eventObj.get("numberview") != null) {
            numberview = eventObj.getString("numberview");
        }
        StringBuilder number = new StringBuilder(numberview);
        number.append('.').append("executePlugin");
        dynamicObject.set("number", (Object)number.toString());
        String eName = "";
        if (eventObj.get("name") != null && StringUtils.isNotBlank((CharSequence)eventObj.getString("name"))) {
            eName = eventObj.getString("name");
        }
        StringBuilder name = new StringBuilder(eName);
        name.append('.').append(ResManager.loadKDString((String)"\u6267\u884c\u63d2\u4ef6\uff08\u51c0\u6539\u53d8\u516c\u7528\u4e8b\u4ef6\uff09", (String)"NetChangeSynHelper_1", (String)"mmc-mrp-business", (Object[])new Object[0]));
        dynamicObject.set("name", (Object)name.toString());
        dynamicObject.set("errorstrategy", (Object)"retry");
        dynamicObject.set("status", (Object)Character.valueOf('1'));
        String entityId = eventObj.getString("entity.id");
        String operation = eventObj.getString("opernumber");
        StringBuilder duplicateKey = new StringBuilder();
        duplicateKey.append(entityId).append('.').append(operation);
        dynamicObject.set("eventnumber", (Object)duplicateKey.toString());
        dynamicObject.set("servicenumber", (Object)"executePlugin");
        dynamicObject.set("creater", (Object)creatorId);
        dynamicObject.set("createdate", (Object)currentTime);
        return dynamicObject;
    }

    private static void genEntityMap(Set<String> entityNums, Map<String, DynamicObject> entityMap) {
        QFilter qFilter = new QFilter("number", "in", entityNums);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bos_formmeta", (String)"id, number, bizappid", (QFilter[])new QFilter[]{qFilter});
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                entityMap.put(dynamicObject.getString("number"), dynamicObject);
            }
        }
    }

    private static long genLongId(ORM orm, String entityNumber) {
        return orm.genLongId(entityNumber);
    }

    private static void genBosOpBizMap(Map<String, Set<String>> entityToOpeateMap, Row row) {
        if (row.get("billobject") != null) {
            String entityNumber = row.getString("billobject");
            String operate = "";
            if (row.get("billoperation") != null) {
                operate = row.getString("billoperation");
            }
            if (entityToOpeateMap.get(entityNumber) == null) {
                String[] operations;
                HashSet<String> operateSets = new HashSet<String>(16);
                for (String ope : operations = operate.split("[,]")) {
                    if (StringUtils.isBlank((CharSequence)ope)) continue;
                    operateSets.add(ope);
                }
                operateSets.add("save");
                operateSets.add("submit");
                operateSets.add("delete");
                entityToOpeateMap.put(entityNumber, operateSets);
            } else {
                String[] operations;
                Set<String> operateSets = entityToOpeateMap.get(entityNumber);
                for (String ope : operations = operate.split("[,]")) {
                    if (StringUtils.isBlank((CharSequence)ope)) continue;
                    operateSets.add(ope);
                }
                entityToOpeateMap.put(entityNumber, operateSets);
            }
        }
    }

    private static Long addServiceParam(ORM orm, Row row, long serviceId, List<Object[]> paramList, Timestamp timestamp, long currentUser, String operation) {
        ArrayList<Object> param = new ArrayList<Object>(InitDataConst.cfgInsertFields.length);
        Long cfgId = NetChangeSynHelper.genLongId(orm, "msplan_reservecfg");
        param.add(cfgId);
        param.add("C");
        param.add(0L);
        param.add(serviceId);
        param.add(row.getString("billobject"));
        param.add(operation);
        param.add("");
        param.add("");
        param.add("");
        param.add("1");
        param.add(currentUser);
        param.add(timestamp);
        param.add(currentUser);
        param.add(timestamp);
        param.add("1");
        paramList.add(param.toArray());
        return cfgId;
    }

    private static void addServiceEntryParam(ORM orm, Long cfgId, List<Object[]> entryParamList, String[] operations) {
        int index = 1;
        for (String operation : operations) {
            ArrayList<Object> entryParam = new ArrayList<Object>(InitDataConst.cfgEntryFields.length);
            entryParam.add(cfgId);
            entryParam.add(NetChangeSynHelper.genLongId(orm, "msplan_reservecfg.entryentity"));
            entryParam.add(index++);
            entryParam.add(operation);
            entryParamList.add(entryParam.toArray());
        }
    }

    static {
        reserveToNetChangeGroupMap.put(1402139420131331072L, 1458558020899387392L);
        reserveToNetChangeGroupMap.put(1402139574834039808L, 1458671999063711744L);
        reserveToNetChangeGroupMap.put(1402139266611416064L, 1483441778274144256L);
        reserveToNetChangeGroupMap.put(1402037881861730304L, 1449295078882279424L);
    }
}

