/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.calcnode.framework.mq.resolver.balance;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.mrp.calcnode.framework.mq.resolver.balance.MRPDataBalanceNewResolver;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.mq.event.MRPEvent;
import kd.mmc.mrp.integrate.entity.PlanModel;
import kd.mmc.mrp.integrate.entity.ResDataModelCollection;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mmc.mrp.model.struct.InvRealBalanceStruct;
import kd.mmc.mrp.model.struct.InvSupplyStruct;
import kd.mmc.mrp.model.struct.ReserveData;
import kd.mmc.mrp.model.struct.SupplyStruct;
import kd.mmc.mrp.model.table.DataBalanceTable;
import kd.mmc.mrp.model.table.RequireRowData;
import kd.mmc.mrp.model.table.RowData;
import kd.mmc.mrp.model.table.res.RequirementDataTable;
import kd.mmc.mrp.model.table.res.SupplymentDataTable;
import kd.mmc.mrp.utils.MRPUtil;

public class MRPDataBalanceResolver4RealTimeRpt
extends MRPDataBalanceNewResolver {
    private static Log logger = LogFactory.getLog(MRPDataBalanceResolver4RealTimeRpt.class);
    private static BigDecimal NEGATIVE_ONE = new BigDecimal("-1");
    private String innercoptype;
    private Long queryOrgId;
    private Long planScopeId;
    private Long materialId;
    private Boolean showDem;
    private Boolean showSup;
    private Boolean isShowProject;
    private Boolean isShowTrackNumber;
    private Boolean isMTS;
    private Boolean isShowConfigureCode;
    private int colCnt = 27;
    private RowMeta meta;
    private Map<String, String> cache = new HashMap<String, String>();

    @Override
    public void execute(MRPEvent event, IMRPEnvProvider actx) {
        super.execute(event, actx);
    }

    @Override
    protected void innerexecute() {
        this.innercoptype = (String)this.ctx.getLocalParams("real_time_rpt_innercoptype");
        this.showDem = (Boolean)this.ctx.getLocalParams("real_time_rpt_is_showdemand");
        this.showSup = (Boolean)this.ctx.getLocalParams("real_time_rpt_is_showsupply");
        String mIdStr = (String)this.ctx.getLocalParams("real_time_rpt_material_id");
        this.planScopeId = (Long)this.ctx.getLocalParams("real_time_rpt_planscope_id");
        this.queryOrgId = (Long)this.ctx.getLocalParams("real_time_rpt_queryorgid");
        this.isShowProject = (Boolean)this.ctx.getLocalParams("real_time_rpt_isshowproject");
        this.isShowTrackNumber = (Boolean)this.ctx.getLocalParams("real_time_rpt_isshowtracknumber");
        this.isShowConfigureCode = (Boolean)this.ctx.getLocalParams("real_time_rpt_isshowconfigrecode");
        this.meta = (RowMeta)this.ctx.getLocalParams("real_time_rpt_dataset_header");
        this.colCnt = this.meta.getFieldCount();
        this.isMTS = (Boolean)this.ctx.getCfgValue(EnvCfgItem.IS_MTS_MERGE_DISPLAY);
        logger.info(String.format("mrprunner-realtimerpt-queryArgs: innercoptype: %s, showDem: %s, mId: %s, planScopeId: %s, queryOrgId: %s, isShowTrackNumber: %s, isMTS: %s", this.innercoptype, this.showDem, mIdStr, this.planScopeId, this.queryOrgId, this.isShowTrackNumber, this.isMTS));
        this.materialId = Long.valueOf(mIdStr);
        if (!this.showDem.booleanValue()) {
            this.requireTbl.clear();
        } else {
            this.ctx.loadRequireMaterialExtProps();
            ArrayList<RequireRowData> datas = new ArrayList<RequireRowData>(this.requireTbl.size());
            int size = this.requireTbl.size();
            for (int i = 0; i < size; ++i) {
                if (this.planScopeId.longValue() != ((Long)MRPUtil.convert((Object)this.requireTbl.getValue(DefaultField.RequireField.PLANSCOPE.getName(), i), (Object)0L)).longValue()) continue;
                Object mAttr = this.requireTbl.getValue(DefaultField.RequireField.MATERIALATTR.getName(), i);
                if (mAttr == null) {
                    String mId = String.valueOf(this.requireTbl.getValue(DefaultField.RequireField.MATERIAL.getName(), i));
                    String orgId = String.valueOf(this.requireTbl.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName(), i));
                    this.requireTbl.updateValue(DefaultField.RequireField.MATERIALATTR.getName(), Integer.valueOf(i), (Object)this.ctx.getMaterialAttr(mId, orgId));
                }
                datas.add(this.requireTbl.fetchRow(i));
            }
            this.requireTbl.clear();
            this.requireTbl.fill(datas.toArray(new RowData[0]));
        }
        if (!this.showSup.booleanValue()) {
            this.supplyTbl.clear();
        }
        super.innerexecute();
    }

    @Override
    protected void saveDatas() {
        ArrayList<DataBalanceTable.RSMapping> mappings = new ArrayList<DataBalanceTable.RSMapping>(this.ctx.calcBalanceDetails().getUnVisitedMappings());
        boolean isSaveDetails = (Boolean)this.ctx.getCfgValue(EnvCfgItem.IS_REALTIMERPT_SAVE_DETAILS);
        this.ctx.calcBalanceDetails().finish();
        LinkedList<Map<String, Object>> details = new LinkedList<Map<String, Object>>();
        this.saveRSMappings(details);
        this.cancelSupplys(details);
        if (isSaveDetails) {
            try {
                this.putMaterialDetails(details);
            }
            catch (Throwable e) {
                logger.error("mrprunner-realtimerpt-detailsaveerror", e);
            }
        }
        List<Object[]> builder = MRPDataBalanceResolver4RealTimeRpt.resolveDatas(this.ctx, this.requireTbl, this.supplyTbl, mappings, this.isMTS, this.colCnt, this.planScopeId, this.innercoptype, this.isShowProject, this.isShowTrackNumber, this.isShowConfigureCode, this.queryOrgId);
        this.ctx.putLocalParam("real_time_rpt_result_ds", builder);
    }

    public static List<Object[]> resolveDatas(IMRPEnvProvider ctx, RequirementDataTable requireTbl, SupplymentDataTable supplyTbl, Collection<DataBalanceTable.RSMapping> mappings, boolean isMTS, int colCnt, Long planScopeId, String innercoptype, Boolean isShowProject, Boolean isShowTrackNumber, Boolean isShowConfigureCode, Long queryOrgId) {
        BigDecimal qty;
        int i;
        Object[] row;
        DataBalanceTable.RSMapping mapping;
        ArrayList<Object[]> builder = new ArrayList<Object[]>(requireTbl.size());
        ArrayList<RequireRowData> ignores = new ArrayList<RequireRowData>(8);
        HashSet<Integer> displayedRequires = new HashSet<Integer>(16);
        HashMap<String, DataBalanceTable.RSMapping> allRelations = new HashMap<String, DataBalanceTable.RSMapping>(8);
        HashMap<String, DataBalanceTable.RSMapping> relations = new HashMap<String, DataBalanceTable.RSMapping>(8);
        Iterator<DataBalanceTable.RSMapping> iter = mappings.iterator();
        while (iter.hasNext()) {
            mapping = iter.next();
            List supplys = mapping.getSupplys();
            if (supplys == null) continue;
            RequireRowData require = mapping.getRequire();
            String id = require.getString(DefaultField.RequireField.BILLID.getName()) + "-" + require.getString(DefaultField.RequireField.BILLENTRYID.getName());
            DataBalanceTable.RSMapping old = (DataBalanceTable.RSMapping)allRelations.get(id);
            if (old == null) {
                old = mapping;
                allRelations.put(id, old);
            } else {
                BigDecimal part = require.getBigDecimal(DefaultField.RequireField.__SUPPLY_QTY__.getName());
                BigDecimal lastQty = old.getRequire().getBigDecimal(DefaultField.RequireField.__SUPPLY_QTY__.getName());
                old.getRequire().update(DefaultField.RequireField.__SUPPLY_QTY__.getName(), (Object)lastQty.add(part));
                iter.remove();
            }
            Iterator supplyIter = supplys.iterator();
            while (supplyIter.hasNext()) {
                RowData supply = (RowData)supplyIter.next();
                if ("mrp_collaborativeorder".equals(supply.get(DefaultField.SupplyField.BILL_ENTITY.getName()))) {
                    supplyIter.remove();
                    String interId = supply.getString(DefaultField.SupplyField.BILLID.getName()) + "-" + supply.getString(DefaultField.SupplyField.BILLENTRYID.getName());
                    relations.put(interId, old);
                    continue;
                }
                if (old == mapping) continue;
                old.getSupplys().add(supply);
            }
        }
        iter = mappings.iterator();
        while (iter.hasNext()) {
            mapping = iter.next();
            RequireRowData require = mapping.getRequire();
            String id = require.getString(DefaultField.RequireField.BILLID.getName()) + "-" + require.getString(DefaultField.RequireField.BILLENTRYID.getName());
            DataBalanceTable.RSMapping old = (DataBalanceTable.RSMapping)relations.get(id);
            if (old == null) continue;
            iter.remove();
            List srcSupplys = old.getSupplys();
            if (srcSupplys == null) {
                old.setSupplys(mapping.getSupplys());
                continue;
            }
            List interSupplys = mapping.getSupplys();
            if (interSupplys == null) continue;
            srcSupplys.addAll(interSupplys);
        }
        HashMap<String, BigDecimal> unUsedQtys = new HashMap<String, BigDecimal>();
        ArrayList<RowData> ignoreStockDatas = new ArrayList<RowData>(8);
        HashMap<String, BigDecimal> ignoreSupplyUnUsedQtys = new HashMap<String, BigDecimal>();
        HashSet<String> calculateSupplys = new HashSet<String>(supplyTbl.size());
        int size = supplyTbl.size();
        for (int i2 = 0; i2 < size; ++i2) {
            RowData supply = supplyTbl.fetchRow(i2);
            BigDecimal qty2 = supply.getBigDecimal(DefaultField.SupplyField.QTY.getName());
            if (qty2.compareTo(BigDecimal.ZERO) <= 0 || supply.getBoolean(DefaultField.SupplyField.__IS_OCCUPIED__.getName()).booleanValue()) continue;
            String key = MRPDataBalanceResolver4RealTimeRpt.getUnUseQtyKey(supply);
            if (!MRPDataBalanceResolver4RealTimeRpt.isAvailStockData(ctx, supplyTbl, supply)) {
                ignoreStockDatas.add(supply);
                ignoreSupplyUnUsedQtys.put(key, qty2.add(ignoreSupplyUnUsedQtys.getOrDefault(key, BigDecimal.ZERO)));
                continue;
            }
            unUsedQtys.put(key, qty2.add(unUsedQtys.getOrDefault(key, BigDecimal.ZERO)));
        }
        HashMap<String, Integer> addedSupplys = new HashMap<String, Integer>();
        for (DataBalanceTable.RSMapping mapping2 : mappings) {
            RequireRowData require = mapping2.getRequire();
            BigDecimal qty3 = require.getBigDecimal(DefaultField.RequireField.__SUPPLY_QTY__.getName());
            if (qty3.compareTo(BigDecimal.ZERO) <= 0) continue;
            displayedRequires.add(require.getRowIdx());
            List supplys = mapping2.getSupplys();
            if (supplys == null || supplys.isEmpty()) {
                ignores.add(require);
                continue;
            }
            qty3 = qty3.multiply(NEGATIVE_ONE);
            MRPDataBalanceResolver4RealTimeRpt.addGroupRow(ResManager.loadKDString((String)"\u4f9b\u9700\u5339\u914d\u5206\u7ec4", (String)"MRPDataBalanceResolver4RealTimeRpt_0", (String)"mmc-mrp-mservice-calcnode", (Object[])new Object[0]), builder, isMTS, colCnt);
            row = MRPDataBalanceResolver4RealTimeRpt.copyRequire(require, builder, colCnt, planScopeId, innercoptype, isShowProject, isShowTrackNumber, isShowConfigureCode, MRPDataBalanceResolver4RealTimeRpt.getRequireReserveQty(require, supplyTbl));
            if (row == null && !isMTS) {
                builder.remove(builder.size() - 1);
            }
            if (row != null) {
                row[row.length - 1] = qty3;
            } else {
                qty3 = BigDecimal.ZERO;
            }
            for (RowData supply : supplys) {
                String key = MRPDataBalanceResolver4RealTimeRpt.getUnUseQtyKey(supply);
                BigDecimal sQty = supply.getBigDecimal(DefaultField.SupplyField.QTY.getName());
                if (!MRPDataBalanceResolver4RealTimeRpt.isAvailStockData(ctx, supplyTbl, supply)) {
                    ignoreStockDatas.add(supply);
                    ignoreSupplyUnUsedQtys.put(key, sQty.add(ignoreSupplyUnUsedQtys.getOrDefault(key, BigDecimal.ZERO)));
                    continue;
                }
                Integer oldIdx = (Integer)addedSupplys.get(key);
                if (oldIdx != null) {
                    row = (Object[])builder.get(oldIdx);
                    sQty = ((BigDecimal)row[4]).add(sQty);
                    row[4] = sQty;
                    MRPDataBalanceResolver4RealTimeRpt.reCalculateSupplyReserveQty(calculateSupplys, supplyTbl, supply, row);
                } else {
                    row = MRPDataBalanceResolver4RealTimeRpt.copySupply(ctx, supply, builder, colCnt, planScopeId, innercoptype, isShowProject, isShowTrackNumber, isShowConfigureCode, queryOrgId, MRPDataBalanceResolver4RealTimeRpt.getSupplyReserveQty(supply, supplyTbl));
                    if (row == null) continue;
                    calculateSupplys.add(MRPDataBalanceResolver4RealTimeRpt.getReserveKey(supply, DefaultField.SupplyField.BILLID.getName(), DefaultField.SupplyField.BILLENTRYID.getName()));
                    addedSupplys.put(key, builder.size() - 1);
                }
                BigDecimal unUsedQty = (BigDecimal)unUsedQtys.remove(key);
                if (unUsedQty != null) {
                    sQty = sQty.add(unUsedQty);
                    row[4] = sQty;
                    MRPDataBalanceResolver4RealTimeRpt.reCalculateSupplyReserveQty(calculateSupplys, supplyTbl, supply, row);
                }
                qty3 = qty3.add(sQty);
                row[row.length - 1] = qty3;
            }
        }
        addedSupplys.clear();
        ArrayList<Object[]> sBuilder = new ArrayList<Object[]>(supplyTbl.size());
        int size2 = supplyTbl.size();
        for (i = 0; i < size2; ++i) {
            BigDecimal unUsedQty;
            RowData supply = supplyTbl.fetchRow(i);
            qty = supply.getBigDecimal(DefaultField.SupplyField.QTY.getName());
            if (qty.compareTo(BigDecimal.ZERO) <= 0 || supply.getBoolean(DefaultField.SupplyField.__IS_OCCUPIED__.getName()).booleanValue() || !MRPDataBalanceResolver4RealTimeRpt.isAvailStockData(ctx, supplyTbl, supply)) continue;
            String key = MRPDataBalanceResolver4RealTimeRpt.getUnUseQtyKey(supply);
            Integer oldIdx = (Integer)addedSupplys.get(key);
            if (oldIdx != null) {
                MRPDataBalanceResolver4RealTimeRpt.reCalculateSupplyReserveQty(calculateSupplys, supplyTbl, supply, (Object[])sBuilder.get(oldIdx));
            }
            if ((unUsedQty = (BigDecimal)unUsedQtys.remove(key)) == null) continue;
            supply.update(DefaultField.SupplyField.QTY.getName(), (Object)unUsedQty);
            Object[] row2 = MRPDataBalanceResolver4RealTimeRpt.copySupply(ctx, supply, sBuilder, colCnt, planScopeId, innercoptype, isShowProject, isShowTrackNumber, isShowConfigureCode, queryOrgId, MRPDataBalanceResolver4RealTimeRpt.getSupplyReserveQty(supply, supplyTbl));
            if (row2 != null) {
                addedSupplys.put(key, sBuilder.size() - 1);
                calculateSupplys.add(MRPDataBalanceResolver4RealTimeRpt.getReserveKey(supply, DefaultField.SupplyField.BILLID.getName(), DefaultField.SupplyField.BILLENTRYID.getName()));
            }
            supply.update(DefaultField.SupplyField.QTY.getName(), (Object)qty);
        }
        if (!sBuilder.isEmpty()) {
            MRPDataBalanceResolver4RealTimeRpt.addGroupRow(ResManager.loadKDString((String)"\u5bcc\u4f59\u4f9b\u5e94\u5206\u7ec4", (String)"MRPDataBalanceResolver4RealTimeRpt_1", (String)"mmc-mrp-mservice-calcnode", (Object[])new Object[0]), builder, isMTS, colCnt);
            builder.addAll(sBuilder);
        }
        sBuilder.clear();
        size2 = requireTbl.size();
        for (i = 0; i < size2; ++i) {
            RequireRowData require = requireTbl.fetchRow(i);
            qty = require.getBigDecimal(DefaultField.RequireField.QTY.getName());
            if (qty.compareTo(BigDecimal.ZERO) <= 0 || displayedRequires.contains(i) || "mrp_collaborativeorder".equals(require.get(DefaultField.RequireField.BILL_ENTITY.getName())) || (row = MRPDataBalanceResolver4RealTimeRpt.copyRequire(require, sBuilder, colCnt, planScopeId, innercoptype, isShowProject, isShowTrackNumber, isShowConfigureCode, MRPDataBalanceResolver4RealTimeRpt.getRequireReserveQty(require, supplyTbl))) == null) continue;
            String exception = (String)MRPUtil.convert((Object)require.getString(DefaultField.RequireField.EXCEPTIONNUMBER.getName()), (Object)"");
            row[row.length - 1] = MRPUtil.hasException((String)exception) ? null : row[4];
        }
        ArrayList<Object[]> sBuilder2 = new ArrayList<Object[]>(ignores.size());
        if (!ignores.isEmpty()) {
            for (RequireRowData require : ignores) {
                String exception;
                Object[] row3 = MRPDataBalanceResolver4RealTimeRpt.copyRequire(require, sBuilder2, colCnt, planScopeId, innercoptype, isShowProject, isShowTrackNumber, isShowConfigureCode, MRPDataBalanceResolver4RealTimeRpt.getRequireReserveQty(require, supplyTbl));
                if (row3 == null) continue;
                if (((BigDecimal)MRPUtil.convert((Object)row3[4], (Object)BigDecimal.ZERO)).compareTo(BigDecimal.ZERO) == 0) {
                    row3[4] = require.getBigDecimal(DefaultField.RequireField.QTY.getName()).multiply(NEGATIVE_ONE);
                }
                if (MRPUtil.hasException((String)(exception = (String)MRPUtil.convert((Object)require.getString(DefaultField.RequireField.EXCEPTIONNUMBER.getName()), (Object)"")))) {
                    row3[row3.length - 1] = null;
                    continue;
                }
                row3[row3.length - 1] = row3[4];
            }
        }
        addedSupplys.clear();
        ArrayList<Object[]> sBuilder3 = new ArrayList<Object[]>(ignoreStockDatas.size());
        if (!ignoreStockDatas.isEmpty()) {
            for (RowData supply : ignoreStockDatas) {
                BigDecimal unUsedQty;
                BigDecimal qty4 = supply.getBigDecimal(DefaultField.SupplyField.QTY.getName());
                String key = MRPDataBalanceResolver4RealTimeRpt.getUnUseQtyKey(supply);
                Integer oldIdx = (Integer)addedSupplys.get(key);
                if (oldIdx != null) {
                    MRPDataBalanceResolver4RealTimeRpt.reCalculateSupplyReserveQty(calculateSupplys, supplyTbl, supply, (Object[])sBuilder3.get(oldIdx));
                }
                if ((unUsedQty = (BigDecimal)ignoreSupplyUnUsedQtys.remove(key)) == null) continue;
                supply.update(DefaultField.SupplyField.QTY.getName(), (Object)unUsedQty);
                Object[] row4 = MRPDataBalanceResolver4RealTimeRpt.copySupply(ctx, supply, sBuilder3, colCnt, planScopeId, innercoptype, isShowProject, isShowTrackNumber, isShowConfigureCode, queryOrgId, MRPDataBalanceResolver4RealTimeRpt.getSupplyReserveQty(supply, supplyTbl));
                if (row4 != null) {
                    row4[row4.length - 1] = null;
                    row4[29] = null;
                    addedSupplys.put(key, sBuilder3.size() - 1);
                    calculateSupplys.add(MRPDataBalanceResolver4RealTimeRpt.getReserveKey(supply, DefaultField.SupplyField.BILLID.getName(), DefaultField.SupplyField.BILLENTRYID.getName()));
                }
                supply.update(DefaultField.SupplyField.QTY.getName(), (Object)qty4);
            }
        }
        if (!sBuilder.isEmpty() || !sBuilder2.isEmpty()) {
            MRPDataBalanceResolver4RealTimeRpt.addGroupRow(ResManager.loadKDString((String)"\u672a\u5339\u914d\u9700\u6c42\u5206\u7ec4", (String)"MRPDataBalanceResolver4RealTimeRpt_4", (String)"mmc-mrp-mservice-calcnode", (Object[])new Object[0]), builder, isMTS, colCnt);
            builder.addAll(sBuilder);
            builder.addAll(sBuilder2);
        }
        if (!sBuilder3.isEmpty()) {
            MRPDataBalanceResolver4RealTimeRpt.addGroupRow(ResManager.loadKDString((String)"\u672a\u5339\u914d\u4f9b\u5e94\u5206\u7ec4", (String)"MRPDataBalanceResolver4RealTimeRpt_5", (String)"mmc-mrp-mservice-calcnode", (Object[])new Object[0]), builder, isMTS, colCnt);
            builder.addAll(sBuilder3);
        }
        return builder;
    }

    private static void reCalculateSupplyReserveQty(Set<String> calculateSupplys, SupplymentDataTable supplyTbl, RowData supply, Object[] row) {
        if (calculateSupplys.add(MRPDataBalanceResolver4RealTimeRpt.getReserveKey(supply, DefaultField.SupplyField.BILLID.getName(), DefaultField.SupplyField.BILLENTRYID.getName()))) {
            row[28] = ((BigDecimal)row[28]).add(MRPDataBalanceResolver4RealTimeRpt.getSupplyReserveQty(supply, supplyTbl));
        }
        row[29] = ((BigDecimal)row[4]).compareTo((BigDecimal)row[28]) <= 0 ? BigDecimal.ZERO : ((BigDecimal)row[4]).subtract((BigDecimal)row[28]);
    }

    private static BigDecimal getRequireReserveQty(RequireRowData require, SupplymentDataTable supplyTbl) {
        return supplyTbl.getR2Reserve().getOrDefault(MRPDataBalanceResolver4RealTimeRpt.getReserveKey((RowData)require, DefaultField.RequireField.BILLID.getName(), DefaultField.RequireField.BILLENTRYID.getName()), new ReserveData()).getAllOrigQty();
    }

    private static BigDecimal getSupplyReserveQty(RowData supply, SupplymentDataTable supplyTbl) {
        return supplyTbl.getS2Reserve().getOrDefault(MRPDataBalanceResolver4RealTimeRpt.getReserveKey(supply, DefaultField.SupplyField.BILLID.getName(), DefaultField.SupplyField.BILLENTRYID.getName()), new ReserveData()).getSupplySurplusQty();
    }

    private static String getReserveKey(RowData supply, String billIdField, String billEntryIdField) {
        Long bill_id = (Long)MRPUtil.convert((Object)supply.getValue(billIdField), (Object)0L);
        Long billentry_id = (Long)MRPUtil.convert((Object)supply.getValue(billEntryIdField), (Object)0L);
        if (billentry_id == 0L) {
            billentry_id = bill_id;
        }
        return bill_id.toString() + '-' + billentry_id;
    }

    private static String getUnUseQtyKey(RowData supply) {
        boolean isInv = MRPUtil.convert((Object)supply.getValue(DefaultField.SupplyField.ISSTORAGEDATA.getName()), (Boolean)Boolean.FALSE);
        if (isInv) {
            StringBuilder sb = new StringBuilder();
            Long material = (Long)MRPUtil.convert((Object)supply.getValue(DefaultField.SupplyField.MATERIAL.getName()), (Object)0L);
            Long materialflexprops = (Long)MRPUtil.convert((Object)supply.getValue(DefaultField.SupplyField.MATERIALFLEXPROPS.getName()), (Object)0L);
            Long configuredcode = (Long)MRPUtil.convert((Object)supply.getValue(DefaultField.SupplyField.CONFIGUREDCODE.getName()), (Object)0L);
            Long tracknumber = (Long)MRPUtil.convert((Object)supply.getValue(DefaultField.SupplyField.TRACKNUMBER.getName()), (Object)0L);
            Long projectnumber = (Long)MRPUtil.convert((Object)supply.getValue(DefaultField.SupplyField.PROJECTNUMBER.getName()), (Object)0L);
            Long supplier = (Long)MRPUtil.convert((Object)supply.getValue(DefaultField.SupplyField.SUPPLIER.getName()), (Object)0L);
            Long supplyorgunit = (Long)MRPUtil.convert((Object)supply.getValue(DefaultField.SupplyField.SUPPLYORGUNIT.getName()), (Object)0L);
            Long planScope = supply.getLong(DefaultField.SupplyField.PLANSCOPE.getName());
            if (planScope == null || planScope == 0L) {
                planScope = supply.getLong(DefaultField.SupplyField.DYNAMIC_PLANSCOPE.getName());
            }
            if (planScope == null) {
                planScope = 0L;
            }
            Long warehouse = (Long)MRPUtil.convert((Object)supply.getValue(DefaultField.SupplyField.WAREHOUSE.getName()), (Object)0L);
            sb.append(material).append('\u0001').append(materialflexprops).append('\u0001').append(configuredcode).append('\u0001').append(tracknumber).append('\u0001').append(projectnumber).append('\u0001').append(supplier).append('\u0001').append(supplyorgunit).append('\u0001').append(planScope).append('\u0001').append(warehouse);
            return String.valueOf(sb.toString().hashCode());
        }
        Long bill_id = (Long)MRPUtil.convert((Object)supply.getValue(DefaultField.SupplyField.BILLID.getName()), (Object)0L);
        Long billentry_id = (Long)MRPUtil.convert((Object)supply.getValue(DefaultField.SupplyField.BILLENTRYID.getName()), (Object)0L);
        if (billentry_id == 0L) {
            billentry_id = bill_id;
        }
        return bill_id.toString() + '-' + billentry_id;
    }

    private static boolean isAvailStockData(IMRPEnvProvider ctx, SupplymentDataTable supplyTbl, RowData supply) {
        ResDataModelCollection resDataModelCollection = (ResDataModelCollection)ctx.getService(ResDataModelCollection.class);
        PlanModel planModel = (PlanModel)ctx.getService(PlanModel.class);
        boolean isInv = MRPUtil.convert((Object)supply.getValue(DefaultField.SupplyField.ISSTORAGEDATA.getName()), (Boolean)Boolean.FALSE);
        if (isInv) {
            Long material = (Long)MRPUtil.convert((Object)supply.getValue(DefaultField.SupplyField.MATERIAL.getName()), (Object)0L);
            Long warehouse = (Long)MRPUtil.convert((Object)supply.getValue(DefaultField.SupplyField.WAREHOUSE.getName()), (Object)0L);
            String supplyorgunit = String.valueOf(supply.getValue(DefaultField.SupplyField.SUPPLYORGUNIT.getName()));
            Object stockOrg = supply.getValue(DefaultField.SupplyField.STOCKORG.getName());
            String supplyId = stockOrg == null ? supplyorgunit : stockOrg.toString();
            SupplyStruct struct = (SupplyStruct)planModel.getPriorityRelations().get(supplyorgunit);
            InvRealBalanceStruct invacc = new InvRealBalanceStruct((CalEnv)ctx, supplyTbl.getColIdx(), supply.getValues());
            InvSupplyStruct inv = struct == null ? null : (InvSupplyStruct)struct.getInvSupplys().get(supplyId);
            return struct != null && ResDataModelCollection.checkStockTypeAndStatus((SupplymentDataTable)supplyTbl, (SupplyStruct)struct, (InvRealBalanceStruct)invacc, (Object[])supply.getValues()) && resDataModelCollection.isWarehouseDataHavScope(struct, inv, warehouse, material.toString(), false, new HashSet());
        }
        return true;
    }

    private static void addGroupRow(String groupTag, List<Object[]> builder, boolean isMTS, int colCnt) {
        if (isMTS) {
            return;
        }
        Object[] groupRow = new Object[colCnt];
        groupRow[17] = groupTag;
        groupRow[4] = null;
        groupRow[colCnt - 1] = null;
        builder.add(groupRow);
    }

    private static Object[] copyRequire(RequireRowData require, List<Object[]> builder, int colCnt, Long planScopeId, String innercoptype, Boolean isShowProject, Boolean isShowTrackNumber, Boolean isShowConfigureCode, BigDecimal reserveQty) {
        Object[] row = new Object[colCnt];
        int i = 0;
        Long supplyOrgId = require.getLong(DefaultField.RequireField.SUPPLYORGUNIT.getName());
        Long requireOrgId = require.getLong(DefaultField.RequireField.PRODUCTIONORGUNIT.getName());
        row[i++] = requireOrgId;
        row[i++] = require.get(DefaultField.RequireField.MATERIAL.getName());
        row[i++] = require.get(DefaultField.RequireField.BASEUNIT.getName());
        Long rts = require.getLong(DefaultField.RequireField.__ORIGIN_DEMAND_DATE__.getName());
        if (rts == null) {
            rts = require.getLong(DefaultField.RequireField.DATE.getName());
        }
        row[i++] = new Timestamp(rts);
        row[i++] = require.getBigDecimal(DefaultField.RequireField.__SUPPLY_QTY__.getName()).multiply(NEGATIVE_ONE);
        row[i++] = require.get(DefaultField.RequireField.BILLID.getName());
        int n = i++;
        String billNumber = require.getString(DefaultField.RequireField.BILLNUMBER.getName());
        row[n] = billNumber;
        int n2 = i++;
        String entrySeq = require.getString(DefaultField.RequireField.BILLENTRYSEQ.getName());
        row[n2] = entrySeq;
        Object conf = require.get(DefaultField.RequireField.CONFIGUREDCODE.getName());
        row[i++] = conf == null ? Long.valueOf(0L) : conf;
        row[i++] = require.get(DefaultField.RequireField.TRACKNUMBER.getName());
        row[i++] = require.get(DefaultField.RequireField.MATERIALFLEXPROPS.getName());
        row[i++] = require.get(DefaultField.RequireField.PROJECTNUMBER.getName());
        int n3 = i++;
        Long planScope = require.getLong(DefaultField.RequireField.PLANSCOPE.getName());
        row[n3] = planScope;
        row[i++] = require.get(DefaultField.RequireField.WAREHOUSE.getName());
        row[i++] = require.get(DefaultField.RequireField.BILL_ENTITY.getName());
        row[i++] = require.get(DefaultField.CommonField.__MODEL_ID__.name());
        row[i++] = StringUtils.isEmpty((String)billNumber) ? "" : billNumber + (StringUtils.isEmpty((String)entrySeq) ? "" : "_" + entrySeq);
        row[i++] = ResManager.loadKDString((String)"\u9700\u6c42\u884c", (String)"MRPDataBalanceResolver4RealTimeRpt_2", (String)"mmc-mrp-mservice-calcnode", (Object[])new Object[0]);
        row[i++] = supplyOrgId;
        row[i++] = require.getLong("ENTRYENTITY.SUPPLIER");
        row[i++] = require.getLong("ENTRYENTITY.CUSTOMER");
        row[i++] = require.getString("ENTRYENTITY.MATERIALATTR");
        row[i++] = MRPUtil.convert((Object)require.getBigDecimal(DefaultField.RequireField.ONWORKQTY.getName()), (Object)BigDecimal.ZERO);
        row[i++] = MRPUtil.convert((Object)require.getBigDecimal(DefaultField.RequireField.PICKEDQTY.getName()), (Object)BigDecimal.ZERO);
        boolean isStock = MRPUtil.convert((Object)require.getBoolean(DefaultField.RequireField.ISSTOCK.getName()), (Boolean)Boolean.FALSE);
        if (!isStock) {
            isStock = "mds_safetystock".equals(require.getString(DefaultField.RequireField.BILL_ENTITY.getName()));
        }
        row[i++] = isStock ? 0 : 1;
        row[i++] = require.getString(DefaultField.CommonField.__MODEL_NUMBER__.name());
        row[i++] = MRPUtil.convert((Object)require.getValue(DefaultField.RequireField.BILLSTATUSFIELD.getName()), (Object)"");
        row[i++] = null;
        if (reserveQty == null) {
            reserveQty = BigDecimal.ZERO;
        }
        row[i++] = reserveQty;
        row[i++] = null;
        row[i++] = "";
        if (!planScopeId.equals(planScope) || "msplan_matplanscop".equals(require.getString(DefaultField.RequireField.BILL_ENTITY.getName()))) {
            return null;
        }
        if ("A".equals(innercoptype)) {
            row[18] = null;
        }
        if (isShowProject != null && !isShowProject.booleanValue()) {
            row[11] = null;
        }
        if (isShowTrackNumber != null && !isShowTrackNumber.booleanValue()) {
            row[9] = null;
        }
        if (isShowConfigureCode != null && !isShowConfigureCode.booleanValue()) {
            row[8] = null;
        }
        builder.add(row);
        return row;
    }

    private static Object[] copySupply(IMRPEnvProvider ctx, RowData supply, List<Object[]> builder, int colCnt, Long planScopeId, String innercoptype, Boolean isShowProject, Boolean isShowTrackNumber, Boolean isShowConfigureCode, Long queryOrgId, BigDecimal reserveQty) {
        boolean isSamePlanScope;
        Long date;
        Object[] row = new Object[colCnt];
        int i = 0;
        Long supplyOrgId = supply.getLong(DefaultField.SupplyField.SUPPLYORGUNIT.getName());
        Long requireOrgId = supply.getLong("ENTRYENTITY.REQUIREORG");
        row[i++] = supplyOrgId;
        row[i++] = supply.get(DefaultField.SupplyField.MATERIAL.getName());
        row[i++] = supply.get(DefaultField.SupplyField.BASEUNIT.getName());
        row[i++] = new Timestamp(supply.getLong(DefaultField.SupplyField.DATE.getName()));
        int n = i++;
        BigDecimal qty = supply.getBigDecimal(DefaultField.SupplyField.QTY.getName());
        row[n] = qty;
        row[i++] = supply.get(DefaultField.SupplyField.BILLID.getName());
        int n2 = i++;
        String billNumber = supply.getString(DefaultField.SupplyField.BILLNUMBER.getName());
        row[n2] = billNumber;
        int n3 = i++;
        String entrySeq = supply.getString(DefaultField.SupplyField.BILLENTRYSEQ.getName());
        row[n3] = entrySeq;
        Object conf = supply.get(DefaultField.SupplyField.CONFIGUREDCODE.getName());
        row[i++] = conf == null ? Long.valueOf(0L) : conf;
        row[i++] = supply.get(DefaultField.SupplyField.TRACKNUMBER.getName());
        row[i++] = supply.get(DefaultField.SupplyField.MATERIALFLEXPROPS.getName());
        Object p = supply.get(DefaultField.SupplyField.PROJECTNUMBER.getName());
        row[i++] = p == null ? Long.valueOf(0L) : p;
        Long planScope = supply.getLong(DefaultField.SupplyField.PLANSCOPE.getName());
        if (planScope == null || planScope == 0L) {
            planScope = supply.getLong(DefaultField.SupplyField.DYNAMIC_PLANSCOPE.getName());
        }
        if (planScope == null) {
            planScope = 0L;
        }
        row[i++] = planScope;
        row[i++] = supply.get(DefaultField.SupplyField.WAREHOUSE.getName());
        row[i++] = supply.get(DefaultField.SupplyField.BILL_ENTITY.getName());
        row[i++] = supply.get(DefaultField.CommonField.__MODEL_ID__.name());
        row[i++] = StringUtils.isEmpty((String)billNumber) ? "" : billNumber + (StringUtils.isEmpty((String)entrySeq) ? "" : "_" + entrySeq);
        row[i++] = ResManager.loadKDString((String)"\u4f9b\u5e94\u884c", (String)"MRPDataBalanceResolver4RealTimeRpt_3", (String)"mmc-mrp-mservice-calcnode", (Object[])new Object[0]);
        row[i++] = requireOrgId;
        row[i++] = supply.getLong("ENTRYENTITY.SUPPLIER");
        row[i++] = supply.getLong("ENTRYENTITY.CUSTOMER");
        row[i++] = supply.getLong("ENTRYENTITY.MATERIALATTR");
        row[i++] = MRPUtil.convert((Object)supply.getBigDecimal(DefaultField.SupplyField.ONWORKQTY.getName()), (Object)BigDecimal.ZERO);
        row[i++] = MRPUtil.convert((Object)supply.getBigDecimal(DefaultField.SupplyField.PICKEDQTY.getName()), (Object)BigDecimal.ZERO);
        row[i++] = "im_inv_realbalance".equals(supply.get(DefaultField.SupplyField.BILL_ENTITY.getName())) ? 0 : 1;
        row[i++] = supply.getString(DefaultField.CommonField.__MODEL_NUMBER__.name());
        row[i++] = MRPUtil.convert((Object)supply.getValue(DefaultField.SupplyField.BILLSTATUSFIELD.getName()), (Object)"");
        if (reserveQty == null) {
            reserveQty = BigDecimal.ZERO;
        }
        if ((date = supply.getLong("ENTRYENTITY.PREPAREDATE")) != null && date > 0L) {
            row[i++] = new Timestamp(date);
            if (ctx.getCfgValue(EnvCfgItem.REALTIMERPT_DATEFIELD_STRATEGY).equals("PREPAREDATEFIRST")) {
                row[3] = row[i - 1];
            }
        } else {
            row[i++] = null;
        }
        row[i++] = reserveQty;
        row[i++] = qty.compareTo(reserveQty) <= 0 ? BigDecimal.ZERO : qty.subtract(reserveQty);
        row[i++] = MRPUtil.convert((Object)supply.getValue("ENTRYENTITY.RELEVANCEBILL"), (Object)"");
        row[i++] = qty;
        if ("A".equals(innercoptype)) {
            row[0] = requireOrgId;
            row[18] = supplyOrgId;
        }
        if (isShowProject != null && !isShowProject.booleanValue()) {
            row[11] = null;
        }
        if (isShowTrackNumber != null && !isShowTrackNumber.booleanValue()) {
            row[9] = null;
        }
        if (isShowConfigureCode != null && !isShowConfigureCode.booleanValue()) {
            row[8] = null;
        }
        boolean bl = isSamePlanScope = planScopeId.longValue() == planScope.longValue();
        if (supplyOrgId.longValue() == queryOrgId.longValue()) {
            if (planScope == 0L) {
                row[colCnt - 1] = null;
            } else if (!isSamePlanScope) {
                String type = supply.getString(DefaultField.SupplyField.INTER_COLLABORTYPE.getName());
                if (type == null || "B".equals(type)) {
                    return null;
                }
                row[colCnt - 1] = null;
            }
            builder.add(row);
            return row;
        }
        if (!isSamePlanScope) {
            return null;
        }
        builder.add(row);
        return row;
    }

    private String getInnerCopType(Long supplyOrgId, Long planScopeId) {
        String innerCopType;
        String key;
        block28: {
            key = String.format("%s\u0001%s\u0002%s", supplyOrgId, planScopeId, this.materialId);
            innerCopType = this.cache.get(key);
            if (innerCopType != null) {
                return innerCopType;
            }
            String fields = "id, createorg, entrymatplanscop.planscope, material, entrymatplanscop.inter_assist_type.type";
            String algoKey = MRPDataBalanceResolver4RealTimeRpt.class.getName();
            ORM orm = ORM.create();
            try (DataSet ds = orm.queryDataSet(algoKey, "msplan_matplanscop", fields, new QFilter[]{new QFilter("createorg", "=", (Object)supplyOrgId), new QFilter("material", "=", (Object)this.materialId), new QFilter("entrymatplanscop.planscope", "=", (Object)planScopeId)});){
                if (ds.hasNext()) {
                    innerCopType = ds.next().getString("entrymatplanscop.inter_assist_type.type");
                    break block28;
                }
                try (DataSet mpDs = orm.queryDataSet(algoKey, "mpdm_materialplan", "id, inter_assist_type.type", new QFilter[]{new QFilter("masterid", "=", (Object)this.materialId), new QFilter("status", "=", (Object)"C"), BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_materialplan", (Long)supplyOrgId)});){
                    if (mpDs.hasNext()) {
                        innerCopType = mpDs.next().getString("inter_assist_type.type");
                    }
                }
            }
        }
        if (innerCopType == null) {
            innerCopType = "B";
        }
        this.cache.put(key, innerCopType);
        return innerCopType;
    }
}

