/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.calcnode.framework.mq.resolver.cps;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.StringUtils;
import kd.mmc.mrp.calcnode.framework.mq.resolver.cps.CPSSupplyStatNode;
import kd.mmc.mrp.calcnode.framework.mq.resolver.cps.MaterialAttrCmp2;
import kd.mmc.mrp.calcnode.framework.step.MRPCalQty4SupplyOrgStep;
import kd.mmc.mrp.calcnode.framework.step.MRPMDependentReqNewStep;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.integrate.KDCloudCPSEnv;
import kd.mmc.mrp.integrate.entity.CacheDatas;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mmc.mrp.model.enums.ResType;
import kd.mmc.mrp.model.enums.strategy.MaterialAttribute;
import kd.mmc.mrp.model.struct.ReplaceMaterialStruct;
import kd.mmc.mrp.model.struct.ReplaceStruct;
import kd.mmc.mrp.model.table.DataBalanceTable;
import kd.mmc.mrp.model.table.RequireRowData;
import kd.mmc.mrp.model.table.RowData;
import kd.mmc.mrp.model.table.res.BOMStructDataTable;
import kd.mmc.mrp.model.table.res.RequirementDataTable;
import kd.mmc.mrp.model.table.res.SupplymentDataTable;
import kd.mmc.mrp.model.table.utils.DataMatchUtils;
import kd.mmc.mrp.utils.CPSUtil;
import kd.mmc.mrp.utils.MRPUtil;

public class CPSRequireStatNode
implements Serializable {
    private static Log logger = LogFactory.getLog(CPSRequireStatNode.class);
    private static final long serialVersionUID = 999154902541624175L;
    private Integer supplyRowIdx;
    private RequireRowData reqData;
    private Map<String, Integer> bomCache;
    private Map<String, List<Integer>> bomChildrenCache;
    Map<String, ReplaceStruct> replaceMap;
    private Map<Integer, CPSSupplyStatNode> allUsedSupplys;
    private StringBuilder keyBuffer;
    private MRPMDependentReqNewStep dateUtil;
    private List<CPSSupplyStatNode> changedNodes = new LinkedList<CPSSupplyStatNode>();
    private List<CPSRequireStatNode> changedStats = new LinkedList<CPSRequireStatNode>();
    private List<CPSSupplyStatNode> subChangedNodes = new LinkedList<CPSSupplyStatNode>();
    private List<CPSRequireStatNode> subChangedStats = new LinkedList<CPSRequireStatNode>();
    private int llc;
    private int topReqIdx;
    private int parentReqIdx;
    private int mainCycleCount = 0;
    private int mftChildrenCycleCount;
    private int bomChildrenCycleCount;
    private int subLogLevel;
    private List<RequireRowData> bomChildren;
    private List<RequireRowData> mftChildren;
    private Map<String, CPSRequireStatNode> statsCache4MFT;
    private Map<String, CPSRequireStatNode> statsCache4BOM;
    private Map<String, List<Integer>> supplyCache = new HashMap<String, List<Integer>>();
    private String keyPrefix;
    private String path = "";
    private boolean isConflict = false;
    private Set<String> consumes = new HashSet<String>();
    private Long cpsDate = 0L;
    private Set<String> onWorkSupplys = new HashSet<String>();
    private Map<Integer, Boolean> existKeyPartMap = new HashMap<Integer, Boolean>();
    private String uuid;
    private boolean isWayFullSet = false;

    public CPSRequireStatNode(String keyPrefix, int topReqIdx, RequireRowData reqData, int parentReqIdx, Integer supplyRowIdx, int llc, int subLogLevel) {
        this.keyPrefix = keyPrefix + "-";
        this.topReqIdx = topReqIdx;
        this.parentReqIdx = parentReqIdx;
        this.reqData = reqData;
        this.supplyRowIdx = supplyRowIdx;
        this.llc = llc;
        this.subLogLevel = subLogLevel;
    }

    public void initialize(Map<String, CPSRequireStatNode> statsCache4MFT, Map<String, CPSRequireStatNode> statsCache4BOM, Map<String, List<Integer>> supplyCache, Map<Integer, CPSSupplyStatNode> allUsedSupplys, Map<String, Integer> bomCache, Map<String, List<Integer>> bomChildrenCache, StringBuilder keyBuffer, Map<Integer, Boolean> existKeyPartMap) {
        this.statsCache4MFT = statsCache4MFT;
        this.statsCache4BOM = statsCache4BOM;
        this.supplyCache = supplyCache;
        this.allUsedSupplys = allUsedSupplys;
        this.bomCache = bomCache;
        this.bomChildrenCache = bomChildrenCache;
        this.keyBuffer = keyBuffer;
        this.existKeyPartMap = existKeyPartMap;
    }

    public void setDateUtil(MRPMDependentReqNewStep dateUtil) {
        this.dateUtil = dateUtil;
    }

    private String buildPath(BigDecimal netDemand, String path, Integer supplyIdx, Integer requireIdx, String uuid) {
        String auxpty = (String)MRPUtil.convert((Object)this.reqData.getValue(DefaultField.RequireField.MATERIALFLEXPROPS.getName()), (Object)"0");
        String configCode = (String)MRPUtil.convert((Object)this.reqData.getValue(DefaultField.RequireField.CONFIGUREDCODE.getName()), (Object)"0");
        String trackNumber = (String)MRPUtil.convert((Object)this.reqData.getValue(DefaultField.RequireField.TRACKNUMBER.getName()), (Object)"0");
        path = StringUtils.isEmpty((String)path) ? netDemand + "\u0001" + String.valueOf(this.reqData.getValue(DefaultField.RequireField.MATERIAL.getName())) + "\u0001" + auxpty + "\u0001" + configCode + "\u0001" + trackNumber + "\u0001" + supplyIdx + "\u0001" + uuid : path + "\u0001" + netDemand + "\u0001" + String.valueOf(this.reqData.getValue(DefaultField.RequireField.MATERIAL.getName())) + "\u0001" + auxpty + "\u0001" + configCode + "\u0001" + trackNumber + "\u0001" + supplyIdx + "\u0001" + uuid;
        return path;
    }

    public BigDecimal calcUsageStats(KDCloudCPSEnv ctx, BigDecimal netDemand, BigDecimal min, RequireRowData topRow, Integer supplyIdx) {
        long start = System.currentTimeMillis();
        if (topRow == null) {
            topRow = this.reqData;
        }
        String oldPath = this.path;
        this.path = this.buildPath(netDemand, this.path, supplyIdx, topRow.getRowIdx(), this.uuid);
        BigDecimal ret = this.calcUsageStatsImpl(ctx, netDemand, min, topRow);
        this.path = oldPath;
        if (this.llc == 0 && "1".equals(ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
            logger.warn(String.format("mmc-cps-mrprunner, mId: %s, cost: %s, mainCycle: %s, mftChildrenCycle: %s, bomChildrenCycle: %s", this.reqData.getValue(DefaultField.RequireField.MATERIAL.getName()), (System.currentTimeMillis() - start) / 1000L, this.mainCycleCount, this.mftChildrenCycleCount, this.bomChildrenCycleCount));
        }
        return ret;
    }

    public void finish(IMRPEnvProvider ctx, BigDecimal topComplete) {
        this.consumes.clear();
        RequirementDataTable requireTbl = ctx.requireDatas();
        SupplymentDataTable supplyTbl = ctx.supplyDatas();
        for (Map.Entry<Integer, CPSSupplyStatNode> entry : this.allUsedSupplys.entrySet()) {
            Integer k = entry.getKey();
            CPSSupplyStatNode v = entry.getValue();
            v.finish();
            if (!MRPUtil.convert((Object)supplyTbl.getValue(DefaultField.SupplyField.ISONWORK.getName(), k.intValue()), (Boolean)Boolean.FALSE).booleanValue()) continue;
            Integer findSupOrReqIndex = MRPUtil.findSupOrReqIndex((IMRPEnvProvider)ctx, (boolean)false, (Integer)k);
            requireTbl.updateValue(DefaultField.RequireField.QTY.getName(), findSupOrReqIndex, (Object)v.getMaxQty().subtract(v.getConsumeQty4Dep()).subtract(v.getConsumeQty4BOM()).subtract(v.getConsumeQty4DepSupply()));
        }
        for (CPSSupplyStatNode node : this.changedNodes) {
            node.finish();
        }
        this.changedNodes.clear();
        this.subChangedNodes.clear();
        for (CPSRequireStatNode stats : this.changedStats) {
            stats.finish(ctx, topComplete);
        }
        this.changedStats.clear();
        this.subChangedStats.clear();
    }

    public void doRollback() {
        this.consumes.clear();
        this.changedNodes.forEach(node -> node.doRollback());
        this.changedStats.forEach(stats -> stats.doRollback());
        this.changedNodes.clear();
        this.subChangedNodes.clear();
        this.changedStats.clear();
        this.subChangedStats.clear();
        this.onWorkSupplys.clear();
    }

    public boolean isConflict() {
        return this.isConflict;
    }

    public boolean isWayFullSet() {
        return this.isWayFullSet;
    }

    public Long getCPSDate() {
        return this.cpsDate;
    }

    public Integer getTopRowIdx() {
        return this.topReqIdx;
    }

    public Integer getSupplyRowIdx() {
        return this.supplyRowIdx;
    }

    private BigDecimal calcUsageStatsImpl(KDCloudCPSEnv ctx, BigDecimal netDemand, BigDecimal min, RequireRowData topRow) {
        if (this.dateUtil == null) {
            this.dateUtil = new MRPMDependentReqNewStep((IMRPEnvProvider)ctx);
        }
        if (this.supplyRowIdx < 0) {
            return this.calcMaxCompleteQty(ctx, netDemand, new ArrayList<RequireRowData>(), null, min, topRow);
        }
        SupplymentDataTable supplyTbl = ctx.supplyDatas();
        CPSSupplyStatNode node = this.allUsedSupplys.get(this.supplyRowIdx);
        Boolean isOnWork = MRPUtil.convert((Object)supplyTbl.getValue(DefaultField.SupplyField.ISONWORK.getName(), this.supplyRowIdx.intValue()), (Boolean)Boolean.FALSE);
        if (isOnWork.booleanValue()) {
            return this.calcOnWorkQty(ctx, node, supplyTbl, netDemand, min, topRow);
        }
        return this.calcCompleteQty((IMRPEnvProvider)ctx, node, supplyTbl, netDemand, topRow);
    }

    private BigDecimal calcOnWorkQty(KDCloudCPSEnv ctx, CPSSupplyStatNode node, SupplymentDataTable supplyTbl, BigDecimal netDemand, BigDecimal min, RequireRowData topRow) {
        this.onWorkSupplys.add((String)MRPUtil.convert((Object)supplyTbl.getValue(DefaultField.SupplyField.BILLENTRYID.getName(), this.supplyRowIdx.intValue()), (Object)""));
        ArrayList<RequireRowData> subRows = new ArrayList<RequireRowData>(16);
        BigDecimal completeQty = this.calcQtyByChildrenReceive((IMRPEnvProvider)ctx, subRows, netDemand, this.supplyRowIdx);
        BigDecimal targetQty = (BigDecimal)MRPUtil.convert((Object)supplyTbl.getValue(DefaultField.SupplyField.QTY.getName(), this.supplyRowIdx.intValue()), (Object)BigDecimal.ZERO);
        if (node == null) {
            node = this.initOnWorkStatNode((IMRPEnvProvider)ctx, this.reqData, this.supplyRowIdx, targetQty, this, netDemand);
        }
        node.doSnap(this.changedNodes);
        node.doSnap(this.subChangedNodes);
        if (netDemand.compareTo(node.getMaxQty()) >= 0) {
            netDemand = node.getMaxQty();
        }
        if (completeQty.compareTo(BigDecimal.ZERO) > 0) {
            node.setConsumeQty4Dep(this.topReqIdx, this.llc, completeQty, this.path, topRow);
            this.addCompleteDatas(ctx, completeQty);
            netDemand = netDemand.subtract(completeQty);
        }
        if (netDemand.compareTo(BigDecimal.ZERO) > 0) {
            if (min.compareTo(netDemand) > 0) {
                min = netDemand;
            }
            BigDecimal canWorkQty = this.calcMaxCompleteQty(ctx, netDemand, subRows, node, min, topRow);
            node.setConsumeQty4DepSupply(this.topReqIdx, this.llc, canWorkQty, this.reqData, this.path);
            completeQty = completeQty.add(canWorkQty);
        }
        return completeQty;
    }

    private BigDecimal calcCompleteQty(IMRPEnvProvider ctx, CPSSupplyStatNode node, SupplymentDataTable supplyTbl, BigDecimal netDemand, RequireRowData topRow) {
        BigDecimal supplyQty = (BigDecimal)MRPUtil.convert((Object)supplyTbl.getValue(DefaultField.SupplyField.QTY.getName(), this.supplyRowIdx.intValue()), (Object)BigDecimal.ZERO);
        if (node != null) {
            supplyQty = supplyQty.subtract(node.getConsumeQty4BOM()).subtract(node.getConsumeQty4DepSupply());
        } else {
            node = this.initStatNode(ctx, this.supplyRowIdx, supplyQty);
        }
        this.cpsDate = Math.max(this.cpsDate, (Long)MRPUtil.convert((Object)supplyTbl.getValue(DefaultField.SupplyField.DATE.getName(), this.supplyRowIdx.intValue()), (Object)0L));
        if (!MRPUtil.convert((Object)supplyTbl.getValue(DefaultField.SupplyField.ISSTORAGEDATA.getName(), this.supplyRowIdx.intValue()), (Boolean)Boolean.FALSE).booleanValue()) {
            this.isWayFullSet = true;
        }
        node.doSnap(this.changedNodes);
        node.doSnap(this.subChangedNodes);
        if (supplyQty.compareTo(netDemand) >= 0) {
            supplyQty = netDemand;
        }
        node.setConsumeQty4BOM(this.topReqIdx, this.llc, supplyQty, this.path, this.reqData);
        return supplyQty;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BigDecimal calcMaxCompleteQty(KDCloudCPSEnv ctx, BigDecimal netDemand, List<RequireRowData> subRows, CPSSupplyStatNode currentNode, BigDecimal min, RequireRowData topRow) {
        try (TraceSpan ts = Tracer.create((String)"CPSCalc", (String)"calcMaxCompleteQty");){
            BigDecimal bigDecimal = this.calcMaxCompleteQtyImpl(ctx, netDemand, subRows, currentNode, min, topRow);
            return bigDecimal;
        }
    }

    private BigDecimal calcMaxCompleteQtyImpl(KDCloudCPSEnv ctx, BigDecimal netDemand, List<RequireRowData> subRows, CPSSupplyStatNode currentNode, BigDecimal min, RequireRowData topRow) {
        List<RequireRowData> tmpBomChildren;
        if (subRows.isEmpty()) {
            if (this.bomChildren == null) {
                if (MaterialAttribute.PURCHASEDPART.getValue() == ((Integer)MRPUtil.convert((Object)this.reqData.get(DefaultField.RequireField.MATERIALATTR.getName()), (Object)MaterialAttribute.OTHER.getValue())).intValue()) {
                    tmpBomChildren = new ArrayList<RequireRowData>(0);
                } else if (this.reqData.getValue(DefaultField.RequireField.SUPPLYORGUNIT.getName()) == null) {
                    CPSUtil.tagBOMNotFound((RequireRowData)this.reqData);
                    tmpBomChildren = new ArrayList<RequireRowData>(0);
                } else {
                    int bomIdx = this.dateUtil.findBOM((RowData)this.reqData, netDemand);
                    if (bomIdx < 0) {
                        if (!"A".equals(ctx.getCPSType())) {
                            CPSUtil.tagBOMNotFound((RequireRowData)this.reqData);
                        }
                        tmpBomChildren = new ArrayList<RequireRowData>(0);
                    } else {
                        tmpBomChildren = this.initBOMEntrys((IMRPEnvProvider)ctx, this.reqData, bomIdx, netDemand, false);
                        tmpBomChildren.sort(new MaterialAttrCmp2());
                        this.replaceMap = CPSUtil.getReplaceMap((IMRPEnvProvider)ctx, tmpBomChildren);
                        this.bomChildren = tmpBomChildren;
                    }
                }
            } else {
                tmpBomChildren = this.bomChildren;
            }
        } else {
            if (this.mftChildren == null) {
                subRows.sort(new MaterialAttrCmp2());
                if (BigDecimal.ZERO.compareTo(netDemand) >= 0) {
                    return BigDecimal.ZERO;
                }
                this.mftChildren = subRows;
                this.replaceMap = CPSUtil.getReplaceMap((IMRPEnvProvider)ctx, this.mftChildren);
            }
            tmpBomChildren = this.mftChildren;
        }
        if (tmpBomChildren.isEmpty() && !ctx.isKeyPart()) {
            return BigDecimal.ZERO;
        }
        BigDecimal targetQty = this.calcTargetQty(ctx, netDemand, tmpBomChildren, min, topRow);
        return targetQty;
    }

    private BigDecimal calcTargetQty4KeyPart(KDCloudCPSEnv ctx, BigDecimal targetQty, List<RequireRowData> tmpBomChildren, BigDecimal min, RequireRowData topRow) {
        this.targetKeyPart(ctx, targetQty, tmpBomChildren, this.reqData);
        Boolean isKeyPart = MRPUtil.convert((Object)this.reqData.getValue(DefaultField.RequireField.__IS_KEYPART__.getName()), (Boolean)Boolean.FALSE);
        boolean isNoSupply = this.supplyRowIdx < 0;
        RequirementDataTable requireTbl = ctx.requireDatas();
        SupplymentDataTable supplyTbl = ctx.supplyDatas();
        boolean isExist = false;
        for (RequireRowData row : tmpBomChildren) {
            if (!MRPUtil.convert((Object)row.getValue(DefaultField.RequireField.__EXIST_KEYPART__.getName()), (Boolean)Boolean.FALSE).booleanValue()) continue;
            isExist = true;
            break;
        }
        if ("1".equals(ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
            logger.warn(String.format("mmc-cps-mrprunner, CPSRequireStatNode,targetQty:%s,isExist:%s,tmpBomChildren.size:%s,material:%s,isNoSupply:%s,node:%s", targetQty, isExist, tmpBomChildren.size(), this.reqData.getValue(DefaultField.RequireField.MATERIAL.getName()), isNoSupply, this.allUsedSupplys.get(this.supplyRowIdx)));
        }
        if (!isExist) {
            CPSSupplyStatNode node;
            String copyPath = this.path;
            String[] virPath = copyPath.split("\u0001");
            if (virPath.length > 7) {
                CharSequence[] arr = new String[virPath.length - 7];
                System.arraycopy(virPath, 0, arr, 0, virPath.length - 7);
                copyPath = String.join((CharSequence)"\u0001", arr);
            }
            if (isKeyPart.booleanValue()) {
                if (tmpBomChildren.isEmpty()) {
                    return BigDecimal.ZERO;
                }
                if (!isNoSupply) {
                    node = this.allUsedSupplys.get(this.supplyRowIdx);
                    BigDecimal unUsedCompleteQty = node.getMaxQty().subtract(node.getConsumeQty4Dep());
                    node.doSnap(this.changedNodes);
                    node.doSnap(this.subChangedNodes);
                    if (unUsedCompleteQty.compareTo(BigDecimal.ZERO) > 0) {
                        if (unUsedCompleteQty.compareTo(targetQty) >= 0) {
                            node.setConsumeQty4Dep(this.topReqIdx, this.llc, targetQty, copyPath, topRow);
                        } else {
                            node.setConsumeQty4Dep(this.topReqIdx, this.llc, unUsedCompleteQty, copyPath, topRow);
                            targetQty = unUsedCompleteQty;
                        }
                    } else {
                        targetQty = BigDecimal.ZERO;
                    }
                    return targetQty;
                }
                int size = supplyTbl.getColIdx().size();
                Object[] data = new Object[size];
                data[((Integer)supplyTbl.getColIdx().get((Object)DefaultField.CommonField.__MODEL_NUMBER__.name())).intValue()] = this.reqData.getValue(DefaultField.CommonField.__MODEL_NUMBER__.name());
                data[((Integer)supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.SUPPLYORGUNIT.getName())).intValue()] = this.reqData.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName());
                data[((Integer)supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.DATE.getName())).intValue()] = this.reqData.getValue(DefaultField.RequireField.DATE.getName());
                data[((Integer)supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.BILLNUMBER.getName())).intValue()] = "";
                data[((Integer)supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.BILLID.getName())).intValue()] = this.reqData.getValue(DefaultField.RequireField.BILLID.getName());
                data[((Integer)supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.BILLENTRYID.getName())).intValue()] = this.reqData.getValue(DefaultField.RequireField.BILLENTRYID.getName());
                data[((Integer)supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.MATERIAL.getName())).intValue()] = this.reqData.getValue(DefaultField.RequireField.MATERIAL.getName());
                data[((Integer)supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.MATERIALATTR.getName())).intValue()] = this.reqData.getValue(DefaultField.RequireField.MATERIALATTR.getName());
                data[((Integer)supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.BILL_ENTITY.getName())).intValue()] = this.reqData.getValue(DefaultField.RequireField.BILL_ENTITY.getName());
                data[((Integer)supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.BILLENTRYSEQ.getName())).intValue()] = this.reqData.getValue(DefaultField.RequireField.BILLENTRYSEQ.getName());
                data[((Integer)supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.TRACKNUMBER.getName())).intValue()] = this.reqData.getValue(DefaultField.RequireField.TRACKNUMBER.getName());
                data[((Integer)supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.CONFIGUREDCODE.getName())).intValue()] = this.reqData.getValue(DefaultField.RequireField.CONFIGUREDCODE.getName());
                data[((Integer)supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.MATERIALFLEXPROPS.getName())).intValue()] = this.reqData.getValue(DefaultField.RequireField.MATERIALFLEXPROPS.getName());
                data[((Integer)supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.__VIRTUAL_SUPPLY__.getName())).intValue()] = true;
                data[((Integer)supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.QTY.getName())).intValue()] = this.reqData.getValue(DefaultField.RequireField.QTY.getName());
                data[((Integer)supplyTbl.getColIdx().get((Object)DefaultField.CommonField.__MODEL_NUMBER__.name())).intValue()] = ResManager.loadKDString((String)"\u9f50\u5957\u5efa\u8bae\u8ba1\u5212", (String)"CalcNetDemand_10", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]);
                RowData supply = new RowData(supplyTbl.getSrcDatas(), supplyTbl.getColIdx(), data, Integer.valueOf(supplyTbl.size() - 1), ResType.SUPPLY);
                int fillNoIndex2 = supplyTbl.fillNoIndex(supply);
                CPSSupplyStatNode node2 = this.initStatNode((IMRPEnvProvider)ctx, fillNoIndex2, targetQty);
                node2.doSnap(this.changedNodes);
                node2.doSnap(this.subChangedNodes);
                this.isWayFullSet = false;
                node2.setConsumeQty4BOM(this.topReqIdx, this.llc, targetQty, copyPath, this.reqData);
                return targetQty;
            }
            if (!isNoSupply) {
                node = this.allUsedSupplys.get(this.supplyRowIdx);
                BigDecimal unUsedCompleteQty = node.getMaxQty().subtract(node.getConsumeQty4Dep());
                node.doSnap(this.changedNodes);
                node.doSnap(this.subChangedNodes);
                if (unUsedCompleteQty.compareTo(BigDecimal.ZERO) > 0) {
                    if (unUsedCompleteQty.compareTo(targetQty) >= 0) {
                        node.setConsumeQty4Dep(this.topReqIdx, this.llc, targetQty, copyPath, topRow);
                    } else {
                        node.setConsumeQty4Dep(this.topReqIdx, this.llc, unUsedCompleteQty, copyPath, topRow);
                        targetQty = unUsedCompleteQty;
                    }
                } else {
                    targetQty = BigDecimal.ZERO;
                }
                return targetQty;
            }
            int size = supplyTbl.getColIdx().size();
            Object[] data = new Object[size];
            data[((Integer)supplyTbl.getColIdx().get((Object)DefaultField.CommonField.__MODEL_NUMBER__.name())).intValue()] = this.reqData.getValue(DefaultField.CommonField.__MODEL_NUMBER__.name());
            data[((Integer)supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.SUPPLYORGUNIT.getName())).intValue()] = this.reqData.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName());
            data[((Integer)supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.DATE.getName())).intValue()] = this.reqData.getValue(DefaultField.RequireField.DATE.getName());
            data[((Integer)supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.BILLNUMBER.getName())).intValue()] = "";
            data[((Integer)supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.BILLID.getName())).intValue()] = this.reqData.getValue(DefaultField.RequireField.BILLID.getName());
            data[((Integer)supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.BILLENTRYID.getName())).intValue()] = this.reqData.getValue(DefaultField.RequireField.BILLENTRYID.getName());
            data[((Integer)supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.MATERIAL.getName())).intValue()] = this.reqData.getValue(DefaultField.RequireField.MATERIAL.getName());
            data[((Integer)supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.MATERIALATTR.getName())).intValue()] = this.reqData.getValue(DefaultField.RequireField.MATERIALATTR.getName());
            data[((Integer)supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.BILL_ENTITY.getName())).intValue()] = this.reqData.getValue(DefaultField.RequireField.BILL_ENTITY.getName());
            data[((Integer)supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.BILLENTRYSEQ.getName())).intValue()] = this.reqData.getValue(DefaultField.RequireField.BILLENTRYSEQ.getName());
            data[((Integer)supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.TRACKNUMBER.getName())).intValue()] = this.reqData.getValue(DefaultField.RequireField.TRACKNUMBER.getName());
            data[((Integer)supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.CONFIGUREDCODE.getName())).intValue()] = this.reqData.getValue(DefaultField.RequireField.CONFIGUREDCODE.getName());
            data[((Integer)supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.MATERIALFLEXPROPS.getName())).intValue()] = this.reqData.getValue(DefaultField.RequireField.MATERIALFLEXPROPS.getName());
            data[((Integer)supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.__VIRTUAL_SUPPLY__.getName())).intValue()] = true;
            data[((Integer)supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.QTY.getName())).intValue()] = this.reqData.getValue(DefaultField.RequireField.QTY.getName());
            data[((Integer)supplyTbl.getColIdx().get((Object)DefaultField.CommonField.__MODEL_NUMBER__.name())).intValue()] = ResManager.loadKDString((String)"\u9f50\u5957\u5efa\u8bae\u8ba1\u5212", (String)"CalcNetDemand_10", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]);
            RowData supply = new RowData(supplyTbl.getSrcDatas(), supplyTbl.getColIdx(), data, Integer.valueOf(supplyTbl.size() - 1), ResType.SUPPLY);
            int fillNoIndex2 = supplyTbl.fillNoIndex(supply);
            CPSSupplyStatNode node3 = this.initStatNode((IMRPEnvProvider)ctx, fillNoIndex2, targetQty);
            node3.doSnap(this.changedNodes);
            node3.doSnap(this.subChangedNodes);
            this.isWayFullSet = false;
            node3.setConsumeQty4BOM(this.topReqIdx, this.llc, targetQty, copyPath, this.reqData);
            return targetQty;
        }
        this.isConflict = false;
        for (int i = 0; i < tmpBomChildren.size(); ++i) {
            BigDecimal unitUseQty;
            Boolean childExistKeyPart;
            ctx.testEnvStatus();
            ++this.mainCycleCount;
            RequireRowData reqData = tmpBomChildren.get(i);
            if (((String)MRPUtil.convert((Object)reqData.getString(DefaultField.RequireField.EXCEPTIONNUMBER.getName()), (Object)"")).contains("87") || !(childExistKeyPart = MRPUtil.convert((Object)reqData.getValue(DefaultField.RequireField.__EXIST_KEYPART__.getName()), (Boolean)Boolean.FALSE)).booleanValue() || BigDecimal.ZERO.compareTo(unitUseQty = (BigDecimal)reqData.getValue(DefaultField.RequireField.__DEPENDENT_UNIT_QTY__.getName())) == 0) continue;
            BigDecimal requireQty = BigDecimal.ZERO;
            BigDecimal fixScrap = BigDecimal.ZERO;
            if (ctx.isScrapRation()) {
                fixScrap = (BigDecimal)MRPUtil.convert((Object)reqData.getBigDecimal(DefaultField.RequireField.__CHILDFIXSCRAP__.getName()), (Object)BigDecimal.ZERO);
            }
            Object unit = reqData.getValue(DefaultField.RequireField.BASEUNIT.getName());
            String qtyType = reqData.getValue(DefaultField.RequireField.__CHILDAMTTYPE__.getName()) == null ? "A" : (String)reqData.getValue(DefaultField.RequireField.__CHILDAMTTYPE__.getName());
            requireQty = "B".equals(qtyType) ? unitUseQty.add(fixScrap) : MRPUtil.multiply2((IMRPEnvProvider)ctx, (Object)unit, (BigDecimal)targetQty, (BigDecimal)unitUseQty).add(fixScrap);
            if (reqData.getValue(DefaultField.RequireField.__SUPPLY_IDX__.getName()) != null) {
                CPSSupplyStatNode node = this.allUsedSupplys.get(reqData.getInteger(DefaultField.RequireField.__SUPPLY_IDX__.getName()));
                BigDecimal recQty = node.getMaxQty();
                recQty = recQty.subtract(node.getConsumeQty4DepSupply());
                node.doSnap(this.changedNodes);
                node.doSnap(this.subChangedNodes);
                if (requireQty.compareTo(recQty) > 0) {
                    requireQty = requireQty.subtract(recQty);
                    node.setConsumeQty4DepSupply(this.topReqIdx, this.llc + 1, recQty, reqData, this.path);
                } else {
                    node.setConsumeQty4DepSupply(this.topReqIdx, this.llc + 1, requireQty, reqData, this.path);
                    requireQty = BigDecimal.ZERO;
                    continue;
                }
            }
            if ("1".equals(ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                logger.warn(String.format("mmc-cps-mrprunner, CPSRequireStatNode,requireQty:%s,reqData:%s", requireQty, reqData));
            }
            BigDecimal originQty = requireQty;
            Object pId = this.reqData.getValue(DefaultField.RequireField.MATERIAL.getName());
            Object subId = reqData.getValue(DefaultField.RequireField.MATERIAL.getName());
            String cacheKey = this.keyPrefix + this.llc + "-" + i + "-" + subId;
            List supplys = this.supplyCache.get(cacheKey);
            if (supplys == null) {
                supplys = DataMatchUtils.findSupplysUtil((boolean)false, (RowData)reqData, (IMRPEnvProvider)ctx);
                MRPUtil.isUseEnableOrder((IMRPEnvProvider)ctx, (SupplymentDataTable)supplyTbl, (List)supplys, (RequireRowData)reqData);
                Iterator strategyId = reqData.getValue(DefaultField.RequireField.PLAN_STRATEGY.getName());
                Boolean isFastEnable = (Boolean)ctx.getCfgValue(EnvCfgItem.ENABLE_FAST_SUPLLY_SEARCH_MODE);
                if (!isFastEnable.booleanValue()) {
                    supplys = supplyTbl.sortByPriority(reqData.getString(DefaultField.RequireField.SUPPLYORGUNIT.getName()), supplys, strategyId == null ? null : String.valueOf(strategyId));
                    supplys.sort(new DataMatchUtils.SupplySortComparator((IMRPEnvProvider)ctx));
                }
                supplys = ctx.supplyDatas().sortSupplyByReserve((IMRPEnvProvider)ctx, supplys, reqData);
                this.supplyCache.put(cacheKey, supplys);
            }
            ctx.createLogRecorder().updateSubStepLog(this.subLogLevel, "entrydetailmsg_tag", (Object)String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u5c42\u7ea7\uff1a%1$s\uff0c\u9876\u5c42\u7269\u6599ID\uff1a%2$s\uff0c\u9700\u6c42\u7269\u6599ID\uff1a%3$s\uff0c\u5b50\u9879\u7269\u6599ID\uff1a%4$s\uff0c\u76ee\u6807\u9f50\u5957\u6570\u91cf\uff1a%5$s,\u9876\u5c42\u5355\u636e\u7f16\u7801\uff1a%6$s\uff0c\u9876\u5c42\u5355\u636e\u884c\u53f7\uff1a%7$s\uff0c\u9876\u5c42\u5355\u636e\u7c7b\u578b\uff1a%8$s\uff0c\u7236\u9879\u5355\u636e\u7f16\u7801\uff1a%9$s\uff0c\u7236\u9879\u5355\u636e\u884c\u53f7\uff1a%10$s\uff0c\u7236\u9879\u5355\u636e\u7c7b\u578b\uff1a%11$s\uff0c\u5355\u636e\u7f16\u7801\uff1a%12$s\uff0c\u5355\u636e\u884c\u53f7\uff1a%13$s\uff0c\u5355\u636e\u7c7b\u578b\uff1a%14$s", (String)"CPSRequireStatNode_0", (String)"mmc-mrp-mservice-calcnode", (Object[])new Object[0]), this.llc, requireTbl.getValue(DefaultField.RequireField.MATERIAL.getName(), this.topReqIdx), pId, subId, targetQty, requireTbl.getValue(DefaultField.RequireField.BILLNUMBER.getName(), this.topReqIdx), requireTbl.getValue(DefaultField.RequireField.BILLENTRYSEQ.getName(), this.topReqIdx), requireTbl.getValue(DefaultField.RequireField.BILL_ENTITY.getName(), this.topReqIdx), this.reqData.getValue(DefaultField.RequireField.BILLNUMBER.getName()), this.reqData.getValue(DefaultField.RequireField.BILLENTRYSEQ.getName()), this.reqData.getValue(DefaultField.RequireField.BILL_ENTITY.getName()), reqData.getValue(DefaultField.RequireField.BILLNUMBER.getName()), reqData.getValue(DefaultField.RequireField.BILLENTRYSEQ.getName()), reqData.getValue(DefaultField.RequireField.BILL_ENTITY.getName())));
            ctx.createLogRecorder().saveStepLog(false);
            for (Integer secSupplyRowIdx : supplys) {
                CPSSupplyStatNode node;
                ctx.testEnvStatus();
                BigDecimal subSupplyQty = (BigDecimal)MRPUtil.convert((Object)supplyTbl.getValue(DefaultField.SupplyField.QTY.getName(), secSupplyRowIdx.intValue()), (Object)BigDecimal.ZERO);
                Boolean isOnWork = MRPUtil.convert((Object)supplyTbl.getValue(DefaultField.SupplyField.ISONWORK.getName(), secSupplyRowIdx.intValue()), (Boolean)Boolean.FALSE);
                this.cpsDate = Math.max(this.cpsDate, (Long)MRPUtil.convert((Object)supplyTbl.getValue(DefaultField.SupplyField.DATE.getName(), secSupplyRowIdx.intValue()), (Object)0L));
                String supplyId = (String)MRPUtil.convert((Object)supplyTbl.getValue(DefaultField.SupplyField.BILLENTRYID.getName(), secSupplyRowIdx.intValue()), (Object)"");
                String requireId = (String)MRPUtil.convert((Object)reqData.getValue(DefaultField.RequireField.BILLENTRYID.getName()), (Object)"");
                Boolean isVirtual = MRPUtil.convert((Object)supplyTbl.getValue(DefaultField.SupplyField.__VIRTUAL_SUPPLY__.getName(), secSupplyRowIdx.intValue()), (Boolean)Boolean.FALSE);
                if (isVirtual.booleanValue() && !supplyId.equals(requireId)) continue;
                if (isOnWork.booleanValue()) {
                    if (this.onWorkSupplys.contains(supplyId) || this.onWorkSupplys.contains(supplyId + "\u0001" + requireId)) continue;
                    this.onWorkSupplys.add(supplyId + "\u0001" + requireId);
                    String key = this.keyPrefix + String.valueOf(subId);
                    CPSRequireStatNode onWorkStats = this.statsCache4MFT.get(key);
                    if (onWorkStats == null) {
                        String keyPrefix = this.keyPrefix + this.llc + "-" + i;
                        onWorkStats = new CPSRequireStatNode(keyPrefix, this.topReqIdx, reqData, this.getNearestParentIdx(reqData), secSupplyRowIdx, this.llc + 1, this.subLogLevel);
                        onWorkStats.initialize(this.statsCache4MFT, this.statsCache4BOM, this.supplyCache, this.allUsedSupplys, this.bomCache, this.bomChildrenCache, this.keyBuffer, this.existKeyPartMap);
                        this.statsCache4MFT.put(key, onWorkStats);
                        onWorkStats.bomCache = this.bomCache;
                        onWorkStats.bomChildrenCache = this.bomChildrenCache;
                        onWorkStats.allUsedSupplys = this.allUsedSupplys;
                        onWorkStats.keyBuffer = this.keyBuffer;
                        onWorkStats.dateUtil = this.dateUtil;
                    }
                    onWorkStats.reqData = reqData;
                    onWorkStats.parentReqIdx = this.getNearestParentIdx(reqData);
                    onWorkStats.consumes.clear();
                    onWorkStats.isConflict = false;
                    onWorkStats.consumes.addAll(this.consumes);
                    onWorkStats.llc = this.llc + 1;
                    onWorkStats.mainCycleCount = 0;
                    onWorkStats.mftChildrenCycleCount = 0;
                    onWorkStats.path = this.path;
                    onWorkStats.onWorkSupplys = this.onWorkSupplys;
                    onWorkStats.supplyRowIdx = secSupplyRowIdx;
                    onWorkStats.topReqIdx = this.topReqIdx;
                    node = this.initOnWorkStatNode((IMRPEnvProvider)ctx, reqData, secSupplyRowIdx, subSupplyQty, onWorkStats, requireQty);
                    this.changedStats.add(onWorkStats);
                    this.subChangedStats.add(onWorkStats);
                    ArrayList<RequireRowData> children = new ArrayList<RequireRowData>(16);
                    BigDecimal onWorkQty = this.calcQtyByChildrenReceive((IMRPEnvProvider)ctx, children, requireQty, secSupplyRowIdx);
                    if (onWorkQty.compareTo(BigDecimal.ZERO) > 0) {
                        node.doSnap(this.changedNodes);
                        node.doSnap(this.subChangedNodes);
                        if (onWorkQty.compareTo(requireQty) >= 0) {
                            node.setConsumeQty4Dep(this.topReqIdx, this.llc + 1, requireQty, this.path, reqData);
                            onWorkStats.addCompleteDatas(ctx, requireQty);
                            requireQty = BigDecimal.ZERO;
                        } else {
                            node.setConsumeQty4Dep(this.topReqIdx, this.llc + 1, onWorkQty, this.path, reqData);
                            onWorkStats.addCompleteDatas(ctx, onWorkQty);
                            requireQty = requireQty.subtract(onWorkQty);
                        }
                    }
                    if (requireQty.compareTo(BigDecimal.ZERO) > 0) {
                        BigDecimal subUnCompleteQty = node.getMaxQty();
                        if ((subUnCompleteQty = subUnCompleteQty.subtract(node.getConsumeQty4DepSupply()).subtract(node.getConsumeQty4Dep())).compareTo(BigDecimal.ZERO) > 0) {
                            BigDecimal yield;
                            node.doSnap(this.changedNodes);
                            node.doSnap(this.subChangedNodes);
                            if (ctx.isKeyPart()) {
                                this.targetKeyPart(ctx, targetQty, children, reqData);
                            }
                            if (ctx.isYield()) {
                                yield = (BigDecimal)MRPUtil.convert((Object)supplyTbl.getValue(DefaultField.SupplyField.YIELD.getName(), secSupplyRowIdx.intValue()), (Object)BigDecimal.ONE);
                                requireQty = MRPUtil.calcYield((BigDecimal)yield, (Object)supplyTbl.getValue(DefaultField.SupplyField.BASEUNIT.getName(), secSupplyRowIdx.intValue()), (BigDecimal)requireQty, (IMRPEnvProvider)ctx, (boolean)false);
                                subUnCompleteQty = MRPUtil.calcYield((BigDecimal)yield, (Object)supplyTbl.getValue(DefaultField.SupplyField.BASEUNIT.getName(), secSupplyRowIdx.intValue()), (BigDecimal)subUnCompleteQty, (IMRPEnvProvider)ctx, (boolean)false);
                            }
                            subUnCompleteQty = onWorkStats.calcMaxCompleteQty(ctx, CPSUtil.min((BigDecimal)requireQty, (BigDecimal)subUnCompleteQty), children, node, BigDecimal.ZERO, requireTbl.fetchRow(this.getNearestParentIdx(reqData)));
                            this.consumes.addAll(onWorkStats.consumes);
                            if (!this.isConflict) {
                                this.isConflict = onWorkStats.isConflict;
                            }
                            this.mainCycleCount += onWorkStats.mainCycleCount;
                            this.mftChildrenCycleCount += onWorkStats.mftChildrenCycleCount;
                            node.setConsumeQty4DepSupply(this.topReqIdx, this.llc + 1, subUnCompleteQty, reqData, this.path);
                            if (subUnCompleteQty.compareTo(requireQty) >= 0) {
                                subUnCompleteQty = requireQty;
                                requireQty = BigDecimal.ZERO;
                            } else {
                                requireQty = requireQty.subtract(subUnCompleteQty);
                                if (subUnCompleteQty.compareTo(BigDecimal.ZERO) > 0 && !MRPUtil.convert((Object)supplyTbl.getValue(DefaultField.SupplyField.ISSTORAGEDATA.getName(), secSupplyRowIdx.intValue()), (Boolean)Boolean.FALSE).booleanValue()) {
                                    this.isWayFullSet = true;
                                }
                            }
                            if (ctx.isYield()) {
                                yield = (BigDecimal)MRPUtil.convert((Object)supplyTbl.getValue(DefaultField.SupplyField.YIELD.getName(), secSupplyRowIdx.intValue()), (Object)BigDecimal.ONE);
                                requireQty = MRPUtil.calcYield((BigDecimal)yield, (Object)supplyTbl.getValue(DefaultField.SupplyField.BASEUNIT.getName(), secSupplyRowIdx.intValue()), (BigDecimal)requireQty, (IMRPEnvProvider)ctx, (boolean)true);
                                subUnCompleteQty = MRPUtil.calcYield((BigDecimal)yield, (Object)supplyTbl.getValue(DefaultField.SupplyField.BASEUNIT.getName(), secSupplyRowIdx.intValue()), (BigDecimal)subUnCompleteQty, (IMRPEnvProvider)ctx, (boolean)true);
                            }
                        }
                    }
                } else {
                    node = this.initStatNode((IMRPEnvProvider)ctx, secSupplyRowIdx, subSupplyQty);
                    subSupplyQty = subSupplyQty.subtract(node.getConsumeQty4BOM());
                    subSupplyQty = subSupplyQty.subtract(node.getConsumeQty4DepSupply());
                    node.doSnap(this.changedNodes);
                    node.doSnap(this.subChangedNodes);
                    if (subSupplyQty.compareTo(BigDecimal.ZERO) > 0 && !MRPUtil.convert((Object)supplyTbl.getValue(DefaultField.SupplyField.ISSTORAGEDATA.getName(), secSupplyRowIdx.intValue()), (Boolean)Boolean.FALSE).booleanValue()) {
                        this.isWayFullSet = true;
                    }
                    if (requireQty.compareTo(subSupplyQty) > 0) {
                        requireQty = requireQty.subtract(subSupplyQty);
                        if (isNoSupply) {
                            node.setConsumeQty4BOM(this.topReqIdx, this.llc + 1, subSupplyQty, this.path, reqData);
                        } else {
                            node.setConsumeQty4DepSupply(this.topReqIdx, this.llc + 1, subSupplyQty, reqData, this.path);
                        }
                    } else {
                        if (isNoSupply) {
                            node.setConsumeQty4BOM(this.topReqIdx, this.llc + 1, requireQty, this.path, reqData);
                        } else {
                            node.setConsumeQty4DepSupply(this.topReqIdx, this.llc + 1, requireQty, reqData, this.path);
                        }
                        requireQty = BigDecimal.ZERO;
                    }
                }
                if (requireQty.compareTo(BigDecimal.ZERO) != 0) continue;
                break;
            }
            if (requireQty.compareTo(BigDecimal.ZERO) > 0) {
                String key = this.keyPrefix + String.valueOf(subId);
                CPSRequireStatNode bomStats = this.statsCache4BOM.get(key);
                if (bomStats == null) {
                    String keyPrefix = this.keyPrefix + this.llc + "-" + i;
                    bomStats = new CPSRequireStatNode(keyPrefix, this.topReqIdx, reqData, this.getNearestParentIdx(reqData), -1, this.llc + 1, this.subLogLevel);
                    bomStats.initialize(this.statsCache4MFT, this.statsCache4BOM, this.supplyCache, this.allUsedSupplys, this.bomCache, this.bomChildrenCache, this.keyBuffer, this.existKeyPartMap);
                    this.statsCache4BOM.put(key, bomStats);
                    bomStats.dateUtil = this.dateUtil;
                    bomStats.cpsDate = (Long)MRPUtil.convert((Object)reqData.getValue(DefaultField.RequireField.DATE.getName()), (Object)0L);
                }
                bomStats.reqData = reqData;
                bomStats.parentReqIdx = this.parentReqIdx;
                bomStats.isConflict = false;
                bomStats.consumes.clear();
                bomStats.consumes.addAll(this.consumes);
                bomStats.llc = this.llc + 1;
                bomStats.mainCycleCount = 0;
                bomStats.bomChildrenCycleCount = 0;
                bomStats.path = this.path;
                bomStats.topReqIdx = this.topReqIdx;
                bomStats.onWorkSupplys = this.onWorkSupplys;
                bomStats.uuid = ID.genStringId();
                this.isWayFullSet = bomStats.isWayFullSet || this.isWayFullSet;
                this.cpsDate = Math.max(bomStats.cpsDate, this.cpsDate);
                if (ctx.isYield()) {
                    Object myield = reqData.getValue(DefaultField.RequireField.YIELD.getName());
                    BigDecimal yield = MRPUtil.toBigDecimal((Object)myield);
                    requireQty = MRPUtil.calcYield((BigDecimal)yield, (Object)reqData.getValue(DefaultField.RequireField.BASEUNIT.getName()), (BigDecimal)requireQty, (IMRPEnvProvider)ctx, (boolean)false);
                }
                BigDecimal subCompleteQty = bomStats.calcUsageStats(ctx, requireQty, BigDecimal.ZERO, requireTbl.fetchRow(this.parentReqIdx), -1);
                this.consumes.addAll(bomStats.consumes);
                if (!this.isConflict) {
                    this.isConflict = bomStats.isConflict;
                }
                this.mainCycleCount += bomStats.mainCycleCount;
                this.bomChildrenCycleCount += bomStats.bomChildrenCycleCount;
                this.changedStats.add(bomStats);
                this.subChangedStats.add(bomStats);
                requireQty = requireQty.subtract(subCompleteQty);
                if (ctx.isYield()) {
                    Object myield = reqData.getValue(DefaultField.RequireField.YIELD.getName());
                    BigDecimal yield = MRPUtil.toBigDecimal((Object)myield);
                    requireQty = MRPUtil.calcYield((BigDecimal)yield, (Object)reqData.getValue(DefaultField.RequireField.BASEUNIT.getName()), (BigDecimal)requireQty, (IMRPEnvProvider)ctx, (boolean)true);
                }
            }
            requireQty = this.calcReplace(ctx, this.replaceMap, reqData, targetQty, requireQty, originQty);
            BigDecimal subQty = BigDecimal.ZERO;
            subQty = "B".equals(qtyType) ? (requireQty.compareTo(BigDecimal.ZERO) > 0 ? BigDecimal.ZERO : targetQty) : MRPUtil.divide((IMRPEnvProvider)ctx, (Object)unit, (BigDecimal)MRPUtil.multiply2((IMRPEnvProvider)ctx, (Object)unit, (BigDecimal)targetQty, (BigDecimal)unitUseQty).subtract(requireQty.subtract(fixScrap)), (BigDecimal)unitUseQty);
            int cmp = targetQty.compareTo(subQty);
            if (cmp > 0) {
                targetQty = subQty;
            }
            if (!this.isConflict) {
                this.isConflict = this.consumes.contains(String.valueOf(subId));
            }
            this.consumes.add(String.valueOf(subId));
        }
        return targetQty;
    }

    public void targetKeyPart(KDCloudCPSEnv ctx, BigDecimal targetQty, List<RequireRowData> tmpBomChildren, RequireRowData parentRow) {
        BOMStructDataTable bomTbl = ctx.bomDatas();
        boolean flag = false;
        Integer parentBomIdx = (Integer)MRPUtil.convert((Object)parentRow.getValue(DefaultField.RequireField.__BOM_IDX__.getName()), (Object)-1);
        for (RequireRowData childRow : tmpBomChildren) {
            if (childRow.getValue(DefaultField.RequireField.__EXIST_KEYPART__.getName()) != null) {
                if (flag) continue;
                flag = MRPUtil.convert((Object)childRow.getValue(DefaultField.RequireField.__EXIST_KEYPART__.getName()), (Boolean)Boolean.FALSE);
                continue;
            }
            boolean exist = this.findKeyPart(ctx, bomTbl, childRow);
            if (!flag) {
                flag = exist;
            }
            Integer childBomIdx = (Integer)MRPUtil.convert((Object)childRow.getValue(DefaultField.RequireField.__BOM_IDX__.getName()), (Object)-1);
            childRow.update(DefaultField.BOMField.__EXIST_KEYPART__.getName(), (Object)exist);
            if (childBomIdx == -1) continue;
            bomTbl.updateValue(DefaultField.BOMField.__EXIST_KEYPART__.getName(), childBomIdx, (Object)exist);
            if (!parentBomIdx.equals(childBomIdx)) continue;
            this.existKeyPartMap.put(childBomIdx, flag);
        }
        if (parentRow.getValue(DefaultField.RequireField.__EXIST_KEYPART__.getName()) == null) {
            parentRow.update(DefaultField.BOMField.__EXIST_KEYPART__.getName(), (Object)flag);
            if (parentBomIdx != -1) {
                bomTbl.updateValue(DefaultField.BOMField.__EXIST_KEYPART__.getName(), parentBomIdx, (Object)flag);
            }
        }
    }

    private boolean findKeyPart(KDCloudCPSEnv ctx, BOMStructDataTable bomTbl, RequireRowData reqData) {
        BigDecimal netDemand = (BigDecimal)MRPUtil.convert((Object)reqData.getValue(DefaultField.RequireField.QTY.getName()), (Object)BigDecimal.ZERO);
        if (MaterialAttribute.PURCHASEDPART.getValue() == ((Integer)MRPUtil.convert((Object)reqData.get(DefaultField.RequireField.MATERIALATTR.getName()), (Object)MaterialAttribute.OTHER.getValue())).intValue()) {
            return MRPUtil.convert((Object)reqData.getValue(DefaultField.RequireField.__IS_KEYPART__.getName()), (Boolean)Boolean.FALSE);
        }
        int bomIdx = this.dateUtil.findBOM((RowData)reqData, netDemand);
        if (bomIdx < 0) {
            return MRPUtil.convert((Object)reqData.getValue(DefaultField.RequireField.__IS_KEYPART__.getName()), (Boolean)Boolean.FALSE);
        }
        String bomFID = String.valueOf(bomTbl.getValue(DefaultField.BOMField.BOMID.getName(), bomIdx));
        List bomIdxs = DataMatchUtils.findBOMChildren((IMRPEnvProvider)ctx, this.bomChildrenCache, (String)bomFID);
        if (!bomIdxs.isEmpty()) {
            ArrayList<RequireRowData> bomEntrys = new ArrayList<RequireRowData>(5);
            this.dateUtil.calcDate(reqData, netDemand);
            HashMap<Integer, Integer> parentBalancePeriod = new HashMap<Integer, Integer>(16);
            HashMap<Integer, BigDecimal> parentQuota = new HashMap<Integer, BigDecimal>(16);
            HashMap<Integer, BigDecimal> rQtyMap = new HashMap<Integer, BigDecimal>(16);
            boolean flag = false;
            for (int j = 0; j < bomIdxs.size(); ++j) {
                ++this.bomChildrenCycleCount;
                CPSRequireStatNode.createChildrenStruct(this.dateUtil, bomEntrys, (IMRPEnvProvider)ctx, reqData, rQtyMap, parentQuota, parentBalancePeriod, new HashMap<String, ReplaceStruct>(), bomIdxs, (Integer)bomIdxs.get(j), bomFID, j, false, this.existKeyPartMap);
                if (!bomEntrys.isEmpty()) {
                    RequireRowData next = (RequireRowData)bomEntrys.get(0);
                    boolean exist = this.findKeyPart(ctx, bomTbl, next);
                    if (!flag) {
                        flag = exist;
                    }
                    if (bomIdx == (Integer)bomIdxs.get(j)) {
                        this.existKeyPartMap.put(bomIdx, flag);
                    } else {
                        bomTbl.updateValue(DefaultField.BOMField.__EXIST_KEYPART__.getName(), (Integer)bomIdxs.get(j), (Object)exist);
                    }
                }
                bomEntrys.clear();
            }
            if (MRPUtil.convert((Object)reqData.getValue(DefaultField.RequireField.__IS_KEYPART__.getName()), (Boolean)Boolean.FALSE).booleanValue()) {
                flag = true;
            }
            reqData.update(DefaultField.BOMField.__EXIST_KEYPART__.getName(), (Object)flag);
            bomTbl.updateValue(DefaultField.BOMField.__EXIST_KEYPART__.getName(), Integer.valueOf(bomIdx), (Object)flag);
        }
        return MRPUtil.convert((Object)reqData.getValue(DefaultField.RequireField.__EXIST_KEYPART__.getName()), (Boolean)Boolean.FALSE);
    }

    private BigDecimal calcTargetQty(KDCloudCPSEnv ctx, BigDecimal targetQty, List<RequireRowData> tmpBomChildren, BigDecimal min, RequireRowData topRow) {
        if (ctx.isKeyPart()) {
            return this.calcTargetQty4KeyPart(ctx, targetQty, tmpBomChildren, min, topRow);
        }
        RequirementDataTable requireTbl = ctx.requireDatas();
        SupplymentDataTable supplyTbl = ctx.supplyDatas();
        boolean isNoSupply = this.supplyRowIdx < 0;
        this.isConflict = false;
        for (int i = 0; i < tmpBomChildren.size(); ++i) {
            ctx.testEnvStatus();
            ++this.mainCycleCount;
            RequireRowData reqData = tmpBomChildren.get(i);
            BigDecimal unitUseQty = (BigDecimal)reqData.getValue(DefaultField.RequireField.__DEPENDENT_UNIT_QTY__.getName());
            if (BigDecimal.ZERO.compareTo(unitUseQty) == 0) continue;
            BigDecimal requireQty = BigDecimal.ZERO;
            BigDecimal fixScrap = BigDecimal.ZERO;
            if (ctx.isScrapRation()) {
                fixScrap = (BigDecimal)MRPUtil.convert((Object)reqData.getBigDecimal(DefaultField.RequireField.__CHILDFIXSCRAP__.getName()), (Object)BigDecimal.ZERO);
            }
            if (((String)MRPUtil.convert((Object)reqData.getString(DefaultField.RequireField.EXCEPTIONNUMBER.getName()), (Object)"")).contains("87")) continue;
            String qtyType = reqData.getValue(DefaultField.RequireField.__CHILDAMTTYPE__.getName()) == null ? "A" : (String)reqData.getValue(DefaultField.RequireField.__CHILDAMTTYPE__.getName());
            Object unit = reqData.getValue(DefaultField.RequireField.BASEUNIT.getName());
            requireQty = "B".equals(qtyType) ? unitUseQty.add(fixScrap) : MRPUtil.multiply2((IMRPEnvProvider)ctx, (Object)unit, (BigDecimal)targetQty, (BigDecimal)unitUseQty).add(fixScrap);
            if (reqData.getValue(DefaultField.RequireField.__SUPPLY_IDX__.getName()) != null) {
                CPSSupplyStatNode node = this.allUsedSupplys.get(reqData.getInteger(DefaultField.RequireField.__SUPPLY_IDX__.getName()));
                BigDecimal recQty = node.getMaxQty();
                recQty = recQty.subtract(node.getConsumeQty4DepSupply());
                node.doSnap(this.changedNodes);
                node.doSnap(this.subChangedNodes);
                if (requireQty.compareTo(recQty) > 0) {
                    requireQty = requireQty.subtract(recQty);
                    node.setConsumeQty4DepSupply(this.topReqIdx, this.llc + 1, recQty, reqData, this.path);
                } else {
                    node.setConsumeQty4DepSupply(this.topReqIdx, this.llc + 1, requireQty, reqData, this.path);
                    requireQty = BigDecimal.ZERO;
                    continue;
                }
            }
            if ("1".equals(ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                logger.warn(String.format("mmc-cps-mrprunner, CPSRequireStatNode,requireQty:%s,reqData:%s", requireQty, reqData));
            }
            BigDecimal originQty = requireQty;
            Object pId = this.reqData.getValue(DefaultField.RequireField.MATERIAL.getName());
            Object subId = reqData.getValue(DefaultField.RequireField.MATERIAL.getName());
            String cacheKey = this.keyPrefix + this.llc + "-" + i + "-" + subId;
            List supplys = this.supplyCache.get(cacheKey);
            if (supplys == null) {
                supplys = DataMatchUtils.findSupplysUtil((boolean)false, (RowData)reqData, (IMRPEnvProvider)ctx);
                MRPUtil.isUseEnableOrder((IMRPEnvProvider)ctx, (SupplymentDataTable)supplyTbl, (List)supplys, (RequireRowData)reqData);
                Iterator strategyId = reqData.getValue(DefaultField.RequireField.PLAN_STRATEGY.getName());
                Boolean isFastEnable = (Boolean)ctx.getCfgValue(EnvCfgItem.ENABLE_FAST_SUPLLY_SEARCH_MODE);
                if (!isFastEnable.booleanValue()) {
                    supplys = supplyTbl.sortByPriority(reqData.getString(DefaultField.RequireField.SUPPLYORGUNIT.getName()), supplys, strategyId == null ? null : String.valueOf(strategyId));
                    supplys.sort(new DataMatchUtils.SupplySortComparator((IMRPEnvProvider)ctx));
                }
                supplys = ctx.supplyDatas().sortSupplyByReserve((IMRPEnvProvider)ctx, supplys, reqData);
                this.supplyCache.put(cacheKey, supplys);
            }
            ctx.createLogRecorder().updateSubStepLog(this.subLogLevel, "entrydetailmsg_tag", (Object)String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u5c42\u7ea7\uff1a%1$s\uff0c\u9876\u5c42\u7269\u6599ID\uff1a%2$s\uff0c\u9700\u6c42\u7269\u6599ID\uff1a%3$s\uff0c\u5b50\u9879\u7269\u6599ID\uff1a%4$s\uff0c\u76ee\u6807\u9f50\u5957\u6570\u91cf\uff1a%5$s,\u9876\u5c42\u5355\u636e\u7f16\u7801\uff1a%6$s\uff0c\u9876\u5c42\u5355\u636e\u884c\u53f7\uff1a%7$s\uff0c\u9876\u5c42\u5355\u636e\u7c7b\u578b\uff1a%8$s\uff0c\u7236\u9879\u5355\u636e\u7f16\u7801\uff1a%9$s\uff0c\u7236\u9879\u5355\u636e\u884c\u53f7\uff1a%10$s\uff0c\u7236\u9879\u5355\u636e\u7c7b\u578b\uff1a%11$s\uff0c\u5355\u636e\u7f16\u7801\uff1a%12$s\uff0c\u5355\u636e\u884c\u53f7\uff1a%13$s\uff0c\u5355\u636e\u7c7b\u578b\uff1a%14$s", (String)"CPSRequireStatNode_0", (String)"mmc-mrp-mservice-calcnode", (Object[])new Object[0]), this.llc, requireTbl.getValue(DefaultField.RequireField.MATERIAL.getName(), this.topReqIdx), pId, subId, targetQty, requireTbl.getValue(DefaultField.RequireField.BILLNUMBER.getName(), this.topReqIdx), requireTbl.getValue(DefaultField.RequireField.BILLENTRYSEQ.getName(), this.topReqIdx), requireTbl.getValue(DefaultField.RequireField.BILL_ENTITY.getName(), this.topReqIdx), this.reqData.getValue(DefaultField.RequireField.BILLNUMBER.getName()), this.reqData.getValue(DefaultField.RequireField.BILLENTRYSEQ.getName()), this.reqData.getValue(DefaultField.RequireField.BILL_ENTITY.getName()), reqData.getValue(DefaultField.RequireField.BILLNUMBER.getName()), reqData.getValue(DefaultField.RequireField.BILLENTRYSEQ.getName()), reqData.getValue(DefaultField.RequireField.BILL_ENTITY.getName())));
            ctx.createLogRecorder().saveStepLog(false);
            for (Integer secSupplyRowIdx : supplys) {
                CPSSupplyStatNode node;
                ctx.testEnvStatus();
                BigDecimal subSupplyQty = (BigDecimal)MRPUtil.convert((Object)supplyTbl.getValue(DefaultField.SupplyField.QTY.getName(), secSupplyRowIdx.intValue()), (Object)BigDecimal.ZERO);
                Boolean isOnWork = MRPUtil.convert((Object)supplyTbl.getValue(DefaultField.SupplyField.ISONWORK.getName(), secSupplyRowIdx.intValue()), (Boolean)Boolean.FALSE);
                this.cpsDate = Math.max(this.cpsDate, (Long)MRPUtil.convert((Object)supplyTbl.getValue(DefaultField.SupplyField.DATE.getName(), secSupplyRowIdx.intValue()), (Object)0L));
                String supplyId = (String)MRPUtil.convert((Object)supplyTbl.getValue(DefaultField.SupplyField.BILLENTRYID.getName(), secSupplyRowIdx.intValue()), (Object)"");
                String requireId = (String)MRPUtil.convert((Object)reqData.getValue(DefaultField.RequireField.BILLENTRYID.getName()), (Object)"");
                Boolean isVirtual = MRPUtil.convert((Object)supplyTbl.getValue(DefaultField.SupplyField.__VIRTUAL_SUPPLY__.getName(), secSupplyRowIdx.intValue()), (Boolean)Boolean.FALSE);
                if (isVirtual.booleanValue() && !supplyId.equals(requireId)) continue;
                if (isOnWork.booleanValue()) {
                    if (this.onWorkSupplys.contains(supplyId) || this.onWorkSupplys.contains(supplyId + "\u0001" + requireId)) continue;
                    this.onWorkSupplys.add(supplyId + "\u0001" + requireId);
                    String key = this.keyPrefix + String.valueOf(subId);
                    CPSRequireStatNode onWorkStats = this.statsCache4MFT.get(key);
                    if (onWorkStats == null) {
                        String keyPrefix = this.keyPrefix + this.llc + "-" + i;
                        onWorkStats = new CPSRequireStatNode(keyPrefix, this.topReqIdx, reqData, this.getNearestParentIdx(reqData), secSupplyRowIdx, this.llc + 1, this.subLogLevel);
                        onWorkStats.initialize(this.statsCache4MFT, this.statsCache4BOM, this.supplyCache, this.allUsedSupplys, this.bomCache, this.bomChildrenCache, this.keyBuffer, this.existKeyPartMap);
                        this.statsCache4MFT.put(key, onWorkStats);
                        onWorkStats.bomCache = this.bomCache;
                        onWorkStats.bomChildrenCache = this.bomChildrenCache;
                        onWorkStats.allUsedSupplys = this.allUsedSupplys;
                        onWorkStats.keyBuffer = this.keyBuffer;
                        onWorkStats.dateUtil = this.dateUtil;
                    }
                    onWorkStats.reqData = reqData;
                    onWorkStats.parentReqIdx = this.getNearestParentIdx(reqData);
                    onWorkStats.consumes.clear();
                    onWorkStats.isConflict = false;
                    onWorkStats.consumes.addAll(this.consumes);
                    onWorkStats.llc = this.llc + 1;
                    onWorkStats.mainCycleCount = 0;
                    onWorkStats.mftChildrenCycleCount = 0;
                    onWorkStats.path = this.path;
                    onWorkStats.onWorkSupplys = this.onWorkSupplys;
                    onWorkStats.supplyRowIdx = secSupplyRowIdx;
                    onWorkStats.topReqIdx = this.topReqIdx;
                    node = this.initOnWorkStatNode((IMRPEnvProvider)ctx, reqData, secSupplyRowIdx, subSupplyQty, onWorkStats, requireQty);
                    this.changedStats.add(onWorkStats);
                    this.subChangedStats.add(onWorkStats);
                    ArrayList<RequireRowData> children = new ArrayList<RequireRowData>(16);
                    BigDecimal onWorkQty = this.calcQtyByChildrenReceive((IMRPEnvProvider)ctx, children, requireQty, secSupplyRowIdx);
                    if (onWorkQty.compareTo(BigDecimal.ZERO) > 0) {
                        node.doSnap(this.changedNodes);
                        node.doSnap(this.subChangedNodes);
                        if (onWorkQty.compareTo(requireQty) >= 0) {
                            node.setConsumeQty4Dep(this.topReqIdx, this.llc + 1, requireQty, this.path, reqData);
                            onWorkStats.addCompleteDatas(ctx, requireQty);
                            requireQty = BigDecimal.ZERO;
                        } else {
                            node.setConsumeQty4Dep(this.topReqIdx, this.llc + 1, onWorkQty, this.path, reqData);
                            onWorkStats.addCompleteDatas(ctx, onWorkQty);
                            requireQty = requireQty.subtract(onWorkQty);
                        }
                    }
                    if (requireQty.compareTo(BigDecimal.ZERO) > 0) {
                        BigDecimal subUnCompleteQty = node.getMaxQty();
                        if ((subUnCompleteQty = subUnCompleteQty.subtract(node.getConsumeQty4DepSupply()).subtract(node.getConsumeQty4Dep())).compareTo(BigDecimal.ZERO) > 0) {
                            BigDecimal yield;
                            node.doSnap(this.changedNodes);
                            node.doSnap(this.subChangedNodes);
                            if (ctx.isKeyPart()) {
                                this.targetKeyPart(ctx, targetQty, children, reqData);
                            }
                            if (ctx.isYield()) {
                                yield = (BigDecimal)MRPUtil.convert((Object)supplyTbl.getValue(DefaultField.SupplyField.YIELD.getName(), secSupplyRowIdx.intValue()), (Object)BigDecimal.ONE);
                                requireQty = MRPUtil.calcYield((BigDecimal)yield, (Object)supplyTbl.getValue(DefaultField.SupplyField.BASEUNIT.getName(), secSupplyRowIdx.intValue()), (BigDecimal)requireQty, (IMRPEnvProvider)ctx, (boolean)false);
                                subUnCompleteQty = MRPUtil.calcYield((BigDecimal)yield, (Object)supplyTbl.getValue(DefaultField.SupplyField.BASEUNIT.getName(), secSupplyRowIdx.intValue()), (BigDecimal)subUnCompleteQty, (IMRPEnvProvider)ctx, (boolean)false);
                            }
                            subUnCompleteQty = onWorkStats.calcMaxCompleteQty(ctx, CPSUtil.min((BigDecimal)requireQty, (BigDecimal)subUnCompleteQty), children, node, BigDecimal.ZERO, requireTbl.fetchRow(this.getNearestParentIdx(reqData)));
                            this.consumes.addAll(onWorkStats.consumes);
                            if (!this.isConflict) {
                                this.isConflict = onWorkStats.isConflict;
                            }
                            this.mainCycleCount += onWorkStats.mainCycleCount;
                            this.mftChildrenCycleCount += onWorkStats.mftChildrenCycleCount;
                            node.setConsumeQty4DepSupply(this.topReqIdx, this.llc + 1, subUnCompleteQty, reqData, this.path);
                            if (subUnCompleteQty.compareTo(requireQty) >= 0) {
                                subUnCompleteQty = requireQty;
                                requireQty = BigDecimal.ZERO;
                            } else {
                                requireQty = requireQty.subtract(subUnCompleteQty);
                                if (subUnCompleteQty.compareTo(BigDecimal.ZERO) > 0 && !MRPUtil.convert((Object)supplyTbl.getValue(DefaultField.SupplyField.ISSTORAGEDATA.getName(), secSupplyRowIdx.intValue()), (Boolean)Boolean.FALSE).booleanValue()) {
                                    this.isWayFullSet = true;
                                }
                            }
                            if (ctx.isYield()) {
                                yield = (BigDecimal)MRPUtil.convert((Object)supplyTbl.getValue(DefaultField.SupplyField.YIELD.getName(), secSupplyRowIdx.intValue()), (Object)BigDecimal.ONE);
                                requireQty = MRPUtil.calcYield((BigDecimal)yield, (Object)supplyTbl.getValue(DefaultField.SupplyField.BASEUNIT.getName(), secSupplyRowIdx.intValue()), (BigDecimal)requireQty, (IMRPEnvProvider)ctx, (boolean)true);
                                subUnCompleteQty = MRPUtil.calcYield((BigDecimal)yield, (Object)supplyTbl.getValue(DefaultField.SupplyField.BASEUNIT.getName(), secSupplyRowIdx.intValue()), (BigDecimal)subUnCompleteQty, (IMRPEnvProvider)ctx, (boolean)true);
                            }
                        }
                    }
                } else {
                    node = this.initStatNode((IMRPEnvProvider)ctx, secSupplyRowIdx, subSupplyQty);
                    subSupplyQty = subSupplyQty.subtract(node.getConsumeQty4BOM());
                    subSupplyQty = subSupplyQty.subtract(node.getConsumeQty4DepSupply());
                    node.doSnap(this.changedNodes);
                    node.doSnap(this.subChangedNodes);
                    if (subSupplyQty.compareTo(BigDecimal.ZERO) > 0 && !MRPUtil.convert((Object)supplyTbl.getValue(DefaultField.SupplyField.ISSTORAGEDATA.getName(), secSupplyRowIdx.intValue()), (Boolean)Boolean.FALSE).booleanValue()) {
                        this.isWayFullSet = true;
                    }
                    if (requireQty.compareTo(subSupplyQty) > 0) {
                        requireQty = requireQty.subtract(subSupplyQty);
                        if (isNoSupply) {
                            node.setConsumeQty4BOM(this.topReqIdx, this.llc + 1, subSupplyQty, this.path, reqData);
                        } else {
                            node.setConsumeQty4DepSupply(this.topReqIdx, this.llc + 1, subSupplyQty, reqData, this.path);
                        }
                    } else {
                        if (isNoSupply) {
                            node.setConsumeQty4BOM(this.topReqIdx, this.llc + 1, requireQty, this.path, reqData);
                        } else {
                            node.setConsumeQty4DepSupply(this.topReqIdx, this.llc + 1, requireQty, reqData, this.path);
                        }
                        requireQty = BigDecimal.ZERO;
                    }
                }
                if (requireQty.compareTo(BigDecimal.ZERO) != 0) continue;
                break;
            }
            if (requireQty.compareTo(BigDecimal.ZERO) > 0) {
                String key = this.keyPrefix + String.valueOf(subId);
                CPSRequireStatNode bomStats = this.statsCache4BOM.get(key);
                if (bomStats == null) {
                    String keyPrefix = this.keyPrefix + this.llc + "-" + i;
                    bomStats = new CPSRequireStatNode(keyPrefix, this.topReqIdx, reqData, this.getNearestParentIdx(reqData), -1, this.llc + 1, this.subLogLevel);
                    bomStats.initialize(this.statsCache4MFT, this.statsCache4BOM, this.supplyCache, this.allUsedSupplys, this.bomCache, this.bomChildrenCache, this.keyBuffer, this.existKeyPartMap);
                    this.statsCache4BOM.put(key, bomStats);
                    bomStats.dateUtil = this.dateUtil;
                    bomStats.cpsDate = (Long)MRPUtil.convert((Object)reqData.getValue(DefaultField.RequireField.DATE.getName()), (Object)0L);
                }
                bomStats.reqData = reqData;
                bomStats.parentReqIdx = this.parentReqIdx;
                bomStats.isConflict = false;
                bomStats.consumes.clear();
                bomStats.consumes.addAll(this.consumes);
                bomStats.llc = this.llc + 1;
                bomStats.mainCycleCount = 0;
                bomStats.bomChildrenCycleCount = 0;
                bomStats.path = this.path;
                bomStats.topReqIdx = this.topReqIdx;
                bomStats.onWorkSupplys = this.onWorkSupplys;
                bomStats.uuid = ID.genStringId();
                this.isWayFullSet = bomStats.isWayFullSet || this.isWayFullSet;
                this.cpsDate = Math.max(bomStats.cpsDate, this.cpsDate);
                if (ctx.isYield()) {
                    Object myield = reqData.getValue(DefaultField.RequireField.YIELD.getName());
                    BigDecimal yield = MRPUtil.toBigDecimal((Object)myield);
                    requireQty = MRPUtil.calcYield((BigDecimal)yield, (Object)reqData.getValue(DefaultField.RequireField.BASEUNIT.getName()), (BigDecimal)requireQty, (IMRPEnvProvider)ctx, (boolean)false);
                }
                BigDecimal subCompleteQty = bomStats.calcUsageStats(ctx, requireQty, BigDecimal.ZERO, requireTbl.fetchRow(this.parentReqIdx), -1);
                this.consumes.addAll(bomStats.consumes);
                if (!this.isConflict) {
                    this.isConflict = bomStats.isConflict;
                }
                this.mainCycleCount += bomStats.mainCycleCount;
                this.bomChildrenCycleCount += bomStats.bomChildrenCycleCount;
                this.changedStats.add(bomStats);
                this.subChangedStats.add(bomStats);
                requireQty = requireQty.subtract(subCompleteQty);
                if (ctx.isYield()) {
                    Object myield = reqData.getValue(DefaultField.RequireField.YIELD.getName());
                    BigDecimal yield = MRPUtil.toBigDecimal((Object)myield);
                    requireQty = MRPUtil.calcYield((BigDecimal)yield, (Object)reqData.getValue(DefaultField.RequireField.BASEUNIT.getName()), (BigDecimal)requireQty, (IMRPEnvProvider)ctx, (boolean)true);
                }
            }
            requireQty = this.calcReplace(ctx, this.replaceMap, reqData, targetQty, requireQty, originQty);
            BigDecimal subQty = BigDecimal.ZERO;
            subQty = "B".equals(qtyType) ? (requireQty.compareTo(BigDecimal.ZERO) > 0 ? BigDecimal.ZERO : targetQty) : MRPUtil.divide((IMRPEnvProvider)ctx, (Object)unit, (BigDecimal)MRPUtil.multiply2((IMRPEnvProvider)ctx, (Object)unit, (BigDecimal)targetQty, (BigDecimal)unitUseQty).subtract(requireQty.subtract(fixScrap)), (BigDecimal)unitUseQty);
            int cmp = targetQty.compareTo(subQty);
            if (cmp > 0) {
                targetQty = subQty;
            }
            if (!this.isConflict) {
                this.isConflict = this.consumes.contains(String.valueOf(subId));
            }
            this.consumes.add(String.valueOf(subId));
        }
        return targetQty;
    }

    private BigDecimal calcReplace(KDCloudCPSEnv env, Map<String, ReplaceStruct> replaceMap, RequireRowData reqData, BigDecimal targetQty, BigDecimal requireQty, BigDecimal originQty) {
        if (!env.isReplace()) {
            return requireQty;
        }
        String replacePlanId = String.valueOf(reqData.getValue(DefaultField.RequireField.REPLACEPLAN.getName()));
        ReplaceStruct struct = replaceMap.get(replacePlanId);
        if (struct != null && reqData.getRowIdx() == -1) {
            requireQty = this.calcReplace4BOM(env, requireQty, originQty, struct);
        }
        return requireQty;
    }

    private BigDecimal calcReplace4BOM(KDCloudCPSEnv env, BigDecimal requireQty, BigDecimal originQty, ReplaceStruct struct) {
        String replaceStra = struct.getReplaceStra();
        ReplaceMaterialStruct mainReplaceM = struct.getMainReplaceM();
        BigDecimal mainQty = originQty;
        if (mainReplaceM.getRequireRowData().getValue(DefaultField.RequireField.__REPLACE_QTY__.getName()) == null) {
            mainReplaceM.getRequireRowData().update(DefaultField.RequireField.__REPLACE_QTY__.getName(), (Object)originQty);
        } else {
            mainQty = (BigDecimal)mainReplaceM.getRequireRowData().getValue(DefaultField.RequireField.__REPLACE_QTY__.getName());
            this.subChangedNodes.forEach(node -> node.doRollback());
            this.subChangedNodes.clear();
            this.subChangedStats.forEach(stats -> stats.doRollback());
            this.subChangedStats.clear();
            ArrayList<RequireRowData> bomEntrys = new ArrayList<RequireRowData>(1);
            bomEntrys.add(mainReplaceM.getRequireRowData());
            BigDecimal rate = (BigDecimal)MRPUtil.convert((Object)mainReplaceM.getRequireRowData().get(DefaultField.RequireField.__DEPENDENT_UNIT_QTY__.getName()), (Object)BigDecimal.ONE);
            mainReplaceM.getRequireRowData().update(DefaultField.RequireField.__DEPENDENT_UNIT_QTY__.getName(), (Object)BigDecimal.ONE);
            env.forceChangeReplace(Boolean.valueOf(false));
            requireQty = this.calcTargetQty(env, mainQty, bomEntrys, BigDecimal.ZERO, mainReplaceM.getRequireRowData());
            requireQty = mainQty.subtract(requireQty);
            env.forceChangeReplace(Boolean.valueOf(true));
            mainReplaceM.getRequireRowData().update(DefaultField.RequireField.__DEPENDENT_UNIT_QTY__.getName(), (Object)rate);
        }
        if ("1001".equals(replaceStra)) {
            if (requireQty.compareTo(BigDecimal.ZERO) > 0) {
                List replaceMs = struct.getReplaceMs();
                requireQty = this.getBatchReplaceQty(env, originQty, mainReplaceM, replaceMs, struct.getReplaceMethod(), mainQty);
            } else {
                requireQty = !mainReplaceM.getRepMaterials().isEmpty() ? this.getMainReplaceQty(env, originQty, mainReplaceM) : BigDecimal.ZERO;
            }
        } else {
            requireQty = "1003".equals(replaceStra) ? (requireQty.compareTo(BigDecimal.ZERO) > 0 ? this.getMixQty(env, originQty, struct, mainReplaceM, mainQty) : (!mainReplaceM.getRepMaterials().isEmpty() ? this.getMainReplaceQty(env, originQty, mainReplaceM) : BigDecimal.ZERO)) : (requireQty.compareTo(BigDecimal.ZERO) > 0 ? this.getMixQty(env, originQty, struct, mainReplaceM, mainQty) : (!mainReplaceM.getRepMaterials().isEmpty() ? this.getMainReplaceQty(env, originQty, mainReplaceM) : BigDecimal.ZERO));
        }
        this.subChangedNodes.clear();
        this.subChangedStats.clear();
        return requireQty;
    }

    private BigDecimal getMainReplaceQty(KDCloudCPSEnv env, BigDecimal originQty, ReplaceMaterialStruct mainReplaceM) {
        BigDecimal rate = (BigDecimal)MRPUtil.convert((Object)mainReplaceM.getRequireRowData().get(DefaultField.RequireField.__DEPENDENT_UNIT_QTY__.getName()), (Object)BigDecimal.ONE);
        mainReplaceM.getRequireRowData().update(DefaultField.RequireField.__DEPENDENT_UNIT_QTY__.getName(), (Object)BigDecimal.ONE);
        ArrayList<RequireRowData> bomEntrys = new ArrayList<RequireRowData>();
        bomEntrys.add(mainReplaceM.getRequireRowData());
        bomEntrys.addAll(mainReplaceM.getRepMaterials().values());
        BigDecimal requireQty = this.calcMaxReplaceQty(env, originQty, mainReplaceM, bomEntrys);
        mainReplaceM.getRequireRowData().update(DefaultField.RequireField.__DEPENDENT_UNIT_QTY__.getName(), (Object)rate);
        return originQty.subtract(requireQty);
    }

    private BigDecimal getMixQty(KDCloudCPSEnv env, BigDecimal originQty, ReplaceStruct struct, ReplaceMaterialStruct mainReplaceM, BigDecimal mainQty) {
        ArrayList<RequireRowData> bomEntrys = new ArrayList<RequireRowData>();
        this.subChangedNodes.forEach(node -> node.doRollback());
        this.subChangedNodes.clear();
        this.subChangedStats.forEach(stats -> stats.doRollback());
        this.subChangedStats.clear();
        String replaceStra = struct.getReplaceStra();
        if ("1003".equals(replaceStra)) {
            ReplaceMaterialStruct rp = null;
            for (ReplaceMaterialStruct rpStruct : struct.getReplaceMs()) {
                bomEntrys.clear();
                bomEntrys.add(rpStruct.getRequireRowData());
                env.forceChangeReplace(Boolean.valueOf(false));
                BigDecimal calcTargetQty = this.calcTargetQty(env, mainQty, bomEntrys, BigDecimal.ZERO, mainReplaceM.getRequireRowData());
                env.forceChangeReplace(Boolean.valueOf(true));
                if (calcTargetQty.compareTo(mainQty) < 0) {
                    this.subChangedNodes.forEach(node -> node.doRollback());
                    this.subChangedNodes.clear();
                    this.subChangedStats.forEach(stats -> stats.doRollback());
                    this.subChangedStats.clear();
                    continue;
                }
                String key = String.format("%s\u0001%s\u0001%s\u0001%s\u0001%s", mainReplaceM.getRequireRowData().getString(DefaultField.RequireField.BILLID.getName()), mainReplaceM.getRequireRowData().getString(DefaultField.RequireField.BILLENTRYID.getName()), mainReplaceM.getRequireRowData().getString(DefaultField.RequireField.REPLACEPLAN.getName()), mainReplaceM.getMaterial(), this.llc);
                env.putCustomParams(key, rpStruct.getPriority().toString());
                rp = rpStruct;
                break;
            }
            if (rp != null) {
                this.subChangedNodes.forEach(node -> node.doRollback());
                this.subChangedNodes.clear();
                this.subChangedStats.forEach(stats -> stats.doRollback());
                this.subChangedStats.clear();
                bomEntrys.clear();
                bomEntrys.add(rp.getRequireRowData());
                bomEntrys.addAll(rp.getRepMaterials().values());
                env.forceChangeReplace(Boolean.valueOf(false));
                BigDecimal calcTargetQty = this.calcTargetQty(env, mainQty, bomEntrys, BigDecimal.ZERO, mainReplaceM.getRequireRowData());
                env.forceChangeReplace(Boolean.valueOf(true));
                this.subChangedNodes.forEach(node -> node.doRollback());
                this.subChangedNodes.clear();
                this.subChangedStats.forEach(stats -> stats.doRollback());
                this.subChangedStats.clear();
                env.forceChangeReplace(Boolean.valueOf(false));
                calcTargetQty = this.calcTargetQty(env, calcTargetQty, bomEntrys, BigDecimal.ZERO, mainReplaceM.getRequireRowData());
                env.forceChangeReplace(Boolean.valueOf(true));
                return originQty.subtract(calcTargetQty);
            }
        }
        this.subChangedNodes.forEach(node -> node.doRollback());
        this.subChangedNodes.clear();
        this.subChangedStats.forEach(stats -> stats.doRollback());
        this.subChangedStats.clear();
        bomEntrys.clear();
        bomEntrys.add(mainReplaceM.getRequireRowData());
        BigDecimal rate = (BigDecimal)MRPUtil.convert((Object)mainReplaceM.getRequireRowData().get(DefaultField.RequireField.__DEPENDENT_UNIT_QTY__.getName()), (Object)BigDecimal.ONE);
        mainReplaceM.getRequireRowData().update(DefaultField.RequireField.__DEPENDENT_UNIT_QTY__.getName(), (Object)BigDecimal.ONE);
        BigDecimal netDemand = originQty;
        env.forceChangeReplace(Boolean.valueOf(false));
        BigDecimal calcTargetQty = this.calcTargetQty(env, mainQty, bomEntrys, BigDecimal.ZERO, mainReplaceM.getRequireRowData());
        env.forceChangeReplace(Boolean.valueOf(true));
        mainQty = mainQty.subtract(calcTargetQty);
        bomEntrys.addAll(mainReplaceM.getRepMaterials().values());
        BigDecimal calcMaxReplaceQty = this.calcMaxReplaceQty(env, calcTargetQty, mainReplaceM, bomEntrys);
        mainReplaceM.getRequireRowData().update(DefaultField.RequireField.__DEPENDENT_UNIT_QTY__.getName(), (Object)rate);
        netDemand = netDemand.subtract(calcMaxReplaceQty);
        this.subChangedNodes.clear();
        this.subChangedStats.clear();
        List replaceMs = struct.getReplaceMs();
        for (ReplaceMaterialStruct rpStruct : replaceMs) {
            bomEntrys.clear();
            bomEntrys.add(rpStruct.getRequireRowData());
            env.forceChangeReplace(Boolean.valueOf(false));
            calcTargetQty = this.calcTargetQty(env, mainQty, bomEntrys, BigDecimal.ZERO, mainReplaceM.getRequireRowData());
            env.forceChangeReplace(Boolean.valueOf(true));
            mainQty = mainQty.subtract(calcTargetQty);
            bomEntrys.addAll(rpStruct.getRepMaterials().values());
            env.forceChangeReplace(Boolean.valueOf(false));
            calcMaxReplaceQty = this.calcMaxReplaceQty(env, calcTargetQty, mainReplaceM, bomEntrys);
            env.forceChangeReplace(Boolean.valueOf(true));
            netDemand = netDemand.subtract(calcMaxReplaceQty);
            this.subChangedNodes.clear();
            this.subChangedStats.clear();
            if (mainQty.compareTo(BigDecimal.ZERO) != 0) continue;
            break;
        }
        return netDemand;
    }

    private BigDecimal getBatchReplaceQty(KDCloudCPSEnv env, BigDecimal originQty, ReplaceMaterialStruct mainReplaceM, List<ReplaceMaterialStruct> replaceMs, String replaceMethod, BigDecimal mainQty) {
        BigDecimal calcTargetQty;
        this.subChangedNodes.forEach(node -> node.doRollback());
        this.subChangedStats.forEach(stats -> stats.doRollback());
        ArrayList<RequireRowData> bomEntrys = new ArrayList<RequireRowData>(16);
        ReplaceMaterialStruct rp = null;
        for (ReplaceMaterialStruct rpStruct : replaceMs) {
            bomEntrys.clear();
            bomEntrys.add(rpStruct.getRequireRowData());
            env.forceChangeReplace(Boolean.valueOf(false));
            BigDecimal calcTargetQty2 = this.calcTargetQty(env, mainQty, bomEntrys, BigDecimal.ZERO, mainReplaceM.getRequireRowData());
            env.forceChangeReplace(Boolean.valueOf(true));
            if (calcTargetQty2.compareTo(mainQty) < 0) {
                this.subChangedNodes.forEach(node -> node.doRollback());
                this.subChangedNodes.clear();
                this.subChangedStats.forEach(stats -> stats.doRollback());
                this.subChangedStats.clear();
                continue;
            }
            String key = String.format("%s\u0001%s\u0001%s\u0001%s\u0001%s", mainReplaceM.getRequireRowData().getString(DefaultField.RequireField.BILLID.getName()), mainReplaceM.getRequireRowData().getString(DefaultField.RequireField.BILLENTRYID.getName()), mainReplaceM.getRequireRowData().getString(DefaultField.RequireField.REPLACEPLAN.getName()), mainReplaceM.getMaterial(), this.llc);
            env.putCustomParams(key, rpStruct.getPriority().toString());
            rp = rpStruct;
            break;
        }
        if (rp != null) {
            this.subChangedNodes.forEach(node -> node.doRollback());
            this.subChangedNodes.clear();
            this.subChangedStats.forEach(stats -> stats.doRollback());
            this.subChangedStats.clear();
            bomEntrys.clear();
            bomEntrys.add(rp.getRequireRowData());
            bomEntrys.addAll(rp.getRepMaterials().values());
            env.forceChangeReplace(Boolean.valueOf(false));
            calcTargetQty = this.calcTargetQty(env, mainQty, bomEntrys, BigDecimal.ZERO, mainReplaceM.getRequireRowData());
            env.forceChangeReplace(Boolean.valueOf(true));
            if (calcTargetQty.compareTo(mainQty) < 0) {
                this.subChangedNodes.forEach(node -> node.doRollback());
                this.subChangedNodes.clear();
                this.subChangedStats.forEach(stats -> stats.doRollback());
                this.subChangedStats.clear();
                env.forceChangeReplace(Boolean.valueOf(false));
                calcTargetQty = this.calcTargetQty(env, calcTargetQty, bomEntrys, BigDecimal.ZERO, mainReplaceM.getRequireRowData());
                env.forceChangeReplace(Boolean.valueOf(true));
                return originQty.subtract(calcTargetQty);
            }
            return BigDecimal.ZERO;
        }
        if ("A".equals(replaceMethod)) {
            bomEntrys.clear();
            bomEntrys.add(mainReplaceM.getRequireRowData());
            bomEntrys.addAll(mainReplaceM.getRepMaterials().values());
            calcTargetQty = this.calcMaxReplaceQty(env, originQty, mainReplaceM, bomEntrys);
            return originQty.subtract(calcTargetQty);
        }
        bomEntrys.clear();
        bomEntrys.add(replaceMs.get(0).getRequireRowData());
        bomEntrys.addAll(replaceMs.get(0).getRepMaterials().values());
        calcTargetQty = this.calcMaxReplaceQty(env, originQty, mainReplaceM, bomEntrys);
        return originQty.subtract(calcTargetQty);
    }

    private BigDecimal calcMaxReplaceQty(KDCloudCPSEnv env, BigDecimal originQty, ReplaceMaterialStruct mainReplaceM, List<RequireRowData> bomEntrys) {
        this.subChangedNodes.forEach(node -> node.doRollback());
        this.subChangedNodes.clear();
        this.subChangedStats.forEach(stats -> stats.doRollback());
        this.subChangedStats.clear();
        env.forceChangeReplace(Boolean.valueOf(false));
        BigDecimal calcTargetQty = this.calcTargetQty(env, originQty, bomEntrys, BigDecimal.ZERO, mainReplaceM.getRequireRowData());
        env.forceChangeReplace(Boolean.valueOf(true));
        this.subChangedNodes.forEach(node -> node.doRollback());
        this.subChangedNodes.clear();
        this.subChangedStats.forEach(stats -> stats.doRollback());
        this.subChangedStats.clear();
        env.forceChangeReplace(Boolean.valueOf(false));
        calcTargetQty = this.calcTargetQty(env, calcTargetQty, bomEntrys, BigDecimal.ZERO, mainReplaceM.getRequireRowData());
        env.forceChangeReplace(Boolean.valueOf(true));
        return calcTargetQty;
    }

    private int getNearestParentIdx(RequireRowData reqData) {
        int nearestParentIdx = reqData.getRowIdx();
        if (nearestParentIdx <= -1) {
            nearestParentIdx = this.parentReqIdx;
        }
        return nearestParentIdx;
    }

    private CPSSupplyStatNode initOnWorkStatNode(IMRPEnvProvider ctx, RequireRowData reqData, Integer supplyRowIdx, BigDecimal supplyQty, CPSRequireStatNode stats, BigDecimal netDemand) {
        CPSSupplyStatNode node = this.allUsedSupplys.get(supplyRowIdx);
        if (node != null) {
            return node;
        }
        node = new CPSSupplyStatNode(supplyRowIdx);
        node.setMaxQty(supplyQty);
        this.allUsedSupplys.put(supplyRowIdx, node);
        return node;
    }

    private CPSSupplyStatNode initStatNode(IMRPEnvProvider ctx, Integer supplyRowIdx, BigDecimal supplyQty) {
        CPSSupplyStatNode node = this.allUsedSupplys.get(supplyRowIdx);
        if (node != null) {
            return node;
        }
        node = new CPSSupplyStatNode(supplyRowIdx);
        this.allUsedSupplys.put(supplyRowIdx, node);
        node.setMaxQty(supplyQty);
        return node;
    }

    private List<RequireRowData> initBOMEntrys(IMRPEnvProvider ctx, RequireRowData reqData, int bomIdx, BigDecimal qty, boolean isReplace) {
        BOMStructDataTable bomTbl = ctx.bomDatas();
        ArrayList<RequireRowData> bomEntrys = new ArrayList<RequireRowData>(5);
        String bomFID = String.valueOf(bomTbl.getValue(DefaultField.BOMField.BOMID.getName(), bomIdx));
        List bomIdxs = DataMatchUtils.findBOMChildren((IMRPEnvProvider)ctx, this.bomChildrenCache, (String)bomFID);
        if (bomIdxs.isEmpty()) {
            CPSUtil.tagBOMEntrysNotFound((RequireRowData)reqData);
        } else {
            this.dateUtil.calcDate(reqData, qty);
            HashMap<Integer, Integer> parentBalancePeriod = new HashMap<Integer, Integer>(16);
            HashMap<Integer, BigDecimal> parentQuota = new HashMap<Integer, BigDecimal>(16);
            HashMap<Integer, BigDecimal> rQtyMap = new HashMap<Integer, BigDecimal>(16);
            reqData.update(DefaultField.RequireField.__BOM_IDX__.getName(), (Object)bomIdx);
            for (int j = 0; j < bomIdxs.size(); ++j) {
                ++this.bomChildrenCycleCount;
                CPSRequireStatNode.createChildrenStruct(this.dateUtil, bomEntrys, ctx, reqData, rQtyMap, parentQuota, parentBalancePeriod, new HashMap<String, ReplaceStruct>(), bomIdxs, (Integer)bomIdxs.get(j), bomFID, j, isReplace, this.existKeyPartMap);
            }
        }
        if (((KDCloudCPSEnv)ctx).isKeyPart()) {
            this.targetKeyPart((KDCloudCPSEnv)ctx, qty, bomEntrys, reqData);
        }
        return bomEntrys;
    }

    public static void createChildrenStruct(MRPMDependentReqNewStep dateUtil, List<RequireRowData> bomEntrys, IMRPEnvProvider ctx, RequireRowData rData, HashMap<Integer, BigDecimal> rQtyMap, HashMap<Integer, BigDecimal> parentQuota, HashMap<Integer, Integer> parentBalancePeriod, Map<String, ReplaceStruct> repStructs, List<Integer> bomIdxs, int childIdx, String bomFID, int childrenListIdx, boolean isReplace, Map<Integer, Boolean> existKeyPartMap) {
        DataBalanceTable.RSMapping mapping = new DataBalanceTable.RSMapping();
        mapping.setChildren(new ArrayList(0));
        KDCloudCPSEnv env = (KDCloudCPSEnv)ctx;
        boolean replace = ctx.isReplace();
        env.forceChangeReplace(Boolean.valueOf(isReplace));
        RequirementDataTable requireTbl = env.requireDatas();
        RequirementDataTable tmpTbl = env.reInitRequireTbl();
        List list = ctx.bomDatas().getCol(DefaultField.BOMField.BOMID.getName()).get((Object)bomFID);
        RowData fetchRow = ctx.bomDatas().fetchRow(((Integer)list.get(0)).intValue());
        mapping.setBom(fetchRow);
        Boolean rp = MRPUtil.convert((Object)ctx.bomDatas().getValue(DefaultField.BOMField.ISREPLACE.getName(), childIdx), (Boolean)Boolean.FALSE);
        if (replace) {
            ctx.bomDatas().updateValue(DefaultField.BOMField.ISREPLACE.getName(), Integer.valueOf(childIdx), (Object)Boolean.FALSE);
        }
        CacheDatas cacheDatas = (CacheDatas)ctx.getService(CacheDatas.class);
        RowData bomEntryRow = ctx.bomDatas().fetchRow(childIdx);
        Map id2ObjCache = cacheDatas.getId2ObjCache();
        Object unitId = bomEntryRow.getValue(DefaultField.BOMField.CHILDUNIT.getName());
        HashMap unit = ctx.getUnit(unitId);
        String precision = (String)unit.get(1);
        String roundingMode = (String)unit.get(2);
        HashMap<String, String> unit1 = new HashMap<String, String>();
        unit1.put("precision", "12");
        unit1.put("precisionaccount", "1");
        id2ObjCache.put(String.valueOf(unitId), unit1);
        dateUtil.createDependentRequire(mapping, rData, BigDecimal.ONE, rQtyMap, parentQuota, parentBalancePeriod, repStructs, bomIdxs, childIdx, bomFID, childrenListIdx);
        ctx.bomDatas().updateValue(DefaultField.BOMField.ISREPLACE.getName(), Integer.valueOf(childIdx), (Object)rp);
        unit1.put("precision", precision);
        unit1.put("precisionaccount", roundingMode);
        id2ObjCache.put(String.valueOf(unitId), unit1);
        new MRPCalQty4SupplyOrgStep(ctx).calQty4SupplyOrg(ctx, tmpTbl);
        for (int i = 0; i < tmpTbl.size(); ++i) {
            RequireRowData reqData = tmpTbl.fetchRow(i);
            if (MaterialAttribute.PHANTOMPART.getValue() == ((Integer)MRPUtil.convert((Object)reqData.get(DefaultField.RequireField.MATERIALATTR.getName()), (Object)MaterialAttribute.OTHER.getValue())).intValue()) continue;
            reqData.setRowIdx(Integer.valueOf(-1));
            BigDecimal qty = (BigDecimal)reqData.getValue(DefaultField.RequireField.QTY.getName());
            reqData.update(DefaultField.RequireField.__DEPENDENT_UNIT_QTY__.getName(), (Object)qty);
            reqData.update(DefaultField.RequireField.__UNUSED_REC_QTY__.getName(), (Object)BigDecimal.ZERO);
            if ("1".equals(ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                logger.warn(String.format("mmc-cps-mrprunner, CPSRequireStatNode,qty:%s,isScrapRation:%s,reqData:%s", qty, ctx.isScrapRation(), reqData));
            }
            reqData.update(DefaultField.RequireField.TRACKNUMBER.getName(), rData.getValue(DefaultField.RequireField.TRACKNUMBER.getName()));
            if (ctx.isScrapRation()) {
                BigDecimal fixScrap = (BigDecimal)MRPUtil.convert((Object)reqData.getBigDecimal(DefaultField.RequireField.__CHILDFIXSCRAP__.getName()), (Object)BigDecimal.ZERO);
                qty = qty.subtract(fixScrap);
                reqData.update(DefaultField.RequireField.__DEPENDENT_UNIT_QTY__.getName(), (Object)qty);
            }
            if (((KDCloudCPSEnv)ctx).isKeyPart()) {
                Integer parentBomIdx = (Integer)MRPUtil.convert((Object)rData.getValue(DefaultField.RequireField.__BOM_IDX__.getName()), (Object)-1);
                Integer childBomIdx = (Integer)MRPUtil.convert((Object)reqData.getValue(DefaultField.RequireField.__BOM_IDX__.getName()), (Object)-1);
                if (childBomIdx != -1 && parentBomIdx.equals(childBomIdx)) {
                    reqData.update(DefaultField.BOMField.__EXIST_KEYPART__.getName(), (Object)existKeyPartMap.get(parentBomIdx));
                }
            }
            reqData.update(DefaultField.RequireField.ISREPLACE.getName(), (Object)rp);
            ctx.loadRequireMaterialExtProps(reqData);
            bomEntrys.add(reqData);
        }
        tmpTbl.clear();
        env.restoreRequireTbl(requireTbl);
        env.resetReplace();
    }

    private BigDecimal calcQtyByChildrenReceive(IMRPEnvProvider ctx, List<RequireRowData> tmpBomChildren, BigDecimal targetQty, Integer supplyRowIdx) {
        BigDecimal completeQty = targetQty;
        if (supplyRowIdx == null || supplyRowIdx == -1) {
            return BigDecimal.ZERO;
        }
        RequirementDataTable requireTbl = ctx.requireDatas();
        SupplymentDataTable supplyTbl = ctx.supplyDatas();
        Long billEntryId = (Long)MRPUtil.convert((Object)supplyTbl.getValue(DefaultField.SupplyField.BILLENTRYID.getName(), supplyRowIdx.intValue()), (Object)0L);
        List subRows = requireTbl.getCol(DefaultField.RequireField.SUPPLYBILLID.getName()).get((Object)billEntryId);
        if ("1".equals(ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
            logger.warn(String.format("mmc-cps-mrprunner, CPSRequireStatNode,billid:%s,subRows:%s", billEntryId, subRows));
        }
        boolean isKeyPart = ((KDCloudCPSEnv)ctx).isKeyPart();
        if (subRows.isEmpty()) {
            completeQty = BigDecimal.ZERO;
            if (MaterialAttribute.PURCHASEDPART.getValue() != ((Integer)MRPUtil.convert((Object)this.reqData.get(DefaultField.RequireField.MATERIALATTR.getName()), (Object)MaterialAttribute.OTHER.getValue())).intValue()) {
                int bomIdx = this.dateUtil.findBOM((RowData)this.reqData, targetQty);
                if (bomIdx < 0) {
                    if (!"A".equals(((KDCloudCPSEnv)ctx).getCPSType())) {
                        CPSUtil.tagBOMNotFound((RequireRowData)this.reqData);
                    }
                } else {
                    tmpBomChildren = this.initBOMEntrys(ctx, this.reqData, bomIdx, targetQty, false);
                    tmpBomChildren.sort(new MaterialAttrCmp2());
                }
            }
        } else {
            tmpBomChildren.addAll(requireTbl.fetchRow((Collection)subRows));
            if (((KDCloudCPSEnv)ctx).isKeyPart()) {
                this.targetKeyPart((KDCloudCPSEnv)ctx, targetQty, tmpBomChildren, this.reqData);
            }
            for (RequireRowData rowData : tmpBomChildren) {
                BigDecimal qty = (BigDecimal)MRPUtil.convert((Object)rowData.getValue(DefaultField.RequireField.QTY.getName()), (Object)BigDecimal.ZERO);
                BigDecimal unitUseQty = (BigDecimal)MRPUtil.convert((Object)rowData.getBigDecimal(DefaultField.RequireField.__DEPENDENT_UNIT_QTY__.getName()), (Object)BigDecimal.ZERO);
                if (BigDecimal.ZERO.compareTo(unitUseQty) == 0) {
                    rowData.update(DefaultField.RequireField.__DEPENDENT_UNIT_QTY__.getName(), (Object)BigDecimal.ZERO);
                    continue;
                }
                if (rowData.getValue(DefaultField.RequireField.__SUPPLY_IDX__.getName()) == null) {
                    completeQty = BigDecimal.ZERO;
                    continue;
                }
                if (isKeyPart && !MRPUtil.convert((Object)rowData.getValue(DefaultField.RequireField.__EXIST_KEYPART__.getName()), (Boolean)Boolean.FALSE).booleanValue()) continue;
                CPSSupplyStatNode node = this.allUsedSupplys.get(rowData.getInteger(DefaultField.RequireField.__SUPPLY_IDX__.getName()));
                BigDecimal recQty = node.getMaxQty().subtract(node.getConsumeQty4Dep()).subtract(node.getConsumeQty4DepSupply());
                if (recQty.compareTo(BigDecimal.ZERO) <= 0) {
                    completeQty = BigDecimal.ZERO;
                    continue;
                }
                Object unit = rowData.getValue(DefaultField.RequireField.BASEUNIT.getName());
                if (qty.compareTo(BigDecimal.ZERO) <= 0) {
                    completeQty = CPSUtil.min((BigDecimal)completeQty, (BigDecimal)targetQty);
                    continue;
                }
                completeQty = CPSUtil.min((BigDecimal)completeQty, (BigDecimal)MRPUtil.divide((IMRPEnvProvider)ctx, (Object)unit, (BigDecimal)recQty, (BigDecimal)unitUseQty));
            }
        }
        if (isKeyPart) {
            if (completeQty.compareTo(targetQty) > 0) {
                this.isWayFullSet = true;
            }
            completeQty = CPSUtil.min((BigDecimal)completeQty, (BigDecimal)targetQty);
        }
        return completeQty;
    }

    private void addCompleteDatas(KDCloudCPSEnv ctx, BigDecimal completeQty) {
        boolean isKeyPart = ctx.isKeyPart();
        Long billEntryId = (Long)MRPUtil.convert((Object)ctx.supplyDatas().getValue(DefaultField.SupplyField.BILLENTRYID.getName(), this.supplyRowIdx.intValue()), (Object)0L);
        List subRows = ctx.requireDatas().getCol(DefaultField.RequireField.SUPPLYBILLID.getName()).get((Object)billEntryId);
        List tmpBomChildren = ctx.requireDatas().fetchRow((Collection)subRows);
        for (RequireRowData rowData : tmpBomChildren) {
            BigDecimal unitUseQty;
            if (isKeyPart && !MRPUtil.convert((Object)rowData.getValue(DefaultField.RequireField.__EXIST_KEYPART__.getName()), (Boolean)Boolean.FALSE).booleanValue() || rowData.getValue(DefaultField.RequireField.__SUPPLY_IDX__.getName()) == null || BigDecimal.ZERO.compareTo(unitUseQty = (BigDecimal)MRPUtil.convert((Object)rowData.getValue(DefaultField.RequireField.__DEPENDENT_UNIT_QTY__.getName()), (Object)BigDecimal.ZERO)) == 0) continue;
            Object unit = rowData.getValue(DefaultField.RequireField.BASEUNIT.getName());
            CPSSupplyStatNode node = this.allUsedSupplys.get(rowData.getInteger(DefaultField.RequireField.__SUPPLY_IDX__.getName()));
            node.doSnap(this.changedNodes);
            node.doSnap(this.subChangedNodes);
            node.setConsumeQty4DepSupply(this.topReqIdx, this.llc + 1, MRPUtil.multiply2((IMRPEnvProvider)ctx, (Object)unit, (BigDecimal)completeQty, (BigDecimal)unitUseQty), rowData, this.path);
        }
    }
}

