/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.calcnode.framework.mq.resolver.cps;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.function.BiConsumer;
import kd.bos.exception.KDBizException;
import kd.mmc.mrp.calcnode.framework.mq.resolver.cps.ActionType;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.table.RequireRowData;

public class CPSSupplyStatNode {
    private Integer supplyRowIdx;
    private BigDecimal maxQty;
    private BigDecimal consumeQty4Dep = BigDecimal.ZERO;
    private BigDecimal consumeQty4BOM = BigDecimal.ZERO;
    private BigDecimal consumeQty4DepSupply = BigDecimal.ZERO;
    private BigDecimal virtualConsumeQty4DepSupply = BigDecimal.ZERO;
    private Map<String, Map<String, BigDecimal>> consumeQty4Deps = new HashMap<String, Map<String, BigDecimal>>(10);
    private Map<String, Map<String, BigDecimal>> consumeQty4BOMs = new HashMap<String, Map<String, BigDecimal>>(10);
    private Map<String, Map<String, BigDecimal>> consumeQty4DepSupplys = new HashMap<String, Map<String, BigDecimal>>(10);
    private Map<String, Map<String, RequireRowData>> reqDataMap = new HashMap<String, Map<String, RequireRowData>>(10);
    private Stack<Integer> snapshots = new Stack();
    private List<Object> actions = new LinkedList<Object>();

    public CPSSupplyStatNode(Integer supplyRowIdx) {
        this.supplyRowIdx = supplyRowIdx;
    }

    public Integer getSupplyRowIdx() {
        return this.supplyRowIdx;
    }

    public BigDecimal getMaxQty() {
        return this.maxQty;
    }

    public void setMaxQty(BigDecimal maxQty) {
        this.maxQty = maxQty;
    }

    public BigDecimal getConsumeQty4Dep() {
        return this.consumeQty4Dep;
    }

    public void setConsumeQty4Dep(int reqRowIdx, int level, BigDecimal consumeQty4Dep, String path, RequireRowData reqData) {
        if (consumeQty4Dep.compareTo(BigDecimal.ZERO) < 0) {
            return;
        }
        this.consumeQty4Dep = this.consumeQty4Dep.add(consumeQty4Dep);
        this.addAction(ActionType.addQty4Dep, this.consumeQty4Deps, reqRowIdx, level, consumeQty4Dep, path, reqData);
    }

    public BigDecimal getConsumeQty4BOM() {
        return this.consumeQty4BOM;
    }

    public void setConsumeQty4BOM(int reqRowIdx, int level, BigDecimal consumeQty4BOM, String path, RequireRowData reqData) {
        if (consumeQty4BOM.compareTo(BigDecimal.ZERO) < 0) {
            return;
        }
        this.consumeQty4BOM = this.consumeQty4BOM.add(consumeQty4BOM);
        this.addAction(ActionType.addQty4BOM, this.consumeQty4BOMs, reqRowIdx, level, consumeQty4BOM, path, reqData);
    }

    public BigDecimal getConsumeQty4DepSupply() {
        return this.consumeQty4DepSupply;
    }

    public BigDecimal getVirtualConsumeQty4DepSupply() {
        return this.virtualConsumeQty4DepSupply;
    }

    public void setConsumeQty4DepSupply(int reqRowIdx, int level, BigDecimal consumeQty4DepSupply, RequireRowData reqData, String path) {
        this.setConsumeQty4DepSupply(reqRowIdx, level, consumeQty4DepSupply, reqData, path, false);
    }

    public void setConsumeQty4DepSupply(int reqRowIdx, int level, BigDecimal consumeQty4DepSupply, RequireRowData reqData, String path, boolean isVirtual) {
        if (consumeQty4DepSupply.compareTo(BigDecimal.ZERO) < 0) {
            return;
        }
        this.consumeQty4DepSupply = this.consumeQty4DepSupply.add(consumeQty4DepSupply);
        this.addAction(ActionType.addQty4DepSupply, this.consumeQty4DepSupplys, reqRowIdx, level, consumeQty4DepSupply, reqData, path, isVirtual);
        if (isVirtual) {
            this.virtualConsumeQty4DepSupply = this.virtualConsumeQty4DepSupply.add(consumeQty4DepSupply);
        }
    }

    public void doSnap(List<CPSSupplyStatNode> records) {
        this.snapshots.push(this.actions.size());
        records.add(this);
    }

    public void doRollback() {
        ActionType action;
        if (this.snapshots.isEmpty()) {
            return;
        }
        Integer size = this.snapshots.pop();
        if (this.actions.size() == size.intValue()) {
            size = 0;
        }
        block5: for (int i = this.actions.size() - 1; i > size; i -= action.getArgCount()) {
            action = (ActionType)((Object)this.consumeParam(this.actions, i));
            switch (action) {
                case addQty4BOM: {
                    this.consumeQty4BOM = this.consumeQty4BOM.subtract((BigDecimal)this.removeQtyImpl(i, action.getArgCount(), 4));
                    continue block5;
                }
                case addQty4Dep: {
                    this.consumeQty4Dep = this.consumeQty4Dep.subtract((BigDecimal)this.removeQtyImpl(i, action.getArgCount(), 4));
                    continue block5;
                }
                case addQty4DepSupply: {
                    Boolean isVirtual = (Boolean)this.actions.remove(i - 1);
                    BigDecimal qty = (BigDecimal)this.removeQtyImpl(i - 1, action.getArgCount() - 1, 4);
                    this.consumeQty4DepSupply = this.consumeQty4DepSupply.subtract(qty);
                    if (!isVirtual.booleanValue()) continue block5;
                    this.virtualConsumeQty4DepSupply = this.virtualConsumeQty4DepSupply.subtract(qty);
                    continue block5;
                }
                default: {
                    throw new KDBizException("no rollback handler for action: " + action.name());
                }
            }
        }
    }

    public void finish() {
        this.snapshots.clear();
        RequireRowData reqData = null;
        int i = this.actions.size() - 1;
        block5: while (i > 0) {
            ActionType action = (ActionType)((Object)this.consumeParam(this.actions, i));
            switch (action) {
                case addQty4BOM: {
                    reqData = (RequireRowData)this.consumeParam(this.actions, (i -= action.getArgCount()) + 6);
                    String path = (String)this.consumeParam(this.actions, i + 5);
                    BigDecimal qty = (BigDecimal)this.consumeParam(this.actions, i + 4);
                    Integer level = (Integer)this.consumeParam(this.actions, i + 3);
                    Integer reqRowIdx = (Integer)this.consumeParam(this.actions, i + 2);
                    Map container = (Map)this.consumeParam(this.actions, i + 1);
                    if (qty.compareTo(BigDecimal.ZERO) <= 0) continue block5;
                    String reqKey = reqData == null ? reqRowIdx + "\u0001" + null : reqRowIdx + "\u0001" + reqData.getValue(DefaultField.RequireField.__BOM_IDX__.getName());
                    String key = level + "\u0001" + path;
                    this.reqDataMap.computeIfAbsent(reqKey, k -> new HashMap(1)).put(key, reqData);
                    this.addQtyImpl(container, reqRowIdx, level, qty, path, reqData, reqKey);
                    continue block5;
                }
                case addQty4Dep: {
                    reqData = (RequireRowData)this.consumeParam(this.actions, (i -= action.getArgCount()) + 6);
                    String path = (String)this.consumeParam(this.actions, i + 5);
                    BigDecimal qty = (BigDecimal)this.consumeParam(this.actions, i + 4);
                    Integer level = (Integer)this.consumeParam(this.actions, i + 3);
                    Integer reqRowIdx = (Integer)this.consumeParam(this.actions, i + 2);
                    Map container = (Map)this.consumeParam(this.actions, i + 1);
                    if (qty.compareTo(BigDecimal.ZERO) <= 0) continue block5;
                    String reqKey = reqData == null ? reqRowIdx + "\u0001" + null : reqRowIdx + "\u0001" + (reqData.getValue(DefaultField.RequireField.__BOM_IDX__.getName()) == null ? reqData.getValue(DefaultField.RequireField.BILLENTRYSEQ.getName()) : reqData.getValue(DefaultField.RequireField.__BOM_IDX__.getName()));
                    String key = level + "\u0001" + path;
                    this.reqDataMap.computeIfAbsent(reqKey, k -> new HashMap(1)).put(key, reqData);
                    this.addQtyImpl(container, reqRowIdx, level, qty, path, reqData, reqKey);
                    continue block5;
                }
                case addQty4DepSupply: {
                    Boolean isVirtual = (Boolean)this.consumeParam(this.actions, (i -= action.getArgCount()) + 7);
                    String path = (String)this.consumeParam(this.actions, i + 6);
                    reqData = (RequireRowData)this.consumeParam(this.actions, i + 5);
                    BigDecimal qty = (BigDecimal)this.consumeParam(this.actions, i + 4);
                    Integer level = (Integer)this.consumeParam(this.actions, i + 3);
                    Integer reqRowIdx = (Integer)this.consumeParam(this.actions, i + 2);
                    Map container = (Map)this.consumeParam(this.actions, i + 1);
                    if (qty.compareTo(BigDecimal.ZERO) <= 0) continue block5;
                    if (!isVirtual.booleanValue() && this.virtualConsumeQty4DepSupply.compareTo(BigDecimal.ZERO) > 0) {
                        this.virtualConsumeQty4DepSupply = this.virtualConsumeQty4DepSupply.subtract(qty);
                    }
                    String reqKey = reqData == null ? reqRowIdx + "\u0001" + null : reqRowIdx + "\u0001" + (reqData.getValue(DefaultField.RequireField.__BOM_IDX__.getName()) == null ? reqData.getValue(DefaultField.RequireField.BILLENTRYSEQ.getName()) : reqData.getValue(DefaultField.RequireField.__BOM_IDX__.getName()));
                    String key = level + "\u0001" + path;
                    this.reqDataMap.computeIfAbsent(reqKey, k -> new HashMap(1)).put(key, reqData);
                    this.addQtyImpl(container, reqRowIdx, level, qty, path, reqData, reqKey);
                    continue block5;
                }
            }
            throw new KDBizException("unknown action name: " + action.name());
        }
    }

    public RequireRowData getRequireData(String reqKey, String key) {
        Map<String, RequireRowData> dates = this.reqDataMap.get(reqKey);
        if (dates == null) {
            return null;
        }
        RequireRowData ret = dates.get(key);
        return ret;
    }

    public void visitConsume4Deps(BiConsumer<String, Map<String, BigDecimal>> action) {
        this.consumeQty4Deps.forEach(action);
    }

    public void visitConsume4BOMs(BiConsumer<String, Map<String, BigDecimal>> action) {
        this.consumeQty4BOMs.forEach(action);
    }

    public void visitConsumeQty4DepSupplys(BiConsumer<String, Map<String, BigDecimal>> action) {
        this.consumeQty4DepSupplys.forEach(action);
    }

    private <T> T removeQtyImpl(int i, int argCount, int retPos) {
        Object ret = null;
        i -= argCount;
        for (int pos = argCount - 1; pos > 0; --pos) {
            Object p = this.actions.remove(i + pos);
            if (retPos != pos) continue;
            ret = p;
        }
        return (T)ret;
    }

    private void addQtyImpl(Map<String, Map<String, BigDecimal>> container, int reqRowIdx, int level, BigDecimal qty, String path, RequireRowData reqData, String reqKey) {
        BigDecimal old;
        String key;
        Map<String, BigDecimal> supplys = container.get(reqKey);
        if (supplys == null) {
            supplys = new HashMap<String, BigDecimal>(10);
            container.put(reqKey, supplys);
        }
        supplys.put(key, (old = supplys.get(key = level + "\u0001" + path)) == null ? qty : old.add(qty));
    }

    private void addAction(ActionType action, Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            this.actions.add(args[i]);
        }
        this.actions.add((Object)action);
    }

    private <T> T consumeParam(List<?> actions, int pos) {
        return (T)actions.remove(pos);
    }
}

