/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.calcnode.framework.mq.resolver.query;

import com.alibaba.fastjson.JSON;
import java.util.HashSet;
import java.util.Set;
import kd.mmc.mrp.calcnode.framework.mq.resolver.query.AbstractMRPResDataQueryResolver;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.cache.MRPCacheManager;
import kd.mmc.mrp.framework.consts.MRPRuntimeConsts;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.utils.MRPUtil;

public class MRPRequireDataQueryResolver
extends AbstractMRPResDataQueryResolver {
    private Set<String> cols;
    int rowCount = 0;
    int idx;
    int trackIdx;
    int orgIdx;
    Set<String> configs = new HashSet<String>(16);
    Set<Long> tracks = new HashSet<Long>(16);

    public MRPRequireDataQueryResolver() {
        this.prefix = "require-";
    }

    @Override
    protected Set<String> getMetaKeyCols(IMRPEnvProvider ctx) {
        if (this.cols != null) {
            return this.cols;
        }
        this.cols = new HashSet<String>();
        this.cols.add("entryentity.material");
        return this.cols;
    }

    @Override
    protected void prepare(String[] metas) {
        this.idx = this.getRowIndex(metas, DefaultField.RequireField.CONFIGUREDCODE.getName());
        this.trackIdx = this.getRowIndex(metas, DefaultField.RequireField.TRACKNUMBER.getName());
        this.orgIdx = this.getRowIndex(metas, DefaultField.RequireField.PRODUCTIONORGUNIT.getName());
    }

    @Override
    protected void visitRow(Object[] r) {
        Long v;
        ++this.rowCount;
        if (this.idx < 0 && this.trackIdx < 0) {
            return;
        }
        if (this.idx >= 0 && this.orgIdx >= 0) {
            v = (Long)MRPUtil.convert((Object)r[this.idx], (Object)0L);
            Long org = (Long)MRPUtil.convert((Object)r[this.orgIdx], (Object)0L);
            if (v > 0L && org > 0L) {
                this.configs.add(v.toString() + '-' + org);
            }
        }
        if (this.trackIdx >= 0 && (v = (Long)MRPUtil.convert((Object)r[this.trackIdx], (Object)0L)) > 0L) {
            this.tracks.add(v);
        }
    }

    @Override
    protected void finish() {
        MRPCacheManager.getInst().putSubData((CalEnv)this.ctx, MRPRuntimeConsts.getRequireConfigKey((String)this.ctx.getMRPContextId()), MRPRuntimeConsts.getDataKey((String)this.event.getEventId(), (String)this.modelId, (String)""), JSON.toJSONString(this.configs));
        MRPCacheManager.getInst().putSubData((CalEnv)this.ctx, MRPRuntimeConsts.getRequireTrackKey((String)this.ctx.getMRPContextId()), MRPRuntimeConsts.getDataKey((String)this.event.getEventId(), (String)this.modelId, (String)""), JSON.toJSONString(this.tracks));
        MRPCacheManager.getInst().putData((CalEnv)this.ctx, MRPRuntimeConsts.getRowCountKey((String)this.event.getEventId(), (String)this.modelId), JSON.toJSONString((Object)this.rowCount));
    }

    protected int getRowIndex(String[] metas, String col) {
        for (int i = 0; i < metas.length; ++i) {
            if (!metas[i].equalsIgnoreCase(col)) continue;
            return i;
        }
        return -1;
    }
}

