/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.calcnode.framework.step;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mmc.mrp.calcnode.framework.step.AbstractMRPSubStep;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.consts.Tips;
import kd.mmc.mrp.framework.step.IMRPResult;
import kd.mmc.mrp.integrate.entity.CacheDatas;
import kd.mmc.mrp.integrate.entity.PlanModel;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mmc.mrp.model.enums.strategy.BillSupplyStrategy;
import kd.mmc.mrp.model.enums.strategy.MaterialAttribute;
import kd.mmc.mrp.model.struct.OrgSupplyStruct;
import kd.mmc.mrp.model.struct.SupplyOrgTypeStruct;
import kd.mmc.mrp.model.table.RequireRowData;
import kd.mmc.mrp.model.table.RowData;
import kd.mmc.mrp.model.table.res.RequirementDataTable;
import kd.mmc.mrp.utils.MRPUtil;
import kd.sdk.mmc.mrp.extpoint.IMRPCalcNetDemandPlugin;
import kd.sdk.mmc.mrp.framework.res.IRowData;

public class MRPCalQty4SupplyOrg
extends AbstractMRPSubStep {
    private static final Log logger = LogFactory.getLog(MRPCalQty4SupplyOrg.class);

    public MRPCalQty4SupplyOrg(IMRPEnvProvider ctx) {
        super(ctx);
    }

    @Override
    protected IMRPResult executeImpl() {
        this.calQty4SupplyOrg();
        return null;
    }

    public String getDesc() {
        return Tips.getCalQtySupplyorg();
    }

    private void calQty4SupplyOrg() {
        this.calQty4SupplyOrg(this.ctx, this.ctx.requireDatas());
    }

    public void calQty4SupplyOrg(IMRPEnvProvider ctx, RequirementDataTable requireTbl) {
        for (int i = 0; i < requireTbl.size(); ++i) {
            List<RequireRowData> result;
            boolean isStock;
            RequireRowData row = requireTbl.fetchRow(i);
            if ("1".equals(ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                logger.warn(String.format("ctxid: %s, mrprunner-orgIsNull, supplyOrg: %s, requireOrg: %s, mid: %s", ctx.getMRPContextId(), row.getValue(DefaultField.RequireField.SUPPLYORGUNIT.getName()), row.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()), row.getValue(DefaultField.RequireField.MATERIAL.getName())));
            }
            if ((isStock = MRPUtil.convert((Object)row.getValue(DefaultField.RequireField.ISSTOCK.getName()), (Boolean)Boolean.FALSE).booleanValue()) || requireTbl.isLock(Integer.valueOf(i)) || (result = this.splitRequireBySupplyNet(ctx, requireTbl, row, true)).isEmpty()) continue;
            requireTbl.fill(result.toArray(new RowData[0]));
        }
        this.doUpdateSupplyOrg(requireTbl);
    }

    public List<RequireRowData> splitRequireBySupplyNet(IMRPEnvProvider ctx, RequirementDataTable requireTbl, RequireRowData row, boolean isGross) {
        PlanModel planModel = (PlanModel)ctx.getService(PlanModel.class);
        CacheDatas cacheDatas = (CacheDatas)ctx.getService(CacheDatas.class);
        ArrayList<RequireRowData> result = new ArrayList<RequireRowData>(1);
        if (this.orgIsNull(row) && this.isFabricatedpart(row)) {
            if (requireTbl.noLock() && isGross) {
                row.update(DefaultField.RequireField.__IS_INTERNAL_GROSS_DEMAND__.getName(), (Object)Boolean.TRUE);
            }
            if (MRPUtil.convert((Object)row.getValue(DefaultField.RequireField.__IS_INTERNAL_GROSS_DEMAND__.getName()), (Boolean)Boolean.FALSE).booleanValue()) {
                row.update(DefaultField.RequireField.SUPPLYORGUNIT.getName(), row.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()));
                return result;
            }
            BigDecimal qty = MRPUtil.toBigDecimal((Object)row.getValue(DefaultField.RequireField.QTY.getName()));
            Long supply_network = (Long)MRPUtil.convert((Object)row.getValue(DefaultField.RequireField.SUPPLY_NETWORK.getName()), (Object)0L);
            Object materialId = row.getValue(DefaultField.RequireField.MATERIAL.getName());
            String mId = materialId == null ? "" : materialId.toString();
            String requireOrg = String.valueOf(row.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()));
            SupplyOrgTypeStruct defSupplyOrgTypeStruct = planModel.getSupplyOrgTypeStruct(supply_network, requireOrg, mId);
            if ("1".equals(ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                logger.warn(String.format("ctxid: %s, mrprunner-isFabricatedpart,  mid: %s", ctx.getMRPContextId(), mId));
            }
            if (defSupplyOrgTypeStruct != null) {
                Map.Entry entry;
                int x = 0;
                BillSupplyStrategy supplyStrategy = null;
                Iterator iterator = defSupplyOrgTypeStruct.getMap().entrySet().iterator();
                while (iterator.hasNext() && (supplyStrategy = ((OrgSupplyStruct)(entry = iterator.next()).getValue()).getStrategy()) == null) {
                }
                if (supplyStrategy != null) {
                    row.update(DefaultField.RequireField.SUPPLY_STRATEGY.getName(), (Object)supplyStrategy.getValue());
                }
                for (Map.Entry entry1 : defSupplyOrgTypeStruct.getMap().entrySet()) {
                    String org = (String)entry1.getKey();
                    OrgSupplyStruct orgSupplyStruct = (OrgSupplyStruct)entry1.getValue();
                    if (x == 0) {
                        row.update(DefaultField.RequireField.SUPPLYORGUNIT.getName(), (Object)Long.valueOf(org));
                        row.update(DefaultField.RequireField.QTY.getName(), (Object)MRPUtil.multiply((BigDecimal)orgSupplyStruct.getRatio(), (BigDecimal)qty));
                    } else {
                        RequireRowData copyRow = row.clone();
                        copyRow.update(DefaultField.RequireField.SUPPLYORGUNIT.getName(), (Object)Long.valueOf(org));
                        copyRow.update(DefaultField.RequireField.QTY.getName(), (Object)MRPUtil.multiply((BigDecimal)orgSupplyStruct.getRatio(), (BigDecimal)qty));
                        this.initRequireData(copyRow);
                        result.add(copyRow);
                    }
                    ++x;
                    if (!"1".equals(ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) continue;
                    logger.warn(String.format("ctxid: %s, mrprunner-OrgSupplyStruct, mid: %s, orgId: %s, ratio: %s", ctx.getMRPContextId(), mId, org, orgSupplyStruct.getRatio()));
                }
            }
        } else if (this.checkMaterialArr(row) && this.orgIsNull(row)) {
            row.update(DefaultField.RequireField.SUPPLYORGUNIT.getName(), row.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()));
        } else if ((!this.checkMaterialArr(row) || this.equalOrg(row)) && this.isFabricatedpart(row) && this.equalOrg(row)) {
            String msg = MRPUtil.appendExceptionMsg((Object)row.getValue(DefaultField.RequireField.EXCEPTIONMESSAGE.getName()), (String)ResManager.loadKDString((String)"\u5185\u534f\u4ef6\uff0c\u9700\u6c42\u7ec4\u7ec7\u7b49\u4e8e\u4f9b\u5e94\u7ec4\u7ec7", (String)"MRPCalQty4SupplyOrg_2", (String)"mmc-mrp-mservice-calcnode", (Object[])new Object[0]));
            row.update(DefaultField.RequireField.EXCEPTIONMESSAGE.getName(), (Object)msg);
            String num = MRPUtil.appendExceptionNumber((Object)row.getValue(DefaultField.RequireField.EXCEPTIONNUMBER.getName()), (String)"91");
            row.update(DefaultField.RequireField.EXCEPTIONNUMBER.getName(), (Object)num);
        }
        this.initRequireData(row);
        return result;
    }

    protected void initRequireData(RequireRowData requireData) {
        IMRPCalcNetDemandPlugin imrpCalcNetDemandPlugin = this.ctx.getMRPCalcNetDemandPlugin();
        if (imrpCalcNetDemandPlugin != null) {
            imrpCalcNetDemandPlugin.initRequireData(this.ctx.getMrpSdkEnv(), (IRowData)requireData);
        }
    }

    protected void doUpdateSupplyOrg(RequirementDataTable requirement) {
    }

    private boolean orgIsNull(RequireRowData row) {
        Object supplyOrg = row.getValue(DefaultField.RequireField.SUPPLYORGUNIT.getName());
        return supplyOrg == null || "0".equals(String.valueOf(supplyOrg));
    }

    private boolean equalOrg(RequireRowData row) {
        return row.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()).equals(row.getValue(DefaultField.RequireField.SUPPLYORGUNIT.getName()));
    }

    protected boolean isFabricatedpart(RequireRowData row) {
        int value = (Integer)MRPUtil.convert((Object)row.getValue(DefaultField.RequireField.MATERIALATTR.getName()), (Object)10070);
        return MaterialAttribute.STORAGEPART.getValue() == value;
    }

    protected boolean checkMaterialArr(RequireRowData row) {
        int value = (Integer)MRPUtil.convert((Object)row.getValue(DefaultField.RequireField.MATERIALATTR.getName()), (Object)10070);
        return MaterialAttribute.EXTERNALPROCESSINPART.getValue() == value || MaterialAttribute.FABRICATEDPART.getValue() == value || MaterialAttribute.PURCHASEDPART.getValue() == value || MaterialAttribute.PHANTOMPART.getValue() == value;
    }
}

