/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.calcnode.framework.step;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import kd.bos.algo.DataType;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.id.ID;
import kd.mmc.mrp.calcnode.framework.step.AbstractMRPSubStep;
import kd.mmc.mrp.calcnode.framework.step.comparator.SupplyDataSortComparator;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.step.IMRPResult;
import kd.mmc.mrp.integrate.entity.CacheDatas;
import kd.mmc.mrp.integrate.entity.InventoryModel;
import kd.mmc.mrp.integrate.entity.ModelUtil;
import kd.mmc.mrp.integrate.entity.PlanModel;
import kd.mmc.mrp.integrate.entity.RequireDataModel;
import kd.mmc.mrp.model.date.OrgBasedCalendarModel;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mmc.mrp.model.struct.SupplyStruct;
import kd.mmc.mrp.model.table.AdjustParameter;
import kd.mmc.mrp.model.table.AdjustSuggestTable;
import kd.mmc.mrp.model.table.DataBalanceTable;
import kd.mmc.mrp.model.table.RequireRowData;
import kd.mmc.mrp.model.table.RowData;
import kd.mmc.mrp.model.table.res.RequirementDataTable;
import kd.mmc.mrp.model.table.res.SupplymentDataTable;
import kd.mmc.mrp.model.table.utils.DataBalanceUtil;
import kd.mmc.mrp.model.table.utils.DataMatchUtils;
import kd.mmc.mrp.model.table.utils.InvPlanUtil;
import kd.mmc.mrp.model.wrapper.FieldMapping;
import kd.mmc.mrp.model.wrapper.SimplePlanOrder;
import kd.mmc.mrp.utils.MRPUtil;
import kd.mpscmm.msplan.business.inventory.InvLevel;
import kd.mpscmm.msplan.business.inventory.InvLevelConst;
import kd.mpscmm.msplan.business.inventory.InvLevelEntry;

public class MRPInventoryPlanStep
extends AbstractMRPSubStep {
    private final Map<Store, PoQty> poQtyMap = new LinkedHashMap<Store, PoQty>(16);
    private final LinkedList<RowData> unMatchedSupplys = new LinkedList();
    private final Map<RequireRowData, List<RowData>> unMatchedSupplysNeedOccupied = new HashMap<RequireRowData, List<RowData>>(16);
    private final Map<Store, PlanTypeCalc> calcMap;
    private final InvLevel invLevel;
    private final boolean isReorderPoint;
    private final boolean isMaxMin;
    private final Map<Long, Set<Long>> mtOrgsMap;
    private final Map<Long, List<Map<String, Long>>> mtToDimVals;
    private final Long curMt;
    private final Date now;
    private final List<FieldMapping> r2s;
    private boolean lessOrEqualRestock = true;
    private final Map<String, Store> poMap;
    private final Map<String, RequireRowData> poToRowMap;
    private final Map<String, Long> poNoToPoId;
    public static final DBRoute scm = new DBRoute("scm");
    private final Map<Integer, Boolean> cache = new WeakHashMap<Integer, Boolean>(16);
    private final Map<Integer, RowData> requireToSupplyCache = new WeakHashMap<Integer, RowData>(16);
    private Map<Long, OccupySupplyStruct> org2LastRequire = new HashMap<Long, OccupySupplyStruct>(2);

    public MRPInventoryPlanStep(IMRPEnvProvider ctx) {
        super(ctx);
        PlanModel pm = (PlanModel)ctx.getService(PlanModel.class);
        this.now = MRPUtil.normalize((Date)new Date());
        InventoryModel invModel = (InventoryModel)ctx.getService(InventoryModel.class);
        this.invLevel = invModel.getInvLevel();
        this.mtOrgsMap = invModel.getMtOrgsFromCache();
        this.mtToDimVals = invModel.getMtToDimValsFromCache();
        this.isReorderPoint = pm.isReorderPoint() && this.invLevel != null;
        this.isMaxMin = pm.isMaxMinInventory() && this.invLevel != null;
        this.calcMap = new HashMap<Store, PlanTypeCalc>(4);
        this.curMt = Long.valueOf(ctx.getCurrentResolveMaterial());
        this.r2s = ctx.r2s();
        this.poMap = new LinkedHashMap<String, Store>(8);
        this.poToRowMap = new LinkedHashMap<String, RequireRowData>(8);
        this.poNoToPoId = new LinkedHashMap<String, Long>(8);
        String inv_plan_calc_settings = (String)ctx.getCfgValue(EnvCfgItem.INV_PLAN_CALC_SETTINGS);
        if (StringUtils.equalsIgnoreCase((CharSequence)"EXCLUDE_ROP", (CharSequence)inv_plan_calc_settings)) {
            this.lessOrEqualRestock = false;
        }
    }

    @Override
    protected IMRPResult executeImpl() {
        if ((this.isReorderPoint || this.isMaxMin) && this.mtOrgsMap.containsKey(this.curMt)) {
            this.initSupplyStore();
            this.calc();
        }
        return null;
    }

    private void calc() {
        List rsMappings = this.ctx.calcBalanceDetails().getUnVisitedMappings();
        this.calcWithRequire(new ArrayList<DataBalanceTable.RSMapping>(rsMappings));
        if (!this.org2LastRequire.isEmpty()) {
            for (OccupySupplyStruct occupySupplyStruct : this.org2LastRequire.values()) {
                this.requireOccupySupply(occupySupplyStruct.planTypeCalc, occupySupplyStruct.usableSups, occupySupplyStruct.require, occupySupplyStruct.remainQty);
            }
        }
        this.createPlanOrder();
        this.calcWithoutRequire();
        int i = rsMappings.size();
        for (Map.Entry<RequireRowData, List<RowData>> entry : this.unMatchedSupplysNeedOccupied.entrySet()) {
            List<RowData> supplys = entry.getValue();
            RequireRowData requireRowData = entry.getKey();
            RequireRowData clone = requireRowData.clone();
            clone.setRowIdx(Integer.valueOf(this.ctx.calcBalanceDetails().getNewRequireIndex()));
            MRPInventoryPlanStep.handlePlanDate(clone, this.ctx);
            InvPlanUtil.updateInvRequireFields((IMRPEnvProvider)this.ctx, (RequireRowData)clone, (Object)clone.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()), (Object)clone.getValue(DefaultField.RequireField.MATERIAL.getName()));
            BigDecimal qty = BigDecimal.ZERO;
            for (RowData rowData : supplys) {
                qty = qty.add(rowData.getBigDecimal(DefaultField.SupplyField.QTY.getName()));
                String exceptionMsg = ResManager.loadKDString((String)"\u5e93\u5b58\u6c34\u4f4d\u5360\u7528\u3002", (String)"MRPInventoryPlanStep_0", (String)"mmc-mrp-mservice-calcnode", (Object[])new Object[0]);
                String exceptionNumber = "98";
                rowData.update(DefaultField.SupplyField._IS_INV_LEVEL_OCCUPIED_.getName(), (Object)Boolean.TRUE);
                rowData.update(DefaultField.SupplyField.__IS_OCCUPIED__.getName(), (Object)Boolean.TRUE);
                exceptionNumber = MRPUtil.appendExceptionNumber((Object)rowData.getValue(DefaultField.SupplyField.__EXCEPTIONNUMBER__.getName()), (String)exceptionNumber);
                exceptionMsg = MRPUtil.appendExceptionMsg((Object)rowData.getValue(DefaultField.SupplyField.__EXCEPTIONMESSAGE__.getName()), (String)exceptionMsg);
                rowData.update(DefaultField.SupplyField.__EXCEPTIONNUMBER__.getName(), (Object)exceptionNumber);
                rowData.update(DefaultField.SupplyField.__EXCEPTIONMESSAGE__.getName(), (Object)exceptionMsg);
            }
            clone.update(DefaultField.RequireField.QTY.getName(), (Object)qty);
            clone.update(DefaultField.RequireField.__SUPPLY_QTY__.getName(), (Object)qty);
            this.ctx.calcBalanceDetails().addMapping(clone, supplys, DataBalanceTable.MatchType.EQUAL);
            if (rsMappings.size() <= i) continue;
            DataBalanceTable.RSMapping rsMapping = (DataBalanceTable.RSMapping)rsMappings.get(i);
            rsMapping.setrQty(BigDecimal.ZERO);
            ++i;
        }
    }

    private AdjustSuggestTable adjustSuggestTable(RequireRowData require, RowData supply) {
        String supplyOrgId = String.valueOf(require.getValue(DefaultField.RequireField.SUPPLYORGUNIT.getName()));
        String requireProductOrgUnitID = String.valueOf(require.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()));
        OrgBasedCalendarModel rOcm = this.ctx.dateManager().get(supplyOrgId, requireProductOrgUnitID);
        Date requireDate = new Date((Long)require.getValue(DefaultField.RequireField.DATE.getName()));
        AdjustParameter adjustParameter = DataBalanceUtil.getAdjustParameter((IMRPEnvProvider)this.ctx, (RequireRowData)require);
        int tolerOfDelay = adjustParameter.getTolerOfDelay();
        int tolerOfForward = adjustParameter.getTolerOfForward();
        Date supplyDate = new Date((Long)supply.getValue(DefaultField.SupplyField.DATE.getName()));
        supplyOrgId = String.valueOf(supply.getValue(DefaultField.SupplyField.SUPPLYORGUNIT.getName()));
        OrgBasedCalendarModel sOcm = this.ctx.dateManager().get(supplyOrgId, requireProductOrgUnitID);
        int requirePeriod = sOcm.getWorkDaySeq(requireDate);
        int supplyPeriod = (Integer)MRPUtil.convert((Object)supply.getValue(DefaultField.SupplyField.ISSTORAGEDATA.getName()), (Object)0) != 0 ? requirePeriod : sOcm.getWorkDaySeq(supplyDate);
        return DataBalanceUtil.getAdjustSuggestTable((IMRPEnvProvider)this.ctx, (RequireRowData)require, (RowData)supply, (int)requirePeriod, (int)supplyPeriod, (Integer)tolerOfDelay, (Integer)tolerOfForward, (OrgBasedCalendarModel)rOcm);
    }

    private PlanTypeCalc createPlanTypeCalc(Store store) {
        Set<Long> orgs = this.mtOrgsMap.get(store.material);
        if (orgs == null || !orgs.contains(store.org)) {
            return null;
        }
        InvLevelEntry entry = this.invLevel.getEntry((Object)store.org, (Object)store.material, new HashMap(store.extendValMap));
        if (entry == null) {
            store.exception = ModelUtil.getMtInvNf();
            store.expCode = "96";
            return null;
        }
        if (entry.getPlanType() == InvLevelConst.PlanType.REORDER && this.isReorderPoint) {
            return new ReorderPoint(entry, this.lessOrEqualRestock);
        }
        if (entry.getPlanType() == InvLevelConst.PlanType.MAXMIN && this.isMaxMin) {
            return new MaxMinInventory(entry, this.lessOrEqualRestock);
        }
        String type = entry.getPlanType() == InvLevelConst.PlanType.REORDER ? ResManager.loadKDString((String)"\u518d\u8ba2\u8d27\u70b9", (String)"MRPInventoryPlanStep_1", (String)"mmc-mrp-mservice-calcnode", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6700\u5927\u6700\u5c0f\u5e93\u5b58", (String)"MRPInventoryPlanStep_2", (String)"mmc-mrp-mservice-calcnode", (Object[])new Object[0]);
        store.exception = String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u65b9\u5f0f\u4e0d\u5728\u8ba1\u7b97\u8303\u56f4\u5185\uff1a%s\u3002", (String)"MRPInventoryPlanStep_3", (String)"mmc-mrp-mservice-calcnode", (Object[])new Object[0]), type);
        store.expCode = "97";
        return null;
    }

    private void calcWithRequire(List<DataBalanceTable.RSMapping> rsMappings) {
        PlanModel planModel = (PlanModel)this.ctx.getService(PlanModel.class);
        for (int i = 0; i < rsMappings.size(); ++i) {
            PoQty poQty;
            Long unit;
            Long mt;
            Long reqOrg;
            Store store;
            PlanTypeCalc planTypeCalc;
            String exp;
            DataBalanceTable.RSMapping rsMapping = rsMappings.get(i);
            BigDecimal rQty = rsMapping.getrQty();
            RequireRowData requireData = rsMapping.getRequire();
            String string = exp = requireData.getValue(DefaultField.RequireField.EXCEPTIONNUMBER.getName()) == null ? "" : String.valueOf(requireData.getValue(DefaultField.RequireField.EXCEPTIONNUMBER.getName()));
            if (!StringUtils.isEmpty((CharSequence)exp) && MRPUtil.hasException((String)exp)) continue;
            BigDecimal result = BigDecimal.ZERO;
            List sups = rsMapping.getSupplys();
            if (sups != null) {
                for (RowData sup : sups) {
                    BigDecimal sQty = sup.getBigDecimal(DefaultField.SupplyField.QTY.getName());
                    if (sQty == null) continue;
                    result = result.add(sQty);
                }
            }
            Date requireDate = new Date((Long)requireData.getValue(DefaultField.RequireField.DATE.getName()));
            Timestamp today = new Timestamp(MRPUtil.normalize((Date)this.ctx.getPlanDate()).getTime());
            if (!this.ctx.isAllowPast() && requireDate.getTime() < today.getTime()) {
                requireData.update(DefaultField.RequireField.DATE.getName(), (Object)today.getTime());
            }
            if ((planTypeCalc = this.getPlanTypeCalc(store = new Store(reqOrg = requireData.getLong(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()), mt = requireData.getLong(DefaultField.RequireField.MATERIAL.getName()), unit = requireData.getLong(DefaultField.RequireField.BASEUNIT.getName()), InvPlanUtil.getExtendValMap((CalEnv)this.ctx, (RowData)requireData, (int)0)))) == null) {
                if (store.exception == null) continue;
                rsMapping.setExceptionData(true);
                requireData.update(DefaultField.RequireField.EXCEPTIONMESSAGE.getName(), (Object)store.exception);
                requireData.update(DefaultField.RequireField.EXCEPTIONNUMBER.getName(), (Object)store.expCode);
                continue;
            }
            Object invPlanTransferData = null;
            rsMapping.setVirtualQty(null);
            if (invPlanTransferData != null) continue;
            if (!this.poQtyMap.containsKey(store)) {
                poQty = this.poQtyMap.computeIfAbsent(store, k -> new PoQty(this.poToRowMap, this.ctx, this.cache, this.requireToSupplyCache));
                RequireRowData emptyRequire = this.createEmptyRequire(-1, store, null, requireData.getBigDecimal(DefaultField.RequireField.QTY.getName()));
                emptyRequire.update(DefaultField.RequireField.MATERIALFLEXPROPS.getName(), requireData.getValue(DefaultField.RequireField.MATERIALFLEXPROPS.getName()));
                this.noRQtyCreateVirtualPo(result, planTypeCalc, i, rsMappings, store, poQty, emptyRequire, false);
            } else {
                poQty = this.poQtyMap.get(store);
            }
            if (rQty.compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal newQty = planTypeCalc.getPlanOrderQty(rQty, poQty.qty(requireData));
                this.createVirtualPo(planTypeCalc, newQty, reqOrg, poQty, store, requireData);
                Map<String, BigDecimal> poSupply = poQty.subtract(rQty, requireData);
                this.addPoSupply(rsMapping, poSupply, store);
                continue;
            }
            BigDecimal remainQty = poQty.qty(requireData);
            this.noRQtyCreateVirtualPo(remainQty, planTypeCalc, i, rsMappings, store, poQty, requireData, true);
        }
    }

    private void noRQtyCreateVirtualPo(BigDecimal remainQty, PlanTypeCalc planTypeCalc, int i, List<DataBalanceTable.RSMapping> rsMappings, Store store, PoQty poQty, RequireRowData requireData, boolean isOccupy) {
        if (!planTypeCalc.isEnough(remainQty)) {
            boolean isOrgLastRequire = true;
            ArrayList<RowData> leftSupplyRows = new ArrayList<RowData>(16);
            int size = rsMappings.size();
            for (int j = i + 1; j < size; ++j) {
                List supplys;
                RequireRowData r = rsMappings.get(j).getRequire();
                Long org = r.getLong(DefaultField.RequireField.PRODUCTIONORGUNIT.getName());
                if (store.org.equals(org)) {
                    isOrgLastRequire = false;
                }
                if ((supplys = rsMappings.get(j).getSupplys()) == null) continue;
                leftSupplyRows.addAll(supplys);
            }
            BigDecimal storeQty = this.getStoreQty(requireData, leftSupplyRows, remainQty, planTypeCalc, isOccupy, isOrgLastRequire);
            BigDecimal newQty = planTypeCalc.getPlanOrderQty(storeQty.negate(), remainQty);
            this.createVirtualPo(planTypeCalc, newQty, store.org, poQty, store, requireData);
        }
    }

    private static boolean isNewCollaborate(RowData sup) {
        String billEntity = sup.getString(DefaultField.SupplyField.BILL_ENTITY.getName());
        String module = sup.getString(DefaultField.CommonField.__MODEL_NUMBER__.name());
        return StringUtils.equalsIgnoreCase((CharSequence)billEntity, (CharSequence)"mrp_collaborativeorder") && (StringUtils.startsWith((CharSequence)module, (CharSequence)ResManager.loadKDString((String)"\u65b0\u521b\u5efa", (String)"MRPInventoryPlanStep_6", (String)"mmc-mrp-mservice-calcnode", (Object[])new Object[0])) || StringUtils.startsWith((CharSequence)module, (CharSequence)ResManager.loadKDString((String)"\u65b0\u5efa", (String)"MRPInventoryPlanStep_7", (String)"mmc-mrp-mservice-calcnode", (Object[])new Object[0])));
    }

    private void createVirtualPo(PlanTypeCalc planTypeCalc, BigDecimal qty, Long reqOrg, PoQty poQty, Store store, RequireRowData requireData) {
        if (qty == null) {
            return;
        }
        String inv_plan_order_settings = (String)this.ctx.getCfgValue(EnvCfgItem.INV_PLAN_ORDER_SETTINGS);
        BigDecimal splitPoQty = StringUtils.equalsIgnoreCase((CharSequence)inv_plan_order_settings, (CharSequence)"SINGLE") ? qty : planTypeCalc.getSplitPoQty(qty);
        do {
            String poNum = MRPUtil.genPONum((IMRPEnvProvider)this.ctx, (String)String.valueOf(reqOrg));
            long id = ID.genLongId();
            this.poNoToPoId.put(poNum, id);
            poQty.add(poNum, splitPoQty.compareTo(qty) < 0 ? splitPoQty : qty);
            this.poMap.put(poNum, store);
            this.poToRowMap.put(poNum, requireData);
        } while ((qty = qty.subtract(splitPoQty)).compareTo(BigDecimal.ZERO) > 0);
    }

    private void addPoSupply(DataBalanceTable.RSMapping rsMapping, Map<String, BigDecimal> poSupply, Store store) {
        rsMapping.setMt(DataBalanceTable.MatchType.EQUAL);
        rsMapping.setrQty(BigDecimal.ZERO);
        for (Map.Entry<String, BigDecimal> entry : poSupply.entrySet()) {
            BigDecimal qty = entry.getValue();
            String poNum = entry.getKey();
            RequireRowData rowData = this.poToRowMap.get(poNum);
            Long supplyDate = rowData == null ? null : rowData.getLong(DefaultField.RequireField.DATE.getName());
            SimplePlanOrder planOrder = new SimplePlanOrder();
            planOrder.setId(this.poNoToPoId.get(poNum) == null ? null : this.poNoToPoId.get(poNum).toString());
            planOrder.setNumber(poNum);
            planOrder.setQty(qty);
            planOrder.setSupplyDate(supplyDate);
            HashMap<String, Object> po = new HashMap<String, Object>();
            po.put("proorpurorg", store.org);
            po.put("tracknumber", rowData == null ? null : rowData.getValue(DefaultField.RequireField.TRACKNUMBER.getName()));
            po.put("project", rowData == null ? null : rowData.getValue(DefaultField.RequireField.PROJECTNUMBER.getName()));
            po.put("supplier", rowData == null ? null : rowData.getValue(DefaultField.RequireField.SUPPLIER.getName()));
            po.put("auxproperty", rowData == null ? null : rowData.getValue(DefaultField.RequireField.MATERIALFLEXPROPS.getName()));
            planOrder.setAuxProperty(po.get("auxproperty"));
            planOrder.setProductOrgUnit((Object)store.org);
            planOrder.setTrackNumber(po.get("tracknumber"));
            planOrder.setProject(po.get("project"));
            planOrder.setSupplier(po.get("supplier"));
            planOrder.setPlanScope(rsMapping.getRequire().get(DefaultField.RequireField.PLANSCOPE.getName()));
            rsMapping.addPo(planOrder);
        }
    }

    private boolean isFabricatedPart(String org, String material) {
        return false;
    }

    private PlanTypeCalc getPlanTypeCalc(Store store) {
        return this.calcMap.computeIfAbsent(store, this::createPlanTypeCalc);
    }

    private void calcWithoutRequire() {
        PlanTypeCalc planTypeCalc;
        Qty qty;
        LinkedHashMap<Store, Qty> storeQtyMap = new LinkedHashMap<Store, Qty>(16);
        CacheDatas cacheDatas = (CacheDatas)this.ctx.getService(CacheDatas.class);
        List<Map<String, Long>> dimVals = this.mtToDimVals.get(this.curMt);
        DynamicObject unit = cacheDatas.reloadDataById("bd_material", (Object)this.curMt, "id,baseunit");
        Long unitId = unit == null ? 0L : unit.getLong("baseunit_id");
        block0: for (Map<String, Long> map : dimVals) {
            Store store;
            HashMap<String, Long> extendValMap = new HashMap<String, Long>(map);
            Long org = (Long)extendValMap.remove("bos_org");
            if (!this.ctx.getRequirorgs().contains(String.valueOf(org)) || this.calcMap.containsKey(store = new Store(org, this.curMt, unitId, extendValMap))) continue;
            qty = storeQtyMap.computeIfAbsent(store, k -> new Qty());
            planTypeCalc = this.getPlanTypeCalc(store);
            if (planTypeCalc == null) continue;
            RequireRowData require = this.createEmptyRequire(-1, store, null, BigDecimal.ONE);
            ListIterator its = this.unMatchedSupplys.listIterator();
            while (its.hasNext()) {
                BigDecimal rQty;
                RowData supRow = (RowData)its.next();
                BigDecimal amt = supRow.getBigDecimal(DefaultField.SupplyField.QTY.getName());
                if (amt == null || amt.compareTo(BigDecimal.ZERO) <= 0 || (rQty = planTypeCalc.getPlanOrderQty(BigDecimal.ZERO, qty.qty)) == null || !DataBalanceUtil.isMatch((IMRPEnvProvider)this.ctx, (RequireRowData)require, (RowData)supRow, this.r2s, (boolean)false, this.cache) || !DataBalanceUtil.isInPeriod((RequireRowData)require, (RowData)supRow, (IMRPEnvProvider)this.ctx)) continue;
                int balance = rQty.compareTo(amt);
                AdjustSuggestTable suggestTable = this.adjustSuggestTable(require, supRow);
                if (suggestTable == null) continue;
                List supRows = this.unMatchedSupplysNeedOccupied.computeIfAbsent(require, k -> new ArrayList());
                if (balance >= 0) {
                    DataBalanceUtil.lessOrEqualsDataBalance((IMRPEnvProvider)this.ctx, (RowData)supRow, (AdjustSuggestTable)suggestTable);
                    qty.add(amt);
                    supRows.add(supRow);
                    its.remove();
                } else {
                    SupplymentDataTable stable = this.ctx.supplyDatas();
                    int idx2 = DataBalanceUtil.surplusDataBalance((IMRPEnvProvider)this.ctx, (RowData)supRow, (AdjustSuggestTable)suggestTable, (SupplymentDataTable)stable, (BigDecimal)amt.subtract(rQty));
                    if (idx2 >= 0) {
                        RowData newSupply = stable.fetchRow(idx2);
                        qty.add(newSupply.getBigDecimal(DefaultField.SupplyField.QTY.getName()));
                        supRows.add(newSupply);
                    } else {
                        qty.add(amt);
                        supRows.add(supRow);
                        its.remove();
                    }
                }
                if (balance > 0) continue;
                continue block0;
            }
        }
        ArrayList<Tuple2<Store, PoQty>> poMap = new ArrayList<Tuple2<Store, PoQty>>(8);
        PlanModel planModel = (PlanModel)this.ctx.getService(PlanModel.class);
        for (Map.Entry entry : storeQtyMap.entrySet()) {
            Store key = (Store)entry.getKey();
            qty = (Qty)entry.getValue();
            planTypeCalc = this.getPlanTypeCalc(key);
            if (planTypeCalc == null || planTypeCalc.isEnough(qty.qty)) continue;
            BigDecimal newQty = planTypeCalc.getPlanOrderQty(BigDecimal.ZERO, qty.qty);
            PoQty poQty = new PoQty(this.poToRowMap, this.ctx, this.cache, this.requireToSupplyCache);
            if (!this.isFabricatedPart(key.org.toString(), key.material.toString())) {
                this.createVirtualPo(planTypeCalc, newQty, key.org, poQty, key, null);
            }
            poMap.add((Tuple2<Store, PoQty>)new Tuple2((Object)key, (Object)poQty));
        }
        this.createPlanOrder(poMap, false);
    }

    private void createPlanOrder() {
        ArrayList<Tuple2<Store, PoQty>> list = new ArrayList<Tuple2<Store, PoQty>>(8);
        LinkedHashSet<Store> stores = new LinkedHashSet<Store>(this.poMap.values());
        for (Store store : stores) {
            PoQty poQty = this.poQtyMap.get(store);
            if (poQty == null) continue;
            list.add((Tuple2<Store, PoQty>)new Tuple2((Object)store, (Object)poQty));
        }
        this.createPlanOrder(list, true);
    }

    private void createPlanOrder(List<Tuple2<Store, PoQty>> poList, boolean fromRequire) {
        List rsMappings = this.ctx.calcBalanceDetails().getUnVisitedMappings();
        int i = rsMappings.size();
        for (Tuple2<Store, PoQty> entry : poList) {
            Store store = (Store)entry.t1;
            PoQty poQty = (PoQty)entry.t2;
            Map<String, BigDecimal> leftMap = poQty.left();
            for (Map.Entry<String, BigDecimal> ee : poQty.oriLeft().entrySet()) {
                String poNum = ee.getKey();
                BigDecimal allQty = ee.getValue();
                if (fromRequire) {
                    BigDecimal leftQty = leftMap.get(poNum);
                    leftQty = leftQty == null ? BigDecimal.ZERO : leftQty;
                    RequireRowData requireRowData = this.poToRowMap.get(poNum);
                    RequireRowData clone = requireRowData.clone();
                    clone.setRowIdx(Integer.valueOf(this.ctx.calcBalanceDetails().getNewRequireIndex()));
                    MRPInventoryPlanStep.handlePlanDate(clone, this.ctx);
                    ArrayList supplys = new ArrayList(0);
                    DataBalanceTable.MatchType matchType = DataBalanceTable.MatchType.LESS;
                    clone.update(DefaultField.RequireField.QTY.getName(), (Object)allQty);
                    clone.update(DefaultField.RequireField.__INV_PO_QTY__.getName(), (Object)leftQty);
                    clone.update(DefaultField.RequireField.__INVLEVEL_REQUIRE__.getName(), (Object)Boolean.TRUE);
                    clone.update(DefaultField.RequireField.__INVLEVEL_BILLNUMBER__.getName(), (Object)poNum);
                    clone.update(DefaultField.RequireField.__PO_ID__.getName(), (Object)this.poNoToPoId.get(poNum));
                    this.ctx.calcBalanceDetails().addMapping(clone, supplys, matchType);
                    if (rsMappings.size() <= i) continue;
                    DataBalanceTable.RSMapping rsMapping = (DataBalanceTable.RSMapping)rsMappings.get(i);
                    rsMapping.setrQty(allQty);
                    ++i;
                    continue;
                }
                RequireRowData require = this.createEmptyRequire(this.ctx.calcBalanceDetails().getNewRequireIndex(), store, poNum, allQty);
                MRPInventoryPlanStep.handlePlanDate(require, this.ctx);
                ArrayList supplys = new ArrayList(0);
                DataBalanceTable.MatchType matchType = DataBalanceTable.MatchType.LESS;
                this.ctx.calcBalanceDetails().addMapping(require, supplys, matchType);
                if (rsMappings.size() <= i) continue;
                DataBalanceTable.RSMapping rsMapping = (DataBalanceTable.RSMapping)rsMappings.get(i);
                rsMapping.setrQty(allQty);
                ++i;
            }
        }
    }

    private RequireRowData createEmptyRequire(int idx, Store store, String poNum, BigDecimal rQty) {
        Object[] mftData;
        RequireDataModel requireDataModel = (RequireDataModel)this.ctx.getService(RequireDataModel.class);
        PlanModel planModel = (PlanModel)this.ctx.getService(PlanModel.class);
        CacheDatas cacheDatas = (CacheDatas)this.ctx.getService(CacheDatas.class);
        RequirementDataTable requirementDataTable = this.ctx.requireDatas();
        Map colIdx = requirementDataTable.getColIdx();
        Object[] obj = new Object[colIdx.size()];
        RequireRowData require = new RequireRowData(requirementDataTable.getSrcDatas(), Integer.valueOf(idx), colIdx, obj);
        InvLevelEntry invLevelEntry = this.invLevel.getEntry((Object)store.org, (Object)store.material, new HashMap(store.extendValMap));
        HashMap info = InventoryModel.invToMap((InvLevelEntry)invLevelEntry, (Long)store.org, (Long)store.material);
        HashMap requireMap = requireDataModel.infoToRequireMap((Map)info);
        for (Map.Entry kk : requireMap.entrySet()) {
            require.update((String)kk.getKey(), kk.getValue());
        }
        SupplyStruct ss = planModel.getPriorityRelations().getOrDefault(store.org.toString(), new SupplyStruct());
        obj[((Integer)colIdx.get((Object)DefaultField.RequireField.MATERIAL.getName())).intValue()] = store.material;
        obj[((Integer)colIdx.get((Object)DefaultField.RequireField.BASEUNIT.getName())).intValue()] = store.unit;
        obj[((Integer)colIdx.get((Object)DefaultField.RequireField.__INVLEVEL_REQUIRE__.getName())).intValue()] = true;
        obj[((Integer)colIdx.get((Object)DefaultField.RequireField.__INVLEVEL_BILLNUMBER__.getName())).intValue()] = poNum;
        obj[((Integer)colIdx.get((Object)DefaultField.RequireField.__PO_ID__.getName())).intValue()] = this.poNoToPoId.get(poNum);
        obj[((Integer)colIdx.get((Object)DefaultField.RequireField.PRODUCTIONORGUNIT.getName())).intValue()] = store.org;
        obj[((Integer)colIdx.get((Object)DefaultField.RequireField.SUPPLYORGUNIT.getName())).intValue()] = store.org;
        obj[((Integer)colIdx.get((Object)DefaultField.RequireField.OWNER.getName())).intValue()] = store.org;
        obj[((Integer)colIdx.get((Object)DefaultField.RequireField.QTY.getName())).intValue()] = rQty;
        obj[((Integer)colIdx.get((Object)DefaultField.RequireField.DATE.getName())).intValue()] = this.now.getTime();
        obj[((Integer)colIdx.get((Object)DefaultField.RequireField.__ORIGIN_DEMAND_DATE__.getName())).intValue()] = this.now.getTime();
        obj[((Integer)colIdx.get((Object)DefaultField.RequireField.TOP_REQUIRE_DATE.getName())).intValue()] = this.now.getTime();
        obj[((Integer)colIdx.get((Object)DefaultField.RequireField.PLANSCOPE.getName())).intValue()] = ss.getPlanScope();
        Map extendDimToColumn = InvPlanUtil.getExtendDimToColumn((CalEnv)this.ctx, (int)0);
        for (Map.Entry entry : extendDimToColumn.entrySet()) {
            obj[((Integer)colIdx.get(entry.getValue())).intValue()] = invLevelEntry.getDimensionValue((String)entry.getKey());
        }
        Long mftId = (Long)MRPUtil.convert((Object)obj[(Integer)colIdx.get(DefaultField.RequireField.MATERIALMFTINFO.getName())], (Object)0L);
        if (mftId <= 0L) {
            mftData = cacheDatas.getMftData4OrgAndMaterial(store.org, store.material);
            mftId = (Long)MRPUtil.convert((Object)mftData[7], (Object)0L);
        } else {
            mftData = cacheDatas.getMftData4Id(mftId);
        }
        obj[((Integer)colIdx.get((Object)DefaultField.RequireField.MATERIALMFTINFO.getName())).intValue()] = mftId;
        Long in_storage_org = store.org;
        Long in_storage_warehouse = 0L;
        Long in_storage_shipping = 0L;
        if (mftId > 0L) {
            in_storage_org = (Long)MRPUtil.convert((Object)mftData[3], (Object)0L);
            in_storage_warehouse = (Long)MRPUtil.convert((Object)mftData[4], (Object)0L);
            in_storage_shipping = (Long)MRPUtil.convert((Object)mftData[5], (Object)0L);
        }
        if (obj[(Integer)colIdx.get(DefaultField.RequireField.IN_STORAGE_ORG.getName())] == null) {
            obj[((Integer)colIdx.get((Object)DefaultField.RequireField.IN_STORAGE_ORG.getName())).intValue()] = in_storage_org;
        }
        if (obj[(Integer)colIdx.get(DefaultField.RequireField.IN_STORAGE_WAREHOUSE.getName())] == null) {
            obj[((Integer)colIdx.get((Object)DefaultField.RequireField.IN_STORAGE_WAREHOUSE.getName())).intValue()] = in_storage_warehouse;
        }
        if (obj[(Integer)colIdx.get(DefaultField.RequireField.IN_STORAGE_SHIPPING.getName())] == null) {
            obj[((Integer)colIdx.get((Object)DefaultField.RequireField.IN_STORAGE_SHIPPING.getName())).intValue()] = in_storage_shipping;
        }
        InvPlanUtil.updateInvRequireFields((IMRPEnvProvider)this.ctx, (RequireRowData)require, (Object)store.org, (Object)store.material, (InvLevelEntry)invLevelEntry);
        obj[((Integer)colIdx.get((Object)DefaultField.RequireField.__INV_PO_QTY__.getName())).intValue()] = rQty;
        return require;
    }

    private static void handlePlanDate(RequireRowData require, IMRPEnvProvider ctx) {
        MRPUtil.calcDate((RequireRowData)require, null, (IMRPEnvProvider)ctx);
    }

    private BigDecimal getStoreQty(RequireRowData require, List<RowData> supplys, BigDecimal remainQty, PlanTypeCalc planTypeCalc, boolean isOccupy, boolean isOrgLastRequire) {
        BigDecimal result = remainQty;
        LinkedList<RowData> allSupplys = new LinkedList<RowData>();
        if (isOccupy && isOrgLastRequire) {
            allSupplys.addAll(this.unMatchedSupplys);
        } else {
            allSupplys.addAll(supplys);
            allSupplys.addAll(this.unMatchedSupplys);
        }
        LinkedList<RowData> usableSups = new LinkedList<RowData>();
        for (RowData supply : allSupplys) {
            BigDecimal supQty;
            if (MRPInventoryPlanStep.isNewCollaborate(supply) || !DataBalanceUtil.isMatch((IMRPEnvProvider)this.ctx, (RequireRowData)require, (RowData)supply, this.r2s, (boolean)false, this.cache) || !DataBalanceUtil.isInPeriod((RequireRowData)require, (RowData)supply, (IMRPEnvProvider)this.ctx) || (supQty = supply.getBigDecimal(DefaultField.SupplyField.QTY.getName())) == null || supQty.compareTo(BigDecimal.ZERO) <= 0) continue;
            result = result.add(supQty);
            usableSups.add(supply);
            if (!planTypeCalc.isEnough(result)) continue;
            break;
        }
        if (isOccupy && !planTypeCalc.isEnough(result)) {
            result = this.requireOccupySupply(planTypeCalc, usableSups, require, remainQty);
        } else if (isOccupy && planTypeCalc.isEnough(result)) {
            Long org = require.getLong(DefaultField.RequireField.PRODUCTIONORGUNIT.getName());
            this.org2LastRequire.put(org, new OccupySupplyStruct(planTypeCalc, usableSups, remainQty, require));
        }
        return result.subtract(remainQty);
    }

    private BigDecimal requireOccupySupply(PlanTypeCalc planTypeCalc, LinkedList<RowData> usableSups, RequireRowData require, BigDecimal remainQty) {
        BigDecimal result = remainQty;
        for (RowData supply : usableSups) {
            BigDecimal s;
            BigDecimal supQty;
            BigDecimal sQty = supQty = supply.getBigDecimal(DefaultField.SupplyField.QTY.getName());
            if (!this.isOccupied(supply) && (s = this.occupySupplys(planTypeCalc, result, supQty, require, supply)) != null) {
                sQty = s;
            }
            if (!planTypeCalc.isEnough(result = result.add(sQty))) continue;
            break;
        }
        return result;
    }

    private BigDecimal occupySupplys(PlanTypeCalc planTypeCalc, BigDecimal result, BigDecimal supQty, RequireRowData require, RowData supply) {
        BigDecimal rQty = planTypeCalc.getPlanOrderQty(BigDecimal.ZERO, result);
        BigDecimal sQty = null;
        if (rQty == null) {
            return sQty;
        }
        int balance = rQty.compareTo(supQty);
        AdjustSuggestTable suggestTable = this.adjustSuggestTable(require, supply);
        if (suggestTable == null) {
            return sQty;
        }
        List supRows = this.unMatchedSupplysNeedOccupied.computeIfAbsent(require, k -> new ArrayList());
        if (balance >= 0) {
            DataBalanceUtil.lessOrEqualsDataBalance((IMRPEnvProvider)this.ctx, (RowData)supply, (AdjustSuggestTable)suggestTable);
            supRows.add(supply);
            this.unMatchedSupplys.remove(supply);
        } else {
            SupplymentDataTable stable = this.ctx.supplyDatas();
            int idx2 = DataBalanceUtil.surplusDataBalance((IMRPEnvProvider)this.ctx, (RowData)supply, (AdjustSuggestTable)suggestTable, (SupplymentDataTable)stable, (BigDecimal)supQty.subtract(rQty));
            if (idx2 >= 0) {
                RowData newSupply = stable.fetchRow(idx2);
                supRows.add(newSupply);
                sQty = newSupply.getBigDecimal(DefaultField.SupplyField.QTY.getName());
            } else {
                supRows.add(supply);
                this.unMatchedSupplys.remove(supply);
            }
        }
        return sQty;
    }

    private void initSupplyStore() {
        SupplymentDataTable supTable = this.ctx.supplyDatas();
        if (supTable == null) {
            return;
        }
        for (int i = 0; i < supTable.size(); ++i) {
            RowData supply = supTable.fetchRow(i);
            if (this.isOccupied(supply)) continue;
            this.unMatchedSupplys.add(supply);
        }
        this.unMatchedSupplys.sort(new SupplyDataSortComparator());
    }

    private boolean isOccupied(RowData supply) {
        String val;
        Object isLocked = supply.getValue(DefaultField.SupplyField.__IS_OCCUPIED__.name());
        Object isReplace = supply.getValue(DefaultField.SupplyField.__IS_REPLACE__.getName());
        if (isLocked != null && ((Boolean)isLocked).booleanValue()) {
            return true;
        }
        Object value = supply.getValue(DefaultField.SupplyField.__EXCEPTIONNUMBER__.getName());
        if (value != null && ((val = String.valueOf(value)).contains("96") || val.contains("97") || val.contains("90") || MRPUtil.removeException((String)val))) {
            return true;
        }
        return isReplace != null && (Boolean)isReplace != false;
    }

    public String getDesc() {
        return ResManager.loadKDString((String)"\u5e93\u5b58\u8ba1\u5212\u8ba1\u7b97", (String)"MRPInventoryPlanStep_4", (String)"mmc-mrp-mservice-calcnode", (Object[])new Object[0]);
    }

    private static class MaxMinInventory
    implements PlanTypeCalc {
        BigDecimal max;
        BigDecimal min;
        boolean lessOrEqualRestock;

        MaxMinInventory(InvLevelEntry entry, boolean lessOrEqualRestock) {
            this.min = entry.getMin();
            this.max = entry.getMax();
            this.lessOrEqualRestock = lessOrEqualRestock;
        }

        @Override
        public BigDecimal getPlanOrderQty(BigDecimal rQty, BigDecimal remainQty) {
            BigDecimal left = remainQty.subtract(rQty);
            if (this.isEnough(left)) {
                return null;
            }
            return this.max.subtract(left);
        }

        @Override
        public boolean isEnough(BigDecimal poQty) {
            return poQty.compareTo(this.min) > 0 || !this.lessOrEqualRestock && poQty.compareTo(this.min) == 0;
        }

        @Override
        public BigDecimal getSplitPoQty(BigDecimal poQty) {
            return poQty;
        }
    }

    private static class ReorderPoint
    implements PlanTypeCalc {
        BigDecimal point;
        BigDecimal batch;
        boolean lessOrEqualRestock;

        ReorderPoint(InvLevelEntry entry, boolean lessOrEqualRestock) {
            this.point = entry.getReorder();
            this.batch = entry.getEcoBatch();
            this.lessOrEqualRestock = lessOrEqualRestock;
        }

        private BigDecimal getPlanOrderQty(BigDecimal rQty) {
            BigDecimal newQty = rQty.add(this.point);
            BigDecimal multiply = newQty.divide(this.batch, 0, 2).multiply(this.batch);
            if (this.isEnough(multiply.subtract(rQty))) {
                return multiply;
            }
            return multiply.add(this.batch);
        }

        @Override
        public BigDecimal getPlanOrderQty(BigDecimal rQty, BigDecimal remainQty) {
            BigDecimal left = remainQty.subtract(rQty);
            if (!this.isEnough(left)) {
                return this.getPlanOrderQty(left.negate());
            }
            return null;
        }

        @Override
        public boolean isEnough(BigDecimal poQty) {
            return poQty.compareTo(this.point) > 0 || !this.lessOrEqualRestock && poQty.compareTo(this.point) == 0;
        }

        @Override
        public BigDecimal getSplitPoQty(BigDecimal poQty) {
            if (this.batch.compareTo(poQty) > 0) {
                return poQty;
            }
            return this.batch;
        }
    }

    private static interface PlanTypeCalc {
        public BigDecimal getPlanOrderQty(BigDecimal var1, BigDecimal var2);

        public boolean isEnough(BigDecimal var1);

        public BigDecimal getSplitPoQty(BigDecimal var1);
    }

    private static class Store {
        private Long org;
        private Long material;
        private Long unit;
        private Map<String, Long> extendValMap;
        private String exception;
        private String expCode;

        Store(Object org, Object material) {
            this.org = (Long)DataType.convertValue((DataType)DataType.LongType, (Object)org);
            this.material = (Long)DataType.convertValue((DataType)DataType.LongType, (Object)material);
        }

        Store(Object org, Object material, Object unit) {
            this(org, material);
            this.unit = (Long)DataType.convertValue((DataType)DataType.LongType, (Object)unit);
        }

        Store(Object org, Object material, Object unit, Map<String, Long> extendValMap) {
            this(org, material, unit);
            this.extendValMap = extendValMap;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Store store = (Store)o;
            if (!Objects.equals(this.org, store.org) || !Objects.equals(this.material, store.material)) {
                return false;
            }
            if (this.extendValMap.size() != store.extendValMap.size()) {
                return false;
            }
            for (Map.Entry<String, Long> entry : this.extendValMap.entrySet()) {
                if (Objects.equals(entry.getValue(), store.extendValMap.get(entry.getKey()))) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            ArrayList<String> keys = new ArrayList<String>(this.extendValMap.keySet());
            keys.sort(String::compareTo);
            ArrayList<Long> vals = new ArrayList<Long>(keys.size());
            for (String key : keys) {
                vals.add(this.extendValMap.get(key));
            }
            return Objects.hash(this.org, this.material, vals);
        }
    }

    private static class Qty {
        BigDecimal qty;

        Qty() {
            this.qty = BigDecimal.ZERO;
        }

        Qty(BigDecimal qty) {
            this.qty = qty;
        }

        void add(BigDecimal b) {
            this.qty = this.qty.add(b);
        }

        void subtract(BigDecimal b) {
            this.qty = this.qty.subtract(b);
        }

        public String toString() {
            return this.qty.toString();
        }

        public int compare(Qty other) {
            return this.qty.compareTo(other.qty);
        }
    }

    private static class PoQty {
        final Map<String, Qty> map = new LinkedHashMap<String, Qty>(8);
        final Map<String, Qty> oriMap = new LinkedHashMap<String, Qty>(8);
        final Map<String, RequireRowData> billToRowMap;
        final IMRPEnvProvider ctx;
        final Map<String, Set<String>> orgToBills = new HashMap<String, Set<String>>(8);
        final Map<Integer, Boolean> cache;
        final Map<Integer, RowData> requireToSupplyCache;

        protected PoQty(Map<String, RequireRowData> billToRowMap, IMRPEnvProvider ctx, Map<Integer, Boolean> cache, Map<Integer, RowData> requireToSupplyCache) {
            this.billToRowMap = billToRowMap;
            this.ctx = ctx;
            this.cache = cache;
            this.requireToSupplyCache = requireToSupplyCache;
        }

        protected void add(String number, BigDecimal qty) {
            this.map.computeIfAbsent(number, k -> new Qty()).add(qty);
            this.oriMap.computeIfAbsent(number, k -> new Qty()).add(qty);
        }

        protected void add(String number, BigDecimal qty, String org) {
            this.map.computeIfAbsent(number, k -> new Qty()).add(qty);
            this.oriMap.computeIfAbsent(number, k -> new Qty()).add(qty);
            this.orgToBills.computeIfAbsent(org, k -> new HashSet()).add(number);
        }

        protected Map<String, BigDecimal> subtract(BigDecimal qty, RequireRowData requireData) {
            LinkedHashMap<String, BigDecimal> result = new LinkedHashMap<String, BigDecimal>(8);
            Qty left = new Qty(qty);
            Iterator<Map.Entry<String, Qty>> iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Qty> next = iterator.next();
                Qty value = next.getValue();
                RequireRowData require = this.billToRowMap.get(next.getKey());
                if (require == null || this.isNoMatch(requireData, require, this.ctx, next.getKey())) continue;
                if (left.compare(value) > 0) {
                    result.put(next.getKey(), value.qty);
                    left.subtract(value.qty);
                    iterator.remove();
                    continue;
                }
                result.put(next.getKey(), left.qty);
                value.subtract(left.qty);
                break;
            }
            return result;
        }

        boolean isNoMatch(RequireRowData requireData, RequireRowData supplyRequire, IMRPEnvProvider ctx, String billNo) {
            RowData supply = this.requireToSupplyCache.get(supplyRequire.hashCode());
            if (supply == null) {
                RequireRowData clone = supplyRequire.clone();
                clone.update(DefaultField.RequireField.__INVLEVEL_BILLNUMBER__.getName(), (Object)billNo);
                MRPInventoryPlanStep.handlePlanDate(clone, ctx);
                supply = DataMatchUtils.requireToSupply((IMRPEnvProvider)ctx, (RequireRowData)clone);
                this.requireToSupplyCache.put(supplyRequire.hashCode(), supply);
            }
            return !DataBalanceUtil.isMatch((IMRPEnvProvider)ctx, (RequireRowData)requireData, (RowData)supply, (List)ctx.r2s(), (boolean)false, this.cache);
        }

        protected BigDecimal qty(RequireRowData requireData) {
            BigDecimal result = BigDecimal.ZERO;
            for (Map.Entry<String, Qty> next : this.map.entrySet()) {
                Qty qty = next.getValue();
                RequireRowData require = this.billToRowMap.get(next.getKey());
                if (require == null || this.isNoMatch(requireData, require, this.ctx, next.getKey())) continue;
                result = result.add(qty.qty);
            }
            return result;
        }

        protected Map<String, BigDecimal> left() {
            return this._left(this.map);
        }

        protected Map<String, BigDecimal> oriLeft() {
            return this._left(this.oriMap);
        }

        Map<String, BigDecimal> _left(Map<String, Qty> map) {
            LinkedHashMap<String, BigDecimal> result = new LinkedHashMap<String, BigDecimal>(8);
            for (Map.Entry<String, Qty> entry : map.entrySet()) {
                Qty value = entry.getValue();
                if (value.qty.compareTo(BigDecimal.ZERO) <= 0) continue;
                result.put(entry.getKey(), value.qty);
            }
            return result;
        }

        boolean isEmpty() {
            return this.map.isEmpty();
        }
    }

    private static class OccupySupplyStruct {
        PlanTypeCalc planTypeCalc;
        LinkedList<RowData> usableSups;
        BigDecimal remainQty;
        RequireRowData require;

        public OccupySupplyStruct(PlanTypeCalc planTypeCalc, LinkedList<RowData> usableSups, BigDecimal remainQty, RequireRowData require) {
            this.planTypeCalc = planTypeCalc;
            this.usableSups = usableSups;
            this.remainQty = remainQty;
            this.require = require;
        }
    }
}

