/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.calcnode.framework.step;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mmc.mrp.calcnode.framework.step.AbstractMRPSubStep;
import kd.mmc.mrp.calcnode.framework.step.MRPCalQty4SupplyOrg;
import kd.mmc.mrp.calcnode.framework.step.result.MRPDataBalanceResult;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.consts.Tips;
import kd.mmc.mrp.framework.step.IMRPResult;
import kd.mmc.mrp.integrate.entity.ModelUtil;
import kd.mmc.mrp.integrate.entity.PlanModel;
import kd.mmc.mrp.integrate.entity.RequireDataModel;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mmc.mrp.model.enums.strategy.BillSupplyStrategy;
import kd.mmc.mrp.model.enums.strategy.MaterialAttribute;
import kd.mmc.mrp.model.enums.strategy.MaterialPlanMode;
import kd.mmc.mrp.model.enums.strategy.PriorityLevelApplyType;
import kd.mmc.mrp.model.struct.CycleMergeStruct;
import kd.mmc.mrp.model.struct.ReserveData;
import kd.mmc.mrp.model.table.ColumnDatas;
import kd.mmc.mrp.model.table.DataBalanceTable;
import kd.mmc.mrp.model.table.RequireRowData;
import kd.mmc.mrp.model.table.RowData;
import kd.mmc.mrp.model.table.res.RequirementDataTable;
import kd.mmc.mrp.model.table.res.SupplymentDataTable;
import kd.mmc.mrp.model.table.utils.DataBalanceUtil;
import kd.mmc.mrp.model.table.utils.DataMatchUtils;
import kd.mmc.mrp.model.table.utils.InvPlanUtil;
import kd.mmc.mrp.mservice.batchpolicy.BatchCalcService;
import kd.mmc.mrp.mservice.batchpolicy.DirectLotBatchService;
import kd.mmc.mrp.mservice.batchpolicy.FixedBatchService;
import kd.mmc.mrp.utils.MRPUtil;
import kd.mmc.mrp.utils.QuotaAllocationUtil;
import kd.mmc.mrp.vo.MergeCycleVo;

public class MRPMDataBalanceStep
extends AbstractMRPSubStep {
    private static Log logger = LogFactory.getLog(MRPMDataBalanceStep.class);
    protected List<RequireRowData> collaborates = new ArrayList<RequireRowData>(7);
    protected List<RequireRowData> internalNetDemands = new ArrayList<RequireRowData>(7);
    protected List<RequireRowData> invInnerTransferDemands = new ArrayList<RequireRowData>(7);
    protected TreeMap<String, List<Integer>> sorted = new TreeMap();
    protected boolean isReplaceBalance = false;
    protected boolean isNullValueMatch = false;
    protected Map<String, BigDecimal> poNum2RequireQty;
    protected Map<String, Map<String, BigDecimal>> supplyOccupyQty;
    protected boolean lessOrEqualRestock = true;
    protected CycleMergeStruct batchCycleMergeStruct = new CycleMergeStruct();
    protected Map<String, Map<String, BigDecimal>> historySupplierQty = new HashMap<String, Map<String, BigDecimal>>(2);

    public MRPMDataBalanceStep(IMRPEnvProvider ctx) {
        super(ctx);
    }

    public MRPMDataBalanceStep(IMRPEnvProvider ctx, boolean isReplaceBalance) {
        super(ctx);
        this.isReplaceBalance = isReplaceBalance;
    }

    @Override
    protected IMRPResult executeImpl() {
        String inv_plan_calc_settings = (String)this.ctx.getCfgValue(EnvCfgItem.INV_PLAN_CALC_SETTINGS);
        if (StringUtils.equalsIgnoreCase((CharSequence)"EXCLUDE_ROP", (CharSequence)inv_plan_calc_settings)) {
            this.lessOrEqualRestock = false;
        }
        this.poNum2RequireQty = this.ctx.getPoNum2InvRequireQty();
        this.supplyOccupyQty = this.ctx.getSupplyOccupyQty();
        RequirePriorityLevelModel requirePriorityLevelModel = this.getRequirePriorityLevelCol();
        this.cycleOccupy(requirePriorityLevelModel.getPriorityIter(), requirePriorityLevelModel.getrCol());
        MRPCalQty4SupplyOrg mrpCalQty4SupplyOrg = new MRPCalQty4SupplyOrg(this.ctx);
        this.collaborates.addAll(this.handleInnerGross(this.ctx, this.internalNetDemands, mrpCalQty4SupplyOrg));
        this.resolveInnerTransfer();
        this.collaborates.addAll(this.invInnerTransferDemands);
        this.ctx.putLocalParam("kd.mmc.mrp.model.table.utils.DataBalanceUtil.getSupplyPlanScope", null);
        this.ctx.putLocalParam("kd.mmc.mrp.model.table.utils.DataMatchUtils.findSupplysUtilImpl", null);
        return new MRPDataBalanceResult(this.collaborates);
    }

    protected List<RequireRowData> handleInnerGross(IMRPEnvProvider ctx, List<RequireRowData> internalNetDemands, MRPCalQty4SupplyOrg mrpCalQty4SupplyOrg) {
        ArrayList<RequireRowData> collaborates = new ArrayList<RequireRowData>(internalNetDemands.size());
        collaborates.addAll(internalNetDemands);
        for (RequireRowData requireData : internalNetDemands) {
            requireData.update(DefaultField.RequireField.SUPPLYORGUNIT.getName(), null);
            requireData.update(DefaultField.RequireField.__IS_INTERNAL_GROSS_DEMAND__.getName(), null);
            List<RequireRowData> result = mrpCalQty4SupplyOrg.splitRequireBySupplyNet(ctx, ctx.requireDatas(), requireData, false);
            collaborates.addAll(result);
        }
        return collaborates;
    }

    protected RequirePriorityLevelModel getRequirePriorityLevelCol() {
        Iterator priorityIter;
        ColumnDatas rCol;
        PriorityLevelApplyType plat = this.ctx.getPriorityLevelApplyType();
        RequirementDataTable requireTbl = this.ctx.requireDatas();
        if (PriorityLevelApplyType.DYNAMIC == plat) {
            rCol = requireTbl.getCol(DefaultField.RequireField.__PRIORITY_LEVEL__.name());
            priorityIter = rCol.descendingIterator();
        } else {
            if ("SURPLUS_ADJUST".equals(this.ctx.getCfgValue(EnvCfgItem.MRP_BALANCE_TYPE))) {
                ArrayList<Integer> requireRowIdxs = new ArrayList<Integer>(requireTbl.size());
                for (int i = 0; i < requireTbl.size(); ++i) {
                    requireRowIdxs.add(i);
                }
                this.samePeriodOccupy(requireRowIdxs);
            }
            rCol = requireTbl.getCol(DefaultField.RequireField.DATE.getName());
            priorityIter = rCol.ascendingIterator();
        }
        return new RequirePriorityLevelModel(rCol, priorityIter);
    }

    protected void cycleOccupy(Iterator<Comparable<?>> priorityIter, ColumnDatas rCol) {
        PlanModel pm;
        long redisAccTime = 0L;
        StringBuilder key = new StringBuilder();
        RequirementDataTable requireTbl = this.ctx.requireDatas();
        ArrayList requires = new ArrayList();
        while (priorityIter.hasNext()) {
            requires.add(priorityIter.next());
        }
        boolean isFirstCalc = "1".equals(this.ctx.getLocalParams("__IS_FIRST_DATA_BALANCE__"));
        if (!this.ctx.getInvPlanKey2Require().isEmpty() && isFirstCalc) {
            ArrayList<Integer> requireRowIdxs = new ArrayList<Integer>(this.ctx.getInvPlanKey2Require().size());
            for (RequireRowData require : this.ctx.getInvPlanKey2Require().values()) {
                requireRowIdxs.add(require.getRowIdx());
            }
            this.modifyOccupy(this.samePeriodOccupy(requireRowIdxs));
        }
        boolean isInvPlan = (pm = (PlanModel)this.ctx.getService(PlanModel.class)).isReorderPoint() || pm.isMaxMinInventory();
        this.batchCycleMergeStruct.clear();
        boolean isbatchpolicy = (Boolean)pm.getPlanDataByParam("isbatchpolicy", (Object)true);
        for (Comparable comparable : requires) {
            long start = System.currentTimeMillis();
            this.ctx.testEnvStatus();
            redisAccTime += System.currentTimeMillis() - start;
            List requireRowIdxs = rCol.get((Object)comparable);
            this.sorted.clear();
            for (Integer rowIdx : requireRowIdxs) {
                boolean is_inv_water_level = MRPUtil.convert((Object)requireTbl.getValue(DefaultField.RequireField.IS_INV_WATER_LEVEL.getName(), rowIdx.intValue()), (Boolean)Boolean.FALSE);
                if (requireTbl.isLock(rowIdx) || is_inv_water_level) continue;
                RequireRowData require = requireTbl.fetchRow(rowIdx.intValue());
                boolean isNewInvRequire = InvPlanUtil.isNewInvRequire((IMRPEnvProvider)this.ctx, (RequireRowData)require);
                if (isInvPlan && isNewInvRequire) {
                    String batchpolicy = require.getString(DefaultField.RequireField.BATCHPOLICY.getName());
                    boolean ispurquota = this.isPurchaseQuota(require);
                    if ("C".equals(batchpolicy) && (ispurquota || isbatchpolicy)) {
                        this.initCycleRequires(this.batchCycleMergeStruct, require);
                        continue;
                    }
                }
                key.setLength(0);
                Long date = (Long)MRPUtil.convert((Object)requireTbl.getValue(DefaultField.RequireField.DATE.getName(), rowIdx.intValue()), (Object)System.currentTimeMillis());
                Object qty = requireTbl.getValue(DefaultField.RequireField.QTY.getName(), rowIdx.intValue());
                Object entryId = requireTbl.getValue(DefaultField.RequireField.BILLENTRYID.getName(), rowIdx.intValue());
                Object billId = requireTbl.getValue(DefaultField.RequireField.BILLID.getName(), rowIdx.intValue());
                key.append(date).append('-').append(qty).append("-").append(entryId).append('-').append(billId);
                List<Integer> rows = this.sorted.get(key.toString());
                if (rows == null) {
                    rows = new ArrayList<Integer>();
                    this.sorted.put(key.toString(), rows);
                }
                rows.add(rowIdx);
            }
            requireRowIdxs.clear();
            Iterator<String> iter = this.sorted.descendingKeySet().descendingIterator();
            while (iter.hasNext()) {
                List<Integer> rows = this.sorted.get(iter.next());
                Collections.sort(rows);
                requireRowIdxs.addAll(rows);
            }
            this.sorted.clear();
            this.modifyOccupy(this.samePeriodOccupy(requireRowIdxs));
        }
        this.invPlanCycleMergeRequireCalc(this.ctx, this.batchCycleMergeStruct);
        if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
            logger.warn(String.format("ctxid: %s, mrprunner-mrpmdatabalance-cacheacctime timecost: %s(ms)", this.ctx.getMRPContextId(), redisAccTime));
        }
    }

    private void invPlanCycleMergeRequireCalc(IMRPEnvProvider ctx, CycleMergeStruct batchCycleMergeStruct) {
        RequireRowData require;
        for (Map.Entry specialentry : batchCycleMergeStruct.getSpecialRequires().entrySet()) {
            List specialList = (List)specialentry.getValue();
            require = ctx.requireDatas().fetchRow(((Integer)specialList.get(0)).intValue());
            long specialperiod = require.getLong(DefaultField.RequireField.SPECIFIEDPERIOD.getName()) == null ? 0L : require.getLong(DefaultField.RequireField.SPECIFIEDPERIOD.getName());
            this.dealSpecialCycles(ctx, specialList, (Long)specialentry.getKey(), specialperiod);
        }
        for (Map.Entry dynamicentry : batchCycleMergeStruct.getDynamicRequires().entrySet()) {
            List dynamicList = (List)dynamicentry.getValue();
            require = ctx.requireDatas().fetchRow(((Integer)dynamicList.get(0)).intValue());
            Integer dynamicperiod = require.getInteger(DefaultField.RequireField.DYNAMICCYCLE.getName()) == null ? Integer.valueOf(0) : require.getInteger(DefaultField.RequireField.DYNAMICCYCLE.getName());
            this.dealDynamicCycles(ctx, dynamicList, (Long)dynamicentry.getKey(), dynamicperiod);
        }
        for (Map.Entry fixedEntry : batchCycleMergeStruct.getFixedRequires().entrySet()) {
            List fixedList = (List)fixedEntry.getValue();
            require = ctx.requireDatas().fetchRow(((Integer)fixedList.get(0)).intValue());
            Integer fixedperiod = require.getInteger(DefaultField.RequireField.FIXEDPERIOD.getName()) == null ? Integer.valueOf(0) : require.getInteger(DefaultField.RequireField.FIXEDPERIOD.getName());
            this.dealFixedCycles(ctx, fixedList, (Long)fixedEntry.getKey(), fixedperiod);
        }
    }

    private void dealSpecialCycles(IMRPEnvProvider ctx, List<Integer> specialList, Long mpId, Long specialperiod) {
        this.sortRequire(ctx, specialList);
        LinkedHashMap<Long, List<Integer>> cycleDate2Require = new LinkedHashMap<Long, List<Integer>>();
        List cycleList = MRPUtil.getMergeCycleVos((IMRPEnvProvider)ctx, (long)specialperiod);
        Iterator cycleIts = cycleList.iterator();
        Date nxdate = null;
        MergeCycleVo cycleVo = null;
        Date mergeDate = null;
        for (Integer idx : specialList) {
            RequireRowData requireRowData = ctx.requireDatas().fetchRow(idx.intValue());
            nxdate = new Date((Long)MRPUtil.convert((Object)requireRowData.getValue(DefaultField.RequireField.__ORIGIN_DEMAND_DATE__.getName()), (Object)0L));
            if (cycleVo == null && cycleIts.hasNext()) {
                cycleVo = (MergeCycleVo)cycleIts.next();
            }
            if (cycleVo != null) {
                while (nxdate.compareTo(cycleVo.getEndDate()) > 0 && cycleIts.hasNext()) {
                    cycleVo = (MergeCycleVo)cycleIts.next();
                }
                mergeDate = nxdate.compareTo(cycleVo.getStartDate()) >= 0 && nxdate.compareTo(cycleVo.getEndDate()) <= 0 ? cycleVo.getMergeDate() : nxdate;
            } else {
                mergeDate = nxdate;
            }
            List list = cycleDate2Require.computeIfAbsent(mergeDate.getTime(), k -> new ArrayList(2));
            list.add(idx);
        }
        this.dealCycleRequires(cycleDate2Require, mpId);
    }

    private void dealDynamicCycles(IMRPEnvProvider ctx, List<Integer> dynamicList, Long mpId, Integer dynamicperiod) {
        this.sortRequire(ctx, dynamicList);
        LinkedHashMap<Long, List<Integer>> cycleDate2Require = new LinkedHashMap<Long, List<Integer>>();
        Date nxdate = null;
        ArrayList<Long> dateSet = new ArrayList<Long>(2);
        for (Integer idx : dynamicList) {
            RequireRowData requireRowData = ctx.requireDatas().fetchRow(idx.intValue());
            nxdate = new Date((Long)MRPUtil.convert((Object)requireRowData.getValue(DefaultField.RequireField.__ORIGIN_DEMAND_DATE__.getName()), (Object)0L));
            if (dateSet.isEmpty() || !((Long)dateSet.get(dateSet.size() - 1)).equals(nxdate.getTime())) {
                dateSet.add(nxdate.getTime());
            }
            int i = (dateSet.size() - 1) % dynamicperiod;
            List list = cycleDate2Require.computeIfAbsent((Long)dateSet.get(dateSet.size() - 1 - i), (Function<Long, List<Integer>>)((Function<Long, List>)k -> new ArrayList(2)));
            list.add(idx);
        }
        this.dealCycleRequires(cycleDate2Require, mpId);
    }

    private void dealFixedCycles(IMRPEnvProvider ctx, List<Integer> fixedList, Long mpId, Integer fixedperiod) {
        this.sortRequire(ctx, fixedList);
        Date startDate = null;
        Date nxdate = null;
        Date endDate = null;
        LinkedHashMap<Long, List<Integer>> cycleDate2Require = new LinkedHashMap<Long, List<Integer>>();
        for (Integer idx : fixedList) {
            RequireRowData requireRowData = ctx.requireDatas().fetchRow(idx.intValue());
            if (startDate == null) {
                startDate = new Date((Long)MRPUtil.convert((Object)requireRowData.getValue(DefaultField.RequireField.__ORIGIN_DEMAND_DATE__.getName()), (Object)0L));
            }
            nxdate = new Date((Long)MRPUtil.convert((Object)requireRowData.getValue(DefaultField.RequireField.__ORIGIN_DEMAND_DATE__.getName()), (Object)0L));
            endDate = MRPUtil.addDays((Date)startDate, (int)fixedperiod);
            while (nxdate.compareTo(endDate) >= 0) {
                startDate = MRPUtil.addDays((Date)startDate, (int)fixedperiod);
                endDate = MRPUtil.addDays((Date)startDate, (int)fixedperiod);
            }
            List requires = cycleDate2Require.computeIfAbsent(startDate.getTime(), k -> new ArrayList(7));
            requires.add(idx);
        }
        this.dealCycleRequires(cycleDate2Require, mpId);
    }

    /*
     * WARNING - void declaration
     */
    private void dealCycleRequires(Map<Long, List<Integer>> cycleDate2Require, Long mpId) {
        for (Map.Entry<Long, List<Integer>> entry : cycleDate2Require.entrySet()) {
            Long dateTime = entry.getKey();
            this.modifyOccupy(this.samePeriodOccupy(entry.getValue()));
            Map idx2mergeRequires = this.batchCycleMergeStruct.getRequireByMpId(mpId);
            Map idx2SupplyRemainQty = this.batchCycleMergeStruct.getSupplyRemainQtyByMpId(mpId);
            if (idx2mergeRequires == null || idx2mergeRequires.isEmpty()) continue;
            for (Map.Entry mergeEntry : idx2mergeRequires.entrySet()) {
                List requires = (List)mergeEntry.getValue();
                BigDecimal rQty = BigDecimal.ZERO;
                for (RequireRowData require : requires) {
                    if (require.isBalanced()) continue;
                    rQty = rQty.add(require.getNewQrequireQty());
                }
                Map supplyIdx2remainQty = idx2SupplyRemainQty.getOrDefault(mergeEntry.getKey(), new HashMap(0));
                PlanTypeCalc planTypeCalc = this.getPlanTypeCalc((RequireRowData)requires.get(0), this.ctx);
                ArrayList<RowData> newSupplys = new ArrayList<RowData>(1);
                if (planTypeCalc != null) {
                    BigDecimal remainQty = BigDecimal.ZERO;
                    for (Map.Entry entry2 : supplyIdx2remainQty.entrySet()) {
                        RowData supply = this.ctx.supplyDatas().fetchRow(((Integer)entry2.getKey()).intValue());
                        BigDecimal sQty = (BigDecimal)MRPUtil.convert((Object)supply.getValue(DefaultField.SupplyField.QTY.getName()), (Object)BigDecimal.ZERO);
                        if (MRPUtil.convert((Object)supply.getValue(DefaultField.SupplyField.__IS_OCCUPIED__.getName()), (Boolean)Boolean.FALSE).booleanValue()) {
                            sQty = BigDecimal.ZERO;
                        }
                        if (sQty.compareTo((BigDecimal)entry2.getValue()) < 0) {
                            entry2.setValue(sQty);
                            remainQty = remainQty.add(sQty);
                            continue;
                        }
                        remainQty = remainQty.add((BigDecimal)entry2.getValue());
                    }
                    BatchCalcService batchCalcService = this.getBatchCalcService((RequireRowData)requires.get(0));
                    this.invPlanRequireOccupySupply(planTypeCalc, batchCalcService, (RequireRowData)requires.get(0), supplyIdx2remainQty);
                    BigDecimal bigDecimal = planTypeCalc.getPlanOrderQty(rQty, remainQty);
                    if (bigDecimal != null && (bigDecimal.compareTo(BigDecimal.ZERO) > 0 || bigDecimal.compareTo(BigDecimal.ZERO) == 0 && !planTypeCalc.isEnough(remainQty))) {
                        InvPlanBalanceParam invPlanBalanceParam = new InvPlanBalanceParam(batchCalcService, planTypeCalc, newSupplys);
                        invPlanBalanceParam.setOrigRequireNotOccupy(true);
                        invPlanBalanceParam.setRemainQty(remainQty);
                        invPlanBalanceParam.setSumSQty(remainQty);
                        invPlanBalanceParam.setSurplus(true);
                        invPlanBalanceParam.setDateTime(MRPUtil.getNetRequireDateTimeByCalendar((IMRPEnvProvider)this.ctx, (Long)dateTime, (RequireRowData)((RequireRowData)requires.get(0))));
                        this.invLevelRequireQuotaAndBatchCalc((RequireRowData)requires.get(0), bigDecimal, rQty, invPlanBalanceParam);
                    }
                }
                for (RequireRowData require : requires) {
                    if (!require.isBalanced()) {
                        BigDecimal bigDecimal = require.getNewQrequireQty();
                        for (RowData supply : newSupplys) {
                            void var17_22;
                            if (var17_22.compareTo(BigDecimal.ZERO) <= 0) break;
                            BigDecimal sQty = (BigDecimal)MRPUtil.convert((Object)supply.getValue(DefaultField.SupplyField.QTY.getName()), (Object)BigDecimal.ZERO);
                            if (sQty.compareTo((BigDecimal)var17_22) <= 0) {
                                BigDecimal bigDecimal2 = var17_22.subtract(sQty);
                                require.getOccupys().add(supply.getRowIdx());
                                this.deductRemainPoQty(sQty, supply);
                                continue;
                            }
                            RowData split = this.ctx.supplyDatas().split(supply, (BigDecimal)var17_22, this.ctx);
                            split = this.ctx.supplyDatas().fetchRow(this.ctx.supplyDatas().fill(split));
                            require.getOccupys().add(split.getRowIdx());
                            this.deductRemainPoQty((BigDecimal)var17_22, split);
                            break;
                        }
                        this.ctx.supplyDatas().lock((Collection)require.getOccupys(), require.getRowIdx());
                    }
                    this.addMapping(this.ctx.calcBalanceDetails(), require, this.ctx.supplyDatas().fetchRow((Collection)require.getOccupys(), true), DataBalanceTable.MatchType.EQUAL);
                }
            }
            idx2mergeRequires.clear();
            idx2SupplyRemainQty.clear();
        }
    }

    protected void deductRemainPoQty(BigDecimal qty, RowData supply) {
        String key;
        BigDecimal reqQty;
        if (qty.compareTo(BigDecimal.ZERO) > 0 && (reqQty = this.poNum2RequireQty.get(key = String.format("%s\u0001%s", supply.getString(DefaultField.SupplyField.BILL_ENTITY.getName()), supply.getString(DefaultField.SupplyField.BILLNUMBER.getName())))) != null) {
            this.poNum2RequireQty.put(key, reqQty.subtract(qty));
        }
    }

    protected void invLevelRequireQuotaAndBatchCalc(RequireRowData requireData, BigDecimal invQty, BigDecimal rQty, InvPlanBalanceParam invPlanBalanceParam) {
        if (invQty.compareTo(BigDecimal.ZERO) <= 0) {
            List<BigDecimal> qtys = this.calcBatchQty(requireData, invPlanBalanceParam, invQty);
            invQty = BigDecimal.ZERO;
            for (BigDecimal bigDecimal : qtys) {
                invQty = invQty.add(bigDecimal);
            }
        }
        Map<Long, BigDecimal> supplierMap = this.calcSupplierQty(requireData, invQty);
        for (Map.Entry entry : supplierMap.entrySet()) {
            Long supplier = (Long)entry.getKey();
            List<BigDecimal> qtys = this.calcBatchQty(requireData, invPlanBalanceParam, (BigDecimal)entry.getValue());
            Long date = invPlanBalanceParam.getDateTime();
            int intervalperiod = MRPUtil.getIntervalperiod((RequireRowData)requireData);
            for (BigDecimal planOrderQty : qtys) {
                if (planOrderQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                RequireRowData newData = this.createInvPlanNewRequire(requireData, planOrderQty, supplier, date);
                date = MRPUtil.addDays((Date)new Date(date), (int)intervalperiod).getTime();
                date = MRPUtil.getNetRequireDateTimeByCalendar((IMRPEnvProvider)this.ctx, (Long)date, (RequireRowData)requireData);
                if (this.isFabricatedpart(newData)) {
                    rQty = this.invPlanInnerCopRequireBalance(this.ctx, newData, rQty, requireData, invPlanBalanceParam);
                    continue;
                }
                rQty = this.invPlanPlanOrderBalance(this.ctx, newData, rQty, requireData, invPlanBalanceParam);
            }
        }
    }

    protected BigDecimal invPlanInnerCopRequireBalance(IMRPEnvProvider ctx, RequireRowData newData, BigDecimal rQty, RequireRowData requireData, InvPlanBalanceParam invPlanBalanceParam) {
        SupplymentDataTable supplyTbl = ctx.supplyDatas();
        boolean isGross = MRPUtil.convert((Object)newData.getValue(DefaultField.RequireField.__IS_INTERNAL_GROSS_DEMAND__.getName()), (Boolean)Boolean.FALSE);
        ArrayList<RequireRowData> current = new ArrayList<RequireRowData>();
        if (isGross) {
            MRPCalQty4SupplyOrg mrpCalQty4SupplyOrg = new MRPCalQty4SupplyOrg(ctx);
            current.addAll(this.handleInnerGross(ctx, Collections.singletonList(newData), mrpCalQty4SupplyOrg));
        } else {
            current.add(newData);
        }
        List<RequireRowData> inventoryRequire = this.removeInventoryRequire(current, ctx.getRequirorgs(), ctx.calcBalanceDetails(), false);
        for (RequireRowData req : inventoryRequire) {
            rQty = this.invPlanPlanOrderBalance(ctx, req, rQty, requireData, invPlanBalanceParam);
        }
        if (current.isEmpty()) {
            return rQty;
        }
        BigDecimal origQty = BigDecimal.ZERO;
        List<RowData[]> list = this.createCollaborateSupply(current);
        HashSet requireOrgs = ctx.getRequirorgs();
        LinkedHashMap require2Supplys = new LinkedHashMap(list.size());
        for (RowData[] rowDataArray : list) {
            RowData supply = rowDataArray[1];
            newData = (RequireRowData)rowDataArray[0];
            BigDecimal planOrderQty = newData.getBigDecimal(DefaultField.RequireField.QTY.getName());
            supply = supplyTbl.fetchRow(supplyTbl.fill(supply));
            supplyTbl.unlock(Collections.singleton(supply.getRowIdx()));
            String supplyOrgId = String.valueOf(newData.getValue(DefaultField.RequireField.SUPPLYORGUNIT.getName()));
            Object originRequireOrg = newData.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName());
            RequireRowData transfer = newData.clone();
            if (MRPUtil.transferRequire((HashSet)requireOrgs, (Object)originRequireOrg, (String)supplyOrgId, (RowData)supply, (RequireRowData)newData, (RequireRowData)transfer, (DataBalanceTable)ctx.calcBalanceDetails())) {
                this.invInnerTransferDemands.add(transfer);
            }
            if (!invPlanBalanceParam.isOrigRequireNotOccupy()) {
                BigDecimal[] bigDecimals = this.invRequireOccupyNewCreateSupply(ctx, rQty, invPlanBalanceParam.getSumSQty(), planOrderQty, requireData, supply, invPlanBalanceParam.isSurplus());
                planOrderQty = bigDecimals[0];
                rQty = bigDecimals[1];
            }
            if (planOrderQty.compareTo(BigDecimal.ZERO) <= 0) continue;
            origQty = origQty.add(planOrderQty);
            ArrayList<RowData> occupys = new ArrayList<RowData>(1);
            occupys.add(supply.clone());
            newData.update(DefaultField.RequireField.QTY.getName(), (Object)planOrderQty);
            require2Supplys.put(newData, occupys);
            String key = String.format("%s\u0001%s", supply.getString(DefaultField.SupplyField.BILL_ENTITY.getName()), supply.getString(DefaultField.SupplyField.BILLNUMBER.getName()));
            this.poNum2RequireQty.put(key, planOrderQty);
            invPlanBalanceParam.getNewSupplys().add(supply);
        }
        if (origQty.compareTo(BigDecimal.ZERO) > 0) {
            for (Map.Entry entry : require2Supplys.entrySet()) {
                if (ctx.calcBalanceDetails().getMappingByRequireRowIdx(((RequireRowData)entry.getKey()).getRowIdx().intValue()) == null) {
                    ((RequireRowData)entry.getKey()).update(DefaultField.RequireField.QTY.getName(), (Object)origQty);
                }
                ctx.calcBalanceDetails().addMapping((RequireRowData)entry.getKey(), (List)entry.getValue(), DataBalanceTable.MatchType.EQUAL);
            }
        }
        return rQty;
    }

    protected BigDecimal invPlanPlanOrderBalance(IMRPEnvProvider ctx, RequireRowData newData, BigDecimal rQty, RequireRowData requireData, InvPlanBalanceParam invPlanBalanceParam) {
        SupplymentDataTable supplyTbl = ctx.supplyDatas();
        BigDecimal planOrderQty = (BigDecimal)MRPUtil.convert((Object)newData.getValue(DefaultField.RequireField.QTY.getName()), (Object)BigDecimal.ZERO);
        RowData supply = this.getPlanOrderSupply(ctx, newData, planOrderQty);
        supply.update(DefaultField.SupplyField.ORIGINQTY.getName(), supply.getValue(DefaultField.SupplyField.QTY.getName()));
        supply.update(DefaultField.SupplyField.QTY.getName(), (Object)planOrderQty);
        supply = supplyTbl.fetchRow(supplyTbl.fill(supply));
        newData.update(DefaultField.RequireField.__INVLEVEL_BILLNUMBER__.getName(), supply.getValue(DefaultField.SupplyField.BILLNUMBER.getName()));
        newData.update(DefaultField.RequireField.__PO_ID__.getName(), supply.getValue(DefaultField.SupplyField.BILLID.getName()));
        ctx.calcBalanceDetails().addMapping(newData, supplyTbl.fetchRow((Collection)newData.getOccupys(), true), DataBalanceTable.MatchType.LESS);
        if (!invPlanBalanceParam.isOrigRequireNotOccupy()) {
            BigDecimal[] bigDecimals = this.invRequireOccupyNewCreateSupply(ctx, rQty, invPlanBalanceParam.getSumSQty(), planOrderQty, requireData, supply, invPlanBalanceParam.isSurplus());
            planOrderQty = bigDecimals[0];
            rQty = bigDecimals[1];
        }
        if (planOrderQty.compareTo(BigDecimal.ZERO) > 0) {
            String key = String.format("%s\u0001%s", supply.getString(DefaultField.SupplyField.BILL_ENTITY.getName()), supply.getString(DefaultField.SupplyField.BILLNUMBER.getName()));
            this.poNum2RequireQty.put(key, planOrderQty);
            invPlanBalanceParam.getNewSupplys().add(supply);
        }
        return rQty;
    }

    private BigDecimal[] invRequireOccupyNewCreateSupply(IMRPEnvProvider ctx, BigDecimal rQty, BigDecimal sumSQty, BigDecimal planOrderQty, RequireRowData requireData, RowData supply, boolean isSurplus) {
        BigDecimal newRQty = rQty.subtract(sumSQty);
        if (!isSurplus && newRQty.compareTo(BigDecimal.ZERO) > 0) {
            if (planOrderQty.compareTo(newRQty) <= 0) {
                requireData.getOccupys().add(supply.getRowIdx());
                rQty = rQty.subtract(planOrderQty);
            } else {
                RowData splitCopy = ctx.supplyDatas().split(supply, newRQty, ctx);
                requireData.getOccupys().add(ctx.supplyDatas().fill(splitCopy));
                rQty = rQty.subtract(newRQty);
            }
            planOrderQty = planOrderQty.subtract(newRQty);
        }
        return new BigDecimal[]{planOrderQty, rQty};
    }

    private RowData getPlanOrderSupply(IMRPEnvProvider ctx, RequireRowData require, BigDecimal qty) {
        require = require.clone();
        Long date = (Long)MRPUtil.convert((Object)require.getValue(DefaultField.RequireField.DATE.getName()), (Object)System.currentTimeMillis());
        date = MRPUtil.getNetRequireDateTimeByCalendar((IMRPEnvProvider)ctx, (Long)date, (RequireRowData)require);
        require.update(DefaultField.RequireField.DATE.getName(), (Object)date);
        MRPUtil.calcDate((RequireRowData)require, (BigDecimal)qty, (IMRPEnvProvider)ctx);
        return DataMatchUtils.requireToSupply((IMRPEnvProvider)ctx, (RequireRowData)require, (BigDecimal)qty);
    }

    protected RequireRowData createInvPlanNewRequire(RequireRowData requireData, BigDecimal planOrderQty, Long supplier, Long date) {
        RequireRowData newData = requireData.clone();
        newData.setNewQrequireQty(planOrderQty);
        InvPlanUtil.updateInvRequireFieldsByMPlan((IMRPEnvProvider)this.ctx, (RequireRowData)newData);
        newData.update(DefaultField.RequireField.QTY.getName(), (Object)planOrderQty);
        newData.update(DefaultField.RequireField.__INVLEVEL_REQUIRE__.getName(), (Object)Boolean.TRUE);
        if (supplier > 0L) {
            newData.update(DefaultField.RequireField.__QUOTA_SUPPLIER__.getName(), (Object)supplier);
        }
        if (date > 0L) {
            newData.update(DefaultField.RequireField.DATE.getName(), (Object)date);
        }
        newData = this.ctx.requireDatas().fetchRow(this.ctx.requireDatas().fill((RowData)newData));
        this.ctx.requireDatas().lock(newData.getRowIdx());
        return newData;
    }

    private void sortRequire(IMRPEnvProvider ctx, List<Integer> requireList) {
        requireList.sort((o1, o2) -> {
            long var1date = (Long)MRPUtil.convert((Object)ctx.requireDatas().getValue(DefaultField.RequireField.__ORIGIN_DEMAND_DATE__.getName(), o1.intValue()), (Object)ctx.getPlanDate().getTime());
            long var2date = (Long)MRPUtil.convert((Object)ctx.requireDatas().getValue(DefaultField.RequireField.__ORIGIN_DEMAND_DATE__.getName(), o2.intValue()), (Object)ctx.getPlanDate().getTime());
            Date v1Date = new Date(var1date);
            Date v2Date = new Date(var2date);
            return v1Date.compareTo(v2Date);
        });
    }

    protected boolean isPurchaseQuota(RequireRowData require) {
        return QuotaAllocationUtil.isPurchaseQuota((IMRPEnvProvider)this.ctx, (RequireRowData)require);
    }

    protected Map<Long, BigDecimal> getSupplierRatio(RequireRowData require, BigDecimal rQty) {
        return QuotaAllocationUtil.getSupplierRatio((IMRPEnvProvider)this.ctx, (RequireRowData)require, (BigDecimal)rQty, this.historySupplierQty);
    }

    protected BatchCalcService getBatchCalcService(RequireRowData require) {
        String batchpolicy = require.getString(DefaultField.RequireField.BATCHPOLICY.getName());
        if ("A".equals(batchpolicy) || "C".equals(batchpolicy)) {
            return new DirectLotBatchService(this.ctx);
        }
        if ("B".equals(batchpolicy)) {
            return new FixedBatchService(this.ctx);
        }
        return new BatchCalcService(this.ctx);
    }

    protected void invPlanRequireOccupySupply(PlanTypeCalc planTypeCalc, BatchCalcService batchCalcService, RequireRowData requireData, Map<Integer, BigDecimal> supplyIdx2remainQty) {
        Map.Entry<Integer, BigDecimal> entry;
        RowData supply;
        boolean isPoSup;
        PlanModel planModel = (PlanModel)this.ctx.getService(PlanModel.class);
        SupplymentDataTable supplyTbl = this.ctx.supplyDatas();
        BigDecimal remainQty = planTypeCalc.getRemainSupplyOccupyQty(batchCalcService, requireData);
        String key = InvPlanUtil.getEmptyRequireKey((RequireRowData)requireData, (boolean)planModel.isEnablePlanScope());
        HashMap<String, BigDecimal> supply2Qty = new HashMap<String, BigDecimal>(supplyIdx2remainQty.size());
        Iterator<Map.Entry<Integer, BigDecimal>> iterator = supplyIdx2remainQty.entrySet().iterator();
        while (iterator.hasNext() && ((isPoSup = InvPlanUtil.isNewCreateSupplyBill((IMRPEnvProvider)this.ctx, (RowData)(supply = supplyTbl.fetchRow((entry = iterator.next()).getKey().intValue())))) || (remainQty = this.invPlanOccupySupply(remainQty, entry.getValue(), entry.getKey(), supply2Qty, key)).compareTo(BigDecimal.ZERO) > 0)) {
        }
        this.supplyOccupyQty.put(key, supply2Qty);
    }

    protected BigDecimal invPlanOccupySupply(BigDecimal remainQty, BigDecimal vQty, int idx, Map<String, BigDecimal> supply2Qty, String key) {
        if (remainQty.compareTo(BigDecimal.ZERO) <= 0) {
            return remainQty;
        }
        RowData supply = this.ctx.supplyDatas().fetchRow(idx);
        remainQty = remainQty.subtract(vQty);
        String supplyKey = String.format("%s-%s", supply.getValue(DefaultField.SupplyField.BILLID.getName()), supply.getValue(DefaultField.SupplyField.BILLENTRYID.getName()));
        BigDecimal sQty = remainQty.compareTo(BigDecimal.ZERO) >= 0 ? vQty : remainQty.add(vQty);
        supply2Qty.put(supplyKey, supply2Qty.getOrDefault(supplyKey, BigDecimal.ZERO).add(sQty));
        this.ctx.supplyDatas().updateValue(DefaultField.SupplyField._IS_INV_LEVEL_OCCUPIED_.getName(), Integer.valueOf(idx), (Object)Boolean.TRUE);
        this.ctx.supplyDatas().updateValue(DefaultField.SupplyField.__INV_REQUIRE_KEY_.getName(), Integer.valueOf(idx), (Object)key);
        return remainQty;
    }

    protected Map<Long, BigDecimal> calcSupplierQty(RequireRowData requireData, BigDecimal invQty) {
        boolean isPurchaseQuota = this.isPurchaseQuota(requireData);
        HashMap<Long, BigDecimal> supplierMap = new HashMap<Long, BigDecimal>(2);
        if (isPurchaseQuota) {
            while (invQty.compareTo(BigDecimal.ZERO) > 0) {
                Map<Long, BigDecimal> ratioMap = this.getSupplierRatio(requireData, invQty);
                for (Map.Entry<Long, BigDecimal> entry : ratioMap.entrySet()) {
                    supplierMap.put(entry.getKey(), supplierMap.getOrDefault(entry.getKey(), BigDecimal.ZERO).add(entry.getValue()));
                    invQty = invQty.subtract(entry.getValue());
                }
                if (!supplierMap.isEmpty()) continue;
                break;
            }
        }
        if (supplierMap.isEmpty()) {
            supplierMap.put(0L, invQty);
        }
        return supplierMap;
    }

    protected List<BigDecimal> calcBatchQty(RequireRowData requireData, InvPlanBalanceParam invPlanBalanceParam, BigDecimal qty) {
        List qtys = invPlanBalanceParam.getBatchCalcService().calcBatch(qty, requireData);
        BigDecimal batchQty = invPlanBalanceParam.getBatchCalcService().calcBatchNoSplit(BigDecimal.ZERO, requireData);
        if (batchQty.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal all = invPlanBalanceParam.getRemainQty();
            for (BigDecimal q : qtys) {
                all = all.add(q);
            }
            if (!invPlanBalanceParam.getPlanTypeCalc().isEnough(all)) {
                BigDecimal last = ((BigDecimal)qtys.remove(qtys.size() - 1)).add(batchQty);
                List resultQtys = invPlanBalanceParam.getBatchCalcService().splitBatchQty(last, requireData);
                qtys.addAll(resultQtys);
            }
        }
        return qtys;
    }

    private void initCycleRequires(CycleMergeStruct cycleMergeStruct, RequireRowData require) {
        Integer fixedperiod = (Integer)MRPUtil.convert((Object)require.getValue(DefaultField.RequireField.FIXEDPERIOD.getName()), (Object)0);
        Integer dynamicperiod = (Integer)MRPUtil.convert((Object)require.getValue(DefaultField.RequireField.DYNAMICCYCLE.getName()), (Object)0);
        Long specialperiod = (Long)MRPUtil.convert((Object)require.getValue(DefaultField.RequireField.SPECIFIEDPERIOD.getName()), (Object)0L);
        Long materialPlanId = (Long)MRPUtil.convert((Object)require.getValue(DefaultField.RequireField.__MATERIALPLAN__.getName()), (Object)0L);
        if (materialPlanId != null && materialPlanId > 0L) {
            if (fixedperiod > 0) {
                this.addCycleRequire(cycleMergeStruct.getFixedRequires(), materialPlanId, require);
            } else if (dynamicperiod > 0) {
                this.addCycleRequire(cycleMergeStruct.getDynamicRequires(), materialPlanId, require);
            } else if (specialperiod > 0L) {
                this.addCycleRequire(cycleMergeStruct.getSpecialRequires(), materialPlanId, require);
            }
        }
    }

    private void addCycleRequire(Map<Long, List<Integer>> maps, Long materialPlanId, RequireRowData require) {
        List requires = maps.computeIfAbsent(materialPlanId, k -> new ArrayList(7));
        requires.add(require.getRowIdx());
    }

    protected List<RequireRowData> removeInventoryRequire(List<RequireRowData> collaborates, HashSet<String> requireOrgs, DataBalanceTable detailTbl, boolean isAddMapping) {
        Iterator<RequireRowData> iterator = collaborates.iterator();
        ArrayList<RequireRowData> inventoryRequire = new ArrayList<RequireRowData>(2);
        while (iterator.hasNext()) {
            String supplyOrgId;
            RequireRowData requireRowData = iterator.next();
            String supplyStrategy = requireRowData.getString(DefaultField.RequireField.SUPPLY_STRATEGY.getName());
            if (!BillSupplyStrategy.INVENTORY.getValue().equals(supplyStrategy) || !MRPUtil.isTransferRequire(requireOrgs, (String)(supplyOrgId = String.valueOf(requireRowData.getValue(DefaultField.RequireField.SUPPLYORGUNIT.getName()))), (RequireRowData)requireRowData)) continue;
            int origIdx = requireRowData.getRowIdx();
            RequireRowData transfer = requireRowData.clone();
            MRPUtil.updateTransferRequire((RequireRowData)transfer, (RequireRowData)requireRowData, (String)requireRowData.getString(DefaultField.RequireField.__REQUIRE_ORG_CHAIN__.getName()), (Object)requireRowData.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()));
            this.ctx.loadRequireMaterialExtProps(transfer);
            if (transfer.getValue(DefaultField.RequireField.MATERIALATTR.getName()) == null) continue;
            DataBalanceTable.RSMapping rsMapping = detailTbl.getMappingByRequireRowIdx(origIdx);
            if (rsMapping != null) {
                BigDecimal srcQty = (BigDecimal)MRPUtil.convert((Object)rsMapping.getRequire().getValue(DefaultField.RequireField.__SUPPLY_QTY__.getName()), (Object)BigDecimal.ZERO);
                BigDecimal srcRQty = (BigDecimal)MRPUtil.convert((Object)rsMapping.getRequire().getValue(DefaultField.RequireField.QTY.getName()), (Object)BigDecimal.ZERO);
                srcQty = srcQty.subtract((BigDecimal)MRPUtil.convert((Object)transfer.getValue(DefaultField.RequireField.QTY.getName()), (Object)BigDecimal.ZERO));
                srcRQty = srcRQty.subtract((BigDecimal)MRPUtil.convert((Object)transfer.getValue(DefaultField.RequireField.QTY.getName()), (Object)BigDecimal.ZERO));
                rsMapping.getRequire().update(DefaultField.RequireField.__SUPPLY_QTY__.getName(), (Object)srcQty);
                rsMapping.getRequire().update(DefaultField.RequireField.QTY.getName(), (Object)srcRQty);
                if (srcQty.compareTo(BigDecimal.ZERO) <= 0) {
                    detailTbl.removeRsMapping(origIdx, rsMapping);
                }
            }
            transfer = this.ctx.requireDatas().fetchRow(this.ctx.requireDatas().fill((RowData)transfer));
            this.ctx.requireDatas().lock(transfer.getRowIdx());
            inventoryRequire.add(transfer);
            if (isAddMapping) {
                this.orderAddMapping(detailTbl, transfer, new ArrayList<RowData>(0), DataBalanceTable.MatchType.LESS);
            }
            iterator.remove();
        }
        return inventoryRequire;
    }

    protected PlanTypeCalc getPlanTypeCalc(RequireRowData requireData, IMRPEnvProvider ctx) {
        String planmode = (String)MRPUtil.convert((Object)requireData.getValue(DefaultField.RequireField.PLANMODE.getName()), (Object)"");
        if (MaterialPlanMode.REORDERPOINT.getValue().equalsIgnoreCase(planmode)) {
            BigDecimal reorderpoint = (BigDecimal)MRPUtil.convert((Object)requireData.getValue(DefaultField.RequireField.REORDERPOINT.getName()), (Object)BigDecimal.ZERO);
            return new ReorderPoint(reorderpoint, this.lessOrEqualRestock);
        }
        if (MaterialPlanMode.MAXANDMININV.getValue().equalsIgnoreCase(planmode)) {
            BigDecimal min = (BigDecimal)MRPUtil.convert((Object)requireData.getValue(DefaultField.RequireField.MIN.getName()), (Object)BigDecimal.ZERO);
            BigDecimal max = (BigDecimal)MRPUtil.convert((Object)requireData.getValue(DefaultField.RequireField.MAX.getName()), (Object)BigDecimal.ZERO);
            return new MaxMinInventory(max, min, this.lessOrEqualRestock);
        }
        return null;
    }

    protected void resolveInnerTransfer() {
        HashSet requireOrgs = this.ctx.getRequirorgs();
        DataBalanceTable detailTbl = this.ctx.calcBalanceDetails();
        Iterator iter = requireOrgs.iterator();
        StringBuilder sb = new StringBuilder((String)iter.next());
        while (iter.hasNext()) {
            sb.append(',').append((String)iter.next());
        }
        if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
            logger.warn(String.format("ctxid: %s, mrprunner-collaborate-rOrgs: [%s], collaborates size: %s", this.ctx.getMRPContextId(), sb, this.collaborates.size()));
        }
        if (!this.collaborates.isEmpty()) {
            this.removeInventoryRequire(this.collaborates, requireOrgs, detailTbl, true);
            if (this.collaborates.isEmpty()) {
                return;
            }
            ArrayList<RequireRowData> current = new ArrayList<RequireRowData>(this.collaborates);
            ArrayList<RequireRowData> requires = new ArrayList<RequireRowData>();
            this.collaborates.clear();
            List<RowData[]> list = this.createCollaborateSupply(current);
            for (RowData[] next : list) {
                RequireRowData require = (RequireRowData)next[0];
                RowData supply = next[1];
                String supplyOrgId = String.valueOf(require.getValue(DefaultField.RequireField.SUPPLYORGUNIT.getName()));
                Object originRequireOrg = require.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName());
                ArrayList<RowData> occupys = new ArrayList<RowData>();
                occupys.add(supply);
                RequireRowData transfer = require.clone();
                detailTbl.addMapping(require, occupys, DataBalanceTable.MatchType.EQUAL);
                this.deductReserveQty(require, occupys, true);
                if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                    logger.warn(String.format("ctxid: %s, mrprunner-collaborate-bill[mid: %s, rOrgId: %s, sOrgId: %s]", this.ctx.getMRPContextId(), require.getValue(DefaultField.RequireField.MATERIAL.getName()), require.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()), supplyOrgId));
                }
                if (!MRPUtil.transferRequire((HashSet)requireOrgs, (Object)originRequireOrg, (String)supplyOrgId, (RowData)supply, (RequireRowData)require, (RequireRowData)transfer, (DataBalanceTable)detailTbl)) continue;
                requires.add(transfer);
            }
            this.collaborates.addAll(requires);
        }
        if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
            logger.warn(String.format("ctxid: %s, mrprunner-collaborates-real-size: %s", this.ctx.getMRPContextId(), this.collaborates.size()));
        }
    }

    protected List<RowData[]> createCollaborateSupply(ArrayList<RequireRowData> current) {
        return this.ctx.createCollaborateSupply(current);
    }

    protected List<RequireRowData> samePeriodOccupy(List<Integer> requireRowIdxs) {
        DataBalanceTable detailTbl = this.ctx.calcBalanceDetails();
        RequirementDataTable requireTbl = this.ctx.requireDatas();
        SupplymentDataTable supplyTbl = this.ctx.supplyDatas();
        List requireRows = requireTbl.fetchRow(requireRowIdxs);
        this.samePeriodOccupy(requireRows, detailTbl, supplyTbl);
        return requireRows;
    }

    private void samePeriodOccupy(List<RequireRowData> requireRows, DataBalanceTable detailTbl, SupplymentDataTable supplyTbl) {
        Iterator<RequireRowData> iter = requireRows.iterator();
        while (iter.hasNext()) {
            String exp;
            this.ctx.testEnvStatus();
            RequireRowData requireData = iter.next();
            String planMode = String.valueOf(requireData.getValue(DefaultField.RequireField.PLANMODE.getName()));
            boolean isInclude = this.ctx.isReorderPoint() && MaterialPlanMode.REORDERPOINT.getValue().equals(planMode);
            isInclude = isInclude || this.ctx.isMPS() && MaterialPlanMode.MPS.getValue().equals(planMode);
            boolean bl = isInclude = isInclude || this.ctx.isMRP() && MaterialPlanMode.MRP.getValue().equals(planMode);
            if (!isInclude) {
                iter.remove();
                continue;
            }
            String string = exp = requireData.getValue(DefaultField.RequireField.EXCEPTIONNUMBER.getName()) == null ? "" : String.valueOf(requireData.getValue(DefaultField.RequireField.EXCEPTIONNUMBER.getName()));
            if (!kd.bos.util.StringUtils.isEmpty((String)exp) && MRPUtil.hasException((String)exp)) {
                detailTbl.addMapping(requireData, new ArrayList(0), DataBalanceTable.MatchType.EQUAL);
                iter.remove();
                continue;
            }
            boolean bool = this.samePeriodOccupyRecord(requireData, supplyTbl, detailTbl);
            if (!bool) continue;
            iter.remove();
        }
    }

    protected boolean samePeriodOccupyRecord(RequireRowData requireData, SupplymentDataTable supplyTbl, DataBalanceTable detailTbl) {
        List occupys = DataBalanceUtil.singleSamePeriodOccupy((RequireRowData)requireData, (IMRPEnvProvider)this.ctx);
        if ("SURPLUS_ADJUST".equals(this.ctx.getCfgValue(EnvCfgItem.MRP_BALANCE_TYPE))) {
            detailTbl.addMapping(requireData, supplyTbl.fetchRow((Collection)occupys), DataBalanceTable.MatchType.LESS);
        } else if (requireData.isBalanced()) {
            detailTbl.addMapping(requireData, supplyTbl.fetchRow((Collection)occupys), DataBalanceTable.MatchType.EQUAL);
        }
        supplyTbl.lock((Collection)occupys, requireData.getRowIdx());
        return requireData.isBalanced();
    }

    protected final void modifyOccupy(List<RequireRowData> requireRows) {
        DataBalanceTable detailTbl = this.ctx.calcBalanceDetails();
        Iterator<RequireRowData> iter = requireRows.iterator();
        while (iter.hasNext()) {
            this.ctx.testEnvStatus();
            RequireRowData requireData = iter.next();
            Object isMergeReq = requireData.getValue(DefaultField.RequireField.__IS_MERGE_.getName());
            String excNum = String.valueOf(requireData.getValue(DefaultField.RequireField.EXCEPTIONNUMBER.getName()));
            BigDecimal qty = (BigDecimal)MRPUtil.convert((Object)requireData.getValue(DefaultField.RequireField.QTY.getName()), (Object)BigDecimal.ZERO);
            if (isMergeReq == Boolean.TRUE || qty.compareTo(BigDecimal.ZERO) <= 0 && excNum.contains("100")) {
                detailTbl.addMapping(requireData, new ArrayList(0), DataBalanceTable.MatchType.EQUAL);
                iter.remove();
                continue;
            }
            Object strategy = requireData.getValue(DefaultField.RequireField.PLAN_STRATEGY.getName());
            if (strategy == null) {
                strategy = requireData.getValue(DefaultField.RequireField.DEFAULT_PLAN_STRATEGY.getName());
            }
            if (strategy == null && ModelUtil.isMrpCalc((CalEnv)this.ctx) && !InvPlanUtil.isInvRequire((IMRPEnvProvider)this.ctx, (RequireRowData)requireData) && !this.ctx.isSpecialPlan()) {
                String msg = MRPUtil.appendExceptionMsg((Object)requireData.getValue(DefaultField.RequireField.EXCEPTIONMESSAGE.getName()), (String)ResManager.loadKDString((String)"\u672a\u627e\u5230\u5236\u9020\u7b56\u7565\u3002", (String)"MRPMDataBalanceStep_3", (String)"mmc-mrp-mservice-calcnode", (Object[])new Object[0]));
                requireData.update(DefaultField.RequireField.EXCEPTIONMESSAGE.getName(), (Object)msg);
                String num = MRPUtil.appendExceptionNumber((Object)requireData.getValue(DefaultField.RequireField.EXCEPTIONNUMBER.getName()), (String)"95");
                requireData.update(DefaultField.RequireField.EXCEPTIONNUMBER.getName(), (Object)num);
            }
            if (!"SURPLUS_ADJUST".equals(this.ctx.getCfgValue(EnvCfgItem.MRP_BALANCE_TYPE))) {
                String exp;
                String string = exp = requireData.getValue(DefaultField.RequireField.EXCEPTIONNUMBER.getName()) == null ? "" : String.valueOf(requireData.getValue(DefaultField.RequireField.EXCEPTIONNUMBER.getName()));
                if (!kd.bos.util.StringUtils.isEmpty((String)exp) && MRPUtil.hasException((String)exp)) {
                    detailTbl.addMapping(requireData, new ArrayList(0), DataBalanceTable.MatchType.EQUAL);
                    iter.remove();
                    continue;
                }
            }
            this.modifyOccupyRecord(requireData, detailTbl);
        }
    }

    protected void modifyOccupyRecord(RequireRowData requireData, DataBalanceTable detailTbl) {
        ArrayList<RowData> occupyData = new ArrayList<RowData>();
        DataBalanceTable.MatchType matchType = DataBalanceUtil.singleModifyOccupy((RequireRowData)requireData, (IMRPEnvProvider)this.ctx, occupyData);
        if (matchType != null) {
            this.addMapping(detailTbl, requireData, occupyData, matchType);
        }
    }

    protected final void addMapping(DataBalanceTable detailTbl, RequireRowData requireData, List<RowData> occupyData, DataBalanceTable.MatchType matchType) {
        if (this.isFabricatedpart(requireData) && MRPUtil.convert((Object)requireData.getValue(DefaultField.RequireField.__IS_INTERNAL_GROSS_DEMAND__.getName()), (Boolean)Boolean.FALSE).booleanValue()) {
            this.collaborateAddMapping(detailTbl, requireData, occupyData, matchType, true);
        } else {
            boolean isTransfer = this.isTransfer(requireData, matchType);
            if (isTransfer) {
                this.collaborateAddMapping(detailTbl, requireData, occupyData, matchType);
            } else {
                this.orderAddMapping(detailTbl, requireData, occupyData, matchType);
            }
        }
        this.deductReserveQty(requireData, occupyData);
    }

    protected void deductReserveQty(RequireRowData requireData, List<RowData> occupyData) {
        this.deductReserveQty(requireData, occupyData, false);
    }

    protected void deductReserveQty(RequireRowData requireData, List<RowData> occupyData, boolean checkPlanTag) {
        PlanModel planModel = (PlanModel)this.ctx.getService(PlanModel.class);
        boolean isReserve = planModel.isReserve();
        if (occupyData.isEmpty() || !isReserve) {
            return;
        }
        ArrayList<Long> check = new ArrayList<Long>(this.ctx.getAllPlanTags());
        if (check.isEmpty()) {
            check.add(0L);
        }
        Long tag = (Long)MRPUtil.convert((Object)requireData.getValue(DefaultField.RequireField.__PLAN_TAG__.getName()), (Object)0L);
        if (checkPlanTag && !check.contains(tag)) {
            return;
        }
        RequireDataModel requireDataModel = (RequireDataModel)this.ctx.getService(RequireDataModel.class);
        String outPutType = requireDataModel.getOutputType();
        SupplymentDataTable sTable = this.ctx.supplyDatas();
        Long material = requireData.getLong(DefaultField.RequireField.MATERIAL.getName());
        Long reqBillId = (Long)MRPUtil.convert((Object)requireData.getValue(DefaultField.RequireField.BILLID.getName()), (Object)0L);
        Long reqBillEntryId = (Long)MRPUtil.convert((Object)requireData.getValue(DefaultField.RequireField.BILLENTRYID.getName()), (Object)0L);
        if (reqBillEntryId == 0L) {
            reqBillEntryId = reqBillId;
        }
        String billEntity = requireData.getString(DefaultField.RequireField.BILL_ENTITY.getName());
        String billNo = requireData.getString(DefaultField.RequireField.BILLNUMBER.getName());
        Integer billEntrySeq = requireData.getInteger(DefaultField.RequireField.BILLENTRYSEQ.getName());
        Integer row = (Integer)sTable.getR2Row().get(String.format("%s-%s", reqBillId, reqBillEntryId));
        String reserve_billno = requireData.getString(DefaultField.RequireField.RESERVE_BILLNO.getName());
        Long reserve_billid = requireData.getLong(DefaultField.RequireField.RESERVE_BILLID.getName());
        Long reserve_billentryid = requireData.getLong(DefaultField.RequireField.RESERVE_BILLENTRYID.getName());
        Integer reserve_billentryseq = requireData.getInteger(DefaultField.RequireField.RESERVE_BILLENTRYSEQ.getName());
        boolean isGetReserveData = reserve_billno != null && reserve_billid != null && reserve_billid > 0L;
        for (RowData supply : occupyData) {
            Boolean isStorageSupply;
            ReserveData selfReserveData;
            Long bill_id = (Long)MRPUtil.convert((Object)supply.getValue(DefaultField.SupplyField.BILLID.getName()), (Object)0L);
            Long billentry_id = (Long)MRPUtil.convert((Object)supply.getValue(DefaultField.SupplyField.BILLENTRYID.getName()), (Object)0L);
            if (billentry_id == 0L) {
                billentry_id = bill_id;
            }
            String key = String.format("%s-%s", bill_id, billentry_id);
            Integer col = (Integer)sTable.getS2Col().get(key);
            BigDecimal supQty = (BigDecimal)MRPUtil.convert((Object)supply.getValue(DefaultField.SupplyField.QTY.getName()), (Object)BigDecimal.ZERO);
            boolean isNeedReserve = true;
            BigDecimal newSupQty = supQty;
            ReserveData s2ReserveData = (ReserveData)sTable.getS2Reserve().get(key);
            BigDecimal sumSpQty = (BigDecimal)sTable.getSingleSpSumQty().get(key);
            if (sumSpQty != null) {
                sumSpQty = sumSpQty.subtract(supQty);
                sTable.getSingleSpSumQty().put(key, sumSpQty);
            }
            boolean isDependReqReserve = false;
            if (row != null && col != null && (selfReserveData = (ReserveData)sTable.getReserveDatas().get(String.valueOf(row) + '-' + String.valueOf(col))) != null && s2ReserveData != null) {
                BigDecimal origReserveQty = selfReserveData.getReserveQty();
                BigDecimal origWeakReserveQty = selfReserveData.getWeakReserveQty();
                isDependReqReserve = selfReserveData.getAllQty().compareTo(BigDecimal.ZERO) > 0;
                BigDecimal surplusQty = selfReserveData.subReserveQty(supQty);
                if (surplusQty.compareTo(BigDecimal.ZERO) >= 0) {
                    isNeedReserve = false;
                    newSupQty = BigDecimal.ZERO;
                } else {
                    newSupQty = surplusQty.abs();
                }
                origReserveQty = origReserveQty.subtract(selfReserveData.getReserveQty());
                origWeakReserveQty = origWeakReserveQty.subtract(selfReserveData.getWeakReserveQty());
                s2ReserveData.addReserveQty(origReserveQty.negate(), false);
                s2ReserveData.addReserveQty(origWeakReserveQty.negate(), true);
            }
            boolean bl = isDependReqReserve = isDependReqReserve && isGetReserveData;
            if ((!isNeedReserve || !MRPUtil.isNeedReserve((CalEnv)this.ctx, (RequireRowData)requireData)) && !isDependReqReserve) continue;
            String reservedType = requireData.getString(DefaultField.RequireField.RESERVEDTYPE.getName());
            boolean isWeak = StringUtils.equals((CharSequence)reservedType, (CharSequence)"B");
            HashMap<String, Object> resMap = new HashMap<String, Object>(32);
            resMap.put("ori_bill_obj", billEntity);
            resMap.put("ori_bill_no", billNo);
            resMap.put("ori_bill_id", reqBillId);
            resMap.put("ori_billentry_id", reqBillEntryId);
            resMap.put("ori_billentry_seq", billEntrySeq);
            resMap.put("bill_obj", isGetReserveData ? outPutType : billEntity);
            resMap.put("r_sale_org", requireData.getLong(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()));
            resMap.put("r_biz_date", requireData.getLong(DefaultField.RequireField.__ORIGIN_DEMAND_DATE__.getName()) == null ? requireData.getLong(DefaultField.RequireField.DATE.getName()) : requireData.getLong(DefaultField.RequireField.__ORIGIN_DEMAND_DATE__.getName()));
            resMap.put("bill_no", isGetReserveData ? reserve_billno : billNo);
            resMap.put("bill_id", isGetReserveData ? reserve_billid : reqBillId);
            resMap.put("billentry_id", isGetReserveData ? reserve_billentryid : reqBillEntryId);
            resMap.put("billentry_seq", isGetReserveData ? reserve_billentryseq : billEntrySeq);
            resMap.put("s_org", supply.getLong(DefaultField.SupplyField.SUPPLYORGUNIT.getName()));
            resMap.put("bal_obj", supply.getString(DefaultField.SupplyField.BILL_ENTITY.getName()));
            Long supBillId = (Long)MRPUtil.convert((Object)supply.getValue(DefaultField.SupplyField.BILLID.getName()), (Object)0L);
            Long supBillEntryId = (Long)MRPUtil.convert((Object)supply.getValue(DefaultField.SupplyField.BILLENTRYID.getName()), (Object)0L);
            if (supBillEntryId == 0L) {
                supBillEntryId = supBillId;
            }
            resMap.put("bal_id", supBillId);
            resMap.put("s_billnum", supply.getString(DefaultField.SupplyField.BILLNUMBER.getName()));
            resMap.put("s_entryseq", supply.getInteger(DefaultField.SupplyField.BILLENTRYSEQ.getName()));
            resMap.put("s_biz_date", supply.getLong(DefaultField.SupplyField.DATE.getName()));
            resMap.put("bal_entryid", supBillEntryId);
            resMap.put("s_materiel", material);
            resMap.put("s_unit", requireData.getLong(DefaultField.RequireField.BASEUNIT.getName()));
            resMap.put("s_baseunit", requireData.getLong(DefaultField.RequireField.BASEUNIT.getName()));
            resMap.put("qty", newSupQty);
            resMap.put("base_qty", newSupQty);
            resMap.put("ori_qty", newSupQty);
            resMap.put("isweak", isWeak);
            resMap.put("change_type", "1");
            resMap.put("create_date", new Date());
            resMap.put("creater", RequestContext.get().getCurrUserId());
            resMap.put("reservesource", "MRP");
            resMap.put("priority", requireData.getInteger(DefaultField.RequireField.__PRIORITY_LEVEL__.getName()));
            resMap.put("isgenreserve", MRPUtil.convert((Object)requireData.getValue(DefaultField.RequireField.IS_GEN_RESERVE.getName()), (Boolean)Boolean.FALSE));
            if (sumSpQty != null && s2ReserveData != null) {
                sumSpQty = sumSpQty.subtract(s2ReserveData.getReserveQty());
                BigDecimal ocpWeakQty = s2ReserveData.getWeakReserveQty().subtract(sumSpQty);
                if (sumSpQty.compareTo(BigDecimal.ZERO) >= 0 && ocpWeakQty.compareTo(BigDecimal.ZERO) > 0) {
                    resMap.put("ocp_weak_qty", ocpWeakQty);
                    s2ReserveData.addReserveQty(ocpWeakQty.negate(), true);
                }
            }
            List list = this.ctx.getReserveCacheData().computeIfAbsent(material.toString(), k -> new ArrayList(16));
            if (isDependReqReserve) {
                if (newSupQty.compareTo(BigDecimal.ZERO) > 0) {
                    HashMap cloneMap = new HashMap(resMap);
                    list.add(cloneMap);
                }
                resMap.put("qty", supQty.subtract(newSupQty));
                resMap.put("base_qty", supQty.subtract(newSupQty));
                resMap.put("ori_qty", supQty.subtract(newSupQty));
                resMap.put("isDependReqReserve", "1");
            }
            if ((isStorageSupply = MRPUtil.convert((Object)supply.getValue(DefaultField.SupplyField.ISSTORAGEDATA.getName()), (Boolean)Boolean.FALSE)).booleanValue()) {
                resMap.put("s_warehouse", supply.getLong(DefaultField.SupplyField.WAREHOUSE.getName()));
                resMap.put("s_location", supply.getLong(DefaultField.SupplyField.STOCKLOT.getName()));
                resMap.put("s_invstatus", supply.getLong(DefaultField.SupplyField.STOCKSTATUS.getName()));
                resMap.put("s_invtype", supply.getLong(DefaultField.SupplyField.STOCKTYPE.getName()));
            }
            list.add(resMap);
        }
    }

    private void addTransferDemand(List<RequireRowData> transferDemands, RequireRowData requireData) {
        for (RequireRowData rData : transferDemands) {
            if (!rData.getRowIdx().equals(requireData.getRowIdx())) continue;
            return;
        }
        transferDemands.add(requireData);
    }

    private void collaborateAddMapping(DataBalanceTable detailTbl, RequireRowData requireData, List<RowData> occupyData, DataBalanceTable.MatchType matchType) {
        this.collaborateAddMapping(detailTbl, requireData, occupyData, matchType, false);
    }

    private void collaborateAddMapping(DataBalanceTable detailTbl, RequireRowData requireData, List<RowData> occupyData, DataBalanceTable.MatchType matchType, boolean isGrossDemand) {
        if (DataBalanceTable.MatchType.EQUAL == matchType) {
            detailTbl.addMapping(requireData, occupyData, DataBalanceTable.MatchType.EQUAL);
            return;
        }
        BigDecimal rQty = MRPUtil.toBigDecimal((Object)requireData.getValue(DefaultField.RequireField.QTY.getName()));
        if (rQty.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        if (!occupyData.isEmpty()) {
            BigDecimal sum = BigDecimal.ZERO;
            for (RowData s : occupyData) {
                sum = sum.add(MRPUtil.toBigDecimal((Object)s.getValue(DefaultField.SupplyField.QTY.getName())));
            }
            RequireRowData split = this.split(requireData, sum);
            if (detailTbl.getMappingByRequireRowIdx(split.getRowIdx().intValue()) == null) {
                split.update(DefaultField.RequireField.QTY.getName(), (Object)rQty);
            }
            detailTbl.addMapping(split, occupyData, DataBalanceTable.MatchType.LESS);
            requireData.setBalanced(false);
            requireData.update(DefaultField.RequireField.QTY.getName(), (Object)rQty.subtract(sum));
            requireData.getOccupys().clear();
        } else if (detailTbl.getMappingByRequireRowIdx(requireData.getRowIdx().intValue()) == null) {
            detailTbl.addMapping(requireData, occupyData, DataBalanceTable.MatchType.LESS);
        }
        if (isGrossDemand) {
            this.addTransferDemand(this.internalNetDemands, requireData);
        } else {
            this.addTransferDemand(this.collaborates, requireData);
        }
    }

    protected void orderAddMapping(DataBalanceTable detailTbl, RequireRowData requireData, List<RowData> occupyData, DataBalanceTable.MatchType matchType) {
        if (this.ctx.isAllowPast()) {
            detailTbl.addMapping(requireData, occupyData, matchType);
        } else {
            Long oldDate = (Long)MRPUtil.convert((Object)requireData.getValue(DefaultField.RequireField.DATE.getName()), (Object)System.currentTimeMillis());
            if (matchType == DataBalanceTable.MatchType.LESS && oldDate <= this.ctx.getPlanDate().getTime()) {
                String orgId = String.valueOf(requireData.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()));
                String supplyOrgId = String.valueOf(requireData.getValue(DefaultField.RequireField.SUPPLYORGUNIT.getName()));
                int mt = (Integer)MRPUtil.convert((Object)requireData.getValue(DefaultField.RequireField.MATERIALATTR.getName()), (Object)MaterialAttribute.OTHER.getValue());
                long date = MaterialAttribute.PURCHASEDPART.getValue() == mt ? this.ctx.getPlanDate().getTime() : this.ctx.dateManager().get(supplyOrgId, orgId).getDate(this.ctx.getPlanDate(), false).getTimeInMillis();
                requireData.update(DefaultField.RequireField.__SRC_DATE__.getName(), (Object)oldDate);
                if (!occupyData.isEmpty() && oldDate != date) {
                    BigDecimal rQty = (BigDecimal)MRPUtil.convert((Object)requireData.getValue(DefaultField.RequireField.QTY.getName()), (Object)BigDecimal.ZERO);
                    BigDecimal sum = BigDecimal.ZERO;
                    for (RowData s : occupyData) {
                        sum = sum.add(MRPUtil.toBigDecimal((Object)s.getValue(DefaultField.SupplyField.QTY.getName())));
                    }
                    RequireRowData split = this.split(requireData, sum);
                    if (detailTbl.getMappingByRequireRowIdx(split.getRowIdx().intValue()) == null) {
                        split.update(DefaultField.RequireField.QTY.getName(), (Object)rQty);
                    }
                    detailTbl.addMapping(split, occupyData, DataBalanceTable.MatchType.LESS);
                    requireData.update(DefaultField.RequireField.DATE.getName(), (Object)date);
                    requireData.setBalanced(false);
                    requireData.update(DefaultField.RequireField.QTY.getName(), (Object)rQty.subtract(sum));
                    requireData.getOccupys().clear();
                    if ("SURPLUS_ADJUST".equals(this.ctx.getCfgValue(EnvCfgItem.MRP_BALANCE_TYPE))) {
                        detailTbl.addMapping(requireData, new ArrayList(), DataBalanceTable.MatchType.LESS);
                    }
                    return;
                }
                requireData.update(DefaultField.RequireField.DATE.getName(), (Object)date);
                detailTbl.addMapping(requireData, occupyData, DataBalanceTable.MatchType.LESS);
            } else {
                detailTbl.addMapping(requireData, occupyData, matchType);
            }
        }
    }

    protected boolean isTransfer(RequireRowData requireData, DataBalanceTable.MatchType matchType) {
        Integer mAttr = (Integer)MRPUtil.convert((Object)requireData.getValue(DefaultField.RequireField.MATERIALATTR.getName()), (Object)MaterialAttribute.OTHER.getValue());
        String requireOrgId = String.valueOf(requireData.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName()));
        String supplyOrgId = String.valueOf(requireData.getValue(DefaultField.RequireField.SUPPLYORGUNIT.getName()));
        return matchType == DataBalanceTable.MatchType.LESS && !requireOrgId.equals(supplyOrgId) && MaterialAttribute.STORAGEPART.getValue() == mAttr.intValue();
    }

    protected boolean isFabricatedpart(RequireRowData row) {
        return MaterialAttribute.STORAGEPART.getValue() == ((Integer)MRPUtil.convert((Object)row.getValue(DefaultField.RequireField.MATERIALATTR.getName()), (Object)MaterialAttribute.OTHER.getValue())).intValue();
    }

    protected RequireRowData split(RequireRowData requireData, BigDecimal rQty) {
        RequireRowData clone = requireData.clone();
        clone.setBalanced(true);
        clone.setBomRow(requireData.getBomRow());
        clone.setNewQrequireQty(BigDecimal.ZERO);
        clone.update(DefaultField.RequireField.QTY.getName(), (Object)rQty);
        clone.getOccupys().addAll(requireData.getOccupys());
        return clone;
    }

    public String getDesc() {
        return Tips.getDataBalance();
    }

    protected static class MaxMinInventory
    implements PlanTypeCalc {
        BigDecimal max;
        BigDecimal min;
        boolean lessOrEqualRestock;

        public MaxMinInventory(BigDecimal max, BigDecimal min, boolean lessOrEqualRestock) {
            this.max = max;
            this.min = min;
            this.lessOrEqualRestock = lessOrEqualRestock;
        }

        @Override
        public BigDecimal getPlanOrderQty(BigDecimal rQty, BigDecimal remainQty) {
            BigDecimal availableQty = remainQty.subtract(rQty);
            if (this.isEnough(availableQty)) {
                return null;
            }
            return this.max.subtract(availableQty);
        }

        @Override
        public boolean isEnough(BigDecimal remainQty) {
            return remainQty.compareTo(this.min) > 0 || !this.lessOrEqualRestock && remainQty.compareTo(this.min) == 0;
        }

        @Override
        public BigDecimal getRemainSupplyOccupyQty(BatchCalcService batchCalcService, RequireRowData require) {
            return batchCalcService.calcBatchNoSplit(this.max, require);
        }
    }

    protected static class ReorderPoint
    implements PlanTypeCalc {
        BigDecimal point;
        boolean lessOrEqualRestock;

        ReorderPoint(BigDecimal point, boolean lessOrEqualRestock) {
            this.point = point;
            this.lessOrEqualRestock = lessOrEqualRestock;
        }

        @Override
        public BigDecimal getPlanOrderQty(BigDecimal rQty, BigDecimal remainQty) {
            BigDecimal availableQty = remainQty.subtract(rQty);
            if (!this.isEnough(availableQty)) {
                return this.point.subtract(availableQty);
            }
            return null;
        }

        @Override
        public boolean isEnough(BigDecimal remainQty) {
            return remainQty.compareTo(this.point) > 0 || !this.lessOrEqualRestock && remainQty.compareTo(this.point) == 0;
        }

        @Override
        public BigDecimal getRemainSupplyOccupyQty(BatchCalcService batchCalcService, RequireRowData require) {
            BigDecimal remainQty = batchCalcService.calcBatchNoSplit(this.point, require);
            if (!this.isEnough(remainQty)) {
                remainQty = remainQty.add(batchCalcService.calcBatchNoSplit(BigDecimal.ZERO, require));
            }
            return remainQty;
        }
    }

    protected static interface PlanTypeCalc {
        public BigDecimal getPlanOrderQty(BigDecimal var1, BigDecimal var2);

        public boolean isEnough(BigDecimal var1);

        public BigDecimal getRemainSupplyOccupyQty(BatchCalcService var1, RequireRowData var2);
    }

    public static class InvPlanBalanceParam {
        private final BatchCalcService batchCalcService;
        private final PlanTypeCalc planTypeCalc;
        private final List<RowData> newSupplys;
        private BigDecimal remainQty = BigDecimal.ZERO;
        private boolean origRequireNotOccupy = false;
        private BigDecimal sumSQty = BigDecimal.ZERO;
        private boolean isSurplus = false;
        private Long dateTime = 0L;

        public InvPlanBalanceParam(BatchCalcService batchCalcService, PlanTypeCalc planTypeCalc, List<RowData> newSupplys) {
            this.batchCalcService = batchCalcService;
            this.planTypeCalc = planTypeCalc;
            this.newSupplys = newSupplys;
        }

        public void setRemainQty(BigDecimal remainQty) {
            this.remainQty = remainQty;
        }

        public void setOrigRequireNotOccupy(boolean origRequireNotOccupy) {
            this.origRequireNotOccupy = origRequireNotOccupy;
        }

        public void setSumSQty(BigDecimal sumSQty) {
            this.sumSQty = sumSQty;
        }

        public void setSurplus(boolean surplus) {
            this.isSurplus = surplus;
        }

        public BatchCalcService getBatchCalcService() {
            return this.batchCalcService;
        }

        public PlanTypeCalc getPlanTypeCalc() {
            return this.planTypeCalc;
        }

        public BigDecimal getRemainQty() {
            return this.remainQty;
        }

        public boolean isOrigRequireNotOccupy() {
            return this.origRequireNotOccupy;
        }

        public BigDecimal getSumSQty() {
            return this.sumSQty;
        }

        public boolean isSurplus() {
            return this.isSurplus;
        }

        public List<RowData> getNewSupplys() {
            return this.newSupplys;
        }

        public Long getDateTime() {
            return this.dateTime;
        }

        public void setDateTime(Long dateTime) {
            this.dateTime = dateTime;
        }
    }

    public static class RequirePriorityLevelModel {
        private ColumnDatas rCol;
        private Iterator<Comparable<?>> priorityIter;

        public RequirePriorityLevelModel(ColumnDatas rCol, Iterator<Comparable<?>> priorityIter) {
            this.rCol = rCol;
            this.priorityIter = priorityIter;
        }

        public ColumnDatas getrCol() {
            return this.rCol;
        }

        public Iterator<Comparable<?>> getPriorityIter() {
            return this.priorityIter;
        }
    }
}

