/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.calcnode.framework.step;

import java.math.BigDecimal;
import kd.mmc.mrp.calcnode.framework.step.AbstractMRPSubStep;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.consts.Tips;
import kd.mmc.mrp.framework.step.IMRPResult;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.table.GridData;
import kd.mmc.mrp.utils.MRPUtil;

public class MRPYieldCal
extends AbstractMRPSubStep {
    private int start = 0;
    private boolean isIgnore = false;

    public MRPYieldCal(IMRPEnvProvider ctx, int start) {
        super(ctx);
        this.start = start;
    }

    @Override
    protected IMRPResult executeImpl() {
        if (this.isIgnore) {
            return null;
        }
        this.yieldCal();
        this.dataAmount = this.ctx.supplyDatas().getSrcDatas().getDatas().size();
        return null;
    }

    public String getDesc() {
        return Tips.getYieldCal();
    }

    private void yieldCal() {
        boolean isYield = this.ctx.isYield();
        GridData.Grid list = this.ctx.supplyDatas().getSrcDatas().getDatas();
        for (Object[] rowData : list) {
            BigDecimal yield;
            Integer i;
            Integer isStockIdx;
            Integer qtyIdx = (Integer)this.ctx.supplyDatas().getColIdx().get(DefaultField.SupplyField.QTY.getName());
            BigDecimal qty = BigDecimal.ZERO;
            if (qtyIdx != null && rowData[qtyIdx] != null) {
                qty = MRPUtil.toBigDecimal((Object)rowData[qtyIdx]);
                Integer originQtyIdx = (Integer)this.ctx.supplyDatas().getColIdx().get(DefaultField.SupplyField.ORIGINQTY.getName());
                if (originQtyIdx != null) {
                    rowData[originQtyIdx.intValue()] = qty;
                }
            }
            if (!isYield || (isStockIdx = (Integer)this.ctx.supplyDatas().getColIdx().get(DefaultField.SupplyField.ISSTORAGEDATA.getName())) != null && MRPUtil.convert((Object)rowData[isStockIdx], (Boolean)Boolean.FALSE).booleanValue() || (i = (Integer)this.ctx.supplyDatas().getColIdx().get(DefaultField.SupplyField.YIELD.getName())) == null || rowData[i] == null || (yield = MRPUtil.toBigDecimal((Object)rowData[i])).compareTo(BigDecimal.ONE) >= 0 || qty.compareTo(BigDecimal.ZERO) == 0) continue;
            Integer y = (Integer)this.ctx.supplyDatas().getColIdx().get(DefaultField.SupplyField.BASEUNIT.getName());
            qty = MRPUtil.calcYield((BigDecimal)yield, (Object)(y == null ? null : rowData[y]), (BigDecimal)qty, (IMRPEnvProvider)this.ctx, (boolean)true);
            if (qtyIdx == null) continue;
            rowData[qtyIdx.intValue()] = qty;
        }
    }
}

