/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.opplugin.botp;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.AfterGetSourceDataEventArgs;
import kd.bos.exception.KDBizException;
import kd.mmc.mrp.business.helper.BillUnitAndQtytHelper;
import kd.mmc.mrp.model.enums.PrecisionAccountEnum;
import kd.mmc.mrp.opplugin.botp.MaterialInfoBOTPUtil;

public class PlsResultToMftOrderOp
extends AbstractConvertPlugIn {
    protected Map<String, String> cacheMap = new HashMap<String, String>();
    private List<DynamicObject> sourceDataList;

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        e.addSrcField("source_order_billno");
        e.addSrcField("source_order_type");
        e.addSrcField("pls_date");
        e.addSrcField("workstarttime");
        e.addSrcField("workendtime");
    }

    public void afterGetSourceData(AfterGetSourceDataEventArgs e) {
        Map dicMap = e.getFldProperties();
        List dataList = e.getSourceRows();
        this.setSourceDataList(dataList);
        StringBuilder errorMsg = new StringBuilder();
        for (DynamicObject data : dataList) {
            Long materId = (Long)((DynamicProperty)dicMap.get("materiel_code")).getValue((Object)data);
            Long org = (Long)((DynamicProperty)dicMap.get("production_org")).getValue((Object)data);
            String billno = (String)((DynamicProperty)dicMap.get("source_order_billno")).getValue((Object)data);
            ((DynamicProperty)dicMap.get("production_org")).setValue((Object)data, (Object)org);
            DynamicObjectCollection infos = MaterialInfoBOTPUtil.getMaterialInfo4Org(materId, org, "bd_materialmftinfo", "id");
            if (infos == null || infos.isEmpty()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6765\u6e90\u8ba2\u5355\u7f16\u53f7\u201c%s\u201d\u7684\u7269\u6599\u4e0d\u5b58\u5728\u7269\u6599\u751f\u4ea7\u4fe1\u606f\u3002", (String)"PlsResultToMftOrderOp_0", (String)"mmc-mrp-opplugin", (Object[])new Object[0]), billno));
            }
            ((DynamicProperty)dicMap.get("materiel_code")).setValue((Object)data, (Object)((DynamicObject)infos.get(0)).getLong("id"));
        }
    }

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey(this.getTgtMainType().toString());
        List<DynamicObject> sourceDataList = this.getSourceDataList();
        Map dicMap = e.getFldProperties();
        StringBuilder errorMsg = new StringBuilder();
        HashSet errorOrgs = new HashSet(8);
        if (entitys == null || entitys.length == 0) {
            return;
        }
        for (int i = 0; i < entitys.length; ++i) {
            if (sourceDataList.size() < entitys.length) continue;
            DynamicObject sourceData = sourceDataList.get(i);
            DynamicObject bill = entitys[i].getDataEntity();
            Date plsDate = (Date)((DynamicProperty)dicMap.get("pls_date")).getValue((Object)sourceData);
            String billno = (String)((DynamicProperty)dicMap.get("source_order_billno")).getValue((Object)sourceData);
            Long orgid = (Long)((DynamicProperty)dicMap.get("production_org")).getValue((Object)sourceData);
            int workstarttime = (Integer)((DynamicProperty)dicMap.get("workstarttime")).getValue((Object)sourceData);
            int workendtime = (Integer)((DynamicProperty)dicMap.get("workendtime")).getValue((Object)sourceData);
            if (workendtime < workstarttime) {
                workendtime = 86400 + workendtime;
            }
            Date startDate = new Date(plsDate.getTime() + (long)workstarttime * 1000L);
            Date endDate = new Date(plsDate.getTime() + (long)workendtime * 1000L);
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("treeentryentity");
            if (errorOrgs.contains(orgid) || entries == null || entries.isEmpty()) continue;
            for (DynamicObject entry : entries) {
                entry.set("planbegintime", (Object)startDate);
                entry.set("planendtime", (Object)endDate);
                DynamicObject materialInfo = entry.getDynamicObject("material");
                if (materialInfo == null) {
                    return;
                }
                DynamicObject material = materialInfo.getDynamicObject("masterid");
                DynamicObject materialUnit = materialInfo.getDynamicObject("mftunit");
                if (materialUnit == null) {
                    return;
                }
                entry.set("unit", (Object)materialUnit);
                DynamicObject baseunit = entry.getDynamicObject("baseunit");
                BigDecimal baseqty = entry.getBigDecimal("baseqty");
                if (baseunit == null || BigDecimal.ZERO.compareTo(baseqty) == 0) {
                    return;
                }
                BigDecimal unit2ndRate = BillUnitAndQtytHelper.getUnitRateConv((Long)((Long)material.getPkValue()), (Long)((Long)materialUnit.getPkValue()), (Long)((Long)baseunit.getPkValue()), this.cacheMap);
                if (unit2ndRate == null || BigDecimal.ZERO.compareTo(unit2ndRate) == 0) {
                    return;
                }
                BigDecimal qtyUnit2nd = BigDecimal.ZERO;
                if (baseqty != null && baseqty.compareTo(BigDecimal.ZERO) != 0) {
                    qtyUnit2nd = baseqty.divide(unit2ndRate, materialUnit.getInt("precision"), PrecisionAccountEnum.getEnumByVal((int)materialUnit.getInt("precisionaccount")));
                }
                entry.set("qty", (Object)qtyUnit2nd);
            }
        }
        if (errorMsg.length() > 0) {
            errorMsg.append(ResManager.loadKDString((String)"\u68c0\u67e5\u662f\u5426\u5df2\u5b8c\u6210\u751f\u4ea7\u4e8b\u52a1\u7c7b\u578b\u521d\u59cb\u5316\u64cd\u4f5c", (String)"PlsResultToMftOrderOp_2", (String)"mmc-mrp-opplugin", (Object[])new Object[0]));
            throw new KDBizException(errorMsg.toString());
        }
    }

    public List<DynamicObject> getSourceDataList() {
        return this.sourceDataList;
    }

    public void setSourceDataList(List<DynamicObject> sourceDataList) {
        this.sourceDataList = sourceDataList;
    }
}

