/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.opplugin.planexecute;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mrp.business.helper.XPlanOrderChangeLoghelper;
import kd.mmc.mrp.business.helper.XPlanOrderChangehelper;
import kd.mmc.mrp.opplugin.planexecute.XPlanOrderChangeValidator;

public class XPlanOrderChangeAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("sourceid");
        e.getFieldKeys().add("changeqty");
        e.getFieldKeys().add("changedate");
        e.getFieldKeys().add("changetype");
        e.getFieldKeys().add("changtracknumber");
        e.getFieldKeys().add("changsupplier");
        e.getFieldKeys().add("reason");
        e.getFieldKeys().add("sourceno");
        e.getFieldKeys().add("creator");
        e.getFieldKeys().add("createtime");
        e.getFieldKeys().add("tracknumber");
        e.getFieldKeys().add("issysgen");
        e.getFieldKeys().add("modifier");
        e.getFieldKeys().add("modifytime");
        e.getFieldKeys().add("auditor");
        e.getFieldKeys().add("auditdate");
        e.getFieldKeys().add("proorpurorg");
        e.getFieldKeys().add("org");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new XPlanOrderChangeValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] xplanOrderChangeBills = e.getDataEntities();
        HashSet<Long> ids = new HashSet<Long>(xplanOrderChangeBills.length);
        HashSet<Long> sourceids = new HashSet<Long>(xplanOrderChangeBills.length);
        for (DynamicObject dynamicObject : xplanOrderChangeBills) {
            Long sourceid = dynamicObject.getLong("sourceid");
            sourceids.add(sourceid);
            Long id = dynamicObject.getLong("id");
            ids.add(id);
            dynamicObject.set("auditdate", (Object)new Date());
            dynamicObject.set("auditor_id", (Object)RequestContext.get().getCurrUserId());
        }
        MainEntityType planorderType = EntityMetadataCache.getDataEntityType((String)"mrp_planorder");
        DynamicObject[] planOrders = BusinessDataServiceHelper.load((Object[])sourceids.toArray(new Object[0]), (DynamicObjectType)planorderType);
        HashMap<Long, DynamicObject> planOrderMap = new HashMap<Long, DynamicObject>(planOrders.length);
        for (DynamicObject planOrder : planOrders) {
            Long planOrderId = planOrder.getLong("id");
            planOrderMap.put(planOrderId, planOrder);
        }
        DynamicObject[] dynamicObjectArray = BusinessDataServiceHelper.load((String)"mrp_xplanorderlog", (String)XPlanOrderChangeLoghelper.getSelectXPlanOrderRLogFields(), (QFilter[])new QFilter[]{new QFilter("xbillid", "in", ids)});
        Map<Long, DynamicObject> xplanorderLogMap = this.genXPlanorderLogMap(dynamicObjectArray);
        for (int i = 0; i < xplanOrderChangeBills.length; ++i) {
            DynamicObject planorderChangeBill = xplanOrderChangeBills[i];
            Long xplanOrderId = planorderChangeBill.getLong("id");
            Long planOrderId = planorderChangeBill.getLong("sourceid");
            DynamicObject planOrder = (DynamicObject)planOrderMap.get(planOrderId);
            DynamicObject xplanorderLog = xplanorderLogMap.get(xplanOrderId);
            XPlanOrderChangehelper.dealChangePlanOrder((DynamicObject)planorderChangeBill, (DynamicObject)planOrder, (DynamicObject)xplanorderLog, planOrderMap, (MainEntityType)planorderType);
        }
        SaveServiceHelper.save((DynamicObject[])xplanorderLogMap.values().toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])planOrderMap.values().toArray(new DynamicObject[0]));
    }

    private Map<Long, DynamicObject> genXPlanorderLogMap(DynamicObject[] xplanorderLogs) {
        HashMap<Long, DynamicObject> xplanorderLogMap = new HashMap<Long, DynamicObject>(xplanorderLogs.length);
        for (DynamicObject dyn : xplanorderLogs) {
            xplanorderLogMap.put(dyn.getLong("xbillid"), dyn);
        }
        return xplanorderLogMap;
    }
}

