/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.opplugin.planexecute;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class XPlanOrderChangeValidator
extends AbstractValidator {
    public void validate() {
        HashSet<Long> sourceids = new HashSet<Long>(this.getDataEntities().length);
        HashSet<Long> ids = new HashSet<Long>(this.getDataEntities().length);
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            DynamicObject xPlanOrder = extendedDataEntity.getDataEntity();
            Long sourceid = xPlanOrder.getLong("sourceid");
            sourceids.add(sourceid);
            Long id = xPlanOrder.getLong("id");
            ids.add(id);
        }
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>(3);
        qfilters.add(new QFilter("sourceid", "in", sourceids));
        qfilters.add(new QFilter("id", "not in", ids));
        qfilters.add(new QFilter("billstatus", "!=", (Object)"C"));
        DynamicObject[] xplanOrders = BusinessDataServiceHelper.load((String)"mrp_xplanorder", (String)"id,sourceid,issysgen", (QFilter[])qfilters.toArray(new QFilter[0]));
        HashMap<Long, DynamicObject> xplanOrderMap = new HashMap<Long, DynamicObject>(xplanOrders.length);
        for (DynamicObject xplanOrder : xplanOrders) {
            if (xplanOrderMap.get(xplanOrder.getLong("sourceid")) != null && !xplanOrder.getBoolean("issysgen")) continue;
            xplanOrderMap.put(xplanOrder.getLong("sourceid"), xplanOrder);
        }
        DynamicObject[] dynamicObjectArray = BusinessDataServiceHelper.load((String)"mrp_planorder", (String)"id,orderqty,dropqty,availabledate,tracknumber,supplier", (QFilter[])new QFilter[]{new QFilter("id", "in", sourceids)});
        HashMap<Long, BigDecimal> planOrderQtyMap = new HashMap<Long, BigDecimal>(dynamicObjectArray.length);
        HashMap<Long, DynamicObject> planOrderMap = new HashMap<Long, DynamicObject>(dynamicObjectArray.length);
        for (DynamicObject dynamicObject : dynamicObjectArray) {
            Long planOrderId = dynamicObject.getLong("id");
            BigDecimal orderQty = dynamicObject.getBigDecimal("orderqty");
            BigDecimal dropQty = dynamicObject.getBigDecimal("dropqty");
            planOrderQtyMap.put(planOrderId, orderQty.subtract(dropQty));
            planOrderMap.put(planOrderId, dynamicObject);
        }
        for (DynamicObject dynamicObject : this.getDataEntities()) {
            DynamicObject xPlanOrder = dynamicObject.getDataEntity();
            Long sourceid = xPlanOrder.getLong("sourceid");
            DynamicObject xplanOrderOld = (DynamicObject)xplanOrderMap.get(sourceid);
            if (xplanOrderOld != null && (!xPlanOrder.getBoolean("issysgen") || xPlanOrder.getBoolean("issysgen") && xplanOrderOld.getBoolean("issysgen")) && !"audit".equals(this.getOperateKey())) {
                this.addErrorMessage((ExtendedDataEntity)dynamicObject, ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u53d8\u66f4\u5355\u3002", (String)"XPlanOrderChangeValidator_5", (String)"mmc-mrp-opplugin", (Object[])new Object[0]));
            }
            BigDecimal changeQty = xPlanOrder.getBigDecimal("changeqty");
            BigDecimal orderQty = (BigDecimal)planOrderQtyMap.get(sourceid);
            if (orderQty.compareTo(changeQty) < 0) {
                this.addErrorMessage((ExtendedDataEntity)dynamicObject, ResManager.loadKDString((String)"\u6570\u91cf\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u201c\u539f\u8ba1\u5212\u8ba2\u5355-\u8ba2\u5355\u6570\u91cf-\u6295\u653e\u6570\u91cf\u201d\u3002", (String)"XPlanOrderChangeValidator_0", (String)"mmc-mrp-opplugin", (Object[])new Object[0]));
            } else {
                planOrderQtyMap.put(sourceid, orderQty.subtract(changeQty));
            }
            DynamicObject planOrder = (DynamicObject)planOrderMap.get(sourceid);
            String changetype = xPlanOrder.getString("changetype");
            if (StringUtils.isBlank((CharSequence)changetype)) {
                this.addErrorMessage((ExtendedDataEntity)dynamicObject, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u53d8\u66f4\u7c7b\u578b\u3002", (String)"XPlanOrderChangeValidator_1", (String)"mmc-mrp-opplugin", (Object[])new Object[0]));
            }
            this.checkDate((ExtendedDataEntity)dynamicObject, xPlanOrder, planOrder, changetype);
        }
    }

    private void checkDate(ExtendedDataEntity rowDataEntity, DynamicObject xPlanOrder, DynamicObject planOrder, String changetype) {
        Date changeDate = xPlanOrder.getDate("changedate");
        Date availableDate = planOrder.getDate("availabledate");
        Long changtracknumberId = 0L;
        Long tracknumberId = 0L;
        DynamicObject changtracknumber = xPlanOrder.getDynamicObject("changtracknumber");
        DynamicObject tracknumber = planOrder.getDynamicObject("tracknumber");
        if (changtracknumber != null) {
            changtracknumberId = changtracknumber.getLong("id");
        }
        if (tracknumber != null) {
            tracknumberId = tracknumber.getLong("id");
        }
        Long changSupplierId = 0L;
        Long supplierId = 0L;
        DynamicObject changsupplier = xPlanOrder.getDynamicObject("changtracknumber");
        DynamicObject supplier = planOrder.getDynamicObject("tracknumber");
        if (changsupplier != null) {
            changSupplierId = changsupplier.getLong("id");
        }
        if (supplier != null) {
            supplierId = supplier.getLong("id");
        }
        if ("A".equals(changetype) && (changeDate == null || availableDate.compareTo(changeDate) <= 0)) {
            this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u53d8\u66f4\u7c7b\u578b\u63d0\u524d\u65f6\uff0c\u53ef\u7528\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u539f\u8ba1\u5212\u8ba2\u5355\u53ef\u7528\u65f6\u95f4\u3002", (String)"XPlanOrderChangeValidator_2", (String)"mmc-mrp-opplugin", (Object[])new Object[0]));
        } else if ("B".equals(changetype) && (changeDate == null || availableDate.compareTo(changeDate) >= 0)) {
            this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u53d8\u66f4\u7c7b\u578b\u5ef6\u540e\u65f6\uff0c\u53ef\u7528\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u539f\u8ba1\u5212\u8ba2\u5355\u53ef\u7528\u65f6\u95f4\u3002", (String)"XPlanOrderChangeValidator_3", (String)"mmc-mrp-opplugin", (Object[])new Object[0]));
        } else if ("D".equals(changetype) && tracknumberId.equals(changtracknumberId)) {
            this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u53d8\u66f4\u7c7b\u578b\u76f4\u63a5\u632a\u7528\u65f6\uff0c\u8ddf\u8e2a\u53f7\u4e0d\u80fd\u7b49\u4e8e\u539f\u8ba1\u5212\u8ba2\u5355\u8ddf\u8e2a\u53f7\u3002", (String)"XPlanOrderChangeValidator_4", (String)"mmc-mrp-opplugin", (Object[])new Object[0]));
        } else if ("D".equals(changetype) && supplierId.equals(changSupplierId)) {
            this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u53d8\u66f4\u7c7b\u578b\u76f4\u63a5\u632a\u7528\u65f6\uff0c\u4f9b\u5e94\u5546\u4e0d\u80fd\u7b49\u4e8e\u539f\u8ba1\u5212\u8ba2\u5355\u4f9b\u5e94\u5546\u3002", (String)"XPlanOrderChangeValidator_6", (String)"mmc-mrp-opplugin", (Object[])new Object[0]));
        }
    }
}

