/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.opplugin.pls.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class SchemeSaveValidator
extends AbstractValidator {
    public void validate() {
        HashSet<Integer> uniqueSet = new HashSet<Integer>();
        HashMap<String, Integer> materialCountMap = new HashMap<String, Integer>(16);
        HashMap<String, Integer> materialGroupCountMap = new HashMap<String, Integer>(16);
        ArrayList<String> noWorkList = new ArrayList<String>(10);
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            this.validateWorkShift(extendedDataEntity);
            this.validateMaterialCategory(extendedDataEntity, uniqueSet, noWorkList);
            this.validateCalcResult(extendedDataEntity, materialCountMap, materialGroupCountMap, noWorkList);
        }
    }

    private void validateWorkShift(ExtendedDataEntity extendedDataEntity) {
        Boolean isClassSystem = (Boolean)extendedDataEntity.getValue("isclasssystem");
        Long classSystemId = (Long)extendedDataEntity.getValue("classsystem_id");
        Long workShiftId = (Long)extendedDataEntity.getValue("workshift_id");
        if (isClassSystem.booleanValue() && classSystemId == 0L) {
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u542f\u7528\u73ed\u5236\u65f6\uff0c\u201c\u73ed\u5236\u201d\u4e3a\u5fc5\u586b\u9879\u3002", (String)"SchemeSaveValidator_5", (String)"mmc-mrp-opplugin", (Object[])new Object[0]), new Object[0]));
        }
        if (!isClassSystem.booleanValue() && workShiftId == 0L) {
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u672a\u542f\u7528\u73ed\u5236\u65f6\uff0c\u201c\u73ed\u6b21\u201d\u4e3a\u5fc5\u586b\u9879\u3002", (String)"SchemeSaveValidator_6", (String)"mmc-mrp-opplugin", (Object[])new Object[0]), new Object[0]));
        }
    }

    private void validateCalcResult(ExtendedDataEntity extendedDataEntity, Map<String, Integer> materialCountMap, Map<String, Integer> materialGroupCountMap, List<String> noWorkList) {
        DynamicObjectCollection workCenterColl = extendedDataEntity.getDataEntity().getDynamicObjectCollection("workcenterentry");
        for (DynamicObject workCenter : workCenterColl) {
            String key;
            int seq = workCenter.getInt("seq");
            long workCenterId = workCenter.getLong("workcenter_number_id");
            DynamicObjectCollection calcResultColl = workCenter.getDynamicObjectCollection("calcresultsubentry");
            for (DynamicObject calcResult : calcResultColl) {
                int count;
                String category = calcResult.getString("category_2");
                String id = "A".equals(category) ? "material_2_id" : "materialgroup_2_id";
                String number = "A".equals(category) ? "material_2.masterid.number" : "materialgroup_2.number";
                Long materialId = calcResult.getLong(id);
                String materialNumber = calcResult.getString(number);
                if (noWorkList.contains(workCenterId + "_" + materialId)) continue;
                boolean isPartInCalc = calcResult.getBoolean("ispartincalc_1");
                String key2 = Long.toString(workCenterId).concat("_").concat(materialNumber);
                if ("A".equals(category)) {
                    count = materialCountMap.computeIfAbsent(key2, k -> 0);
                    materialCountMap.put(key2, isPartInCalc ? count + 1 : count);
                    continue;
                }
                count = materialGroupCountMap.computeIfAbsent(key2, k -> 0);
                materialGroupCountMap.put(key2, isPartInCalc ? count + 1 : count);
            }
            for (Map.Entry<String, Integer> entry : materialCountMap.entrySet()) {
                int count = entry.getValue();
                if (count == 1) continue;
                key = entry.getKey();
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u201c\u5de5\u4f5c\u4e2d\u5fc3\u5206\u5f55\u201d\u7b2c%d\u884c,\u201c\u8ba1\u7b97\u7ed3\u679c\u9879\u5b50\u5206\u5f55\u201d\u7269\u6599\u201c%s\u201d\u6709\u4e14\u53ea\u6709\u4e00\u884c\u80fd\u53c2\u4e0e\u6392\u7a0b\u8ba1\u7b97\u3002", (String)"SchemeSaveValidator_0", (String)"mmc-mrp-opplugin", (Object[])new Object[0]), seq, key.substring(key.indexOf(95) + 1)));
            }
            for (Map.Entry<String, Integer> entry : materialGroupCountMap.entrySet()) {
                int count = entry.getValue();
                if (count == 1) continue;
                key = entry.getKey();
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u201c\u5de5\u4f5c\u4e2d\u5fc3\u5206\u5f55\u201d\u7b2c%d\u884c,\u201c\u8ba1\u7b97\u7ed3\u679c\u9879\u5b50\u5206\u5f55\u201d\u7269\u6599\u63a7\u5236\u7ec4\u201c%s\u201d\u6709\u4e14\u53ea\u6709\u4e00\u884c\u80fd\u53c2\u4e0e\u6392\u7a0b\u8ba1\u7b97\u3002", (String)"SchemeSaveValidator_1", (String)"mmc-mrp-opplugin", (Object[])new Object[0]), seq, key.substring(key.indexOf(95) + 1)));
            }
            materialCountMap.clear();
            materialGroupCountMap.clear();
        }
    }

    private void validateMaterialCategory(ExtendedDataEntity extendedDataEntity, Set<Integer> uniqueSet, List<String> noWorkList) {
        DynamicObjectCollection materialCategories = extendedDataEntity.getDataEntity().getDynamicObjectCollection("matcategoryentry");
        for (DynamicObject materialCategory : materialCategories) {
            int seq = materialCategory.getInt("seq");
            String category = materialCategory.getString("category");
            String key = "A".equals(category) ? "material_id" : "materialgroup_id";
            String name = "A".equals(category) ? ResManager.loadKDString((String)"\u7269\u6599", (String)"SchemeSaveValidator_7", (String)"mmc-mrp-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7269\u6599\u63a7\u5236\u7ec4", (String)"SchemeSaveValidator_8", (String)"mmc-mrp-opplugin", (Object[])new Object[0]);
            long materialId = materialCategory.getLong(key);
            if (materialId == 0L) {
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7269\u6599\u7c7b\u522b\u5206\u5f55\u201d\u7b2c%d\u884c:\u201c%s\u201d\u3002", (String)"SchemeSaveValidator_9", (String)"mmc-mrp-opplugin", (Object[])new Object[0]), seq, name));
                continue;
            }
            DynamicObjectCollection workCenters = materialCategory.getDynamicObjectCollection("workcentersubentry");
            for (DynamicObject workCenter : workCenters) {
                long workCenterId = workCenter.getLong("workcenter_id");
                int priority = workCenter.getInt("priority");
                if (priority == 0) {
                    noWorkList.add(workCenterId + "_" + materialId);
                }
                if (priority == 0 || uniqueSet.add(priority)) continue;
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u201c\u7269\u6599\u7c7b\u522b\u5206\u5f55\u201d\u7b2c%1$d\u884c,\u201c\u5de5\u4f5c\u4e2d\u5fc3\u5b50\u5206\u5f55\u201d\u5b58\u5728\u76f8\u540c\u7684\u4f18\u5148\u7ea7: %2$d\u3002", (String)"SchemeSaveValidator_4", (String)"mmc-mrp-opplugin", (Object[])new Object[0]), seq, priority));
            }
            uniqueSet.clear();
        }
    }
}

