/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.opplugin.pls.validator;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class WorkShiftEntryValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            DynamicObjectCollection workCenterEntry = dataEntity.getDynamicObjectCollection("workcenterentry");
            for (int i = 0; i < workCenterEntry.size(); ++i) {
                DynamicObject workCenter = (DynamicObject)workCenterEntry.get(i);
                DynamicObjectCollection workShiftEntry = workCenter.getDynamicObjectCollection("workshiftentry");
                this.isTimeRepeat(extendedDataEntity, workShiftEntry, i);
            }
        }
    }

    private void isTimeRepeat(ExtendedDataEntity extendedDataEntity, DynamicObjectCollection col, int workCenterRow) {
        BigDecimal sumWorkTime = BigDecimal.ZERO;
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject entry = (DynamicObject)col.get(i);
            boolean isJoinCal = entry.getBoolean("iscal");
            if (!isJoinCal) continue;
            int workStartTime = entry.getInt("workstarttime");
            int workEndTime = entry.getInt("workendtime");
            BigDecimal workTime = entry.getBigDecimal("worktime");
            boolean isCrossDay = entry.getBoolean("iscrossday");
            sumWorkTime = sumWorkTime.add(workTime);
            if (workStartTime < 0) {
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5de5\u4f5c\u4e2d\u5fc3\u5bf9\u5e94\u7684\u73ed\u6b21\u80fd\u529b\u5206\u5f55\u7b2c%2$s\u884c\u5de5\u4f5c\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WorkShiftEntryValidator_0", (String)"mmc-mrp-opplugin", (Object[])new Object[0]), workCenterRow + 1, i + 1));
            }
            if (workEndTime < 0) {
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5de5\u4f5c\u4e2d\u5fc3\u5bf9\u5e94\u7684\u73ed\u6b21\u80fd\u529b\u5206\u5f55\u7b2c%2$s\u5de5\u4f5c\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WorkShiftEntryValidator_1", (String)"mmc-mrp-opplugin", (Object[])new Object[0]), workCenterRow + 1, i + 1));
            }
            for (int j = i + 1; j < col.size(); ++j) {
                DynamicObject obj = (DynamicObject)col.get(j);
                boolean isCal = obj.getBoolean("iscal");
                if (!isCal) continue;
                int start = obj.getInt("workstarttime");
                int end = obj.getInt("workendtime");
                boolean cross = obj.getBoolean("iscrossday");
                boolean flag = this.compareDay(isCrossDay, cross, workStartTime, workEndTime, start, end);
                boolean flag1 = this.compareDay1(isCrossDay, cross, workStartTime, workEndTime, start, end);
                boolean flag2 = this.compareDay2(isCrossDay, cross, workStartTime, workEndTime, start, end);
                if (!flag && !flag1 && !flag2) continue;
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5de5\u4f5c\u4e2d\u5fc3\u5bf9\u5e94\u7684\u73ed\u6b21\u80fd\u529b\u5206\u5f55\u65f6\u95f4\u6bb5\u6709\u91cd\u53e0\u3002", (String)"WorkShiftEntryValidator_2", (String)"mmc-mrp-opplugin", (Object[])new Object[0]), workCenterRow + 1));
            }
        }
        if (sumWorkTime.compareTo(new BigDecimal(24)) > 0) {
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5de5\u4f5c\u4e2d\u5fc3\u5bf9\u5e94\u7684\u73ed\u6b21\u80fd\u529b\u5206\u5f55\u5de5\u4f5c\u65f6\u957f\u8d85\u8fc724\u5c0f\u65f6\u3002", (String)"WorkShiftEntryValidator_3", (String)"mmc-mrp-opplugin", (Object[])new Object[0]), workCenterRow + 1));
        }
    }

    private boolean compareDay(boolean isCrossDay, boolean cross, int workStartTime, int workEndTime, int start, int end) {
        boolean flag = isCrossDay && !cross && (workStartTime <= end || workEndTime >= start);
        return flag;
    }

    private boolean compareDay1(boolean isCrossDay, boolean cross, int workStartTime, int workEndTime, int start, int end) {
        boolean flag = !isCrossDay && !cross && Math.max(workStartTime, start) <= Math.min(workEndTime, end);
        return flag;
    }

    private boolean compareDay2(boolean isCrossDay, boolean cross, int workStartTime, int workEndTime, int start, int end) {
        boolean flag = !isCrossDay && cross && (workEndTime >= start || workStartTime <= end);
        return flag;
    }
}

