/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.opplugin.simulationplan;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mrp.opplugin.simulationplan.SimulationBillValidator;

public class SimulationBillOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("material");
        e.getFieldKeys().add("configuredcode");
        e.getFieldKeys().add("auxpty");
        e.getFieldKeys().add("closeuser");
        e.getFieldKeys().add("closedate");
        e.getFieldKeys().add("closestatus");
        e.getFieldKeys().add("entryentity.seq");
        e.getFieldKeys().add("runlog");
        e.getFieldKeys().add("plan");
        e.getFieldKeys().add("requiredate");
        e.getFieldKeys().add("requiretype");
        e.getFieldKeys().add("sourcetype");
        e.getFieldKeys().add("billid");
        e.getFieldKeys().add("billentryid");
        e.getFieldKeys().add("billentrykey");
        e.getFieldKeys().add("billnumber");
        e.getFieldKeys().add("rowno");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String key = e.getOperationKey();
        DynamicObject[] entities = e.getDataEntities();
        DynamicObject userObj = BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getCurrUserId(), (String)"bos_user");
        ArrayList<DynamicObject> col = new ArrayList<DynamicObject>(entities.length);
        ArrayList<String> runLogList = new ArrayList<String>(entities.length);
        for (int i = 0; i < entities.length; ++i) {
            if ("bizclose".equals(key)) {
                entities[i].set("closestatus", (Object)"A");
                entities[i].set("closeuser", (Object)userObj);
                entities[i].set("closedate", (Object)new Date());
                col.add(entities[i]);
                continue;
            }
            if ("bizunclose".equals(key)) {
                entities[i].set("closestatus", (Object)"B");
                entities[i].set("closeuser", null);
                entities[i].set("closedate", null);
                col.add(entities[i]);
                continue;
            }
            if ("delete".equals(key)) {
                if (entities[i].getDynamicObject("runlog") == null) continue;
                runLogList.add(entities[i].getDynamicObject("runlog").getString("number"));
                continue;
            }
            if ("audit".equals(key)) {
                DynamicObject dynamicObject = entities[i];
                DynamicObjectCollection entrys = dynamicObject.getDynamicObjectCollection("entryentity");
                entrys.forEach(en -> {
                    if ("B".equals(en.getString("sourcetype"))) {
                        en.set("billid", dynamicObject.getPkValue());
                        en.set("billentryid", en.getPkValue());
                        en.set("billentrykey", (Object)"entryentity");
                        en.set("billnumber", dynamicObject.get("billno"));
                        en.set("rowno", (Object)en.getInt("seq"));
                    }
                });
                continue;
            }
            if (!"save".equals(key) && !"submit".equals(key)) continue;
            this.changeAndClear(entities[i]);
        }
        if (!col.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])col.toArray(new DynamicObject[0]));
        }
        if (!runLogList.isEmpty()) {
            DeleteServiceHelper.delete((String)"mrp_simcolorder", (QFilter[])new QFilter[]{new QFilter("planoperatenum", "in", runLogList)});
            DeleteServiceHelper.delete((String)"mrp_simulateorder", (QFilter[])new QFilter[]{new QFilter("planoperatenum", "in", runLogList)});
            DeleteServiceHelper.delete((String)"mrp_caculate_log", (QFilter[])new QFilter[]{new QFilter("number", "in", runLogList)});
            DeleteServiceHelper.delete((String)"mrp_simulationdetail", (QFilter[])new QFilter[]{new QFilter("caculatelog", "in", runLogList)});
        }
    }

    private void changeAndClear(DynamicObject obj) {
        boolean flag = false;
        Iterable properties = obj.getDataEntityState().getBizChangedProperties();
        for (Object ide : properties) {
            if (!"abctype".equals(ide.getName())) continue;
            flag = true;
            break;
        }
        if (flag) {
            this.clearData(obj);
            return;
        }
        DynamicObjectCollection col = obj.getDynamicObjectCollection("entryentity");
        block12: for (DynamicObject entry : col) {
            properties = entry.getDataEntityState().getBizChangedProperties();
            for (IDataEntityProperty ide : properties) {
                switch (ide.getName()) {
                    case "requireorg": 
                    case "material": 
                    case "qty": 
                    case "requiredate": 
                    case "tracknumber": 
                    case "configuredcode": {
                        flag = true;
                        break block12;
                    }
                }
            }
        }
        if (flag) {
            this.clearData(obj);
            return;
        }
        DynamicObjectCollection query = QueryServiceHelper.query((String)obj.getDataEntityType().getName(), (String)"id,entryentity.id entryid", (QFilter[])new QFilter[]{new QFilter("id", "=", obj.getPkValue())});
        if (query.size() != col.size()) {
            this.clearData(obj);
            return;
        }
    }

    private void clearData(DynamicObject obj) {
        obj.set("simulationuser", null);
        obj.set("simulationstatus", (Object)"A");
        obj.set("runlog", null);
        obj.getDynamicObjectCollection("treeentryentity").clear();
        obj.getDynamicObjectCollection("fieldentry").clear();
        obj.getDynamicObjectCollection("groupentryentity").clear();
        obj.getDynamicObjectCollection("entryentity").forEach(entry -> {
            entry.set("deliverydate", null);
            entry.set("promisedate", null);
            entry.set("invqty", (Object)BigDecimal.ZERO);
            entry.set("wayqty", (Object)BigDecimal.ZERO);
        });
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new SimulationBillValidator());
    }
}

