/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.opplugin.simulationplan;

import java.util.Calendar;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mrp.business.helper.GlobalPlanHelper;
import kd.mmc.mrp.common.util.DynamicObjDataUtil;
import kd.mmc.mrp.model.date.OrgBasedCalendarModel;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mpscmm.msplan.mrp.business.helper.PlanOrderHelper;

public class SimulationBillValidator
extends AbstractValidator {
    public void validate() {
        block6: {
            String operate;
            block5: {
                operate = this.getOperateKey();
                if (!"save".equals(operate) && !"submit".equals(operate) && !"audit".equals(operate)) break block5;
                Calendar instance = Calendar.getInstance();
                OrgBasedCalendarModel.nomalize((Calendar)instance);
                Date time = instance.getTime();
                int maxRowCount = 200;
                DynamicObject queryOne = QueryServiceHelper.queryOne((String)"mrp_runconfig", (String)"id,param", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)EnvCfgItem.SIMULATE_MAX_ROW_COUNT.name())});
                if (queryOne != null) {
                    maxRowCount = queryOne.getInt("param");
                }
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject obj = dataEntity.getDataEntity();
                    DynamicObjectCollection col = obj.getDynamicObjectCollection("entryentity");
                    if (col.size() > maxRowCount) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6a21\u62df\u6982\u8981\u884c\u6570\u8d85\u8fc7[\u9009\u5355/\u6a21\u62df\u6700\u5927\u884c\u6570\u63a7\u5236(%s)]", (String)"SimulationBillValidator_4", (String)"mmc-mrp-opplugin", (Object[])new Object[0]), maxRowCount));
                    }
                    for (DynamicObject entry : col) {
                        this.checkAuxptyAndConfiguredCode(dataEntity, entry);
                        this.checkRequireDate(dataEntity, entry, time);
                    }
                }
                break block6;
            }
            if (!"unaudit".equals(operate) && !"bizclose".equals(operate)) break block6;
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                DynamicObject obj = dataEntity.getDataEntity();
                Long planId = DynamicObjDataUtil.getDynamicObjectPK((DynamicObject)obj.getDynamicObject("plan"));
                if (!GlobalPlanHelper.isExistMRPRunning((Long)planId)) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u6a21\u62df\u65b9\u6848\u5b58\u5728\u6b63\u5728\u8fd0\u884c\u7684\u8ba1\u5212\uff0c\u8bf7\u7b49\u5f85\u8fd0\u7b97\u7ed3\u675f\u6216\u7ec8\u6b62\u8fd0\u7b97\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"SimulationBillValidator_2", (String)"mmc-mrp-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private void checkAuxptyAndConfiguredCode(ExtendedDataEntity dataEntity, DynamicObject entry) {
        DynamicObject material = entry.getDynamicObject("material");
        if (material == null) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6a21\u62df\u6982\u8981\u7b2c[%s]\u884c\u7269\u6599\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SimulationBillValidator_5", (String)"mmc-mrp-opplugin", (Object[])new Object[0]), entry.get("seq")));
            return;
        }
        DynamicObject auxpty = entry.getDynamicObject("auxpty");
        if ("2".equals(material.getString("configproperties")) && entry.getDynamicObject("configuredcode") == null) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6a21\u62df\u6982\u8981\u7b2c[%s]\u884c\u914d\u7f6e\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SimulationBillValidator_0", (String)"mmc-mrp-opplugin", (Object[])new Object[0]), entry.get("seq")));
        }
        if (PlanOrderHelper.dealAuxptyEntry((DynamicObject)material, (DynamicObject)auxpty)) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6a21\u62df\u6982\u8981\u7b2c[%s]\u884c\u5f71\u54cd\u8ba1\u5212\u7684\u8f85\u52a9\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SimulationBillValidator_1", (String)"mmc-mrp-opplugin", (Object[])new Object[0]), entry.get("seq")));
        }
    }

    private void checkRequireDate(ExtendedDataEntity dataEntity, DynamicObject entry, Date time) {
        if ("B".equals(entry.getString("sourcetype")) && entry.getDate("requiredate").before(time)) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6a21\u62df\u6982\u8981\u7b2c[%s]\u884c\u624b\u5de5\u5f55\u5165\u5206\u5f55\u7684\u9700\u6c42\u65e5\u671f\u9700\u5927\u4e8e\u7b49\u4e8e\u7cfb\u7edf\u5f53\u524d\u65e5\u671f\u3002", (String)"SimulationBillValidator_3", (String)"mmc-mrp-opplugin", (Object[])new Object[0]), entry.get("seq")));
        }
    }
}

