/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.controlnode.framework.runner;

import com.alibaba.fastjson.JSON;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.mmc.mrp.controlnode.framework.mq.consumer.MRPControllerNodeConsumer;
import kd.mmc.mrp.controlnode.framework.runner.worker.MRPRunner;
import kd.mmc.mrp.controlnode.framework.step.MRPMParallelExecuteStep;
import kd.mmc.mrp.controlnode.framework.step.MRPMRunEnd;
import kd.mmc.mrp.controlnode.framework.step.MRPMRunStart;
import kd.mmc.mrp.exception.MRPBizException;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.runner.AbstractMRPRunner;
import kd.mmc.mrp.framework.step.IMRPStep;
import kd.mmc.mrp.model.enums.status.MRPExecuteStatus;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class MRPRunner4Config
extends AbstractMRPRunner {
    protected List<IMRPStep> steps;

    protected synchronized List<IMRPStep> prepareCalcSteps() {
        if (this.steps == null) {
            this.steps = new ArrayList<IMRPStep>();
            this.initSteps(this.ctx);
        }
        return this.steps;
    }

    protected void initSteps(IMRPEnvProvider ctx) {
        String runMode = ctx.getRunMode();
        String planOrgId = ctx.getRunLogPlanOrgId();
        DynamicObject bizPlan = this.getBusinessConfig(runMode, planOrgId);
        ArrayList<IMRPStep> stepList = new ArrayList<IMRPStep>();
        stepList.add((IMRPStep)new MRPMRunStart(ctx));
        if (bizPlan == null) {
            String planOrgName = ctx.getRunLogPlanOrgName();
            String runModeName = ctx.getRunModeName();
            ErrorCode errorCode = new ErrorCode("MRPRunner4Config", String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u7ec4\u7ec7\uff08%1$s\uff09- \u8ba1\u7b97\u65b9\u6848\u914d\u7f6e - (%2$s)\u4e1a\u52a1\u65b9\u6848\u914d\u7f6e\u672a\u627e\u5230", (String)"MRPRunner4Config_0", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), planOrgName, runModeName));
            stepList.clear();
            stepList.add((IMRPStep)new MRPMRunEnd(ctx, (Throwable)new MRPBizException(errorCode), MRPExecuteStatus.ERROR_STOP));
        } else {
            this.initStepByConfig(bizPlan, stepList);
        }
        this.steps = stepList;
    }

    protected void initStepByConfig(DynamicObject bizPlan, List<IMRPStep> stepList) {
        try {
            String xmlStr = bizPlan.getString("xml_tag");
            String cellsdata = bizPlan.getString("cellsdata_tag");
            Map cellsDataMap = (Map)JSON.parse((String)cellsdata);
            Document document = DocumentHelper.parseText((String)xmlStr);
            Element root = document.getRootElement();
            List mxCellElements = root.elements();
            this.ctx.preLoadSysConfiguration();
            HashMap<String, Set<String>> targetRelations = new HashMap<String, Set<String>>();
            HashMap<String, Set<String>> sourceRelations = new HashMap<String, Set<String>>();
            HashMap<String, IMRPStep> steps = new HashMap<String, IMRPStep>();
            Boolean isParallel = false;
            for (Element cell : mxCellElements) {
                String vertex = cell.attributeValue("vertex");
                if ("1".equals(vertex)) {
                    String id = cell.attributeValue("id");
                    IMRPStep step = this.getIMRPStep(cellsDataMap, id, this.ctx);
                    steps.put(id, step);
                    continue;
                }
                String edge = cell.attributeValue("edge");
                if (!"1".equalsIgnoreCase(edge)) continue;
                String sourceId = cell.attributeValue("source");
                String targetId = cell.attributeValue("target");
                Set targets = targetRelations.getOrDefault(sourceId, new HashSet());
                targets.add(targetId);
                targetRelations.put(sourceId, targets);
                Set sources = sourceRelations.getOrDefault(targetId, new HashSet());
                sources.add(sourceId);
                sourceRelations.put(targetId, sources);
                if (isParallel.booleanValue()) continue;
                isParallel = targets.size() > 1;
            }
            if (isParallel.booleanValue()) {
                stepList.add(new MRPMParallelExecuteStep(this.ctx, targetRelations, sourceRelations, steps));
            } else {
                this.setSteps(stepList, mxCellElements, cellsDataMap, this.ctx);
            }
            stepList.add((IMRPStep)new MRPMRunEnd(this.ctx, null, MRPExecuteStatus.FINISHED));
        }
        catch (Exception e) {
            stepList.clear();
            stepList.add((IMRPStep)new MRPMRunEnd(this.ctx, e, MRPExecuteStatus.ERROR_STOP));
        }
    }

    private void setSteps(List<IMRPStep> stepList, List<Element> mxCellElements, Map<String, Map<String, String>> cellsDataMap, IMRPEnvProvider ctx) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        HashMap<String, Set<String>> setMap = new HashMap<String, Set<String>>();
        HashSet<String> root = new HashSet<String>();
        setMap.put("-1", root);
        for (Element cell : mxCellElements) {
            String vertex = cell.attributeValue("vertex");
            String id = cell.attributeValue("id");
            if (!"1".equals(vertex)) continue;
            root.add(id);
        }
        for (Element cell : mxCellElements) {
            String edge = cell.attributeValue("edge");
            String sourceId = cell.attributeValue("source");
            String targetId = cell.attributeValue("target");
            if (!"1".equalsIgnoreCase(edge)) continue;
            Set target = setMap.getOrDefault(sourceId, new HashSet());
            target.add(targetId);
            setMap.put(sourceId, target);
            root.remove(targetId);
        }
        this.dfsSetStep(stepList, root, setMap, cellsDataMap, ctx);
    }

    private void dfsSetStep(List<IMRPStep> stepList, Set<String> root, Map<String, Set<String>> setMap, Map<String, Map<String, String>> cellsDataMap, IMRPEnvProvider ctx) throws ClassNotFoundException, InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        if (root == null) {
            return;
        }
        for (String sourceId : root) {
            IMRPStep step = this.getIMRPStep(cellsDataMap, sourceId, ctx);
            if (step != null) {
                stepList.add(step);
            }
            Set<String> next = setMap.get(sourceId);
            this.dfsSetStep(stepList, next, setMap, cellsDataMap, ctx);
        }
    }

    private IMRPStep getIMRPStep(Map<String, Map<String, String>> cellsDataMap, String sourceId, IMRPEnvProvider ctx) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException {
        Map<String, String> data = cellsDataMap.get(sourceId);
        if (data == null) {
            return null;
        }
        Long algoModuleId = Long.valueOf(data.get("algomodel"));
        String selectName = data.get("selectname") == null ? null : data.get("selectname");
        DynamicObject algoModule = QueryServiceHelper.queryOne((String)"mrp_algoregister", (String)String.format("%s,%s", "algoimpletcalss", "name"), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)algoModuleId)});
        selectName = selectName == null ? algoModule.getString("name") : selectName;
        String implClassName = algoModule.getString("algoimpletcalss");
        Class<?> c = Class.forName(implClassName);
        Constructor<?>[] constructors = c.getConstructors();
        Constructor<?> con = null;
        for (Constructor<?> constructor : constructors) {
            if (constructor == null || constructor.getParameterTypes().length != 1 || constructor.getParameterTypes()[0] != IMRPEnvProvider.class) continue;
            con = constructor;
            break;
        }
        if (con == null) {
            return null;
        }
        IMRPStep implClass = (IMRPStep)con.newInstance(ctx);
        implClass.setStepDescByNodeName(selectName);
        return implClass;
    }

    protected DynamicObject getBusinessConfig(String runMode, String planOrgId) {
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterOrg = new QFilter("createorg", "=", (Object)Long.valueOf(planOrgId));
        QFilter qFilter = new QFilter("entryentity.runtype", "=", (Object)runMode);
        DynamicObject calPlan = QueryServiceHelper.queryOne((String)"mrp_calplanconfig", (String)"entryentity.bizplan bizplan", (QFilter[])new QFilter[]{qFilter, qFilterEnable, qFilterOrg, qFilterStatus});
        if (calPlan != null) {
            Object bizPlanId = calPlan.get("bizplan");
            return QueryServiceHelper.queryOne((String)"mrp_businessplan", (String)"xml_tag,cellsdata_tag", (QFilter[])new QFilter[]{new QFilter("id", "=", bizPlanId)});
        }
        return null;
    }

    public void initMRPControllerMQ() {
        this.ctx.getMQManager().registControlQueue(this.ctx, MRPControllerNodeConsumer.class);
    }

    protected void calc(List<IMRPStep> steps) {
        ThreadPools.executeOnceIncludeRequestContext((String)("MRPMainRunner-lognum-" + this.ctx.getRunLogNumber()), (Runnable)new MRPRunner(this.ctx, steps, this));
    }
}

