/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.controlnode.framework.step;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.cache.MRPCacheManager;
import kd.mmc.mrp.framework.consts.MRPRuntimeConsts;
import kd.mmc.mrp.framework.consts.Tips;
import kd.mmc.mrp.framework.step.AbstractMRPStep;
import kd.mmc.mrp.integrate.entity.PlanModel;
import kd.mmc.mrp.utils.ReserveUtil;

public class MRPGetReserveRecordData
extends AbstractMRPStep {
    public MRPGetReserveRecordData(IMRPEnvProvider ctx) {
        super(ctx);
    }

    protected void innerExecute() {
        PlanModel planModel = (PlanModel)this.ctx.getService(PlanModel.class);
        boolean isReserve = planModel.isReserve();
        if (isReserve) {
            HashSet enableMaterials = new HashSet(this.ctx.getEnableMaterialIds());
            Map rowDataMap = ReserveUtil.getReserveRecordByMaterials((IMRPEnvProvider)this.ctx, enableMaterials);
            for (Map.Entry entry : rowDataMap.entrySet()) {
                String cacheKey = MRPRuntimeConsts.getReserveRecordSplitKey((String)this.ctx.getMRPContextId(), (String)((String)entry.getKey()));
                this.dataAmount += ((List)entry.getValue()).size();
                MRPCacheManager.getInst().putSubData((CalEnv)this.ctx, "reserve_record", cacheKey, JSON.toJSONString(entry.getValue(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
            }
        }
    }

    public String getStepDesc(Locale locale) {
        return Tips.getReserveRecordData();
    }
}

