/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.controlnode.framework.step;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mrp.common.simulationplan.ReplaceMaterialEntity;
import kd.mmc.mrp.common.simulationplan.SimulationEntryEntity;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.consts.Tips;
import kd.mmc.mrp.framework.step.AbstractMRPStep;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mmc.mrp.utils.MRPUtil;

public class MRPMCalcInventoryQty
extends AbstractMRPStep {
    Map<String, ReplaceMaterialEntity> replaceMap;
    boolean isFlexPropMatch;

    public MRPMCalcInventoryQty(IMRPEnvProvider ctx) {
        super(ctx);
        this.isFlexPropMatch = (Boolean)this.ctx.getCfgValue(EnvCfgItem.ENABLE_MATERIAL_EXT_PROPS);
    }

    public String getStepDesc(Locale locale) {
        return Tips.getInventoryQty();
    }

    protected void innerExecute() {
        if (this.ctx.getCustomParams("simulationbillid") == null) {
            return;
        }
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)this.ctx.getCustomParams("simulationbillid"), (String)"mrp_simulation");
        this.getReplaceData();
        Map<String, String> fieldMap = this.getFieldMap(obj);
        DynamicObjectCollection treeEntrys = obj.getDynamicObjectCollection("treeentryentity");
        HashMap<String, List<SimulationEntryEntity>> map = new HashMap<String, List<SimulationEntryEntity>>(treeEntrys.size());
        Map<String, TreeNode> treeMap = this.buildTopTree(treeEntrys, fieldMap, map);
        List<Object> subList = new ArrayList(8);
        for (Map.Entry<String, TreeNode> entry : treeMap.entrySet()) {
            String reqsourcebillno = entry.getKey();
            TreeNode tree = entry.getValue();
            List list = (List)map.get(reqsourcebillno);
            subList = this.buildTree(tree, list);
            for (TreeNode treeNode : subList) {
                SimulationEntryEntity data = (SimulationEntryEntity)treeNode.getData();
                String pid = data.getPid();
                if (tree.getTreeNode(pid) == null) {
                    data.setInvFullSetQty(data.getInvQty());
                    data.setWayFullSetQty(data.getSupplyQty().subtract(data.getNewPlanOrderQty()));
                    data.setChildInvQty(BigDecimal.ZERO);
                    data.setChildWayQty(BigDecimal.ZERO);
                    continue;
                }
                this.calcTopQty(tree, treeNode);
            }
            this.updateSimulationEntry(obj, tree);
        }
        this.dataAmount += treeMap.size();
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
    }

    private Map<String, String> getFieldMap(DynamicObject obj) {
        DynamicObjectCollection fieldEntrys = obj.getDynamicObjectCollection("fieldentry");
        HashMap<String, String> fieldMap = new HashMap<String, String>(2);
        fieldMap.put("planorder", "");
        fieldMap.put("inv", "");
        for (DynamicObject entry : fieldEntrys) {
            if ("mrp_simulateorder".equals(entry.getString("fieldentity"))) {
                if (!ResManager.loadKDString((String)"\u65b0\u5efa\u8ba1\u5212\u8ba2\u5355", (String)"MRPMCalcInventoryQty_0", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]).equals(entry.getString("fieldname"))) continue;
                fieldMap.put("planorder", entry.getString("fieldkey"));
                continue;
            }
            if (!"im_inv_realbalance".equals(entry.getString("fieldentity"))) continue;
            fieldMap.put("inv", entry.getString("fieldkey"));
        }
        return fieldMap;
    }

    private void updateSimulationEntry(DynamicObject obj, TreeNode tree) {
        DynamicObjectCollection entryentity = obj.getDynamicObjectCollection("entryentity");
        SimulationEntryEntity row = (SimulationEntryEntity)tree.getData();
        entryentity.forEach(en -> {
            if (en.getString("billid").equals(row.getBillId()) && en.getString("billentryid").equals(row.getBillEntryId())) {
                en.set("invqty", (Object)row.getInvFullSetQty());
                en.set("wayqty", (Object)row.getWayFullSetQty());
            }
        });
    }

    private List<TreeNode> buildTree(TreeNode tree, List<SimulationEntryEntity> list) {
        for (SimulationEntryEntity entity : list) {
            String id = entity.getId();
            String pid = entity.getPid();
            if (tree.getTreeNode(pid) == null) continue;
            TreeNode parentNode = tree.getTreeNode(pid);
            TreeNode node2 = new TreeNode(pid, id, "", true, (Object)entity);
            parentNode.addChild(node2);
        }
        ArrayList<TreeNode> subList = new ArrayList<TreeNode>(8);
        tree.iterate(20, node -> {
            if (node.getChildren() == null || node.getChildren().isEmpty()) {
                subList.add((TreeNode)node);
            }
        });
        return subList;
    }

    private Map<String, TreeNode> buildTopTree(DynamicObjectCollection treeEntrys, Map<String, String> fieldMap, Map<String, List<SimulationEntryEntity>> map) {
        HashMap<String, TreeNode> treeMap = new HashMap<String, TreeNode>(treeEntrys.size());
        for (DynamicObject entry : treeEntrys) {
            String reqsourcebillno = entry.getString("d_reqsourcebillno");
            String pid = entry.getString("pid");
            String id = entry.getString("id");
            Integer level = entry.getInt("d_level");
            SimulationEntryEntity entity = new SimulationEntryEntity(id, pid, level.intValue());
            entity.setBillId(entry.getString("d_billid"));
            entity.setBillEntryId(entry.getString("d_billentryid"));
            entity.setMaterialId(Long.valueOf(entry.getDynamicObject("d_material").getLong("id")));
            entity.setUnit(Long.valueOf(entry.getDynamicObject("d_unit").getLong("id")));
            entity.setRequireQty(entry.getBigDecimal("d_requireqty"));
            entity.setSupplyQty(entry.getBigDecimal("d_supplyqty"));
            entity.setEntryType(entry.getString("d_entryqtytype"));
            entity.setQtyNumerator(entry.getBigDecimal("entryqtynumerator"));
            entity.setQtyDenominator(entry.getBigDecimal("entryqtydenominator"));
            entity.setDynamicScrapRatio(entry.getBigDecimal("dynamicscrapratio"));
            entity.setFixScrap(entry.getBigDecimal("fixscrap"));
            entity.setWastaGerateFormula("".equals(entry.getString("wastagerateformula")) ? "B" : entry.getString("wastagerateformula"));
            if (!"".equals(fieldMap.get("planorder"))) {
                entity.setNewPlanOrderQty(entry.getBigDecimal(fieldMap.get("planorder")));
            }
            if (!"".equals(fieldMap.get("inv"))) {
                entity.setInvQty(entry.getBigDecimal(fieldMap.get("inv")));
            }
            List list = map.computeIfAbsent(reqsourcebillno, k -> new ArrayList());
            list.add(entity);
            if (level != 1) continue;
            TreeNode tree = new TreeNode(pid, id, "", true, (Object)entity);
            treeMap.put(reqsourcebillno, tree);
        }
        return treeMap;
    }

    private void calcTopQty(TreeNode tree, TreeNode node) {
        if (tree.getTreeNode(node.getParentid()) == null) {
            return;
        }
        TreeNode parentNode = tree.getTreeNode(node.getParentid());
        SimulationEntryEntity parentData = (SimulationEntryEntity)parentNode.getData();
        SimulationEntryEntity data = (SimulationEntryEntity)node.getData();
        BigDecimal invQty = data.getInvQty();
        if (data.getChildInvQty() != null) {
            invQty = invQty.add(data.getChildInvQty());
        }
        BigDecimal wayQty = data.getSupplyQty().subtract(data.getNewPlanOrderQty());
        if (data.getChildWayQty() != null) {
            wayQty = wayQty.add(data.getChildWayQty());
        }
        BigDecimal qtyNumerator = data.getQtyNumerator();
        BigDecimal qtyDenominator = data.getQtyDenominator();
        BigDecimal dynamicScrapRatio = data.getDynamicScrapRatio();
        BigDecimal fixScrap = data.getFixScrap();
        String wastagerateformula = data.getWastaGerateFormula();
        BigDecimal invFullSetQty = BigDecimal.ZERO;
        BigDecimal wayFullSetQty = BigDecimal.ZERO;
        MRPUtil.UnitPrecisionParam unitPrecisionParam = MRPUtil.getUnitPrecisionParam((Object)parentData.getUnit(), (IMRPEnvProvider)this.ctx);
        String entryType = data.getEntryType();
        if (this.ctx.isScrapRation()) {
            if ("AC".contains(entryType)) {
                if (wastagerateformula.equals("A")) {
                    invFullSetQty = invQty.subtract(fixScrap).multiply(BigDecimal.ONE.subtract(dynamicScrapRatio)).multiply(qtyDenominator).divide(qtyNumerator, unitPrecisionParam.scale, unitPrecisionParam.roundingMode);
                    wayFullSetQty = wayQty.subtract(fixScrap).multiply(BigDecimal.ONE.subtract(dynamicScrapRatio)).multiply(qtyDenominator).divide(qtyNumerator, unitPrecisionParam.scale, unitPrecisionParam.roundingMode);
                } else if (wastagerateformula.equals("B")) {
                    invFullSetQty = invQty.subtract(fixScrap).multiply(qtyDenominator).divide(BigDecimal.ONE.add(dynamicScrapRatio).multiply(qtyNumerator), unitPrecisionParam.scale, unitPrecisionParam.roundingMode);
                    wayFullSetQty = wayQty.subtract(fixScrap).multiply(qtyDenominator).divide(BigDecimal.ONE.add(dynamicScrapRatio).multiply(qtyNumerator), unitPrecisionParam.scale, unitPrecisionParam.roundingMode);
                }
            } else {
                if (invQty.compareTo(data.getRequireQty()) >= 0) {
                    invFullSetQty = parentData.getNewPlanOrderQty();
                }
                if (wayQty.compareTo(data.getRequireQty()) >= 0) {
                    wayFullSetQty = parentData.getNewPlanOrderQty();
                }
            }
        } else if ("B".equals(entryType)) {
            if (invQty.compareTo(data.getRequireQty()) >= 0) {
                invFullSetQty = parentData.getNewPlanOrderQty();
            }
            if (wayQty.compareTo(data.getRequireQty()) >= 0) {
                wayFullSetQty = parentData.getNewPlanOrderQty();
            }
        } else {
            invFullSetQty = invQty.multiply(qtyDenominator).divide(qtyNumerator, unitPrecisionParam.scale, unitPrecisionParam.roundingMode);
            wayFullSetQty = wayQty.multiply(qtyDenominator).divide(qtyNumerator, unitPrecisionParam.scale, unitPrecisionParam.roundingMode);
        }
        if (invFullSetQty.compareTo(BigDecimal.ZERO) < 0) {
            invFullSetQty = BigDecimal.ZERO;
        }
        if (wayFullSetQty.compareTo(BigDecimal.ZERO) < 0) {
            wayFullSetQty = BigDecimal.ZERO;
        }
        if (parentData.getChildInvQty() == null || parentData.getChildInvQty().compareTo(invFullSetQty) > 0) {
            parentData.setChildInvQty(invFullSetQty);
            if (parentData.getRequireQty().compareTo(parentData.getInvQty().add(invFullSetQty)) < 0) {
                parentData.setInvFullSetQty(parentData.getRequireQty());
            } else {
                parentData.setInvFullSetQty(parentData.getInvQty().add(invFullSetQty));
            }
        }
        if (parentData.getChildWayQty() == null || parentData.getChildWayQty().compareTo(wayFullSetQty) > 0) {
            parentData.setChildWayQty(wayFullSetQty);
            if (parentData.getRequireQty().compareTo(parentData.getSupplyQty().subtract(parentData.getNewPlanOrderQty()).add(wayFullSetQty)) < 0) {
                parentData.setWayFullSetQty(parentData.getRequireQty());
            } else {
                parentData.setWayFullSetQty(parentData.getSupplyQty().subtract(parentData.getNewPlanOrderQty()).add(wayFullSetQty));
            }
        }
        this.calcTopQty(tree, parentNode);
    }

    private void getReplaceData() {
        DynamicObject[] load;
        this.replaceMap = new HashMap<String, ReplaceMaterialEntity>(8);
        String selectFields = "id,sourceno,billid,billentryid,material,requireqty,repmaterial,repqty,auxpty,repauxpty,mainentryentity.entrymaterial,mainentryentity.entryqty,mainentryentity.entryauxpty,reqentryentity.entryreqmaterial,reqentryentity.entryreqqty,reqentryentity.entryrepauxpty";
        for (DynamicObject replace : load = BusinessDataServiceHelper.load((String)"mrp_replace_log", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("runlog", "=", this.ctx.getRunLog().getPkValue())})) {
            String reqsourcebillno = "";
            reqsourcebillno = "".equals(replace.getString("sourceno")) ? replace.getString("billid") + replace.getString("billentryid") : replace.getString("sourceno");
            DynamicObject material = replace.getDynamicObject("material");
            Long auxpty = replace.getDynamicObject("auxpty") == null ? Long.valueOf(0L) : replace.getDynamicObject("auxpty").getPkValue();
            String key = String.valueOf(material.getPkValue()) + (this.isFlexPropMatch ? String.valueOf(auxpty) : "0");
            ReplaceMaterialEntity replaceEntity = this.replaceMap.computeIfAbsent(reqsourcebillno, k -> new ReplaceMaterialEntity());
            replaceEntity.getReplaceMap().put(key, replace.getBigDecimal("requireqty"));
            material = replace.getDynamicObject("repmaterial");
            auxpty = replace.getDynamicObject("repauxpty") == null ? Long.valueOf(0L) : replace.getDynamicObject("repauxpty").getPkValue();
            key = String.valueOf(material.getPkValue()) + (this.isFlexPropMatch ? String.valueOf(auxpty) : "0");
            replaceEntity.getReplacecSet().add(key);
            DynamicObjectCollection mainEntrys = replace.getDynamicObjectCollection("mainentryentity");
            for (DynamicObject entry : mainEntrys) {
                material = entry.getDynamicObject("entrymaterial");
                auxpty = entry.getDynamicObject("entryauxpty") == null ? Long.valueOf(0L) : entry.getDynamicObject("entryauxpty").getPkValue();
                key = String.valueOf(material.getPkValue()) + (this.isFlexPropMatch ? String.valueOf(auxpty) : "0");
                replaceEntity.getReplaceMap().put(key, entry.getBigDecimal("entryqty"));
            }
            DynamicObjectCollection replaceEntrys = replace.getDynamicObjectCollection("reqentryentity");
            for (DynamicObject entry : replaceEntrys) {
                material = entry.getDynamicObject("entryreqmaterial");
                auxpty = entry.getDynamicObject("entryrepauxpty") == null ? Long.valueOf(0L) : entry.getDynamicObject("entryrepauxpty").getPkValue();
                key = String.valueOf(material.getPkValue()) + (this.isFlexPropMatch ? String.valueOf(auxpty) : "0");
                replaceEntity.getReplaceMap().put(key, entry.getBigDecimal("entryreqqty"));
            }
        }
    }
}

