/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.controlnode.framework.step;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.cache.MRPCacheManager;
import kd.mmc.mrp.framework.consts.MRPRuntimeConsts;
import kd.mmc.mrp.framework.consts.Tips;
import kd.mmc.mrp.framework.mq.DefaultOnResponse;
import kd.mmc.mrp.framework.mq.event.MRPCollaboratePlanBillClearEvent;
import kd.mmc.mrp.framework.mq.event.MRPDataBalanceEvent;
import kd.mmc.mrp.framework.mq.event.MRPEvent;
import kd.mmc.mrp.framework.mq.event.MRPPlanOrderClearEvent;
import kd.mmc.mrp.framework.plugin.IMRPCalculatePlugIn;
import kd.mmc.mrp.framework.plugin.MRPMPlugInFactory;
import kd.mmc.mrp.framework.step.AbstractMRPStep;
import kd.mmc.mrp.integrate.entity.CacheDatas;
import kd.mmc.mrp.integrate.entity.InventoryModel;
import kd.mmc.mrp.integrate.entity.PlanModel;
import kd.mmc.mrp.integrate.entity.RequireDataModel;
import kd.mmc.mrp.model.enums.MultiThreadCacheKey;
import kd.mmc.mrp.model.enums.status.MRPExecuteStatus;
import kd.mmc.mrp.utils.ExtPluginUtil;
import kd.mmc.mrp.utils.MRPClearDataUtil;
import kd.mmc.mrp.utils.MRPUtil;
import kd.mmc.mrp.utils.ReserveUtil;
import kd.mpscmm.msplan.business.inventory.InvLevel;
import kd.sdk.mmc.mrp.extpoint.IMRPClearHistoryDataPlugin;
import org.apache.commons.collections.CollectionUtils;

public class MRPMCalcNetDemand
extends AbstractMRPStep {
    private boolean isSelectMaterialPlan = false;
    private boolean isSelectMaterialPlan4PlanScope = false;
    private boolean isSelectBillPlan = false;
    private Set<String> dependMaterials = new HashSet<String>(16);
    private Set<Long> allDeleteIds = new HashSet<Long>(16);
    private Set<Long> allDeleteCollIds = new HashSet<Long>(16);
    protected IMRPClearHistoryDataPlugin clearHistoryDataPlugin = null;
    protected boolean isInitClearPlugin = false;

    public MRPMCalcNetDemand(IMRPEnvProvider ctx) {
        super(ctx);
    }

    protected void innerExecute() {
        String value;
        IMRPCalculatePlugIn[] plugins;
        for (IMRPCalculatePlugIn plugin : plugins = MRPMPlugInFactory.createCalculatePlugins((IMRPEnvProvider)this.ctx)) {
            plugin.setup(this.ctx);
        }
        CacheDatas cacheDatas = (CacheDatas)this.ctx.getService(CacheDatas.class);
        this.isSelectMaterialPlan = cacheDatas.isSelectMaterialPlan();
        this.isSelectMaterialPlan4PlanScope = cacheDatas.isSelectMaterialPlan4PlanScope();
        this.isSelectBillPlan = cacheDatas.isSelectBillPlan();
        this.dependMaterials = new HashSet<String>(16);
        this.allDeleteIds = new HashSet<Long>(16);
        this.allDeleteCollIds = new HashSet<Long>(16);
        List llc2m = this.ctx.bomDatas().getLLC();
        Set requireMaterials = this.ctx.bomDatas().getRequireMaterials();
        HashSet<String> requireLlc2m = new HashSet<String>(requireMaterials);
        InventoryModel service = (InventoryModel)this.ctx.getService(InventoryModel.class);
        InvLevel invLevel = service == null ? null : service.getInvLevel();
        Set invLevelMids = invLevel == null ? null : invLevel.getAllMaterials().stream().map(Object::toString).collect(Collectors.toSet());
        String json = MRPCacheManager.getInst().getData((CalEnv)this.ctx, MRPRuntimeConsts.getSelectBillMaterialKey((String)this.ctx.getMRPContextId()));
        Set mIds = Collections.emptySet();
        if (json != null) {
            mIds = new HashSet(JSON.parseArray((String)json, String.class));
        }
        if (mIds.isEmpty() && invLevelMids != null && !invLevelMids.isEmpty()) {
            requireLlc2m.addAll(invLevelMids);
            requireMaterials.addAll(invLevelMids);
            MRPCacheManager.getInst().putData((CalEnv)this.ctx, MRPRuntimeConsts.getRequireMaterialKey((String)this.ctx.getMRPContextId()), JSON.toJSONString((Object)requireMaterials));
        }
        if ((value = MRPCacheManager.getInst().getData((CalEnv)this.ctx, MRPRuntimeConsts.getInvMaterialKey((String)this.ctx.getMRPContextId()))) != null) {
            Collection invPlanMaterials = new HashSet(JSON.parseArray((String)value, String.class));
            if (!mIds.isEmpty()) {
                invPlanMaterials = CollectionUtils.intersection(invPlanMaterials, mIds);
            }
            requireLlc2m.addAll(invPlanMaterials);
            requireMaterials.addAll(invPlanMaterials);
            MRPCacheManager.getInst().putData((CalEnv)this.ctx, MRPRuntimeConsts.getRequireMaterialKey((String)this.ctx.getMRPContextId()), JSON.toJSONString((Object)requireMaterials));
        }
        if (this.isSelectMaterialPlan && (json = MRPCacheManager.getInst().getData((CalEnv)this.ctx, MRPRuntimeConsts.getOriginSelectBillMaterialKey((String)this.ctx.getMRPContextId()))) != null) {
            HashSet originMids = new HashSet(JSON.parseArray((String)json, String.class));
            this.dependMaterials.addAll(originMids);
        }
        int i = 0;
        RequireDataModel requireDataModel = (RequireDataModel)this.ctx.getService(RequireDataModel.class);
        if (!requireDataModel.isIs_single_calc()) {
            for (Set materialIds : llc2m) {
                this.calc(i++, materialIds, plugins);
                this.lr.saveStepLog(false);
                if (materialIds == null) continue;
                requireLlc2m.removeAll(materialIds);
            }
        }
        if (!requireLlc2m.isEmpty()) {
            this.calc(i, requireLlc2m, plugins);
        }
        if (this.isSelectMaterialPlan || this.isSelectBillPlan) {
            RequireDataModel require = (RequireDataModel)this.ctx.getService(RequireDataModel.class);
            String outputType = require.getOutputType();
            String outputCollaborativeorder = require.getOutputCollaborativeorder();
            MRPClearDataUtil.clearHisData(this.allDeleteIds, (IMRPEnvProvider)this.ctx, (String)outputType, (String)"po-clear", MRPPlanOrderClearEvent.class, (boolean)true);
            MRPClearDataUtil.clearHisData(this.allDeleteCollIds, (IMRPEnvProvider)this.ctx, (String)outputCollaborativeorder, (String)"colPlanBill-clear", MRPCollaboratePlanBillClearEvent.class, (boolean)true);
            if (this.allDeleteIds.size() + this.allDeleteCollIds.size() > 0) {
                this.ctx.wait4Response();
            }
        }
        for (i = 0; i < plugins.length; ++i) {
            plugins[i].tearDown();
        }
    }

    protected void calc(int llc, Set<String> ids, IMRPCalculatePlugIn[] plugins) {
        int clearOrderCount = 0;
        int clearColCount = 0;
        if (this.isSelectMaterialPlan && ids != null) {
            int[] counts = this.selectMaterialPlanClearOrder(llc, ids);
            clearOrderCount = counts[0];
            clearColCount = counts[1];
        }
        this.lr.createSubStepLog(llc, String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u7b2c%s\u5c42\u7684\u7269\u6599", (String)"MRPMCalcNetDemand_0", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), llc), this.stepIdx);
        int subCount = 0;
        long start = System.currentTimeMillis();
        DefaultOnResponse defaultResolver = (DefaultOnResponse)this.ctx.getMQManager().getOnResponse();
        defaultResolver.resetStatsCount(new String[]{"REQUIRE_COUNT", "SUPPLY_COUNT", "DETAIL_COUNT", "DEPENDENT_COUNT"});
        if (ids != null) {
            for (String materialID : ids) {
                Set group = null;
                if (this.ctx.bomDatas().isInReplaceGroup(materialID)) {
                    if (this.ctx.bomDatas().isSendedByReplaceGroup(materialID)) continue;
                    group = this.ctx.bomDatas().getReplaceGroupAndTagSended(materialID);
                }
                if (this.isSelectMaterialPlan && !this.dependMaterials.contains(materialID)) continue;
                ++subCount;
                MRPEvent event = this.createEvent(llc);
                event.setParam(MultiThreadCacheKey.KEY_MATERIAL_ID, (Serializable)((Object)materialID));
                if (group != null) {
                    event.setParam(MultiThreadCacheKey.KEY_MATERIAL_ID_BY_GROUP, (Serializable)((Object)JSON.toJSONString((Object)group)));
                }
                event.setRecorder(this.lr);
                event.setSubStepIdx(llc);
                this.ctx.runTask(event);
            }
        }
        if (ids == null) {
            this.lr.updateSubStepLog(llc, "entrydetailmsg", (Object)("llc: " + llc + ", empty materials."));
        } else {
            this.lr.updateSubStepLog(llc, "entrydetailmsg", (Object)String.format(ResManager.loadKDString((String)"\u5269\u4f59\u8ba1\u7b97\u4e8b\u4ef6\uff1a%s", (String)"MRPMCalcNetDemand_1", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), subCount));
        }
        this.lr.updateSubStepLog(llc, "entryprocessdata", (Object)subCount);
        this.lr.saveStepLog(false);
        this.ctx.wait4Response();
        this.dataAmount += subCount;
        for (int i = 0; i < plugins.length; ++i) {
            plugins[i].execute();
        }
        CacheDatas cacheDatas = (CacheDatas)this.ctx.getService(CacheDatas.class);
        if (this.isSelectMaterialPlan && ids != null) {
            HashSet dependMids = new HashSet(16);
            HashMap<String, Set> orgAndMid2AllScope = new HashMap<String, Set>(16);
            for (String string : ids) {
                String cacheValue = MRPCacheManager.getInst().getData((CalEnv)this.ctx, MRPRuntimeConsts.getDependRequireMaterialKey((String)this.ctx.getMRPContextId(), (String)string));
                if (cacheValue != null && !cacheValue.isEmpty()) {
                    dependMids.addAll(JSON.parseArray((String)cacheValue, String.class));
                }
                if ((cacheValue = MRPCacheManager.getInst().getData((CalEnv)this.ctx, MRPRuntimeConsts.getDependRequireMaterialPlanScopeKey((String)this.ctx.getMRPContextId(), (String)string))) == null) continue;
                Map map = (Map)JSONObject.parseObject((String)cacheValue, (TypeReference)new TypeReference<Map<String, Set<String>>>(){}, (Feature[])new Feature[0]);
                for (Map.Entry entry : map.entrySet()) {
                    Set allValue = orgAndMid2AllScope.computeIfAbsent((String)entry.getKey(), k -> new HashSet(16));
                    allValue.addAll((Collection)entry.getValue());
                }
            }
            this.dependMaterials.addAll(dependMids);
            cacheDatas.getOrgAndMid2scope().clear();
            for (Map.Entry entry : orgAndMid2AllScope.entrySet()) {
                String[] str = ((String)entry.getKey()).split("\u0001");
                String value = MRPCacheManager.getInst().getSubData((CalEnv)this.ctx, "materialscope_relation\u0001" + str[0], MRPRuntimeConsts.getSelectMaterialPlanScopeKey((String)this.ctx.getMRPContextId(), (String)str[1]));
                Set set = (Set)entry.getValue();
                if (value != null) {
                    set.addAll(JSON.parseArray((String)value, String.class));
                }
                MRPCacheManager.getInst().putSubData((CalEnv)this.ctx, "materialscope_relation\u0001" + str[0], MRPRuntimeConsts.getSelectMaterialPlanScopeKey((String)this.ctx.getMRPContextId(), (String)str[1]), JSON.toJSONString((Object)set));
            }
        }
        if (this.isSelectBillPlan && ids != null) {
            RequireDataModel require = (RequireDataModel)this.ctx.getService(RequireDataModel.class);
            String outputType = require.getOutputType();
            String outputCollaborativeorder = require.getOutputCollaborativeorder();
            HashSet deleteIds = new HashSet(16);
            HashSet hashSet = new HashSet(16);
            for (String materialID : ids) {
                String cacheValue = MRPCacheManager.getInst().getData((CalEnv)this.ctx, MRPRuntimeConsts.getSelectPlanDeleteOrderIdsKey((String)this.ctx.getMRPContextId(), (String)materialID));
                if (cacheValue != null && !cacheValue.isEmpty()) {
                    List dpIds = JSON.parseArray((String)cacheValue, Long.class);
                    clearOrderCount += dpIds.size();
                    deleteIds.addAll(dpIds);
                }
                if ((cacheValue = MRPCacheManager.getInst().getData((CalEnv)this.ctx, MRPRuntimeConsts.getSelectPlanDeleteCollIdsKey((String)this.ctx.getMRPContextId(), (String)materialID))) == null || cacheValue.isEmpty()) continue;
                List dcIds = JSON.parseArray((String)cacheValue, Long.class);
                clearColCount += dcIds.size();
                hashSet.addAll(dcIds);
            }
            this.allDeleteIds.addAll(deleteIds);
            this.allDeleteCollIds.addAll(hashSet);
            MRPCacheManager.getInst().putData((CalEnv)this.ctx, MRPRuntimeConsts.getDynamicDeleteDataKey((String)this.ctx.getMRPContextId(), (int)llc, (String)outputType), JSON.toJSONString(deleteIds, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
            cacheDatas.setDeleteBillsByLlc(Integer.valueOf(llc), outputType, deleteIds);
            MRPCacheManager.getInst().putData((CalEnv)this.ctx, MRPRuntimeConsts.getDynamicDeleteDataKey((String)this.ctx.getMRPContextId(), (int)llc, (String)outputCollaborativeorder), JSON.toJSONString(hashSet, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
            cacheDatas.setDeleteBillsByLlc(Integer.valueOf(llc), outputCollaborativeorder, hashSet);
        }
        if (this.isSelectMaterialPlan || this.isSelectBillPlan) {
            this.lr.updateSubStepLog(llc, "entrydetailmsg", (Object)String.format(ResManager.loadKDString((String)"\u5269\u4f59\u8ba1\u7b97\u4e8b\u4ef6\uff1a0, \u3010\u8f93\u5165\u3011\u9700\u6c42\u6570\u91cf\uff1a %1$s\uff0c\u4f9b\u5e94\u6570\u91cf\uff1a%2$s\u3002\u3010\u8f93\u51fa\u3011\u660e\u7ec6\u6570\u91cf\uff1a%3$s\uff0c\u76f8\u5173\u9700\u6c42\u6570\u91cf\uff1a%4$s\uff0c\u6e05\u7406\u8ba1\u5212\u8ba2\u5355\u6570\u91cf\uff1a%5$s\uff0c\u6e05\u7406\u534f\u540c\u8ba1\u5212\u5355\u6570\u91cf\uff1a%6$s\u3002", (String)"MRPMCalcNetDemand_3", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), defaultResolver.getStatsCount("REQUIRE_COUNT"), defaultResolver.getStatsCount("SUPPLY_COUNT"), defaultResolver.getStatsCount("DETAIL_COUNT"), defaultResolver.getStatsCount("DEPENDENT_COUNT"), clearOrderCount, clearColCount));
        } else {
            this.lr.updateSubStepLog(llc, "entrydetailmsg", (Object)String.format(ResManager.loadKDString((String)"\u5269\u4f59\u8ba1\u7b97\u4e8b\u4ef6\uff1a0, \u3010\u8f93\u5165\u3011\u9700\u6c42\u6570\u91cf\uff1a %1$s\uff0c\u4f9b\u5e94\u6570\u91cf\uff1a%2$s\u3002\u3010\u8f93\u51fa\u3011\u660e\u7ec6\u6570\u91cf\uff1a%3$s\uff0c\u76f8\u5173\u9700\u6c42\u6570\u91cf\uff1a%4$s\u3002", (String)"MRPMCalcNetDemand_2", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), defaultResolver.getStatsCount("REQUIRE_COUNT"), defaultResolver.getStatsCount("SUPPLY_COUNT"), defaultResolver.getStatsCount("DETAIL_COUNT"), defaultResolver.getStatsCount("DEPENDENT_COUNT")));
        }
        double time = (double)(System.currentTimeMillis() - start) / 1000.0 / 60.0;
        this.lr.updateSubStepLog(llc, "entryoperatmin", (Object)time);
        this.lr.updateSubStepLog(llc, "entryresult", (Object)MRPExecuteStatus.FINISHED.getAlias());
    }

    private int[] selectMaterialPlanClearOrder(int llc, Set<String> ids) {
        RequireDataModel require = (RequireDataModel)this.ctx.getService(RequireDataModel.class);
        String outputType = require.getOutputType();
        String outputCollaborativeorder = require.getOutputCollaborativeorder();
        PlanModel planModel = (PlanModel)this.ctx.getService(PlanModel.class);
        CacheDatas cacheDatas = (CacheDatas)this.ctx.getService(CacheDatas.class);
        Set orgs = cacheDatas.getSelectMaterialOrg();
        HashSet<Long> ms = new HashSet<Long>(ids.size());
        for (String materialID : ids) {
            if (!this.isSelectMaterialPlan || !this.dependMaterials.contains(materialID)) continue;
            ms.add(Long.parseLong(materialID));
        }
        int clearOrderCount = 0;
        int clearColCount = 0;
        if (ms.isEmpty()) {
            return new int[]{clearOrderCount, clearColCount};
        }
        boolean isautodropplanbill = (Boolean)planModel.getPlanDataByParam("isautodropplanbill", (Object)false);
        ArrayList<String> orderTypes = new ArrayList<String>(4);
        String auditordertype = (String)planModel.getPlanDataByParam("auditordertype", (Object)"");
        for (String type : auditordertype.split(",")) {
            if (!StringUtils.isNotBlank((CharSequence)type)) continue;
            orderTypes.add(type);
        }
        boolean isDeleteAuditBill = isautodropplanbill && !orderTypes.isEmpty();
        HashSet supplyOrgs = new HashSet(planModel.getSupplyorgs());
        QFilter filterRequireOrg = new QFilter("org", "in", (Object)(this.isSelectMaterialPlan4PlanScope ? MRPUtil.setStringParseLong((Set)orgs) : MRPUtil.setStringParseLong((Set)planModel.getRequirorgs())));
        QFilter filterSupplyOrg = new QFilter("proorpurorg", "in", (Object)MRPUtil.setStringParseLong(supplyOrgs));
        List qFilters = MRPClearDataUtil.getMRPClearHistoryDataFilter((IMRPEnvProvider)this.ctx, (QFilter)filterRequireOrg, (QFilter)filterSupplyOrg);
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(qFilters);
        QFilter qFilterMaterial = new QFilter("material", "in", ms);
        qFilterList.add(qFilterMaterial);
        HashSet<Long> deleteIds = new HashSet<Long>(16);
        try (DataSet dataset = this.ctx.getORM().queryDataSet("MRP-PLANORDER-CLEANER", outputType, "id,org,material,planscope", this.getPlanOrderClearFilters(qFilterList), "");){
            this.addClearIds(dataset, deleteIds, "org", "material");
        }
        if (isDeleteAuditBill) {
            dataset = this.ctx.getORM().queryDataSet("MRP-PLANORDER-CLEANER", outputType, "id,org,material,planscope", this.getPlanOrderClearFilters(MRPClearDataUtil.getDeleteAuditBillFilters((List)qFilters, qFilterList, orderTypes)), "");
            var24_29 = null;
            try {
                this.addClearIds(dataset, deleteIds, "org", "material");
            }
            catch (Throwable throwable) {
                var24_29 = throwable;
                throw throwable;
            }
            finally {
                if (dataset != null) {
                    if (var24_29 != null) {
                        try {
                            dataset.close();
                        }
                        catch (Throwable throwable) {
                            var24_29.addSuppressed(throwable);
                        }
                    } else {
                        dataset.close();
                    }
                }
            }
        }
        clearOrderCount += deleteIds.size();
        this.allDeleteIds.addAll(deleteIds);
        MRPCacheManager.getInst().putData((CalEnv)this.ctx, MRPRuntimeConsts.getDynamicDeleteDataKey((String)this.ctx.getMRPContextId(), (int)llc, (String)outputType), JSON.toJSONString(deleteIds, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
        cacheDatas.setDeleteBillsByLlc(Integer.valueOf(llc), outputType, deleteIds);
        filterRequireOrg.__setProperty("org");
        filterSupplyOrg.__setProperty("supplyorg");
        qFilterMaterial.__setProperty("materiel");
        HashSet<Long> deleteCollIds = new HashSet<Long>(16);
        MRPClearDataUtil.addCollaborativeorderBillStatusFilter(qFilterList);
        try (DataSet dataset = this.ctx.getORM().queryDataSet("MRP-PLANORDER-CLEANER", outputCollaborativeorder, "id,org,materiel,planscope", this.getCollaborativeOrderClearFilters(qFilterList), "");){
            this.addClearIds(dataset, deleteCollIds, "org", "materiel");
        }
        clearColCount += deleteCollIds.size();
        this.allDeleteCollIds.addAll(deleteCollIds);
        MRPCacheManager.getInst().putData((CalEnv)this.ctx, MRPRuntimeConsts.getDynamicDeleteDataKey((String)this.ctx.getMRPContextId(), (int)llc, (String)outputCollaborativeorder), JSON.toJSONString(deleteCollIds, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
        cacheDatas.setDeleteBillsByLlc(Integer.valueOf(llc), outputCollaborativeorder, deleteCollIds);
        ReserveUtil.reserveRemoveByBillId(deleteIds, (String)this.ctx.getRunLogNumber());
        ReserveUtil.reserveRemoveByBillId(deleteCollIds, (String)this.ctx.getRunLogNumber());
        return new int[]{clearOrderCount, clearColCount};
    }

    private void addClearIds(DataSet dataset, Set<Long> deleteIds, String orgField, String materialField) {
        CacheDatas cacheDatas = (CacheDatas)this.ctx.getService(CacheDatas.class);
        for (Row row : dataset) {
            Long id = row.getLong("id");
            Long org = row.getLong(orgField);
            Long mid = row.getLong(materialField);
            Long orderPlanScope = row.getLong("planscope");
            if (this.isSelectMaterialPlan4PlanScope) {
                Set cacheValue = cacheDatas.getSelectMaterialPlanScope((CalEnv)this.ctx, org.toString(), mid.toString());
                if (cacheValue == null) continue;
                boolean isMatch = false;
                for (String v : cacheValue) {
                    String[] str = v.split("\u0001");
                    Long scope = (Long)MRPUtil.convert((Object)str[0], (Object)0L);
                    if (scope > 0L && !scope.equals(orderPlanScope)) continue;
                    isMatch = true;
                    break;
                }
                if (!isMatch) continue;
                deleteIds.add(id);
                continue;
            }
            deleteIds.add(id);
        }
    }

    protected IMRPClearHistoryDataPlugin getClearHistoryDataPlugin() {
        if (!this.isInitClearPlugin) {
            this.clearHistoryDataPlugin = (IMRPClearHistoryDataPlugin)ExtPluginUtil.getProxyPlugin(null, IMRPClearHistoryDataPlugin.class, (String)"MRP_CLEARHISTORYDATA_EXT", null);
            this.isInitClearPlugin = true;
        }
        return this.clearHistoryDataPlugin;
    }

    protected QFilter[] getPlanOrderClearFilters(List<QFilter> qFilterList) {
        IMRPClearHistoryDataPlugin clearHistoryDataPlugin = this.getClearHistoryDataPlugin();
        return clearHistoryDataPlugin == null ? qFilterList.toArray(new QFilter[0]) : clearHistoryDataPlugin.getPlanOrderClearFilters(this.ctx.getMrpSdkEnv(), qFilterList);
    }

    protected QFilter[] getCollaborativeOrderClearFilters(List<QFilter> qFilterList) {
        IMRPClearHistoryDataPlugin clearHistoryDataPlugin = this.getClearHistoryDataPlugin();
        return clearHistoryDataPlugin == null ? qFilterList.toArray(new QFilter[0]) : clearHistoryDataPlugin.getCollaborativeOrderClearFilters(this.ctx.getMrpSdkEnv(), qFilterList);
    }

    protected MRPEvent createEvent(int llc) {
        MRPDataBalanceEvent ret = new MRPDataBalanceEvent();
        ret.setMrpContextId(this.ctx.getMRPContextId());
        ret.setParam(MultiThreadCacheKey.KEY_LLC, (Serializable)Integer.valueOf(llc));
        return ret;
    }

    public String getStepDesc(Locale locale) {
        return Tips.getCalcNetdemands();
    }
}

