/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.controlnode.framework.step;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mrp.common.consts.GrossdemandConst;
import kd.mmc.mrp.common.enums.CopTypeEnum;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.IMRPExecuteLogRecorder;
import kd.mmc.mrp.framework.cache.MRPCacheManager;
import kd.mmc.mrp.framework.consts.Tips;
import kd.mmc.mrp.framework.step.AbstractMRPStep;
import kd.mmc.mrp.integrate.entity.PlanModel;
import kd.mmc.mrp.integrate.utils.SnapshotDataIntegrateUtils;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.utils.MRPUtil;
import kd.mpscmm.msplan.mservice.service.datasync.MMCSnapDataVisitor;

public class MRPMGetGrossdemandSource
extends AbstractMRPStep {
    private static final Log logger = LogFactory.getLog(MRPMGetGrossdemandSource.class);
    IMRPExecuteLogRecorder log;
    public static final String GLOBALSHARED_CTRLSTRATEGY = "5";
    public static final String PRIVATE_CTRLSTRATEGY = "7";
    public static final String NONPURCHASEDPARTS = "X";
    public static final String PURCHASEDPARTS = "10040";
    public static final String MATERIALTAG = "&&";
    public static final String CONFIGURATIONTAG = "##";
    Map<MaterialInfo, Map<String, Map<String, BigDecimal>>> codeDemandsMap;
    Map<MaterialInfo, Map<String, Map<String, BigDecimal>>> codeSupplysMap;
    Map<String, String> materialAndMaterialTypes;
    private Set<String> cacheDsIds;
    private int count;
    private static ORM orm = ORM.create();

    public MRPMGetGrossdemandSource(IMRPEnvProvider ctx) {
        super(ctx);
        this.log = this.ctx.createLogRecorder();
        this.codeDemandsMap = new HashMap<MaterialInfo, Map<String, Map<String, BigDecimal>>>();
        this.codeSupplysMap = new HashMap<MaterialInfo, Map<String, Map<String, BigDecimal>>>();
        this.materialAndMaterialTypes = new HashMap<String, String>(16);
        this.cacheDsIds = new HashSet<String>(1);
        this.count = 50000;
    }

    public String getStepDesc(Locale locale) {
        return Tips.getGetGrossdemandSource();
    }

    protected void innerExecute() {
        String planOrgid = this.ctx.getPlanOrgId();
        DynamicObject grossdemandDefine = this.getGrossdemandDefine(planOrgid);
        if (grossdemandDefine == null) {
            this.log.updateStepLog("entrydetailmsg", (Object)ResManager.loadKDString((String)"\u83b7\u53d6\u6bdb\u9700\u6c42\u6765\u6e90\u5931\u8d25\uff0c\u8bf7\u7ef4\u62a4\u6bdb\u9700\u6c42\u5b9a\u4e49\u3002", (String)"MRPMGetGrossdemandSource_0", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]));
            this.log.saveStepLog(false);
            return;
        }
        DynamicObject caculatelog = this.ctx.getRunLog();
        String logid = caculatelog.getPkValue().toString();
        Date date = caculatelog.getDate("startdate");
        ArrayList<DynamicObject> grossdemandSourceList = new ArrayList<DynamicObject>();
        Long plangramid = Long.parseLong(this.ctx.getPlanId());
        QFilter plangramQFilter = new QFilter("plangram", "=", (Object)plangramid);
        QFilter enableQFilter = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        QFilter statusQFilter = new QFilter("status", "=", (Object)Character.valueOf('C'));
        DynamicObjectCollection plandispatchs = QueryServiceHelper.query((String)"mrp_plandispatch", (String)"forecastids", (QFilter[])new QFilter[]{plangramQFilter, enableQFilter, statusQFilter}, (String)"createtime desc", (int)1);
        HashSet<Long> setids = new HashSet<Long>();
        if (plandispatchs != null && plandispatchs.size() > 0) {
            Map datas;
            DynamicObject forecastidobj = (DynamicObject)plandispatchs.get(0);
            String forecastid = forecastidobj.getString("forecastids");
            HashSet<Long> forecastids = new HashSet<Long>();
            if (forecastid != null && forecastid.length() > 0) {
                String[] forecastidStr = forecastid.split(",");
                for (String id : forecastidStr) {
                    forecastids.add(Long.parseLong(id));
                }
            }
            if ((datas = BusinessDataServiceHelper.loadFromCache((String)"mds_setofftool", (String)"entryentity.setid", (QFilter[])new QFilter[]{new QFilter("id", "in", forecastids)})) != null && datas.size() > 0) {
                for (DynamicObject dynamicObject : datas.values()) {
                    DynamicObjectCollection collection = dynamicObject.getDynamicObjectCollection("entryentity");
                    for (DynamicObject data : collection) {
                        setids.add(Long.valueOf(data.getDynamicObject("setid").getPkValue().toString()));
                    }
                }
            }
        }
        HashMap<MaterialInfo, Map<String, String>> grossdemandSourcemap = new HashMap<MaterialInfo, Map<String, String>>();
        Long starttime = System.currentTimeMillis();
        HashSet<String> materialIds = new HashSet<String>(this.ctx.bomDatas().getRequireMaterials());
        List llc = this.ctx.bomDatas().getLLC();
        for (Set level : llc) {
            materialIds.addAll(level);
        }
        PlanModel planModel = (PlanModel)this.ctx.getService(PlanModel.class);
        HashSet orgs = planModel.getOrgs();
        this.getMaterialAttr(materialIds, orgs);
        HashSet<Long> materials = new HashSet<Long>(materialIds.size());
        HashMap materialMap = Maps.newHashMapWithExpectedSize((int)materialIds.size());
        HashSet materialInfos = Sets.newHashSetWithExpectedSize((int)materialIds.size());
        for (String materialId : materialIds) {
            List materialDetails = MRPCacheManager.getInst().getMaterialDetails((CalEnv)this.ctx, String.valueOf(materialId));
            for (Map materialDetail : materialDetails) {
                String parentbomid = null;
                String material = null;
                String materialattr = null;
                MaterialInfo demandMaterialInfo = null;
                MaterialInfo supplyMaterialInfo = null;
                if (materialDetail.get("material") != null) {
                    material = materialDetail.get("material").toString();
                    Long matId = Long.parseLong(material);
                    materials.add(matId);
                    Long configuredcode = (Long)MRPUtil.convert(materialDetail.get("configuredcode"), (Object)0L);
                    Long supplyauxpty = (Long)MRPUtil.convert(materialDetail.get("supplyauxpty"), (Object)0L);
                    supplyMaterialInfo = new MaterialInfo(matId, configuredcode, supplyauxpty, 0L, 0L, 0L, 0L);
                    materialInfos.add(supplyMaterialInfo);
                    Long demandauxpty = (Long)MRPUtil.convert(materialDetail.get("demandauxpty"), (Object)0L);
                    demandMaterialInfo = new MaterialInfo(matId, configuredcode, demandauxpty, 0L, 0L, 0L, 0L);
                    materialInfos.add(demandMaterialInfo);
                    MaterialInfo materialdemPInfo = new MaterialInfo(matId, configuredcode, demandauxpty, matId, configuredcode, demandauxpty, 0L);
                    this.putGrossdemandSourcemap(grossdemandSourcemap, materialdemPInfo);
                    MaterialInfo materialsupPInfo = new MaterialInfo(matId, configuredcode, supplyauxpty, matId, configuredcode, supplyauxpty, 0L);
                    this.putGrossdemandSourcemap(grossdemandSourcemap, materialsupPInfo);
                }
                if (materialDetail.get("bomid") != null) {
                    parentbomid = materialDetail.get("bomid").toString();
                }
                materialattr = materialDetail.get("materialattr") != null && PURCHASEDPARTS.equals(materialDetail.get("materialattr").toString()) ? materialDetail.get("materialattr").toString() : NONPURCHASEDPARTS;
                if (materialDetail.get("material") != null && materialDetail.get("materialattr") != null && !PURCHASEDPARTS.equals(materialDetail.get("materialattr").toString())) {
                    this.materialAndMaterialTypes.put(materialDetail.get("material").toString(), materialDetail.get("materialattr").toString());
                }
                if (parentbomid == null && materialDetail.get("demandbillf7") != null) {
                    String demandbilltype = materialDetail.get("demandbilltype") != null ? materialDetail.get("demandbilltype").toString() : " ";
                    BigDecimal demandqty = MRPUtil.toBigDecimal(materialDetail.get("demandqty"));
                    String mrpdemandtype = grossdemandDefine.getString("mrpdemandtype");
                    String demandStart = "";
                    if (StringUtils.isNotBlank((CharSequence)mrpdemandtype)) {
                        demandStart = grossdemandDefine.getString("mrpdemandtype") + "_";
                    }
                    String requirementtype = demandStart + demandbilltype;
                    this.mapAddQTY(requirementtype, demandqty, demandMaterialInfo, materialattr, this.codeDemandsMap);
                }
                if (materialDetail.get("supplybilltype") == null) continue;
                String supplybilltype = materialDetail.get("supplybilltype").toString();
                BigDecimal supplyqty = MRPUtil.toBigDecimal(materialDetail.get("supplyqty"));
                String adjustsuggest = materialDetail.get("adjustsuggest") != null ? materialDetail.get("adjustsuggest").toString() : " ";
                String mrpsupplytype = grossdemandDefine.getString("mrpsupplytype");
                String supplysluggishtype = grossdemandDefine.getString("supplysluggishtype");
                String demandStart = "";
                if (ResManager.loadKDString((String)"\u5efa\u8bae\u53d6\u6d88", (String)"MRPMGetGrossdemandSource_1", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]).equals(adjustsuggest) && StringUtils.isNotBlank((CharSequence)supplysluggishtype)) {
                    demandStart = supplysluggishtype + "_";
                } else if (StringUtils.isNotBlank((CharSequence)mrpsupplytype)) {
                    demandStart = mrpsupplytype + "_";
                }
                String requirementtype = demandStart + supplybilltype;
                this.mapAddQTY(requirementtype, supplyqty, supplyMaterialInfo, materialattr, this.codeSupplysMap);
            }
        }
        Long endtime = System.currentTimeMillis();
        logger.warn(String.format("mrprunner-GrossdemandSource-size,bom\u662f\u5916\u8d2d\u4ef6\u7684\u6570\u636ematerialAndMaterialTypes\u96c6\u5408\uff1a%s", this.materialAndMaterialTypes.size()));
        logger.warn(String.format("mrprunner-GrossdemandSource-time,\u6bdb\u9700\u6c42\u6765\u6e90\u83b7\u53d6\u7f16\u7801\u548c\u7236\u7f16\u7801\u3001bom\u5173\u7cfb\u65f6\u95f4: %s MS", endtime - starttime));
        logger.warn(String.format("mrprunner-GrossdemandSource-size,\u7f16\u7801\u548c\u7236\u7f16\u7801\u76f8\u540c\u7684\u96c6\u5408\uff1a %s ", grossdemandSourcemap.size()));
        logger.warn(String.format("mrprunner-GrossdemandSource-size,\u9876\u5c42\u7269\u6599\u9700\u6c42\u6570\u636e\u7684\u96c6\u5408\uff1a %s ", this.codeDemandsMap.size()));
        logger.warn(String.format("mrprunner-GrossdemandSource-size,\u9876\u5c42\u7269\u6599\u4f9b\u5e94\u6570\u636e\u6570\u636e\u7684\u96c6\u5408\uff1a %s ", this.codeSupplysMap.size()));
        this.getMaterial(materials, grossdemandDefine, materialMap);
        Map<Long, Long> pbomMap = this.getPBOM(materials, grossdemandDefine);
        starttime = System.currentTimeMillis();
        this.getGrossdemandSourcemap(materialInfos, grossdemandSourcemap, date);
        endtime = System.currentTimeMillis();
        logger.warn(String.format("mrprunner-GrossdemandSource-time,\u6bdb\u9700\u6c42\u6765\u6e90\u83b7\u53d6\u7f16\u7801\u548c\u7236\u7f16\u7801\u5173\u7cfb\u65f6\u95f4: %s MS", endtime - starttime));
        logger.warn(String.format("mrprunner-GrossdemandSource-size,\u7f16\u7801\u548c\u7236\u7f16\u7801\u7684\u603b\u96c6\u5408\uff1a %s ", grossdemandSourcemap.size()));
        starttime = System.currentTimeMillis();
        if (setids.size() > 0) {
            this.getFnreportSum(grossdemandSourceList, grossdemandSourcemap, grossdemandDefine, setids, logid, materials, materialMap, pbomMap);
        }
        endtime = System.currentTimeMillis();
        logger.warn(String.format("mrprunner-GrossdemandSource-time,\u83b7\u53d6\u6240\u6709\u7684\u9884\u6d4b\u51b2\u51cf\u4fe1\u606f \u5173\u8054\u7236\u9879\u7f16\u7801\u5728\u9884\u6d4b\u51b2\u51cf\u4e2d\u7684\u8bb0\u5f55\u65f6\u95f4: %s MS", endtime - starttime));
        starttime = System.currentTimeMillis();
        this.getCalcdetailSum(grossdemandSourceList, grossdemandDefine, grossdemandSourcemap, logid, materialMap, pbomMap);
        endtime = System.currentTimeMillis();
        logger.warn(String.format("mrprunner-GrossdemandSource-time,\u5173\u8054\u7236\u9879\u7f16\u7801\u5728MRP\u8ba1\u7b97\u660e\u7ec6\u8868\u4e2d\u9700\u6c42\u5355\u636e\u7c7b\u578b\u548c\u4f9b\u5e94\u5355\u636e\u7c7b\u578b\u65f6\u95f4: %s MS", endtime - starttime));
        starttime = System.currentTimeMillis();
        Map<Long, BigDecimal> safetystocks = this.getSafetyStocks(materials);
        this.getSafetyStockSum(grossdemandSourceList, grossdemandSourcemap, logid, safetystocks, materialMap, pbomMap, grossdemandDefine);
        endtime = System.currentTimeMillis();
        logger.warn(String.format("mrprunner-GrossdemandSource-time,\u5173\u8054\u7236\u9879\u7f16\u7801\u5728\u5b89\u5168\u5e93\u5b58\u65f6\u95f4: %s MS", endtime - starttime));
        starttime = System.currentTimeMillis();
        this.saveGrossdemandSource(grossdemandSourceList);
        endtime = System.currentTimeMillis();
        logger.warn(String.format("mrprunner-GrossdemandSource-size,\u4fdd\u5b58\u6bdb\u9700\u6c42\u6765\u6e90\u6570\u91cf: %s ", grossdemandSourceList.size()));
        logger.warn(String.format("mrprunner-GrossdemandSource-time,\u4fdd\u5b58\u6240\u6709\u6bdb\u9700\u6c42\u6765\u6e90\u7684\u65f6\u95f4: %s MS", endtime - starttime));
        for (String cacheId : this.cacheDsIds) {
            Algo.removeCacheDataSet((String)cacheId);
        }
        this.dataAmount = grossdemandSourceList.size();
    }

    private void getMaterialAttr(Set<String> materialIds, Set<String> orgIds) {
        HashSet materialIdSets = Sets.newHashSetWithExpectedSize((int)materialIds.size());
        for (String materialId : materialIds) {
            materialIdSets.add(Long.valueOf(materialId));
        }
        for (String orgId : orgIds) {
            QFilter qFilterMater = new QFilter("masterid", "in", (Object)materialIdSets);
            QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
            QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
            QFilter materialAttrPur = new QFilter("materialattr", "!=", (Object)PURCHASEDPARTS);
            QFilter basedataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_materialplan", (Long)Long.valueOf(orgId));
            String runLogNum = this.ctx.getRunLogNumber();
            Long versionId = SnapshotDataIntegrateUtils.getVersionIdByRunLogNumber((String)runLogNum);
            QFilter[] filters = new QFilter[]{qFilterMater, qFilterStatus, qFilterEnable, materialAttrPur, basedataFilter};
            DataSet ds = new MMCSnapDataVisitor().localFastDataVisit(versionId, null, "mpdm_materialplan", "masterid,materialattr", filters, null);
            if (ds != null) {
                while (ds.hasNext()) {
                    Row row = ds.next();
                    String id = row.getString(0);
                    String materialAttr = row.getString(1);
                    this.materialAndMaterialTypes.put(id, materialAttr);
                    Long materialId = Long.valueOf(id);
                    materialIdSets.remove(materialId);
                }
                ds.close();
                continue;
            }
            DataSet dataset = QueryServiceHelper.queryDataSet((String)MRPMGetGrossdemandSource.class.getName(), (String)"mpdm_materialplan", (String)"masterid,materialattr", (QFilter[])filters, null);
            Throwable throwable = null;
            try {
                while (dataset.hasNext()) {
                    Row row = dataset.next();
                    String id = row.getString(0);
                    String materialAttr = row.getString(1);
                    this.materialAndMaterialTypes.put(id, materialAttr);
                    Long materialId = Long.valueOf(id);
                    materialIdSets.remove(materialId);
                }
                dataset.close();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dataset == null) continue;
                if (throwable != null) {
                    try {
                        dataset.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dataset.close();
            }
        }
    }

    private void getGrossdemandSourcemap(Set<MaterialInfo> materialInfos, Map<MaterialInfo, Map<String, String>> grossdemandSourcemap, Date date) {
        Long timetemp = date.getTime();
        PlanModel planModel = (PlanModel)this.ctx.getService(PlanModel.class);
        HashSet orgs = planModel.getOrgs();
        for (MaterialInfo materialInfo : materialInfos) {
            Long mid = materialInfo.getMaterialId();
            Long configuredcode = materialInfo.getConfiguredcode();
            Long auxproperty = materialInfo.getAuxproperty();
            HashSet<MaterialInfo> bommaterialSet = new HashSet<MaterialInfo>();
            List allline = this.ctx.bomDatas().getCol(DefaultField.BOMField.CHILDMATERIAL.getName()).get((Object)mid);
            if (allline != null) {
                for (Integer line : allline) {
                    Object auxpropertyObj;
                    Long entryAuxproperty;
                    Object configuredcodeObj;
                    Long entryConfiguredcode;
                    if (this.isRemoveBomEntry(line) || !configuredcode.equals(entryConfiguredcode = (Long)MRPUtil.convert((Object)(configuredcodeObj = this.ctx.bomDatas().getValue(DefaultField.BOMField.ENTRYCONFIGUREDCODE.getName(), line.intValue())), (Object)0L)) || !auxproperty.equals(entryAuxproperty = (Long)MRPUtil.convert((Object)(auxpropertyObj = this.ctx.bomDatas().getValue(DefaultField.BOMField.ENTRYMATERIALFLEXPROP.getName(), line.intValue())), (Object)0L))) continue;
                    Object parentMaterial = this.ctx.bomDatas().getValue(DefaultField.BOMField.MATERIAL.getName(), line.intValue());
                    Object bomid = this.ctx.bomDatas().getValue(DefaultField.BOMField.BOMID.getName(), line.intValue());
                    Object validdateObj = this.ctx.bomDatas().getValue(DefaultField.BOMField.CHILDVALIDDATE.getName(), line.intValue());
                    Long validdate = validdateObj != null ? Long.parseLong(validdateObj.toString()) : 0L;
                    Object invaliddateObj = this.ctx.bomDatas().getValue(DefaultField.BOMField.CHILDINVALIDDATE.getName(), line.intValue());
                    Long invaliddate = invaliddateObj != null ? Long.parseLong(invaliddateObj.toString()) : 0L;
                    if (validdateObj == null || invaliddateObj == null || timetemp < validdate || timetemp > invaliddate || parentMaterial == null) continue;
                    Long parentMaterialId = (Long)MRPUtil.convert((Object)parentMaterial, (Object)0L);
                    if (this.materialAndMaterialTypes.get(parentMaterialId.toString()) == null) {
                        logger.warn(String.format("mrprunner-GrossdemandSource-\u7236bom\u5916\u8d2d\u4ef6,\u7269\u6599\uff1a%s,\u7236BOMID: %s\u662f\u5916\u8d2d\u4ef6", mid, parentMaterial));
                        continue;
                    }
                    Object pconfiguredcodeObj = this.ctx.bomDatas().getValue(DefaultField.BOMField.CONFIGUREDCODE.getName(), line.intValue());
                    Long pconfiguredcode = (Long)MRPUtil.convert((Object)pconfiguredcodeObj, (Object)0L);
                    Object pauxpropertyObj = this.ctx.bomDatas().getValue(DefaultField.BOMField.MATERIALFLEXPROPS.getName(), line.intValue());
                    Long pauxproperty = (Long)MRPUtil.convert((Object)pauxpropertyObj, (Object)0L);
                    MaterialInfo matinfo = new MaterialInfo(0L, 0L, 0L, parentMaterialId, pconfiguredcode, pauxproperty, (Long)MRPUtil.convert((Object)bomid, (Object)0L));
                    bommaterialSet.add(matinfo);
                    MaterialInfo mat = new MaterialInfo(mid, configuredcode, auxproperty, parentMaterialId, pconfiguredcode, pauxproperty, 0L);
                    if (!parentMaterialId.equals(mid)) {
                        this.putGrossdemandSourcemap(grossdemandSourcemap, mat);
                    }
                    this.getParentBoms(grossdemandSourcemap, mat, bommaterialSet, timetemp, orgs);
                }
            }
            if (bommaterialSet.size() <= 0) continue;
            logger.warn(String.format("mrprunner-GrossdemandSource-bom,\u7269\u6599\uff1a%s,\u7236\u7269\u6599\u548c\u7236bomid\u96c6\u5408: %s ", mid, bommaterialSet));
        }
    }

    private boolean isRemoveBomEntry(Integer line) {
        CopTypeEnum copTypeEnum = CopTypeEnum.fromValue((String)String.valueOf(this.ctx.bomDatas().getValue(DefaultField.BOMField.COPTYPE.getName(), line.intValue())));
        return copTypeEnum != null;
    }

    private void getParentBoms(Map<MaterialInfo, Map<String, String>> grossdemandSourcemap, MaterialInfo materialInfo, Set<MaterialInfo> bommaterialSet, Long timetemp, Set<String> orgs) {
        Long material = materialInfo.getPmaterialId();
        Long configuredcode = materialInfo.getPconfiguredcode();
        Long auxproperty = materialInfo.getPauxproperty();
        List allline = this.ctx.bomDatas().getCol(DefaultField.BOMField.CHILDMATERIAL.getName()).get((Object)material);
        if (allline != null) {
            for (Integer line : allline) {
                Object auxpropertyObj;
                Long entryAuxproperty;
                Object configuredcodeObj;
                Long entryConfiguredcode;
                if (this.isRemoveBomEntry(line)) continue;
                Object bomid = this.ctx.bomDatas().getValue(DefaultField.BOMField.BOMID.getName(), line.intValue());
                MaterialInfo matinfo = new MaterialInfo(0L, 0L, 0L, material, configuredcode, auxproperty, (Long)MRPUtil.convert((Object)bomid, (Object)0L));
                if (bommaterialSet.contains(matinfo) || !configuredcode.equals(entryConfiguredcode = (Long)MRPUtil.convert((Object)(configuredcodeObj = this.ctx.bomDatas().getValue(DefaultField.BOMField.ENTRYCONFIGUREDCODE.getName(), line.intValue())), (Object)0L)) || !auxproperty.equals(entryAuxproperty = (Long)MRPUtil.convert((Object)(auxpropertyObj = this.ctx.bomDatas().getValue(DefaultField.BOMField.ENTRYMATERIALFLEXPROP.getName(), line.intValue())), (Object)0L))) continue;
                Object validdateObj = this.ctx.bomDatas().getValue(DefaultField.BOMField.CHILDVALIDDATE.getName(), line.intValue());
                Long validdate = validdateObj != null ? Long.parseLong(validdateObj.toString()) : 0L;
                Object invaliddateObj = this.ctx.bomDatas().getValue(DefaultField.BOMField.CHILDINVALIDDATE.getName(), line.intValue());
                Long invaliddate = invaliddateObj != null ? Long.parseLong(invaliddateObj.toString()) : 0L;
                if (validdateObj == null || invaliddateObj == null || timetemp < validdate || timetemp > invaliddate) continue;
                Object parentMaterial = this.ctx.bomDatas().getValue(DefaultField.BOMField.MATERIAL.getName(), line.intValue());
                if (parentMaterial != null && this.materialAndMaterialTypes.get(parentMaterial.toString()) == null) {
                    logger.warn(String.format("mrprunner-GrossdemandSource-\u7236bom\u5916\u8d2d\u4ef6,\u7269\u6599\uff1a%s,\u7236BOMID: %s\u662f\u5916\u8d2d\u4ef6", bomid, parentMaterial));
                    continue;
                }
                Long parentMaterialId = (Long)MRPUtil.convert((Object)parentMaterial, (Object)0L);
                Object pconfiguredcodeObj = this.ctx.bomDatas().getValue(DefaultField.BOMField.CONFIGUREDCODE.getName(), line.intValue());
                Long pconfiguredcode = (Long)MRPUtil.convert((Object)pconfiguredcodeObj, (Object)0L);
                Object pauxpropertyObj = this.ctx.bomDatas().getValue(DefaultField.BOMField.MATERIALFLEXPROPS.getName(), line.intValue());
                Long pauxproperty = (Long)MRPUtil.convert((Object)pauxpropertyObj, (Object)0L);
                MaterialInfo matInfo = new MaterialInfo(0L, 0L, 0L, parentMaterialId, pconfiguredcode, pauxproperty, (Long)MRPUtil.convert((Object)bomid, (Object)0L));
                bommaterialSet.add(matInfo);
                MaterialInfo mat = new MaterialInfo(materialInfo.getMaterialId(), materialInfo.getConfiguredcode(), materialInfo.getAuxproperty(), parentMaterialId, pconfiguredcode, pauxproperty, 0L);
                if (parentMaterial == null) continue;
                this.putGrossdemandSourcemap(grossdemandSourcemap, mat);
                this.getParentBoms(grossdemandSourcemap, mat, bommaterialSet, timetemp, orgs);
            }
        }
    }

    private void putGrossdemandSourcemap(Map<MaterialInfo, Map<String, String>> grossdemandSourcemap, MaterialInfo materialInfo) {
        if (grossdemandSourcemap.get(materialInfo) == null) {
            HashMap map = Maps.newHashMapWithExpectedSize((int)2);
            map.put("materialcode", materialInfo.getMaterialId().toString());
            map.put("materialparentcode", materialInfo.getPmaterialId().toString());
            grossdemandSourcemap.put(materialInfo, map);
        }
    }

    private void getSafetyStockSum(List<DynamicObject> grossdemandSourceList, Map<MaterialInfo, Map<String, String>> grossdemandSourcemap, String logid, Map<Long, BigDecimal> safetystocks, Map<Long, Map<String, Object>> materialMap, Map<Long, Long> pbomMap, DynamicObject grossdemandDefine) {
        for (Map.Entry<MaterialInfo, Map<String, String>> entry : grossdemandSourcemap.entrySet()) {
            Map<String, String> grossdemandSource = entry.getValue();
            String materialparentcode = grossdemandSource.get("materialparentcode");
            if (safetystocks.get(Long.parseLong(materialparentcode)) == null) continue;
            String requirementtype = grossdemandDefine.getString("safetystock");
            BigDecimal qty = safetystocks.get(Long.parseLong(materialparentcode));
            this.setGrossdemandSourceList(grossdemandSourceList, grossdemandSource, logid, requirementtype, qty, materialMap, pbomMap);
        }
    }

    private Map<Long, BigDecimal> getSafetyStocks(Set<Long> materials) {
        HashMap<Long, BigDecimal> materialQtys = new HashMap<Long, BigDecimal>(1);
        HashMap materialSafetyStocks = new HashMap(1);
        HashMap<Long, String> safetyStockctrlstrategys = new HashMap<Long, String>(16);
        HashSet requirorgs = this.ctx.getRequirorgs();
        for (String string : requirorgs) {
            QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"mds_safetystock", (Long)Long.valueOf(string));
            QFilter materialQFilter = new QFilter("material.id", "in", materials);
            QFilter enableQFilter = new QFilter("enable", "=", (Object)Character.valueOf('1'));
            QFilter statusQFilter = new QFilter("status", "=", (Object)Character.valueOf('C'));
            QFilter saftytypeQFilter = new QFilter("saftytype", "!=", (Object)Character.valueOf('A'));
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String d = sdf.format(new Date());
            Date date = null;
            try {
                date = sdf.parse(d);
            }
            catch (ParseException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            QFilter startdateQFilter = new QFilter("loseeffecttime", ">=", (Object)date);
            QFilter enddateQFilter = new QFilter("effecttime", "<=", (Object)date);
            DataSet dataset = QueryServiceHelper.queryDataSet((String)MRPMGetGrossdemandSource.class.getName(), (String)"mds_safetystock", (String)"id,material.id,qty,ctrlstrategy", (QFilter[])new QFilter[]{materialQFilter, enableQFilter, statusQFilter, startdateQFilter, enddateQFilter, baseDataFilter, saftytypeQFilter}, null);
            Throwable throwable = null;
            try {
                while (dataset.hasNext()) {
                    Row row = dataset.next();
                    Long materialid = row.getLong("material.id");
                    BigDecimal qty = row.getBigDecimal("qty");
                    Long safetyStockid = row.getLong("id");
                    HashMap<Long, BigDecimal> safetyStocks = new HashMap<Long, BigDecimal>(1);
                    safetyStocks.put(safetyStockid, qty);
                    HashMap<Long, BigDecimal> safetyStock = (HashMap<Long, BigDecimal>)materialSafetyStocks.get(materialid);
                    String ctrlstrategy = row.getString("ctrlstrategy");
                    safetyStockctrlstrategys.put(safetyStockid, ctrlstrategy);
                    if (safetyStock == null) {
                        safetyStock = new HashMap<Long, BigDecimal>(1);
                    } else if (PRIVATE_CTRLSTRATEGY.equals(ctrlstrategy)) {
                        Set safetyIds = safetyStock.keySet();
                        for (Long safetyId : safetyIds) {
                            String oldctrlstrategy = (String)safetyStockctrlstrategys.get(safetyId);
                            if (!GLOBALSHARED_CTRLSTRATEGY.equals(oldctrlstrategy)) continue;
                            safetyStock.remove(safetyId);
                        }
                    } else if (GLOBALSHARED_CTRLSTRATEGY.equals(ctrlstrategy)) continue;
                    safetyStock.putAll(safetyStocks);
                    materialSafetyStocks.put(materialid, safetyStock);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dataset == null) continue;
                if (throwable != null) {
                    try {
                        dataset.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dataset.close();
            }
        }
        for (Map.Entry entry : materialSafetyStocks.entrySet()) {
            Map values = (Map)entry.getValue();
            Long materialId = (Long)entry.getKey();
            for (Map.Entry value : values.entrySet()) {
                BigDecimal bigDecimal = (BigDecimal)materialQtys.get(materialId);
                if (bigDecimal == null) {
                    materialQtys.put(materialId, (BigDecimal)value.getValue());
                    continue;
                }
                materialQtys.put(materialId, bigDecimal.add((BigDecimal)value.getValue()));
            }
        }
        return materialQtys;
    }

    private Map<Long, Long> getPBOM(Set<Long> materials, DynamicObject grossdemandDefine) {
        HashMap<Long, Long> pbom = new HashMap<Long, Long>(1);
        QFilter materialQFilter = new QFilter("materielitem.id", "in", materials);
        String runLogNum = this.ctx.getRunLogNumber();
        Long versionId = SnapshotDataIntegrateUtils.getVersionIdByRunLogNumber((String)runLogNum);
        String etStr = "mds_productfamily";
        String selectFields = "materielitem.id,materielpbom.id";
        QFilter[] filters = new QFilter[]{materialQFilter};
        DataSet ds = new MMCSnapDataVisitor().localFastDataVisit(versionId, null, etStr, selectFields, filters, null);
        if (ds != null) {
            while (ds.hasNext()) {
                Row row = ds.next();
                Long id = row.getLong("materielitem.id");
                Long materielpbom = row.getLong("materielpbom.id");
                pbom.put(id, materielpbom);
            }
            ds.close();
        } else {
            try (DataSet dataset = QueryServiceHelper.queryDataSet((String)MRPMGetGrossdemandSource.class.getName(), (String)etStr, (String)selectFields, (QFilter[])filters, null);){
                while (dataset.hasNext()) {
                    Row row = dataset.next();
                    Long id = row.getLong("materielitem.id");
                    Long materielpbom = row.getLong("materielpbom.id");
                    pbom.put(id, materielpbom);
                }
            }
        }
        return pbom;
    }

    private void getMaterial(Set<Long> materials, DynamicObject grossdemandDefine, Map<Long, Map<String, Object>> materialMap) {
        Serializable id;
        QFilter[] filters;
        String selectFields;
        String etStr;
        QFilter materialQFilter = new QFilter("id", "in", materials);
        String runLogNum = this.ctx.getRunLogNumber();
        Long versionId = SnapshotDataIntegrateUtils.getVersionIdByRunLogNumber((String)runLogNum);
        DataSet ds = new MMCSnapDataVisitor().localFastDataVisit(versionId, null, etStr = "bd_material", selectFields = "id,offeringcode", filters = new QFilter[]{materialQFilter}, null);
        if (ds != null) {
            while (ds.hasNext()) {
                Row row = ds.next();
                id = row.getLong("id");
                Map<String, Object> material = materialMap.get(id);
                if (material == null) {
                    material = new HashMap<String, Object>(3);
                }
                Long offeringcode = row.getLong("offeringcode");
                material.put("productmodel", offeringcode);
                materialMap.put((Long)id, material);
            }
            ds.close();
        } else {
            DataSet dataset = QueryServiceHelper.queryDataSet((String)MRPMGetGrossdemandSource.class.getName(), (String)etStr, (String)selectFields, (QFilter[])filters, null);
            id = null;
            try {
                while (dataset.hasNext()) {
                    Row row = dataset.next();
                    Long id2 = row.getLong("id");
                    Map<String, Object> material = materialMap.get(id2);
                    if (material == null) {
                        material = new HashMap<String, Object>(3);
                    }
                    Long offeringcode = row.getLong("offeringcode");
                    material.put("productmodel", offeringcode);
                    materialMap.put(id2, material);
                }
            }
            catch (Throwable row) {
                id = row;
                throw row;
            }
            finally {
                if (dataset != null) {
                    if (id != null) {
                        try {
                            dataset.close();
                        }
                        catch (Throwable row) {
                            ((Throwable)id).addSuppressed(row);
                        }
                    } else {
                        dataset.close();
                    }
                }
            }
        }
        DynamicObject standard = grossdemandDefine.getDynamicObject("codetype");
        Long standardId = 0L;
        standardId = standard == null ? GrossdemandConst.MATERIAL_JBFLBZ : Long.valueOf(grossdemandDefine.getDynamicObject("codetype").getLong("id"));
        materialQFilter = new QFilter("material.id", "in", materials);
        QFilter[] materialfilters = new QFilter[]{materialQFilter};
        String detailetStr = "bd_materialgroupdetail";
        String detailselectFields = "material.id,standard.id,group.id";
        DataSet ds1 = new MMCSnapDataVisitor().localFastDataVisit(versionId, null, detailetStr, detailselectFields, materialfilters, null);
        if (ds1 != null) {
            while (ds1.hasNext()) {
                Row row = ds1.next();
                Long id3 = row.getLong("material.id");
                Map<String, Object> material = materialMap.get(id3);
                Long standardid = row.getLong("standard.id");
                if (!standardId.equals(standardid) || material == null) continue;
                Long groupid = row.getLong("group.id");
                material.put("materialgroup", groupid);
                materialMap.put(id3, material);
            }
            ds1.close();
        } else {
            try (DataSet dataset = QueryServiceHelper.queryDataSet((String)MRPMGetGrossdemandSource.class.getName(), (String)detailetStr, (String)detailselectFields, (QFilter[])materialfilters, null);){
                while (dataset.hasNext()) {
                    Row row = dataset.next();
                    Long id4 = row.getLong("material.id");
                    Map<String, Object> material = materialMap.get(id4);
                    Long standardid = row.getLong("standard.id");
                    if (!standardId.equals(standardid) || material == null) continue;
                    Long groupid = row.getLong("group.id");
                    material.put("materialgroup", groupid);
                    materialMap.put(id4, material);
                }
            }
        }
    }

    private void saveGrossdemandSource(List<DynamicObject> grossdemandSourceList) {
        if (grossdemandSourceList != null && grossdemandSourceList.size() > 0) {
            Iterator<DynamicObject> it = grossdemandSourceList.iterator();
            while (it.hasNext()) {
                DynamicObject grossdemandSource = it.next();
                String requirementtype = grossdemandSource.getString("requirementtype");
                if (!StringUtils.isBlank((CharSequence)requirementtype)) continue;
                it.remove();
            }
            int averageNum = grossdemandSourceList.size() % this.count == 0 ? grossdemandSourceList.size() / this.count : grossdemandSourceList.size() / this.count + 1;
            List<List<DynamicObject>> averagelist = MRPMGetGrossdemandSource.averageAssign(grossdemandSourceList, averageNum);
            for (List<DynamicObject> list : averagelist) {
                DynamicObject[] dynamicObjectarr = list.toArray(new DynamicObject[list.size()]);
                SaveServiceHelper.save((DynamicObject[])dynamicObjectarr);
            }
        }
    }

    private void getFnreportSum(List<DynamicObject> grossdemandSourceList, Map<MaterialInfo, Map<String, String>> grossdemandSourcemap, DynamicObject grossdemandDefine, Set<Long> setids, String logid, Set<Long> materials, Map<Long, Map<String, Object>> materialMap, Map<Long, Long> pbomMap) {
        QFilter setidsQFilter = new QFilter("setid", "in", setids);
        QFilter materialQFilter = new QFilter("materialid", "in", materials);
        materialQFilter.or(new QFilter("srcmaterialid", "in", materials));
        Map<String, Map<String, Object>> setofftools = this.getSetOffTools(grossdemandDefine);
        HashSet<String> duplicateRemoval = new HashSet<String>();
        HashMap<String, BigDecimal> foreCostNumberMap = new HashMap<String, BigDecimal>(1);
        HashMap<String, BigDecimal> nosendOrderMap = new HashMap<String, BigDecimal>(1);
        HashMap<String, BigDecimal> sendOrderMap = new HashMap<String, BigDecimal>(1);
        HashMap<String, BigDecimal> remainNumberMap = new HashMap<String, BigDecimal>(1);
        String runLogNum = this.ctx.getRunLogNumber();
        Long versionId = SnapshotDataIntegrateUtils.getVersionIdByRunLogNumber((String)runLogNum);
        QFilter[] filters = new QFilter[]{setidsQFilter, materialQFilter};
        String etStr = "mds_fnreport";
        String selectFields = "setid,materialid,srcmaterialid,qty,fordate,forecastqty,setoffqty,salremainqty,sendgoodsdate,hwremainqty";
        DataSet ds = new MMCSnapDataVisitor().localFastDataVisit(versionId, null, etStr, selectFields, filters, null);
        if (ds != null) {
            while (ds.hasNext()) {
                Row row = ds.next();
                this.setFnreportMap(row, materials, foreCostNumberMap, nosendOrderMap, sendOrderMap, remainNumberMap, setofftools, duplicateRemoval);
            }
            ds.close();
        } else {
            DataSet dataset = QueryServiceHelper.queryDataSet((String)MRPMGetGrossdemandSource.class.getName(), (String)etStr, (String)selectFields, (QFilter[])filters, null);
            Object object = null;
            try {
                while (dataset.hasNext()) {
                    Row row = dataset.next();
                    this.setFnreportMap(row, materials, foreCostNumberMap, nosendOrderMap, sendOrderMap, remainNumberMap, setofftools, duplicateRemoval);
                }
            }
            catch (Throwable row) {
                object = row;
                throw row;
            }
            finally {
                if (dataset != null) {
                    if (object != null) {
                        try {
                            dataset.close();
                        }
                        catch (Throwable row) {
                            ((Throwable)object).addSuppressed(row);
                        }
                    } else {
                        dataset.close();
                    }
                }
            }
        }
        logger.warn(String.format("mrprunner-GrossdemandSource-size,\u9884\u6d4b\u6570\u91cfmap: %s ", foreCostNumberMap.size()));
        logger.warn(String.format("mrprunner-GrossdemandSource-size,\u672a\u53d1\u8d27\u8ba2\u5355map: %s ", nosendOrderMap.size()));
        logger.warn(String.format("mrprunner-GrossdemandSource-size,\u53d1\u8d27\u8ba2\u5355map: %s ", sendOrderMap.size()));
        logger.warn(String.format("mrprunner-GrossdemandSource-size,\u9884\u6d4b\u5269\u4f59\u6570\u91cfmap: %s ", remainNumberMap.size()));
        HashSet<String> duplicateRemovalSetofftoolsName = new HashSet<String>();
        for (Long setid : setids) {
            for (Map.Entry<MaterialInfo, Map<String, String>> entry : grossdemandSourcemap.entrySet()) {
                Map<String, String> grossdemandSource = entry.getValue();
                String materialparentcode = grossdemandSource.get("materialparentcode");
                this.setidMaterialparentcode(grossdemandSourceList, grossdemandSource, logid, duplicateRemovalSetofftoolsName, setofftools, setid, "a", materialparentcode, foreCostNumberMap, materialMap, pbomMap);
                this.setidMaterialparentcode(grossdemandSourceList, grossdemandSource, logid, duplicateRemovalSetofftoolsName, setofftools, setid, "b", materialparentcode, nosendOrderMap, materialMap, pbomMap);
                this.setidMaterialparentcode(grossdemandSourceList, grossdemandSource, logid, duplicateRemovalSetofftoolsName, setofftools, setid, "c", materialparentcode, sendOrderMap, materialMap, pbomMap);
                this.setidMaterialparentcode(grossdemandSourceList, grossdemandSource, logid, duplicateRemovalSetofftoolsName, setofftools, setid, "d", materialparentcode, remainNumberMap, materialMap, pbomMap);
            }
            this.setduplicateRemovalSetofftoolsName(duplicateRemovalSetofftoolsName, setofftools, setid, "a");
            this.setduplicateRemovalSetofftoolsName(duplicateRemovalSetofftoolsName, setofftools, setid, "b");
            this.setduplicateRemovalSetofftoolsName(duplicateRemovalSetofftoolsName, setofftools, setid, "c");
            this.setduplicateRemovalSetofftoolsName(duplicateRemovalSetofftoolsName, setofftools, setid, "d");
        }
    }

    private void setFnreportMap(Row row, Set<Long> materials, Map<String, BigDecimal> foreCostNumberMap, Map<String, BigDecimal> nosendOrderMap, Map<String, BigDecimal> sendOrderMap, Map<String, BigDecimal> remainNumberMap, Map<String, Map<String, Object>> setofftools, Set<String> duplicateRemoval) {
        String mapKey;
        Long setid = row.getLong("setid");
        Long materialid = row.getLong("materialid");
        BigDecimal forecastqty = row.getBigDecimal("forecastqty");
        Date fordate = row.getDate("fordate");
        BigDecimal setoffqty = row.getBigDecimal("setoffqty");
        BigDecimal salremainqty = row.getBigDecimal("salremainqty");
        Date sendgoodsdate = row.getDate("sendgoodsdate");
        BigDecimal hwremainqty = row.getBigDecimal("hwremainqty");
        Long srcmaterialid = row.getLong("srcmaterialid");
        BigDecimal qty = row.getBigDecimal("qty");
        String duplicateRemovalkey = setid + materialid + fordate.toString();
        if (materials.contains(materialid) && duplicateRemoval.add(duplicateRemovalkey)) {
            if (setofftools.get(setid + "&&a") != null) {
                mapKey = setofftools.get(setid + "&&a").get("setoffsettingname") + MATERIALTAG + materialid;
                this.mapAddQTY(foreCostNumberMap, mapKey, forecastqty);
            }
            if (setofftools.get(setid + "&&d") != null) {
                mapKey = setofftools.get(setid + "&&d").get("setoffsettingname") + MATERIALTAG + materialid;
                this.mapAddQTY(remainNumberMap, mapKey, hwremainqty);
            }
        }
        if (setofftools.get(setid + "&&b") != null && sendgoodsdate == null && materials.contains(srcmaterialid) && (forecastqty.compareTo(BigDecimal.ZERO) != 0 || salremainqty.compareTo(qty) >= 0)) {
            mapKey = setofftools.get(setid + "&&b").get("setoffsettingname") + MATERIALTAG + srcmaterialid;
            this.mapAddQTY(nosendOrderMap, mapKey, salremainqty.add(setoffqty));
        }
        if (setofftools.get(setid + "&&c") != null && sendgoodsdate != null && materials.contains(srcmaterialid) && (forecastqty.compareTo(BigDecimal.ZERO) != 0 || salremainqty.compareTo(qty) >= 0)) {
            mapKey = setofftools.get(setid + "&&c").get("setoffsettingname") + MATERIALTAG + srcmaterialid;
            this.mapAddQTY(sendOrderMap, mapKey, salremainqty.add(setoffqty));
        }
    }

    private void setidMaterialparentcode(List<DynamicObject> grossdemandSourceList, Map<String, String> grossdemandSource, String logid, Set<String> duplicateRemovalSetofftoolsName, Map<String, Map<String, Object>> setofftools, Long setid, String type, String materialparentcode, Map<String, BigDecimal> map, Map<Long, Map<String, Object>> materialMap, Map<Long, Long> pbomMap) {
        if (!this.getduplicateRemovalSetofftoolsName(duplicateRemovalSetofftoolsName, setofftools, setid, type)) {
            String requirementtype = null;
            if (setofftools.get(setid + MATERIALTAG + type) != null) {
                requirementtype = setofftools.get(setid + MATERIALTAG + type).get("setoffsettingname").toString();
            }
            if (requirementtype != null) {
                String mapKey = requirementtype + MATERIALTAG + materialparentcode;
                BigDecimal qty = map.get(mapKey);
                this.setGrossdemandSourceList(grossdemandSourceList, grossdemandSource, logid, requirementtype, qty, materialMap, pbomMap);
            }
        }
    }

    private void setGrossdemandSourceList(List<DynamicObject> grossdemandSourceList, Map<String, String> grossdemandSourcecode, String logid, String requirementtype, BigDecimal qty, Map<Long, Map<String, Object>> materialMap, Map<Long, Long> pbomMap) {
        if (requirementtype == null || qty == null) {
            return;
        }
        String qtys = qty.stripTrailingZeros().toPlainString();
        if ("0".equals(qtys)) {
            logger.warn(String.format("mrprunner-GrossdemandSource,\u7269\u6599 %s \u6570\u91cf\u4e3a0", grossdemandSourcecode.get("materialcode") + requirementtype));
            return;
        }
        DynamicObject grossdemandSource = this.getNewDynamicObject("mrp_gdd_source_base");
        grossdemandSource.set("caculatelog", (Object)logid);
        grossdemandSource.set("materialcode", (Object)grossdemandSourcecode.get("materialcode"));
        grossdemandSource.set("materialparentcode", (Object)grossdemandSourcecode.get("materialparentcode"));
        grossdemandSource.set("requirementtype", (Object)requirementtype);
        grossdemandSource.set("qty", (Object)qtys);
        if (materialMap.get(Long.parseLong(grossdemandSourcecode.get("materialparentcode"))) != null) {
            Map<String, Object> material = materialMap.get(Long.parseLong(grossdemandSourcecode.get("materialparentcode")));
            grossdemandSource.set("productmodel", material.get("productmodel"));
            grossdemandSource.set("materialgroup", material.get("materialgroup"));
        }
        grossdemandSource.set("pbom", (Object)pbomMap.get(Long.parseLong(grossdemandSourcecode.get("materialparentcode"))));
        grossdemandSourceList.add(grossdemandSource);
    }

    private boolean getduplicateRemovalSetofftoolsName(Set<String> duplicateRemovalSetofftoolsName, Map<String, Map<String, Object>> setofftools, Long setid, String type) {
        String setoffname;
        String duplicateRemovalSetofftoolsNameKey;
        String setofftoolskey = setid + type;
        Map<String, Object> setofftool = setofftools.get(setofftoolskey);
        return setofftool != null && duplicateRemovalSetofftoolsName.contains(duplicateRemovalSetofftoolsNameKey = (setoffname = setofftool.get("setoffsettingname").toString()) + type);
    }

    private void setduplicateRemovalSetofftoolsName(Set<String> duplicateRemovalSetofftoolsName, Map<String, Map<String, Object>> setofftools, Long setid, String type) {
        if (setofftools == null) {
            return;
        }
        String setofftoolskey = setid + type;
        Map<String, Object> setofftool = setofftools.get(setofftoolskey);
        if (setofftool != null) {
            String setoffname = setofftool.get("setoffsettingname").toString();
            String duplicateRemovalSetofftoolsNameKey = setoffname + type;
            duplicateRemovalSetofftoolsName.add(duplicateRemovalSetofftoolsNameKey);
        }
    }

    private Map<String, Map<String, Object>> getSetOffTools(DynamicObject grossdemandDefine) {
        if (grossdemandDefine != null) {
            HashMap<String, Map<String, Object>> setofftools = new HashMap<String, Map<String, Object>>();
            StringBuilder info = new StringBuilder();
            DynamicObjectCollection gdmdefineentrys = grossdemandDefine.getDynamicObjectCollection("gdmdefineentry");
            for (DynamicObject gdmdefineentry : gdmdefineentrys) {
                Long setoffsetting = gdmdefineentry.getLong("setoffsetting");
                DynamicObject[] datas = BusinessDataServiceHelper.load((String)"mds_setoffsetting", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)setoffsetting)});
                if (datas == null || datas.length == 0) {
                    info.append(String.format(ResManager.loadKDString((String)"\u6bdb\u9700\u6c42\u5b9a\u4e49\u5206\u5f55\u9884\u6d4b\u51b2\u51cf\u5b9a\u4e49id\u4e3a%s\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u4e0d\u5904\u7406\u8fd9\u6761\u5206\u5f55\u6570\u636e;", (String)"MRPMGetGrossdemandSource_2", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), setoffsetting));
                    this.log.updateStepLog("entrydetailmsg", (Object)info);
                    this.log.saveStepLog(false);
                    continue;
                }
                String setofftype = gdmdefineentry.getString("setofftype");
                String setoffname = gdmdefineentry.getString("setoffname");
                HashMap<String, Object> gdmdefineentryMap = new HashMap<String, Object>();
                gdmdefineentryMap.put("setoffsetting", setoffsetting);
                gdmdefineentryMap.put("setofftype", setofftype);
                gdmdefineentryMap.put("setoffsettingname", setoffname);
                setofftools.put(setoffsetting + MATERIALTAG + setofftype, gdmdefineentryMap);
            }
            return setofftools;
        }
        return null;
    }

    private DynamicObject getGrossdemandDefine(String planOrgid) {
        QFilter createorgQFilter = new QFilter("createorg", "=", (Object)Long.valueOf(planOrgid));
        QFilter enableQFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] grossdemandDefines = BusinessDataServiceHelper.load((String)"mrp_grossdemand_define", (String)"createorg,number,name,mrpdemandtype,codetype,gdmdefineentry,gdmdefineentry.setoffsetting,gdmdefineentry.setofftype,gdmdefineentry.setoffname,mrpsupplytype,supplysluggishtype,safetystock", (QFilter[])new QFilter[]{createorgQFilter, enableQFilter});
        DynamicObject grossdemandDefine = null;
        if (grossdemandDefines != null && grossdemandDefines.length > 0) {
            grossdemandDefine = grossdemandDefines[0];
        }
        return grossdemandDefine;
    }

    private void getCalcdetailSum(List<DynamicObject> grossdemandSourceList, DynamicObject grossdemandDefine, Map<MaterialInfo, Map<String, String>> grossdemandSourcemap, String planId, Map<Long, Map<String, Object>> materialMap, Map<Long, Long> pbomMap) {
        for (Map.Entry<MaterialInfo, Map<String, String>> entry : grossdemandSourcemap.entrySet()) {
            Map<String, Map<String, BigDecimal>> demandMap;
            Map<String, String> grossdemandSource = entry.getValue();
            MaterialInfo materialInfo = entry.getKey();
            MaterialInfo supmat = new MaterialInfo(materialInfo.getPmaterialId(), materialInfo.getPconfiguredcode(), materialInfo.getPauxproperty(), 0L, 0L, 0L, 0L);
            MaterialInfo demmat = new MaterialInfo(materialInfo.getMaterialId(), materialInfo.getConfiguredcode(), materialInfo.getAuxproperty(), 0L, 0L, 0L, 0L);
            if (this.codeSupplysMap.get(supmat) != null) {
                Map<String, Map<String, BigDecimal>> supplymap = this.codeSupplysMap.get(supmat);
                this.setGrossdemandSourceLists(grossdemandSourceList, planId, grossdemandSource, supplymap, materialMap, pbomMap, materialInfo);
            }
            if (!supmat.equals(demmat) && this.codeDemandsMap.get(supmat) != null) {
                demandMap = this.codeDemandsMap.get(supmat);
                this.setGrossdemandSourceLists(grossdemandSourceList, planId, grossdemandSource, demandMap, materialMap, pbomMap, materialInfo);
            }
            if (this.codeDemandsMap.get(demmat) == null) continue;
            demandMap = this.codeDemandsMap.get(demmat);
            this.setGrossdemandSourceLists(grossdemandSourceList, planId, grossdemandSource, demandMap, materialMap, pbomMap, materialInfo);
        }
    }

    private void setGrossdemandSourceLists(List<DynamicObject> grossdemandSourceList, String planId, Map<String, String> grossdemandSourcecode, Map<String, Map<String, BigDecimal>> map, Map<Long, Map<String, Object>> materialMap, Map<Long, Long> pbomMap, MaterialInfo materialInfo) {
        if (map != null && map.size() > 0) {
            for (Map.Entry<String, Map<String, BigDecimal>> entry : map.entrySet()) {
                BigDecimal sumqty = BigDecimal.ZERO;
                String requirementtype = entry.getKey();
                for (Map.Entry<String, BigDecimal> entry1 : entry.getValue().entrySet()) {
                    BigDecimal qty = entry1.getValue();
                    String qtys = qty.stripTrailingZeros().toPlainString();
                    if (qtys == null || "0".equals(qtys)) {
                        logger.warn(String.format("mrprunner-GrossdemandSource,\u7269\u6599 %s \u6570\u91cf\u4e3a0", grossdemandSourcecode.get("materialcode") + requirementtype));
                        continue;
                    }
                    String materialAttr = entry1.getKey();
                    if (grossdemandSourcecode.get("materialcode").equals(grossdemandSourcecode.get("materialparentcode"))) {
                        sumqty = sumqty.add(qty);
                        continue;
                    }
                    if (PURCHASEDPARTS.equals(materialAttr)) continue;
                    DynamicObject grossdemandSource = this.setGrossdemandSource(planId, grossdemandSourcecode, requirementtype, qtys, pbomMap, materialMap, materialInfo);
                    grossdemandSourceList.add(grossdemandSource);
                }
                String qtys = sumqty.stripTrailingZeros().toPlainString();
                if (qtys == null || "0".equals(qtys)) {
                    logger.warn(String.format("mrprunner-GrossdemandSource,\u7269\u6599 %s \u6570\u91cf\u4e3a0", grossdemandSourcecode.get("materialcode") + requirementtype));
                    continue;
                }
                DynamicObject grossdemandSource = this.setGrossdemandSource(planId, grossdemandSourcecode, requirementtype, qtys, pbomMap, materialMap, materialInfo);
                grossdemandSourceList.add(grossdemandSource);
            }
        }
    }

    private DynamicObject setGrossdemandSource(String planId, Map<String, String> grossdemandSourcecode, String requirementtype, String qtys, Map<Long, Long> pbomMap, Map<Long, Map<String, Object>> materialMap, MaterialInfo materialInfo) {
        DynamicObject grossdemandSource = this.getNewDynamicObject("mrp_gdd_source_base");
        Long configuredcode = materialInfo.getConfiguredcode();
        Long pconfiguredcode = materialInfo.getPconfiguredcode();
        Long material = materialInfo.getMaterialId();
        Long pmaterial = materialInfo.getPmaterialId();
        Long auxproperty = materialInfo.getAuxproperty();
        Long pauxproperty = materialInfo.getPauxproperty();
        grossdemandSource.set("caculatelog", (Object)planId);
        grossdemandSource.set("materialcode", (Object)material);
        grossdemandSource.set("configuredcode", (Object)configuredcode);
        grossdemandSource.set("auxproperty", (Object)auxproperty);
        grossdemandSource.set("materialparentcode", (Object)pmaterial);
        grossdemandSource.set("pconfiguredcode", (Object)pconfiguredcode);
        grossdemandSource.set("pauxproperty", (Object)pauxproperty);
        grossdemandSource.set("requirementtype", (Object)requirementtype);
        grossdemandSource.set("qty", (Object)qtys);
        if (materialMap.get(material) != null) {
            Map<String, Object> map = materialMap.get(material);
            grossdemandSource.set("productmodel", map.get("productmodel"));
            grossdemandSource.set("materialgroup", map.get("materialgroup"));
        }
        grossdemandSource.set("pbom", (Object)pbomMap.get(Long.parseLong(grossdemandSourcecode.get("materialparentcode"))));
        return grossdemandSource;
    }

    private void mapAddQTY(String requirementtype, BigDecimal qty, MaterialInfo materialInfo, String materialattr, Map<MaterialInfo, Map<String, Map<String, BigDecimal>>> codeMap) {
        BigDecimal sumQty;
        Map demandbillMap;
        HashMap map = codeMap.get(materialInfo);
        if (map == null) {
            map = Maps.newHashMapWithExpectedSize((int)100);
        }
        if ((demandbillMap = (Map)map.get(requirementtype)) == null) {
            demandbillMap = Maps.newHashMapWithExpectedSize((int)2);
        }
        if ((sumQty = (BigDecimal)demandbillMap.get(materialattr)) == null) {
            sumQty = BigDecimal.ZERO;
        }
        demandbillMap.put(materialattr, sumQty.add(qty));
        map.put(requirementtype, demandbillMap);
        codeMap.put(materialInfo, map);
    }

    private void mapAddQTY(Map<String, BigDecimal> Map2, String requirementtype, BigDecimal qty) {
        if (Map2.get(requirementtype) == null) {
            Map2.put(requirementtype, qty);
        } else {
            Map2.put(requirementtype, Map2.get(requirementtype).add(qty));
        }
    }

    private DynamicObject getNewDynamicObject(String entityNumber) {
        return orm.newDynamicObject(entityNumber);
    }

    public static <T> List<List<T>> averageAssign(List<T> source, int n) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        int remainder = source.size() % n;
        int number = source.size() / n;
        int offset = 0;
        for (int i = 0; i < n; ++i) {
            List<T> value = null;
            if (remainder > 0) {
                value = source.subList(i * number + offset, (i + 1) * number + offset + 1);
                --remainder;
                ++offset;
            } else {
                value = source.subList(i * number + offset, (i + 1) * number + offset);
            }
            if (value == null || value.size() <= 0) continue;
            result.add(value);
        }
        return result;
    }

    public String getAssociateForm() {
        return "mrp_grossdemand_source";
    }

    private static class MaterialInfo {
        Long materialId;
        Long configuredcode;
        Long auxproperty;
        Long pmaterialId;
        Long pconfiguredcode;
        Long pauxproperty;
        Long bomid;

        MaterialInfo(Long mt, Long configuredcode, Long auxproperty, Long pmaterialId, Long pconfiguredcode, Long pauxproperty, Long bomid) {
            this.materialId = mt;
            this.configuredcode = configuredcode;
            this.auxproperty = auxproperty;
            this.pmaterialId = pmaterialId;
            this.pconfiguredcode = pconfiguredcode;
            this.pauxproperty = pauxproperty;
            this.bomid = bomid;
        }

        public Long getMaterialId() {
            return this.materialId;
        }

        public Long getConfiguredcode() {
            return this.configuredcode;
        }

        public Long getAuxproperty() {
            return this.auxproperty;
        }

        public Long getPmaterialId() {
            return this.pmaterialId;
        }

        public Long getPconfiguredcode() {
            return this.pconfiguredcode;
        }

        public Long getPauxproperty() {
            return this.pauxproperty;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MaterialInfo materialInfo = (MaterialInfo)o;
            return Objects.equals(this.materialId, materialInfo.materialId) && Objects.equals(this.configuredcode, materialInfo.configuredcode) && Objects.equals(this.auxproperty, materialInfo.auxproperty) && Objects.equals(this.pmaterialId, materialInfo.pmaterialId) && Objects.equals(this.pconfiguredcode, materialInfo.pconfiguredcode) && Objects.equals(this.pauxproperty, materialInfo.pauxproperty) && Objects.equals(this.bomid, materialInfo.bomid);
        }

        public int hashCode() {
            return Objects.hash(this.materialId, this.configuredcode, this.auxproperty, this.pmaterialId, this.pconfiguredcode, this.pauxproperty, this.bomid);
        }
    }
}

