/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.controlnode.framework.step;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestContext;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.WaitingRejectedHandler;
import kd.bos.threads.impl.RequestContextRunnable;
import kd.mmc.mrp.exception.MRPBizException;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.step.IMRPStep;
import kd.mmc.mrp.framework.step.IMRPSubStep;
import kd.mmc.mrp.model.enums.EnvCfgItem;

public class MRPMParallelExecuteStep
implements IMRPStep,
Thread.UncaughtExceptionHandler {
    private static final Log logger = LogFactory.getLog(MRPMParallelExecuteStep.class);
    private IMRPEnvProvider ctx;
    private int percent;
    private AtomicInteger stepIdx;
    private Map<String, Set<String>> targetRelations;
    private Map<String, Set<String>> sourceRelations;
    private Map<String, IMRPStep> steps;
    private ExecutorService executor;

    public MRPMParallelExecuteStep(IMRPEnvProvider ctx, Map<String, Set<String>> targetRelations, Map<String, Set<String>> sourceRelations, Map<String, IMRPStep> steps) {
        this.ctx = ctx;
        this.targetRelations = targetRelations;
        this.sourceRelations = sourceRelations;
        this.steps = steps;
    }

    public void createStepLog(int stepIdx, int percent) {
        this.stepIdx = new AtomicInteger(stepIdx);
        this.percent = percent;
    }

    public void execute() {
        try {
            this.executeImpl();
        }
        finally {
            this.doFinally();
        }
    }

    private void executeImpl() {
        String poolName = "MMC-mrp-parallel-executor";
        int poolSize = (Integer)this.ctx.getCfgValue(EnvCfgItem.MRP_CALC_PROCESSOR);
        logger.warn(String.format("mmc-mrprunner-poolsize-overflow, current: %s, processors: %s", poolSize, Runtime.getRuntime().availableProcessors()));
        if (this.executor == null) {
            this.executor = ThreadLifeCycleManager.wrapExecutorService((ExecutorService)new ThreadPoolExecutor(poolSize, poolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(Integer.getInteger("threadpool.fix.maxqueue.size", 100000)), new ContextAwareableThreadFactory(poolName, this), (RejectedExecutionHandler)new WaitingRejectedHandler()));
        }
        int stepSize = this.steps.size();
        this.percent -= stepSize;
        while (!this.steps.isEmpty()) {
            this.executeSteps();
        }
    }

    public void doFinally() {
        if (this.executor == null) {
            return;
        }
        if (this.executor.isShutdown() || this.executor.isTerminated()) {
            this.executor = null;
            return;
        }
        this.executor.shutdown();
        this.executor = null;
    }

    protected void executeSteps() {
        String id;
        ArrayList<Map.Entry<String, IMRPStep>> levelSteps = new ArrayList<Map.Entry<String, IMRPStep>>();
        for (Map.Entry<String, IMRPStep> stepEntry : this.steps.entrySet()) {
            String string = stepEntry.getKey();
            if (this.sourceRelations.containsKey(string)) continue;
            levelSteps.add(stepEntry);
        }
        this.percent += levelSteps.size();
        ArrayList<Future<String>> results = new ArrayList<Future<String>>(levelSteps.size());
        for (Map.Entry entry : levelSteps) {
            id = (String)entry.getKey();
            IMRPStep step = (IMRPStep)entry.getValue();
            Future<String> r = this.executor.submit(new MRPParallelWrapper(id, step, this.stepIdx, this.percent));
            results.add(r);
        }
        while (!results.isEmpty()) {
            Iterator iter = results.iterator();
            while (iter.hasNext()) {
                this.ctx.testEnvStatus();
                Future future = (Future)iter.next();
                if (!future.isDone()) continue;
                iter.remove();
                try {
                    id = (String)future.get();
                }
                catch (Throwable e) {
                    Throwable cause = e.getCause();
                    logger.error("mmc-mrprunner-parallel-execution-failed", e);
                    if (cause != null) {
                        e = cause;
                    }
                    MRPBizException wrapper = new MRPBizException(e, new ErrorCode("parallel-execution-failed", e.getMessage()));
                    wrapper.setStackTrace(e.getStackTrace());
                    throw wrapper;
                }
                Set<String> nexts = this.targetRelations.get(id);
                if (nexts != null) {
                    for (String nextId : nexts) {
                        Set<String> prevs = this.sourceRelations.get(nextId);
                        if (prevs.size() <= 1) {
                            prevs.clear();
                        } else {
                            prevs.remove(id);
                        }
                        if (!prevs.isEmpty()) continue;
                        this.sourceRelations.remove(nextId);
                    }
                }
                this.steps.remove(id);
            }
        }
    }

    public List<IMRPSubStep> getSubSteps() {
        return null;
    }

    public String getStepDesc(Locale locale) {
        return null;
    }

    public IMRPEnvProvider getMRPContext() {
        return this.ctx;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        logger.error("mmc-mrp, uncaught-error, thread: " + t.getName(), e);
    }

    public int getInnerStepCount() {
        return this.stepIdx == null ? 2 : this.stepIdx.get();
    }

    public static class ContextAwareableThreadFactory
    implements ThreadFactory {
        private AtomicInteger atomicInteger = new AtomicInteger(0);
        private String poolName;
        private Thread.UncaughtExceptionHandler handler;
        private RequestContext rc;

        public ContextAwareableThreadFactory(String poolName, Thread.UncaughtExceptionHandler handler) {
            this.poolName = poolName;
            this.handler = handler;
            this.rc = RequestContext.get();
            if (this.rc == null) {
                throw new KDBizException(new ErrorCode("EMPTY_REQUEST_CONTEXT", "EMPTY_REQUEST_CONTEXT"), new Object[0]);
            }
        }

        @Override
        public Thread newThread(Runnable runnable) {
            runnable = ThreadLifeCycleManager.wrapRunnable((Runnable)new RequestContextRunnable(runnable, RequestContext.copy((RequestContext)this.rc)));
            Thread worker = new Thread(runnable, this.poolName + "-" + this.atomicInteger.incrementAndGet());
            worker.setUncaughtExceptionHandler(this.handler);
            return worker;
        }
    }

    public static class MRPParallelWrapper
    implements Callable<String> {
        private String id;
        private IMRPStep step;
        private AtomicInteger stepIdx;
        private int percent;

        public MRPParallelWrapper(String id, IMRPStep step, AtomicInteger stepIdx, int percent) {
            this.id = id;
            this.step = step;
            this.stepIdx = stepIdx;
            this.percent = percent;
        }

        @Override
        public String call() throws Exception {
            this.step.createStepLog(this.stepIdx.getAndIncrement(), this.percent);
            this.step.execute();
            return this.id;
        }
    }
}

