/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.controlnode.framework.step;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Locale;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.consts.Tips;
import kd.mmc.mrp.framework.step.AbstractMRPStep;
import kd.mmc.mrp.model.enums.status.MRPExecuteStatus;
import kd.mmc.mrp.utils.MRPUtil;

public class MRPMRunEnd
extends AbstractMRPStep {
    private static final Log logger = LogFactory.getLog(MRPMRunEnd.class);
    private Throwable e;
    private MRPExecuteStatus status;

    public MRPMRunEnd(IMRPEnvProvider ctx, Throwable e, MRPExecuteStatus status) {
        super(ctx);
        this.e = e;
        this.status = status;
    }

    protected void innerExecute() {
        logger.warn("mrprunner-run-finished, ctxid: " + this.ctx.getMRPContextId() + ", failed: " + (this.e != null));
        this.ctx.clearRuntimeEnv();
        this.lr.updateStepLog("entryresult", (Object)this.status.getAlias());
        if (this.e != null) {
            String errorMsg = this.e.getMessage();
            if (errorMsg != null && errorMsg.length() >= 125) {
                errorMsg = errorMsg.substring(0, 125);
            }
            this.lr.updateStepLog("entrydetailmsg", (Object)errorMsg);
            this.lr.updateStepLog("entrydetailmsg_tag", (Object)MRPUtil.getStackTrace((Throwable)this.e));
            logger.warn("mrprunner-run-finished-exception", this.e);
        }
        this.lr.updateRunLog("calculatestatus", (Object)this.status.getValue());
        Date startDate = this.lr.getLogStartDate();
        Date endDate = new Date();
        this.lr.updateRunLog("enddate", (Object)endDate);
        long second = endDate.getTime() / 1000L - startDate.getTime() / 1000L;
        BigDecimal time = new BigDecimal(second).divide(new BigDecimal(60), 2, RoundingMode.CEILING);
        this.lr.updateRunLog("summin", (Object)time);
    }

    public String getStepDesc(Locale locale) {
        return Tips.getCalcEnd();
    }
}

