/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.controlnode.framework.step;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataService;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.IMRPExecuteLogRecorder;
import kd.mmc.mrp.framework.consts.Tips;
import kd.mmc.mrp.framework.step.AbstractMRPStep;
import kd.mmc.mrp.integrate.utils.SnapshotDataIntegrateUtils;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mmc.mrp.utils.MRPUtil;
import kd.mpscmm.msplan.mservice.service.datasync.MMCSnapDataVisitor;

public class MRPMaterialIPlanSync
extends AbstractMRPStep {
    private static final Log logger = LogFactory.getLog(MRPMaterialIPlanSync.class);
    private HashSet<Long> planIds = new HashSet(0);
    private final HashSet<Long> allMaterialIds = new HashSet(0);
    private final HashSet<Long> useMaterialIds = new HashSet(0);
    private static final String algoKey = "MRPMaterialIPlanSync";
    private IMRPExecuteLogRecorder log = this.ctx.createLogRecorder();
    private static final ORM orm = ORM.create();
    private static final int count = 5000;
    private static final int logSize = 5000;
    int materialPlanUpdateSize = 0;
    int notFoundSize = 0;
    int materialPlanSize = 0;

    public MRPMaterialIPlanSync(IMRPEnvProvider ctx) {
        super(ctx);
    }

    public String getStepDesc(Locale var1) {
        return Tips.getSyncMaterialPlanInfo();
    }

    protected void innerExecute() {
        this.syncMaterialPlan();
    }

    public void syncMaterialPlan() {
        String runLogNum = this.ctx.getRunLogNumber();
        Long versionId = SnapshotDataIntegrateUtils.getVersionIdByRunLogNumber((String)runLogNum);
        this.planIds = this.getMaterialIds("mpdm_materialplan", "id,masterid as materialId", new QFilter[0], versionId);
        Map<Long, Set<Long>> orgToMaterials = this.getAllBOMMaterials(new QFilter[0], versionId);
        this.planIds.clear();
        this.removeInvLevel(orgToMaterials);
        this.insertPlan(orgToMaterials, versionId);
        this.dataAmount = this.materialPlanUpdateSize;
    }

    private void removeInvLevel(Map<Long, Set<Long>> orgToMaterials) {
        Boolean cfgValue = (Boolean)this.ctx.getCfgValue(EnvCfgItem.INV_LEVEL_CALC);
        if (cfgValue.booleanValue()) {
            for (Map.Entry<Long, Set<Long>> entry : orgToMaterials.entrySet()) {
                Set<Long> mIds = this.dispatchService(entry.getKey(), entry.getValue());
                entry.getValue().removeAll(mIds);
                this.allMaterialIds.removeAll(mIds);
            }
        }
    }

    private Set<Long> dispatchService(Long org, Set<Long> mtSet) {
        return (Set)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msplan", (String)"IMPDMCheckInvLevelService", (String)"isexist", (Object[])new Object[]{org, mtSet});
    }

    public Map<Long, Set<Long>> getAllBOMMaterials(QFilter[] filters, Long versionId) {
        String etStr = "pdm_mftbom";
        String selectFields = "createorg, materialid, entry.entrymaterialid entrymaterialid";
        HashMap<Long, Set<Long>> orgToMaterials = new HashMap<Long, Set<Long>>(16);
        this.addBOMMaterials(filters, versionId, etStr, selectFields, orgToMaterials);
        etStr = "pdm_superbom";
        selectFields = "createorg, material as materialid, entry.entrymaterial entrymaterialid";
        this.addBOMMaterials(filters, versionId, etStr, selectFields, orgToMaterials);
        return orgToMaterials;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBOMMaterials(QFilter[] filters, Long versionId, String etStr, String selectFields, Map<Long, Set<Long>> orgToMaterials) {
        try (DataSet ds = new MMCSnapDataVisitor().localFastDataVisit(versionId, null, etStr, selectFields, filters, null);){
            if (ds == null) {
                ds = orm.queryDataSet(algoKey, etStr, selectFields, filters);
            }
            this.loopBomDataDs(ds, orgToMaterials);
        }
    }

    private void loopBomDataDs(DataSet ds, Map<Long, Set<Long>> orgToMaterials) {
        while (ds.hasNext()) {
            Row row = ds.next();
            Long org = row.getLong("createorg");
            Long materialid = row.getLong("materialid");
            Long entrymaterialid = row.getLong("entrymaterialid");
            HashSet<Long> materials = new HashSet<Long>(2);
            materials.add(materialid);
            materials.add(entrymaterialid);
            materials.remove(0L);
            if (this.planIds.contains(materialid)) {
                materials.remove(materialid);
            }
            if (this.planIds.contains(entrymaterialid)) {
                materials.remove(entrymaterialid);
            }
            if (!materials.isEmpty()) {
                Set<Long> allMids = orgToMaterials.get(org);
                if (allMids == null) {
                    allMids = materials;
                } else {
                    allMids.addAll(materials);
                }
                orgToMaterials.put(org, allMids);
            }
            this.allMaterialIds.addAll(materials);
        }
    }

    public void insertPlan(Map<Long, Set<Long>> orgToMaterials, Long versionId) {
        if (!orgToMaterials.isEmpty()) {
            String tablename = SnapshotDataIntegrateUtils.queryLatestSnapTableName((Long)versionId, (String)"scm", (String)"t_mpdm_materialplan");
            String tablename_e = SnapshotDataIntegrateUtils.queryLatestSnapTableName((Long)versionId, (String)"scm", (String)"t_mpdm_materialplan_e");
            if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                logger.warn(String.format("MRPMaterialIPlanSync-select, materialPlan: table: %s,table_e: %s", tablename, tablename_e));
            }
            Map<Long, String> minfos = this.getMaterialInfos(this.allMaterialIds, versionId);
            Long manufacturegroupObj = this.getManuFactureGroup("MTS10", null);
            StringBuilder insertSql = new StringBuilder();
            StringBuilder insertSql_e = new StringBuilder();
            if (StringUtils.isBlank((CharSequence)tablename) || StringUtils.isBlank((CharSequence)tablename_e)) {
                tablename = "t_mpdm_materialplan";
                tablename_e = "t_mpdm_materialplan_e";
            }
            insertSql.append("insert ");
            insertSql.append(tablename);
            insertSql.append("(fid,fmasterid,fmaterialid,fcreateorgid,fmaterialattr,foperatorid,fctrlstrategy,fstatus,fenable,fplantag,fcreatorid,fcreatetime,fmodifierid,fmodifytime,fismrp,fadjustbatchstrtegy)");
            insertSql.append(" values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            insertSql_e.append("insert ");
            insertSql_e.append(tablename_e);
            insertSql_e.append("(fid,fplanmode,fmanufacturegroupid,freversalpriority,fwriteoffdirection,fforwardperiod,fbackwardperiod,freservedtype,fyield,fwastagerate,fwastagerateformula,fleadtimetype,ffixedleadtime,fchangeleadtime,finspectionleadtime,fpreprocessingtime,fpostprocessingtime,fchangebatch,flotpolicy,fbatchqty,fbatchincrement,fminlotsize,fmaxlotsize,fseparatorsymbol,fintervalperiod,fpartitionbase,fdynamiccycle,ffixedperiod)");
            insertSql_e.append(" values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            for (Map.Entry<Long, Set<Long>> entry : orgToMaterials.entrySet()) {
                this.createPlanObj(entry.getKey(), entry.getValue(), minfos, insertSql, insertSql_e, manufacturegroupObj);
                BaseDataService baseDataService = new BaseDataService();
                baseDataService.clearBaseDataFilterCache("mpdm_materialplan", entry.getKey());
            }
            BaseDataServiceHelper.refreshBaseDataUseRange((String)"mpdm_materialplan", new ArrayList<Long>(orgToMaterials.keySet()));
        }
    }

    private void createPlanObj(Long org, Set<Long> mIds, Map<Long, String> minfos, StringBuilder insertSql, StringBuilder insertSql_e, Long manufacturegroup) {
        ArrayList<Object[]> allParams = new ArrayList<Object[]>(5000);
        ArrayList<Object[]> allParams_e = new ArrayList<Object[]>(5000);
        long[] ids = orm.genLongIds("mpdm_materialplan", mIds.size());
        int i = 0;
        for (Long mid : mIds) {
            if (this.useMaterialIds.contains(mid)) continue;
            long fid = ids[i++];
            if (!this.createPlanBySQL(allParams, allParams_e, insertSql, insertSql_e, org, mid, minfos.get(mid), manufacturegroup, fid)) continue;
            this.useMaterialIds.add(mid);
        }
        if (!allParams.isEmpty()) {
            this.executeSqlMaterialPlan(insertSql, insertSql_e, allParams, allParams_e);
            String info = String.format(ResManager.loadKDString((String)"\u540c\u6b65\u7269\u6599\u8ba1\u5212\u4fe1\u606f\uff1a\u9700\u540c\u6b65\u603b\u91cf %1$s\u6761,\u5df2\u5b8c\u6210\u540c\u6b65\u6570\u91cf\uff1a%2$s \u6761,\u627e\u4e0d\u5230\u7269\u6599\u751f\u4ea7\u4fe1\u606f\uff1a%3$s;", (String)"MRPMaterialIPlanSync_1", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), this.allMaterialIds.size(), this.materialPlanUpdateSize, this.notFoundSize);
            this.log.updateStepLog("entrydetailmsg", (Object)info);
            this.log.saveStepLog(false);
        }
    }

    private boolean createPlanBySQL(List<Object[]> allParams, List<Object[]> allParams_e, StringBuilder insertSql, StringBuilder insertSql_e, Long org, Long mid, String attr, Long manufacturegroup, long fid) {
        String logStartStr = "MRPMaterialIPlanSync-insert, materialPlan: fid:, material: , masterid:";
        StringBuilder logSb = new StringBuilder();
        StringBuilder logmaterial = new StringBuilder();
        if (StringUtils.isBlank((CharSequence)attr)) {
            ++this.notFoundSize;
            return false;
        }
        Object[] p = new Object[16];
        p[0] = fid;
        p[1] = mid;
        p[2] = mid;
        logmaterial.append('[');
        logmaterial.append(fid);
        logmaterial.append(',');
        logmaterial.append(mid);
        logmaterial.append(',');
        logmaterial.append(p[1]);
        logmaterial.append(']');
        if (logmaterial.length() > 5000) {
            logSb.append(logStartStr);
            logSb.append((CharSequence)logmaterial);
            if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                logger.info(logSb.toString());
            }
            logSb.delete(0, logSb.length());
            logmaterial.delete(0, logmaterial.length());
        }
        p[3] = org;
        p[4] = attr;
        p[5] = RequestContext.get().getCurrUserId();
        p[6] = "5";
        p[7] = "C";
        p[8] = "1";
        p[9] = "A";
        p[10] = RequestContext.get().getCurrUserId();
        p[11] = new Date();
        p[12] = RequestContext.get().getCurrUserId();
        p[13] = new Date();
        p[14] = true;
        p[15] = false;
        Object[] p_e = new Object[]{fid, "D", manufacturegroup, "A", "A", new BigDecimal(0), new BigDecimal(0), "C", new BigDecimal(1), new BigDecimal(0), "B", "A", new BigDecimal(0), new BigDecimal(0), new BigDecimal(0), new BigDecimal(0), new BigDecimal(0), new BigDecimal(0), "A", new BigDecimal(0), new BigDecimal(0), new BigDecimal(0), new BigDecimal(0), "A", new BigDecimal(0), new BigDecimal(0), new BigDecimal(0), new BigDecimal(0)};
        allParams.add(p);
        allParams_e.add(p_e);
        if (allParams.size() >= 5000) {
            this.executeSqlMaterialPlan(insertSql, insertSql_e, allParams, allParams_e);
            allParams.clear();
            allParams_e.clear();
            String info = String.format(ResManager.loadKDString((String)"\u540c\u6b65\u7269\u6599\u8ba1\u5212\u4fe1\u606f\uff1a\u9700\u540c\u6b65\u603b\u91cf %1$s\u6761,\u5df2\u5b8c\u6210\u540c\u6b65\u6570\u91cf\uff1a%2$s \u6761,\u627e\u4e0d\u5230\u7269\u6599\u751f\u4ea7\u4fe1\u606f\uff1a%3$s;", (String)"MRPMaterialIPlanSync_1", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), this.allMaterialIds.size(), this.materialPlanUpdateSize, this.notFoundSize);
            this.log.updateStepLog("entrydetailmsg", (Object)info);
            this.log.saveStepLog(false);
        }
        if (logmaterial.length() > 0) {
            logSb.append(logStartStr);
            logSb.append((CharSequence)logmaterial);
            if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                logger.info(logSb.toString());
            }
        }
        return true;
    }

    private void executeSqlMaterialPlan(StringBuilder insertSql, StringBuilder insertSql_e, List<Object[]> allParams, List<Object[]> allParams_e) {
        try (TXHandle h0 = TX.requiresNew();){
            try {
                if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                    logger.warn(String.format("MRPMaterialIPlanSync-insert, materialPlan: start exe count %s ", this.materialPlanUpdateSize));
                }
                this.materialPlanUpdateSize += allParams.size();
                int[] res = DB.executeBatch((DBRoute)new DBRoute("scm"), (String)insertSql.toString(), allParams);
                DB.executeBatch((DBRoute)new DBRoute("scm"), (String)insertSql_e.toString(), allParams_e);
                for (int i : res) {
                    if (i == -2) {
                        ++this.materialPlanSize;
                        continue;
                    }
                    if (i <= 0) continue;
                    this.materialPlanSize += i;
                }
                allParams.clear();
                allParams_e.clear();
                if ("1".equals(this.ctx.getCfgValue(EnvCfgItem.RECORD_DETAIL_LOG))) {
                    logger.warn(String.format("MRPMaterialIPlanSync-insert, materialPlan: end exe count %s,materialPlanSize:%s,res:%s ", this.materialPlanUpdateSize, this.materialPlanSize, res));
                }
            }
            catch (Throwable throwable) {
                logger.error("MRPMaterialIPlanSync-insert, materialPlan: exe faild ", throwable);
                h0.markRollback();
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7269\u6599\u8ba1\u5212\u4fe1\u606f\u65b0\u589e\u5931\u8d25:%s", (String)"MRPMaterialIPlanSync_2", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), MRPUtil.getStackTrace((Throwable)throwable)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getManuFactureGroup(String number, Long versionId) {
        Long id;
        QFilter filter = new QFilter("number", "=", (Object)number);
        QFilter[] filters = new QFilter[]{filter};
        String etStr = "mpdm_manustrategy_group";
        String selectFields = "id";
        try (DataSet ds = new MMCSnapDataVisitor().localFastDataVisit(versionId, null, etStr, selectFields, filters, null);){
            if (ds == null) {
                ds = orm.queryDataSet(algoKey, etStr, selectFields, filters, null, 1);
            }
            id = this.loopManuFactureGroup(ds);
        }
        return id;
    }

    private Long loopManuFactureGroup(DataSet ds) {
        if (ds.hasNext()) {
            Row row = ds.next();
            return row.getLong(0);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, String> getMaterialInfos(Set<Long> mids, Long versionId) {
        QFilter filter = new QFilter("masterid", "in", mids);
        QFilter[] filters = new QFilter[]{filter};
        String etStr = "bd_materialmftinfo";
        String selectFields = "id,masterid,materialattr";
        HashMap<Long, String> map = new HashMap<Long, String>();
        try (DataSet ds = new MMCSnapDataVisitor().localFastDataVisit(versionId, null, etStr, selectFields, filters, null);){
            if (ds == null) {
                ds = orm.queryDataSet(algoKey, etStr, selectFields, filters);
            }
            this.loopMinfoDs(ds, map);
        }
        return map;
    }

    private void loopMinfoDs(DataSet ds, Map<Long, String> map) {
        while (ds.hasNext()) {
            Row row = ds.next();
            Long masterid = row.getLong("masterid");
            map.put(masterid, row.getString("materialattr"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet<Long> getMaterialIds(String entryName, String fields, QFilter[] filters, Long versionId) {
        HashSet<Long> ids = new HashSet<Long>();
        try (DataSet ds = new MMCSnapDataVisitor().localFastDataVisit(versionId, null, entryName, fields, filters, null);){
            if (ds == null) {
                ds = orm.queryDataSet(algoKey, entryName, fields, filters);
            }
            this.loopMaterialPlanInfo(ds, ids);
        }
        return ids;
    }

    private void loopMaterialPlanInfo(DataSet ds, HashSet<Long> ids) {
        for (Row row : ds) {
            long materialId = row.getLong("materialId");
            ids.add(materialId);
        }
    }
}

