/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.controlnode.framework.step;

import java.util.HashSet;
import java.util.Locale;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.IMRPExecuteLogRecorder;
import kd.mmc.mrp.framework.consts.Tips;
import kd.mmc.mrp.framework.step.AbstractMRPStep;
import kd.mmc.mrp.integrate.entity.RequireDataModel;
import kd.mmc.mrp.integrate.utils.SnapshotDataIntegrateUtils;

public class MRPMaterialPlanDel
extends AbstractMRPStep {
    private String outputType;

    public MRPMaterialPlanDel(IMRPEnvProvider ctx) {
        super(ctx);
    }

    public String getStepDesc(Locale var1) {
        return Tips.getDeleteMaterialPlanInfo();
    }

    protected void innerExecute() {
        this.delMaterialPlanInfo();
    }

    private void delMaterialPlanInfo() {
        String runLogNum = this.ctx.getRunLogNumber();
        Long versionId = SnapshotDataIntegrateUtils.getVersionIdByRunLogNumber((String)runLogNum);
        if (versionId != null && versionId != 0L) {
            return;
        }
        RequireDataModel require = (RequireDataModel)this.ctx.getService(RequireDataModel.class);
        this.outputType = require.getOutputType();
        if (!require.isPlanOrderExtendEntity()) {
            this.outputType = "mrp_planorder";
        }
        QFilter runlogfilter = new QFilter("calculatestatus", "=", (Object)"D");
        runlogfilter.and(new QFilter("number", "!=", (Object)runLogNum));
        runlogfilter.and(new QFilter("operatmodekey", "=", (Object)"mrp_globalplan"));
        DynamicObjectCollection runlogs = QueryServiceHelper.query((String)"mrp_caculate_log", (String)"id,number", (QFilter[])new QFilter[]{runlogfilter});
        if (runlogs != null && !runlogs.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < runlogs.size(); ++i) {
                DynamicObject runlog = (DynamicObject)runlogs.get(i);
                sb.append(runlog.getString("number"));
                if (i >= runlogs.size() - 1) continue;
                sb.append(',');
            }
            String msg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5b58\u5728\u8fd0\u884c\u4e2d\u7684\u8fd0\u7b97\u65e5\u5fd7\uff1a%s\uff0c\u65e0\u6cd5\u5220\u9664\u8ba1\u5212\u4fe1\u606f\u3002", (String)"MRPMaterialPlanDel_0", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), sb.toString());
            IMRPExecuteLogRecorder log = this.ctx.createLogRecorder();
            log.updateStepLog("entrydetailmsg", (Object)msg);
            log.saveStepLog(false);
            return;
        }
        this.deleteMRPMaterialPlan();
    }

    private void deleteMRPMaterialPlan() {
        Row row;
        QFilter filter = new QFilter("ismrp", "=", (Object)true);
        HashSet<Long> ids = new HashSet<Long>(0);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mpdm_materialplan", (String)"id", (QFilter[])new QFilter[]{filter}, null);){
            while (dataSet.hasNext()) {
                row = dataSet.next();
                ids.add(row.getLong(0));
            }
        }
        if (ids.isEmpty()) {
            return;
        }
        filter = new QFilter("materialplanid", "in", ids);
        dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)this.outputType, (String)"materialplanid", (QFilter[])new QFilter[]{filter}, null);
        var4_4 = null;
        try {
            while (dataSet.hasNext()) {
                row = dataSet.next();
                ids.remove(row.getLong(0));
            }
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (var4_4 != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        filter = new QFilter("id", "in", ids);
        this.dataAmount = DeleteServiceHelper.delete((String)"mpdm_materialplan", (QFilter[])new QFilter[]{filter});
    }
}

