/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.controlnode.framework.step;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mrp.common.enums.MaterialAttrEnum;
import kd.mmc.mrp.common.util.SnapshotDataUtils;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.cache.MRPCacheManager;
import kd.mmc.mrp.framework.consts.Tips;
import kd.mmc.mrp.framework.step.AbstractMRPStep;
import kd.mmc.mrp.rpt.enmus.RptTypeEnum;
import kd.mmc.mrp.rpt.entity.RptSchemeInfo;
import kd.mmc.mrp.rpt.util.CalcDocumentsPlanUtils;
import kd.mmc.mrp.rpt.util.CalcProductionForecastUtils;
import kd.mmc.mrp.rpt.util.RptUtils;
import kd.mmc.mrp.utils.MRPUtil;

public class MRPSaveDocumentsPlan
extends AbstractMRPStep {
    private static final Log logger = LogFactory.getLog(MRPSaveDocumentsPlan.class);
    private static final String ALGO_KEY = MRPSaveDocumentsPlan.class.getName();
    private final Long versionId;
    protected static final String[] calcResultFields = new String[]{"demandbilltype", "billno", "llc", "materialattr", "adjustsuggest", "supplybillf7", "supmaterial", "supplyorg", "supplydate", "demanddate", "demandqty", "supplyqty", "adjustqty", "billentryseq", "reqsourcebillno", "adjustdate", "billid", "billentryid", "operator"};
    protected static final DataType[] calcResultTypes = new DataType[]{DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.LongType, DataType.LongType, DataType.DateType, DataType.DateType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.IntegerType, DataType.StringType, DataType.DateType, DataType.LongType, DataType.LongType, DataType.LongType};
    protected static final String[] materialPlanFields = new String[]{"masterid", "createorg", "operator", "demandmodel"};
    protected static final DataType[] materialPlanTypes = new DataType[]{DataType.LongType, DataType.LongType, DataType.LongType, DataType.StringType};
    private Set<Long> materialIdSet;
    private Set<Long> orgIdSet;
    private String algoKey = ((Object)((Object)this)).getClass().getName();

    public MRPSaveDocumentsPlan(IMRPEnvProvider ctx) {
        super(ctx);
        this.versionId = SnapshotDataUtils.getVersionIdByRunLogNumber((String)ctx.getRunLogNumber());
        this.materialIdSet = new HashSet<Long>();
        this.orgIdSet = new HashSet<Long>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void innerExecute() {
        try {
            String planNo = this.ctx.getRunLog().getString("number");
            long planId = this.ctx.getRunLog().getLong("plangram");
            RptSchemeInfo rptSchemeInfo = RptUtils.getRptSchemeInfo((long)0L, (String)RptTypeEnum.DOCUMENTS_PLAN.getValue());
            if (rptSchemeInfo == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5ba1\u6838\u4e14\u53ef\u7528\u7684\u62a5\u8868\u65b9\u6848\u3002", (String)"MRPSaveDocumentsPlan_3", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]));
            }
            List plan = rptSchemeInfo.getPlan();
            if (plan.size() > 0 && !plan.contains(planId)) {
                return;
            }
            Set<String> materialIds = this.getAllMaterialIds();
            DataSet detailDataSet = this.queryMrpCalcDetail(materialIds, rptSchemeInfo);
            DataSet materialPlanDataSet = CalcDocumentsPlanUtils.queryMaterialPlanInfo((String)this.algoKey, this.stringToLong(materialIds), this.orgIdSet);
            DataSet calDetailDataSet = CalcDocumentsPlanUtils.dealDatasWithResource((DataSet)detailDataSet);
            Date historyEarlyDate = null;
            Date lastestDate = null;
            for (Row row2 : calDetailDataSet.copy()) {
                Date date = row2.getDate("demanddate");
                if (historyEarlyDate == null) {
                    historyEarlyDate = date;
                }
                if (lastestDate == null) {
                    lastestDate = date;
                }
                if (date != null && date.compareTo(historyEarlyDate) <= 0) {
                    historyEarlyDate = date;
                }
                if (date == null || date.compareTo(lastestDate) <= 0) continue;
                lastestDate = date;
            }
            Map planInfo = CalcProductionForecastUtils.getPlanInfos(null, (long)planId);
            DataSet materialInvDataSet = CalcDocumentsPlanUtils.queryMaterialInvQty((String)this.algoKey, this.materialIdSet, (Set)((Set)planInfo.get("storageorg")), (Set)((Set)planInfo.get("warehouse")), (Set)((Set)planInfo.get("location")), (RptSchemeInfo)rptSchemeInfo);
            DataSet materialGoodDataSet = CalcDocumentsPlanUtils.queryMaterialGoodInvQty((String)this.algoKey, this.materialIdSet, (Set)((Set)planInfo.get("storageorg")), (Set)((Set)planInfo.get("goodwarehouse")), (Set)((Set)planInfo.get("goodlocation")), (RptSchemeInfo)rptSchemeInfo);
            DataSet materialNoStandardDataSet = CalcDocumentsPlanUtils.queryMaterialNoStandardQty((String)this.algoKey, (long)0L, this.materialIdSet);
            DataSet dataSet = CalcDocumentsPlanUtils.relateDataSet((DataSet)calDetailDataSet, (DataSet)materialPlanDataSet, (DataSet)materialInvDataSet, (DataSet)materialGoodDataSet, (DataSet)materialNoStandardDataSet);
            Map params = RptUtils.createParams((RptSchemeInfo)rptSchemeInfo, (Date)historyEarlyDate, (Date)lastestDate);
            dataSet = CalcDocumentsPlanUtils.createNewDataSet((String)this.algoKey, (Map)params, (DataSet)dataSet);
            dataSet.copy().forEach(row -> ++this.dataAmount);
            CalcDocumentsPlanUtils.createDocumentsDatas((DataSet)dataSet, (String)planNo, (Map)params);
        }
        catch (Exception e) {
            logger.error("\u4ea4\u5355\u8ba1\u5212\u751f\u6210\u5f02\u5e38", (Throwable)e);
            this.lr.updateStepLog("entrydetailmsg", (Object)String.format(ResManager.loadKDString((String)"\u4ea4\u5355\u8ba1\u5212\u751f\u6210\u5f02\u5e38\uff1a%s", (String)"MRPSaveDocumentsPlan_0", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), e.getMessage()));
            this.lr.updateStepLog("entrydetailmsg_tag", (Object)MRPUtil.getStackTrace((Throwable)e));
        }
        finally {
            Algo.closeAllDataSet();
        }
    }

    private Set<String> getAllMaterialIds() {
        List llcMaterialIds = this.ctx.bomDatas().getLLC();
        Set requireMaterialIds = this.ctx.bomDatas().getRequireMaterials();
        HashSet<String> materialIds = new HashSet<String>(requireMaterialIds);
        for (Set ids : llcMaterialIds) {
            materialIds.addAll(ids);
        }
        return materialIds;
    }

    private DataSet queryMrpCalcDetail(Set<String> materialIds, RptSchemeInfo rptSchemeInfo) {
        List source = rptSchemeInfo.getSource();
        DynamicObjectCollection dataConfigs = QueryServiceHelper.query((String)"mrp_resource_dataconfig", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)source)});
        ArrayList billType = new ArrayList(8);
        if (dataConfigs != null && dataConfigs.size() != 0) {
            dataConfigs.forEach(dataConfig -> billType.add(dataConfig.getString("name")));
        }
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])calcResultFields, (DataType[])calcResultTypes);
        Algo algo = Algo.create((String)ALGO_KEY);
        DataSetBuilder dataSetBuilder = algo.createDataSetBuilder(rowMeta);
        for (String materialId : materialIds) {
            List materialDetails = MRPCacheManager.getInst().getMaterialDetails((CalEnv)this.ctx, materialId);
            for (Map materialDetail : materialDetails) {
                String supplybillf7;
                BigDecimal supplyqty;
                BigDecimal demandqty;
                String materialattr = String.valueOf(materialDetail.get("materialattr"));
                if (StringUtils.equals((CharSequence)MaterialAttrEnum.PURCHASEDPART.getValue(), (CharSequence)materialattr)) continue;
                String demandbilltype = (String)materialDetail.get("demandbilltype");
                if (!billType.isEmpty() && !billType.contains(demandbilltype) || (demandqty = (BigDecimal)materialDetail.get("demandqty")) == null || BigDecimal.ZERO.compareTo(demandqty) == 0 || (supplyqty = (BigDecimal)materialDetail.get("supplyqty")) == null || BigDecimal.ZERO.compareTo(supplyqty) == 0) continue;
                String adjustsuggest = (String)materialDetail.get("adjustsuggest");
                if (StringUtils.equals((CharSequence)ResManager.loadKDString((String)"\u5efa\u8bae\u53d6\u6d88", (String)"MRPSaveDocumentsPlan_2", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), (CharSequence)adjustsuggest) || (supplybillf7 = (String)materialDetail.get("supplybillf7")) != null && supplybillf7.contains("inv")) continue;
                String billno = (String)materialDetail.get("billno");
                String llc = (String)materialDetail.get("llc");
                Long supmaterial = (Long)materialDetail.get("supmaterial");
                Object supplyorg = materialDetail.get("supplyorg");
                supplyorg = supplyorg == null ? Long.valueOf(0L) : (supplyorg instanceof Integer ? Long.valueOf(String.valueOf(supplyorg)) : supplyorg);
                Long supplydate = (Long)materialDetail.get("supplydate");
                Long demanddate = (Long)materialDetail.get("demanddate");
                BigDecimal adjustqty = (BigDecimal)materialDetail.get("adjustqty");
                Integer billentryseq = (Integer)materialDetail.get("billentryseq");
                String reqsourcebillno = (String)materialDetail.get("reqsourcebillno");
                Object[] value = new Object[]{demandbilltype, billno, llc, materialattr, adjustsuggest, supplybillf7, supmaterial, supplyorg, supplydate == null ? null : new Date(supplydate), demanddate == null ? null : new Date(demanddate), demandqty, supplyqty, adjustqty == null ? BigDecimal.ZERO : adjustqty, billentryseq == null ? Integer.valueOf(0) : billentryseq, reqsourcebillno, materialDetail.get("adjustdate") == null ? null : new Date((Long)DataType.convertValue((DataType)DataType.LongType, materialDetail.get("adjustdate"))), materialDetail.get("billid"), materialDetail.get("billentryid"), materialDetail.get("supplyoperator")};
                dataSetBuilder.append(value);
                this.materialIdSet.add(supmaterial);
                this.orgIdSet.add((Long)supplyorg);
            }
        }
        return dataSetBuilder.build();
    }

    private Set<Long> stringToLong(Set<String> strings) {
        HashSet<Long> sets = new HashSet<Long>(strings.size());
        for (String str : strings) {
            sets.add(Long.valueOf(str));
        }
        return sets;
    }

    public String getStepDesc(Locale locale) {
        return Tips.getSaveDocumentsplan();
    }
}

