/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.controlnode.framework.step;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mrp.common.enums.MaterialAttrEnum;
import kd.mmc.mrp.common.util.SnapshotDataUtils;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.cache.MRPCacheManager;
import kd.mmc.mrp.framework.cache.MRPRedisStore;
import kd.mmc.mrp.framework.consts.MRPRuntimeConsts;
import kd.mmc.mrp.framework.consts.Tips;
import kd.mmc.mrp.framework.step.AbstractMRPStep;
import kd.mmc.mrp.rpt.enmus.RptTypeEnum;
import kd.mmc.mrp.rpt.entity.RptSchemeInfo;
import kd.mmc.mrp.rpt.util.CalcProductionForecastUtils;
import kd.mmc.mrp.rpt.util.CalcStockForecastUtils;
import kd.mmc.mrp.rpt.util.RptUtils;
import kd.mmc.mrp.utils.MRPUtil;

public class MRPSaveStockForecast
extends AbstractMRPStep {
    private final String algoKey = ((Object)((Object)this)).getClass().getName();
    private static final Log log = LogFactory.getLog(MRPSaveStockForecast.class);
    private static final String[] fields = new String[]{"entryentity.material", "entryentity.supplyqty", "entryentity.supplyorg", "entryentity.demanddate", "entryentity.demandqty", "entryentity.adjustdate", "entryentity.adjustqty", "entryentity.demandbillf7", "entryentity.supplybillf7", "entryentity.adjustsuggest", "entryentity.billno", "entryentity.requireoperator", "entryentity.billentryseq", "entryentity.demandbilltype", "entryentity.reqsourcebillno", "entryentity.billid", "entryentity.billentryid", "entryentity.llc"};
    private static final DataType[] fieldType = new DataType[]{DataType.LongType, DataType.BigDecimalType, DataType.LongType, DataType.DateType, DataType.BigDecimalType, DataType.DateType, DataType.BigDecimalType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.LongType, DataType.LongType, DataType.StringType, DataType.StringType, DataType.LongType, DataType.LongType, DataType.StringType};
    private static final String[] planFields = new String[]{"masterid", "createorg", "operator", "demandmodel"};
    private static final DataType[] planFieldsType = new DataType[]{DataType.LongType, DataType.LongType, DataType.LongType, DataType.StringType};
    private final StringBuilder sb;
    private final Long versionId;
    private Set<Long> orgId;

    public MRPSaveStockForecast(IMRPEnvProvider ctx) {
        super(ctx);
        this.versionId = SnapshotDataUtils.getVersionIdByRunLogNumber((String)ctx.getRunLogNumber());
        this.sb = new StringBuilder();
        this.orgId = new HashSet<Long>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void innerExecute() {
        try {
            long planId = Long.parseLong(this.ctx.getPlanId());
            String logNumber = this.ctx.getRunLogNumber();
            RptSchemeInfo rptSchemeInfo = RptUtils.getRptSchemeInfo((long)0L, (String)RptTypeEnum.STOCK_FORECAST.getValue());
            if (rptSchemeInfo == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5ba1\u6838\u4e14\u53ef\u7528\u7684\u62a5\u8868\u65b9\u6848\u3002", (String)"MRPSaveStockForecast_0", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]));
            }
            List plan = rptSchemeInfo.getPlan();
            if (plan.size() > 0 && !plan.contains(planId)) {
                return;
            }
            Set<String> allMaterialIds = this.getAllMaterialIds();
            List allPlanTags = this.ctx.getAllPlanTags();
            Map<String, Object> materialMap = this.createMaterialMap(allMaterialIds, allPlanTags);
            DataSet materialBaseDataSet = (DataSet)materialMap.get("base");
            DataSet detailDataSet = this.createCalDeatailDataSet(allMaterialIds, rptSchemeInfo);
            DataSet calDetailDataSet = CalcStockForecastUtils.dealDatasWithResource((DataSet)detailDataSet);
            Date historyEarlyDate = null;
            Date lastestDate = null;
            for (Row row2 : calDetailDataSet.copy()) {
                Date date = row2.getDate("entryentity.demanddate");
                if (historyEarlyDate == null) {
                    historyEarlyDate = date;
                }
                if (lastestDate == null) {
                    lastestDate = date;
                }
                if (date != null && date.compareTo(historyEarlyDate) <= 0) {
                    historyEarlyDate = date;
                }
                if (date == null || date.compareTo(lastestDate) <= 0) continue;
                lastestDate = date;
            }
            Map planInfo = CalcProductionForecastUtils.getPlanInfos((Long)this.versionId, (long)planId);
            DataSet materialPlanDataSet = CalcStockForecastUtils.queryMaterialPlanInfo((String)this.algoKey, this.stringToLong(allMaterialIds), this.orgId);
            DataSet materialInvDataSet = CalcStockForecastUtils.queryMaterialInventory((String)this.algoKey, this.stringToLong(allMaterialIds), (Set)((Set)planInfo.get("storageorg")), (Set)((Set)planInfo.get("warehouse")), (Set)((Set)planInfo.get("location")), (RptSchemeInfo)rptSchemeInfo);
            DataSet invQtyDataSet = CalcStockForecastUtils.getInvQtyDataSet((DataSet)detailDataSet);
            DataSet dullQtyDataSet = CalcStockForecastUtils.getDullQtyDataSet((DataSet)detailDataSet);
            DataSet weekQtyDataSet = CalcStockForecastUtils.queryWeekQty((String)this.algoKey, (RptSchemeInfo)rptSchemeInfo);
            DataSet monthQtyDataSet = CalcStockForecastUtils.queryMonthQty((String)this.algoKey, (RptSchemeInfo)rptSchemeInfo);
            DataSet dataSet = CalcStockForecastUtils.relateDataSet((DataSet)calDetailDataSet, (DataSet)materialBaseDataSet, (DataSet)materialPlanDataSet, (DataSet)materialInvDataSet, (DataSet)invQtyDataSet, (DataSet)weekQtyDataSet, (DataSet)monthQtyDataSet, (DataSet)dullQtyDataSet);
            LinkedHashMap pbomDatas = new LinkedHashMap(8);
            dataSet = CalcStockForecastUtils.dealPbomDatas((String)this.algoKey, (DataSet)dataSet, this.orgId, pbomDatas);
            Map params = RptUtils.createParams((RptSchemeInfo)rptSchemeInfo, (Date)historyEarlyDate, (Date)lastestDate);
            dataSet = CalcStockForecastUtils.createNewDataSet((String)this.algoKey, (Map)params, (DataSet)dataSet, pbomDatas);
            dataSet.copy().forEach(row -> ++this.dataAmount);
            CalcStockForecastUtils.createStockDatas((DataSet)dataSet, (String)logNumber, (Map)params);
        }
        catch (Exception e) {
            log.error("\u5907\u6599\u9884\u6d4b\u751f\u6210\u5f02\u5e38", (Throwable)e);
            this.lr.updateStepLog("entrydetailmsg", (Object)String.format(ResManager.loadKDString((String)"\u5907\u6599\u9884\u6d4b\u751f\u6210\u5f02\u5e38\uff1a%s", (String)"MRPSaveStockForecast_1", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), e.getMessage()));
            this.lr.updateStepLog("entrydetailmsg_tag", (Object)MRPUtil.getStackTrace((Throwable)e));
        }
        finally {
            Algo.closeAllDataSet();
        }
    }

    public String getStepDesc(Locale locale) {
        return Tips.getSaveStockforecast();
    }

    private Set<String> getAllMaterialIds() {
        List llcMaterialIds = this.ctx.bomDatas().getLLC();
        Set requireMaterialIds = this.ctx.bomDatas().getRequireMaterials();
        HashSet<String> materialIds = new HashSet<String>(requireMaterialIds);
        for (Set ids : llcMaterialIds) {
            materialIds.addAll(ids);
        }
        return materialIds;
    }

    private DataSet createCalDeatailDataSet(Set<String> materialIds, RptSchemeInfo rptSchemeInfo) {
        List source = rptSchemeInfo.getSource();
        DynamicObjectCollection dataConfigs = QueryServiceHelper.query((String)"mrp_resource_dataconfig", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)source)});
        ArrayList billType = new ArrayList(8);
        if (dataConfigs != null && dataConfigs.size() != 0) {
            dataConfigs.forEach(dataConfig -> billType.add(dataConfig.getString("name")));
        }
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])fields, (DataType[])fieldType);
        DataSetBuilder dataSetBuilder = Algo.create((String)this.algoKey).createDataSetBuilder(rowMeta);
        for (String materialId : materialIds) {
            List materialDetails = MRPCacheManager.getInst().getMaterialDetails((CalEnv)this.ctx, materialId);
            if (materialDetails.isEmpty()) {
                this.sb.setLength(0);
                this.sb.append("[StockForecast][").append(materialId).append("] get null from cache");
                log.info(this.sb.toString());
                continue;
            }
            for (Map materialDetail : materialDetails) {
                Object requiretype;
                BigDecimal supplyQty;
                BigDecimal demandQty;
                String materialAttr = (String)DataType.convertValue((DataType)DataType.StringType, materialDetail.get("materialattr"));
                if (StringUtils.equals((CharSequence)MaterialAttrEnum.PURCHASEDPART.getValue(), (CharSequence)materialAttr) || (demandQty = MRPUtil.toBigDecimal(materialDetail.get("demandqty"))) == null || BigDecimal.ZERO.compareTo(demandQty) == 0 || (supplyQty = MRPUtil.toBigDecimal(materialDetail.get("supplyqty"))) == null || BigDecimal.ZERO.compareTo(supplyQty) == 0 || (requiretype = materialDetail.get("demandbilltype")) != null && !billType.isEmpty() && !billType.contains(requiretype.toString())) continue;
                Date demandDate = null;
                if (materialDetail.get("demanddate") != null) {
                    demandDate = new Date((Long)DataType.convertValue((DataType)DataType.LongType, materialDetail.get("demanddate")));
                }
                long supplyOrg = (Long)DataType.convertValue((DataType)DataType.LongType, materialDetail.get("supplyorg"));
                this.orgId.add(supplyOrg);
                Object[] value = new Object[]{Long.parseLong(materialId), supplyQty, supplyOrg, demandDate, demandQty, materialDetail.get("adjustdate") == null ? null : new Date((Long)DataType.convertValue((DataType)DataType.LongType, materialDetail.get("adjustdate"))), materialDetail.get("adjustqty"), materialDetail.get("demandbillf7"), materialDetail.get("supplybillf7"), materialDetail.get("adjustsuggest"), materialDetail.get("billno"), materialDetail.get("requireoperator"), materialDetail.get("billentryseq"), requiretype, materialDetail.get("reqsourcebillno"), materialDetail.get("billid"), materialDetail.get("billentryid"), materialDetail.get("llc")};
                dataSetBuilder.append(value);
            }
        }
        return dataSetBuilder.build();
    }

    private Map<String, Object> createMaterialMap(Set<String> materialIds, List<Long> allPlanTags) {
        Serializable tag;
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])planFields, (DataType[])planFieldsType);
        Algo algo = Algo.create((String)this.algoKey);
        DataSetBuilder dataSetBuilder = algo.createDataSetBuilder(rowMeta);
        HashMap groupToStrategy = new HashMap(8);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.algoKey, (String)"mpdm_manustrategy_group", (String)"id,createorg,entryentity.strategynumber,entryentity.strategynumber.demandmodel", null, (String)"id,entryentity.priority");){
            dataSet.forEach(row -> groupToStrategy.put(row.getLong("id"), row.getString("entryentity.strategynumber.demandmodel")));
        }
        DynamicObject strategyObj = QueryServiceHelper.queryOne((String)"mpdm_manustrategy", (String)"id,demandmodel", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"MTS10")});
        if (strategyObj == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7f16\u7801\u4e3aMTS10\u7684\u8ba1\u5212\u6a21\u5f0f\u3002", (String)"MRPSaveStockForecast_2", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]));
        }
        String defaultDemandModel = strategyObj.getString("demandmodel");
        LinkedHashSet mids = new LinkedHashSet(materialIds.size());
        for (String mid : materialIds) {
            String cacheKey = MRPRuntimeConsts.getMetaDynamicInfoKey((String)this.ctx.getMRPContextId(), (String)mid);
            MRPRedisStore dstore = MRPCacheManager.getDStore((String)this.ctx.getMRPContextId());
            HashMap info = (HashMap)dstore.mapGet("mpList", cacheKey);
            if (info == null) {
                log.warn(String.format("mrprunner-StockForecast-get-null-material-planinfo, ctxid: %s, cacheKey: %s, mid: %s", this.ctx.getMRPContextId(), cacheKey, mid));
                continue;
            }
            tag = MRPUtil.getLong((Map)info, (String)"plantags");
            if (!allPlanTags.contains(tag)) continue;
            long manufacturegroup = MRPUtil.getLong((Map)info, (String)"manufacturegroup");
            String demandModel = (String)groupToStrategy.get(manufacturegroup);
            if (StringUtils.isEmpty((CharSequence)demandModel)) {
                demandModel = defaultDemandModel;
            }
            Object[] value = new Object[]{Long.valueOf(mid), MRPUtil.getLong((Map)info, (String)"createorg"), MRPUtil.getLong((Map)info, (String)"operator"), demandModel};
            dataSetBuilder.append(value);
        }
        DataSet materialPlanDataSet = dataSetBuilder.build();
        String[] materialFields = new String[]{"id", "isserviceuse"};
        DataType[] materialTypes = new DataType[]{DataType.LongType, DataType.StringType};
        rowMeta = RowMetaFactory.createRowMeta((String[])materialFields, (DataType[])materialTypes);
        dataSetBuilder = algo.createDataSetBuilder(rowMeta);
        QFilter qFilter = new QFilter("id", "in", mids);
        DataSet dataSet = SnapshotDataUtils.queryDataSet((String)this.algoKey, (Long)this.versionId, (String)"bd_material", (String)"id,materialtype", (QFilter[])new QFilter[]{qFilter});
        tag = null;
        try {
            while (dataSet.hasNext()) {
                Row row2 = dataSet.next();
                Object[] value = new Object[2];
                long id = row2.getLong("id");
                String materialtype = row2.getString("materialtype");
                String isserviceuse = "N";
                if ("9".equals(materialtype)) {
                    isserviceuse = "Y";
                }
                value[0] = id;
                value[1] = isserviceuse;
                dataSetBuilder.append(value);
            }
        }
        catch (Throwable throwable) {
            tag = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (tag != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)tag).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        DataSet materialBaseDataSet = dataSetBuilder.build();
        HashMap<String, Object> datas = new HashMap<String, Object>();
        datas.put("plan", materialPlanDataSet);
        datas.put("base", materialBaseDataSet);
        return datas;
    }

    private Set<Long> stringToLong(Set<String> strings) {
        HashSet<Long> sets = new HashSet<Long>(strings.size());
        for (String str : strings) {
            sets.add(Long.valueOf(str));
        }
        return sets;
    }
}

