/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.controlnode.framework.step.adjust;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.param.AppParam;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.mmc.mrp.controlnode.framework.step.adjust.MRPEdcPurchaseOrderVo;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.IMRPExecuteLogRecorder;
import kd.mmc.mrp.framework.cache.MRPCacheManager;
import kd.mmc.mrp.framework.consts.Tips;
import kd.mmc.mrp.framework.step.AbstractMRPStep;
import kd.mmc.mrp.integrate.entity.PlanModel;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mmc.mrp.model.enums.strategy.BillSplitStrategy;
import kd.mmc.mrp.utils.MRPUtil;

public class MRPEdcAdjustCalStep
extends AbstractMRPStep {
    private static final String SUPPLYBILLF7 = "supplybillf7";
    private static final String SUPPLYBILLID = "supplybillid";
    private static final String MATERIALATTR = "materialattr";
    private static final String PM_PURORDERBILL = "pm_purorderbill";
    private int seq = 1;
    private long saveTimes = 0L;
    private static final int batchSize = 5000;

    public MRPEdcAdjustCalStep(IMRPEnvProvider ctx) {
        super(ctx);
    }

    protected void innerExecute() {
        IMRPExecuteLogRecorder log = this.ctx.createLogRecorder();
        Map<String, Set<String>> resultMap = this.getResultType(this.ctx);
        Set<String> materialIds = this.getMaterialIds();
        long baseStartTime = System.currentTimeMillis();
        Map<Long, Long> unitMap = this.genMaterialBaseUnit(materialIds);
        Long baseTime = System.currentTimeMillis() - baseStartTime;
        HashMap<Long, Set<Long>> purchase2EdcIds = new HashMap<Long, Set<Long>>(16);
        HashSet<DynamicObject> edcSet = new HashSet<DynamicObject>(16);
        int evtCount = 0;
        int materialCount = materialIds.size();
        long eventStartTime = System.currentTimeMillis();
        for (String materialId : materialIds) {
            Iterator materialDetails = MRPCacheManager.getInst().getMaterialDetails2((CalEnv)this.ctx, String.valueOf(materialId));
            this.genEdcAdjustData(materialDetails, unitMap, purchase2EdcIds, resultMap, edcSet);
            log.updateStepLog("entrydetailmsg", (Object)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u76f8\u5173\u7269\u6599\u8ba1\u91cf\u5355\u4f4d\u4fe1\u606f\u8017\u65f6:%1$s(ms)\uff0c\u5df2\u6267\u884c\u5b8c\u8ba1\u7b97\u4e8b\u4ef6\uff1a%2$s\uff0c\u5269\u4f59\u8ba1\u7b97\u4e8b\u4ef6\uff1a%3$s\u3002", (String)"MRPEdcAdjustCalStep_0", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), baseTime, ++evtCount, materialCount - evtCount));
        }
        if (!edcSet.isEmpty()) {
            this.batchSaveDatas(edcSet);
        }
        Long eventTime = System.currentTimeMillis() - eventStartTime - this.saveTimes;
        long purStartTime = System.currentTimeMillis();
        if (!purchase2EdcIds.isEmpty()) {
            int batch = (Integer)this.ctx.getCfgValue(EnvCfgItem.MRP_MATERIAL_PLANINFO_BATCH);
            int count = 0;
            Iterator iter = purchase2EdcIds.keySet().iterator();
            HashSet<Long> porderIds = new HashSet<Long>(1);
            ArrayList<Object[]> params = new ArrayList<Object[]>(purchase2EdcIds.size());
            DBRoute dbRoute = new DBRoute("scm");
            String updateSql = "update t_mrp_adjustsuggest set fsupplier = ?, fpurchaser = ? where fid = ?";
            do {
                count = 0;
                porderIds.clear();
                while (iter.hasNext()) {
                    Long id = (Long)iter.next();
                    porderIds.add(id);
                    if (++count != batch) continue;
                    break;
                }
                QFilter idFilter = new QFilter("id", "in", porderIds);
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)PM_PURORDERBILL, (String)PM_PURORDERBILL, (String)"id, supplier, operator", (QFilter[])new QFilter[]{idFilter}, null);){
                    for (Row row : dataSet) {
                        Set edcIds;
                        long supplier = 0L;
                        if (row.get("supplier") != null) {
                            supplier = row.getLong("supplier");
                        }
                        long purchaser = 0L;
                        if (row.get("operator") != null) {
                            purchaser = row.getLong("operator");
                        }
                        if (supplier <= 0L && purchaser <= 0L || (edcIds = (Set)purchase2EdcIds.get(row.getLong("id"))) == null) continue;
                        for (Long id : edcIds) {
                            Object[] param = new Object[]{supplier, purchaser, id};
                            params.add(param);
                            if (params.size() != 5000) continue;
                            this.executeBatch(params, dbRoute, updateSql);
                        }
                    }
                }
            } while (count >= batch);
            this.executeBatch(params, dbRoute, updateSql);
        }
        Long purTime = System.currentTimeMillis() - purStartTime;
        log.updateStepLog("entrydetailmsg", (Object)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u76f8\u5173\u7269\u6599\u8ba1\u91cf\u5355\u4f4d\u4fe1\u606f\u8017\u65f6:%1$s(ms)\uff0c\u67e5\u8be2\u76f8\u5173\u91c7\u8d2d\u8ba2\u5355\u4fe1\u606f\u8017\u65f6:%2$s(ms)\uff0c\u5df2\u6267\u884c\u5b8c\u8ba1\u7b97\u4e8b\u4ef6\uff1a%3$s\uff0c\u8ba1\u7b97\u4e8b\u4ef6\u8017\u65f6:%4$s(ms)\uff0c\u4fdd\u5b58\u6570\u636e\u8017\u65f6:%5$s(ms)\u3002", (String)"MRPEdcAdjustCalStep_2", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), baseTime, purTime, evtCount, eventTime, this.saveTimes));
    }

    private void executeBatch(List<Object[]> params, DBRoute dbRoute, String updateSql) {
        if (!params.isEmpty()) {
            DB.executeBatch((DBRoute)dbRoute, (String)updateSql, params);
            params.clear();
        }
    }

    private Set<String> getMaterialIds() {
        HashSet<String> materialIds = new HashSet<String>(16);
        for (Set ids : this.ctx.bomDatas().getLLC()) {
            materialIds.addAll(ids);
        }
        materialIds.addAll(this.ctx.bomDatas().getRequireMaterials());
        materialIds.remove("null");
        return materialIds;
    }

    private Map<Long, MRPEdcPurchaseOrderVo> getPurOrders(Set<String> materialIds) {
        HashMap<Long, MRPEdcPurchaseOrderVo> purchaseOrderVoMap = new HashMap<Long, MRPEdcPurchaseOrderVo>(materialIds.size());
        HashSet<Long> porderIds = new HashSet<Long>();
        for (String materialId : materialIds) {
            Iterator materialDetails = MRPCacheManager.getInst().getMaterialDetails2((CalEnv)this.ctx, String.valueOf(materialId));
            while (materialDetails.hasNext()) {
                Map materialDetail = (Map)materialDetails.next();
                if (!PM_PURORDERBILL.equals(materialDetail.get(SUPPLYBILLF7)) || materialDetail.get(SUPPLYBILLID) == null) continue;
                porderIds.add((Long)materialDetail.get(SUPPLYBILLID));
            }
        }
        QFilter idFilter = new QFilter("id", "in", porderIds);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)PM_PURORDERBILL, (String)PM_PURORDERBILL, (String)"id, supplier, operator", (QFilter[])new QFilter[]{idFilter}, null);){
            for (Row row : dataSet) {
                MRPEdcPurchaseOrderVo purchaseOrderVo = new MRPEdcPurchaseOrderVo();
                long supplier = 0L;
                if (row.get("supplier") != null) {
                    supplier = row.getLong("supplier");
                }
                purchaseOrderVo.setSupplier(supplier);
                long purchaser = 0L;
                if (row.get("operator") != null) {
                    purchaser = row.getLong("operator");
                }
                purchaseOrderVo.setPurchaser(purchaser);
                purchaseOrderVoMap.put(row.getLong("id"), purchaseOrderVo);
            }
        }
        return purchaseOrderVoMap;
    }

    private void batchSaveDatas(Set<DynamicObject> edcSet) {
        long saveStartTime = System.currentTimeMillis();
        if (!edcSet.isEmpty()) {
            DynamicObject[] edcs = edcSet.toArray(new DynamicObject[0]);
            this.dataAmount += edcs.length;
            SaveServiceHelper.save((DynamicObject[])edcs);
        }
        this.saveTimes += System.currentTimeMillis() - saveStartTime;
        edcSet.clear();
    }

    public Map<Long, Long> genMaterialBaseUnit(Set<String> materialIds) {
        HashSet<Long> mIds = new HashSet<Long>(materialIds.size());
        HashMap<Long, Long> map = new HashMap<Long, Long>(materialIds.size());
        for (String materialId : materialIds) {
            mIds.add(Long.valueOf(materialId));
        }
        QFilter idFilter = new QFilter("id", "in", mIds);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.mmc.mrp.controlnode.framework.step.adjust.MRPEdcAdjustCalStep", (String)"bd_material", (String)"id, baseunit", (QFilter[])new QFilter[]{idFilter}, null);){
            for (Row row : dataSet) {
                map.put(row.getLong("id"), row.getLong("baseunit"));
            }
        }
        return map;
    }

    private String toAdjustSuggest(String adjustSuggest) {
        String adjust = "";
        if (ResManager.loadKDString((String)"\u5efa\u8bae\u63d0\u524d", (String)"MRPEdcAdjustCalStep_3", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]).equals(adjustSuggest)) {
            adjust = "2";
        } else if (ResManager.loadKDString((String)"\u5efa\u8bae\u53d6\u6d88", (String)"MRPEdcAdjustCalStep_5", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]).equals(adjustSuggest)) {
            adjust = "0";
        } else if (ResManager.loadKDString((String)"\u5efa\u8bae\u5ef6\u540e", (String)"MRPEdcAdjustCalStep_4", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]).equals(adjustSuggest)) {
            adjust = "1";
        }
        return adjust;
    }

    private Long genLongId() {
        return ID.genLongId();
    }

    private void genEdcAdjustData(Iterator<Map<String, Object>> materialDetails, Map<Long, Long> unitMap, Map<Long, Set<Long>> purchase2EdcIds, Map<String, Set<String>> resultMap, Set<DynamicObject> edcSet) {
        HashMap map = this.ctx.strategys();
        Date currentTime = new Date();
        long creatorId = RequestContext.get().getCurrUserId();
        Set<String> planTags = resultMap.get("plantags");
        if (materialDetails != null) {
            while (materialDetails.hasNext()) {
                Map<String, Object> materialDetail = materialDetails.next();
                String adjustSuggest = "";
                if (materialDetail.get("adjustsuggest") != null) {
                    adjustSuggest = (String)MRPUtil.convert((Object)materialDetail.get("adjustsuggest"), (Object)"");
                }
                if (!ResManager.loadKDString((String)"\u5efa\u8bae\u63d0\u524d", (String)"MRPEdcAdjustCalStep_3", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]).equals(adjustSuggest) && !ResManager.loadKDString((String)"\u5efa\u8bae\u5ef6\u540e", (String)"MRPEdcAdjustCalStep_4", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]).equals(adjustSuggest) && !ResManager.loadKDString((String)"\u5efa\u8bae\u53d6\u6d88", (String)"MRPEdcAdjustCalStep_5", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]).equals(adjustSuggest) || materialDetail.get("copsupply") != null && "1".equals(String.valueOf(materialDetail.get("copsupply")))) continue;
                String supplantag = "0";
                if (materialDetail.get("cache_supplantag") != null) {
                    supplantag = (String)MRPUtil.convert((Object)materialDetail.get("cache_supplantag"), (Object)"0");
                }
                if (!planTags.isEmpty() && !planTags.contains(supplantag) || planTags.isEmpty() && !"0".equals(supplantag)) continue;
                String realAdjust = this.toAdjustSuggest(adjustSuggest);
                String billType = "";
                if (materialDetail.get(SUPPLYBILLF7) != null) {
                    billType = (String)MRPUtil.convert((Object)materialDetail.get(SUPPLYBILLF7), (Object)"");
                }
                if (resultMap.get(billType) == null || !resultMap.get(billType).contains(realAdjust)) continue;
                DynamicObject edc = this.genNewDynamicObject();
                Long id = edc.getLong("id");
                edc.set("adjustsuggest", (Object)realAdjust);
                DynamicObject runLog = this.ctx.getRunLog();
                Long caculateLogNum = runLog.getLong("id");
                edc.set("plannum", (Object)caculateLogNum);
                StringBuilder lineSeq = new StringBuilder();
                if (runLog.getString("number") != null) {
                    lineSeq.append(runLog.getString("number")).append('-').append(this.seq++);
                }
                edc.set("entryseq", (Object)lineSeq.toString());
                long supplyOrg = 0L;
                if (materialDetail.get("supplyorg") != null) {
                    supplyOrg = Long.parseLong(materialDetail.get("supplyorg").toString());
                }
                edc.set("supplyorg", (Object)supplyOrg);
                long materialId = 0L;
                if (materialDetail.get("material") != null) {
                    materialId = Long.parseLong(materialDetail.get("material").toString());
                }
                edc.set("materiel", (Object)materialId);
                String materialAttr = "";
                if (materialDetail.get(MATERIALATTR) != null) {
                    materialAttr = (String)MRPUtil.convert((Object)materialDetail.get(MATERIALATTR), (Object)"");
                }
                edc.set(MATERIALATTR, (Object)materialAttr);
                Long auxprop = 0L;
                if (materialDetail.get("supplyauxpty") != null) {
                    auxprop = (Long)MRPUtil.convert((Object)materialDetail.get("supplyauxpty"), (Object)0L);
                }
                edc.set("auxprop", (Object)auxprop);
                if (PM_PURORDERBILL.equals(billType) && materialDetail.get(SUPPLYBILLID) != null) {
                    Long supplybillid = (Long)MRPUtil.convert((Object)materialDetail.get(SUPPLYBILLID), (Object)0L);
                    Set edcIds = purchase2EdcIds.computeIfAbsent(supplybillid, k -> new HashSet(16));
                    edcIds.add(id);
                }
                edc.set("billtype", (Object)billType);
                String billNo = "";
                if (materialDetail.get("supplybillno") != null) {
                    billNo = (String)MRPUtil.convert((Object)materialDetail.get("supplybillno"), (Object)"");
                }
                edc.set("billno", (Object)billNo);
                int entrySeq = 0;
                if (materialDetail.get("supplybillentryseq") != null) {
                    entrySeq = (Integer)MRPUtil.convert((Object)materialDetail.get("supplybillentryseq"), (Object)0);
                }
                edc.set("lineno", (Object)entrySeq);
                String billId = "";
                if (materialDetail.get(SUPPLYBILLID) != null) {
                    billId = materialDetail.get(SUPPLYBILLID).toString();
                }
                edc.set("billid", (Object)billId);
                String lineId = "";
                if (materialDetail.get("supplybillentryid") != null) {
                    lineId = materialDetail.get("supplybillentryid").toString();
                }
                edc.set("lineid", (Object)lineId);
                BigDecimal qty = BigDecimal.ZERO;
                if (materialDetail.get("adjustqty") != null) {
                    qty = MRPUtil.toBigDecimal((Object)materialDetail.get("adjustqty"));
                }
                if (ResManager.loadKDString((String)"\u5efa\u8bae\u53d6\u6d88", (String)"MRPEdcAdjustCalStep_5", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]).equals(adjustSuggest) && qty.compareTo(BigDecimal.ZERO) == 0 && materialDetail.get("supplyqty") != null) {
                    qty = MRPUtil.toBigDecimal((Object)materialDetail.get("supplyqty"));
                }
                edc.set("qty", (Object)qty);
                Long baseUnit = 0L;
                if (unitMap.get(materialId) != null) {
                    baseUnit = unitMap.get(materialId);
                }
                edc.set("baseunit", (Object)baseUnit);
                long schduler = 0L;
                if (materialDetail.get("supplyoperator") != null) {
                    schduler = (Long)MRPUtil.convert((Object)materialDetail.get("supplyoperator"), (Object)0L);
                }
                edc.set("schduler", (Object)schduler);
                Date supplydate = null;
                if (materialDetail.get("supplydate") != null) {
                    supplydate = new Date((Long)MRPUtil.convert((Object)materialDetail.get("supplydate"), (Object)0L));
                }
                edc.set("origindate", supplydate);
                Date suggestDate = null;
                if (!ResManager.loadKDString((String)"\u5efa\u8bae\u53d6\u6d88", (String)"MRPEdcAdjustCalStep_5", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]).equals(adjustSuggest) && materialDetail.get("adjustdate") != null) {
                    suggestDate = new Date((Long)MRPUtil.convert((Object)materialDetail.get("adjustdate"), (Object)0L));
                }
                AppParam appParam = new AppParam("0MBBBZ1L5IAW", Long.valueOf(this.ctx.getPlanOrgId()));
                Map mrpParam = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
                String adjustResource = ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6.\u4ea4\u8d27\u65e5\u671f", (String)"MRPEdcAdjustCalStep_6", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]);
                if (mrpParam.get("fieldname") != null) {
                    adjustResource = (String)MRPUtil.convert(mrpParam.get("fieldname"), (Object)"");
                }
                if (PM_PURORDERBILL.equals(billType)) {
                    edc.set("adjustdatetype", (Object)adjustResource);
                }
                if (map.get(billType) != null) {
                    BillSplitStrategy strategy = (BillSplitStrategy)map.get(billType);
                    edc.set("adjuststrategy", (Object)strategy.getValue());
                }
                edc.set("suggestdate", (Object)suggestDate);
                edc.set("adjustdate", (Object)suggestDate);
                edc.set("releasestatus", (Object)Boolean.FALSE);
                edc.set("creator", (Object)creatorId);
                edc.set("createtime", (Object)currentTime);
                Long trackNumberId = 0L;
                if (materialDetail.get("suptracknumber") != null) {
                    trackNumberId = (Long)MRPUtil.convert((Object)materialDetail.get("suptracknumber"), (Object)0L);
                }
                edc.set("tracknumber", (Object)trackNumberId);
                Long configuredcode = 0L;
                if (materialDetail.get("configuredcode") != null) {
                    configuredcode = (Long)MRPUtil.convert((Object)materialDetail.get("configuredcode"), (Object)0L);
                }
                edc.set("configuredcode", (Object)configuredcode);
                Long projectId = 0L;
                if (materialDetail.get("supplyproject") != null) {
                    projectId = (Long)MRPUtil.convert((Object)materialDetail.get("supplyproject"), (Object)0L);
                }
                edc.set("project", (Object)projectId);
                edcSet.add(edc);
                if (edcSet.size() != 5000) continue;
                this.batchSaveDatas(edcSet);
            }
        }
    }

    public DynamicObject genNewDynamicObject() {
        DynamicObject edc = BusinessDataServiceHelper.newDynamicObject((String)"mrp_adjustsuggest");
        long id = this.genLongId();
        edc.set("id", (Object)id);
        edc.set("masterid", (Object)id);
        return edc;
    }

    public String getStepDesc(Locale locale) {
        return Tips.getEdcAdjustsuggest();
    }

    public Map<String, Set<String>> getResultType(IMRPEnvProvider ctx) {
        PlanModel plan = (PlanModel)ctx.getService(PlanModel.class);
        DynamicObject planProgram = plan.getPlan();
        DynamicObjectCollection planColl = planProgram.getDynamicObjectCollection("rearentryentity");
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(planColl.size());
        for (DynamicObject entry : planColl) {
            String[] adjusts;
            String entity = "";
            if (entry.getDynamicObject("entryentitytype") != null) {
                entity = entry.getDynamicObject("entryentitytype").getString("number");
            }
            String resultType = "";
            if (entry.getString("resulttype") != null) {
                resultType = entry.getString("resulttype");
            }
            if (StringUtils.isEmpty((CharSequence)entity)) continue;
            HashSet<String> set = new HashSet<String>(4);
            for (String adjust : adjusts = resultType.split(",")) {
                if (StringUtils.isBlank((CharSequence)adjust)) continue;
                set.add(adjust);
            }
            map.put(entity, set);
        }
        DynamicObjectCollection operatorColl = planProgram.getDynamicObjectCollection("plantags");
        HashSet<String> planTags = new HashSet<String>(operatorColl.size());
        for (DynamicObject operator : operatorColl) {
            DynamicObject plantag = operator.getDynamicObject("fbasedataid");
            planTags.add(plantag.getString("id"));
        }
        map.put("plantags", planTags);
        return map;
    }

    public String getAssociateForm() {
        return "mrp_adjust_view";
    }
}

