/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.controlnode.framework.step.allocat;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mrp.controlnode.framework.step.allocat.AllocUtil;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.cache.MRPCacheManager;
import kd.mmc.mrp.integrate.entity.IssuePlanModel;
import kd.mmc.mrp.integrate.entity.PlanModel;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.struct.InvSupplyStruct;
import kd.mmc.mrp.model.struct.InvWareHouseStruct;
import kd.mmc.mrp.model.struct.SupplyStruct;
import kd.mmc.mrp.model.table.DataBalanceTable;
import kd.mmc.mrp.model.table.GridData;
import kd.mmc.mrp.model.table.RequireRowData;
import kd.mmc.mrp.model.table.RowData;
import kd.mmc.mrp.model.table.res.SupplymentDataTable;

public class AllocIssueSave {
    private static final String KEY_ENTITY_ALLOC = "pom_allocationplan";
    private IMRPEnvProvider ctx;
    private BigDecimal minPackQty;
    private boolean isMinPack;
    private List<ReqSupData> list;
    private Map<Store, Qty> ycQty = new LinkedHashMap<Store, Qty>(16);
    private DynamicObject mtVentoryInfo;
    private DynamicObject mt;
    private boolean isAlloc;
    private Set<Long> allocOrgs;
    private Map<Long, DefaultOrg> defaultOrgMap;
    private Date now = new Date();

    public AllocIssueSave(IMRPEnvProvider ctx) {
        this(ctx, true);
    }

    public AllocIssueSave(IMRPEnvProvider ctx, boolean isMinPack) {
        this.list = new ArrayList<ReqSupData>(16);
        this.allocOrgs = new LinkedHashSet<Long>(4);
        this.ctx = ctx;
        IssuePlanModel planModel = (IssuePlanModel)ctx.getService(PlanModel.class);
        this.isAlloc = planModel.isAlloc();
        long material = this.getCurrentMaterial(ctx);
        this.mtVentoryInfo = BusinessDataServiceHelper.loadSingle((String)"bd_materialinventoryinfo", (String)"id,baseunit,inventoryunit,minpackqty", (QFilter[])new QFilter[]{new QFilter("masterid", "=", (Object)material)});
        this.mt = BusinessDataServiceHelper.loadSingle((String)"bd_material", (String)"id,baseunit,auxptyunit", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)material)});
        this.initDefaultOrgMap(ctx);
        if (this.mtVentoryInfo != null) {
            this.minPackQty = this.mtVentoryInfo.getBigDecimal("minpackqty");
            boolean bl = this.isMinPack = isMinPack && this.minPackQty != null && this.minPackQty.compareTo(BigDecimal.ZERO) > 0 && planModel.isMinPack();
            if (this.isMinPack) {
                SupplymentDataTable supTable = ctx.supplyDatas();
                if (supTable == null) {
                    return;
                }
                Map colIdx = supTable.getColIdx();
                GridData srcDatas = supTable.getSrcDatas();
                GridData.Grid datas = srcDatas.getDatas();
                for (Object[] data : datas) {
                    if (((Boolean)data[(Integer)colIdx.get(DefaultField.SupplyField.__IS_OCCUPIED__.getName())]).booleanValue()) continue;
                    double priority = this.getPriority(data[(Integer)colIdx.get(DefaultField.SupplyField.__SUPPLY_PRIORITY__.getName())], data[(Integer)colIdx.get(DefaultField.SupplyField.__PRIORITY_LEVEL__.getName())]);
                    BigDecimal supQty = new BigDecimal(data[(Integer)colIdx.get(DefaultField.SupplyField.QTY.getName())].toString());
                    if (!(priority < 99.0) || supQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                    Object outstockorg = data[(Integer)colIdx.get(DefaultField.SupplyField.SUPPLYORGUNIT.getName())];
                    Object outstock = data[(Integer)colIdx.get(DefaultField.SupplyField.WAREHOUSE.getName())];
                    Object outposition = data[(Integer)colIdx.get(DefaultField.SupplyField.STOCKLOT.getName())];
                    Store store = new Store(outstockorg, outstock, outposition);
                    this.ycQty.computeIfAbsent(store, k -> new Qty()).add(supQty);
                }
            }
        }
    }

    private long getCurrentMaterial(IMRPEnvProvider ctx) {
        String currentResolveMaterial = ctx.getCurrentResolveMaterial();
        return Long.parseLong(currentResolveMaterial);
    }

    private void initDefaultOrgMap(IMRPEnvProvider ctx) {
        this.defaultOrgMap = new HashMap<Long, DefaultOrg>();
        HashSet requirorgs = ctx.getRequirorgs();
        Set reqs = requirorgs.stream().map(Long::valueOf).collect(Collectors.toSet());
        String sel = "createorg,callinorg,callinwarehouse,callinlocation,allocplan,issueplan";
        QFilter[] filters = new QFilter[]{new QFilter("createorg", "in", reqs), new QFilter("enable", "=", (Object)Boolean.TRUE), new QFilter("status", "in", (Object)"C")};
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".initDefaultOrgMap"), (String)"fmm_defaultorg", (String)sel, (QFilter[])filters, null);){
            for (Row d : ds) {
                Long createorg = d.getLong("createorg");
                this.defaultOrgMap.put(createorg, new DefaultOrg(d.getLong(0), d.getLong(1), d.getLong(2), d.getLong(3)));
                if (!d.getBoolean("allocplan").booleanValue()) continue;
                this.allocOrgs.add(createorg);
            }
        }
    }

    private double getPriority(Object sp, Object pl) {
        Object result = sp == null ? pl : sp;
        return Double.parseDouble(result.toString());
    }

    public void add(RequireRowData reqRow, RowData supRow) {
        ReqSupData data = new ReqSupData(reqRow, supRow);
        this.list.add(data);
        Store store = new Store(data.supOrg, data.supHouse, data.supLocation);
        this.ycQty.computeIfAbsent(store, k -> new Qty()).add(data.supQty);
    }

    protected void calculateMiniPack() {
        if (!this.isMinPack) {
            return;
        }
        Map<Long, List<Store>> requireToStores = this.getReqToStores();
        Iterator<ReqSupData> iterator = this.list.iterator();
        block0: while (iterator.hasNext()) {
            Qty qty;
            BigDecimal newQty;
            ReqSupData plan = iterator.next();
            BigDecimal reqQty = plan.supQty;
            long reqOrg = plan.reqOrg;
            Store store = new Store(plan.supOrg, plan.supHouse, plan.supLocation);
            List<Store> reqStores = requireToStores.get(reqOrg);
            boolean contains = reqStores.contains(store);
            if (contains && (newQty = this.getMinPackage(reqQty, this.minPackQty, qty = this.ycQty.get(store))).compareTo(BigDecimal.ZERO) > 0) {
                plan.supQty = newQty;
                continue;
            }
            for (Store otherStore : reqStores) {
                BigDecimal newQty2;
                Qty qty2 = this.ycQty.get(otherStore);
                if (qty2 == null || (newQty2 = this.getMinPackage(reqQty, this.minPackQty, qty2)).compareTo(BigDecimal.ZERO) <= 0) continue;
                plan.supQty = newQty2;
                plan.supOrg = otherStore.supplyOrg;
                plan.supHouse = otherStore.stock;
                plan.supLocation = otherStore.position;
                continue block0;
            }
            iterator.remove();
        }
    }

    private BigDecimal getMinPackage(BigDecimal reqQty, BigDecimal minpackqty, Qty qty) {
        if (!qty.largeOrEql(minpackqty)) {
            return BigDecimal.ZERO;
        }
        BigDecimal upQty = reqQty.divide(minpackqty, 0, 2).multiply(minpackqty);
        if (qty.largeOrEql(upQty)) {
            qty.subtract(upQty);
            return upQty;
        }
        BigDecimal downQty = qty.qty.divide(minpackqty, 0, 3).multiply(minpackqty);
        qty.subtract(downQty);
        return downQty;
    }

    private Map<Long, List<Store>> getReqToStores() {
        HashMap<Long, List<Store>> requireToStores = new HashMap<Long, List<Store>>();
        HashMap priorityRelations = this.ctx.getPriorityRelations();
        for (Map.Entry entry : priorityRelations.entrySet()) {
            String reqOrg = (String)entry.getKey();
            SupplyStruct value = (SupplyStruct)entry.getValue();
            for (Map.Entry structEntry : value.getInvSupplys().entrySet()) {
                String supOrg = (String)structEntry.getKey();
                List invWareHouses = ((InvSupplyStruct)structEntry.getValue()).getInvWareHouses();
                for (InvWareHouseStruct invWareHouse : invWareHouses) {
                    String warehouseId = invWareHouse.getWarehouseId();
                    String locationId = invWareHouse.getLocationId();
                    BigDecimal priority = invWareHouse.getPriority();
                    if (!(priority.doubleValue() < 99.0)) continue;
                    requireToStores.computeIfAbsent(Long.valueOf(reqOrg), k -> new ArrayList()).add(new Store(supOrg, warehouseId, locationId, priority));
                }
            }
        }
        for (List value : requireToStores.values()) {
            value.sort((a, b) -> ((Store)b).priority.compareTo(((Store)a).priority));
        }
        return requireToStores;
    }

    public int save() {
        this.now = new Date();
        this.calculateMiniPack();
        return this.saveAllocDyns();
    }

    protected List<DynamicObject> getAllocDyns() {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(16);
        Collection<ReqSupData> allocs = this.getAllocList();
        if (allocs.isEmpty()) {
            return result;
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)KEY_ENTITY_ALLOC);
        for (ReqSupData alloc : allocs) {
            DynamicObject allocDyn = this.createAllocDyn(alloc, (DynamicObjectType)type);
            result.add(allocDyn);
        }
        Map<String, List<DynamicObject>> orgPlansMap = result.stream().collect(Collectors.groupingBy(dyn -> dyn.getString("org")));
        for (Map.Entry<String, List<DynamicObject>> entry : orgPlansMap.entrySet()) {
            List<DynamicObject> values = entry.getValue();
            if (values.size() == 0) continue;
            String[] numbers = CodeRuleServiceHelper.getBatchNumber((String)KEY_ENTITY_ALLOC, (DynamicObject)values.get(0), (String)entry.getKey(), (int)entry.getValue().size());
            if (numbers.length > 0) {
                for (int i = 0; i < values.size() && i < numbers.length; ++i) {
                    values.get(i).set("billno", (Object)numbers[i]);
                }
                continue;
            }
            for (DynamicObject value : values) {
                String uuid = UUID.randomUUID().toString();
                String substring = uuid.substring(0, 8);
                value.set("billno", (Object)("ALLOC_" + substring));
            }
        }
        return result;
    }

    private Collection<ReqSupData> getAllocList() {
        return this.list.stream().filter(x -> this.allocOrgs.contains(x.reqOrg)).collect(LinkedHashSet::new, Set::add, Set::addAll);
    }

    protected int saveAllocDyns() {
        if (!this.isAlloc) {
            return 0;
        }
        List<DynamicObject> allocDyns = this.getAllocDyns();
        Object[] aps = SaveServiceHelper.save((DynamicObject[])allocDyns.toArray(new DynamicObject[0]));
        return aps.length;
    }

    private DynamicObject createAllocDyn(ReqSupData data, DynamicObjectType type) {
        RequireRowData reqRow = data.reqRow;
        RowData supRow = data.supRow;
        DynamicObject ap = (DynamicObject)type.createInstance();
        Object reqOrg = reqRow.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName());
        Object reqDate = reqRow.getValue(DefaultField.RequireField.DATE.getName());
        BigDecimal planQty = data.supQty;
        BigDecimal oriReqQty = reqRow.getBigDecimal(DefaultField.RequireField.__SUPPLY_QTY__.getName());
        Object configCode = reqRow.getValue(DefaultField.RequireField.CONFIGUREDCODE.getName());
        Object trackNumber = reqRow.getValue(DefaultField.RequireField.TRACKNUMBER.getName());
        ap.set("configuredcode", configCode);
        ap.set("tracknumber", trackNumber);
        ap.set("status", (Object)"A");
        ap.set("billstatus", (Object)"C");
        ap.set("source", (Object)"B");
        ap.set("billdate", (Object)this.now);
        ap.set("org", reqOrg);
        ap.set("requestdate", reqDate);
        long mtId = this.mt.getLong("id");
        long unitId = this.mtVentoryInfo.getLong("inventoryunit_id");
        long unitBaseId = this.mt.getLong("baseunit_id");
        long unitAuxId = this.mt.getLong("auxptyunit_id");
        ap.set("materiel", (Object)this.mtVentoryInfo.getLong("id"));
        ap.set("stockunitid", (Object)unitId);
        ap.set("materialunitid", (Object)unitBaseId);
        ap.set("auxunitid", (Object)unitAuxId);
        ap.set("requestbaseqty", (Object)oriReqQty);
        ap.set("requestqty", (Object)AllocUtil.getUnitRateConvert(mtId, unitBaseId, unitId).multiply(oriReqQty));
        ap.set("requestauxqty", (Object)AllocUtil.getUnitRateConvert(mtId, unitBaseId, unitAuxId).multiply(oriReqQty));
        ap.set("mplanbaseqty", (Object)planQty);
        ap.set("mplanqty", (Object)AllocUtil.getUnitRateConvert(mtId, unitBaseId, unitId).multiply(planQty));
        ap.set("mplanauxqty", (Object)AllocUtil.getUnitRateConvert(mtId, unitBaseId, unitAuxId).multiply(planQty));
        this.setAllocInstock(reqRow, supRow, ap);
        ap.set("outstockorg", (Object)data.supOrg);
        ap.set("outwarehouse", (Object)data.supHouse);
        ap.set("outlocation", (Object)data.supLocation);
        this.setOwner(reqRow, ap);
        Long userId = RequestContext.get().getCurrUserId();
        ap.set("creator", (Object)userId);
        ap.set("createtime", (Object)this.now);
        ap.set("modifier", (Object)userId);
        ap.set("modifytime", (Object)this.now);
        ap.set("auditor", (Object)userId);
        ap.set("auditdate", (Object)this.now);
        ap.set("org", reqOrg);
        ap.set("upperbillid_tag", (Object)this.setSrcBill(this.ctx, reqRow.getValue(DefaultField.RequireField.BILLID.getName()), reqRow.getValue(DefaultField.RequireField.BILLENTRYID.getName())));
        return ap;
    }

    private void setOwner(RequireRowData reqRow, DynamicObject ap) {
        String src = reqRow.getString("ENTRYENTITY.ALLOCSRC");
        if ("0".equals(src)) {
            Long orgId = reqRow.getLong(DefaultField.RequireField.PRODUCTIONORGUNIT.getName());
            if (orgId != 0L) {
                Long produceOrg = AllocUtil.getAccountOrgByProduceOrg(orgId);
                ap.set("supplymode", (Object)"bos_org");
                ap.set("supplierid", (Object)produceOrg);
            }
        } else if ("1".equals(src)) {
            Long billEntryId = reqRow.getLong(DefaultField.RequireField.BILLENTRYID.getName());
            QFilter filter = new QFilter("stockentry", "=", (Object)billEntryId);
            DynamicObject dyn = QueryServiceHelper.queryOne((String)"pom_mftstock", (String)"stockentry.supplymode,stockentry.supplierid", (QFilter[])new QFilter[]{filter});
            if (dyn != null) {
                Object mode = dyn.get("stockentry.supplymode");
                Object supply = dyn.get("stockentry.supplierid");
                ap.set("supplymode", mode);
                ap.set("supplierid", supply);
            }
        }
    }

    protected void setAllocInstock(RequireRowData reqRow, RowData supRow, DynamicObject dyn) {
        Long reqOrg = reqRow.getLong(DefaultField.RequireField.PRODUCTIONORGUNIT.getName());
        DefaultOrg defaultOrg = this.defaultOrgMap.get(reqOrg);
        if (defaultOrg != null && defaultOrg.callinorg != 0L) {
            dyn.set("instockorg", (Object)defaultOrg.callinorg);
            dyn.set("inwarehouse", (Object)defaultOrg.callinwarehouse);
            dyn.set("inlocation", (Object)defaultOrg.callinlocation);
        } else {
            dyn.set("instockorg", reqRow.getValue("ENTRYENTITY.INSTOCKORG"));
            dyn.set("inwarehouse", reqRow.getValue("ENTRYENTITY.INSTOCK"));
            dyn.set("inlocation", reqRow.getValue("ENTRYENTITY.INPOSITION"));
        }
    }

    private String setSrcBill(IMRPEnvProvider ctx, Object billid, Object billentryid) {
        String k;
        Map ms;
        List l;
        String mstr = MRPCacheManager.getInst().getData((CalEnv)ctx, "allocationMergeBills");
        if (mstr != null && (l = (List)(ms = (Map)JSON.parseObject((String)mstr, Map.class)).get(k = billid + "_" + billentryid)) != null) {
            StringBuilder str = new StringBuilder();
            for (String s : l) {
                if (str.length() > 0) {
                    str.append(',');
                }
                str.append(s.split("_")[0]);
            }
            return str.toString();
        }
        return billid.toString();
    }

    public void addMappings(List<DataBalanceTable.RSMapping> mappings) {
        for (DataBalanceTable.RSMapping mapping : mappings) {
            RequireRowData reqRow = mapping.getRequire();
            BigDecimal remainReqQty = reqRow.getBigDecimal(DefaultField.RequireField.QTY.getName());
            List supRows = mapping.getSupplys();
            if (reqRow.getValue(DefaultField.RequireField.__IS_MERGE_.getName()) == null && supRows != null && reqRow.getOccupys() != null) {
                for (RowData supRow : supRows) {
                    BigDecimal sQty = supRow.getBigDecimal(DefaultField.SupplyField.QTY.getName());
                    Double supPriority = supRow.getDouble(DefaultField.SupplyField.__SUPPLY_PRIORITY__.getName());
                    Double supLevel = supRow.getDouble(DefaultField.SupplyField.__PRIORITY_LEVEL__.getName());
                    double d = supPriority != null ? supPriority : (supLevel != null ? supLevel : 0.0);
                    double priority = d;
                    if (!(priority < 99.0) || sQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                    this.add(reqRow, supRow);
                    remainReqQty = remainReqQty.add(sQty);
                }
            }
            reqRow.update(DefaultField.RequireField.__SUPPLY_QTY__.getName(), (Object)remainReqQty);
        }
    }

    public static class DefaultOrg {
        public final long createorg;
        public final long callinorg;
        public final long callinwarehouse;
        public final long callinlocation;

        public DefaultOrg(long createorg, long callinorg, long callinwarehouse, long callinlocation) {
            this.createorg = createorg;
            this.callinorg = callinorg;
            this.callinwarehouse = callinwarehouse;
            this.callinlocation = callinlocation;
        }
    }

    public static class ReqSupData {
        RequireRowData reqRow;
        RowData supRow;
        Long reqOrg;
        BigDecimal supQty;
        Long supOrg;
        Long supHouse;
        Long supLocation;

        ReqSupData(RequireRowData reqRow, RowData supRow) {
            this.reqRow = reqRow;
            this.supRow = supRow;
            this.reqOrg = reqRow.getLong(DefaultField.RequireField.PRODUCTIONORGUNIT.getName());
            this.supQty = supRow.getBigDecimal(DefaultField.SupplyField.QTY.getName());
            this.supOrg = supRow.getLong(DefaultField.SupplyField.SUPPLYORGUNIT.getName());
            this.supHouse = supRow.getLong(DefaultField.SupplyField.WAREHOUSE.getName());
            this.supLocation = supRow.getLong(DefaultField.SupplyField.STOCKLOT.getName());
        }
    }

    private static class Qty {
        BigDecimal qty = BigDecimal.ZERO;

        Qty() {
        }

        void add(BigDecimal b) {
            this.qty = this.qty.add(b);
        }

        void subtract(BigDecimal b) {
            this.qty = this.qty.subtract(b);
        }

        boolean largeOrEql(BigDecimal q) {
            return this.qty.compareTo(q) >= 0;
        }
    }

    private static class Store {
        private Long supplyOrg;
        private Long stock;
        private Long position;
        private BigDecimal priority;

        public Store(Object supplyOrg, Object stock, Object position) {
            this.supplyOrg = (Long)DataType.convertValue((DataType)DataType.LongType, (Object)supplyOrg);
            this.stock = (Long)DataType.convertValue((DataType)DataType.LongType, (Object)stock);
            this.position = (Long)DataType.convertValue((DataType)DataType.LongType, (Object)position);
            this.stock = this.stock == 0L ? null : this.stock;
            this.position = this.position == 0L ? null : this.position;
        }

        public Store(String supOrg, String warehouseId, String locationId, BigDecimal priority) {
            this.supplyOrg = Long.valueOf(supOrg);
            this.stock = warehouseId == null || warehouseId.trim().equals("") ? null : Long.valueOf(warehouseId);
            this.position = locationId == null || locationId.trim().equals("") ? null : Long.valueOf(locationId);
            this.priority = priority;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Store store = (Store)o;
            return Objects.equals(this.supplyOrg, store.supplyOrg) && Objects.equals(this.stock, store.stock) && (store.position == null || Objects.equals(this.position, store.position));
        }

        public int hashCode() {
            return Objects.hash(this.supplyOrg, this.stock, this.position);
        }
    }
}

