/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.controlnode.framework.step.cps;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.step.AbstractMRPStep;
import kd.mmc.mrp.utils.CPSUtil;

public class CalcCPSResultReport
extends AbstractMRPStep {
    public CalcCPSResultReport(IMRPEnvProvider ctx) {
        super(ctx);
    }

    public String getStepDesc(Locale locale) {
        return null;
    }

    protected void innerExecute() {
        this.saveCPSReportResultDatas();
    }

    private void saveCPSReportResultDatas() {
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"mrp_cps_resultdatas");
        obj.set("runlognumber", (Object)this.ctx.getRunLogNumber());
        obj.set("creater", (Object)RequestContext.get().getCurrUserId());
        obj.set("createdate", (Object)this.ctx.getPlanDate());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
        DataSet dataSet = this.createResultGroupDatas();
        this.saveCPSReportGroupResultDatas(dataSet, obj);
    }

    private DataSet createResultDetailDatas() {
        return null;
    }

    private String getResultDetailSQL() {
        StringBuilder sql = new StringBuilder();
        sql.append("entryentity.billno s_billno,entryentity.billentryseq s_billrow,");
        sql.append("entryentity.billid s_billid,entryentity.billentryid s_billentryid,entryentity.demandbillf7 s_billtypef7,");
        sql.append("entryentity.supmaterial s_material,entryentity.configuredcode s_configuredcode,");
        sql.append("entryentity.tracknumber s_tracknumber,entryentity.demandauxpty s_auxpty,");
        sql.append("entryentity.demandqty s_requireqty,entryentity.demanddate s_requiredate,");
        sql.append("entryentity.supplyqty s_supplyqty,entryentity.supplydate s_supplydate,");
        sql.append("entryentity.ishandle ishandle,entryentity.supmaterialattr s_materialattr,");
        sql.append("entryentity.demandqty - entryentity.supplyqty s_shortageqty,entryentity.supplyqty s_planqty,");
        sql.append("entryentity.editreason editreason,entryentity.llc llc,");
        sql.append("entryentity.origindemanddate s_origindemanddate,entryentity.exceptionnumber exceptionnumber,");
        sql.append("entryentity.iskeypart s_iskeypart,entryentity.existkeypart s_existkeypart,");
        sql.append("entryentity.replaceplan s_replaceplan,entryentity.isreplace s_isreplace,");
        sql.append("entryentity.replacepriority s_replacepriority,entryentity.ismainreplace s_ismainreplace");
        return sql.toString();
    }

    private String getResultShortageSQL() {
        StringBuilder sql = new StringBuilder();
        sql.append("entryentity.billno s_billno,entryentity.billentryseq s_billrow,");
        sql.append("entryentity.billid s_billid,entryentity.billentryid s_billentryid,entryentity.demandbillf7 s_billtypef7,");
        sql.append("entryentity.material s_material,entryentity.configuredcode s_configuredcode,");
        sql.append("entryentity.tracknumber s_tracknumber,entryentity.demandauxpty s_auxpty,");
        sql.append("entryentity.srcdemandqty s_requireqty,entryentity.demanddate s_requiredate,");
        sql.append("entryentity.srcdemandqty - entryentity.adjustqty s_supplyqty,entryentity.supplydate s_supplydate,");
        sql.append("entryentity.ishandle ishandle,entryentity.materialattr s_materialattr,");
        sql.append("0-entryentity.adjustqty s_shortageqty,entryentity.supplyqty s_planqty,");
        sql.append("entryentity.editreason editreason,entryentity.llc llc,");
        sql.append("entryentity.origindemanddate s_origindemanddate,entryentity.exceptionnumber exceptionnumber,");
        sql.append("entryentity.iskeypart s_iskeypart,entryentity.existkeypart s_existkeypart,");
        sql.append("entryentity.replaceplan s_replaceplan,entryentity.isreplace s_isreplace,");
        sql.append("entryentity.replacepriority s_replacepriority,entryentity.ismainreplace s_ismainreplace");
        return sql.toString();
    }

    private void saveCPSReportGroupResultDatas(DataSet dataSet, DynamicObject obj) {
        StringBuilder sql = new StringBuilder();
        sql.append("insert into t_mrp_cps_resultdatas1 ");
        sql.append("(");
        sql.append("fid,fentryid,fseq,frequireorg,fbilltype,");
        sql.append("fbilltypef7,fbillno,fbillrow,fbillid,fbillentryid,");
        sql.append("fmaterial,fconfiguredcode,ftracknumber,fauxpty,funit,");
        sql.append("fcpsqty,fcancpsqty,frequiredate,forigindemanddate,fcpsdate,");
        sql.append("fstatus");
        sql.append(") values (");
        sql.append("?,?,?,?,?,");
        sql.append("?,?,?,?,?,");
        sql.append("?,?,?,?,?,");
        sql.append("?,?,?,?,?,");
        sql.append("?");
        sql.append(")");
        ArrayList<Object[]> valueList = new ArrayList<Object[]>(16);
        int seq = 0;
        int batch = CPSUtil.getDetailSaveBatch((IMRPEnvProvider)this.ctx);
        IDataEntityType dt = ORM.create().newDynamicObject("mrp_cps_resultdatas.entryentity").getDataEntityType();
        for (Row row : dataSet) {
            Object[] arr = new Object[21];
            arr[0] = obj.getPkValue();
            arr[2] = seq++;
            arr[3] = row.getLong("requireorg");
            arr[4] = row.getString("billtype");
            arr[5] = row.getString("billtypef7");
            arr[6] = row.getString("billno");
            arr[7] = row.getString("billrow");
            arr[8] = row.getString("billid");
            arr[9] = row.getString("billentryid");
            arr[10] = row.getLong("material");
            arr[11] = row.getLong("configuredcode");
            arr[12] = row.getLong("tracknumber");
            arr[13] = row.getLong("auxpty");
            arr[14] = row.getLong("unit");
            arr[15] = row.getBigDecimal("cpsqty");
            arr[16] = row.getBigDecimal("cancpsqty");
            arr[17] = row.getDate("requiredate");
            arr[18] = row.getDate("origindemanddate");
            arr[19] = row.getDate("cpsdate");
            arr[20] = row.getString("status");
            valueList.add(arr);
            if (valueList.size() < batch) continue;
            long[] genLongIds = ORM.create().genLongIds(dt, valueList.size());
            for (int i = 0; i < valueList.size(); ++i) {
                ((Object[])valueList.get((int)i))[1] = genLongIds[i];
            }
            DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)sql.toString(), valueList);
            valueList.clear();
        }
        if (!valueList.isEmpty()) {
            long[] genLongIds = ORM.create().genLongIds(dt, valueList.size());
            for (int i = 0; i < valueList.size(); ++i) {
                ((Object[])valueList.get((int)i))[1] = genLongIds[i];
            }
            DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)sql.toString(), valueList);
            valueList.clear();
        }
    }

    private DataSet createResultGroupDatas() {
        String detailSQL = this.getResultGroupDetailSql();
        DataSet detail = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mrp_cps_detail", (String)detailSQL, (QFilter[])new QFilter[]{new QFilter("caculatelog", "=", (Object)this.ctx.getRunLogNumber())}, null);
        detail = detail.where("exceptionnumber not like '%101%'");
        detail = detail.where("exceptionnumber not like '%87%'");
        DataSet select = detail.copy().where("llc != '0'").select("billid,billentryid,cpsdate cpsdate1");
        select = select.groupBy(new String[]{"billid", "billentryid"}).max("cpsdate1").finish();
        detail = detail.where("llc = '0'");
        detail = detail.leftJoin(select).on("billid", "billid").on("billentryid", "billentryid").select(detail.getRowMeta().getFieldNames(), new String[]{"cpsdate1"}).finish();
        detail = detail.updateField("cpsdate", "case when cpsdate1 != null then cpsdate1 else cpsdate end");
        detail = detail.removeFields(new String[]{"cpsdate1"});
        String shortageSQL = this.getResultGroupShortageSql();
        DataSet shortage = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mrp_cps_shortage", (String)shortageSQL, (QFilter[])new QFilter[]{new QFilter("caculatelog", "=", (Object)this.ctx.getRunLogNumber())}, null);
        shortage = shortage.where("exceptionnumber not like '%101%'");
        shortage = shortage.where("exceptionnumber not like '%87%'");
        shortage = shortage.where("llc = '0'");
        DataSet union = detail.union(shortage);
        union = union.updateField("ishandle", "case when ishandle then 0 else 1 end");
        DataSet headDataSet = union.groupBy(new String[]{"requireorg", "billtype", "billtypef7", "billid", "billentryid", "billno", "billrow"}).max("origindemanddate").finish();
        headDataSet = headDataSet.addFields(new String[]{"billid", "billentryid"}, new String[]{"billid1", "billentryid1"});
        headDataSet = headDataSet.removeFields(new String[]{"billid", "billentryid"});
        union = union.groupBy(new String[]{"billid", "billentryid", "material"}).max("configuredcode").max("tracknumber").max("auxpty").sum("cpsqty").max("requiredate").sum("cancpsqty").max("cpsdate").max("ishandle").finish();
        union = union.addField("case when cancpsqty = 0 then 'C' else (case when cancpsqty < cpsqty then 'D' else (case when ishandle = 1 then 'B' else 'A' end) end) end", "status");
        HashSet materialSet = new HashSet(16);
        union.copy().forEach(row -> materialSet.add(row.getLong("material")));
        DataSet materialDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_material", (String)"id,baseunit unit", (QFilter[])new QFilter[]{new QFilter("id", "in", materialSet)}, null);
        DataSet dataSet = union.leftJoin(materialDataSet).on("material", "id").select(union.getRowMeta().getFieldNames(), materialDataSet.getRowMeta().getFieldNames()).finish();
        union = dataSet.leftJoin(headDataSet).on("billid", "billid1").on("billentryid", "billentryid1").select(dataSet.getRowMeta().getFieldNames(), headDataSet.getRowMeta().getFieldNames()).finish();
        return union;
    }

    private String getResultGroupDetailSql() {
        StringBuilder sql = new StringBuilder();
        sql.append("entryentity.requireorg requireorg,entryentity.demandbilltype billtype,");
        sql.append("entryentity.billid billid,entryentity.billentryid billentryid,");
        sql.append("entryentity.demandbillf7 billtypef7,entryentity.llc llc,");
        sql.append("entryentity.billno billno,entryentity.billentryseq billrow,");
        sql.append("entryentity.supmaterial material,entryentity.configuredcode configuredcode,");
        sql.append("entryentity.tracknumber tracknumber,entryentity.demandauxpty auxpty,");
        sql.append("entryentity.demandqty cpsqty,entryentity.demanddate requiredate,");
        sql.append("entryentity.supplyqty cancpsqty,entryentity.ishandle ishandle,");
        sql.append("entryentity.origindemanddate origindemanddate,entryentity.supplydate cpsdate,");
        sql.append("entryentity.exceptionnumber exceptionnumber");
        return sql.toString();
    }

    private String getResultGroupShortageSql() {
        StringBuilder sql = new StringBuilder();
        sql.append("entryentity.requireorg requireorg,entryentity.demandbilltype billtype,");
        sql.append("entryentity.billid billid,entryentity.billentryid billentryid,");
        sql.append("entryentity.demandbillf7 billtypef7,entryentity.llc llc,");
        sql.append("entryentity.billno billno,entryentity.billentryseq billrow,");
        sql.append("entryentity.material material,entryentity.configuredcode configuredcode,");
        sql.append("entryentity.tracknumber tracknumber,entryentity.demandauxpty auxpty,");
        sql.append("entryentity.srcdemandqty cpsqty,entryentity.demanddate requiredate,");
        sql.append("entryentity.srcdemandqty - entryentity.adjustqty cancpsqty,entryentity.ishandle ishandle,");
        sql.append("entryentity.origindemanddate origindemanddate,entryentity.supplydate cpsdate,");
        sql.append("entryentity.exceptionnumber exceptionnumber");
        return sql.toString();
    }
}

