/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.controlnode.framework.step.cps;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mrp.calcnode.framework.mq.resolver.balance.MRPDataBalanceResolver;
import kd.mmc.mrp.calcnode.framework.mq.resolver.cps.CPSRequireStatNode;
import kd.mmc.mrp.calcnode.framework.mq.resolver.cps.CPSSupplyStatNode;
import kd.mmc.mrp.calcnode.framework.step.MRPCalQty4SupplyOrgStep;
import kd.mmc.mrp.calcnode.framework.step.MRPMDependentReqNewStep;
import kd.mmc.mrp.calcnode.framework.step.MRPMReuqirePriorityLevelCalcStep;
import kd.mmc.mrp.controlnode.framework.step.cps.CalcShortage;
import kd.mmc.mrp.framework.CalEnv;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.cache.MRPCacheManager;
import kd.mmc.mrp.framework.consts.MRPRuntimeConsts;
import kd.mmc.mrp.framework.step.AbstractMRPStep;
import kd.mmc.mrp.integrate.KDCloudCPSEnv;
import kd.mmc.mrp.integrate.entity.CacheDatas;
import kd.mmc.mrp.integrate.entity.MtPlanInfoModel;
import kd.mmc.mrp.integrate.entity.PlanModel;
import kd.mmc.mrp.integrate.entity.RequireDataModel;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mmc.mrp.model.enums.ResType;
import kd.mmc.mrp.model.enums.strategy.MaterialAttribute;
import kd.mmc.mrp.model.enums.strategy.PriorityLevelApplyType;
import kd.mmc.mrp.model.enums.strategy.PriorityLevelCalcMode;
import kd.mmc.mrp.model.table.ColumnDatas;
import kd.mmc.mrp.model.table.RequireRowData;
import kd.mmc.mrp.model.table.RowData;
import kd.mmc.mrp.model.table.res.BOMStructDataTable;
import kd.mmc.mrp.model.table.res.RequirementDataTable;
import kd.mmc.mrp.model.table.res.SupplymentDataTable;
import kd.mmc.mrp.model.table.utils.DataMatchUtils;
import kd.mmc.mrp.utils.CPSUtil;
import kd.mmc.mrp.utils.MRPUtil;
import kd.mmc.mrp.utils.ReserveUtil;

public class CalcNetDemand
extends AbstractMRPStep {
    private static final BigDecimal TWO = new BigDecimal(2);
    protected BOMStructDataTable bomTbl;
    protected RequirementDataTable requireTbl;
    protected SupplymentDataTable supplyTbl;
    protected Map<String, Integer> bomCache;
    protected Map<String, List<Integer>> bomChildrenCache;
    protected Map<Integer, CPSSupplyStatNode> allUsedSupplys = new HashMap<Integer, CPSSupplyStatNode>(100);
    private Map<String, Boolean> fullsetTypes = new HashMap<String, Boolean>();
    private Map<String, Long> cpsDates = new HashMap<String, Long>();
    private static Log logger = LogFactory.getLog(CalcNetDemand.class);
    List<Map<String, Object>> shortageDetails = new ArrayList<Map<String, Object>>();
    List<Map<String, Object>> reserveList = new ArrayList<Map<String, Object>>();
    Map<String, BigDecimal> reserveMap = new HashMap<String, BigDecimal>();
    private Long beginDate;
    private Long endDate;
    private int shortageCount = 0;
    private Map<Integer, Boolean> existKeyPartMap = new HashMap<Integer, Boolean>();
    private DynamicObject calcDetails;
    private HashSet<String> calculatableIds;
    private DynamicObject shortageObj;

    public CalcNetDemand(IMRPEnvProvider ctx) {
        super(ctx);
    }

    protected void innerExecute() {
        try (TXHandle h = TX.notSupported((String)"CalcNetDemand.execute");){
            Iterator iter;
            ColumnDatas plCol;
            this.bomCache = new HashMap<String, Integer>();
            this.bomChildrenCache = new HashMap<String, List<Integer>>();
            this.bomTbl = this.ctx.bomDatas();
            this.requireTbl = this.ctx.requireDatas();
            this.supplyTbl = this.ctx.supplyDatas();
            Map<String, Integer> materials = this.restoreDatas();
            this.releaseReserve();
            long start = System.currentTimeMillis();
            this.lr.createSubStepLog(1, ResManager.loadKDString((String)"\u52a0\u8f7d\u7269\u6599\u8ba1\u5212\u4fe1\u606f\u3002", (String)"CalcNetDemand_6", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), this.stepIdx);
            this.lr.saveStepLog(false);
            this.batchLoadInventory();
            this.reduceMaterial(materials);
            this.ctx.loadRequireMaterialExtProps();
            this.ctx.loadSupplyMaterialExtProps();
            this.ctx.getFlexDataTable().loadFlexValues();
            new MRPCalQty4SupplyOrgStep(this.ctx).execute();
            this.executeRequirePriorityStep();
            List<Integer> requireIndexs = this.getRequireIndexs(this.ctx);
            double time = (double)(System.currentTimeMillis() - start) / 1000.0 / 60.0;
            this.lr.updateSubStepLog(1, "entryoperatmin", (Object)time);
            start = System.currentTimeMillis();
            StringBuilder keyBuffer = new StringBuilder();
            ArrayList<Map<String, Object>> details = new ArrayList<Map<String, Object>>(this.requireTbl.size());
            this.lr.createSubStepLog(2, ResManager.loadKDString((String)"\u9f50\u5957\u8ba1\u7b97-\u72ec\u7acb\u9700\u6c42", (String)"CalcNetDemand_4", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), this.stepIdx);
            this.lr.saveStepLog(false);
            this.calcIndependentRequire(1, this.allUsedSupplys, details, requireIndexs, keyBuffer);
            this.lr.updateSubStepLog(2, "entrydetailmsg", (Object)String.format(ResManager.loadKDString((String)"\u5df2\u8ba1\u7b97\uff1a%1$s\uff0c\u9884\u8ba1\u5269\u4f59\uff1a%2$s\u3002", (String)"CalcNetDemand_7", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), requireIndexs.size(), 0));
            this.lr.saveStepLog(false);
            ArrayList<Integer> orderIdx = new ArrayList<Integer>();
            PriorityLevelApplyType plat = this.ctx.getPriorityLevelApplyType();
            if (PriorityLevelApplyType.DYNAMIC == plat) {
                plCol = this.requireTbl.getCol(DefaultField.RequireField.__PRIORITY_LEVEL__.name());
                iter = plCol.descendingIterator();
            } else {
                plCol = this.requireTbl.getCol(DefaultField.RequireField.DATE.getName());
                iter = plCol.ascendingIterator();
            }
            String json = MRPCacheManager.getInst().getData((CalEnv)this.ctx, MRPRuntimeConsts.getSelectBillSizeKey((String)this.ctx.getMRPContextId()));
            boolean isSelectBillPlan = json != null && Integer.parseInt(json) > 0;
            Map jsonStr = MRPCacheManager.getInst().getSubDataMap((CalEnv)this.ctx, "selectbills");
            HashSet<String> ids = new HashSet<String>(jsonStr.size());
            if (isSelectBillPlan) {
                for (Map.Entry x : jsonStr.entrySet()) {
                    List list = JSON.parseArray((String)((String)x.getValue()), Object[].class);
                    for (Object[] obj : list) {
                        Long billId = (Long)MRPUtil.convert((Object)obj[0], (Object)0L);
                        Long billEntryId = (Long)MRPUtil.convert((Object)obj[1], (Object)0L);
                        ids.add(billId + "\u0001" + billEntryId);
                    }
                }
            }
            while (iter.hasNext()) {
                Comparable val = (Comparable)iter.next();
                List rows = plCol.get((Object)val);
                for (Integer next : rows) {
                    RequireRowData reqData = this.requireTbl.fetchRow(next.intValue());
                    String id = reqData.get(DefaultField.RequireField.BILLID.getName()) + "\u0001" + reqData.get(DefaultField.RequireField.BILLENTRYID.getName());
                    if (isSelectBillPlan) {
                        if (!ids.contains(id) || !MRPUtil.convert((Object)reqData.getValue(DefaultField.RequireField.__IS_CALC_REQUIRE__.getName()), (Boolean)Boolean.FALSE).booleanValue()) continue;
                        orderIdx.add(next);
                        continue;
                    }
                    if (!MRPUtil.convert((Object)reqData.getValue(DefaultField.RequireField.__IS_CALC_REQUIRE__.getName()), (Boolean)Boolean.FALSE).booleanValue()) continue;
                    orderIdx.add(next);
                }
            }
            if (PriorityLevelApplyType.DYNAMIC != plat) {
                this.sortRequire(orderIdx);
            }
            this.ctx.putCustomParams("cps\u0001require\u0001list", JSON.toJSONString(orderIdx, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
            this.lr.createSubStepLog(3, ResManager.loadKDString((String)"\u9f50\u5957\u8ba1\u7b97-\u5728\u5236\u9700\u6c42", (String)"CalcNetDemand_8", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), this.stepIdx);
            this.lr.saveStepLog(false);
            this.calcVirtualRequire(1, this.allUsedSupplys, details, orderIdx, keyBuffer);
            this.lr.updateSubStepLog(3, "entrydetailmsg", (Object)String.format(ResManager.loadKDString((String)"\u5df2\u8ba1\u7b97\uff1a%1$s\uff0c\u9884\u8ba1\u5269\u4f59\uff1a%2$s\u3002", (String)"CalcNetDemand_7", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), orderIdx.size(), 0));
            this.lr.saveStepLog(false);
            this.ctx.putCustomParams("cps\u0001require\u0001list", JSON.toJSONString(requireIndexs, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
            this.lr.createSubStepLog(4, ResManager.loadKDString((String)"\u9f50\u5957\u8ba1\u7b97-\u76f8\u5173\u9700\u6c42", (String)"CalcNetDemand_12", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), this.stepIdx);
            this.lr.saveStepLog(false);
            this.calcRelatedRequire(1, this.allUsedSupplys, details, requireIndexs, keyBuffer);
            this.lr.updateSubStepLog(4, "entrydetailmsg", (Object)String.format(ResManager.loadKDString((String)"\u5df2\u8ba1\u7b97\uff1a%1$s\uff0c\u9884\u8ba1\u5269\u4f59\uff1a%2$s\u3002", (String)"CalcNetDemand_7", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), requireIndexs.size(), 0));
            this.lr.saveStepLog(false);
            requireIndexs.addAll(orderIdx);
            this.ctx.putCustomParams("cps\u0001require\u0001list", JSON.toJSONString(requireIndexs, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
            this.ctx.putCustomParams("cps\u0001keypart\u0001map", JSON.toJSONString(this.existKeyPartMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
            this.createRSMappings(details);
            if (!this.shortageDetails.isEmpty()) {
                DynamicObject shortageObj2 = this.getShortageObj();
                this.shortageCount += CPSUtil.batchExecuteSql(this.shortageDetails, (Long)shortageObj2.getLong("id"), (String)"mrp_cps_shortage.entryentity", (boolean)false);
            }
            time = (double)(System.currentTimeMillis() - start) / 1000.0 / 60.0;
            this.lr.updateSubStepLog(2, "entryoperatmin", (Object)time);
            this.ctx.putCustomParams("shortageCount", String.valueOf(this.shortageCount));
        }
    }

    private Map<String, Integer> restoreDatas() {
        PlanModel planModel;
        List llc2m = this.ctx.bomDatas().getLLC();
        Set<String> allReqIds = this.getAllReqStockMaterials();
        this.lr.createSubStepLog(0, ResManager.loadKDString((String)"\u7f13\u5b58\u6570\u636e\u6062\u590d\u81f3\u5185\u5b58", (String)"CalcNetDemand_0", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), this.stepIdx);
        this.lr.saveStepLog(false);
        int count = 0;
        long start = System.currentTimeMillis();
        Map materials = MRPCacheManager.getDStore((String)this.ctx.getMRPContextId()).mapGetAll(MRPRuntimeConsts.getSummarizeKey((String)this.ctx.getMRPContextId()));
        for (Set mIds : llc2m) {
            if (mIds == null) continue;
            this.restoreDatas(mIds, materials);
            allReqIds.removeAll(mIds);
            this.lr.updateSubStepLog(0, "entrydetailmsg", (Object)String.format(ResManager.loadKDString((String)"\u6309\u7167\u7269\u6599\u5df2\u8fd8\u539f\uff1a%1$s\uff0c\u9884\u8ba1\u5269\u4f59\uff1a%2$s\u3002", (String)"CalcNetDemand_3", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), count += mIds.size(), allReqIds.size()));
            this.lr.saveStepLog(false);
        }
        if (!allReqIds.isEmpty()) {
            this.restoreDatas(allReqIds, materials);
            this.lr.updateSubStepLog(0, "entrydetailmsg", (Object)String.format(ResManager.loadKDString((String)"\u6309\u7167\u7269\u6599\u5df2\u8fd8\u539f\uff1a%1$s\uff0c\u9884\u8ba1\u5269\u4f59\uff1a%2$s\u3002", (String)"CalcNetDemand_3", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), count += allReqIds.size(), 0));
            this.lr.saveStepLog(false);
        }
        if ((planModel = (PlanModel)this.ctx.getService(PlanModel.class)).getWipSupply2Require().isEmpty()) {
            SupplymentDataTable supplyDatas = this.ctx.supplyDatas();
            for (int i = 0; i < supplyDatas.size(); ++i) {
                supplyDatas.updateValue(DefaultField.SupplyField.ISONWORK.getName(), Integer.valueOf(i), (Object)false);
            }
        }
        double time = (double)(System.currentTimeMillis() - start) / 1000.0 / 60.0;
        this.lr.updateSubStepLog(0, "entryoperatmin", (Object)time);
        return materials;
    }

    private void reduceMaterial(Map<String, Integer> materials) {
        Iterator<Map.Entry<String, Integer>> it = materials.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Integer> entry = it.next();
            if (entry.getValue() != 0) continue;
            it.remove();
        }
        Set<String> set = materials.keySet();
        MtPlanInfoModel mtPlanInfoModel = (MtPlanInfoModel)this.ctx.getService(MtPlanInfoModel.class);
        set.retainAll(mtPlanInfoModel.getOriEnabledMaterialIds());
        Set enabledMaterialIds = mtPlanInfoModel.getEnabledMaterialIds();
        enabledMaterialIds.retainAll(set);
        mtPlanInfoModel.setEnabledMaterialIds(enabledMaterialIds);
        MRPCacheManager.getInst().putData((CalEnv)this.ctx, MRPRuntimeConsts.getMaterialTableKey((String)this.ctx.getMRPContextId()), JSON.toJSONString((Object)enabledMaterialIds, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
    }

    private List<Integer> getRequireIndexs(IMRPEnvProvider ctx) {
        boolean isSelectBillPlan;
        Iterator iter;
        ColumnDatas plCol;
        PriorityLevelApplyType plat = ctx.getPriorityLevelApplyType();
        RequirementDataTable requireTbl = ctx.requireDatas();
        if (PriorityLevelApplyType.DYNAMIC == plat) {
            plCol = requireTbl.getCol(DefaultField.RequireField.__PRIORITY_LEVEL__.name());
            iter = plCol.descendingIterator();
        } else {
            plCol = requireTbl.getCol(DefaultField.RequireField.DATE.getName());
            iter = plCol.ascendingIterator();
        }
        ArrayList<Integer> indexs = new ArrayList<Integer>(16);
        String json = MRPCacheManager.getInst().getData((CalEnv)ctx, MRPRuntimeConsts.getSelectBillSizeKey((String)ctx.getMRPContextId()));
        boolean bl = isSelectBillPlan = json != null && Integer.parseInt(json) > 0;
        if (ctx.getCustomParams("cps_begin") != null && ctx.getCustomParams("cps_end") != null) {
            this.beginDate = Long.valueOf(ctx.getCustomParams("cps_begin"));
            this.endDate = Long.valueOf(ctx.getCustomParams("cps_end"));
        }
        if (isSelectBillPlan) {
            Map jsonStr = MRPCacheManager.getInst().getSubDataMap((CalEnv)ctx, "selectbills");
            HashSet<String> ids = new HashSet<String>(jsonStr.size());
            for (Map.Entry x : jsonStr.entrySet()) {
                List list = JSON.parseArray((String)((String)x.getValue()), Object[].class);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Object[] obj = (Object[])iterator.next();
                    Long billId = (Long)MRPUtil.convert((Object)obj[0], (Object)0L);
                    Long billEntryId = (Long)MRPUtil.convert((Object)obj[1], (Object)0L);
                    ids.add(billId + "\u0001" + billEntryId);
                }
            }
            while (iter.hasNext()) {
                Comparable val = (Comparable)iter.next();
                List rows = plCol.get((Object)val);
                for (Integer idx : rows) {
                    boolean isCalc;
                    RequireRowData reqData = requireTbl.fetchRow(idx.intValue());
                    String id = reqData.get(DefaultField.RequireField.BILLID.getName()) + "\u0001" + reqData.get(DefaultField.RequireField.BILLENTRYID.getName());
                    this.addOnWorkSupply(reqData);
                    this.updateStockRequire(reqData);
                    BigDecimal netDemand = (BigDecimal)MRPUtil.convert((Object)reqData.getValue(DefaultField.RequireField.QTY.getName()), (Object)BigDecimal.ZERO);
                    Object supplyId = reqData.getValue(DefaultField.RequireField.SUPPLYBILLID.getName());
                    boolean bl2 = isCalc = netDemand.compareTo(BigDecimal.ZERO) > 0;
                    if (this.beginDate != null && this.endDate != null) {
                        Long requireDate = 0L;
                        requireDate = reqData.getValue(DefaultField.RequireField.CPSDATE.getName()) != null ? (Long)MRPUtil.convert((Object)reqData.getValue(DefaultField.RequireField.CPSDATE.getName()), (Object)0L) : (Long)MRPUtil.convert((Object)reqData.getValue(DefaultField.RequireField.DATE.getName()), (Object)0L);
                        if (this.beginDate.compareTo(requireDate) > 0 || this.endDate.compareTo(requireDate) < 0) continue;
                    }
                    Boolean isOnWork = MRPUtil.convert((Object)reqData.getValue(DefaultField.RequireField.__ISONWORK__.getName()), (Boolean)Boolean.FALSE);
                    if (supplyId != null || !isCalc || !ids.contains(id) || isOnWork.booleanValue()) continue;
                    indexs.add(idx);
                }
            }
        } else {
            while (iter.hasNext()) {
                Comparable val = (Comparable)iter.next();
                List rows = plCol.get((Object)val);
                for (Integer idx : rows) {
                    RequireRowData reqData = requireTbl.fetchRow(idx.intValue());
                    this.addOnWorkSupply(reqData);
                    this.updateStockRequire(reqData);
                    BigDecimal netDemand = (BigDecimal)MRPUtil.convert((Object)reqData.getValue(DefaultField.RequireField.QTY.getName()), (Object)BigDecimal.ZERO);
                    Object supplyId = reqData.getValue(DefaultField.RequireField.SUPPLYBILLID.getName());
                    if (this.beginDate != null && this.endDate != null) {
                        Long requireDate = 0L;
                        requireDate = reqData.getValue(DefaultField.RequireField.CPSDATE.getName()) != null ? (Long)MRPUtil.convert((Object)reqData.getValue(DefaultField.RequireField.CPSDATE.getName()), (Object)0L) : (Long)MRPUtil.convert((Object)reqData.getValue(DefaultField.RequireField.DATE.getName()), (Object)0L);
                        if (this.beginDate.compareTo(requireDate) > 0 || this.endDate.compareTo(requireDate) < 0) continue;
                    }
                    boolean isCalc = netDemand.compareTo(BigDecimal.ZERO) > 0;
                    Boolean isOnWork = MRPUtil.convert((Object)reqData.getValue(DefaultField.RequireField.__ISONWORK__.getName()), (Boolean)Boolean.FALSE);
                    if (supplyId != null || !isCalc || isOnWork.booleanValue()) continue;
                    indexs.add(idx);
                }
            }
        }
        if (PriorityLevelApplyType.DYNAMIC != plat) {
            this.sortRequire(indexs);
        }
        return indexs;
    }

    private void updateStockRequire(RequireRowData reqData) {
        Boolean isOnWork = MRPUtil.convert((Object)reqData.getValue(DefaultField.RequireField.__ISONWORK__.getName()), (Boolean)Boolean.FALSE);
        if (isOnWork.booleanValue()) {
            Long billEntryId = (Long)MRPUtil.convert((Object)reqData.getValue(DefaultField.RequireField.BILLENTRYID.getName()), (Object)0L);
            List subRows = this.requireTbl.getCol(DefaultField.RequireField.SUPPLYBILLID.getName()).get((Object)billEntryId);
            Integer supplyIdx = MRPUtil.findSupOrReqIndex((IMRPEnvProvider)this.ctx, (boolean)true, (Integer)reqData.getRowIdx());
            BigDecimal qty = (BigDecimal)MRPUtil.convert((Object)this.supplyTbl.getValue(DefaultField.SupplyField.ORIGINQTY.getName(), supplyIdx.intValue()), (Object)BigDecimal.ZERO);
            if (qty.compareTo(BigDecimal.ZERO) > 0 && !subRows.isEmpty()) {
                for (Integer idx : subRows) {
                    BigDecimal childQty;
                    RequireRowData subReqData = this.requireTbl.fetchRow(idx.intValue());
                    Object unit = subReqData.getValue(DefaultField.RequireField.BASEUNIT.getName());
                    if (subReqData.getValue(DefaultField.RequireField.MODULENUMERATOR.getName()) == null || subReqData.getValue(DefaultField.RequireField.MODULEDENOMINATOR.getName()) == null) {
                        childQty = (BigDecimal)MRPUtil.convert((Object)subReqData.getValue(DefaultField.RequireField.QTY.getName()), (Object)BigDecimal.ZERO);
                        subReqData.update(DefaultField.RequireField.MODULENUMERATOR.getName(), (Object)childQty);
                        subReqData.update(DefaultField.RequireField.MODULEDENOMINATOR.getName(), (Object)qty);
                        subReqData.update(DefaultField.RequireField.__DEPENDENT_UNIT_QTY__.getName(), (Object)childQty.divide(qty, 12, 4));
                        continue;
                    }
                    childQty = (BigDecimal)MRPUtil.convert((Object)subReqData.getValue(DefaultField.RequireField.MODULENUMERATOR.getName()), (Object)BigDecimal.ZERO);
                    qty = (BigDecimal)MRPUtil.convert((Object)subReqData.getValue(DefaultField.RequireField.MODULEDENOMINATOR.getName()), (Object)BigDecimal.ZERO);
                    subReqData.update(DefaultField.RequireField.__DEPENDENT_UNIT_QTY__.getName(), (Object)childQty.divide(qty, 12, 4));
                }
            }
        }
    }

    private void sortRequire(List<Integer> indexs) {
        final HashMap<String, Integer> llcMap = new HashMap<String, Integer>(16);
        List llc2m = this.ctx.bomDatas().getLLC();
        for (int i = 0; i < llc2m.size(); ++i) {
            Set mids = (Set)llc2m.get(i);
            for (String mid : mids) {
                llcMap.put(mid, i);
            }
        }
        indexs.sort(new Comparator<Integer>(){

            @Override
            public int compare(Integer idx1, Integer idx2) {
                Integer llc2;
                RequireRowData reqData1 = CalcNetDemand.this.requireTbl.fetchRow(idx1.intValue());
                RequireRowData reqData2 = CalcNetDemand.this.requireTbl.fetchRow(idx2.intValue());
                Long requireDate1 = (Long)MRPUtil.convert((Object)reqData1.getValue(DefaultField.RequireField.DATE.getName()), (Object)0L);
                Long requireDate2 = (Long)MRPUtil.convert((Object)reqData2.getValue(DefaultField.RequireField.DATE.getName()), (Object)0L);
                Long material1 = (Long)MRPUtil.convert((Object)reqData1.getValue(DefaultField.RequireField.MATERIAL.getName()), (Object)0L);
                Long material2 = (Long)MRPUtil.convert((Object)reqData2.getValue(DefaultField.RequireField.MATERIAL.getName()), (Object)0L);
                Integer llc1 = llcMap.getOrDefault(material1.toString(), Integer.MAX_VALUE);
                if (llc1.equals(llc2 = llcMap.getOrDefault(material2.toString(), Integer.MAX_VALUE))) {
                    if (requireDate1.equals(requireDate2)) {
                        if (material1.equals(material2)) {
                            BigDecimal requireQty1 = (BigDecimal)MRPUtil.convert((Object)reqData1.getValue(DefaultField.RequireField.QTY.getName()), (Object)BigDecimal.ZERO);
                            BigDecimal requireQty2 = (BigDecimal)MRPUtil.convert((Object)reqData2.getValue(DefaultField.RequireField.QTY.getName()), (Object)BigDecimal.ZERO);
                            return requireQty1.compareTo(requireQty2);
                        }
                        return material1.compareTo(material2);
                    }
                    return requireDate1.compareTo(requireDate2);
                }
                return llc1.compareTo(llc2);
            }
        });
    }

    private Set<String> getAllReqStockMaterials() {
        HashSet<String> allReqIds = new HashSet<String>(this.ctx.bomDatas().getRequireMaterials());
        allReqIds.addAll(this.ctx.getEnableMaterialIds());
        PlanModel planModel = (PlanModel)this.ctx.getService(PlanModel.class);
        Set collect = planModel.getEnabledRequires().stream().map(Long::valueOf).collect(Collectors.toSet());
        DynamicObjectCollection dqs = QueryServiceHelper.query((String)"mrp_resource_dataconfig", (String)"id,name,number,billfieldtransfer.srcbill srcbill", (QFilter[])new QFilter[]{new QFilter("id", "in", collect)});
        List<String> requireBills = Arrays.asList("pom_mftstock", "om_mftstock", "mrp_planorder", "om_componentlist");
        for (DynamicObject obj : dqs) {
            if (!requireBills.contains(obj.getString("srcbill"))) continue;
            String id = obj.getString("id");
            String eventid = MRPCacheManager.getInst().getData((CalEnv)this.ctx, id);
            List list = JSON.parseArray((String)MRPCacheManager.getInst().getData((CalEnv)this.ctx, MRPRuntimeConsts.getSeparateKey((String)eventid, (String)id)), String.class);
            if (list != null) {
                allReqIds.addAll(list);
            }
            MtPlanInfoModel mtPlanInfoModel = (MtPlanInfoModel)this.ctx.getService(MtPlanInfoModel.class);
            RequireDataModel requireDataModel = (RequireDataModel)this.ctx.getService(RequireDataModel.class);
            HashSet notInitMids = new HashSet(allReqIds);
            notInitMids.retainAll(mtPlanInfoModel.getOriEnabledMaterialIds());
            notInitMids.removeAll(mtPlanInfoModel.getEnabledMaterialIds());
            if (notInitMids.isEmpty()) continue;
            requireDataModel.initMaterialPlanInfos(false, notInitMids);
            Set enabledMaterialIds = mtPlanInfoModel.getEnabledMaterialIds();
            enabledMaterialIds.addAll(notInitMids);
            mtPlanInfoModel.setEnabledMaterialIds(enabledMaterialIds);
            MRPCacheManager.getInst().putData((CalEnv)this.ctx, MRPRuntimeConsts.getMaterialTableKey((String)this.ctx.getMRPContextId()), JSON.toJSONString((Object)enabledMaterialIds, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
            Map materialPlanInfos = mtPlanInfoModel.getMaterialPlanInfos();
            Iterator iterator = materialPlanInfos.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                if (next.getValue() != null) continue;
                iterator.remove();
            }
        }
        collect = planModel.getEnabledSupplys().stream().map(Long::valueOf).collect(Collectors.toSet());
        dqs = QueryServiceHelper.query((String)"mrp_resource_dataconfig", (String)"id,name,number,billfieldtransfer.srcbill srcbill", (QFilter[])new QFilter[]{new QFilter("id", "in", collect)});
        List<String> supplyBills = Arrays.asList("pom_mftorder", "om_mftorder", "mrp_planorder", "pm_om_purorderbill");
        for (DynamicObject obj : dqs) {
            if (!supplyBills.contains(obj.getString("srcbill"))) continue;
            String id = obj.getString("id");
            String eventid = MRPCacheManager.getInst().getData((CalEnv)this.ctx, id);
            List list = JSON.parseArray((String)MRPCacheManager.getInst().getData((CalEnv)this.ctx, MRPRuntimeConsts.getSeparateKey((String)eventid, (String)id)), String.class);
            if (list != null) {
                allReqIds.addAll(list);
            }
            MtPlanInfoModel mtPlanInfoModel = (MtPlanInfoModel)this.ctx.getService(MtPlanInfoModel.class);
            RequireDataModel requireDataModel = (RequireDataModel)this.ctx.getService(RequireDataModel.class);
            HashSet<String> notInitMids = new HashSet<String>(allReqIds);
            notInitMids.retainAll(mtPlanInfoModel.getOriEnabledMaterialIds());
            notInitMids.removeAll(mtPlanInfoModel.getEnabledMaterialIds());
            if (notInitMids.isEmpty()) continue;
            requireDataModel.initMaterialPlanInfos(false, notInitMids);
            Set enabledMaterialIds = mtPlanInfoModel.getEnabledMaterialIds();
            enabledMaterialIds.addAll(notInitMids);
            mtPlanInfoModel.setEnabledMaterialIds(enabledMaterialIds);
            MRPCacheManager.getInst().putData((CalEnv)this.ctx, MRPRuntimeConsts.getMaterialTableKey((String)this.ctx.getMRPContextId()), JSON.toJSONString((Object)enabledMaterialIds, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
            Map materialPlanInfos = mtPlanInfoModel.getMaterialPlanInfos();
            Iterator iterator = materialPlanInfos.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                if (next.getValue() != null) continue;
                iterator.remove();
            }
        }
        return allReqIds;
    }

    private void createRSMappings(List<Map<String, Object>> details) {
        HashSet usagePaths = new HashSet();
        PlanModel planModel = (PlanModel)this.ctx.getService(PlanModel.class);
        if (this.calcDetails == null) {
            this.calcDetails = BusinessDataServiceHelper.newDynamicObject((String)"mrp_cps_detail");
            this.calcDetails.set("caculatelog", (Object)this.ctx.getRunLogNumber());
            this.calcDetails.set("mrpplan", (Object)planModel.getPlanId());
            this.calcDetails.set("createtime", (Object)System.currentTimeMillis());
            this.calcDetails.set("runtype", (Object)this.ctx.getRunLog().getString("runtype"));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.calcDetails});
        }
        HashMap<String, String> reserveType = new HashMap<String, String>(8);
        DynamicObjectCollection col = planModel.getPlan().getDynamicObjectCollection("scentryentity");
        for (DynamicObject dynamicObject : col) {
            reserveType.put(dynamicObject.getString("resourceregisters.id"), dynamicObject.getString("reservetype"));
        }
        for (Map.Entry<Integer, CPSSupplyStatNode> entry : this.allUsedSupplys.entrySet()) {
            this.ctx.testEnvStatus();
            Integer supplyIdx = entry.getKey();
            RowData supply = this.supplyTbl.fetchRow(supplyIdx.intValue());
            CPSSupplyStatNode node = entry.getValue();
            node.visitConsume4Deps((k, v) -> {
                Integer idx = Integer.valueOf(k.split("\u0001")[0]);
                this.addMapping(idx, (Map<String, BigDecimal>)v, supply, usagePaths, details, (levelKey, row) -> {
                    String name = ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\uff08\u9886\u6599\uff09", (String)"CalcNetDemand_1", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]);
                    String[] parts = levelKey.split("\u0001");
                    if (parts.length > 0 && !"-1".equals(parts[parts.length - 2])) {
                        name = String.format("%1$s%2$s", this.supplyTbl.getValue("__MODEL_NUMBER__", Integer.parseInt(parts[parts.length - 2])), ResManager.loadKDString((String)"\uff08\u9886\u6599\uff09", (String)"CalcNetDemand_13", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]));
                    }
                    row.put("editreason", name);
                    row.put("ishandle", MRPUtil.convert((Object)supply.getValue(DefaultField.SupplyField.ISSTORAGEDATA.getName()), (Boolean)Boolean.FALSE));
                    if (MRPUtil.convert((Object)supply.getValue(DefaultField.SupplyField.ISONWORK.getName()), (Boolean)Boolean.FALSE).booleanValue()) {
                        row.put("yieldratio", MRPUtil.convert((Object)supply.getValue(DefaultField.SupplyField.YIELD.getName()), (Object)BigDecimal.ONE));
                    }
                    String rowKey = k + "\u0001" + supplyIdx;
                    this.setFullSetStatus(rowKey, row);
                    RequireRowData require = this.requireTbl.fetchRow(idx.intValue());
                    String rid = String.valueOf(require.getValue(DefaultField.RequireField.MATERIAL.getName()));
                    String sid = String.valueOf(supply.getValue(DefaultField.SupplyField.MATERIAL.getName()));
                    RequireRowData requireData = node.getRequireData(k, levelKey);
                    if (!rid.equals(sid) && requireData != null) {
                        row.put("demandwarehouse", requireData.getValue(DefaultField.RequireField.WAREHOUSE.getName()));
                        row.put("demandplanscope", requireData.getValue(DefaultField.RequireField.PLANSCOPE.getName()));
                        row.put("materialattr", requireData.getValue(DefaultField.RequireField.MATERIALATTR.getName()));
                        row.put("scrapratio", requireData.getValue(DefaultField.RequireField.__SCRAPRATIO__.getName()));
                        row.put("dynamicscrapratio", requireData.getValue(DefaultField.RequireField.__DYNAMICSCRAPRATIO__.getName()));
                        row.put("fixscrap", requireData.getValue(DefaultField.RequireField.__FIXSCRAP__.getName()));
                        row.put("dynamicscrapformula", requireData.getValue(DefaultField.RequireField.__DYNAMICSCRAPFORMULA__.getName()));
                    }
                    if (requireData != null) {
                        row.put("iskeypart", requireData.getValue(DefaultField.RequireField.__IS_KEYPART__.getName()));
                        row.put("existkeypart", requireData.getValue(DefaultField.RequireField.__EXIST_KEYPART__.getName()));
                        row.put("replaceplan", requireData.getValue(DefaultField.RequireField.REPLACEPLAN.getName()));
                        row.put("replacepriority", requireData.getValue(DefaultField.RequireField.REPLACEPRIORITY.getName()));
                        row.put("ismianreplace", requireData.getValue(DefaultField.RequireField.ISREPLACEPLANMM.getName()));
                        row.put("isreplace", requireData.getValue(DefaultField.RequireField.ISREPLACE.getName()));
                    }
                    return true;
                });
            });
            node.visitConsume4BOMs((k, v) -> {
                Integer idx = Integer.valueOf(k.split("\u0001")[0]);
                this.addMapping(idx, (Map<String, BigDecimal>)v, supply, usagePaths, details, (levelKey, row) -> {
                    RequireRowData require = this.requireTbl.fetchRow(idx.intValue());
                    String rid = String.valueOf(require.getValue(DefaultField.RequireField.MATERIAL.getName()));
                    String sid = String.valueOf(supply.getValue(DefaultField.SupplyField.MATERIAL.getName()));
                    RequireRowData requireData = node.getRequireData(k, levelKey);
                    ReserveUtil.createCPSReserveDatas((PlanModel)planModel, this.reserveList, (Map)reserveType, (RequireRowData)requireData, (RowData)supply, (HashMap)row, (RequireRowData)require);
                    if (rid.equals(sid)) {
                        if ("".equals(supply.getValue(DefaultField.SupplyField.BILLID.getName()))) {
                            row.put("editreason", "PLAN");
                        } else {
                            row.put("editreason", supply.getValue("__MODEL_NUMBER__"));
                        }
                    } else {
                        row.put("editreason", "BOM");
                        if (requireData != null) {
                            row.put("demandwarehouse", requireData.getValue(DefaultField.RequireField.WAREHOUSE.getName()));
                            row.put("demandplanscope", requireData.getValue(DefaultField.RequireField.PLANSCOPE.getName()));
                            row.put("materialattr", requireData.getValue(DefaultField.RequireField.MATERIALATTR.getName()));
                            row.put("scrapratio", requireData.getValue(DefaultField.RequireField.__SCRAPRATIO__.getName()));
                            row.put("dynamicscrapratio", requireData.getValue(DefaultField.RequireField.__DYNAMICSCRAPRATIO__.getName()));
                            row.put("fixscrap", requireData.getValue(DefaultField.RequireField.__FIXSCRAP__.getName()));
                            row.put("dynamicscrapformula", requireData.getValue(DefaultField.RequireField.__DYNAMICSCRAPFORMULA__.getName()));
                        }
                    }
                    if (requireData != null) {
                        row.put("iskeypart", requireData.getValue(DefaultField.RequireField.__IS_KEYPART__.getName()));
                        row.put("existkeypart", requireData.getValue(DefaultField.RequireField.__EXIST_KEYPART__.getName()));
                        row.put("replaceplan", requireData.getValue(DefaultField.RequireField.REPLACEPLAN.getName()));
                        row.put("replacepriority", requireData.getValue(DefaultField.RequireField.REPLACEPRIORITY.getName()));
                        row.put("ismianreplace", requireData.getValue(DefaultField.RequireField.ISREPLACEPLANMM.getName()));
                        row.put("isreplace", requireData.getValue(DefaultField.RequireField.ISREPLACE.getName()));
                    }
                    row.put("ishandle", MRPUtil.convert((Object)supply.getValue(DefaultField.SupplyField.ISSTORAGEDATA.getName()), (Boolean)Boolean.FALSE));
                    String rowKey = k + "\u0001" + supplyIdx;
                    this.setFullSetStatus(rowKey, row);
                    return true;
                });
            });
            node.visitConsumeQty4DepSupplys((k, v) -> {
                Integer idx = Integer.valueOf(k.split("\u0001")[0]);
                this.addMapping(idx, (Map<String, BigDecimal>)v, supply, usagePaths, details, (levelKey, row) -> {
                    String[] parts = levelKey.split("\u0001");
                    if (parts.length > 0 && !"-1".equals(parts[parts.length - 2])) {
                        row.put("editreason", this.supplyTbl.getValue("__MODEL_NUMBER__", Integer.parseInt(parts[parts.length - 2])));
                    }
                    row.put("ishandle", MRPUtil.convert((Object)supply.getValue(DefaultField.SupplyField.ISSTORAGEDATA.getName()), (Boolean)Boolean.FALSE));
                    String rowKey = k + "\u0001" + supplyIdx;
                    this.setFullSetStatus(rowKey, row);
                    RequireRowData requireData = node.getRequireData(k, levelKey);
                    if (requireData != null) {
                        row.put("demanddate", requireData.getValue(DefaultField.RequireField.DATE.getName()));
                    }
                    RequireRowData require = this.requireTbl.fetchRow(idx.intValue());
                    String rid = String.valueOf(require.getValue(DefaultField.RequireField.MATERIAL.getName()));
                    String sid = String.valueOf(supply.getValue(DefaultField.SupplyField.MATERIAL.getName()));
                    ReserveUtil.createCPSReserveDatas((PlanModel)planModel, this.reserveList, (Map)reserveType, (RequireRowData)requireData, (RowData)supply, (HashMap)row, (RequireRowData)require);
                    if (!rid.equals(sid) && requireData != null) {
                        row.put("workcenter", requireData.getValue(DefaultField.RequireField.WORKCENTER.getName()));
                        row.put("operationno", requireData.getValue(DefaultField.RequireField.OPERATIONNO.getName()));
                        row.put("operationdesc", requireData.getValue(DefaultField.RequireField.OPERATIONDESC.getName()));
                        row.put("operation", requireData.getValue(DefaultField.RequireField.OPERATION.getName()));
                        row.put("demandwarehouse", requireData.getValue(DefaultField.RequireField.WAREHOUSE.getName()));
                        row.put("demandplanscope", requireData.getValue(DefaultField.RequireField.PLANSCOPE.getName()));
                        row.put("materialattr", requireData.getValue(DefaultField.RequireField.MATERIALATTR.getName()));
                        row.put("scrapratio", requireData.getValue(DefaultField.RequireField.__SCRAPRATIO__.getName()));
                        row.put("dynamicscrapratio", requireData.getValue(DefaultField.RequireField.__DYNAMICSCRAPRATIO__.getName()));
                        row.put("fixscrap", requireData.getValue(DefaultField.RequireField.__FIXSCRAP__.getName()));
                        row.put("dynamicscrapformula", requireData.getValue(DefaultField.RequireField.__DYNAMICSCRAPFORMULA__.getName()));
                    }
                    if (requireData != null) {
                        row.put("iskeypart", requireData.getValue(DefaultField.RequireField.__IS_KEYPART__.getName()));
                        row.put("existkeypart", requireData.getValue(DefaultField.RequireField.__EXIST_KEYPART__.getName()));
                        row.put("replaceplan", requireData.getValue(DefaultField.RequireField.REPLACEPLAN.getName()));
                        row.put("replacepriority", requireData.getValue(DefaultField.RequireField.REPLACEPRIORITY.getName()));
                        row.put("ismianreplace", requireData.getValue(DefaultField.RequireField.ISREPLACEPLANMM.getName()));
                        row.put("isreplace", requireData.getValue(DefaultField.RequireField.ISREPLACE.getName()));
                    }
                    return true;
                });
            });
            if (details.size() <= CPSUtil.getDetailSaveBatch((IMRPEnvProvider)this.ctx)) continue;
            this.dataAmount += CPSUtil.batchExecuteSql(details, (Long)this.calcDetails.getLong("id"), (String)"mrp_cps_detail.entryentity", (boolean)true);
        }
        HashSet<String> isAddSet = new HashSet<String>();
        for (String usagePath : usagePaths) {
            this.addLevelMapping(usagePath, details, isAddSet);
            if (details.size() <= CPSUtil.getDetailSaveBatch((IMRPEnvProvider)this.ctx)) continue;
            this.dataAmount += CPSUtil.batchExecuteSql(details, (Long)this.calcDetails.getLong("id"), (String)"mrp_cps_detail.entryentity", (boolean)true);
        }
        if (!details.isEmpty()) {
            this.dataAmount += CPSUtil.batchExecuteSql(details, (Long)this.calcDetails.getLong("id"), (String)"mrp_cps_detail.entryentity", (boolean)true);
        }
        if (!this.reserveList.isEmpty()) {
            Iterator<Map<String, Object>> iterator = this.reserveList.iterator();
            while (iterator.hasNext()) {
                Map<String, Object> map = iterator.next();
                String key = String.format("%s\u0001%s\u0001%s\u0001%s", map.get("bill_id"), map.get("billentry_id"), map.get("bal_id"), map.get("bal_entryid"));
                BigDecimal reserveQty = this.reserveMap.get(key);
                if (reserveQty == null) continue;
                BigDecimal qty = (BigDecimal)map.get("qty");
                if (qty.compareTo(reserveQty) > 0) {
                    map.put("qty", qty.subtract(reserveQty));
                    map.put("base_qty", qty.subtract(reserveQty));
                    map.put("ori_qty", qty.subtract(reserveQty));
                    continue;
                }
                iterator.remove();
            }
            if (!this.reserveList.isEmpty()) {
                List<Map<String, Object>> subList;
                int batch = (Integer)this.ctx.getCfgValue(EnvCfgItem.MRP_MATERIAL_PLANINFO_BATCH);
                int idx = 0;
                int listSize = this.reserveList.size();
                while (idx + batch < listSize) {
                    subList = this.reserveList.subList(idx, idx += batch);
                    ReserveUtil.createReserveRecord((IMRPEnvProvider)this.ctx, subList, new HashSet());
                }
                if (listSize > idx) {
                    subList = this.reserveList.subList(idx, listSize);
                    ReserveUtil.createReserveRecord((IMRPEnvProvider)this.ctx, subList, new HashSet());
                }
            }
        }
    }

    private BigDecimal calcIndependentRequire(int level, Map<Integer, CPSSupplyStatNode> levelUsedSupplys, List<Map<String, Object>> details, List<Integer> rows, StringBuilder keyBuffer) {
        BigDecimal grade = BigDecimal.ZERO;
        HashMap statsCache4MFT = new HashMap();
        HashMap statsCache4BOM = new HashMap();
        CPSRequireStatNode cpsNode = new CPSRequireStatNode("", -1, null, -1, Integer.valueOf(-1), 0, 1);
        MRPMDependentReqNewStep dateUtil = new MRPMDependentReqNewStep(this.ctx);
        cpsNode.setDateUtil(dateUtil);
        boolean isLet = ((KDCloudCPSEnv)this.ctx).isLet();
        for (int i = 0; i < rows.size(); ++i) {
            boolean isCalc;
            Integer reqRowIdx = rows.get(i);
            this.ctx.testEnvStatus();
            RequireRowData reqData = this.requireTbl.fetchRow(reqRowIdx.intValue());
            if (reqData.getValue(DefaultField.RequireField.DATE.getName()) == null || this.ctx.getPlanDate().getTime() > reqData.getLong(DefaultField.RequireField.DATE.getName())) {
                reqData.update(DefaultField.RequireField.DATE.getName(), (Object)this.ctx.getPlanDate().getTime());
            }
            reqData.update(DefaultField.RequireField.__START_DATE__.getName(), reqData.getValue(DefaultField.RequireField.DATE.getName()));
            reqData.update(DefaultField.RequireField.__ORDER_DATE__.getName(), reqData.getValue(DefaultField.RequireField.DATE.getName()));
            if (!this.isCalculatableData(reqData)) continue;
            BigDecimal netDemand = (BigDecimal)MRPUtil.convert((Object)reqData.getValue(DefaultField.RequireField.QTY.getName()), (Object)BigDecimal.ZERO);
            boolean bl = isCalc = netDemand.compareTo(BigDecimal.ZERO) <= 0;
            if (isCalc) {
                this.addIndependentReqSupply(reqData, BigDecimal.ZERO, details);
                continue;
            }
            BigDecimal requireQty = netDemand;
            if (((KDCloudCPSEnv)this.ctx).isKeyPart()) {
                int bomIdx;
                if (MaterialAttribute.PURCHASEDPART.getValue() != ((Integer)MRPUtil.convert((Object)reqData.get(DefaultField.RequireField.MATERIALATTR.getName()), (Object)MaterialAttribute.OTHER.getValue())).intValue() && (bomIdx = dateUtil.findBOM((RowData)reqData, netDemand)) >= 0) {
                    BOMStructDataTable bomTbl = this.ctx.bomDatas();
                    reqData.update(DefaultField.RequireField.__BOM_IDX__.getName(), (Object)bomIdx);
                    String bomFID = String.valueOf(bomTbl.getValue(DefaultField.BOMField.BOMID.getName(), bomIdx));
                    List bomIdxs = DataMatchUtils.findBOMChildren((IMRPEnvProvider)this.ctx, this.bomChildrenCache, (String)bomFID);
                    ArrayList bomEntrys = new ArrayList(6);
                    if (!bomIdxs.isEmpty()) {
                        HashMap repStructs = new HashMap(16);
                        dateUtil.calcDate(reqData, netDemand);
                        HashMap parentBalancePeriod = new HashMap(16);
                        HashMap parentQuota = new HashMap(16);
                        HashMap rQtyMap = new HashMap(16);
                        for (int j = 0; j < bomIdxs.size(); ++j) {
                            CPSRequireStatNode.createChildrenStruct((MRPMDependentReqNewStep)dateUtil, bomEntrys, (IMRPEnvProvider)this.ctx, (RequireRowData)reqData, rQtyMap, parentQuota, parentBalancePeriod, repStructs, (List)bomIdxs, (int)((Integer)bomIdxs.get(j)), (String)bomFID, (int)j, (boolean)false, this.existKeyPartMap);
                        }
                        cpsNode.initialize(statsCache4MFT, statsCache4BOM, new HashMap(), levelUsedSupplys, this.bomCache, this.bomChildrenCache, keyBuffer, this.existKeyPartMap);
                        cpsNode.targetKeyPart((KDCloudCPSEnv)this.ctx, netDemand, bomEntrys, reqData);
                    }
                }
                if (!MRPUtil.convert((Object)reqData.getValue(DefaultField.RequireField.__EXIST_KEYPART__.getName()), (Boolean)Boolean.FALSE).booleanValue()) {
                    int size = this.supplyTbl.getColIdx().size();
                    Object[] data = new Object[size];
                    data[((Integer)this.supplyTbl.getColIdx().get((Object)DefaultField.CommonField.__MODEL_NUMBER__.name())).intValue()] = reqData.getValue(DefaultField.CommonField.__MODEL_NUMBER__.name());
                    data[((Integer)this.supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.SUPPLYORGUNIT.getName())).intValue()] = reqData.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName());
                    data[((Integer)this.supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.DATE.getName())).intValue()] = reqData.getValue(DefaultField.RequireField.DATE.getName());
                    data[((Integer)this.supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.BILLNUMBER.getName())).intValue()] = "";
                    data[((Integer)this.supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.BILLID.getName())).intValue()] = reqData.getValue(DefaultField.RequireField.BILLID.getName());
                    data[((Integer)this.supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.BILLENTRYID.getName())).intValue()] = reqData.getValue(DefaultField.RequireField.BILLENTRYID.getName());
                    data[((Integer)this.supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.MATERIAL.getName())).intValue()] = reqData.getValue(DefaultField.RequireField.MATERIAL.getName());
                    data[((Integer)this.supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.MATERIALATTR.getName())).intValue()] = reqData.getValue(DefaultField.RequireField.MATERIALATTR.getName());
                    data[((Integer)this.supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.BILL_ENTITY.getName())).intValue()] = reqData.getValue(DefaultField.RequireField.BILL_ENTITY.getName());
                    data[((Integer)this.supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.BILLENTRYSEQ.getName())).intValue()] = reqData.getValue(DefaultField.RequireField.BILLENTRYSEQ.getName());
                    data[((Integer)this.supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.TRACKNUMBER.getName())).intValue()] = reqData.getValue(DefaultField.RequireField.TRACKNUMBER.getName());
                    data[((Integer)this.supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.CONFIGUREDCODE.getName())).intValue()] = reqData.getValue(DefaultField.RequireField.CONFIGUREDCODE.getName());
                    data[((Integer)this.supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.MATERIALFLEXPROPS.getName())).intValue()] = reqData.getValue(DefaultField.RequireField.MATERIALFLEXPROPS.getName());
                    data[((Integer)this.supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.__VIRTUAL_SUPPLY__.getName())).intValue()] = true;
                    data[((Integer)this.supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.QTY.getName())).intValue()] = netDemand;
                    data[((Integer)this.supplyTbl.getColIdx().get((Object)DefaultField.CommonField.__MODEL_NUMBER__.name())).intValue()] = ResManager.loadKDString((String)"\u9f50\u5957\u5efa\u8bae\u8ba1\u5212", (String)"CalcNetDemand_10", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]);
                    RowData supply = new RowData(this.supplyTbl.getSrcDatas(), this.supplyTbl.getColIdx(), data, Integer.valueOf(this.supplyTbl.size() - 1), ResType.SUPPLY);
                    int fillNoIndex2 = this.supplyTbl.fillNoIndex(supply);
                    CPSSupplyStatNode node = new CPSSupplyStatNode(Integer.valueOf(fillNoIndex2));
                    this.allUsedSupplys.put(fillNoIndex2, node);
                    node.setMaxQty(netDemand);
                    String auxpty = (String)MRPUtil.convert((Object)reqData.getValue(DefaultField.RequireField.MATERIALFLEXPROPS.getName()), (Object)"0");
                    String configCode = (String)MRPUtil.convert((Object)reqData.getValue(DefaultField.RequireField.CONFIGUREDCODE.getName()), (Object)"0");
                    String trackNumber = (String)MRPUtil.convert((Object)reqData.getValue(DefaultField.RequireField.TRACKNUMBER.getName()), (Object)"0");
                    String path = netDemand + "\u0001" + String.valueOf(reqData.getValue(DefaultField.RequireField.MATERIAL.getName())) + "\u0001" + auxpty + "\u0001" + configCode + "\u0001" + trackNumber + "\u0001" + fillNoIndex2 + "\u0001" + reqRowIdx;
                    node.setConsumeQty4BOM(reqRowIdx.intValue(), 0, netDemand, path, reqData);
                    node.finish();
                    reqData.update(DefaultField.RequireField.QTY.getName(), (Object)BigDecimal.ZERO);
                    Object unit = reqData.getValue(DefaultField.RequireField.BASEUNIT.getName());
                    grade = grade.add(MRPUtil.divide((IMRPEnvProvider)this.ctx, (Object)unit, (BigDecimal)requireQty.subtract(netDemand), (BigDecimal)requireQty));
                    this.lr.updateSubStepLog(2, "entrydetailmsg", (Object)String.format(ResManager.loadKDString((String)"\u5df2\u8ba1\u7b97\uff1a%1$s\uff0c\u9884\u8ba1\u5269\u4f59\uff1a%2$s\u3002", (String)"CalcNetDemand_7", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), i + 1, rows.size() - i - 1));
                    this.lr.saveStepLog(false);
                    continue;
                }
            }
            List supplys = DataMatchUtils.findSupplysUtil((boolean)false, (RowData)reqData, (IMRPEnvProvider)this.ctx);
            MRPUtil.isUseEnableOrder((IMRPEnvProvider)this.ctx, (SupplymentDataTable)this.supplyTbl, (List)supplys, (RequireRowData)reqData);
            Object strategyId = reqData.getValue(DefaultField.RequireField.PLAN_STRATEGY.getName());
            Boolean isFastEnable = (Boolean)this.ctx.getCfgValue(EnvCfgItem.ENABLE_FAST_SUPLLY_SEARCH_MODE);
            if (!isFastEnable.booleanValue()) {
                supplys = this.supplyTbl.sortByPriority(reqData.getString(DefaultField.RequireField.SUPPLYORGUNIT.getName()), supplys, strategyId == null ? null : String.valueOf(strategyId));
                supplys.sort(new DataMatchUtils.SupplySortComparator(this.ctx));
            }
            supplys = this.ctx.supplyDatas().sortSupplyByReserve(this.ctx, supplys, reqData);
            for (Integer supplyRowIdx : supplys) {
                BigDecimal targetQty;
                Boolean isVirtual = MRPUtil.convert((Object)this.supplyTbl.getValue(DefaultField.SupplyField.__VIRTUAL_SUPPLY__.getName(), supplyRowIdx.intValue()), (Boolean)Boolean.FALSE);
                if (isVirtual.booleanValue()) continue;
                this.ctx.testEnvStatus();
                CPSRequireStatNode stats = new CPSRequireStatNode(reqRowIdx.toString(), reqRowIdx.intValue(), reqData, reqRowIdx.intValue(), supplyRowIdx, 0, level);
                stats.initialize(statsCache4MFT, statsCache4BOM, new HashMap(), levelUsedSupplys, this.bomCache, this.bomChildrenCache, keyBuffer, this.existKeyPartMap);
                boolean isOnWork = MRPUtil.convert((Object)this.supplyTbl.getValue(DefaultField.SupplyField.ISONWORK.getName(), supplyRowIdx.intValue()), (Boolean)Boolean.FALSE);
                if (isOnWork && this.ctx.isYield()) {
                    BigDecimal yield = (BigDecimal)MRPUtil.convert((Object)this.supplyTbl.getValue(DefaultField.SupplyField.YIELD.getName(), supplyRowIdx.intValue()), (Object)BigDecimal.ONE);
                    netDemand = MRPUtil.calcYield((BigDecimal)yield, (Object)this.supplyTbl.getValue(DefaultField.SupplyField.BASEUNIT.getName(), supplyRowIdx.intValue()), (BigDecimal)netDemand, (IMRPEnvProvider)this.ctx, (boolean)false);
                }
                if (netDemand.subtract(targetQty = this.searchMaxCompleteQty(stats, netDemand, keyBuffer, supplyRowIdx)).compareTo(BigDecimal.ZERO) <= 0) {
                    netDemand = netDemand.subtract(targetQty);
                    reqData.update(DefaultField.RequireField.QTY.getName(), (Object)BigDecimal.ZERO);
                    break;
                }
                netDemand = netDemand.subtract(targetQty);
                if (!isOnWork || !this.ctx.isYield()) continue;
                BigDecimal yield = (BigDecimal)MRPUtil.convert((Object)this.supplyTbl.getValue(DefaultField.SupplyField.YIELD.getName(), supplyRowIdx.intValue()), (Object)BigDecimal.ONE);
                netDemand = MRPUtil.calcYield((BigDecimal)yield, (Object)this.supplyTbl.getValue(DefaultField.SupplyField.BASEUNIT.getName(), supplyRowIdx.intValue()), (BigDecimal)netDemand, (IMRPEnvProvider)this.ctx, (boolean)true);
            }
            reqData.update(DefaultField.RequireField.QTY.getName(), (Object)netDemand);
            if (!isLet && netDemand.compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal targetQty;
                CPSRequireStatNode stats = new CPSRequireStatNode(reqRowIdx.toString(), reqRowIdx.intValue(), reqData, reqRowIdx.intValue(), Integer.valueOf(-1), 0, level);
                stats.initialize(statsCache4MFT, statsCache4BOM, new HashMap(), levelUsedSupplys, this.bomCache, this.bomChildrenCache, keyBuffer, this.existKeyPartMap);
                if (this.ctx.isYield()) {
                    Object myield = reqData.getValue(DefaultField.RequireField.YIELD.getName());
                    BigDecimal yield = MRPUtil.toBigDecimal((Object)myield);
                    netDemand = MRPUtil.calcYield((BigDecimal)yield, (Object)reqData.getValue(DefaultField.RequireField.BASEUNIT.getName()), (BigDecimal)netDemand, (IMRPEnvProvider)this.ctx, (boolean)false);
                }
                if ((targetQty = this.searchMaxCompleteQty(stats, netDemand, keyBuffer, -1)).compareTo(BigDecimal.ZERO) < 0) {
                    targetQty = BigDecimal.ZERO;
                }
                netDemand = netDemand.subtract(targetQty);
                if (targetQty.compareTo(BigDecimal.ZERO) > 0) {
                    this.addIndependentReqSupply(reqData, targetQty, details);
                }
                if (this.ctx.isYield()) {
                    Object myield = reqData.getValue(DefaultField.RequireField.YIELD.getName());
                    BigDecimal yield = MRPUtil.toBigDecimal((Object)myield);
                    netDemand = MRPUtil.calcYield((BigDecimal)yield, (Object)reqData.getValue(DefaultField.RequireField.BASEUNIT.getName()), (BigDecimal)netDemand, (IMRPEnvProvider)this.ctx, (boolean)true);
                }
                reqData.update(DefaultField.RequireField.QTY.getName(), (Object)netDemand);
                if (!isLet) {
                    this.isLet(keyBuffer, reqRowIdx);
                }
            }
            Object unit = reqData.getValue(DefaultField.RequireField.BASEUNIT.getName());
            grade = grade.add(MRPUtil.divide((IMRPEnvProvider)this.ctx, (Object)unit, (BigDecimal)requireQty.subtract(netDemand), (BigDecimal)requireQty));
            this.lr.updateSubStepLog(2, "entrydetailmsg", (Object)String.format(ResManager.loadKDString((String)"\u5df2\u8ba1\u7b97\uff1a%1$s\uff0c\u9884\u8ba1\u5269\u4f59\uff1a%2$s\u3002", (String)"CalcNetDemand_7", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), i + 1, rows.size() - i - 1));
            this.lr.saveStepLog(false);
        }
        return grade;
    }

    private BigDecimal calcVirtualRequire(int level, Map<Integer, CPSSupplyStatNode> levelUsedSupplys, List<Map<String, Object>> details, List<Integer> rows, StringBuilder keyBuffer) {
        BigDecimal grade = BigDecimal.ZERO;
        HashMap statsCache4MFT = new HashMap();
        HashMap statsCache4BOM = new HashMap();
        boolean isLet = ((KDCloudCPSEnv)this.ctx).isLet();
        CPSRequireStatNode cpsNode = new CPSRequireStatNode("", -1, null, -1, Integer.valueOf(-1), 0, 1);
        MRPMDependentReqNewStep dateUtil = new MRPMDependentReqNewStep(this.ctx);
        cpsNode.setDateUtil(dateUtil);
        for (int i = 0; i < rows.size(); ++i) {
            boolean isCalc;
            Integer reqRowIdx = rows.get(i);
            this.ctx.testEnvStatus();
            RequireRowData reqData = this.requireTbl.fetchRow(reqRowIdx.intValue());
            if (reqData.getValue(DefaultField.RequireField.DATE.getName()) == null || this.ctx.getPlanDate().getTime() > reqData.getLong(DefaultField.RequireField.DATE.getName())) {
                reqData.update(DefaultField.RequireField.DATE.getName(), (Object)this.ctx.getPlanDate().getTime());
            }
            reqData.update(DefaultField.RequireField.__START_DATE__.getName(), reqData.getValue(DefaultField.RequireField.DATE.getName()));
            reqData.update(DefaultField.RequireField.__ORDER_DATE__.getName(), reqData.getValue(DefaultField.RequireField.DATE.getName()));
            BigDecimal netDemand = (BigDecimal)MRPUtil.convert((Object)reqData.getValue(DefaultField.RequireField.QTY.getName()), (Object)BigDecimal.ZERO);
            if (!this.isCalculatableData(reqData)) continue;
            netDemand = (BigDecimal)MRPUtil.convert((Object)reqData.getValue(DefaultField.RequireField.QTY.getName()), (Object)BigDecimal.ZERO);
            boolean bl = isCalc = netDemand.compareTo(BigDecimal.ZERO) <= 0;
            if (isCalc) continue;
            BigDecimal requireQty = netDemand;
            Integer supplyIdx = MRPUtil.findSupOrReqIndex((IMRPEnvProvider)this.ctx, (boolean)true, (Integer)reqData.getRowIdx());
            ArrayList tmpBomChildren = new ArrayList();
            if (((KDCloudCPSEnv)this.ctx).isKeyPart() && !MRPUtil.convert((Object)reqData.getValue(DefaultField.RequireField.__EXIST_KEYPART__.getName()), (Boolean)Boolean.FALSE).booleanValue()) {
                Long billEntryId = (Long)MRPUtil.convert((Object)this.supplyTbl.getValue(DefaultField.SupplyField.BILLENTRYID.getName(), supplyIdx.intValue()), (Object)0L);
                List subRows = this.requireTbl.getCol(DefaultField.RequireField.SUPPLYBILLID.getName()).get((Object)billEntryId);
                if (subRows.isEmpty()) {
                    int bomIdx;
                    if (MaterialAttribute.PURCHASEDPART.getValue() != ((Integer)MRPUtil.convert((Object)reqData.get(DefaultField.RequireField.MATERIALATTR.getName()), (Object)MaterialAttribute.OTHER.getValue())).intValue() && (bomIdx = dateUtil.findBOM((RowData)reqData, netDemand)) >= 0) {
                        BOMStructDataTable bomTbl = this.ctx.bomDatas();
                        reqData.update(DefaultField.RequireField.__BOM_IDX__.getName(), (Object)bomIdx);
                        String bomFID = String.valueOf(bomTbl.getValue(DefaultField.BOMField.BOMID.getName(), bomIdx));
                        List bomIdxs = DataMatchUtils.findBOMChildren((IMRPEnvProvider)this.ctx, this.bomChildrenCache, (String)bomFID);
                        if (!bomIdxs.isEmpty()) {
                            HashMap repStructs = new HashMap(16);
                            dateUtil.calcDate(reqData, netDemand);
                            HashMap parentBalancePeriod = new HashMap(16);
                            HashMap parentQuota = new HashMap(16);
                            HashMap rQtyMap = new HashMap(16);
                            for (int j = 0; j < bomIdxs.size(); ++j) {
                                CPSRequireStatNode.createChildrenStruct((MRPMDependentReqNewStep)dateUtil, tmpBomChildren, (IMRPEnvProvider)this.ctx, (RequireRowData)reqData, rQtyMap, parentQuota, parentBalancePeriod, repStructs, (List)bomIdxs, (int)((Integer)bomIdxs.get(j)), (String)bomFID, (int)j, (boolean)false, this.existKeyPartMap);
                            }
                        }
                    }
                } else {
                    tmpBomChildren.addAll(this.requireTbl.fetchRow((Collection)subRows));
                }
                cpsNode.initialize(statsCache4MFT, statsCache4BOM, new HashMap(), levelUsedSupplys, this.bomCache, this.bomChildrenCache, keyBuffer, this.existKeyPartMap);
                cpsNode.targetKeyPart((KDCloudCPSEnv)this.ctx, requireQty, tmpBomChildren, reqData);
                if (!MRPUtil.convert((Object)reqData.getValue(DefaultField.RequireField.__EXIST_KEYPART__.getName()), (Boolean)Boolean.FALSE).booleanValue()) {
                    CPSSupplyStatNode node = this.allUsedSupplys.get(supplyIdx);
                    if (node == null) {
                        node = new CPSSupplyStatNode(supplyIdx);
                        node.setMaxQty(netDemand);
                        this.allUsedSupplys.put(supplyIdx, node);
                    }
                    String auxpty = (String)MRPUtil.convert((Object)reqData.getValue(DefaultField.RequireField.MATERIALFLEXPROPS.getName()), (Object)"0");
                    String configCode = (String)MRPUtil.convert((Object)reqData.getValue(DefaultField.RequireField.CONFIGUREDCODE.getName()), (Object)"0");
                    String trackNumber = (String)MRPUtil.convert((Object)reqData.getValue(DefaultField.RequireField.TRACKNUMBER.getName()), (Object)"0");
                    String path = netDemand + "\u0001" + String.valueOf(reqData.getValue(DefaultField.RequireField.MATERIAL.getName())) + "\u0001" + auxpty + "\u0001" + configCode + "\u0001" + trackNumber + "\u0001" + supplyIdx + "\u0001" + reqRowIdx;
                    node.setConsumeQty4BOM(reqRowIdx.intValue(), 0, netDemand, path, reqData);
                    node.finish();
                    reqData.update(DefaultField.RequireField.QTY.getName(), (Object)BigDecimal.ZERO);
                    Object unit = reqData.getValue(DefaultField.RequireField.BASEUNIT.getName());
                    grade = grade.add(MRPUtil.divide((IMRPEnvProvider)this.ctx, (Object)unit, (BigDecimal)requireQty.subtract(netDemand), (BigDecimal)requireQty));
                    this.lr.updateSubStepLog(2, "entrydetailmsg", (Object)String.format(ResManager.loadKDString((String)"\u5df2\u8ba1\u7b97\uff1a%1$s\uff0c\u9884\u8ba1\u5269\u4f59\uff1a%2$s\u3002", (String)"CalcNetDemand_7", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), i + 1, rows.size() - i - 1));
                    this.lr.saveStepLog(false);
                    continue;
                }
            }
            this.ctx.testEnvStatus();
            CPSRequireStatNode stats = new CPSRequireStatNode(reqRowIdx.toString(), reqRowIdx.intValue(), reqData, reqRowIdx.intValue(), supplyIdx, 0, level);
            stats.initialize(statsCache4MFT, statsCache4BOM, new HashMap(), levelUsedSupplys, this.bomCache, this.bomChildrenCache, keyBuffer, this.existKeyPartMap);
            if (this.ctx.isYield()) {
                BigDecimal yield = (BigDecimal)MRPUtil.convert((Object)this.supplyTbl.getValue(DefaultField.SupplyField.YIELD.getName(), supplyIdx.intValue()), (Object)BigDecimal.ONE);
                netDemand = MRPUtil.calcYield((BigDecimal)yield, (Object)this.supplyTbl.getValue(DefaultField.SupplyField.BASEUNIT.getName(), supplyIdx.intValue()), (BigDecimal)netDemand, (IMRPEnvProvider)this.ctx, (boolean)false);
            }
            BigDecimal targetQty = this.searchMaxCompleteQty(stats, netDemand, keyBuffer, supplyIdx);
            if (this.ctx.isYield()) {
                BigDecimal yield = (BigDecimal)MRPUtil.convert((Object)this.supplyTbl.getValue(DefaultField.SupplyField.YIELD.getName(), supplyIdx.intValue()), (Object)BigDecimal.ONE);
                netDemand = MRPUtil.calcYield((BigDecimal)yield, (Object)this.supplyTbl.getValue(DefaultField.SupplyField.BASEUNIT.getName(), supplyIdx.intValue()), (BigDecimal)netDemand, (IMRPEnvProvider)this.ctx, (boolean)true);
            }
            if ((netDemand = netDemand.subtract(targetQty)).compareTo(BigDecimal.ZERO) <= 0) {
                reqData.update(DefaultField.RequireField.QTY.getName(), (Object)BigDecimal.ZERO);
                continue;
            }
            Object unit = reqData.getValue(DefaultField.RequireField.BASEUNIT.getName());
            grade = grade.add(MRPUtil.divide((IMRPEnvProvider)this.ctx, (Object)unit, (BigDecimal)requireQty.subtract(netDemand), (BigDecimal)requireQty));
            reqData.update(DefaultField.RequireField.QTY.getName(), (Object)netDemand);
            if (!isLet) {
                this.isLet(keyBuffer, reqRowIdx);
            }
            this.lr.updateSubStepLog(3, "entrydetailmsg", (Object)String.format(ResManager.loadKDString((String)"\u5df2\u8ba1\u7b97\uff1a%1$s\uff0c\u9884\u8ba1\u5269\u4f59\uff1a%2$s\u3002", (String)"CalcNetDemand_7", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), i + 1, rows.size() - i - 1));
            this.lr.saveStepLog(false);
        }
        return grade;
    }

    private void isLet(StringBuilder keyBuffer, Integer reqRowIdx) {
        ArrayList<Map<String, Object>> shortList = new ArrayList<Map<String, Object>>();
        DynamicObject shortageObj2 = this.getShortageObj();
        CalcShortage.calcRequireShortage((KDCloudCPSEnv)this.ctx, shortList, reqRowIdx, shortageObj2, this.existKeyPartMap, this.reserveList, this.allUsedSupplys);
        this.shortageDetails.addAll(shortList);
        if (this.shortageDetails.size() > CPSUtil.getDetailSaveBatch((IMRPEnvProvider)this.ctx)) {
            this.shortageCount += CPSUtil.batchExecuteSql(this.shortageDetails, (Long)shortageObj2.getLong("id"), (String)"mrp_cps_shortage.entryentity", (boolean)false);
        }
    }

    private BigDecimal calcRelatedRequire(int level, Map<Integer, CPSSupplyStatNode> levelUsedSupplys, List<Map<String, Object>> details, List<Integer> rows, StringBuilder keyBuffer) {
        BigDecimal grade = BigDecimal.ZERO;
        HashMap statsCache4MFT = new HashMap();
        HashMap statsCache4BOM = new HashMap();
        boolean isLet = ((KDCloudCPSEnv)this.ctx).isLet();
        for (int i = 0; i < rows.size(); ++i) {
            BigDecimal targetQty;
            boolean isCalc;
            Integer reqRowIdx = rows.get(i);
            this.ctx.testEnvStatus();
            RequireRowData reqData = this.requireTbl.fetchRow(reqRowIdx.intValue());
            if (!this.isCalculatableData(reqData)) continue;
            BigDecimal netDemand = (BigDecimal)MRPUtil.convert((Object)reqData.getValue(DefaultField.RequireField.QTY.getName()), (Object)BigDecimal.ZERO);
            boolean bl = isCalc = netDemand.compareTo(BigDecimal.ZERO) <= 0;
            if (isCalc) continue;
            BigDecimal requireQty = netDemand;
            CPSRequireStatNode stats = new CPSRequireStatNode(reqRowIdx.toString(), reqRowIdx.intValue(), reqData, reqRowIdx.intValue(), Integer.valueOf(-1), 0, level);
            stats.initialize(statsCache4MFT, statsCache4BOM, new HashMap(), levelUsedSupplys, this.bomCache, this.bomChildrenCache, keyBuffer, this.existKeyPartMap);
            if (this.ctx.isYield()) {
                Object myield = reqData.getValue(DefaultField.RequireField.YIELD.getName());
                BigDecimal yield = MRPUtil.toBigDecimal((Object)myield);
                netDemand = MRPUtil.calcYield((BigDecimal)yield, (Object)reqData.getValue(DefaultField.RequireField.BASEUNIT.getName()), (BigDecimal)netDemand, (IMRPEnvProvider)this.ctx, (boolean)false);
            }
            if ((targetQty = this.searchMaxCompleteQty(stats, netDemand, keyBuffer, -1)).compareTo(BigDecimal.ZERO) < 0) {
                targetQty = BigDecimal.ZERO;
            }
            netDemand = netDemand.subtract(targetQty);
            if (targetQty.compareTo(BigDecimal.ZERO) > 0) {
                this.addIndependentReqSupply(reqData, targetQty, details);
            }
            if (this.ctx.isYield()) {
                Object myield = reqData.getValue(DefaultField.RequireField.YIELD.getName());
                BigDecimal yield = MRPUtil.toBigDecimal((Object)myield);
                netDemand = MRPUtil.calcYield((BigDecimal)yield, (Object)reqData.getValue(DefaultField.RequireField.BASEUNIT.getName()), (BigDecimal)netDemand, (IMRPEnvProvider)this.ctx, (boolean)true);
            }
            Object unit = reqData.getValue(DefaultField.RequireField.BASEUNIT.getName());
            grade = grade.add(MRPUtil.divide((IMRPEnvProvider)this.ctx, (Object)unit, (BigDecimal)requireQty.subtract(netDemand), (BigDecimal)requireQty));
            reqData.update(DefaultField.RequireField.QTY.getName(), (Object)netDemand);
            if (!isLet) {
                this.isLet(keyBuffer, reqRowIdx);
            }
            this.lr.updateSubStepLog(4, "entrydetailmsg", (Object)String.format(ResManager.loadKDString((String)"\u5df2\u8ba1\u7b97\uff1a%1$s\uff0c\u9884\u8ba1\u5269\u4f59\uff1a%2$s\u3002", (String)"CalcNetDemand_7", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), i + 1, rows.size() - i - 1));
            this.lr.saveStepLog(false);
        }
        return grade;
    }

    private Map<String, Object> addIndependentReqSupply(RequireRowData reqData, BigDecimal targetQty, List<Map<String, Object>> details) {
        HashMap<String, Object> row = new HashMap<String, Object>();
        MRPDataBalanceResolver.putRequire((IMRPEnvProvider)this.ctx, row, (RequireRowData)reqData, (boolean)false, (int)0);
        row.put("demandqty", targetQty);
        row.put("supplyqty", targetQty);
        row.put("topmaterial", reqData.getValue(DefaultField.RequireField.MATERIAL.getName()));
        row.put("origindemanddate", reqData.getValue(DefaultField.RequireField.CPSDATE.getName()));
        int mAttr = (Integer)MRPUtil.convert((Object)reqData.getValue(DefaultField.RequireField.MATERIALATTR.getName()), (Object)MaterialAttribute.OTHER.getValue());
        String bt = this.ctx.getRelatedSupplyBillType(mAttr);
        row.put("supplybilltype", bt == null ? ResManager.loadKDString((String)"\u9f50\u5957\u5efa\u8bae\u8ba1\u5212", (String)"CalcNetDemand_10", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]) : bt);
        row.put("supmaterial", reqData.getValue(DefaultField.RequireField.MATERIAL.getName()));
        row.put("supplybillf7", "mrp_planorder");
        row.put("supmaterialattr", reqData.getValue(DefaultField.RequireField.MATERIALATTR.getName()));
        row.put("supconfigcode", reqData.getValue(DefaultField.RequireField.CONFIGUREDCODE.getName()));
        row.put("suptracknumber", reqData.getValue(DefaultField.RequireField.TRACKNUMBER.getName()));
        row.put("supplyplanscope", row.get("demandplanscope"));
        row.put("existkeypart", reqData.getValue(DefaultField.RequireField.__EXIST_KEYPART__.getName()));
        row.put("replaceplan", reqData.getValue(DefaultField.RequireField.REPLACEPLAN.getName()));
        row.put("replacepriority", reqData.getValue(DefaultField.RequireField.REPLACEPRIORITY.getName()));
        row.put("ismianreplace", reqData.getValue(DefaultField.RequireField.ISREPLACEPLANMM.getName()));
        row.put("isreplace", reqData.getValue(DefaultField.RequireField.ISREPLACE.getName()));
        row.put("editreason", "PLAN");
        row.put("supplydate", this.ctx.getPlanDate().getTime());
        row.put("editdate", this.ctx.getPlanDate().getTime());
        this.setFullSetStatus("", row);
        if ("A".equals(row.get("fullsetstatus"))) {
            row.put("ishandle", Boolean.TRUE);
        }
        details.add(row);
        return row;
    }

    private void setFullSetStatus(String rowKey, HashMap<String, Object> row) {
        if (this.fullsetTypes.containsKey(rowKey)) {
            if (this.fullsetTypes.get(rowKey).booleanValue()) {
                row.put("fullsetstatus", "B");
            } else {
                row.put("fullsetstatus", "A");
                row.put("ishandle", Boolean.TRUE);
            }
            row.put("editdate", this.cpsDates.get(rowKey));
        } else {
            if (Boolean.parseBoolean(row.get("ishandle").toString())) {
                row.put("fullsetstatus", "A");
            } else {
                row.put("fullsetstatus", "B");
            }
            row.put("editdate", this.ctx.getPlanDate().getTime());
        }
    }

    private BigDecimal searchMaxCompleteQty(CPSRequireStatNode stats, BigDecimal max, StringBuilder keyBuffer, Integer supplyIdx) {
        Object rowKey;
        BigDecimal targetQty = max;
        BigDecimal cycleTargetQty = BigDecimal.ZERO;
        BigDecimal min = BigDecimal.ZERO;
        int cycleCnt = (Integer)this.ctx.getCfgValue(EnvCfgItem.CPS_MAX_QTY_SEARCH_CYCLE);
        try {
            do {
                int cmp;
                this.ctx.testEnvStatus();
                if (targetQty.compareTo(BigDecimal.ZERO) == 0) {
                    BigDecimal bigDecimal = BigDecimal.ZERO;
                    return bigDecimal;
                }
                cycleTargetQty = stats.calcUsageStats((KDCloudCPSEnv)this.ctx, targetQty, cycleTargetQty, null, supplyIdx);
                if (max.subtract(min).compareTo(BigDecimal.ONE) <= 0) {
                    cmp = cycleTargetQty.compareTo(targetQty);
                    if (cmp < 0) {
                        stats.doRollback();
                        cycleTargetQty = stats.calcUsageStats((KDCloudCPSEnv)this.ctx, min, min, null, supplyIdx);
                    }
                    rowKey = cycleTargetQty;
                    return rowKey;
                }
                cmp = cycleTargetQty.compareTo(min);
                if (cmp > 0) {
                    min = cycleTargetQty;
                } else if (cmp <= 0) {
                    max = targetQty;
                }
                BigDecimal add = min.add(max);
                targetQty = new BigDecimal(add.divide(TWO, 10, 4).intValue());
                cmp = targetQty.compareTo(min);
                if (cmp < 0) {
                    targetQty = min;
                }
                stats.doRollback();
                if (stats.isConflict()) continue;
                max = min;
                targetQty = cycleTargetQty;
            } while (--cycleCnt > 0);
            cycleCnt = (Integer)this.ctx.getCfgValue(EnvCfgItem.CPS_MAX_QTY_SEARCH_CYCLE);
            throw new RuntimeException(String.format("search cnt overflow error. max-cnt: %s, stats: %s", cycleCnt, stats.toString()));
        }
        finally {
            stats.finish(this.ctx, cycleTargetQty);
            rowKey = stats.getTopRowIdx() + "\u0001" + stats.getSupplyRowIdx();
            this.cpsDates.put((String)rowKey, stats.getCPSDate());
            this.fullsetTypes.put((String)rowKey, stats.isWayFullSet());
        }
    }

    protected boolean isCalculatableData(RequireRowData reqData) {
        String mId = String.valueOf(reqData.getValue(DefaultField.RequireField.MATERIAL.getName()));
        if (this.calculatableIds == null || this.calculatableIds.isEmpty()) {
            return true;
        }
        return this.calculatableIds.contains(mId);
    }

    private void addLevelMapping(String usagePath, List<Map<String, Object>> details, Set<String> isAddSet) {
        String key;
        String[] parts = usagePath.split("\u0001");
        Integer reqRowIdx = Integer.parseInt(parts[0]);
        Integer llc = Integer.parseInt(parts[1]);
        RequireRowData rData = this.requireTbl.fetchRow(reqRowIdx.intValue());
        for (int i = parts.length - 1; i > 8 && !isAddSet.contains(key = parts[i - 12] + "\u0001" + parts[i - 5] + "\u0001" + parts[i - 6] + "\u0001" + reqRowIdx + "\u0001" + parts[i - 4] + "\u0001" + parts[i - 3] + "\u0001" + parts[i - 2] + parts[i]); i -= 7) {
            isAddSet.add(key);
            Integer n = llc;
            Integer n2 = llc = Integer.valueOf(llc - 1);
            HashMap<String, Object> row = new HashMap<String, Object>();
            MRPDataBalanceResolver.putRequire((IMRPEnvProvider)this.ctx, row, (RequireRowData)rData, (boolean)false, (int)llc);
            row.put("topmaterial", rData.get(DefaultField.RequireField.MATERIAL.getName()));
            row.put("supmaterial", Long.valueOf(parts[i - 5]));
            row.put("demandqty", new BigDecimal(parts[i - 6]));
            row.put("supplyqty", new BigDecimal(parts[i - 6]));
            row.put("supplydate", this.ctx.getPlanDate().getTime());
            row.put("material", Long.valueOf(parts[i - 12]));
            row.put("origindemanddate", rData.getValue(DefaultField.RequireField.CPSDATE.getName()));
            row.put("supmaterialattr", rData.getValue(DefaultField.RequireField.MATERIALATTR.getName()));
            row.put("supplyauxpty", Long.valueOf(parts[i - 4]));
            row.put("supconfigcode", Long.valueOf(parts[i - 3]));
            row.put("suptracknumber", Long.valueOf(parts[i - 2]));
            row.put("existkeypart", rData.getValue(DefaultField.RequireField.__EXIST_KEYPART__.getName()));
            row.put("fullsetstatus", "B");
            row.put("supplybilltype", ResManager.loadKDString((String)"\u9f50\u5957\u5efa\u8bae\u8ba1\u5212", (String)"CalcNetDemand_10", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]));
            row.put("editdate", this.ctx.getPlanDate().getTime());
            row.put("editreason", "PLAN");
            details.add(row);
        }
    }

    private void addMapping(Integer reqRowIdx, Map<String, BigDecimal> levels, RowData supply, Set<String> usagePaths, List<Map<String, Object>> details, IMappingDataResolver resolver) {
        RequireRowData rData = this.requireTbl.fetchRow(reqRowIdx.intValue());
        for (Map.Entry<String, BigDecimal> entry : levels.entrySet()) {
            BigDecimal sQty = supply.getBigDecimal(DefaultField.SupplyField.QTY.getName());
            BigDecimal usedQty = entry.getValue();
            HashMap<String, Object> row = new HashMap<String, Object>();
            MRPDataBalanceResolver.putRequire((IMRPEnvProvider)this.ctx, row, (RequireRowData)rData, (boolean)false, (int)0);
            String levelKey = entry.getKey();
            String[] parts = levelKey.split("\u0001");
            usagePaths.add(reqRowIdx + "\u0001" + levelKey);
            MRPDataBalanceResolver.putSupply((IMRPEnvProvider)this.ctx, row, (RowData)supply, (int)Integer.parseInt(parts[0]));
            row.put("topmaterial", rData.get(DefaultField.RequireField.MATERIAL.getName()));
            row.put("material", Long.valueOf(parts[parts.length - 6]));
            row.put("origindemanddate", rData.getValue(DefaultField.RequireField.CPSDATE.getName()));
            row.put("supmaterialattr", supply.getValue(DefaultField.SupplyField.MATERIALATTR.getName()));
            row.put("supconfigcode", supply.getValue(DefaultField.SupplyField.CONFIGUREDCODE.getName()));
            row.put("suptracknumber", supply.getValue(DefaultField.SupplyField.TRACKNUMBER.getName()));
            row.put("demandplanscope", row.get("supplyplanscope"));
            row.put("demandqty", usedQty);
            row.put("supplyqty", usedQty);
            row.put("yieldratio", BigDecimal.ZERO);
            row.put("isvirtual", supply.getValue(DefaultField.SupplyField.__VIRTUAL_SUPPLY__.getName()));
            if (resolver == null || !resolver.resolve(levelKey, row)) continue;
            details.add(row);
            supply.update(DefaultField.SupplyField.QTY.getName(), (Object)sQty.subtract(usedQty));
        }
    }

    private void restoreDatas(Set<String> mIds, Map<String, Integer> materials) {
        for (String mId : mIds) {
            Integer rc = materials.get(mId);
            if (rc == null || rc == 0) continue;
            this.restoreImpl(mId, true);
            this.restoreImpl(mId, false);
        }
    }

    private void restoreImpl(String mId, boolean isRequire) {
        String prefix = isRequire ? "require-" : "supply-";
        Map map = MRPCacheManager.getInst().getSubDataMap((CalEnv)this.ctx, prefix + mId);
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                String[] splits = MRPRuntimeConsts.splitDataKey((String)((String)entry.getKey()));
                List list = JSON.parseArray((String)((String)entry.getValue()), Object[].class);
                this.ctx.restoreTableDatas(splits[0], splits[1], mId, list, isRequire);
            }
        }
    }

    protected void executeRequirePriorityStep() {
        PriorityLevelCalcMode plcm = this.ctx.getPriorityLevelCalcMode();
        if (this.ctx.requireDatas().size() == 0) {
            return;
        }
        if (PriorityLevelCalcMode.RECALC == plcm) {
            new MRPMReuqirePriorityLevelCalcStep(this.ctx).execute();
        } else if (PriorityLevelCalcMode.INHERIT == plcm) {
            new MRPMReuqirePriorityLevelCalcStep(this.ctx, true).execute();
        } else {
            throw new KDBizException(String.format("unknown priority calc mode: %s", plcm));
        }
    }

    public String getStepDesc(Locale locale) {
        return ResManager.loadKDString((String)"\u9f50\u5957\u660e\u7ec6\u8ba1\u7b97", (String)"CalcNetDemand_9", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]);
    }

    private DynamicObject getShortageObj() {
        if (this.shortageObj == null) {
            PlanModel planModel = (PlanModel)this.ctx.getService(PlanModel.class);
            this.shortageObj = BusinessDataServiceHelper.newDynamicObject((String)"mrp_cps_shortage");
            this.shortageObj.set("caculatelog", (Object)this.ctx.getRunLogNumber());
            this.shortageObj.set("mrpplan", (Object)planModel.getPlanId());
            this.shortageObj.set("createtime", (Object)System.currentTimeMillis());
            this.shortageObj.set("runtype", (Object)this.ctx.getRunLog().getString("runtype"));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.shortageObj});
        }
        return this.shortageObj;
    }

    private void batchLoadInventory() {
        CacheDatas cacheDatas = (CacheDatas)this.ctx.getService(CacheDatas.class);
        HashSet<Object> set = new HashSet<Object>();
        for (Object[] next : this.supplyTbl.getSrcDatas().getDatas()) {
            Object isInv = next[(Integer)this.supplyTbl.getColIdx().get(DefaultField.SupplyField.ISSTORAGEDATA.getName())];
            if (!MRPUtil.convert((Object)isInv, (Boolean)Boolean.FALSE).booleanValue()) continue;
            set.add(next[(Integer)this.supplyTbl.getColIdx().get(DefaultField.SupplyField.BILLID.getName())]);
        }
        if (!set.isEmpty()) {
            cacheDatas.batchRelodDataPutCache("im_inv_realbalance", set, null);
        }
        set.clear();
        for (Object[] next : this.requireTbl.getSrcDatas().getDatas()) {
            Long warehouse = (Long)MRPUtil.convert((Object)next[(Integer)this.requireTbl.getColIdx().get(DefaultField.RequireField.WAREHOUSE.getName())], (Object)0L);
            set.add(warehouse);
        }
        if (!set.isEmpty()) {
            cacheDatas.batchQueryOrgByWarehouse(set);
        }
    }

    private void releaseReserve() {
        PlanModel planModel = (PlanModel)this.ctx.getService(PlanModel.class);
        boolean isReserve = planModel.isReserve();
        if (isReserve) {
            boolean isSelectBillPlan;
            HashSet enableMaterials = new HashSet(this.ctx.getEnableMaterialIds());
            String json = MRPCacheManager.getInst().getData((CalEnv)this.ctx, MRPRuntimeConsts.getSelectBillSizeKey((String)this.ctx.getMRPContextId()));
            boolean bl = isSelectBillPlan = json != null && Integer.parseInt(json) > 0;
            if (isSelectBillPlan) {
                this.releaseSelectBills(planModel.getReleaseMode());
            } else {
                ReserveUtil.releaseReserveRecordByMaterials((IMRPEnvProvider)this.ctx, enableMaterials, (String)planModel.getReleaseMode(), (String)"CPS");
            }
            Map rowDataMap = ReserveUtil.getReserveRecordByMaterials((IMRPEnvProvider)this.ctx, enableMaterials);
            Map reserveColIndex = ReserveUtil.getReserveColIndex();
            for (Map.Entry entry : rowDataMap.entrySet()) {
                String cacheKey = MRPRuntimeConsts.getReserveRecordSplitKey((String)this.ctx.getMRPContextId(), (String)((String)entry.getKey()));
                MRPCacheManager.getInst().putSubData((CalEnv)this.ctx, "reserve_record", cacheKey, JSON.toJSONString(entry.getValue(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
                for (Object[] obj : (List)entry.getValue()) {
                    Integer requireIdIdx = (Integer)reserveColIndex.get("bill_id");
                    Integer requireEntryIdIdx = (Integer)reserveColIndex.get("billentry_id");
                    Integer supplyIdIdx = (Integer)reserveColIndex.get("bal_id");
                    Integer supplyEntryIdIdx = (Integer)reserveColIndex.get("bal_entryid");
                    Integer qtyIdx = (Integer)reserveColIndex.get("base_qty");
                    String key = String.format("%s\u0001%s\u0001%s\u0001%s", obj[requireIdIdx], obj[requireEntryIdIdx], obj[supplyIdIdx], obj[supplyEntryIdIdx]);
                    this.reserveMap.put(key, (BigDecimal)obj[qtyIdx]);
                }
            }
            CPSUtil.refreshReserveMapping((KDCloudCPSEnv)((KDCloudCPSEnv)this.ctx), (RequirementDataTable)this.requireTbl, (SupplymentDataTable)this.supplyTbl);
        }
    }

    private void releaseSelectBills(String releaseMode) {
        Iterator iter;
        ColumnDatas plCol;
        PriorityLevelApplyType plat = this.ctx.getPriorityLevelApplyType();
        RequirementDataTable requireTbl = this.ctx.requireDatas();
        if (PriorityLevelApplyType.DYNAMIC == plat) {
            plCol = requireTbl.getCol(DefaultField.RequireField.__PRIORITY_LEVEL__.name());
            iter = plCol.descendingIterator();
        } else {
            plCol = requireTbl.getCol(DefaultField.RequireField.DATE.getName());
            iter = plCol.ascendingIterator();
        }
        if (this.ctx.getCustomParams("cps_begin") != null && this.ctx.getCustomParams("cps_end") != null) {
            this.beginDate = Long.valueOf(this.ctx.getCustomParams("cps_begin"));
            this.endDate = Long.valueOf(this.ctx.getCustomParams("cps_end"));
        }
        Map jsonStr = MRPCacheManager.getInst().getSubDataMap((CalEnv)this.ctx, "selectbills");
        HashSet<String> ids = new HashSet<String>(jsonStr.size());
        for (Map.Entry x : jsonStr.entrySet()) {
            List list = JSON.parseArray((String)((String)x.getValue()), Object[].class);
            for (Object[] obj : list) {
                Long billId = (Long)MRPUtil.convert((Object)obj[0], (Object)0L);
                Long billEntryId = (Long)MRPUtil.convert((Object)obj[1], (Object)0L);
                ids.add(billId + "\u0001" + billEntryId);
            }
        }
        HashSet<Long> billIds = new HashSet<Long>(16);
        while (iter.hasNext()) {
            Comparable val = (Comparable)iter.next();
            List rows = plCol.get((Object)val);
            for (Integer idx : rows) {
                boolean isCalc;
                RequireRowData reqData = requireTbl.fetchRow(idx.intValue());
                String id = reqData.get(DefaultField.RequireField.BILLID.getName()) + "\u0001" + reqData.get(DefaultField.RequireField.BILLENTRYID.getName());
                BigDecimal netDemand = (BigDecimal)MRPUtil.convert((Object)reqData.getValue(DefaultField.RequireField.QTY.getName()), (Object)BigDecimal.ZERO);
                Object supplyId = reqData.getValue(DefaultField.RequireField.SUPPLYBILLID.getName());
                boolean bl = isCalc = netDemand.compareTo(BigDecimal.ZERO) > 0;
                if (this.beginDate != null && this.endDate != null) {
                    Long requireDate = 0L;
                    requireDate = reqData.getValue(DefaultField.RequireField.CPSDATE.getName()) != null ? (Long)MRPUtil.convert((Object)reqData.getValue(DefaultField.RequireField.CPSDATE.getName()), (Object)0L) : (Long)MRPUtil.convert((Object)reqData.getValue(DefaultField.RequireField.DATE.getName()), (Object)0L);
                    if (this.beginDate.compareTo(requireDate) > 0 || this.endDate.compareTo(requireDate) < 0) continue;
                }
                Boolean isOnWork = MRPUtil.convert((Object)reqData.getValue(DefaultField.RequireField.__ISONWORK__.getName()), (Boolean)Boolean.FALSE);
                if (supplyId == null && isCalc && ids.contains(id) && !isOnWork.booleanValue()) {
                    billIds.add(reqData.getLong(DefaultField.RequireField.BILLID.getName()));
                    continue;
                }
                if (!MRPUtil.convert((Object)reqData.getValue(DefaultField.RequireField.__IS_CALC_REQUIRE__.getName()), (Boolean)Boolean.FALSE).booleanValue()) continue;
                Long billEntryId = (Long)MRPUtil.convert((Object)reqData.get(DefaultField.RequireField.BILLENTRYID.getName()), (Object)0L);
                List subRows = requireTbl.getCol(DefaultField.RequireField.SUPPLYBILLID.getName()).get((Object)billEntryId);
                if (subRows.isEmpty()) continue;
                List fetchRow = requireTbl.fetchRow((Collection)subRows);
                for (RequireRowData subRow : fetchRow) {
                    billIds.add(subRow.getLong(DefaultField.RequireField.BILLID.getName()));
                }
            }
        }
        ReserveUtil.releaseReserveRecordByBillIds((IMRPEnvProvider)this.ctx, billIds, (String)releaseMode, (String)"CPS");
    }

    private void addOnWorkSupply(RequireRowData reqData) {
        BigDecimal recQty = (BigDecimal)MRPUtil.convert((Object)reqData.getValue(DefaultField.RequireField.RECQTY.getName()), (Object)BigDecimal.ZERO);
        if (recQty.compareTo(BigDecimal.ZERO) > 0) {
            int size = this.supplyTbl.getColIdx().size();
            Object[] data = new Object[size];
            data[((Integer)this.supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.SUPPLYORGUNIT.getName())).intValue()] = reqData.getValue(DefaultField.RequireField.PRODUCTIONORGUNIT.getName());
            data[((Integer)this.supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.DATE.getName())).intValue()] = reqData.getValue(DefaultField.RequireField.DATE.getName());
            data[((Integer)this.supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.BILLNUMBER.getName())).intValue()] = "";
            data[((Integer)this.supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.BILLID.getName())).intValue()] = reqData.getValue(DefaultField.RequireField.BILLID.getName());
            data[((Integer)this.supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.BILLENTRYID.getName())).intValue()] = reqData.getValue(DefaultField.RequireField.BILLENTRYID.getName());
            data[((Integer)this.supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.MATERIAL.getName())).intValue()] = reqData.getValue(DefaultField.RequireField.MATERIAL.getName());
            data[((Integer)this.supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.MATERIALATTR.getName())).intValue()] = reqData.getValue(DefaultField.RequireField.MATERIALATTR.getName());
            data[((Integer)this.supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.BILL_ENTITY.getName())).intValue()] = reqData.getValue(DefaultField.RequireField.BILL_ENTITY.getName());
            data[((Integer)this.supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.BILLENTRYSEQ.getName())).intValue()] = reqData.getValue(DefaultField.RequireField.BILLENTRYSEQ.getName());
            data[((Integer)this.supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.TRACKNUMBER.getName())).intValue()] = reqData.getValue(DefaultField.RequireField.TRACKNUMBER.getName());
            data[((Integer)this.supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.CONFIGUREDCODE.getName())).intValue()] = reqData.getValue(DefaultField.RequireField.CONFIGUREDCODE.getName());
            data[((Integer)this.supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.MATERIALFLEXPROPS.getName())).intValue()] = reqData.getValue(DefaultField.RequireField.MATERIALFLEXPROPS.getName());
            data[((Integer)this.supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.__VIRTUAL_SUPPLY__.getName())).intValue()] = true;
            data[((Integer)this.supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.QTY.getName())).intValue()] = recQty;
            data[((Integer)this.supplyTbl.getColIdx().get((Object)DefaultField.CommonField.__MODEL_NUMBER__.name())).intValue()] = ResManager.loadKDString((String)"\u7ec4\u4ef6\u5728\u5236", (String)"CalcNetDemand_11", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]);
            data[((Integer)this.supplyTbl.getColIdx().get((Object)DefaultField.SupplyField.ISSTORAGEDATA.getName())).intValue()] = true;
            RowData supply = new RowData(this.supplyTbl.getSrcDatas(), this.supplyTbl.getColIdx(), data, Integer.valueOf(this.supplyTbl.size() - 1), ResType.SUPPLY);
            int idx = this.supplyTbl.fillNoIndex(supply);
            reqData.update(DefaultField.RequireField.__SUPPLY_IDX__.getName(), (Object)idx);
            CPSSupplyStatNode node = new CPSSupplyStatNode(Integer.valueOf(idx));
            node.setMaxQty(recQty);
            this.allUsedSupplys.put(idx, node);
        }
    }

    private static interface IMappingDataResolver {
        public boolean resolve(String var1, HashMap<String, Object> var2);
    }
}

