/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.controlnode.mservice.mrp;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.mmc.mrp.business.helper.GlobalPlanHelper;
import kd.mmc.mrp.controlnode.framework.runner.MRPRunner4SPlanAndBizPlan;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.framework.consts.Tips;
import kd.mmc.mrp.integrate.MRPIntegrateFactory;
import kd.mmc.mrp.integrate.entity.PlanModel;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.enums.status.MRPExecuteStatus;
import kd.mmc.mrp.utils.DataSourceUtil;
import kd.mmc.mrp.utils.MRPUtil;
import kd.mmc.mrp.utils.PlanScopeUnit;
import kd.mpscmm.msplan.mservice.service.datafetch.model.FetchDataQueryModule;

public class AutoExecuteSelectPlanService {
    public String autoExecuteSelectPlan4PlanGram(Long planId, String billEntity, QFilter qFilter) {
        return this.autoExecuteSelectPlan4PlanGram(planId, billEntity, qFilter, false, null, true);
    }

    public String autoExecuteSelectPlan4PlanGram(Long planId, String billEntity, QFilter qFilter, Long bizPlanId) {
        return this.autoExecuteSelectPlan4PlanGram(planId, billEntity, qFilter, false, bizPlanId, true);
    }

    public String autoExecuteSelectPlan4PlanGram(Long planId, String billEntity, QFilter qFilter, Long bizPlanId, boolean isOnlySelectBillPlan) {
        return this.autoExecuteSelectPlan4PlanGram(planId, billEntity, qFilter, false, bizPlanId, isOnlySelectBillPlan);
    }

    public String autoExecuteSelectPlan4PlanGram(Long planId, String billEntity, QFilter qFilter, boolean is_single_calc, Long bizPlanId, boolean isOnlySelectBillPlan) {
        DynamicObject planprogram = BusinessDataServiceHelper.loadSingleFromCache((Object)planId, (String)"mrp_planprogram");
        long resId = 0L;
        DynamicObjectCollection entryentity = planprogram.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entryentity) {
            if (!entry.getBoolean("entryismrpoperat") || !StringUtils.equalsIgnoreCase((CharSequence)entry.getString("entrydemandsrc_id"), (CharSequence)billEntity)) continue;
            resId = entry.getLong("resourceregister_id");
            break;
        }
        if (resId <= 0L) {
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)billEntity);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u65b9\u6848\u201c%1$s\u201d\u672a\u627e\u5230%2$s\u53c2\u4e0eMRP\u8fd0\u7b97\u7684\u9700\u6c42\u6570\u636e\u6e90\u3002", (String)"AutoExecuteSelectPlanService_0", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), planprogram.getString("name"), entityType.getDisplayName().toString()));
        }
        HashSet<String> mIds = new HashSet<String>(16);
        HashMap<Long, List<Object[]>> map = new HashMap<Long, List<Object[]>>(8);
        List list = map.computeIfAbsent(resId, k -> new ArrayList(16));
        HashMap<String, Map<String, Set<String>>> org2material = new HashMap<String, Map<String, Set<String>>>(16);
        FetchDataQueryModule queryMD = DataSourceUtil.getQueryModuleByModelFilter((Long)resId, (QFilter)qFilter);
        String billEntryKey = null;
        for (String selectField : queryMD.getSelFields()) {
            if (!selectField.contains(DefaultField.RequireField.BILLENTRYID.getName().toLowerCase(Locale.ENGLISH))) continue;
            String quStr = selectField.substring(selectField.indexOf("(") + 1, selectField.indexOf(")"));
            String[] split = quStr.split("\\.");
            if (split.length < 2) break;
            billEntryKey = split[0];
            break;
        }
        DynamicObject mrpDs = BusinessDataServiceHelper.loadSingleFromCache((Object)resId, (String)"mrp_resource_dataconfig", (String)"id,number,name");
        StringBuilder billNos = new StringBuilder();
        billNos.append('\u3010').append(mrpDs.getString("name")).append("\u3011\uff1a");
        try (DataSet dataSet = DataSourceUtil.getDataSetByModel((FetchDataQueryModule)queryMD, (DataSet)QueryServiceHelper.queryDataSet((String)this.getClass().getSimpleName(), (String)queryMD.getMt(), (String)queryMD.getOql(), (QFilter[])queryMD.getqFilters(), null));){
            RowMeta rowMeta = dataSet.getRowMeta();
            while (dataSet.hasNext()) {
                Integer entryseq;
                Row row = dataSet.next();
                Long id = this.havProperty(rowMeta, DefaultField.RequireField.BILLID.getName().toLowerCase(Locale.ENGLISH)) ? (Long)MRPUtil.convert((Object)row.getLong(DefaultField.RequireField.BILLID.getName().toLowerCase(Locale.ENGLISH)), (Object)0L) : Long.valueOf(0L);
                Long entryid = this.havProperty(rowMeta, DefaultField.RequireField.BILLENTRYID.getName().toLowerCase(Locale.ENGLISH)) ? (Long)MRPUtil.convert((Object)row.getLong(DefaultField.RequireField.BILLENTRYID.getName().toLowerCase(Locale.ENGLISH)), (Object)0L) : Long.valueOf(0L);
                String billNo = this.havProperty(rowMeta, DefaultField.RequireField.BILLNUMBER.getName().toLowerCase(Locale.ENGLISH)) ? (String)MRPUtil.convert((Object)row.getString(DefaultField.RequireField.BILLNUMBER.getName().toLowerCase(Locale.ENGLISH)), (Object)"") : "";
                Integer n = entryseq = this.havProperty(rowMeta, DefaultField.RequireField.BILLENTRYSEQ.getName().toLowerCase(Locale.ENGLISH)) ? (Integer)MRPUtil.convert((Object)row.getInteger(DefaultField.RequireField.BILLENTRYSEQ.getName().toLowerCase(Locale.ENGLISH)), (Object)0) : Integer.valueOf(0);
                if (entryseq > 0) {
                    billNo = billNo + '-' + entryseq;
                }
                billNos.append(billNo).append('\uff0c');
                Long entrymaterial = this.havProperty(rowMeta, DefaultField.RequireField.MATERIAL.getName().toLowerCase(Locale.ENGLISH)) ? (Long)MRPUtil.convert((Object)row.get(DefaultField.RequireField.MATERIAL.getName().toLowerCase(Locale.ENGLISH)), (Object)0L) : Long.valueOf(0L);
                Long requireorg = this.havProperty(rowMeta, DefaultField.RequireField.PRODUCTIONORGUNIT.getName().toLowerCase(Locale.ENGLISH)) ? (Long)MRPUtil.convert((Object)row.getLong(DefaultField.RequireField.PRODUCTIONORGUNIT.getName().toLowerCase(Locale.ENGLISH)), (Object)0L) : Long.valueOf(0L);
                Long configuredcode = this.havProperty(rowMeta, DefaultField.RequireField.CONFIGUREDCODE.getName().toLowerCase(Locale.ENGLISH)) ? (Long)MRPUtil.convert((Object)row.getLong(DefaultField.RequireField.CONFIGUREDCODE.getName().toLowerCase(Locale.ENGLISH)), (Object)0L) : Long.valueOf(0L);
                Long warehouse = this.havProperty(rowMeta, DefaultField.RequireField.WAREHOUSE.getName().toLowerCase(Locale.ENGLISH)) ? (Long)MRPUtil.convert((Object)row.getLong(DefaultField.RequireField.WAREHOUSE.getName().toLowerCase(Locale.ENGLISH)), (Object)0L) : Long.valueOf(0L);
                Long planscope = this.havProperty(rowMeta, DefaultField.RequireField.PLANSCOPE.getName().toLowerCase(Locale.ENGLISH)) ? (Long)MRPUtil.convert((Object)row.getLong(DefaultField.RequireField.PLANSCOPE.getName().toLowerCase(Locale.ENGLISH)), (Object)0L) : Long.valueOf(0L);
                planscope = PlanScopeUnit.getPlanScope((Long)planscope, (Long)requireorg, (Long)warehouse, (Long)entrymaterial);
                Object[] values = new Object[]{id, entryid, billEntryKey, 0L, configuredcode, requireorg};
                list.add(values);
                mIds.add(entrymaterial.toString());
                Map mid2Scope = org2material.computeIfAbsent(requireorg.toString(), k -> new HashMap(2));
                Set scopeKey = mid2Scope.computeIfAbsent(entrymaterial.toString(), k -> new HashSet(2));
                scopeKey.add(planscope.toString() + '\u0001' + configuredcode.toString());
            }
        }
        if (mIds.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9009\u5355/\u9009\u6599\u7269\u6599\u4e0d\u5728\u8ba1\u7b97\u8303\u56f4\u5185\u3002", (String)"AutoExecuteSelectPlanService_4", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]));
        }
        DynamicObject caculateLog = this.createNewLog(planprogram);
        billNos.setLength(billNos.length() - 1);
        if (GlobalPlanHelper.isExistMRPRunning((Long)planId)) {
            ThreadPools.executeOnce((String)"autoExecuteSelectPlan4PlanGram", () -> this.run(billNos.toString(), planId, planprogram, caculateLog, map, mIds, org2material, is_single_calc, bizPlanId, isOnlySelectBillPlan));
        } else {
            this.run(billNos.toString(), planId, planprogram, caculateLog, map, mIds, org2material, is_single_calc, bizPlanId, isOnlySelectBillPlan);
        }
        return caculateLog.getString("number");
    }

    private void run(String billNos, Long planId, DynamicObject planprogram, DynamicObject caculateLog, Map<Long, List<Object[]>> map, Set<String> mIds, Map<String, Map<String, Set<String>>> org2material, boolean is_single_calc, Long bizPlanId, boolean isOnlySelectBillPlan) {
        long bigWaitTime = 600000L;
        long singleWait = 5000L;
        for (long waitTime = 0L; GlobalPlanHelper.isExistMRPRunning((Long)planId) && bigWaitTime > waitTime; waitTime += singleWait) {
            try {
                TimeUnit.MILLISECONDS.sleep(singleWait);
                continue;
            }
            catch (InterruptedException e) {
                throw new KDBizException((Throwable)e, new ErrorCode("sleep_failed", e.getMessage()), new Object[0]);
            }
        }
        if (GlobalPlanHelper.isExistMRPRunning((Long)planId)) {
            caculateLog.set("calculatestatus", (Object)MRPExecuteStatus.ERROR_STOP.getValue());
            Date startDate = caculateLog.getDate("startdate");
            Date endDate = new Date();
            caculateLog.set("enddate", (Object)endDate);
            long second = endDate.getTime() / 1000L - startDate.getTime() / 1000L;
            BigDecimal time = new BigDecimal(second).divide(new BigDecimal(60), 2, RoundingMode.CEILING);
            caculateLog.set("summin", (Object)time);
            DynamicObjectCollection entrys = caculateLog.getDynamicObjectCollection("entryentity");
            DynamicObject logInfo = entrys.addNew();
            logInfo.set("id", (Object)ID.genLongId());
            logInfo.set("entrystepseq", (Object)1);
            logInfo.set("entrystepname", (Object)Tips.getCalcEnd());
            logInfo.set("entryprocessdata", (Object)0);
            logInfo.set("entryresult", (Object)MRPExecuteStatus.ERROR_STOP.getAlias());
            String msg = String.format(ResManager.loadKDString((String)"\u7b49\u5f85\u8d85\u65f6\uff0c\u8ba1\u5212\u65b9\u6848\u201c%1$s\u201d\u5b58\u5728\u6b63\u5728\u8fd0\u884c\u7684\u8ba1\u5212\uff0c\u7b49\u5f85\u65f6\u957f\uff1a%2$s\u5206\u949f\uff0c\u70b9\u51fb\u8be6\u7ec6\u4fe1\u606f\u53ef\u67e5\u770b\u8fd0\u7b97\u5355\u636e\u3002", (String)"AutoExecuteSelectPlanService_3", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), planprogram.getString("name"), time.stripTrailingZeros().toPlainString());
            logInfo.set("entrydetailmsg", (Object)msg);
            logInfo.set("entrydetailmsg_tag", (Object)billNos);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{caculateLog});
            throw new KDBizException(msg);
        }
        caculateLog.set("calculatestatus", (Object)"D");
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{caculateLog});
        IMRPEnvProvider env = MRPIntegrateFactory.createMRPEnv((DynamicObject)caculateLog);
        new MRPRunner4SPlanAndBizPlan(map, mIds, org2material, is_single_calc, bizPlanId, isOnlySelectBillPlan).run(env);
    }

    private DynamicObject createNewLog(DynamicObject plangram) {
        DynamicObject org;
        DynamicObject caculateLog = BusinessDataServiceHelper.newDynamicObject((String)"mrp_caculate_log");
        String number = CodeRuleServiceHelper.getNumber((String)"mrp_caculate_log", (DynamicObject)caculateLog, (String)(org = plangram.getDynamicObject("createorg")).getPkValue().toString());
        if (StringUtils.isBlank((CharSequence)number)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8fd0\u7b97\u65e5\u5fd7\u7f16\u7801\u89c4\u5219\u4e0d\u5b58\u5728\u3002", (String)"AutoExecuteSelectPlanService_6", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]));
        }
        String plantype = PlanModel.getPlanType((DynamicObject)plangram);
        Long id = ORM.create().genLongId("mrp_caculate_log");
        caculateLog.set("id", (Object)id);
        caculateLog.set("number", (Object)number);
        caculateLog.set("createorg", (Object)org);
        caculateLog.set("useorg", (Object)org);
        caculateLog.set("runtype", (Object)"A");
        caculateLog.set("plantype", (Object)plantype);
        caculateLog.set("clearstatus", (Object)Character.valueOf('A'));
        caculateLog.set("status", (Object)Character.valueOf('C'));
        caculateLog.set("enable", (Object)Character.valueOf('1'));
        caculateLog.set("plangram", (Object)plangram.getLong("id"));
        caculateLog.set("programnumber", (Object)plangram.getString("number"));
        caculateLog.set("programname", (Object)plangram.getString("name"));
        caculateLog.set("plandate", (Object)MRPUtil.normalize((Date)new Date()));
        caculateLog.set("iscommon", plangram.get("iscommon"));
        caculateLog.set("iscustomize", plangram.get("iscustomize"));
        caculateLog.set("isselection", plangram.get("isselection"));
        caculateLog.set("isnotsetup", plangram.get("isnotsetup"));
        caculateLog.set("creator", (Object)RequestContext.get().getCurrUserId());
        caculateLog.set("operatmode", (Object)ResManager.loadKDString((String)"\u9009\u5355\u8ba1\u5212", (String)"AutoExecuteSelectPlanService_2", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]));
        caculateLog.set("operatmodekey", (Object)"mrp_selectbillplan");
        caculateLog.set("calculatestatus", (Object)"E");
        caculateLog.set("startdate", (Object)new Date());
        caculateLog.set("ctrlstrategy", (Object)"7");
        caculateLog.set("isllc", (Object)false);
        caculateLog.set("isbomcheck", (Object)false);
        caculateLog.set("isallowdateinpast", (Object)false);
        caculateLog.set("plangramentity", (Object)"mrp_planprogram");
        DynamicObjectCollection plantags = plangram.getDynamicObjectCollection("plantags");
        DynamicObjectCollection calctags = caculateLog.getDynamicObjectCollection("plantags");
        calctags.clear();
        for (DynamicObject tag : plantags) {
            DynamicObject cal = calctags.addNew();
            cal.set("fbasedataid", tag.get("fbasedataid"));
        }
        ORM.create().save(caculateLog);
        BaseDataServiceHelper.clearCache((DynamicObject)caculateLog);
        return caculateLog;
    }

    private boolean havProperty(RowMeta rowMeta, String field) {
        return rowMeta.getFieldIndex(field, false) >= 0;
    }
}

