/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.common.botp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;

public class BotpTrackerHelper {
    public static Map<Object, Set<Object>> billLinkTrackDown(String sourceEntity, String targetEntity, Long[] billIds, boolean onlyDirtTarget) {
        HashMap<Object, Set<Object>> entryIdMap = new HashMap<Object, Set<Object>>(6);
        Map nodeMap = BFTrackerServiceHelper.loadBillLinkDownNodes((String)sourceEntity, (Long[])billIds, (boolean)onlyDirtTarget);
        for (Map.Entry entry : nodeMap.entrySet()) {
            Long sBillId = (Long)entry.getKey();
            BFRowLinkDownNode node = (BFRowLinkDownNode)entry.getValue();
            Map tNodes = node.getTNodes();
            Iterator tIterator = tNodes.entrySet().iterator();
            Set<Long> tBillIds = new HashSet(6);
            if (entryIdMap.get(sBillId) != null) {
                tBillIds = (Set)entryIdMap.get(sBillId);
            }
            while (tIterator.hasNext()) {
                Map.Entry next = tIterator.next();
                BFRowLinkDownNode value = (BFRowLinkDownNode)next.getValue();
                BFRowId rowId = value.getRowId();
                Long billId = rowId.getBillId();
                Long mainTableId = rowId.getMainTableId();
                String entityNumber = EntityMetadataCache.loadTableDefine((Long)mainTableId).getEntityNumber();
                if (!StringUtils.equals((CharSequence)targetEntity, (CharSequence)entityNumber)) continue;
                tBillIds.add(billId);
            }
            entryIdMap.put(sBillId, tBillIds);
        }
        return entryIdMap;
    }

    public static Map<Object, Set<Object>> trackDown(String sourceEntity, String sourceEntryEntity, List<String> targetEntitys, Long[] entryIds) {
        HashMap<Object, Set<Object>> entryIdMap = new HashMap<Object, Set<Object>>(6);
        List nodes = BFTrackerServiceHelper.loadDirtLinkDownNodes((String)sourceEntity, (String)sourceEntryEntity, (Long[])entryIds);
        for (BFRowLinkDownNode node : nodes) {
            BFRowId sRowId = node.getRowId();
            Long sEntryId = sRowId.getEntryId();
            Map tNodes = node.getTNodes();
            Iterator tIterator = tNodes.entrySet().iterator();
            Set<Long> tBillIds = new HashSet(6);
            if (entryIdMap.get(sEntryId) != null) {
                tBillIds = (Set)entryIdMap.get(sEntryId);
            }
            while (tIterator.hasNext()) {
                Map.Entry next = tIterator.next();
                BFRowLinkDownNode value = (BFRowLinkDownNode)next.getValue();
                BFRowId rowId = value.getRowId();
                Long billId = rowId.getBillId();
                Long mainTableId = rowId.getMainTableId();
                String entityNumber = EntityMetadataCache.loadTableDefine((Long)mainTableId).getEntityNumber();
                if (!targetEntitys.contains(entityNumber)) continue;
                tBillIds.add(billId);
            }
            if (tBillIds.isEmpty()) continue;
            entryIdMap.put(sEntryId, tBillIds);
        }
        return entryIdMap;
    }

    public static Map<Object, Set<Object>> trackDown(String sourceEntity, String sourceEntryEntity, String targetEntity, Long[] entryIds) {
        ArrayList<String> targetEntitys = new ArrayList<String>(1);
        targetEntitys.add(targetEntity);
        return BotpTrackerHelper.trackDown(sourceEntity, sourceEntryEntity, targetEntitys, entryIds);
    }
}

