/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.common.botp;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class PurOrderBotpHelper {
    private static final BigDecimal ZERO = BigDecimal.ZERO;
    private static final BigDecimal ONE = BigDecimal.ONE;
    private static final BigDecimal HUNDRED = new BigDecimal(100);

    public static Map<String, Object> getAmount(BigDecimal qty, boolean isTax, BigDecimal price, BigDecimal priceAndTax, BigDecimal taxRate, String discountType, BigDecimal discountRate, int settlePrecision, int settlePricePrecision) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        BigDecimal amount = ZERO;
        BigDecimal taxAmount = ZERO;
        BigDecimal discountAmount = ZERO;
        BigDecimal amountAndTax = ZERO;
        BigDecimal hundred = new BigDecimal(100);
        BigDecimal bigDecimal = taxRate = taxRate == null ? ZERO : taxRate.divide(hundred).setScale(10, 4);
        if (qty != null && qty.compareTo(ZERO) != 0) {
            if (discountRate == null || StringUtils.isBlank((CharSequence)discountType) || discountType.equals("NULL") || discountRate.compareTo(ZERO) == 0) {
                if (isTax && priceAndTax != null && priceAndTax.compareTo(ZERO) != 0) {
                    price = priceAndTax.divide(ONE.add(taxRate), settlePricePrecision, RoundingMode.HALF_UP);
                    amountAndTax = qty.multiply(priceAndTax).setScale(settlePrecision, RoundingMode.HALF_UP);
                    taxAmount = amountAndTax.divide(ONE.add(taxRate), 10, 4).multiply(taxRate).setScale(settlePrecision, RoundingMode.HALF_UP);
                    amount = amountAndTax.subtract(taxAmount).setScale(settlePrecision, RoundingMode.HALF_UP);
                } else if (price != null && price.compareTo(ZERO) != 0) {
                    priceAndTax = price.multiply(ONE.add(taxRate)).setScale(settlePricePrecision, RoundingMode.HALF_UP);
                    amount = qty.multiply(price).setScale(settlePrecision, RoundingMode.HALF_UP);
                    taxAmount = amount.multiply(taxRate).setScale(settlePrecision, RoundingMode.HALF_UP);
                    amountAndTax = amount.add(taxAmount).setScale(settlePrecision, RoundingMode.HALF_UP);
                }
            } else if (isTax && priceAndTax != null && priceAndTax.compareTo(ZERO) != 0) {
                price = priceAndTax.divide(ONE.add(taxRate), settlePricePrecision, RoundingMode.HALF_UP);
                if ("A".equals(discountType)) {
                    discountRate = discountRate.divide(hundred).setScale(10, 4);
                    discountAmount = qty.multiply(priceAndTax).multiply(discountRate).setScale(settlePrecision, RoundingMode.HALF_UP);
                    amountAndTax = qty.multiply(priceAndTax).subtract(discountAmount).setScale(settlePrecision, RoundingMode.HALF_UP);
                } else if ("B".equals(discountType)) {
                    discountAmount = qty.multiply(discountRate).setScale(settlePrecision, RoundingMode.HALF_UP);
                    amountAndTax = qty.multiply(priceAndTax.subtract(discountRate)).setScale(settlePrecision, RoundingMode.HALF_UP);
                }
                taxAmount = amountAndTax.divide(ONE.add(taxRate), 10, 4).multiply(taxRate).setScale(settlePrecision, RoundingMode.HALF_UP);
                amount = amountAndTax.subtract(taxAmount).setScale(settlePrecision, RoundingMode.HALF_UP);
            } else if (price != null && price.compareTo(ZERO) != 0) {
                priceAndTax = price.multiply(ONE.add(taxRate)).setScale(settlePricePrecision, RoundingMode.HALF_UP);
                if ("A".equals(discountType)) {
                    discountRate = discountRate.divide(hundred, 10, 4);
                    discountAmount = qty.multiply(priceAndTax).multiply(discountRate).setScale(settlePrecision, RoundingMode.HALF_UP);
                    amount = qty.multiply(price).multiply(ONE.subtract(discountRate)).setScale(settlePrecision, RoundingMode.HALF_UP);
                } else if ("B".equals(discountType)) {
                    discountAmount = qty.multiply(discountRate).setScale(settlePrecision, RoundingMode.HALF_UP);
                    amount = qty.multiply(price.subtract(discountRate)).setScale(settlePrecision, RoundingMode.HALF_UP);
                }
                taxAmount = amount.multiply(taxRate).setScale(settlePrecision, RoundingMode.HALF_UP);
                amountAndTax = amount.add(taxAmount).setScale(settlePrecision, RoundingMode.HALF_UP);
            }
        }
        map.put("price", price);
        map.put("priceandtax", priceAndTax);
        map.put("amount", amount);
        map.put("discountamount", discountAmount);
        map.put("taxamount", taxAmount);
        map.put("amountandtax", amountAndTax);
        return map;
    }

    public static void initQty(DynamicObject entry) {
        DynamicObject material = entry.getDynamicObject("material");
        if (material == null) {
            return;
        }
        DynamicObject master = material.getDynamicObject("masterid");
        if (master == null) {
            return;
        }
        DynamicObject unit = entry.getDynamicObject("unit");
        BigDecimal qty = entry.getBigDecimal("qty");
        DynamicObject baseUnit = entry.getDynamicObject("baseunit");
        BigDecimal baseQty = entry.getBigDecimal("baseqty");
        if (qty != null && baseQty != null && qty.compareTo(ZERO) != 0 && baseQty.compareTo(ZERO) != 0) {
            return;
        }
        if (!(qty != null && qty.compareTo(ZERO) != 0 || baseQty != null && baseQty.compareTo(ZERO) != 0)) {
            return;
        }
        if (baseUnit == null) {
            baseUnit = master.getDynamicObject("baseunit");
            entry.set("baseunit", (Object)baseUnit);
        }
        if (unit == null) {
            unit = material.getDynamicObject("purchaseunit");
            entry.set("unit", (Object)unit);
        }
        if (unit == null || baseUnit == null) {
            return;
        }
        if ((qty == null || qty.compareTo(ZERO) == 0) && baseQty != null && baseQty.compareTo(ZERO) != 0) {
            qty = PurOrderBotpHelper.getDesQtyConv((Long)master.getPkValue(), baseUnit, baseQty, unit);
            entry.set("qty", (Object)qty);
        } else if ((baseQty == null || baseQty.compareTo(ZERO) == 0) && qty != null && qty.compareTo(ZERO) != 0) {
            baseQty = PurOrderBotpHelper.getDesQtyConv((Long)master.getPkValue(), unit, qty, baseUnit);
            entry.set("baseqty", (Object)baseQty);
        }
        BigDecimal receiveRateUp = entry.getBigDecimal("receiverateup");
        BigDecimal receiveRateDown = entry.getBigDecimal("receiveratedown");
        if ((receiveRateUp == null || receiveRateDown == null || receiveRateUp.compareTo(ZERO) == 0 || receiveRateDown.compareTo(ZERO) == 0) && qty != null && baseQty != null && qty.compareTo(ZERO) != 0 && baseQty.compareTo(ZERO) != 0) {
            boolean isControlQty = material.getBoolean("iscontrolqty");
            if (isControlQty) {
                receiveRateUp = material.getBigDecimal("receiverateup");
                receiveRateDown = material.getBigDecimal("receiveratedown");
                if (receiveRateUp != null && receiveRateDown != null) {
                    int precision = PurOrderBotpHelper.getPrecision(unit);
                    int precisionType = PurOrderBotpHelper.getPrecisionType(unit);
                    int precision_base = PurOrderBotpHelper.getPrecision(baseUnit);
                    int precisionType_base = PurOrderBotpHelper.getPrecisionType(baseUnit);
                    BigDecimal add = ONE.add(receiveRateUp.divide(HUNDRED, 10, 4));
                    BigDecimal receiveQtyUp = qty.multiply(add).setScale(precision, precisionType);
                    BigDecimal subtract = ONE.subtract(receiveRateDown.divide(HUNDRED, 10, 4));
                    BigDecimal receiveQtyDown = qty.multiply(subtract).setScale(precision, precisionType);
                    BigDecimal receiveBaseQtyUp = baseQty.multiply(add).setScale(precision_base, precisionType_base);
                    BigDecimal receiveBaseQtyDown = baseQty.multiply(subtract).setScale(precision_base, precisionType_base);
                    entry.set("iscontrolqty", (Object)Boolean.TRUE);
                    entry.set("receiverateup", (Object)receiveRateUp);
                    entry.set("receiveratedown", (Object)receiveRateDown);
                    entry.set("receiveqtyup", (Object)receiveQtyUp);
                    entry.set("receiveqtydown", (Object)receiveQtyDown);
                    entry.set("receivebaseqtyup", (Object)receiveBaseQtyUp);
                    entry.set("receivebaseqtydown", (Object)receiveBaseQtyDown);
                }
            } else {
                entry.set("iscontrolqty", (Object)Boolean.FALSE);
                entry.set("receiveqtyup", (Object)qty);
                entry.set("receiveqtydown", (Object)qty);
                entry.set("receivebaseqtyup", (Object)baseQty);
                entry.set("receivebaseqtydown", (Object)baseQty);
            }
        }
    }

    public static void initPayCondition(Long payConditionId, DynamicObject bill) {
        DynamicObjectCollection payplanentrys;
        DynamicObject payCondition = BusinessDataServiceHelper.loadSingleFromCache((Object)payConditionId, (String)"bd_paycondition");
        if (payCondition != null && (payplanentrys = bill.getDynamicObjectCollection("purbillentry_pay")) != null && payplanentrys.size() == 0) {
            String basis = payCondition.getString("basis");
            DynamicObjectCollection entitys = payCondition.getDynamicObjectCollection("entry");
            if (entitys != null && entitys.size() > 0) {
                if ("B".equals(basis)) {
                    for (int i = 0; i < entitys.size(); ++i) {
                        DynamicObject recplanentry = payplanentrys.addNew();
                        DynamicObject entity = (DynamicObject)entitys.get(i);
                        recplanentry.set("payname", entity.get("itemname"));
                        recplanentry.set("isprepay", entity.get("ispre"));
                        recplanentry.set("payamount", entity.get("amount"));
                    }
                    bill.set("ispayrate", (Object)Boolean.FALSE);
                } else {
                    BigDecimal totalAllAmount = bill.getBigDecimal("totalallamount");
                    for (int i = 0; i < entitys.size(); ++i) {
                        DynamicObject payplanentry = payplanentrys.addNew();
                        DynamicObject entity = (DynamicObject)entitys.get(i);
                        payplanentry.set("payname", entity.get("itemname"));
                        payplanentry.set("isprepay", entity.get("ispre"));
                        BigDecimal payRate = (BigDecimal)entity.get("rate");
                        BigDecimal payAmount = totalAllAmount == null || payRate == null ? null : totalAllAmount.multiply(payRate.divide(HUNDRED, 10, 4));
                        payplanentry.set("payrate", (Object)payRate);
                        payplanentry.set("payamount", (Object)payAmount);
                    }
                    bill.set("ispayrate", (Object)Boolean.TRUE);
                }
            }
        }
    }

    public static void dealPayEntrys(DynamicObject bill, int settlePrecision) {
        DynamicObjectCollection payEntrys = bill.getDynamicObjectCollection("purbillentry_pay");
        if (payEntrys == null) {
            return;
        }
        if (payEntrys.isEmpty()) {
            return;
        }
        BigDecimal sumPayAmount = BigDecimal.ZERO;
        BigDecimal totalAmountAndTax = bill.getBigDecimal("totalallamount");
        boolean isPayRate = bill.getBoolean("ispayrate");
        BigDecimal sumPayRate = BigDecimal.ZERO;
        for (int i = 0; i < payEntrys.size(); ++i) {
            DynamicObject payCondition;
            BigDecimal payRate;
            DynamicObject payEntry = (DynamicObject)payEntrys.get(i);
            if (isPayRate && (payRate = payEntry.getBigDecimal("payrate")) != null) {
                sumPayRate = sumPayRate.add(payRate);
                BigDecimal payAmount = BigDecimal.ZERO;
                payAmount = i == payEntrys.size() - 1 && HUNDRED.compareTo(sumPayRate) == 0 ? totalAmountAndTax.subtract(sumPayAmount) : totalAmountAndTax.multiply(payRate.divide(new BigDecimal(100), 10, 4));
                payAmount = payAmount.setScale(settlePrecision, RoundingMode.HALF_UP);
                payEntry.set("payamount", (Object)payAmount);
                sumPayAmount = sumPayAmount.add(payAmount).setScale(settlePrecision, RoundingMode.HALF_UP);
            }
            if ((payCondition = (DynamicObject)bill.get("paycondition")) == null) continue;
            payEntry.set("paydate", (Object)new Date());
        }
    }

    public static BigDecimal getDesQtyConv(Long materialId, DynamicObject srcUnit, BigDecimal srcQty, DynamicObject desUnit) {
        if (materialId == null || srcUnit == null || desUnit == null || srcQty == null) {
            return ZERO;
        }
        if (srcUnit.getPkValue().equals(desUnit.getPkValue())) {
            return srcQty;
        }
        BigDecimal desQty = ZERO;
        DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)((Long)srcUnit.getPkValue()), (Long)((Long)desUnit.getPkValue()));
        if (muConv != null) {
            int numerator = muConv.getInt("numerator");
            int denominator = muConv.getInt("denominator");
            if (denominator != 0) {
                int unitPrecision = desUnit.getInt("precision");
                int account = desUnit.getInt("precisionaccount");
                int unitPrecisionType = 4;
                if (account == 2) {
                    unitPrecisionType = 1;
                } else if (account == 3) {
                    unitPrecisionType = 0;
                }
                desQty = srcQty.multiply(new BigDecimal(numerator)).divide(new BigDecimal(denominator), unitPrecision, unitPrecisionType);
            }
        }
        return desQty;
    }

    public static DynamicObject getDefaultLinkMan(DynamicObject supplier) {
        DynamicObjectCollection linkmans = supplier.getDynamicObjectCollection("entry_linkman");
        if (linkmans == null || linkmans.isEmpty()) {
            return null;
        }
        DynamicObject defaultLinkMan = null;
        for (DynamicObject linkman : linkmans) {
            boolean isDefault = linkman.getBoolean("isdefault_linkman");
            boolean invalid = linkman.getBoolean("invalid");
            if (isDefault && !invalid) {
                defaultLinkMan = linkman;
                break;
            }
            if (defaultLinkMan != null || invalid) continue;
            defaultLinkMan = linkman;
        }
        return defaultLinkMan;
    }

    public static DynamicObject getOtherSupplier(DynamicObject supplier, String otherSupplierKey) {
        if (supplier == null) {
            return null;
        }
        DynamicObject otherSupplier = supplier.getDynamicObject(otherSupplierKey);
        if (otherSupplier != null) {
            return otherSupplier;
        }
        String bizfunction = supplier.getString("bizfunction");
        if (StringUtils.isBlank((CharSequence)bizfunction)) {
            return null;
        }
        switch (otherSupplierKey) {
            case "deliversupplierid": {
                if (!supplier.getBoolean("purchasehold") && bizfunction.contains("1")) break;
                return null;
            }
            case "invoicesupplierid": {
                if (!supplier.getBoolean("invoicehold") && bizfunction.contains("2")) break;
                return null;
            }
            case "receivingsupplierid": {
                if (!supplier.getBoolean("payhold") && bizfunction.contains("3")) break;
                return null;
            }
        }
        return supplier;
    }

    public static int getPrecision(DynamicObject unit) {
        int precision = 10;
        if (unit != null) {
            precision = unit.getInt("precision");
        }
        return precision;
    }

    public static int getPrecisionType(DynamicObject unit) {
        int precisionType = 4;
        if (unit != null && StringUtils.isNotBlank((Object)unit.get("precisionaccount"))) {
            String precisionAccount;
            switch (precisionAccount = unit.getString("precisionaccount")) {
                case "1": {
                    precisionType = 4;
                    break;
                }
                case "2": {
                    precisionType = 1;
                    break;
                }
                case "3": {
                    precisionType = 0;
                    break;
                }
            }
        }
        return precisionType;
    }

    public static DynamicObject getDefaultBizType(DynamicObject billType) {
        DynamicObject bizType = null;
        DynamicObject billTypeParam = (DynamicObject)SystemParamServiceHelper.getBillTypeParameter((String)"pm_purorderbill", (String)"pm_billtypeparameter", (long)((Long)billType.getPkValue()));
        if (billTypeParam != null) {
            bizType = billTypeParam.getDynamicObject("biztype");
        }
        return bizType;
    }
}

