/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.common.botp;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.operate.OpFieldValueReader;
import kd.bos.list.IListView;
import kd.bos.mservice.sysparam.SystemParamService;
import kd.bos.orm.ORM;
import kd.bos.orm.dataentity.ShardingHinter;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.xdb.hint.ShardingHintContext;

public class TrackCustomer {
    private String type;
    private String pageId;
    private IFormView view;
    private String entityId;
    private Set<Long> selectedBillIds = new HashSet<Long>(10);
    private Set<Long> selectedEntryIds = new HashSet<Long>(10);
    private Set<Long> selectedSubEntryIds = new HashSet<Long>(10);
    private OperationResult trackResult = null;
    private static SystemParamService systemParamService = (SystemParamService)ServiceFactory.getService(SystemParamService.class);

    public IFormView getView() {
        return this.view;
    }

    public String getPageId() {
        return this.pageId;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public OperationResult getTrackResult() {
        return this.trackResult;
    }

    public TrackCustomer(IFormView view, String entityId) {
        this.view = view;
        this.entityId = entityId;
    }

    protected boolean beforeInvokeOperation() {
        if (this.getView() instanceof IBillView) {
            String pkValue;
            IBillModel billModel = (IBillModel)this.getView().getModel();
            String string = pkValue = billModel.getPKValue() == null ? "" : billModel.getPKValue().toString();
            if (StringUtils.isBlank((CharSequence)pkValue) || pkValue.equals("0")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002", (String)"TrackCustomer_0", (String)"mmc-om-common", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationResult invokeOperation() {
        String linkNodesJson;
        FormShowParameter showParameter;
        this.beforeInvokeOperation();
        HashSet<Long> billIds = this.getSelectedBillIds();
        if (billIds.size() == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u8054\u67e5\u7684\u6570\u636e\u3002", (String)"TrackCustomer_1", (String)"mmc-om-common", (Object[])new Object[0]));
            return null;
        }
        IDataEntityType dt = ORM.create().getDataEntityType(this.getEntityId());
        ShardingHintContext ctx = ShardingHinter.tryHint((IDataEntityType)dt, (Object[])billIds.toArray());
        if (ctx != null) {
            ctx.set();
        }
        try {
            showParameter = new FormShowParameter();
            Object lookUpTrackerUseList = systemParamService.loadPublicParameterFromCache("lookuptracker_use_list");
            String isUseList = lookUpTrackerUseList == null ? String.valueOf(false) : lookUpTrackerUseList.toString();
            showParameter.getCustomParams().put("lookuptracker_use_list", isUseList);
            showParameter.setFormId("botp_lookuptracker");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setPageId(this.buildTrackFormPageId());
            showParameter.setCaption(this.buildTrackFormCaption());
            this.trackResult = new OperationResult();
            this.trackResult.setSuccess(true);
            this.trackResult.setBillCount(billIds.size());
            linkNodesJson = this.loadAndSeriLinkNodes();
        }
        finally {
            if (ctx != null) {
                ctx.close();
            }
        }
        if (StringUtils.isBlank((CharSequence)linkNodesJson)) {
            String msg = ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"TrackCustomer_2", (String)"mmc-om-common", (Object[])new Object[0]);
            if (this.getTrackResult().getAllErrorOrValidateInfo().isEmpty()) {
                this.getView().showTipNotification(msg);
            } else {
                if (StringUtils.isBlank((CharSequence)this.trackResult.getMessage())) {
                    this.trackResult.setMessage(msg);
                }
                this.trackResult.setSuccess(false);
                this.getView().showOperationResult(this.trackResult);
            }
            return null;
        }
        if (!this.trackResult.getAllErrorOrValidateInfo().isEmpty()) {
            this.getView().showOperationResult(this.trackResult);
        }
        showParameter.getCustomParams().put("linknodes", linkNodesJson);
        showParameter.getCustomParams().put("lookuptype", this.getLookUpType());
        this.getView().showForm(showParameter);
        return null;
    }

    protected HashSet<Long> getSelectedBillIds() {
        IBillView billView;
        IBillModel billModel;
        HashSet<Long> billIds = new HashSet<Long>();
        if (this.getView() instanceof IListView) {
            IListView listView = (IListView)this.getView();
            for (ListSelectedRow row : listView.getSelectedRows()) {
                Long billId;
                if (!(row.getPrimaryKeyValue() instanceof Long) || billIds.contains(billId = (Long)row.getPrimaryKeyValue())) continue;
                billIds.add(billId);
            }
        } else if (this.getView() instanceof IBillView && (billModel = (IBillModel)(billView = (IBillView)this.getView()).getModel()).getPKValue() instanceof Long) {
            Long billId = (Long)billModel.getPKValue();
            billIds.add(billId);
        }
        this.selectedBillIds.addAll(billIds);
        return billIds;
    }

    protected String buildTrackFormPageId() {
        ArrayList<Long> dataIds = null;
        if (!this.selectedBillIds.isEmpty()) {
            dataIds = new ArrayList<Long>(this.selectedBillIds);
        } else if (!this.selectedEntryIds.isEmpty()) {
            dataIds = new ArrayList<Long>(this.selectedEntryIds);
        } else if (!this.selectedSubEntryIds.isEmpty()) {
            dataIds = new ArrayList<Long>(this.selectedSubEntryIds);
        }
        if (dataIds == null) {
            return null;
        }
        dataIds.sort(new LongComparator());
        int hashcode = 1;
        for (Long dataId : dataIds) {
            hashcode = 31 * (dataId == null ? 1 : dataId.hashCode());
        }
        return String.format("%s_%s_%s_%s_%s", this.getView().getPageId(), "trackup", String.valueOf(dataIds.get(0)), dataIds.size(), hashcode);
    }

    protected String buildTrackFormCaption() {
        Long billId;
        OpFieldValueReader fieldValueReader;
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)this.getEntityId());
        String entityName = mainType.getDisplayName().toString();
        String billNo = "";
        int billCount = this.getSelectedBillIds().size();
        if (!this.getSelectedBillIds().isEmpty() && StringUtils.isBlank((CharSequence)(billNo = (fieldValueReader = OpFieldValueReader.get((IFormView)this.getView())).getBillNo((Object)(billId = this.getSelectedBillIds().iterator().next()))))) {
            billNo = this.tryLoadBillno(mainType, billId);
        }
        String opName = ResManager.loadKDString((String)"\u4e0a\u67e5", (String)"TrackCustomer_3", (String)"mmc-om-common", (Object[])new Object[0]);
        return billCount <= 1 ? MessageFormat.format("{0}({1})-{2}", entityName, billNo, opName) : MessageFormat.format(ResManager.loadKDString((String)"{0}({1}\u7b49{2}\u5355)-{3}", (String)"TrackCustomer_4", (String)"scmc-mm-om", (Object[])new Object[0]), entityName, billNo, billCount, opName);
    }

    private String tryLoadBillno(MainEntityType mainType, Object billId) {
        String billNoKey;
        DynamicObject billData = BusinessDataServiceHelper.loadSingleFromCache((Object)billId, (DynamicObjectType)mainType);
        if (billData != null && mainType instanceof BillEntityType && StringUtils.isNotBlank((CharSequence)(billNoKey = ((BillEntityType)mainType).getBillNo()))) {
            return billData.getString(billNoKey);
        }
        return null;
    }

    protected String loadAndSeriLinkNodes() {
        HashSet<Long> billIds = this.getSelectedBillIds();
        List<BFRowLinkUpNode> nodes = this.addNoReationNodes(billIds);
        if (nodes != null && nodes.size() != 0) {
            if (nodes.isEmpty()) {
                return null;
            }
            HashSet<Long> successBillIds = new HashSet<Long>(nodes.size());
            for (BFRowLinkUpNode node : nodes) {
                if (node.getSNodes() == null || node.getSNodes().isEmpty()) continue;
                successBillIds.add(node.getRowId().getBillId());
            }
            this.getTrackResult().getSuccessPkIds().addAll(successBillIds);
            String nodesJson = SerializationUtils.serializeToBase64(nodes);
            return nodesJson;
        }
        return null;
    }

    private List<BFRowLinkUpNode> addNoReationNodes(HashSet<Long> billIds) {
        ArrayList<Object> nodes = new ArrayList<BFRowLinkUpNode>(billIds.size());
        if (billIds == null || billIds.size() < 1) {
            return nodes;
        }
        HashMap<Long, Set> targetIds = new HashMap<Long, Set>(billIds.size());
        QFilter qFilter = new QFilter("id", "in", billIds);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"om_mftstockplan", (String)"id,orderentryid", (QFilter[])qFilter.toArray(), null);){
            for (Row row : dataSet) {
                long outpurApplyid = row.get("orderentryid") == null ? 0L : row.getLong("orderentryid");
                long outstockid = row.get("id") == null ? 0L : row.getLong("id");
                targetIds.computeIfAbsent(outstockid, k -> new HashSet(10)).add(outpurApplyid);
            }
        }
        if (targetIds.size() < 1) {
            return nodes;
        }
        TableDefine srcTableDefine = EntityMetadataCache.loadTableDefine((String)"om_mftstockplan", (String)"stockentry");
        TableDefine targetTableDefine = EntityMetadataCache.loadTableDefine((String)"pm_purapplybill", (String)"billentry");
        nodes = new ArrayList(10);
        for (Map.Entry<Long, Set<Long>> entry : targetIds.entrySet()) {
            BFRowLinkUpNode srcNode = this.getBfRowLinkUpNode(targetTableDefine, srcTableDefine, entry);
            nodes.add(srcNode);
        }
        return nodes;
    }

    private BFRowLinkUpNode getBfRowLinkUpNode(TableDefine targetTableDefine, TableDefine srcTableDefine, Map.Entry<Long, Set<Long>> targetEntrys) {
        Long srcid = targetEntrys.getKey();
        Set<Long> targetids = targetEntrys.getValue();
        BFRowLinkUpNode srcNode = new BFRowLinkUpNode();
        BFRowId srcrowId = new BFRowId(srcTableDefine.getTableId(), srcid, srcTableDefine.getTableId(), srcid);
        srcNode.setRowId(srcrowId);
        HashMap<BFRowId, BFRowLinkUpNode> targetNods = new HashMap<BFRowId, BFRowLinkUpNode>(16);
        for (Long targetid : targetids) {
            BFRowLinkUpNode targetNode = new BFRowLinkUpNode();
            BFRowId targetrowId = new BFRowId(targetTableDefine.getTableId(), targetid, targetTableDefine.getTableId(), targetid);
            targetNode.setRowId(targetrowId);
            targetNods.put(targetrowId, targetNode);
        }
        srcNode.setSNodes(targetNods);
        return srcNode;
    }

    protected String getLookUpType() {
        return "lookup";
    }

    static class LongComparator
    implements Comparator<Long> {
        LongComparator() {
        }

        @Override
        public int compare(Long o1, Long o2) {
            return Long.compare(o1, o2);
        }
    }
}

