/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.common.helper;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class AcctOrgHelper {
    public Long getAcctOrgByMftOrg(Long mftOrgId) {
        ArrayList<String> propertyNameList = new ArrayList<String>();
        propertyNameList.add("fisaccounting");
        Map orgProperty = OrgUnitServiceHelper.getOrgProperty((long)mftOrgId, propertyNameList);
        Boolean fIsAccounting = (Boolean)orgProperty.get("fisaccounting");
        if (fIsAccounting.booleanValue()) {
            return mftOrgId;
        }
        Long parent = this.getParentIdBySelfOrOrgUnitViewCommon(mftOrgId, "10");
        return parent;
    }

    private long getParentIdBySelfOrOrgUnitViewCommon(long srcParentId, Object viewKey) {
        QFilter filter = new QFilter("org", "=", (Object)srcParentId);
        QFilter filterTreeType = null;
        ArrayList<Object> viewList = new ArrayList<Object>(10);
        if (viewKey instanceof String) {
            viewList.add(viewKey);
            viewList.add("15");
            filterTreeType = new QFilter("view.number", "in", viewList);
        } else {
            viewList.add(viewKey);
            viewList.add(15L);
            filterTreeType = new QFilter("view", "in", viewList);
        }
        QFilter[] filters = new QFilter[]{filter, filterTreeType};
        String orgUnitLongnumber = "";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"OrgService.getParentIdBySelfOrOrgUnitView", (String)"bos_org_structure", (String)"view,org,longnumber", (QFilter[])filters, (String)"longnumber desc");){
            for (Row row : dataSet) {
                if (15L == row.getLong("view")) {
                    orgUnitLongnumber = row.getString("longnumber");
                    continue;
                }
                long l = row.getLong("org");
                return l;
            }
        }
        return this.getParentIdBySelfOrOrgUnitView(srcParentId, viewKey, orgUnitLongnumber);
    }

    private long getParentIdBySelfOrOrgUnitView(long srcParentId, Object viewKey, String orgUnitLongnumber) {
        long lCurParentID = 0L;
        if (StringUtils.isEmpty((CharSequence)orgUnitLongnumber)) {
            QFilter filterUnit = new QFilter("org", "=", (Object)srcParentId);
            QFilter filterView = new QFilter("view", "=", (Object)15L);
            QFilter[] filterUnits = new QFilter[]{filterUnit, filterView};
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"getParentIdBySelfOrOrgUnitViewByLongNumber", (String)"bos_org_structure", (String)"longnumber", (QFilter[])filterUnits, (String)"");){
                if (ds.hasNext()) {
                    orgUnitLongnumber = ds.next().getString("longnumber");
                }
            }
        }
        QFilter viewFilter = null;
        viewFilter = viewKey instanceof String ? new QFilter("view.number", "=", viewKey) : new QFilter("view", "=", viewKey);
        if (StringUtils.isNotEmpty((CharSequence)orgUnitLongnumber)) {
            String[] parentNumberArr = orgUnitLongnumber.split("!");
            QFilter numberFilter = new QFilter("org.number", "in", (Object)parentNumberArr);
            QFilter[] filterOrgs = new QFilter[]{numberFilter, viewFilter};
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"OrgServiceHelper.getSamePropertyParentIDByLongNumber", (String)"bos_org_structure", (String)"org", (QFilter[])filterOrgs, (String)"longnumber desc", (int)1);){
                for (Row row : dataSet) {
                    lCurParentID = row.getLong("org");
                }
            }
        }
        if (lCurParentID == 0L) {
            return this.getViewRootOrgId(viewFilter);
        }
        return lCurParentID;
    }

    private long getViewRootOrgId(QFilter viewFilter) {
        long orgId = 0L;
        QFilter parentFilter = new QFilter("parent", "=", (Object)0L);
        QFilter levelFilter = new QFilter("level", "=", (Object)1);
        QFilter[] filters = new QFilter[]{viewFilter, parentFilter, levelFilter};
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"OrgService.getViewRootOrgId", (String)"bos_org_structure", (String)"org", (QFilter[])filters, (String)"longnumber", (int)1);){
            if (ds.hasNext()) {
                long l = ds.next().getLong("org");
                return l;
            }
        }
        return orgId;
    }
}

