/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.om.common.manuftech.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.business.helper.CostRelateHelper;
import kd.bd.mpdm.common.mftorder.enums.ManuBillTaskStatusEnum;
import kd.bd.mpdm.common.utils.MpdmDyObjUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.ORM;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class CheckManuOrderUtil {
    private static final String[] OPKEYS = new String[]{"B", "C", "D"};

    public static StringBuffer checkManuOrderEntryStatus(String checkType, String billno, String operationName, Object pk) {
        StringBuffer errors = new StringBuffer();
        QFilter filter = new QFilter("treeentryentity.id", "=", pk);
        QFilter[] filters = new QFilter[]{filter};
        ORM orm = ORM.create();
        DynamicObjectCollection deptCol = orm.query("om_mftorder", "id,billno,treeentryentity.id,treeentryentity.planstatus,treeentryentity.bizstatus", filters, "id");
        if (deptCol.size() == 0) {
            errors.append(ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5e8f\u8ba1\u5212\u5bf9\u5e94\u59d4\u5916\u5de5\u5355\u5206\u5f55\u5df2\u5220\u9664\u3002", (String)"CheckManuOrderUtil_0", (String)"mmc-om-common", (Object[])new Object[0]));
            errors.append("\n");
            return errors;
        }
        block0: for (int i = 0; i < deptCol.size(); ++i) {
            DynamicObject obj = (DynamicObject)deptCol.get(i);
            for (int j = 0; j < obj.getDynamicObjectCollection("treeentryentity").size(); ++j) {
                DynamicObject manuEntryObj = (DynamicObject)obj.getDynamicObjectCollection("treeentryentity").get(j);
                if (!pk.equals(manuEntryObj.getPkValue())) continue;
                if ("checkTaskStatus".equals(checkType)) {
                    if ("B".equals(manuEntryObj.getString("bizstatus"))) {
                        errors.append(String.format(ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5355%s\u884c\u4e1a\u52a1\u72b6\u6001\u4e3a\u6302\u8d77,\u65e0\u6cd5\u66f4\u6539\u5de5\u5e8f\u72b6\u6001\u3002", (String)"CheckManuOrderUtil_1", (String)"mmc-om-common", (Object[])new Object[0]), obj.get("billno")));
                        errors.append("\n");
                        continue block0;
                    }
                    if ("C".equals(manuEntryObj.getString("bizstatus"))) {
                        errors.append(String.format(ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5355%s\u884c\u4e1a\u52a1\u72b6\u6001\u4e3a\u5173\u95ed,\u65e0\u6cd5\u66f4\u6539\u5de5\u5e8f\u72b6\u6001\u3002", (String)"CheckManuOrderUtil_2", (String)"mmc-om-common", (Object[])new Object[0]), obj.get("billno")));
                        errors.append("\n");
                        continue block0;
                    }
                    if (!"D".equals(manuEntryObj.getString("bizstatus"))) continue block0;
                    errors.append(String.format(ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5355%s\u884c\u4e1a\u52a1\u72b6\u6001\u4e3a\u7ed3\u6848,\u65e0\u6cd5\u66f4\u6539\u5de5\u5e8f\u72b6\u6001\u3002", (String)"CheckManuOrderUtil_3", (String)"mmc-om-common", (Object[])new Object[0]), obj.get("billno")));
                    errors.append("\n");
                    continue block0;
                }
                if (!"checkBizStatus".equals(checkType) || "C".equals(manuEntryObj.getString("planstatus"))) continue block0;
                errors.append(String.format(ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5355%s\u884c\u8ba1\u5212\u72b6\u6001\u4e0d\u4e3a\u4e0b\u8fbe\u3002", (String)"CheckManuOrderUtil_4", (String)"mmc-om-common", (Object[])new Object[0]), obj.get("billno"))).append(operationName).append("\u3002\n");
                continue block0;
            }
        }
        return errors;
    }

    public static void updateManuOrderEntryStatus(Object entryPk) {
        ORM orm = ORM.create();
        QFilter filter = new QFilter("treeentryentity.id", "=", entryPk);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection deptCol = orm.query("om_mftorder", "id", filters, "id");
        DynamicObject mftOrderObj = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)deptCol.get(0)).getPkValue(), (String)"om_mftorder");
        for (int i = 0; i < mftOrderObj.getDynamicObjectCollection("treeentryentity").size(); ++i) {
            DynamicObject entryObj = (DynamicObject)mftOrderObj.getDynamicObjectCollection("treeentryentity").get(i);
            ArrayList<DynamicObject> subEntryObjs = new ArrayList<DynamicObject>();
            for (int j = 0; j < mftOrderObj.getDynamicObjectCollection("treeentryentity").size(); ++j) {
                if (!entryObj.getPkValue().toString().equals(((DynamicObject)mftOrderObj.getDynamicObjectCollection("treeentryentity").get(j)).get("pid").toString())) continue;
                subEntryObjs.add((DynamicObject)mftOrderObj.getDynamicObjectCollection("treeentryentity").get(j));
            }
            if (!entryPk.equals(entryObj.getPkValue())) continue;
            filter = new QFilter("mftentryseq.id", "=", entryPk);
            QFilter filter1 = new QFilter("billstatus", "=", (Object)"C");
            filters = new QFilter[]{filter, filter1};
            deptCol = CheckManuOrderUtil.queryManftech(orm, filters);
            boolean flag = false;
            boolean flag1 = false;
            boolean flag2 = false;
            boolean isUpdate = false;
            for (int j = 0; j < deptCol.size(); ++j) {
                DynamicObject technicsObj = (DynamicObject)deptCol.get(j);
                for (int k = 0; k < technicsObj.getDynamicObjectCollection("oprentryentity").size(); ++k) {
                    DynamicObject technicsEntryObj = (DynamicObject)technicsObj.getDynamicObjectCollection("oprentryentity").get(k);
                    ArrayList<String> status = new ArrayList<String>(Arrays.asList("A", "B", "C", "D"));
                    if (status.contains(technicsEntryObj.getString("oprstatus"))) {
                        flag = true;
                    }
                    if ("E".contains(technicsEntryObj.getString("oprstatus"))) {
                        flag1 = true;
                    }
                    if (!(status = new ArrayList<String>(Arrays.asList("F", "G"))).contains(technicsEntryObj.getString("oprstatus"))) continue;
                    flag2 = true;
                }
            }
            if (flag) {
                if (flag1) {
                    if (flag2) {
                        if (!"D".equals(entryObj.getString("taskstatus"))) {
                            entryObj.set("taskstatus", (Object)"D");
                            CheckManuOrderUtil.updateSubEntryObjs(subEntryObjs, "D");
                            isUpdate = true;
                        }
                    } else if (!"B".equals(entryObj.getString("taskstatus"))) {
                        entryObj.set("taskstatus", (Object)"B");
                        CheckManuOrderUtil.updateSubEntryObjs(subEntryObjs, "B");
                        isUpdate = true;
                    }
                } else if (flag2) {
                    if (!"D".equals(entryObj.getString("taskstatus"))) {
                        entryObj.set("taskstatus", (Object)"D");
                        CheckManuOrderUtil.updateSubEntryObjs(subEntryObjs, "D");
                        isUpdate = true;
                    }
                } else if (!"A".equals(entryObj.getString("taskstatus"))) {
                    entryObj.set("taskstatus", (Object)"A");
                    CheckManuOrderUtil.updateSubEntryObjs(subEntryObjs, "A");
                    isUpdate = true;
                }
            } else if (flag1) {
                if (flag2) {
                    if (!"D".equals(entryObj.getString("taskstatus"))) {
                        entryObj.set("taskstatus", (Object)"D");
                        CheckManuOrderUtil.updateSubEntryObjs(subEntryObjs, "D");
                        isUpdate = true;
                    }
                } else if (!"B".equals(entryObj.getString("taskstatus"))) {
                    entryObj.set("taskstatus", (Object)"B");
                    CheckManuOrderUtil.updateSubEntryObjs(subEntryObjs, "B");
                    isUpdate = true;
                }
            } else if (flag2) {
                if (!"C".equals(entryObj.getString("taskstatus"))) {
                    entryObj.set("taskstatus", (Object)"C");
                    CheckManuOrderUtil.updateSubEntryObjs(subEntryObjs, "C");
                    isUpdate = true;
                }
            } else if (!"A".equals(entryObj.getString("taskstatus"))) {
                entryObj.set("taskstatus", (Object)"A");
                CheckManuOrderUtil.updateSubEntryObjs(subEntryObjs, "A");
                isUpdate = true;
            }
            if (!isUpdate) continue;
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mftOrderObj});
            DynamicObjectCollection entryEntity = mftOrderObj.getDynamicObjectCollection("treeentryentity");
            if (entryEntity.isEmpty()) continue;
            IDataEntityType dataEntityType = ((DynamicObject)entryEntity.get(0)).getDataEntityType();
            DataEntityCacheManager cacheManager = new DataEntityCacheManager(dataEntityType);
            cacheManager.removeByDt();
        }
    }

    public static void updateManuOrderEntryStatus2(String orderType, String status, String operateKey, Set<Object> entryPks, DynamicObject[] technicsBills) {
        QFilter filter = new QFilter("treeentryentity.id", "in", entryPks);
        Date date = new Date();
        DynamicObject[] mftOrders = BusinessDataServiceHelper.load((String)orderType, (String)"org,isinitbill,id,pid,taskstatus,producttype,startworktime,quainwaqty,unquainwaqty,scrinwaqty,baseqty", (QFilter[])new QFilter[]{filter});
        Map costSubOneDateMap = CostRelateHelper.getCostSubOneDateMap((DynamicObject[])mftOrders);
        for (int i = 0; i < mftOrders.length; ++i) {
            boolean isinitbill = mftOrders[i].containsProperty("isinitbill") && mftOrders[i].getBoolean("isinitbill");
            Long orgID = MpdmDyObjUtils.getDyObjId((Object)mftOrders[i].get("org"));
            for (int j = 0; j < mftOrders[i].getDynamicObjectCollection("treeentryentity").size(); ++j) {
                DynamicObject entryObj = (DynamicObject)mftOrders[i].getDynamicObjectCollection("treeentryentity").get(j);
                ArrayList<DynamicObject> subEntryObjs = new ArrayList<DynamicObject>();
                for (int k = 0; k < mftOrders[i].getDynamicObjectCollection("treeentryentity").size(); ++k) {
                    if (!entryObj.getPkValue().toString().equals(((DynamicObject)mftOrders[i].getDynamicObjectCollection("treeentryentity").get(k)).get("pid").toString())) continue;
                    subEntryObjs.add((DynamicObject)mftOrders[i].getDynamicObjectCollection("treeentryentity").get(k));
                }
                for (Object o : entryPks) {
                    boolean finish;
                    if (!o.equals(entryObj.getPkValue())) continue;
                    boolean start = operateKey.contains("start") && "E".equals(status) && !Arrays.asList(OPKEYS).contains(entryObj.getString("taskstatus"));
                    boolean bl = finish = operateKey.contains("finish") && "F".equals(status) && !Arrays.asList(OPKEYS).contains(entryObj.getString("taskstatus"));
                    if (start || finish) {
                        String taskStatus = "B";
                        if (isinitbill) {
                            date = (Date)costSubOneDateMap.get(orgID);
                            if (date == null) {
                                date = new Date();
                            }
                            taskStatus = CheckManuOrderUtil.getTaskStatus(entryObj);
                        }
                        entryObj.set("taskstatus", (Object)taskStatus);
                        if (null == entryObj.getDate("startworktime")) {
                            entryObj.set("startworktime", (Object)date);
                        }
                        CheckManuOrderUtil.updateSubEntryObjs(subEntryObjs, taskStatus, date);
                    }
                    if (!operateKey.contains("unrelease") && !operateKey.contains("unplan") && !operateKey.contains("unconfirm")) continue;
                    for (int k = 0; k < technicsBills.length; ++k) {
                        DynamicObjectCollection dynamicObjectCollection;
                        List collect;
                        if (!entryObj.getPkValue().equals(technicsBills[k].getDynamicObject("mftentryseq").getPkValue()) || (collect = (dynamicObjectCollection = technicsBills[k].getDynamicObjectCollection("oprentryentity")).stream().map(x -> x.getString("oprstatus")).collect(Collectors.toList())).contains("E") || collect.contains("F") || collect.contains("G")) continue;
                        entryObj.set("taskstatus", (Object)"A");
                        entryObj.set("startworktime", null);
                        CheckManuOrderUtil.updateSubEntryObjs(subEntryObjs, "A", null);
                    }
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])mftOrders);
    }

    private static void updateSubEntryObjs(List<DynamicObject> subEntryObjs, String value) {
        for (DynamicObject obj : subEntryObjs) {
            obj.set("taskstatus", (Object)value);
        }
    }

    private static void updateSubEntryObjs(List<DynamicObject> subEntryObjs, String value, Date date) {
        if (subEntryObjs == null || subEntryObjs.size() < 1) {
            return;
        }
        for (DynamicObject obj : subEntryObjs) {
            obj.set("taskstatus", (Object)value);
            if (null != obj.getDate("startworktime")) continue;
            obj.set("startworktime", (Object)date);
        }
    }

    private static DynamicObjectCollection queryManftech(ORM orm, QFilter[] filters) {
        DynamicObjectCollection deptCol = orm.query("om_mfttechnics", "id,billno,oprentryentity.id,oprentryentity.oprstatus", filters, "id");
        return deptCol;
    }

    private static String getTaskStatus(DynamicObject entry) {
        String taskStatus = "B";
        BigDecimal quainwaqty = entry.getBigDecimal("quainwaqty");
        BigDecimal unquainwaqty = entry.getBigDecimal("unquainwaqty");
        BigDecimal scrinwaqty = entry.getBigDecimal("scrinwaqty");
        BigDecimal baseqty = entry.getBigDecimal("baseqty");
        BigDecimal sum = quainwaqty.add(unquainwaqty).add(scrinwaqty);
        if (sum.compareTo(BigDecimal.ZERO) > 0 && sum.compareTo(baseqty) < 0) {
            taskStatus = ManuBillTaskStatusEnum.SOMEENDWORK.getValue();
        } else if (sum.compareTo(baseqty) >= 0) {
            taskStatus = ManuBillTaskStatusEnum.ENDWORK.getValue();
        }
        return taskStatus;
    }
}

